@echo off
rem  
rem This batch file contains a series of DOSKEY macros.  Each is explained
rem individually below.  To load these macros, you must include the line
rem      DOSKEY /bufsize=1024
rem in your AUTOEXEC.BAT file.  Then execute this batch file (MACROS.BAT)
rem to load your macros into memory.  You will also need to have two files
rem available in your current directory: YES and CR.
rem
rem The CLR macro.
rem   The CLR macro will reset your screen to 80 column color mode
rem and clear the screen.  This is useful if, after exiting a program,
rem you find your machine displaying large letters or garbage instead
rem of 80-column text.
doskey clr=mode co80 $GNUL
rem
rem The DIAL macro.
rem    This macro assumes that you have a 2400 baud modem attached to serial
rem port 2 (COM2).  If your modem is 1200 baud, change the number "2400" in
rem the macro definition to "1200".  If your modem is attached to serial
rem port 1, change the three references to "COM2" below to "COM1".  To dial
rem a number, type:
rem     DIAL number
rem Once the number has been dialed, press any key once the phone has begun
rem ringing and you have lifted the receiver off of the hook.  To wait for
rem a second dial tone (when dialing off post), insert the letter "W" in
rem between the numbers where you want the pause to occur.
doskey dial=mode COM2 2400 $GNUL $Techo ATDT $1; $GCOM2 $Tpause$Techo ATH $GCOM2
rem
rem The DSIZE macro.
rem    Similar to SPACE, DSIZE finds the total amount of space on a disk.
rem     DSIZE d:
rem reports the size of the disk in drive d: (use the appropriate letter
rem for the drive you are checking).
doskey dsize=chkdsk $1 $Bfind "total disk space"
rem
rem The DT macro.
rem    This macro will display the system date and time without prompting
rem you to enter a new value.
doskey dt=time $Lcr$Gtime1.txt$Tdate$Lcr$G$Gtime1.txt$Ttype time1.txt$Bfind "Cur"$Gtime2.txt$Ttype time2.txt
rem
rem The FAST macro.
rem    This macro will speed up the "typematic" rate on most AT keyboards.
doskey fast=mode con rate=30 delay=1
rem
rem The FF macro.
rem    This macro sends a form feed to your printer, ejecting the current
rem page.  This is the same as if you had pressed the form feed button on
rem your printer's console.
doskey ff=echo $Gprn >NUL
rem
rem The FFIND macro.
rem    This macro will find any file on the current disk.  Simply type
rem     FFIND filename
rem where filename is replaced by the name of the file you wish to locate.
rem Wildcards are OK.
doskey ffind=attrib \$1 /s b$Bmore
rem 
rem
rem The FRAG macro.
rem    This macro checks for fragmented files in the current directory.
rem     FRAG filespec
rem checks the current directory for files meeting the specification 
rem filespec that are fragmented (i.e., occupy non-contiguous disk clusters).
doskey frag=chkdsk $1 $Bfind "non"
rem
rem The GETBACK macro.
rem    This macro quickly UNDELETES a file without asking for confirmation
rem or the files first letter.  It does NOT require MIRROR to be loaded.  You
rem may not specify any wildcards in the file's name.
doskey getback=echo y$1 $Bundelete $1 /dos
rem
rem The HIDE macro.
rem    Use this macro to hide files.  You may hide files using the syntax:
rem     HIDE filespec [/s]
rem All files in the current directory meeting filespec will be hidden.  If
rem you add the optional /s switch, all files meeting filespec in the current
rem directory and all of its subdirectories will be hidden.
doskey hide=attrib +h $*
rem
rem The MACROS macro.
rem    This macro will display a list of all currently loaded DOSKEY macros.
doskey macros=doskey /macros $Bmore
rem
rem The MCD macro.
rem    Use this macro to create a directory and switch to that directory 
rem at the same time.  Syntax:
rem     MCD newdirname
doskey mcd=md $1 $Tcd $1
rem
rem The MOVE macro.
rem    This macro moves files from one place to another.  To move files, type:
rem     MOVE source destination
rem The file(s) specified by source will be copied to destination, and then
rem source will be deleted.
doskey move=xcopy $* $Tdel $1 $Lyes
rem
rem The NEWPATH macro.
rem    Use this macro to temporarily change the DOS path.  Syntax:
rem     NEWPATH newpath
rem Replace newpath with the directories you would like included in the
rem new path, separated by semi-colons.  To restore your previous path,
rem run the batch file RESETP.BAT which is created by NEWPATH.
doskey newpath=echo @echo off $Gresetp.bat $Tpath $G$Gresetp.bat $Tpath=$*
rem
rem The NORMAL macro.
rem    This macro will return the "typematic" rate of most AT keyboards
rem to its default rate.
doskey normal=mode con rate=20 delay=2
rem
rem The NUKE macro.
rem    This macro will remove an entire subdirectory, as well as any
rem files that are in it, WITHOUT any prompts.  This can be very dangerous,
rem so be careful!  It will not remove a directory that contains other
rem subdirectories, however.
doskey nuke=del $1 $Lyes $GNUL $Trd $1 $GNUL
rem
rem The PMEM macro.
rem    Use the PMEM macro to determine how much memory is being taken up by
rem a specific program.  Syntax:
rem     PMEM program
rem Type the "simple" name of the program (only the name you type to start
rem the program, not including an extension such as .COM, .EXE, or .BAT.
doskey pmem=mem /c$Bfind "$1" /i
rem
rem The SCRNSHFT macro.
rem    Use this macro to shift your screen to the left or right on your
rem monitor.  Specify the letter "L" or "R" after typing SCRNSHFT to
rem indicate a shift to the left or right.
doskey scrnshft=mode co80,$1,T
rem
rem The SLOW macro.
rem    This macro will slow down the "typematic" rate on most AT keyboards.
doskey slow=mode con rate=5 delay=4
rem
rem The SPACE macro.
rem    This macro will report the amount of available disk space.  Type
rem     SPACE d:
rem where d: is replaced by the letter of the drive you wish to check.
doskey space=dir $1 $Bfind "free"
rem
rem The UNHIDE macro.
rem    This macro accomplishes the opposite of HIDE; it unhides files.  The
rem syntax is the same as for the HIDE macro.
doskey unhide=attrib -h $*
rem
rem The UPDATE macro.
rem    To change the date and time stamp on a file, type:
rem     UPDATE filename
rem The date and time stamp on the file "filename" will be changed to the
rem current date and time.  Wildcards are not supported by this macro.
doskey update=copy /b $1 +,,$GNUL
rem
rem The MACDOCS macro.
rem    This macro prints the comments ("rem" lines) from the DOS5MACS.BAT file.
doskey macdocs=type dos5macs.bat $Bfind "rem" $Gprn
echo .
echo Type "MACDOCS" at the command line to print a copy of the documentation
echo for the DOS 5.00 macro set.