
    The INTERNET WIRETAP First Electronic Edition of

      A CONNECTICUT YANKEE IN KING ARTHUR'S COURT

                           by

                       MARK TWAIN
                   (Samuel L. Clemens)

    Copyright, 1889 and 1899, by SAMUEL L. CLEMENS
           This text is in the PUBLIC DOMAIN.

      From The Writings of Mark Twain Volume XVI
        Harper & Brothers Publishers, New York


    Electronic Edition by <dell@wiretap.spies.com>
           Released to the public June 1993


                        PREFACE

THE ungentle laws and customs touched upon in
this tale are historical, and the episodes which are
used to illustrate them are also historical. It is
not pretended that these laws and customs existed in
England in the sixth century; no, it is only pretended
that inasmuch as they existed in the English and other
civilizations of far later times, it is safe to consider that
it is no libel upon the sixth century to suppose them to
have been in practice in that day also. One is quite
justified in inferring that whatever one of these laws or
customs was lacking in that remote time, its place was
competently filled by a worse one.

The question as to whether there is such a thing as
divine right of kings is not settled in this book. It
was found too difficult. That the executive head of a
nation should be a person of lofty character and
extraordinary ability, was manifest and indisputable;
that none but the Deity could select that head unerr-
ingly, was also manifest and indisputable; that the
Deity ought to make that selection, then, was likewise
manifest and indisputable; consequently, that He does
make it, as claimed, was an unavoidable deduction. I
mean, until the author of this book encountered the
Pompadour, and Lady Castlemaine, and some other
executive heads of that kind; these were found so
difficult to work into the scheme, that it was judged
better to take the other tack in this book (which must
be issued this fall), and then go into training and
settle the question in another book. It is, of course,
a thing which ought to be settled, and I am not going
to have anything particular to do next winter anyway.

                                      MARK TWAIN.


             A CONNECTICUT YANKEE IN KING
                    ARTHUR'S COURT


A WORD OF EXPLANATION

IT was in Warwick Castle that I came across the
curious stranger whom I am going to talk about.
He attracted me by three things: his candid simplicity,
his marvelous familiarity with ancient armor, and the
restfulness of his company -- for he did all the talking.
We fell together, as modest people will, in the tail of
the herd that was being shown through, and he at once
began to say things which interested me. As he
talked along, softly, pleasantly, flowingly, he seemed
to drift away imperceptibly out of this world and time,
and into some remote era and old forgotten country;
and so he gradually wove such a spell about me that I
seemed to move among the specters and shadows and
dust and mold of a gray antiquity, holding speech with
a relic of it! Exactly as I would speak of my nearest
personal friends or enemies, or my most familiar
neighbors, he spoke of Sir Bedivere, Sir Bors de
Ganis, Sir Launcelot of the Lake, Sir Galahad, and all
the other great names of the Table Round -- and how
old, old, unspeakably old and faded and dry and
musty and ancient he came to look as he went on!
Presently he turned to me and said, just as one might
speak of the weather, or any other common matter --

"You know about transmigration of souls; do you
know about transposition of epochs -- and bodies?"

I said I had not heard of it. He was so little inter-
ested -- just as when people speak of the weather --
that he did not notice whether I made him any answer
or not. There was half a moment of silence, imme-
diately interrupted by the droning voice of the salaried
cicerone:

"Ancient hauberk, date of the sixth century, time
of King Arthur and the Round Table; said to have
belonged to the knight Sir Sagramor le Desirous; ob-
serve the round hole through the chain-mail in the left
breast; can't be accounted for; supposed to have been
done with a bullet since invention of firearms -- per-
haps maliciously by Cromwell's soldiers."

My acquaintance smiled -- not a modern smile, but
one that must have gone out of general use many, many
centuries ago -- and muttered apparently to himself:

"Wit ye well, I SAW IT DONE." Then, after a pause,
added: "I did it myself."

By the time I had recovered from the electric sur-
prise of this remark, he was gone.

All that evening I sat by my fire at the Warwick
Arms, steeped in a dream of the olden time, while the
rain beat upon the windows, and the wind roared about
the eaves and corners. From time to time I dipped
into old Sir Thomas Malory's enchanting book, and
fed at its rich feast of prodigies and adventures,
breathed in the fragrance of its obsolete names, and
dreamed again. Midnight being come at length, I read
another tale, for a nightcap -- this which here follows,
to wit:

   HOW SIR LAUNCELOT SLEW TWO GIANTS, AND MADE A
                    CASTLE FREE

   Anon withal came there upon him two great giants,
   well armed, all save the heads, with two horrible
   clubs in their hands. Sir Launcelot put his shield
   afore him, and put the stroke away of the one
   giant, and with his sword he clave his head asunder.
   When his fellow saw that, he ran away as he were
   wood [* demented], for fear of the horrible strokes,
   and Sir Launcelot after him with all his might,
   and smote him on the shoulder, and clave him to
   the middle. Then Sir Launcelot went into the hall,
   and there came afore him three score ladies and
   damsels, and all kneeled unto him, and thanked
   God and him of their deliverance. For, sir, said
   they, the most part of us have been here this
   seven year their prisoners, and we have worked all
   manner of silk works for our meat, and we are all
   great gentle-women born, and blessed be the time,
   knight, that ever thou wert born;for thou hast
   done the most worship that ever did knight in the
   world, that will we bear record, and we all pray
   you to tell us your name, that we may tell our
   friends who delivered us out of prison. Fair 
   damsels, he said, my name is Sir Launcelot du
   Lake. And so he departed from them and betaught
   them unto God. And then he mounted upon his
   horse, and rode into many strange and wild
   countries, and through many waters and valleys,
   and evil was he lodged. And at the last by
   fortune him happened against a night to come to
   a fair courtilage, and therein he found an old
   gentle-woman that lodged him with a good-will,
   and there he had good cheer for him and his horse.
   And when time was, his host brought him into a
   fair garret over the gate to his bed. There
   Sir Launcelot unarmed him, and set his harness
   by him, and went to bed, and anon he fell on
   sleep. So, soon after there came one on
   horseback, and knocked at the gate in great
   haste. And when Sir Launcelot heard this he rose
   up, and looked out at the window, and saw by the
   moonlight three knights come riding after that
   one man, and all three lashed on him at once
   with swords, and that one knight turned on them
   knightly again and defended him. Truly, said
   Sir Launcelot, yonder one knight shall I help,
   for it were shame for me to see three knights
   on one, and if he be slain I am partner of his
   death. And therewith he took his harness and
   went out at a window by a sheet down to the four
   knights, and then Sir Launcelot said on high,
   Turn you knights unto me, and leave your
   fighting with that knight. And then they all
   three left Sir Kay, and turned unto Sir Launcelot,
   and there began great battle, for they alight
   all three, and strake many strokes at Sir
   Launcelot, and assailed him on every side. Then
   Sir Kay dressed him for to have holpen Sir
   Launcelot. Nay, sir, said he, I will none of
   your help, therefore as ye will have my help
   let me alone with them. Sir Kay for the pleasure
   of the knight suffered him for to do his will,
   and so stood aside. And then anon within six
   strokes Sir Launcelot had stricken them to the
   earth.

   And then they all three cried, Sir Knight, we
   yield us unto you as man of might matchless. As
   to that, said Sir Launcelot, I will not take
   your yielding unto me, but so that ye yield
   you unto Sir Kay the seneschal, on that covenant
   I will save your lives and else not. Fair knight,
   said they, that were we loath to do; for as for
   Sir Kay we chased him hither, and had overcome
   him had ye not been; therefore, to yield us unto
   him it were no reason. Well, as to that, said
   Sir Launcelot, advise you well, for ye may
   choose whether ye will die or live, for an ye be
   yielden, it shall be unto Sir Kay. Fair knight,
   then they said, in saving our lives we will do
   as thou commandest us. Then shall ye, said Sir
   Launcelot, on Whitsunday next coming go unto the
   court of King Arthur, and there shall ye yield
   you unto Queen Guenever, and put you all three
   in her grace and mercy, and say that Sir Kay
   sent you thither to be her prisoners. On the morn
   Sir Launcelot arose early, and left Sir Kay
   sleeping; and Sir Launcelot took Sir Kay's armor
   and his shield and armed him, and so he went to
   the stable and took his horse, and took his leave
   of his host, and so he departed. Then soon after
   arose Sir Kay and missed Sir Launcelot; and
   then he espied that he had his armor and his
   horse. Now by my faith I know well that he will
   grieve some of the court of King Arthur; for on
   him knights will be bold, and deem that it is I,
   and that will beguile them; and because of his
   armor and shield I am sure I shall ride in peace.
   And then soon after departed Sir Kay, and
   thanked his host.

As I laid the book down there was a knock at the
door, and my stranger came in. I gave him a pipe
and a chair, and made him welcome. I also comforted
him with a hot Scotch whisky; gave him another one;
then still another -- hoping always for his story. After
a fourth persuader, he drifted into it himself, in a quite
simple and natural way:


THE STRANGER'S HISTORY

I am an American. I was born and reared in Hart-
ford, in the State of Connecticut -- anyway, just over
the river, in the country. So I am a Yankee of the
Yankees -- and practical; yes, and nearly barren of
sentiment, I suppose -- or poetry, in other words. My
father was a blacksmith, my uncle was a horse doctor,
and I was both, along at first. Then I went over to
the great arms factory and learned my real trade;
learned all there was to it; learned to make every-
thing: guns, revolvers, cannon, boilers, engines, all
sorts of labor-saving machinery. Why, I could make
anything a body wanted -- anything in the world, it
didn't make any difference what; and if there wasn't
any quick new-fangled way to make a thing, I could
invent one -- and do it as easy as rolling off a log. I
became head superintendent; had a couple of thou-
sand men under me.

Well, a man like that is a man that is full of fight --
that goes without saying. With a couple of thousand
rough men under one, one has plenty of that sort of
amusement. I had, anyway. At last I met my match,
and I got my dose. It was during a misunderstanding
conducted with crowbars with a fellow we used to call
Hercules. He laid me out with a crusher alongside
the head that made everything crack, and seemed to
spring every joint in my skull and made it overlap its
neighbor. Then the world went out in darkness, and
I didn't feel anything more, and didn't know anything
at all -- at least for a while.

When I came to again, I was sitting under an oak
tree, on the grass, with a whole beautiful and broad
country landscape all to myself -- nearly. Not en-
tirely; for there was a fellow on a horse, looking down
at me -- a fellow fresh out of a picture-book. He was
in old-time iron armor from head to heel, with a
helmet on his head the shape of a nail-keg with slits
in it; and he had a shield, and a sword, and a pro-
digious spear; and his horse had armor on, too, and a
steel horn projecting from his forehead, and gorgeous
red and green silk trappings that hung down all around
him like a bedquilt, nearly to the ground.

"Fair sir, will ye just?" said this fellow.

"Will I which?"

"Will ye try a passage of arms for land or lady or
for --"

"What are you giving me?" I said. "Get along
back to your circus, or I'll report you."

Now what does this man do but fall back a couple
of hundred yards and then come rushing at me as hard
as he could tear, with his nail-keg bent down nearly to
his horse's neck and his long spear pointed straight
ahead. I saw he meant business, so I was up the tree
when he arrived.

He allowed that I was his property, the captive of
his spear. There was argument on his side -- and the
bulk of the advantage -- so I judged it best to humor
him. We fixed up an agreement whereby I was to go
with him and he was not to hurt me. I came down,
and we started away, I walking by the side of his
horse. We marched comfortably along, through glades
and over brooks which I could not remember to have
seen before -- which puzzled me and made me wonder
-- and yet we did not come to any circus or sign of
a circus. So I gave up the idea of a circus, and con-
cluded he was from an asylum. But we never came to
an asylum -- so I was up a stump, as you may say. I
asked him how far we were from Hartford. He said
he had never heard of the place; which I took to be a
lie, but allowed it to go at that. At the end of an
hour we saw a far-away town sleeping in a valley by a
winding river; and beyond it on a hill, a vast gray
fortress, with towers and turrets, the first I had ever
seen out of a picture.

"Bridgeport?" said I, pointing.

"Camelot," said he.

My stranger had been showing signs of sleepiness.
He caught himself nodding, now, and smiled one of
those pathetic, obsolete smiles of his, and said:

"I find I can't go on; but come with me, I've got
it all written out, and you can read it if you like."

In his chamber, he said: "First, I kept a journal;
then by and by, after years, I took the journal and
turned it into a book. How long ago that was!"

He handed me his manuscript, and pointed out the
place where I should begin:

"Begin here -- I've already told you what goes be-
fore." He was steeped in drowsiness by this time.
As I went out at his door I heard him murmur sleep-
ily: "Give you good den, fair sir."

I sat down by my fire and examined my treasure.
The first part of it -- the great bulk of it -- was parch-
ment, and yellow with age. I scanned a leaf particu-
larly and saw that it was a palimpsest. Under the old
dim writing of the Yankee historian appeared traces of
a penmanship which was older and dimmer still --
Latin words and sentences: fragments from old monk-
ish legends, evidently. I turned to the place indicated
by my stranger and began to read -- as follows:



THE TALE OF THE LOST LAND.


CHAPTER I.
CAMELOT

"CAMELOT -- Camelot," said I to myself. "I
don't seem to remember hearing of it before.
Name of the asylum, likely."

It was a soft, reposeful summer landscape, as lovely
as a dream, and as lonesome as Sunday. The air was
full of the smell of flowers, and the buzzing of insects,
and the twittering of birds, and there were no people,
no wagons, there was no stir of life, nothing going on.
The road was mainly a winding path with hoof-prints
in it, and now and then a faint trace of wheels on
either side in the grass -- wheels that apparently had a
tire as broad as one's hand.

Presently a fair slip of a girl, about ten years old,
with a cataract of golden hair streaming down over her
shoulders, came along. Around her head she wore a
hoop of flame-red poppies. It was as sweet an outfit
as ever I saw, what there was of it. She walked indo-
lently along, with a mind at rest, its peace reflected in
her innocent face. The circus man paid no attention
to her; didn't even seem to see her. And she -- she
was no more startled at his fantastic make-up than if
she was used to his like every day of her life. She
was going by as indifferently as she might have gone
by a couple of cows; but when she happened to notice
me, THEN there was a change! Up went her hands,
and she was turned to stone; her mouth dropped
open, her eyes stared wide and timorously, she was
the picture of astonished curiosity touched with fear.
And there she stood gazing, in a sort of stupefied
fascination, till we turned a corner of the wood and
were lost to her view. That she should be startled at
me instead of at the other man, was too many for me;
I couldn't make head or tail of it . And that she
should seem to consider me a spectacle, and totally
overlook her own merits in that respect, was another
puzzling thing, and a display of magnanimity, too,
that was surprising in one so young. There was food
for thought here. I moved along as one in a dream.

As we approached the town, signs of life began to
appear. At intervals we passed a wretched cabin, with
a thatched roof, and about it small fields and garden
patches in an indifferent state of cultivation. There
were people, too; brawny men, with long, coarse, un-
combed hair that hung down over their faces and made
them look like animals. They and the women, as a
rule, wore a coarse tow-linen robe that came well below
the knee, and a rude sort of sandal, and many wore
an iron collar. The small boys and girls were always
naked; but nobody seemed to know it. All of these
people stared at me, talked about me, ran into the huts
and fetched out their families to gape at me; but no-
body ever noticed that other fellow, except to make
him humble salutation and get no response for their
pains.

In the town were some substantial windowless houses
of stone scattered among a wilderness of thatched
cabins; the streets were mere crooked alleys, and un-
paved; troops of dogs and nude children played in the
sun and made life and noise; hogs roamed and rooted
contentedly about, and one of them lay in a reeking
wallow in the middle of the main thoroughfare and
suckled her family. Presently there was a distant blare
of military music; it came nearer, still nearer, and
soon a noble cavalcade wound into view, glorious with
plumed helmets and flashing mail and flaunting banners
and rich doublets and horse-cloths and gilded spear-
heads; and through the muck and swine, and naked
brats, and joyous dogs, and shabby huts, it took its
gallant way, and in its wake we followed. Followed
through one winding alley and then another, -- and
climbing, always climbing -- till at last we gained the
breezy height where the huge castle stood. There was
an exchange of bugle blasts; then a parley from the
walls, where men-at-arms, in hauberk and morion,
marched back and forth with halberd at shoulder
under flapping banners with the rude figure of a dragon
displayed upon them; and then the great gates were
flung open, the drawbridge was lowered, and the head
of the cavalcade swept forward under the frowning
arches; and we, following, soon found ourselves in a
great paved court, with towers and turrets stretching
up into the blue air on all the four sides; and all about
us.the dismount was going on, and much greeting and
ceremony, and running to and fro, and a gay display
of moving and intermingling colors, and an altogether
pleasant stir and noise and confusion.


CHAPTER II.
KING ARTHUR'S COURT

THE moment I got a chance I slipped aside privately
and touched an ancient common looking man on
the shoulder and said, in an insinuating, confidential
way:

"Friend, do me a kindness. Do you belong to the
asylum, or are you just on a visit or something
like that?"

He looked me over stupidly, and said:

"Marry, fair sir, me seemeth --"

"That will do," I said; "I reckon you are a
patient."

I moved away, cogitating, and at the same time
keeping an eye out for any chance passenger in his
right mind that might come along and give me some
light. I judged I had found one, presently; so I
drew him aside and said in his ear:

"If I could see the head keeper a minute -- only
just a minute --"

"Prithee do not let me."

"Let you WHAT?"

"HINDER me, then, if the word please thee better.
Then he went on to say he was an under-cook and
could not stop to gossip, though he would like it
another time; for it would comfort his very liver to
know where I got my clothes. As he started away he
pointed and said yonder was one who was idle enough
for my purpose, and was seeking me besides, no
doubt. This was an airy slim boy in shrimp-colored
tights that made him look like a forked carrot, the
rest of his gear was blue silk and dainty laces and
ruffles; and he had long yellow curls, and wore a
plumed pink satin cap tilted complacently over his
ear. By his look, he was good-natured; by his gait,
he was satisfied with himself. He was pretty enough
to frame. He arrived, looked me over with a smiling
and impudent curiosity; said he had come for me, and
informed me that he was a page.

"Go 'long," I said; "you ain't more than a para-
graph."

It was pretty severe, but I was nettled. However,
it never phazed him; he didn't appear to know he was
hurt. He began to talk and laugh, in happy, thought-
less, boyish fashion, as we walked along, and made
himself old friends with me at once; asked me all sorts
of questions about myself and about my clothes, but
never waited for an answer -- always chattered straight
ahead, as if he didn't know he had asked a question
and wasn't expecting any reply, until at last he hap-
pened to mention that he was born in the beginning of
the year 513.

It made the cold chills creep over me! I stopped
and said, a little faintly:

"Maybe I didn't hear you just right. Say it again
-- and say it slow. What year was it?"

"513."

"513! You don't look it! Come, my boy, I am
a stranger and friendless; be honest and honorable
with me. Are you in your right mind?"

He said he was.

"Are these other people in their right minds?"

He said they were.

"And this isn't an asylum? I mean, it isn't a place
where they cure crazy people?"

He said it wasn't.

"Well, then," I said, "either I am a lunatic, or
something just as awful has happened. Now tell me,
honest and true, where am I?"

"IN KING ARTHUR'S COURT."

I waited a minute, to let that idea shudder its way
home, and then said:

"And according to your notions, what year is it now?"

"528 -- nineteenth of June."

I felt a mournful sinking at the heart, and muttered:
"I shall never see my friends again -- never, never
again. They will not be born for more than thirteen
hundred years yet."

I seemed to believe the boy, I didn't know why.
SOMETHING in me seemed to believe him -- my con-
sciousness, as you may say; but my reason didn't.
My reason straightway began to clamor; that was
natural. I didn't know how to go about satisfying it,
because I knew that the testimony of men wouldn't
serve -- my reason would say they were lunatics, and
throw out their evidence. But all of a sudden I stum-
bled on the very thing, just by luck. I knew that the
only total eclipse of the sun in the first half of the
sixth century occurred on the 21st of June, A. D. 528,
O.S., and began at 3 minutes after 12 noon. I also
knew that no total eclipse of the sun was due in what
to ME was the present year -- i.e., 1879. So, if I
could keep my anxiety and curiosity from eating the
heart out of me for forty-eight hours, I should then
find out for certain whether this boy was telling me the
truth or not.

Wherefore, being a practical Connecticut man, I now
shoved this whole problem clear out of my mind till its
appointed day and hour should come, in order that I
might turn all my attention to the circumstances of the
present moment, and be alert and ready to make the
most out of them that could be made. One thing at a
time, is my motto -- and just play that thing for all it
is worth, even if it's only two pair and a jack. I made
up my mind to two things: if it was still the nineteenth
century and I was among lunatics and couldn't get
away, I would presently boss that asylum or know the
reason why; and if, on the other hand, it was really
the sixth century, all right, I didn't want any softer
thing: I would boss the whole country inside of three
months; for I judged I would have the start of the
best-educated man in the kingdom by a matter of
thirteen hundred years and upward. I'm not a man
to waste time after my mind's made up and there's
work on hand; so I said to the page:

"Now, Clarence, my boy -- if that might happen to
be your name -- I'll get you to post me up a little if
you don't mind. What is the name of that apparition
that brought me here?"

"My master and thine? That is the good knight
and great lord Sir Kay the Seneschal, foster brother to
our liege the king."

"Very good; go on, tell me everything."

He made a long story of it; but the part that had
immediate interest for me was this: He said I was Sir
Kay's prisoner, and that in the due course of custom
I would be flung into a dungeon and left there on scant
commons until my friends ransomed me -- unless I
chanced to rot, first. I saw that the last chance had
the best show, but I didn't waste any bother about
that; time was too precious. The page said, further,
that dinner was about ended in the great hall by this
time, and that as soon as the sociability and the heavy
drinking should begin, Sir Kay would have me in and
exhibit me before King Arthur and his illustrious
knights seated at the Table Round, and would brag
about his exploit in capturing me, and would probably
exaggerate the facts a little, but it wouldn't be good
form for me to correct him, and not over safe, either;
and when I was done being exhibited, then ho for the
dungeon; but he, Clarence, would find a way to come
and see me every now and then, and cheer me up, and
help me get word to my friends.

Get word to my friends! I thanked him; I couldn't
do less; and about this time a lackey came to say I
was wanted; so Clarence led me in and took me off to
one side and sat down by me.

Well, it was a curious kind of spectacle, and interest-
ing. It was an immense place, and rather naked --
yes, and full of loud contrasts. It was very, very
lofty; so lofty that the banners depending from the
arched beams and girders away up there floated in a
sort of twilight; there was a stone-railed gallery at
each end, high up, with musicians in the one, and
women, clothed in stunning colors, in the other. The
floor was of big stone flags laid in black and white
squares, rather battered by age and use, and needing
repair. As to ornament, there wasn't any, strictly
speaking; though on the walls hung some huge tapes-
tries which were probably taxed as works of art;
battle-pieces, they were, with horses shaped like those
which children cut out of paper or create in ginger-
bread; with men on them in scale armor whose scales
are represented by round holes -- so that the man's
coat looks as if it had been done with a biscuit-punch.
There was a fireplace big enough to camp in; and its
projecting sides and hood, of carved and pillared
stonework, had the look of a cathedral door. Along
the walls stood men-at-arms, in breastplate and morion,
with halberds for their only weapon -- rigid as statues;
and that is what they looked like.

In the middle of this groined and vaulted public
square was an oaken table which they called the Table
Round. It was as large as a circus ring; and around
it sat a great company of men dressed in such various
and splendid colors that it hurt one's eyes to look at
them. They wore their plumed hats, right along, ex-
cept that whenever one addressed himself directly to
the king, he lifted his hat a trifle just as he was begin-
ning his remark.

Mainly they were drinking -- from entire ox horns;
but a few were still munching bread or gnawing beef
bones. There was about an average of two dogs to
one man; and these sat in expectant attitudes till a
spent bone was flung to them, and then they went for
it by brigades and divisions, with a rush, and there
ensued a fight which filled the prospect with a tumultu-
ous chaos of plunging heads and bodies and flashing
tails, and the storm of howlings and barkings deafened
all speech for the time; but that was no matter, for
the dog-fight was always a bigger interest anyway; the
men rose, sometimes, to observe it the better and bet
on it, and the ladies and the musicians stretched them-
selves out over their balusters with the same object;
and all broke into delighted ejaculations from time to
time. In the end, the winning dog stretched himself
out comfortably with his bone between his paws, and
proceeded to growl over it, and gnaw it, and grease
the floor with it, just as fifty others were already doing;
and the rest of the court resumed their previous indus-
tries and entertainments.

As a rule, the speech and behavior of these people
were gracious and courtly; and I noticed that they
were good and serious listeners when anybody was tell-
ing anything -- I mean in a dog-fightless interval. And
plainly, too, they were a childlike and innocent lot;
telling lies of the stateliest pattern with a most gentle
and winning naivety, and ready and willing to listen to
anybody else's lie, and believe it, too. It was hard to
associate them with anything cruel or dreadful; and
yet they dealt in tales of blood and suffering with a
guileless relish that made me almost forget to shudder.

I was not the only prisoner present. There were
twenty or more. Poor devils, many of them were
maimed, hacked, carved, in a frightful way; and their
hair, their faces, their clothing, were caked with black
and stiffened drenchings of blood. They were suffer-
ing sharp physical pain, of course; and weariness, and
hunger and thirst, no doubt; and at least none had
given them the comfort of a wash, or even the poor
charity of a lotion for their wounds; yet you never
heard them utter a moan or a groan, or saw them show
any sign of restlessness, or any disposition to com-
plain. The thought was forced upon me: "The ras-
cals -- THEY have served other people so in their day;
it being their own turn, now, they were not expecting
any better treatment than this; so their philosophical
bearing is not an outcome of mental training, intellec-
tual fortitude, reasoning; it is mere animal training;
they are white Indians."


CHAPTER III.
KNIGHTS OF THE TABLE ROUND

MAINLY the Round Table talk was monologues --
narrative accounts of the adventures in which
these prisoners were captured and their friends and
backers killed and stripped of their steeds and armor.
As a general thing -- as far as I could make out --
these murderous adventures were not forays undertaken
to avenge injuries, nor to settle old disputes or sudden
fallings out; no, as a rule they were simply duels be-
tween strangers -- duels between people who had never
even been introduced to each other, and between
whom existed no cause of offense whatever. Many a
time I had seen a couple of boys, strangers, meet by
chance, and say simultaneously, "I can lick you," and
go at it on the spot; but I had always imagined until
now that that sort of thing belonged to children only,
and was a sign and mark of childhood; but here were
these big boobies sticking to it and taking pride in it
clear up into full age and beyond. Yet there was some-
thing very engaging about these great simple-hearted
creatures, something attractive and lovable. There did
not seem to be brains enough in the entire nursery, so
to speak, to bait a fish-hook with; but you didn't seem
to mind that, after a little, because you soon saw that
brains were not needed in a society like that, and in-
deed would have marred it, hindered it, spoiled its sym-
metry -- perhaps rendered its existence impossible.

There was a fine manliness observable in almost every
face; and in some a certain loftiness and sweetness that
rebuked your belittling criticisms and stilled them. A
most noble benignity and purity reposed in the counte-
nance of him they called Sir Galahad, and likewise in the
king's also; and there was majesty and greatness in
the giant frame and high bearing of Sir Launcelot of
the Lake.

There was presently an incident which centered the
general interest upon this Sir Launcelot. At a sign
from a sort of master of ceremonies, six or eight of the
prisoners rose and came forward in a body and knelt
on the floor and lifted up their hands toward the ladies'
gallery and begged the grace of a word with the queen.
The most conspicuously situated lady in that massed
flower-bed of feminine show and finery inclined her
head by way of assent, and then the spokesman of the
prisoners delivered himself and his fellows into her
hands for free pardon, ransom, captivity, or death, as
she in her good pleasure might elect; and this, as he
said, he was doing by command of Sir Kay the Senes-
chal, whose prisoners they were, he having vanquished
them by his single might and prowess in sturdy conflict
in the field.

Surprise and astonishment flashed from face to face
all over the house; the queen's gratified smile faded
out at the name of Sir Kay, and she looked disap-
pointed; and the page whispered in my ear with an
accent and manner expressive of extravagant derision --

"Sir KAY, forsooth! Oh, call me pet names, dear-
est, call me a marine! In twice a thousand years shall
the unholy invention of man labor at odds to beget the
fellow to this majestic lie!"

Every eye was fastened with severe inquiry upon Sir
Kay. But he was equal to the occasion. He got up
and played his hand like a major -- and took every
trick. He said he would state the case exactly accord-
ing to the facts; he would tell the simple straightfor-
ward tale, without comment of his own; "and then,"
said he, "if ye find glory and honor due, ye will give
it unto him who is the mightiest man of his hands that
ever bare shield or strake with sword in the ranks of
Christian battle -- even him that sitteth there!" and he
pointed to Sir Launcelot. Ah, he fetched them; it
was a rattling good stroke. Then he went on and told
how Sir Launcelot, seeking adventures, some brief time
gone by, killed seven giants at one sweep of his sword,
and set a hundred and forty-two captive maidens free;
and then went further, still seeking adventures, and
found him (Sir Kay) fighting a desperate fight against
nine foreign knights, and straightway took the battle
solely into his own hands, and conquered the nine; and
that night Sir Launcelot rose quietly, and dressed him
in Sir Kay's armor and took Sir Kay's horse and gat
him away into distant lands, and vanquished sixteen
knights in one pitched battle and thirty-four in another;
and all these and the former nine he made to swear
that about Whitsuntide they would ride to Arthur's
court and yield them to Queen Guenever's hands as
captives of Sir Kay the Seneschal, spoil of his knightly
prowess; and now here were these half dozen, and the
rest would be along as soon as they might be healed of
their desperate wounds.

Well, it was touching to see the queen blush and
smile, and look embarrassed and happy, and fling fur-
tive glances at Sir Launcelot that would have got him
shot in Arkansas, to a dead certainty.

Everybody praised the valor and magnanimity of Sir
Launcelot; and as for me, I was perfectly amazed,
that one man, all by himself, should have been able to
beat down and capture such battalions of practiced
fighters. I said as much to Clarence; but this mock-
ing featherhead only said:

"An Sir Kay had had time to get another skin of
sour wine into him, ye had seen the accompt doubled."

I looked at the boy in sorrow; and as I looked I saw
the cloud of a deep despondency settle upon his counte-
nance. I followed the direction of his eye, and saw that
a very old and white-bearded man, clothed in a flowing
black gown, had risen and was standing at the table
upon unsteady legs, and feebly swaying his ancient
head and surveying the company with his watery and
wandering eye. The same suffering look that was in
the page's face was observable in all the faces around
-- the look of dumb creatures who know that they must
endure and make no moan.

"Marry, we shall have it a again," sighed the boy;
"that same old weary tale that he hath told a
thousand times in the same words, and that he WILL tell
till he dieth, every time he hath gotten his barrel full
and feeleth his exaggeration-mill a-working. Would
God I had died or I saw this day!"

"Who is it?"

"Merlin, the mighty liar and magician, perdition
singe him for the weariness he worketh with his one
tale! But that men fear him for that he hath the
storms and the lightnings and all the devils that be in
hell at his beck and call, they would have dug his en-
trails out these many years ago to get at that tale and
squelch it. He telleth it always in the third person,
making believe he is too modest to glorify himself --
maledictions light upon him, misfortune be his dole!
Good friend, prithee call me for evensong."

The boy nestled himself upon my shoulder and pre-
tended to go to sleep. The old man began his tale;
and presently the lad was asleep in reality; so also were
the dogs, and the court, the lackeys, and the files of
men-at-arms. The droning voice droned on; a soft
snoring arose on all sides and supported it like a deep
and subdued accompaniment of wind instruments.
Some heads were bowed upon folded arms, some lay
back with open mouths that issued unconscious music;
the flies buzzed and bit, unmolested, the rats swarmed
softly out from a hundred holes, and pattered about,
and made themselves at home everywhere; and one of
them sat up like a squirrel on the king's head and held
a bit of cheese in its hands and nibbled it, and dribbled
the crumbs in the king's face with naive and impudent
irreverence. It was a tranquil scene, and restful to the
weary eye and the jaded spirit.

This was the old man's tale. He said:

"Right so the king and Merlin departed, and went
until an hermit that was a good man and a great leech.
So the hermit searched all his wounds and gave him
good salves; so the king was there three days, and then
were his wounds well amended that he might ride and
go, and so departed. And as they rode, Arthur said,
I have no sword. No force *,  said Merlin, hereby is a
[* Footnote from M.T.: No matter.]
sword that shall be yours and I may. So they rode till
they came to a lake, the which was a fair water and
broad, and in the midst of the lake Arthur was ware of
an arm clothed in white samite, that held a fair sword
in that hand. Lo, said Merlin, yonder is that sword
that I spake of. With that they saw a damsel going
upon the lake. What damsel is that? said Arthur.
That is the Lady of the lake, said Merlin; and within
that lake is a rock, and therein is as fair a place as any
on earth, and richly beseen, and this damsel will come
to you anon, and then speak ye fair to her that she will
give you that sword. Anon withal came the damsel
unto Arthur and saluted him, and he her again.
Damsel, said Arthur, what sword is that, that yonder
the arm holdeth above the water? I would it were
mine, for I have no sword. Sir Arthur King, said the
damsel, that sword is mine, and if ye will give me a gift
when I ask it you, ye shall have it. By my faith, said
Arthur, I will give you what gift ye will ask. Well,
said the damsel, go ye into yonder barge and row your-
self to the sword, and take it and the scabbard with
you, and I will ask my gift when I see my time. So
Sir Arthur and Merlin alight, and tied their horses to
two trees, and so they went into the ship, and when
they came to the sword that the hand held, Sir Arthur
took it up by the handles, and took it with him. And
the arm and the hand went under the water; and so
they came unto the land and rode forth. And then Sir
Arthur saw a rich pavilion. What signifieth yonder
pavilion? It is the knight's pavilion, said Merlin,
that ye fought with last, Sir Pellinore, but he is
out, he is not there; he hath ado with a knight of
yours, that hight Egglame, and they have fought
together, but at the last Egglame fled, and else he had
been dead, and he hath chased him even to Carlion,
and we shall meet with him anon in the highway. That
is well said, said Arthur, now have I a sword, now will
I wage battle with him, and be avenged on him. Sir,
ye shall not so, said Merlin, for the knight is weary of
fighting and chasing, so that ye shall have no worship
to have ado with him; also, he will not lightly be
matched of one knight living; and therefore it is my
counsel, let him pass, for he shall do you good service
in short time, and his sons, after his days. Also ye
shall see that day in short space ye shall be right glad
to give him your sister to wed. When I see him, I will
do as ye advise me, said Arthur. Then Sir Arthur
looked on the sword, and liked it passing well.
Whether liketh you better, said Merlin, the sword or
the scabbard? Me liketh better the sword, said Arthur.
Ye are more unwise, said Merlin, for the scabbard is
worth ten of the sword, for while ye have the scabbard
upon you ye shall never lose no blood, be ye never so
sore wounded; therefore, keep well the scabbard always
with you. So they rode into Carlion, and by the way
they met with Sir Pellinore; but Merlin had done such
a craft that Pellinore saw not Arthur, and he passed by
without any words. I marvel, said Arthur, that the
knight would not speak. Sir, said Merlin, he saw you
not; for and he had seen you ye had not lightly de-
parted. So they came unto Carlion, whereof his
knights were passing glad. And when they heard of
his adventures they marveled that he would jeopard his
person so alone. But all men of worship said it was
merry to be under such a chieftain that would put his
person in adventure as other poor knights did."


CHAPTER IV.
SIR DINADAN THE HUMORIST

IT seemed to me that this quaint lie was most simply
and beautifully told; but then I had heard it only
once, and that makes a difference; it was pleasant to
the others when it was fresh, no doubt.

Sir Dinadan the Humorist was the first to awake, and
he soon roused the rest with a practical joke of a suffi-
ciently poor quality. He tied some metal mugs to a
dog's tail and turned him loose, and he tore around and
around the place in a frenzy of fright, with all the other
dogs bellowing after him and battering and crashing
against everything that came in their way and making
altogether a chaos of confusion and a most deafening
din and turmoil; at which every man and woman of the
multitude laughed till the tears flowed, and some fell
out of their chairs and wallowed on the floor in ecstasy.
It was just like so many children. Sir Dinadan was so
proud of his exploit that he could not keep from telling
over and over again, to weariness, how the immortal
idea happened to occur to him; and as is the way with
humorists of his breed, he was still laughing at it after
everybody else had got through. He was so set up
that he concluded to make a speech -- of course a
humorous speech. I think I never heard so many old
played-out jokes strung together in my life. He was
worse than the minstrels, worse than the clown in the
circus. It seemed peculiarly sad to sit here, thirteen
hundred years before I was born, and listen again to
poor, flat, worm-eaten jokes that had given me the dry
gripes when I was a boy thirteen hundred years after-
wards. It about convinced me that there isn't any such
thing as a new joke possible. Everybody laughed at
these antiquities -- but then they always do; I had
noticed that, centuries later. However, of course the
scoffer didn't laugh -- I mean the boy. No, he scoffed;
there wasn't anything he wouldn't scoff at. He said
the most of Sir Dinadan's jokes were rotten and the rest
were petrified. I said "petrified" was good; as I be-
lieved, myself, that the only right way to classify the
majestic ages of some of those jokes was by geologic
periods. But that neat idea hit the boy in a blank
place, for geology hadn't been invented yet. However,
I made a note of the remark, and calculated to educate
the commonwealth up to it if I pulled through. It is
no use to throw a good thing away merely because the
market isn't ripe yet.

Now Sir Kay arose and began to fire up on his his-
tory-mill with me for fuel. It was time for me to feel
serious, and I did. Sir Kay told how he had en-
countered me in a far land of barbarians, who all wore
the same ridiculous garb that I did -- a garb that was a
work of enchantment, and intended to make the wearer
secure from hurt by human hands. However he had
nullified the force of the enchantment by prayer, and
had killed my thirteen knights in a three hours' battle,
and taken me prisoner, sparing my life in order that so
strange a curiosity as I was might be exhibited to the
wonder and admiration of the king and the court. He
spoke of me all the time, in the blandest way, as "this
prodigious giant," and "this horrible sky-towering
monster," and "this tusked and taloned man-devour-
ing ogre", and everybody took in all this bosh in the
naivest way, and never smiled or seemed to notice that
there was any discrepancy between these watered statis-
tics and me. He said that in trying to escape from him
I sprang into the top of a tree two hundred cubits high
at a single bound, but he dislodged me with a stone the
size of a cow, which "all-to brast" the most of my
bones, and then swore me to appear at Arthur's court
for sentence. He ended by condemning me to die at
noon on the 21st; and was so little concerned about it
that he stopped to yawn before he named the date.

I was in a dismal state by this time; indeed, I was
hardly enough in my right mind to keep the run of a
dispute that sprung up as to how I had better be killed,
the possibility of the killing being doubted by some,
because of the enchantment in my clothes. And yet it
was nothing but an ordinary suit of fifteen-dollar slop-
shops. Still, I was sane enough to notice this detail,
to wit: many of the terms used in the most matter-of-
fact way by this great assemblage of the first ladies and
gentlemen in the land would have made a Comanche
blush. Indelicacy is too mild a term to convey the
idea. However, I had read "Tom Jones," and "Rod-
erick Random," and other books of that kind, and
knew that the highest and first ladies and gentlemen in
England had remained little or no cleaner in their talk,
and in the morals and conduct which such talk implies,
clear up to a hundred years ago; in fact clear into our
own nineteenth century -- in which century, broadly
speaking, the earliest samples of the real lady and real
gentleman discoverable in English history -- or in
European history, for that matter -- may be said to
have made their appearance. Suppose Sir Walter, in-
stead of putting the conversations into the mouths of
his characters, had allowed the characters to speak for
themselves? We should have had talk from Rebecca
and Ivanhoe and the soft lady Rowena which would
embarrass a tramp in our day. However, to the uncon-
sciously indelicate all things are delicate. King Ar-
thur's people were not aware that they were indecent
and I had presence of mind enough not to mention it.

They were so troubled about my enchanted clothes
that they were mightily relieved, at last, when old
Merlin swept the difficulty away for them with a com-
mon-sense hint. He asked them why they were so dull
-- why didn't it occur to them to strip me. In half a
minute I was as naked as a pair of tongs! And dear,
dear, to think of it: I was the only embarrassed person
there. Everybody discussed me; and did it as uncon-
cernedly as if I had been a cabbage. Queen Guenever
was as naively interested as the rest, and said she had
never seen anybody with legs just like mine before. It
was the only compliment I got -- if it was a compliment.

Finally I was carried off in one direction, and my
perilous clothes in another. I was shoved into a dark
and narrow cell in a dungeon, with some scant remnants
for dinner, some moldy straw for a bed, and no end
of rats for company.


CHAPTER V.
AN INSPIRATION

I WAS so tired that even my fears were not able to
keep me awake long.

When I next came to myself, I seemed to have been
asleep a very long time. My first thought was, "Well,
what an astonishing dream I've had! I reckon I've
waked only just in time to keep from being hanged or
drowned or burned or something.... I'll nap
again till the whistle blows, and then I'll go down to
the arms factory and have it out with Hercules."

But just then I heard the harsh music of rusty chains
and bolts, a light flashed in my eyes, and that butterfly,
Clarence, stood before me! I gasped with surprise;
my breath almost got away from me.

"What!" I said, "you here yet? Go along with
the rest of the dream! scatter!"

But he only laughed, in his light-hearted way, and
fell to making fun of my sorry plight.

"All right," I said resignedly, "let the dream go
on; I'm in no hurry."

"Prithee what dream?"

"What dream? Why, the dream that I am in
Arthur's court -- a person who never existed; and that
I am talking to you, who are nothing but a work of the
imagination."

"Oh, la, indeed! and is it a dream that you're to be
burned to-morrow? Ho-ho -- answer me that!"

The shock that went through me was distressing. I
now began to reason that my situation was in the last
degree serious, dream or no dream; for I knew by past
experience of the lifelike intensity of dreams, that to
be burned to death, even in a dream, would be very far
from being a jest, and was a thing to be avoided, by
any means, fair or foul, that I could contrive. So I
said beseechingly:

"Ah, Clarence, good boy, only friend I've got, --
for you ARE my friend, aren't you? -- don't fail me; help
me to devise some way of escaping from this place!"

"Now do but hear thyself! Escape? Why, man,
the corridors are in guard and keep of men-at-arms."

"No doubt, no doubt. But how many, Clarence?
Not many, I hope?"

"Full a score. One may not hope to escape."
After a pause -- hesitatingly: "and there be other rea-
sons -- and weightier."

"Other ones? What are they?"

"Well, they say -- oh, but I daren't, indeed
daren't!"

"Why, poor lad, what is the matter? Why do you
blench? Why do you tremble so?"

"Oh, in sooth, there is need! I do want to tell you,
but --"

"Come, come, be brave, be a man -- speak out,
there's a good lad!"

He hesitated, pulled one way by desire, the other
way by fear; then he stole to the door and peeped out,
listening; and finally crept close to me and put his
mouth to my ear and told me his fearful news in a
whisper, and with all the cowering apprehension of one
who was venturing upon awful ground and speaking of
things whose very mention might be freighted with
death.

"Merlin, in his malice, has woven a spell about this
dungeon, and there bides not the man in these king-
doms that would be desperate enough to essay to cross
its lines with you! Now God pity me, I have told it!
Ah, be kind to me, be merciful to a poor boy who
means thee well; for an thou betray me I am lost!"

I laughed the only really refreshing laugh I had had
for some time; and shouted:

"Merlin has wrought a spell! MERLIN, forsooth!
That cheap old humbug, that maundering old ass?
Bosh, pure bosh, the silliest bosh in the world! Why,
it does seem to me that of all the childish, idiotic,
chuckle-headed, chicken-livered superstitions that
ev -- oh, damn Merlin!"

But Clarence had slumped to his knees before I had
half finished, and he was like to go out of his mind
with fright.

"Oh, beware! These are awful words! Any
moment these walls may crumble upon us if you say
such things. Oh call them back before it is too late!"

Now this strange exhibition gave me a good idea and
set me to thinking. If everybody about here was so
honestly and sincerely afraid of Merlin's pretended
magic as Clarence was, certainly a superior man like
me ought to be shrewd enough to contrive some way
to take advantage of such a state of things. I went
on thinking, and worked out a plan. Then I said:

"Get up. Pull yourself together; look me in the
eye. Do you know why I laughed?"

"No -- but for our blessed Lady's sake, do it no
more."

"Well, I'll tell you why I laughed. Because I'm a
magician myself."

"Thou!" The boy recoiled a step, and caught his
breath, for the thing hit him rather sudden; but the
aspect which he took on was very, very respectful. I
took quick note of that; it indicated that a humbug
didn't need to have a reputation in this asylum; people
stood ready to take him at his word, without that. I
resumed.

"I've know Merlin seven hundred years, and he --"

"Seven hun --"

"Don't interrupt me. He has died and come alive
again thirteen times, and traveled under a new name
every time: Smith, Jones, Robinson, Jackson, Peters,
Haskins, Merlin -- a new alias every time he turns up.
I knew him in Egypt three hundred years ago; I knew
him in India five hundred years ago -- he is always
blethering around in my way, everywhere I go; he
makes me tired. He don't amount to shucks, as a
magician; knows some of the old common tricks,
but has never got beyond the rudiments, and never
will. He is well enough for the provinces-- one-night
stands and that sort of thing, you know -- but dear me,
HE oughtn't to set up for an expert -- anyway not
where there's a real artist. Now look here, Clarence,
I am going to stand your friend, right along, and in re-
turn you must be mine. I want you to do me a favor.
I want you to get word to the king that I am a magician
myself -- and the Supreme Grand High-yu-Muck-
amuck and head of the tribe, at that; and I want him
to be made to understand that I am just quietly arrang-
ing a little calamity here that will make the fur fly in these
realms if Sir Kay's project is carried out and any harm
comes to me. Will you get that to the king for me?"

The poor boy was in such a state that he could
hardly answer me. It was pitiful to see a creature so
terrified, so unnerved, so demoralized. But he prom-
ised everything; and on my side he made me promise
over and over again that I would remain his friend, and
never turn against him or cast any enchantments upon
him. Then he worked his way out, staying himself
with his hand along the wall, like a sick person.

Presently this thought occurred to me: how heed-
less I have been! When the boy gets calm, he will
wonder why a great magician like me should have
begged a boy like him to help me get out of this place;
he will put this and that together, and will see that I
am a humbug.

I worried over that heedless blunder for an hour,
and called myself a great many hard names, meantime.
But finally it occurred to me all of a sudden that these
animals didn't reason; that THEY never put this and
that together; that all their talk showed that they
didn't know a discrepancy when they saw it. I was at
rest, then.

But as soon as one is at rest, in this world, off he goes
on something else to worry about. It occurred to me
that I had made another blunder: I had sent the boy
off to alarm his betters with a threat -- I intending to
invent a calamity at my leisure; now the people who are
the readiest and eagerest and willingest to swallow
miracles are the very ones who are hungriest to see you
perform them; suppose I should be called on for a
sample? Suppose I should be asked to name my
calamity? Yes, I had made a blunder; I ought to
have invented my calamity first. "What shall I do?
what can I say, to gain a little time?" I was in trouble
again; in the deepest kind of trouble:...
"There's a footstep! -- they're coming. If I had only
just a moment to think.... Good, I've got it.
I'm all right."

You see, it was the eclipse. It came into my mind
in the nick of time, how Columbus, or Cortez, or one
of those people, played an eclipse as a saving trump
once, on some savages, and I saw my chance. I could
play it myself, now, and it wouldn't be any plagiarism,
either, because I should get it in nearly a thousand
years ahead of those parties.

Clarence came in, subdued, distressed, and said:

"I hasted the message to our liege the king, and
straightway he had me to his presence. He was
frighted even to the marrow, and was minded to give
order for your instant enlargement, and that you be
clothed in fine raiment and lodged as befitted one so
great; but then came Merlin and spoiled all; for he
persuaded the king that you are mad, and know not
whereof you speak; and said your threat is but foolish-
ness and idle vaporing. They disputed long, but in the
end, Merlin, scoffing, said, 'Wherefore hath he not
NAMED his brave calamity? Verily it is because he can-
not.' This thrust did in a most sudden sort close the
king's mouth, and he could offer naught to turn the
argument; and so, reluctant, and full loth to do you
the discourtesy, he yet prayeth you to consider his per-
plexed case, as noting how the matter stands, and name
the calamity -- if so be you have determined the nature
of it and the time of its coming. Oh, prithee delay
not; to delay at such a time were to double and treble
the perils that already compass thee about. Oh, be
thou wise -- name the calamity!"

I allowed silence to accumulate while I got my im-
pressiveness together, and then said:

"How long have I been shut up in this hole?"

"Ye were shut up when yesterday was well spent
It is 9 of the morning now."

"No! Then I have slept well, sure enough. Nine
in the morning now! And yet it is the very complex-
ion of midnight, to a shade. This is the 20th, then?"

"The 20th -- yes."

"And I am to be burned alive to-morrow." The
boy shuddered.

"At what hour?"

"At high noon."

"Now then, I will tell you what to say." I paused,
and stood over that cowering lad a whole minute in
awful silence; then, in a voice deep, measured,
charged with doom, I began, and rose by dramatically
graded stages to my colossal climax, which I delivered
in as sublime and noble a way as ever I did such a
thing in my life: "Go back and tell the king that at
that hour I will smother the whole world in the dead
blackness of midnight; I will blot out the sun, and he
shall never shine again; the fruits of the earth shall
rot for lack of light and warmth, and the peoples of the
earth shall famish and die, to the last man!"

I had to carry the boy out myself, he sunk into such
a collapse. I handed him over to the soldiers, and
went back.


CHAPTER VI.
THE ECLIPSE

IN the stillness and the darkness, realization soon
began to supplement knowledge. The mere knowl-
edge of a fact is pale; but when you come to REALIZE
your fact, it takes on color. It is all the difference be-
tween hearing of a man being stabbed to the heart, and
seeing it done. In the stillness and the darkness, the
knowledge that I was in deadly danger took to itself
deeper and deeper meaning all the time; a something
which was realization crept inch by inch through my
veins and turned me cold.

But it is a blessed provision of nature that at times
like these, as soon as a man's mercury has got down to
a certain point there comes a revulsion, and he rallies.
Hope springs up, and cheerfulness along with it, and
then he is in good shape to do something for himself,
if anything can be done. When my rally came, it
came with a bound. I said to myself that my eclipse
would be sure to save me, and make me the greatest
man in the kingdom besides; and straightway my
mercury went up to the top of the tube, and my solici-
tudes all vanished. I was as happy a man as there
was in the world. I was even impatient for to-
morrow to come, I so wanted to gather in that great
triumph and be the center of all the nation's wonder
and reverence. Besides, in a business way it would be
the making of me; I knew that.

Meantime there was one thing which had got pushed
into the background of my mind. That was the half-
conviction that when the nature of my proposed
calamity should be reported to those superstitious
people, it would have such an effect that they would
want to compromise. So, by and by when I heard
footsteps coming, that thought was recalled to me, and
I said to myself, "As sure as anything, it's the com-
promise. Well, if it is good, all right, I will accept;
but if it isn't, I mean to stand my ground and play my
hand for all it is worth."

The door opened, and some men-at-arms appeared.
The leader said:

"The stake is ready. Come!"

The stake! The strength went out of me, and I
almost fell down. It is hard to get one's breath at
such a time, such lumps come into one's throat, and
such gaspings; but as soon as I could speak, I said:

"But this is a mistake -- the execution is to-
morrow."

"Order changed; been set forward a day. Haste
thee!"

I was lost. There was no help for me. I was
dazed, stupefied; I had no command over myself, I
only wandered purposely about, like one out of his
mind; so the soldiers took hold of me, and pulled me
along with them, out of the cell and along the maze of
underground corridors, and finally into the fierce glare
of daylight and the upper world. As we stepped into
the vast enclosed court of the castle I got a shock;
for the first thing I saw was the stake, standing in the
center, and near it the piled fagots and a monk. On
all four sides of the court the seated multitudes rose
rank above rank, forming sloping terraces that were
rich with color. The king and the queen sat in their
thrones, the most conspicuous figures there, of course.

To note all this, occupied but a second. The next
second Clarence had slipped from some place of con-
cealment and was pouring news into my ear, his eyes
beaming with triumph and gladness. He said:

"'Tis through ME the change was wrought! And
main hard have I worked to do it, too. But when I
revealed to them the calamity in store, and saw how
mighty was the terror it did engender, then saw I also
that this was the time to strike! Wherefore I diligently
pretended, unto this and that and the other one, that
your power against the sun could not reach its full
until the morrow; and so if any would save the sun
and the world, you must be slain to-day, while your
enchantments are but in the weaving and lack potency.
Odsbodikins, it was but a dull lie, a most indifferent
invention, but you should have seen them seize it and
swallow it, in the frenzy of their fright, as it were sal-
vation sent from heaven; and all the while was I
laughing in my sleeve the one moment, to see them so
cheaply deceived, and glorifying God the next, that
He was content to let the meanest of His creatures be
His instrument to the saving of thy life. Ah how
happy has the matter sped! You will not need to do
the sun a REAL hurt -- ah, forget not that, on your soul
forget it not! Only make a little darkness -- only the
littlest little darkness, mind, and cease with that. It
will be sufficient. They will see that I spoke falsely, --
being ignorant, as they will fancy -- and with the fall-
ing of the first shadow of that darkness you shall see
them go mad with fear; and they will set you free and
make you great! Go to thy triumph, now! But re-
member -- ah, good friend, I implore thee remember
my supplication, and do the blessed sun no hurt. For
MY sake, thy true friend."

I choked out some words through my grief and
misery; as much as to say I would spare the sun; for
which the lad's eyes paid me back with such deep and
loving gratitude that I had not the heart to tell him his
good-hearted foolishness had ruined me and sent me
to my death.

As the soldiers assisted me across the court the still-
ness was so profound that if I had been blindfold I
should have supposed I was in a solitude instead of
walled in by four thousand people. There was not a
movement perceptible in those masses of humanity;
they were as rigid as stone images, and as pale; and
dread sat upon every countenance. This hush con-
tinued while I was being chained to the stake; it still
continued while the fagots were carefully and tediously
piled about my ankles, my knees, my thighs, my body.
Then there was a pause, and a deeper hush, if possible,
and a man knelt down at my feet with a blazing torch;
the multitude strained forward, gazing, and parting
slightly from their seats without knowing it; the monk
raised his hands above my head, and his eyes toward
the blue sky, and began some words in Latin; in this
attitude he droned on and on, a little while, and then
stopped. I waited two or three moments; then looked
up; he was standing there petrified. With a common
impulse the multitude rose slowly up and stared into
the sky. I followed their eyes, as sure as guns, there
was my eclipse beginning! The life went boiling
through my veins; I was a new man! The rim of
black spread slowly into the sun's disk, my heart beat
higher and higher, and still the assemblage and the
priest stared into the sky, motionless. I knew that
this gaze would be turned upon me, next. When it
was, l was ready. I was in one of the most grand
attitudes I ever struck, with my arm stretched up
pointing to the sun. It was a noble effect. You
could SEE the shudder sweep the mass like a wave.
Two shouts rang out, one close upon the heels of the
other:

"Apply the torch!"

"I forbid it!"

The one was from Merlin, the other from the king.
Merlin started from his place -- to apply the torch
himself, I judged. I said:

"Stay where you are. If any man moves -- even
the king -- before I give him leave, I will blast him
with thunder, I will consume him with lightnings!"

The multitude sank meekly into their seats, and I was
just expecting they would. Merlin hesitated a moment
or two, and I was on pins and needles during that little
while. Then he sat down, and I took a good breath;
for I knew I was master of the situation now. The
king said:

"Be merciful, fair sir, and essay no further in this
perilous matter, lest disaster follow. It was reported
to us that your powers could not attain unto their full
strength until the morrow; but --"

"Your Majesty thinks the report may have been a
lie? It WAS a lie."

That made an immense effect; up went appealing
hands everywhere, and the king was assailed with a
storm of supplications that I might be bought off at
any price, and the calamity stayed. The king was
eager to comply. He said:

"Name any terms, reverend sir, even to the halving
of my kingdom; but banish this calamity, spare the
sun!"

My fortune was made. I would have taken him up
in a minute, but I couldn't stop an eclipse; the thing
was out of the question. So I asked time to consider.
The king said:

"How long -- ah, how long, good sir? Be merci-
ful; look, it groweth darker, moment by moment.
Prithee how long?"

"Not long. Half an hour -- maybe an hour."

There were a thousand pathetic protests, but I
couldn't shorten up any, for I couldn't remember
how long a total eclipse lasts. I was in a puzzled con-
dition, anyway, and wanted to think. Something was
wrong about that eclipse, and the fact was very un-
settling. If this wasn't the one I was after, how was
I to tell whether this was the sixth century, or nothing
but a dream? Dear me, if I could only prove it was
the latter! Here was a glad new hope. If the boy
was right about the date, and this was surely the 20th,
it WASN'T the sixth century. I reached for the monk's
sleeve, in considerable excitement, and asked him what
day of the month it was.

Hang him, he said it was the TWENTY-FIRST! It made
me turn cold to hear him. I begged him not to make
any mistake about it; but he was sure; he knew it
was the 21st. So, that feather-headed boy had botched
things again! The time of the day was right for the
eclipse; I had seen that for myself, in the beginning,
by the dial that was near by. Yes, I was in King
Arthur's court, and I might as well make the most out
of it I could.

The darkness was steadily growing, the people be-
coming more and more distressed. I now said:

"I have reflected, Sir King. For a lesson, I will
let this darkness proceed, and spread night in the
world; but whether I blot out the sun for good, or
restore it, shall rest with you. These are the terms, to
wit: You shall remain king over all your dominions,
and receive all the glories and honors that belong to
the kingship; but you shall appoint me your perpetual
minister and executive, and give me for my services
one per cent. of such actual increase of revenue over
and above its present amount as I may succeed in
creating for the state. If I can't live on that, I sha'n't
ask anybody to give me a lift. Is it satisfactory?"

There was a prodigious roar of applause, and out of
the midst of it the king's voice rose, saying:

"Away with his bonds, and set him free! and do
him homage, high and low, rich and poor, for he is
become the king's right hand, is clothed with power
and authority, and his seat is upon the highest step of
the throne! Now sweep away this creeping night, and
bring the light and cheer again, that all the world may
bless thee."

But I said:

"That a common man should be shamed before
the world, is nothing; but it were dishonor to the KING
if any that saw his minister naked should not also see
him delivered from his shame. If I might ask that my
clothes be brought again --"

"They are not meet," the king broke in. "Fetch
raiment of another sort; clothe him like a prince!"

My idea worked. I wanted to keep things as they
were till the eclipse was total, otherwise they would be
trying again to get me to dismiss the darkness, and of
course I couldn't do it. Sending for the clothes
gained some delay, but not enough. So I had to
make another excuse. I said it would be but natural
if the king should change his mind and repent to some
extent of what he had done under excitement; there-
fore I would let the darkness grow a while, and if at
the end of a reasonable time the king had kept his
mind the same, the darkness should be dismissed.
Neither the king nor anybody else was satisfied with
that arrangement, but I had to stick to my point.

It grew darker and darker and blacker and blacker,
while I struggled with those awkward sixth-century
clothes. It got to be pitch dark, at last, and the
multitude groaned with horror to feel the cold uncanny
night breezes fan through the place and see the stars
come out and twinkle in the sky. At last the eclipse
was total, and I was very glad of it, but everybody
else was in misery; which was quite natural. I said:

"The king, by his silence, still stands to the terms."
Then I lifted up my hands -- stood just so a moment --
then I said, with the most awful solemnity: "Let the
enchantment dissolve and pass harmless away!"

There was no response, for a moment, in that deep
darkness and that graveyard hush. But when the
silver rim of the sun pushed itself out, a moment or
two later, the assemblage broke loose with a vast shout
and came pouring down like a deluge to smother me
with blessings and gratitude; and Clarence was not the
last of the wash, to be sure.


CHAPTER VII.
MERLIN'S TOWER

INASMUCH as I was now the second personage in
the Kingdom, as far as political power and author-
ty were concerned, much was made of me. My
raiment was of silks and velvets and cloth of gold,
and by consequence was very showy, also uncomfort-
able. But habit would soon reconcile me to my clothes;
I was aware of that. I was given the choicest suite of
apartments in the castle, after the king's. They were
aglow with loud-colored silken hangings, but the stone
floors had nothing but rushes on them for a carpet,
and they were misfit rushes at that, being not all of
one breed. As for conveniences, properly speaking,
there weren't any. I mean LITTLE conveniences; it is
the little conveniences that make the real comfort of
life. The big oaken chairs, graced with rude carvings,
were well enough, but that was the stopping place.
There was no soap, no matches, no looking-glass -- ex-
cept a metal one, about as powerful as a pail of water.
And not a chromo. I had been used to chromos for
years, and I saw now that without my suspecting it a
passion for art had got worked into the fabric of my
being, and was become a part of me. It made me
homesick to look around over this proud and gaudy
but heartless barrenness and remember that in our house
in East Hartford, all unpretending as it was, you couldn't
go into a room but you would find an insurance-chromo,
or at least a three-color God-Bless-Our-Home over the
door; and in the parlor we had nine. But here, even
in my grand room of state, there wasn't anything in
the nature of a picture except a thing the size of a
bedquilt, which was either woven or knitted (it had
darned places in it), and nothing in it was the right
color or the right shape; and as for proportions, even
Raphael himself couldn't have botched them more
formidably, after all his practice on those nightmares
they call his "celebrated Hampton Court cartoons."
Raphael was a bird. We had several of his chromos;
one was his "Miraculous Draught of Fishes," where
he puts in a miracle of his own -- puts three men into
a canoe which wouldn't have held a dog without up-
setting. I always admired to study R.'s art, it was so
fresh and unconventional.

There wasn't even a bell or a speaking-tube in the
castle. I had a great many servants, and those that
were on duty lolled in the anteroom; and when I
wanted one of them I had to go and call for him.
There was no gas, there were no candles; a bronze
dish half full of boarding-house butter with a blazing
rag floating in it was the thing that produced what was
regarded as light. A lot of these hung along the walls
and modified the dark, just toned it down enough to
make it dismal. If you went out at night, your ser-
vants carried torches. There were no books, pens,
paper or ink, and no glass in the openings they be-
lieved to be windows. It is a little thing -- glass is --
until it is absent, then it becomes a big thing. But
perhaps the worst of all was, that there wasn't any
sugar, coffee, tea, or tobacco. I saw that I was just
another Robinson Crusoe cast away on an uninhabited
island, with no society but some more or less tame
animals, and if I wanted to make life bearable I must
do as he did -- invent, contrive, create, reorganize
things; set brain and hand to work, and keep them
busy. Well, that was in my line.

One thing troubled me along at first -- the immense
interest which people took in me. Apparently the
whole nation wanted a look at me. It soon transpired
that the eclipse had scared the British world almost to
death; that while it lasted the whole country, from one
end to the other, was in a pitiable state of panic, and
the churches, hermitages, and monkeries overflowed
with praying and weeping poor creatures who thought
the end of the world was come. Then had followed
the news that the producer of this awful event was a
stranger, a mighty magician at Arthur's court; that he
could have blown out the sun like a candle, and was
just going to do it when his mercy was purchased, and
he then dissolved his enchantments, and was now
recognized and honored as the man who had by his
unaided might saved the globe from destruction and
its peoples from extinction. Now if you consider that
everybody believed that, and not only believed it, but
never even dreamed of doubting it, you will easily
understand that there was not a person in all Britain
that would not have walked fifty miles to get a sight of
me. Of course I was all the talk -- all other subjects
were dropped; even the king became suddenly a per-
son of minor interest and notoriety. Within twenty-
four hours the delegations began to arrive, and from
that time onward for a fortnight they kept coming.
The village was crowded, and all the countryside. I
had to go out a dozen times a day and show myself to
these reverent and awe-stricken multitudes. It came
to be a great burden, as to time and trouble, but of
course it was at the same time compensatingly agree-
able to be so celebrated and such a center of homage.
It turned Brer Merlin green with envy and spite, which
was a great satisfaction to me. But there was one
thing I couldn't understand -- nobody had asked for
an autograph. I spoke to Clarence about it. By
George! I had to explain to him what it was. Then
he said nobody in the country could read or write but
a few dozen priests. Land! think of that.

There was another thing that troubled me a little.
Those multitudes presently began to agitate for another
miracle. That was natural. To be able to carry back
to their far homes the boast that they had seen the
man who could command the sun, riding in the
heavens, and be obeyed, would make them great in
the eyes of their neighbors, and envied by them all;
but to be able to also say they had seen him work a
miracle themselves -- why, people would come a dis-
tance to see THEM. The pressure got to be pretty
strong. There was going to be an eclipse of the
moon, and I knew the date and hour, but it was too
far away. Two years. I would have given a good
deal for license to hurry it up and use it now when
there was a big market for it. It seemed a great pity
to have it wasted so, and come lagging along at a time
when a body wouldn't have any use for it, as like as
not. If it had been booked for only a month away, I
could have sold it short; but, as matters stood, I
couldn't seem to cipher out any way to make it do me
any good, so I gave up trying. Next, Clarence found
that old Merlin was making himself busy on the sly
among those people. He was spreading a report that
I was a humbug, and that the reason I didn't accom-
modate the people with a miracle was because I
couldn't. I saw that I must do something. I pres-
ently thought out a plan.

By my authority as executive I threw Merlin into
prison -- the same cell I had occupied myself. Then
I gave public notice by herald and trumpet that I
should be busy with affairs of state for a fortnight, but
about the end of that time I would take a moment's
leisure and blow up Merlin's stone tower by fires from
heaven; in the meantime, whoso listened to evil re-
ports about me, let him beware. Furthermore, I
would perform but this one miracle at this time, and
no more; if it failed to satisfy and any murmured, I
would turn the murmurers into horses, and make them
useful. Quiet ensued.

I took Clarence into my confidence, to a certain
degree, and we went to work privately. I told him
that this was a sort of miracle that required a trifle of
preparation, and that it would be sudden death to ever
talk about these preparations to anybody. That made
his mouth safe enough. Clandestinely we made a few
bushels of first-rate blasting powder, and I superin-
tended my armorers while they constructed a lightning-
rod and some wires. This old stone tower was very
massive -- and rather ruinous, too, for it was Roman,
and four hundred years old. Yes, and handsome,
after a rude fashion, and clothed with ivy from base to
summit, as with a shirt of scale mail. It stood on a
lonely eminence, in good view from the castle, and
about half a mile away.

Working by night, we stowed the powder in the
tower -- dug stones out, on the inside, and buried the
powder in the walls themselves, which were fifteen feet
thick at the base. We put in a peck at a time, in a
dozen places. We could have blown up the Tower of
London with these charges. When the thirteenth night
was come we put up our lightning-rod, bedded it in
one of the batches of powder, and ran wires from it to
the other batches. Everybody had shunned that
locality from the day of my proclamation, but on the
morning of the fourteenth I thought best to warn the
people, through the heralds, to keep clear away -- a
quarter of a mile away. Then added, by command,
that at some time during the twenty-four hours I
would consummate the miracle, but would first give a
brief notice; by flags on the castle towers if in the
daytime, by torch-baskets in the same places if at
night.

Thunder-showers had been tolerably frequent of late,
and I was not much afraid of a failure; still, I shouldn't
have cared for a delay of a day or two; I should have
explained that I was busy with affairs of state yet, and
the people must wait.

Of course, we had a blazing sunny day -- almost the
first one without a cloud for three weeks; things always
happen so. I kept secluded, and watched the weather.
Clarence dropped in from time to time and said the
public excitement was growing and growing all the
time, and the whole country filling up with human
masses as far as one could see from the battlements.
At last the wind sprang up and a cloud appeared -- in
the right quarter, too, and just at nightfall. For a
little while I watched that distant cloud spread and
blacken, then I judged it was time for me to appear.
I ordered the torch-baskets to be lit, and Merlin liber-
ated and sent to me. A quarter of an hour later I
ascended the parapet and there found the king and the
court assembled and gazing off in the darkness toward
Merlin's Tower. Already the darkness was so heavy
that one could not see far; these people and the old
turrets, being partly in deep shadow and partly in the
red glow from the great torch-baskets overhead, made
a good deal of a picture.

Merlin arrived in a gloomy mood. I said:

"You wanted to burn me alive when I had not done
you any harm, and latterly you have been trying to
injure my professional reputation. Therefore I am
going to call down fire and blow up your tower, but
it is only fair to give you a chance; now if you think
you can break my enchantments and ward off the fires,
step to the bat, it's your innings."

"I can, fair sir, and I will. Doubt it not."

He drew an imaginary circle on the stones of the
roof, and burnt a pinch of powder in it, which sent up
a small cloud of aromatic smoke, whereat everybody
fell back and began to cross themselves and get un-
comfortable. Then he began to mutter and make
passes in the air with his hands. He worked himself
up slowly and gradually into a sort of frenzy, and got
to thrashing around with his arms like the sails of a
windmill. By this time the storm had about reached
us; the gusts of wind were flaring the torches and
making the shadows swash about, the first heavy drops
of rain were falling, the world abroad was black as
pitch, the lightning began to wink fitfully. Of course,
my rod would be loading itself now. In fact, things
were imminent. So I said:

"You have had time enough. I have given you
every advantage, and not interfered. It is plain your
magic is weak. It is only fair that I begin now."

I made about three passes in the air, and then there
was an awful crash and that old tower leaped into the
sky in chunks, along with a vast volcanic fountain of
fire that turned night to noonday, and showed a thou-
sand acres of human beings groveling on the ground in
a general collapse of consternation. Well, it rained
mortar and masonry the rest of the week. This was
the report; but probably the facts would have modi-
fied it.

It was an effective miracle. The great bothersome
temporary population vanished. There were a good
many thousand tracks in the mud the next morning,
but they were all outward bound. If I had advertised
another miracle I couldn't have raised an audience
with a sheriff.

Merlin's stock was flat. The king wanted to stop
his wages; he even wanted to banish him, but I inter-
fered. I said he would be useful to work the weather,
and attend to small matters like that, and I would give
him a lift now and then when his poor little parlor-
magic soured on him. There wasn't a rag of his tower
left, but I had the government rebuild it for him, and
advised him to take boarders; but he was too high-
toned for that. And as for being grateful, he never
even said thank you. He was a rather hard lot, take
him how you might; but then you couldn't fairly ex-
pect a man to be sweet that had been set back so.


CHAPTER VIII.
THE BOSS

TO be vested with enormous authority is a fine
thing; but to have the on-looking world consent
to it is a finer. The tower episode solidified my
power, and made it impregnable. If any were per-
chance disposed to be jealous and critical before that,
they experienced a change of heart, now. There was
not any one in the kingdom who would have considered
it good judgment to meddle with my matters.

I was fast getting adjusted to my situation and cir-
cumstances. For a time, I used to wake up, mornings,
and smile at my "dream," and listen for the Colt's
factory whistle; but that sort of thing played itself
out, gradually, and at last I was fully able to realize
that I was actually living in the sixth century, and in
Arthur's court, not a lunatic asylum. After that, I
was just as much at home in that century as I could
have been in any other; and as for preference, I
wouldn't have traded it for the twentieth. Look at
the opportunities here for a man of knowledge, brains,
pluck, and enterprise to sail in and grow up with the
country. The grandest field that ever was; and all my
own; not a competitor; not a man who wasn't a baby
to me in acquirements and capacities; whereas, what
would I amount to in the twentieth century? I should
be foreman of a factory, that is about all; and could
drag a seine down street any day and catch a hundred
better men than myself.

What a jump I had made! I couldn't keep from
thinking about it, and contemplating it, just as one
does who has struck oil. There was nothing back of
me that could approach it, unless it might be Joseph's
case; and Joseph's only approached it, it didn't equal
it, quite. For it stands to reason that as Joseph's
splendid financial ingenuities advantaged nobody but
the king, the general public must have regarded him
with a good deal of disfavor, whereas I had done my
entire public a kindness in sparing the sun, and was
popular by reason of it.

I was no shadow of a king; I was the substance;
the king himself was the shadow. My power was
colossal; and it was not a mere name, as such things
have generally been, it was the genuine article. I
stood here, at the very spring and source of the second
great period of the world's history; and could see the
trickling stream of that history gather and deepen and
broaden, and roll its mighty tides down the far
centuries; and I could note the upspringing of adven-
turers like myself in the shelter of its long array of
thrones: De Montforts, Gavestons, Mortimers, Villier-
ses; the war-making, campaign-directing wantons of
France, and Charles the Second's scepter-wielding
drabs; but nowhere in the procession was my full-
sized fellow visible. I was a Unique; and glad to
know that that fact could not be dislodged or chal-
lenged for thirteen centuries and a half, for sure.
Yes, in power I was equal to the king. At the same
time there was another power that was a trifle stronger
than both of us put together. That was the Church.
I do not wish to disguise that fact. I couldn't, if I
wanted to. But never mind about that, now; it will
show up, in its proper place, later on. It didn't cause
me any trouble in the beginning -- at least any of
consequence.

Well, it was a curious country, and full of interest.
And the people! They were the quaintest and sim-
plest and trustingest race; why, they were nothing but
rabbits. It was pitiful for a person born in a whole-
some free atmosphere to listen to their humble and
hearty outpourings of loyalty toward their king and
Church and nobility; as if they had any more occasion
to love and honor king and Church and noble than a
slave has to love and honor the lash, or a dog has to
love and honor the stranger that kicks him! Why,
dear me,ANY kind of royalty, howsoever modified,
ANY kind of aristocracy, howsoever pruned, is rightly
an insult; but if you are born and brought up under
that sort of arrangement you probably never find it
out for yourself, and don't believe it when somebody
else tells you. It is enough to make a body ashamed
of his race to think of the sort of froth that has
always occupied its thrones without shadow of right
or reason, and the seventh-rate people that have always
figured as its aristocracies -- a company of monarchs
and nobles who, as a rule, would have achieved only
poverty and obscurity if left, like their betters, to their
own exertions.

The most of King Arthur's British nation were
slaves, pure and simple, and bore that name, and wore
the iron collar on their necks; and the rest were slaves
in fact, but without the name; they imagined them-
selves men and freemen, and called themselves so.
The truth was, the nation as a body was in the world
for one object, and one only: to grovel before king
and Church and noble; to slave for them, sweat blood
for them, starve that they might be fed, work that they
might play, drink misery to the dregs that they might
be happy, go naked that they might wear silks and
jewels, pay taxes that they might be spared from pay-
ing them, be familiar all their lives with the degrading
language and postures of adulation that they might
walk in pride and think themselves the gods of this
world. And for all this, the thanks they got were
cuffs and contempt; and so poor-spirited were they
that they took even this sort of attention as an honor.

Inherited ideas are a curious thing, and interesting
to observe and examine. I had mine, the king and his
people had theirs. In both cases they flowed in ruts
worn deep by time and habit, and the man who should
have proposed to divert them by reason and argument
would have had a long contract on his hands. For
instance, those people had inherited the idea that all
men without title and a long pedigree, whether they
had great natural gifts and acquirements or hadn't,
were creatures of no more consideration than so many
animals, bugs, insects; whereas I had inherited the
idea that human daws who can consent to masquerade
in the peacock-shams of inherited dignities and un-
earned titles, are of no good but to be laughed at.
The way I was looked upon was odd, but it was
natural. You know how the keeper and the public
regard the elephant in the menagerie: well, that is the
idea. They are full of admiration of his vast bulk and
his prodigious strength; they speak with pride of the
fact that he can do a hundred marvels which are far
and away beyond their own powers; and they speak
with the same pride of the fact that in his wrath he is
able to drive a thousand men before him. But does
that make him one of THEM? No; the raggedest
tramp in the pit would smile at the idea. He couldn't
comprehend it; couldn't take it in; couldn't in any
remote way conceive of it. Well, to the king, the
nobles, and all the nation, down to the very slaves
and tramps, I was just that kind of an elephant, and
nothing more. I was admired, also feared; but it
was as an animal is admired and feared. The animal
is not reverenced, neither was I; I was not even re-
spected. I had no pedigree, no inherited title; so
in the king's and nobles' eyes I was mere dirt; the
people regarded me with wonder and awe, but there
was no reverence mixed with it; through the force of
inherited ideas they were not able to conceive of any-
thing being entitled to that except pedigree and lord-
ship. There you see the hand of that awful power,
the Roman Catholic Church. In two or three little
centuries it had converted a nation of men to a nation
of worms. Before the day of the Church's supremacy
in the world, men were men, and held their heads up,
and had a man's pride and spirit and independence;
and what of greatness and position a person got, he
got mainly by achievement, not by birth. But then
the Church came to the front, with an axe to grind;
and she was wise, subtle, and knew more than one
way to skin a cat -- or a nation; she invented "divine
right of kings," and propped it all around, brick by
brick, with the Beatitudes -- wrenching them from
their good purpose to make them fortify an evil one;
she preached (to the commoner) humility, obedience
to superiors, the beauty of self-sacrifice; she preached
(to the commoner) meekness under insult; preached
(still to the commoner, always to the commoner) pa-
tience, meanness of spirit, non-resistance under op-
pression; and she introduced heritable ranks and
aristocracies, and taught all the Christian populations
of the earth to bow down to them and worship them.
Even down to my birth-century that poison was still in
the blood of Christendom, and the best of English com-
moners was still content to see his inferiors impudently
continuing to hold a number of positions, such as lord-
ships and the throne, to which the grotesque laws of
his country did not allow him to aspire; in fact, he
was not merely contented with this strange condition
of things, he was even able to persuade himself that
he was proud of it. It seems to show that there isn't
anything you can't stand, if you are only born and
bred to it. Of course that taint, that reverence for
rank and title, had been in our American blood, too --
I know that; but when I left America it had disap-
peared -- at least to all intents and purposes. The
remnant of it was restricted to the dudes and dudesses.
When a disease has worked its way down to that level,
it may fairly be said to be out of the system.

But to return to my anomalous position in King
Arthur's kingdom. Here I was, a giant among pig-
mies, a man among children, a master intelligence
among intellectual moles: by all rational measurement
the one and only actually great man in that whole
British world; and yet there and then, just as in the
remote England of my birth-time, the sheep-witted
earl who could claim long descent from a king's leman,
acquired at second-hand from the slums of London,
was a better man than I was. Such a personage was
fawned upon in Arthur's realm and reverently looked
up to by everybody, even though his dispositions were
as mean as his intelligence, and his morals as base as
his lineage. There were times when HE could sit down
in the king's presence, but I couldn't. I could have
got a title easily enough, and that would have raised
me a large step in everybody's eyes; even in the
king's, the giver of it. But I didn't ask for it; and I
declined it when it was offered. I couldn't have enjoyed
such a thing with my notions; and it wouldn't have
been fair, anyway, because as far back as I could go,
our tribe had always been short of the bar sinister. I
couldn't have felt really and satisfactorily fine and
proud and set-up over any title except one that should
come from the nation itself, the only legitimate source;
and such an one I hoped to win; and in the course of
years of honest and honorable endeavor, I did win it
and did wear it with a high and clean pride. This
title fell casually from the lips of a blacksmith, one
day, in a village, was caught up as a happy thought
and tossed from mouth to mouth with a laugh and an
affirmative vote; in ten days it had swept the kingdom,
and was become as familiar as the king's name. I
was never known by any other designation afterward,
whether in the nation's talk or in grave debate upon
matters of state at the council-board of the sovereign.
This title, translated into modern speech, would be
THE BOSS. Elected by the nation. That suited me.
And it was a pretty high title. There were very few
THE'S, and I was one of them. If you spoke of the
duke, or the earl, or the bishop, how could anybody
tell which one you meant? But if you spoke of The
King or The Queen or The Boss, it was different.

Well, I liked the king, and as king I respected him
-- respected the office; at least respected it as much as
I was capable of respecting any unearned supremacy;
but as MEN I looked down upon him and his nobles --
privately. And he and they liked me, and respected
my office; but as an animal, without birth or sham
title, they looked down upon me -- and were not par-
ticularly private about it, either. I didn't charge for
my opinion about them, and they didn't charge for
their opinion about me: the account was square, the
books balanced, everybody was satisfied.


CHAPTER IX.
THE TOURNAMENT

THEY were always having grand tournaments there
at Camelot; and very stirring and picturesque
and ridiculous human bull-fights they were, too, but
just a little wearisome to the practical mind. How-
ever, I was generally on hand -- for two reasons: a
man must not hold himself aloof from the things which
his friends and his community have at heart if he
would be liked -- especially as a statesman; and both
as business man and statesman I wanted to study the
tournament and see if I couldn't invent an improve-
ment on it. That reminds me to remark, in passing,
that the very first official thing I did, in my adminis-
tration -- and it was on the very first day of it, too --
was to start a patent office; for I knew that a country
without a patent office and good patent laws was just
a crab, and couldn't travel any way but sideways or
backways.

Things ran along, a tournament nearly every week;
and now and then the boys used to want me to take a
hand -- I mean Sir Launcelot and the rest -- but I
said I would by and by; no hurry yet, and too much
government machinery to oil up and set to rights and
start a-going.

We had one tournament which was continued from
day to day during more than a week, and as many as
five hundred knights took part in it, from first to last.
They were weeks gathering. They came on horseback
from everywhere; from the very ends of the country,
and even from beyond the sea; and many brought
ladies, and all brought squires and troops of servants.
It was a most gaudy and gorgeous crowd, as to cos-
tumery, and very characteristic of the country and the
time, in the way of high animal spirits, innocent inde-
cencies of language, and happy-hearted indifference to
morals. It was fight or look on, all day and every
day; and sing, gamble, dance, carouse half the night
every night. They had a most noble good time. You
never saw such people. Those banks of beautiful
ladies, shining in their barbaric splendors, would see
a knight sprawl from his horse in the lists with a lance-
shaft the thickness of your ankle clean through him
and the blood spouting, and instead of fainting they
would clap their hands and crowd each other for a
better view; only sometimes one would dive into her
handkerchief, and look ostentatiously broken-hearted,
and then you could lay two to one that there was a
scandal there somewhere and she was afraid the public
hadn't found it out.

The noise at night would have been annoying to me
ordinarily, but I didn't mind it in the present circum-
stances, because it kept me from hearing the quacks
detaching legs and arms from the day's cripples.
They ruined an uncommon good old cross-cut saw for
me, and broke the saw-buck, too, but I let it pass.
And as for my axe -- well, I made up my mind that
the next time I lent an axe to a surgeon I would pick
my century.

I not only watched this tournament from day to day,
but detailed an intelligent priest from my Department
of Public Morals and Agriculture, and ordered him to
report it; for it was my purpose by and by, when I
should have gotten the people along far enough, to
start a newspaper. The first thing you want in a new
country, is a patent office; then work up your school
system; and after that, out with your paper. A
newspaper has its faults, and plenty of them, but no
matter, it's hark from the tomb for a dead nation, and
don't you forget it. You can't resurrect a dead nation
without it; there isn't any way. So I wanted to
sample things, and be finding out what sort of reporter-
material I might be able to rake together out of the
sixth century when I should come to need it.

Well, the priest did very well, considering. He got
in all the details, and that is a good thing in a local
item: you see, he had kept books for the undertaker-
department of his church when he was younger,
and there, you know, the money's in the details; the
more details, the more swag: bearers, mutes, candles,
prayers -- everything counts; and if the bereaved don't
buy prayers enough you mark up your candles with a
forked pencil, and your bill shows up all right. And
he had a good knack at getting in the complimentary
thing here and there about a knight that was likely to
advertise -- no, I mean a knight that had influence;
and he also had a neat gift of exaggeration, for in his
time he had kept door for a pious hermit who lived in
a sty and worked miracles.

Of course this novice's report lacked whoop and
crash and lurid description, and therefore wanted the
true ring; but its antique wording was quaint and
sweet and simple, and full of the fragrances and flavors
of the time, and these little merits made up in a meas-
ure for its more important lacks. Here is an extract
from it:

  Then Sir Brian de les Isles and Grummore Grummorsum,
  knights of the castle, encountered with Sir Aglovale and
  Sir Tor, and Sir Tor smote down Sir Grummore Grummorsum
  to the earth. Then came Sir Carados of the dolorous
  tower, and Sir Turquine, knights of the castle, and
  there encountered with them Sir Percivale de Galis
  and Sir Lamorak de Galis, that were two brethren, and
  there encountered Sir Percivale with Sir Carados, and
  either brake their spears unto their hands, and then
  Sir Turquine with Sir Lamorak, and either of them smote
  down other, horse and all, to the earth, and either
  parties rescued other and horsed them again. And Sir
  Arnold, and Sir Gauter, knights of the castle,
  encountered with Sir Brandiles and Sir Kay, and these
  four knights encountered mightily, and brake their
  spears to their hands. Then came Sir Pertolope from
  the castle, and there encountered with him Sir Lionel,
  and there Sir Pertolope the green knight smote down Sir
  Lionel, brother to Sir Launcelot. All this was marked
  by noble heralds, who bare him best, and their names.
  Then Sir Bleobaris brake his spear upon Sir Gareth,
  but of that stroke Sir Bleobaris fell to the earth.
  When Sir Galihodin saw that, he bad Sir Gareth keep him,
  and Sir Gareth smote him to the earth. Then Sir Galihud
  gat a spear to avenge his brother, and in the same wise
  Sir Gareth served him, and Sir Dinadan and his brother
  La Cote Male Taile, and Sir Sagramore le Disirous, and 
  Sir Dodinas le Savage; all these he bare down with one
  spear. When King Aswisance of Ireland saw Sir Gareth 
  fare so he marvelled what he might be, that one time
  seemed green, and another time, at his again coming,
  he seemed blue. And thus at every course that he rode
  to and fro he changed his color, so that there might
  neither king nor knight have ready cognizance of him.
  Then Sir Agwisance the King of Ireland encountered
  with Sir Gareth, and there Sir Gareth smote him from
  his horse, saddle and all. And then came King Carados
  of Scotland, and Sir Gareth smote him down horse and
  man. And in the same wise he served King Uriens of the
  land of Gore. And then there came in Six Bagdemagus,
  and Sir Gareth smote him down horse and man to the
  earth. And Bagdemagus's son Meliganus brake a spear
  upon Sir Gareth mightily and knightly. And then Sir
  Galahault the noble prince cried on high, Knight with 
  the many colors, well hast thou justed; now make thee
  ready that I may just with thee. Sir Gareth heard him,
  and he gat a great spear, and so they encountered
  together, and there the prince brake his spear; but Sir
  Gareth smote him upon the left side of the helm, that
  he reeled here and there, and he had fallen down had not
  his men recovered him. Truly, said King Arthur, that
  knight with the many colors is a good knight. Wherefore
  the king called unto him Sir Launcelot, and prayed him
  to encounter with that knight. Sir, said Launcelot, I
  may as well find in my heart for to forbear him at
  this time, for he hath had travail enough this day, and
  when a good knight doth so well upon some day, it is
  no good knight's part to let him of his worship, and,
  namely, when he seeth a knight hath done so great 
  labour; for peradventure, said Sir Launcelot, his
  quarrel is here this day, and peradventure he is best
  beloved with this lady of all that be here, for I see
  well he paineth himself and enforceth him to do great
  deeds, and therefore, said Sir Launcelot, as for me,
  this day he shall have the honour; though it lay in my
  power to put him from it, I would not.

There was an unpleasant little episode that day,
which for reasons of state I struck out of my priest's
report. You will have noticed that Garry was doing
some great fighting in the engagement. When I say
Garry I mean Sir Gareth. Garry was my private pet
name for him; it suggests that I had a deep affection
for him, and that was the case. But it was a private
pet name only, and never spoken aloud to any one,
much less to him; being a noble, he would not have
endured a familiarity like that from me. Well, to pro-
ceed: I sat in the private box set apart for me as the
king's minister. While Sir Dinadan was waiting for
his turn to enter the lists, he came in there and sat
down and began to talk; for he was always making up
to me, because I was a stranger and he liked to have a
fresh market for his jokes, the most of them having
reached that stage of wear where the teller has to do
the laughing himself while the other person looks sick.
I had always responded to his efforts as well as I
could, and felt a very deep and real kindness for him,
too, for the reason that if by malice of fate he knew
the one particular anecdote which I had heard oftenest
and had most hated and most loathed all my life, he
had at least spared it me. It was one which I had
heard attributed to every humorous person who had
ever stood on American soil, from Columbus down to
Artemus Ward. It was about a humorous lecturer
who flooded an ignorant audience with the killingest
jokes for an hour and never got a laugh; and then
when he was leaving, some gray simpletons wrung him
gratefully by the hand and said it had been the funniest
thing they had ever heard, and "it was all they could
do to keep from laughin' right out in meetin'." That
anecdote never saw the day that it was worth the telling;
and yet I had sat under the telling of it hundreds and
thousands and millions and billions of times, and cried
and cursed all the way through. Then who can hope
to know what my feelings were, to hear this armor-
plated ass start in on it again, in the murky twilight of
tradition, before the dawn of history, while even
Lactantius might be referred to as "the late Lactan-
tius," and the Crusades wouldn't be born for five
hundred years yet? Just as he finished, the call-boy
came; so, haw-hawing like a demon, he went rattling
and clanking out like a crate of loose castings, and I
knew nothing more. It was some minutes before I
came to, and then I opened my eyes just in time to
see Sir Gareth fetch him an awful welt, and I uncon-
sciously out with the prayer, "I hope to gracious he's
killed!" But by ill-luck, before I had got half through
with the words, Sir Gareth crashed into Sir Sagramor
le Desirous and sent him thundering over his horse's
crupper, and Sir Sagramor caught my remark and
thought I meant it for HIM.

Well, whenever one of those people got a thing into
his head, there was no getting it out again. I knew
that, so I saved my breath, and offered no explana-
tions. As soon as Sir Sagramor got well, he notified
me that there was a little account to settle between us,
and he named a day three or four years in the future;
place of settlement, the lists where the offense had
been given. I said I would be ready when he got
back. You see, he was going for the Holy Grail.
The boys all took a flier at the Holy Grail now and
then. It was a several years' cruise. They always
put in the long absence snooping around, in the most
conscientious way, though none of them had any idea
where the Holy Grail really was, and I don't think any
of them actually expected to find it, or would have
known what to do with it if he HAD run across it.
You see, it was just the Northwest Passage of that
day, as you may say; that was all. Every year expe-
ditions went out holy grailing, and next year relief
expeditions went out to hunt for THEM. There was
worlds of reputation in it, but no money. Why, they
actually wanted ME to put in! Well, I should smile.


CHAPTER X.
BEGINNINGS OF CIVILIZATION

THE Round Table soon heard of the challenge, and
of course it was a good deal discussed, for such
things interested the boys. The king thought I ought
now to set forth in quest of adventures, so that I
might gain renown and be the more worthy to meet
Sir Sagramor when the several years should have rolled
away. I excused myself for the present; I said it
would take me three or four years yet to get things
well fixed up and going smoothly; then I should be
ready; all the chances were that at the end of that
time Sir Sagramor would still be out grailing, so no
valuable time would be lost by the postponement; I
should then have been in office six or seven years,
and I believed my system and machinery would be so
well developed that I could take a holiday without its
working any harm.

I was pretty well satisfied with what I had already
accomplished. In various quiet nooks and corners I
had the beginnings of all sorts of industries under way
-- nuclei of future vast factories, the iron and steel
missionaries of my future civilization. In these were
gathered together the brightest young minds I could
find, and I kept agents out raking the country for
more, all the time. I was training a crowd of ignorant
folk into experts -- experts in every sort of handiwork
and scientific calling. These nurseries of mine went
smoothly and privately along undisturbed in their ob-
scure country retreats, for nobody was allowed to
come into their precincts without a special permit --
for I was afraid of the Church.

I had started a teacher-factory and a lot of Sunday-
schools the first thing; as a result, I now had an ad-
mirable system of graded schools in full blast in those
places, and also a complete variety of Protestant con-
gregations all in a prosperous and growing condition.
Everybody could be any kind of a Christian he wanted
to; there was perfect freedom in that matter. But I
confined public religious teaching to the churches and
the Sunday-schools, permitting nothing of it in my
other educational buildings. I could have given my
own sect the preference and made everybody a Presby-
terian without any trouble, but that would have been
to affront a law of human nature: spiritual wants and
instincts are as various in the human family as are
physical appetites, complexions, and features, and a
man is only at his best, morally, when he is equipped
with the religious garment whose color and shape and
size most nicely accommodate themselves to the spirit-
ual complexion, angularities, and stature of the indi-
vidual who wears it; and, besides, I was afraid of a
united Church; it makes a mighty power, the mightiest
conceivable, and then when it by and by gets into
selfish hands, as it is always bound to do, it means
death to human liberty and paralysis to human
thought.

All mines were royal property, and there were a
good many of them. They had formerly been worked
as savages always work mines -- holes grubbed in the
earth and the mineral brought up in sacks of hide by
hand, at the rate of a ton a day; but I had begun to
put the mining on a scientific basis as early as I could.

Yes, I had made pretty handsome progress when Sir
Sagramor's challenge struck me.

Four years rolled by -- and then! Well, you would
never imagine it in the world. Unlimited power is the
ideal thing when it is in safe hands. The despotism of
heaven is the one absolutely perfect government. An
earthly despotism would be the absolutely perfect earthly
government, if the conditions were the same, namely,
the despot the perfectest individual of the human race,
and his lease of life perpetual. But as a perishable
perfect man must die, and leave his despotism in the
hands of an imperfect successor, an earthly despotism
is not merely a bad form of government, it is the worst
form that is possible.

My works showed what a despot could do with the
resources of a kingdom at his command. Unsuspected
by this dark land, I had the civilization of the nine-
teenth century booming under its very nose! It was
fenced away from the public view, but there it was, a
gigantic and unassailable fact -- and to be heard from,
yet, if I lived and had luck. There it was, as sure a
fact and as substantial a fact as any serene volcano,
standing innocent with its smokeless summit in the
blue sky and giving no sign of the rising hell in its
bowels. My schools and churches were children four
years before; they were grown-up now; my shops of
that day were vast factories now; where I had a dozen
trained men then, I had a thousand now; where I had
one brilliant expert then, I had fifty now. I stood
with my hand on the cock, so to speak, ready to turn
it on and flood the midnight world with light at any
moment. But I was not going to do the thing in that
sudden way. It was not my policy. The people
could not have stood it; and, moreover, I should have
had the Established Roman Catholic Church on my
back in a minute.

No, I had been going cautiously all the while. I
had had confidential agents trickling through the
country some time, whose office was to undermine
knighthood by imperceptible degrees, and to gnaw a
little at this and that and the other superstition, and so
prepare the way gradually for a better order of things.
I was turning on my light one-candle-power at a time,
and meant to continue to do so.

I had scattered some branch schools secretly about
the kingdom, and they were doing very well. I meant
to work this racket more and more, as time wore on, if
nothing occurred to frighten me. One of my deepest
secrets was my West Point -- my military academy. I
kept that most jealously out of sight; and I did the
same with my naval academy which I had established
at a remote seaport. Both were prospering to my
satisfaction.

Clarence was twenty-two now, and was my head
executive, my right hand. He was a darling; he was
equal to anything; there wasn't anything he couldn't
turn his hand to. Of late I had been training him for
journalism, for the time seemed about right for a start
in the newspaper line; nothing big, but just a small
weekly for experimental circulation in my civilization-
nurseries. He took to it like a duck; there was an
editor concealed in him, sure. Already he had doubled
himself in one way; he talked sixth century and wrote
nineteenth. His journalistic style was climbing, stead-
ily; it was already up to the back settlement Alabama
mark, and couldn't be told from the editorial output of
that region either by matter or flavor.

We had another large departure on hand, too. This
was a telegraph and a telephone; our first venture in
this line. These wires were for private service only,
as yet, and must be kept private until a riper day
should come. We had a gang of men on the road,
working mainly by night. They were stringing ground
wires; we were afraid to put up poles, for they would
attract too much inquiry. Ground wires were good
enough, in both instances, for my wires were protected
by an insulation of my own invention which was per-
fect. My men had orders to strike across country,
avoiding roads, and establishing connection with any
considerable towns whose lights betrayed their pres-
ence, and leaving experts in charge. Nobody could
tell you how to find any place in the kingdom, for
nobody ever went intentionally to any place, but only
struck it by accident in his wanderings, and then gener-
ally left it without thinking to inquire what its name
was. At one time and another we had sent out topo-
graphical expeditions to survey and map the kingdom,
but the priests had always interfered and raised trouble.
So we had given the thing up, for the present; it
would be poor wisdom to antagonize the Church.

As for the general condition of the country, it was
as it had been when I arrived in it, to all intents and
purposes. I had made changes, but they were neces-
sarily slight, and they were not noticeable. Thus far,
I had not even meddled with taxation, outside of the
taxes which provided the royal revenues. I had
systematized those, and put the service on an effective
and righteous basis. As a result, these revenues were
already quadrupled, and yet the burden was so much
more equably distributed than before, that all the king-
dom felt a sense of relief, and the praises of my ad-
ministration were hearty and general.

Personally, I struck an interruption, now, but I did
not mind it, it could not have happened at a better
time. Earlier it could have annoyed me, but now
everything was in good hands and swimming right
along. The king had reminded me several times, of
late, that the postponement I had asked for, four years
before, had about run out now. It was a hint that I
ought to be starting out to seek adventures and get up
a reputation of a size to make me worthy of the honor
of breaking a lance with Sir Sagramor, who was still
out grailing, but was being hunted for by various relief
expeditions, and might be found any year, now. So
you see I was expecting this interruption; it did not
take me by surprise.


CHAPTER XI.
THE YANKEE IN SEARCH OF ADVENTURES.

THERE never was such a country for wandering
liars; and they were of both sexes. Hardly a
month went by without one of these tramps arriving;
and generally loaded with a tale about some princess
or other wanting help to get her out of some far-away
castle where she was held in captivity by a lawless
scoundrel, usually a giant. Now you would think that
the first thing the king would do after listening to such
a novelette from an entire stranger, would be to ask
for credentials -- yes, and a pointer or two as to
locality of castle, best route to it, and so on. But
nobody ever thought of so simple and common-sense
a thing at that. No, everybody swallowed these peo-
ple's lies whole, and never asked a question of any
sort or about anything. Well, one day when I was
not around, one of these people came along -- it was a
she one, this time -- and told a tale of the usual pat-
tern. Her mistress was a captive in a vast and gloomy
castle, along with forty-four other young and beautiful
girls, pretty much all of them princesses; they had
been languishing in that cruel captivity for twenty-six
years; the masters of the castle were three stupendous
brothers, each with four arms and one eye -- the eye in
the center of the forehead, and as big as a fruit. Sort of
fruit not mentioned; their usual slovenliness in statistics.

Would you believe it? The king and the whole
Round Table were in raptures over this preposterous
opportunity for adventure. Every knight of the Table
jumped for the chance, and begged for it; but to their
vexation and chagrin the king conferred it upon me,
who had not asked for it at all.

By an effort, I contained my joy when Clarence
brought me the news. But he -- he could not contain
his. His mouth gushed delight and gratitude in a
steady discharge -- delight in my good fortune, grati-
tude to the king for this splendid mark of his favor for
me. He could keep neither his legs nor his body still,
but pirouetted about the place in an airy ecstasy of
happiness.

On my side, I could have cursed the kindness that
conferred upon me this benefaction, but I kept my
vexation under the surface for policy's sake, and did
what I could to let on to be glad. Indeed, I SAID I
was glad. And in a way it was true; I was as glad as
a person is when he is scalped.

Well, one must make the best of things, and not
waste time with useless fretting, but get down to busi-
ness and see what can be done. In all lies there is
wheat among the chaff; I must get at the wheat in this
case: so I sent for the girl and she came. She was a
comely enough creature, and soft and modest, but, if
signs went for anything, she didn't know as much as a
lady's watch. I said:

"My dear, have you been questioned as to particu-
lars?"

She said she hadn't.

"Well, I didn't expect you had, but I thought I
would ask, to make sure; it's the way I've been raised.
Now you mustn't take it unkindly if I remind you that
as we don't know you, we must go a little slow. You
may be all right, of course, and we'll hope that you
are; but to take it for granted isn't business. YOU
understand that. I'm obliged to ask you a few ques-
tions; just answer up fair and square, and don't be
afraid. Where do you live, when you are at home?"

"In the land of Moder, fair sir."

"Land of Moder. I don't remember hearing of it
before. Parents living?"

"As to that, I know not if they be yet on live, sith
it is many years that I have lain shut up in the castle."

"Your name, please?"

"I hight the Demoiselle Alisande la Carteloise, an it
please you."

"Do you know anybody here who can identify you?"

"That were not likely, fair lord, I being come hither
now for the first time."

"Have you brought any letters -- any documents --
any proofs that you are trustworthy and truthful?"

"Of a surety, no; and wherefore should I? Have
I not a tongue, and cannot I say all that myself?"

"But YOUR saying it, you know, and somebody
else's saying it, is different."

"Different? How might that be? I fear me I do
not understand."

"Don't UNDERSTAND? Land of -- why, you see --
you see -- why, great Scott, can't you understand a
little thing like that? Can't you understand the
difference between your -- WHY do you look so inno-
cent and idiotic!"

"I? In truth I know not, but an it were the will of
God."

"Yes, yes, I reckon that's about the size of it.
Don't mind my seeming excited; I'm not. Let us
change the subject. Now as to this castle, with forty-
five princesses in it, and three ogres at the head of it,
tell me -- where is this harem?"

"Harem?"

"The CASTLE, you understand; where is the castle?"

"Oh, as to that, it is great, and strong, and well beseen,
and lieth in a far country. Yes, it is many leagues."

"HOW many?"

"Ah, fair sir, it were woundily hard to tell, they
are so many, and do so lap the one upon the other,
and being made all in the same image and tincted with
the same color, one may not know the one league from
its fellow, nor how to count them except they be taken
apart, and ye wit well it were God's work to do that,
being not within man's capacity; for ye will note --"

"Hold on, hold on, never mind about the distance;
WHEREABOUTS does the castle lie? What's the direction
from here?"

"Ah, please you sir, it hath no direction from
here; by reason that the road lieth not straight, but
turneth evermore; wherefore the direction of its place
abideth not, but is some time under the one sky and
anon under another, whereso if ye be minded that it is
in the east, and wend thitherward, ye shall observe that
the way of the road doth yet again turn upon itself by
the space of half a circle, and this marvel happing
again and yet again and still again, it will grieve you
that you had thought by vanities of the mind to thwart
and bring to naught the will of Him that giveth not a
castle a direction from a place except it pleaseth Him,
and if it please Him not, will the rather that even all
castles and all directions thereunto vanish out of the
earth, leaving the places wherein they tarried desolate
and vacant, so warning His creatures that where He
will He will, and where He will not He --"

"Oh, that's all right, that's all right, give us a rest;
never mind about the direction, HANG the direction -- I
beg pardon, I beg a thousand pardons, I am not well
to-day; pay no attention when I soliloquize, it is an
old habit, an old, bad habit, and hard to get rid of
when one's digestion is all disordered with eating food
that was raised forever and ever before he was born;
good land! a man can't keep his functions regular on
spring chickens thirteen hundred years old. But come
-- never mind about that; let's -- have you got such
a thing as a map of that region about you? Now a
good map --"

"Is it peradventure that manner of thing which of
late the unbelievers have brought from over the great
seas, which, being boiled in oil, and an onion and salt
added thereto, doth --"

"What, a map? What are you talking about?
Don't you know what a map is? There, there, never
mind, don't explain, I hate explanations; they fog a
thing up so that you can't tell anything about it. Run
along, dear; good-day; show her the way, Clarence."

Oh, well, it was reasonably plain, now, why these
donkeys didn't prospect these liars for details. It
may be that this girl had a fact in her somewhere, but
I don't believe you could have sluiced it out with a
hydraulic; nor got it with the earlier forms of blasting,
even; it was a case for dynamite. Why, she was a
perfect ass; and yet the king and his knights had
listened to her as if she had been a leaf out of the
gospel. It kind of sizes up the whole party. And
think of the simple ways of this court: this wandering
wench hadn't any more trouble to get access to the
king in his palace than she would have had to get into
the poorhouse in my day and country. In fact, he
was glad to see her, glad to hear her tale; with that
adventure of hers to offer, she was as welcome as a
corpse is to a coroner.

Just as I was ending-up these reflections, Clarence
came back. I remarked upon the barren result of my
efforts with the girl; hadn't got hold of a single point
that could help me to find the castle. The youth
looked a little surprised, or puzzled, or something, and
intimated that he had been wondering to himself what
I had wanted to ask the girl all those questions for.

"Why, great guns," I said, "don't I want to find
the castle? And how else would I go about it?"

"La, sweet your worship, one may lightly answer
that, I ween. She will go with thee. They always
do. She will ride with thee."

"Ride with me? Nonsense!"

"But of a truth she will. She will ride with thee.
Thou shalt see."

"What? She browse around the hills and scour the
woods with me -- alone -- and I as good as engaged to
be married? Why, it's scandalous. Think how it
would look."

My, the dear face that rose before me! The boy
was eager to know all about this tender matter. I
swore him to secresy and then whispered her name --
"Puss Flanagan." He looked disappointed, and said
he didn't remember the countess. How natural it was
for the little courtier to give her a rank. He asked me
where she lived.

"In East Har--" I came to myself and stopped,
a little confused; then I said, "Never mind, now; I'll
tell you some time."

And might he see her? Would I let him see her
some day?

It was but a little thing to promise -- thirteen hun-
dred years or so -- and he so eager; so I said Yes.
But I sighed; I couldn't help it. And yet there was
no sense in sighing, for she wasn't born yet. But that
is the way we are made: we don't reason, where we
feel; we just feel.

My expedition was all the talk that day and that
night, and the boys were very good to me, and made
much of me, and seemed to have forgotten their vexa-
tion and disappointment, and come to be as anxious
for me to hive those ogres and set those ripe old vir-
gins loose as if it were themselves that had the con-
tract. Well, they WERE good children -- but just chil-
dren, that is all. And they gave me no end of points
about how to scout for giants, and how to scoop them
in; and they told me all sorts of charms against en-
chantments, and gave me salves and other rubbish to
put on my wounds. But it never occurred to one of
them to reflect that if I was such a wonderful necro-
mancer as I was pretending to be, I ought not to need
salves or instructions, or charms against enchantments,
and, least of all, arms and armor, on a foray of any
kind -- even against fire-spouting dragons, and devils
hot from perdition, let alone such poor adversaries as
these I was after, these commonplace ogres of the
back settlements.

I was to have an early breakfast, and start at dawn,
for that was the usual way; but I had the demon's
own time with my armor, and this delayed me a little.
It is troublesome to get into, and there is so much
detail. First you wrap a layer or two of blanket around
your body, for a sort of cushion and to keep off the
cold iron; then you put on your sleeves and shirt of
chain mail -- these are made of small steel links woven
together, and they form a fabric so flexible that if you
toss your shirt onto the floor, it slumps into a pile like
a peck of wet fish-net; it is very heavy and is nearly
the uncomfortablest material in the world for a night
shirt, yet plenty used it for that -- tax collectors, and
reformers, and one-horse kings with a defective title,
and those sorts of people; then you put on your shoes
-- flat-boats roofed over with interleaving bands of
steel -- and screw your clumsy spurs into the heels.
Next you buckle your greaves on your legs, and your
cuisses on your thighs; then come your backplate and
your breastplate, and you begin to feel crowded; then
you hitch onto the breastplate the half-petticoat of
broad overlapping bands of steel which hangs down in
front but is scolloped out behind so you can sit down,
and isn't any real improvement on an inverted coal
scuttle, either for looks or for wear, or to wipe your
hands on; next you belt on your sword; then you
put your stove-pipe joints onto your arms, your iron
gauntlets onto your hands, your iron rat-trap onto
your head, with a rag of steel web hitched onto it to
hang over the back of your neck -- and there you are,
snug as a candle in a candle-mould. This is no time
to dance. Well, a man that is packed away like that
is a nut that isn't worth the cracking, there is so little
of the meat, when you get down to it, by comparison
with the shell.

The boys helped me, or I never could have got in.
Just as we finished, Sir Bedivere happened in, and I
saw that as like as not I hadn't chosen the most con-
venient outfit for a long trip. How stately he looked;
and tall and broad and grand. He had on his head a
conical steel casque that only came down to his ears,
and for visor had only a narrow steel bar that extended
down to his upper lip and protected his nose; and all
the rest of him, from neck to heel, was flexible chain
mail, trousers and all. But pretty much all of him was
hidden under his outside garment, which of course was
of chain mail, as I said, and hung straight from his
shoulders to his ankles; and from his middle to the
bottom, both before and behind, was divided, so that
he could ride and let the skirts hang down on each
side. He was going grailing, and it was just the outfit
for it, too. I would have given a good deal for that
ulster, but it was too late now to be fooling around.
The sun was just up, the king and the court were all
on hand to see me off and wish me luck; so it wouldn't
be etiquette for me to tarry. You don't get on your
horse yourself; no, if you tried it you would get dis-
appointed. They carry you out, just as they carry a
sun-struck man to the drug store, and put you on, and
help get you to rights, and fix your feet in the stirrups;
and all the while you do feel so strange and stuffy and
like somebody else -- like somebody that has been mar-
ried on a sudden, or struck by lightning, or something
like that, and hasn't quite fetched around yet, and is sort
of numb, and can't just get his bearings. Then they
stood up the mast they called a spear, in its socket by
my left foot, and I gripped it with my hand; lastly
they hung my shield around my neck, and I was all
complete and ready to up anchor and get to sea.
Everybody was as good to me as they could be, and
a maid of honor gave me the stirrup-cup her own self.
There was nothing more to do now, but for that
damsel to get up behind me on a pillion, which she
did, and put an arm or so around me to hold on.

And so we started, and everybody gave us a good-
bye and waved their handkerchiefs or helmets. And
everybody we met, going down the hill and through
the village was respectful to us, except some shabby
little boys on the outskirts. They said:

"Oh, what a guy!" And hove clods at us.

In my experience boys are the same in all ages.
They don't respect anything, they don't care for any-
thing or anybody. They say "Go up, baldhead" to
the prophet going his unoffending way in the gray of
antiquity; they sass me in the holy gloom of the
Middle Ages; and I had seen them act the same way
in Buchanan's administration; I remember, because I
was there and helped. The prophet had his bears and
settled with his boys; and I wanted to get down and
settle with mine, but it wouldn't answer, because I
couldn't have got up again. I hate a country without
a derrick.


CHAPTER XII.
SLOW TORTURE

STRAIGHT off, we were in the country. It was
most lovely and pleasant in those sylvan solitudes
in the early cool morning in the first freshness of
autumn. From hilltops we saw fair green valleys lying
spread out below, with streams winding through them,
and island groves of trees here and there, and huge
lonely oaks scattered about and casting black blots of
shade; and beyond the valleys we saw the ranges of
hills, blue with haze, stretching away in billowy per-
spective to the horizon, with at wide intervals a dim
fleck of white or gray on a wave-summit, which we
knew was a castle. We crossed broad natural lawns
sparkling with dew, and we moved like spirits, the
cushioned turf giving out no sound of footfall; we
dreamed along through glades in a mist of green light
that got its tint from the sun-drenched roof of leaves
overhead, and by our feet the clearest and coldest of
runlets went frisking and gossiping over its reefs and
making a sort of whispering music, comfortable to hear;
and at times we left the world behind and entered into
the solemn great deeps and rich gloom of the forest,
where furtive wild things whisked and scurried by and
were gone before you could even get your eye on the
place where the noise was; and where only the earliest
birds were turning out and getting to business with a
song here and a quarrel yonder and a mysterious far-
off hammering and drumming for worms on a tree trunk
away somewhere in the impenetrable remotenesses of
the woods. And by and by out we would swing again
into the glare.

About the third or fourth or fifth time that we swung
out into the glare -- it was along there somewhere, a
couple of hours or so after sun-up -- it wasn't as pleas-
ant as it had been. It was beginning to get hot. This
was quite noticeable. We had a very long pull, after
that, without any shade. Now it is curious how
progressively little frets grow and multiply after they
once get a start. Things which I didn't mind at all,
at first, I began to mind now -- and more and more,
too, all the time. The first ten or fifteen times I wanted
my handkerchief I didn't seem to care; I got along,
and said never mind, it isn't any matter, and dropped
it out of my mind. But now it was different; I wanted
it all the time; it was nag, nag, nag, right along, and
no rest; I couldn't get it out of my mind; and so at
last I lost my temper and said hang a man that would
make a suit of armor without any pockets in it. You
see I had my handkerchief in my helmet; and some
other things; but it was that kind of a helmet that you
can't take off by yourself. That hadn't occurred to
me when I put it there; and in fact I didn't know it.
I supposed it would be particularly convenient there.
And so now, the thought of its being there, so handy
and close by, and yet not get-at-able, made it all the
worse and the harder to bear. Yes, the thing that you
can't get is the thing that you want, mainly; every one
has noticed that. Well, it took my mind off from every-
thing else; took it clear off, and centered it in my
helmet; and mile after mile, there it stayed, imagining
the handkerchief, picturing the handkerchief; and it
was bitter and aggravating to have the salt sweat keep
trickling down into my eyes, and I couldn't get at it.
It seems like a little thing, on paper, but it was not a
little thing at all; it was the most real kind of misery.
I would not say it if it was not so. I made up my
mind that I would carry along a reticule next time, let
it look how it might, and people say what they would.
Of course these iron dudes of the Round Table would
think it was scandalous, and maybe raise Sheol about
it, but as for me, give me comfort first, and style after-
wards. So we jogged along, and now and then we
struck a stretch of dust, and it would tumble up in
clouds and get into my nose and make me sneeze
and cry; and of course I said things I oughtn't to
have said, I don't deny that. I am not better than
others.

We couldn't seem to meet anybody in this lone-
some Britain, not even an ogre; and, in the mood I
was in then, it was well for the ogre; that is, an
ogre with a handkerchief. Most knights would have
thought of nothing but getting his armor; but so I
got his bandanna, he could keep his hardware, for all
of me.

Meantime, it was getting hotter and hotter in there.
You see, the sun was beating down and warming up the
iron more and more all the time. Well, when you are
hot, that way, every little thing irritates you. When I
trotted, I rattled like a crate of dishes, and that annoyed
me; and moreover I couldn't seem to stand that
shield slatting and banging, now about my breast, now
around my back; and if I dropped into a walk my
joints creaked and screeched in that wearisome way that
a wheelbarrow does, and as we didn't create any breeze
at that gait, I was like to get fried in that stove; and
besides, the quieter you went the heavier the iron set-
tled down on you and the more and more tons you
seemed to weigh every minute. And you had to be
always changing hands, and passing your spear over to
the other foot, it got so irksome for one hand to hold
it long at a time.

Well, you know, when you perspire that way, in
rivers, there comes a time when you -- when you --
well, when you itch. You are inside, your hands are
outside; so there you are; nothing but iron between.
It is not a light thing, let it sound as it may. First
it is one place; then another; then some more; and
it goes on spreading and spreading, and at last the ter-
ritory is all occupied, and nobody can imagine what
you feel like, nor how unpleasant it is. And when it
had got to the worst, and it seemed to me that I could
not stand anything more, a fly got in through the bars
and settled on my nose, and the bars were stuck and
wouldn't work, and I couldn't get the visor up; and I
could only shake my head, which was baking hot by
this time, and the fly -- well, you know how a fly acts
when he has got a certainty -- he only minded the
shaking enough to change from nose to lip, and lip to
ear, and buzz and buzz all around in there, and keep
on lighting and biting, in a way that a person, already
so distressed as I was, simply could not stand. So I
gave in, and got Alisande to unship the helmet and
relieve me of it. Then she emptied the conveniences
out of it and fetched it full of water, and I drank and
then stood up, and she poured the rest down inside the
armor. One cannot think how refreshing it was. She
continued to fetch and pour until I was well soaked
and thoroughly comfortable.

It was good to have a rest -- and peace. But nothing
is quite perfect in this life, at any time. I had made a
pipe a while back, and also some pretty fair tobacco;
not the real thing, but what some of the Indians use:
the inside bark of the willow, dried. These comforts
had been in the helmet, and now I had them again, but
no matches.

Gradually, as the time wore along, one annoying fact
was borne in upon my understanding -- that we were
weather-bound. An armed novice cannot mount his
horse without help and plenty of it. Sandy was not
enough; not enough for me, anyway. We had to wait
until somebody should come along. Waiting, in
silence, would have been agreeable enough, for I was
full of matter for reflection, and wanted to give it a
chance to work. I wanted to try and think out how it
was that rational or even half-rational men could ever
have learned to wear armor, considering its incon-
veniences; and how they had managed to keep up such
a fashion for generations when it was plain that what I
had suffered to-day they had had to suffer all the days
of their lives. I wanted to think that out; and more-
over I wanted to think out some way to reform this
evil and persuade the people to let the foolish fashion
die out; but thinking was out of the question in the
circumstances. You couldn't think, where Sandy
was.

She was a quite biddable creature and good-hearted,
but she had a flow of talk that was as steady as a mill,
and made your head sore like the drays and wagons in
a city. If she had had a cork she would have been a
comfort. But you can't cork that kind; they would
die. Her clack was going all day, and you would think
something would surely happen to her works, by and
by; but no, they never got out of order; and she
never had to slack up for words. She could grind,
and pump, and churn, and buzz by the week, and never
stop to oil up or blow out. And yet the result was
just nothing but wind. She never had any ideas, any
more than a fog has. She was a perfect blatherskite;
I mean for jaw, jaw, jaw, talk, talk, talk, jabber, jabber,
jabber; but just as good as she could be. I hadn't
minded her mill that morning, on account of having
that hornets' nest of other troubles; but more than
once in the afternoon I had to say:

"Take a rest, child; the way you are using up all
the domestic air, the kingdom will have to go to im-
porting it by to-morrow, and it's a low enough treasury
without that."


CHAPTER XIII.
FREEMEN

YES, it is strange how little a while at a time a per-
son can be contented. Only a little while back,
when I was riding and suffering, what a heaven this
peace, this rest, this sweet serenity in this secluded
shady nook by this purling stream would have seemed,
where I could keep perfectly comfortable all the time
by pouring a dipper of water into my armor now and
then; yet already I was getting dissatisfied; partly be-
cause I could not light my pipe -- for, although I had
long ago started a match factory, I had forgotten to
bring matches with me -- and partly because we had
nothing to eat. Here was another illustration of the
childlike improvidence of this age and people. A man
in armor always trusted to chance for his food on a
journey, and would have been scandalized at the idea
of hanging a basket of sandwiches on his spear. There
was probably not a knight of all the Round Table com-
bination who would not rather have died than been
caught carrying such a thing as that on his flagstaff.
And yet there could not be anything more sensible.
It had been my intention to smuggle a couple of sand-
wiches into my helmet, but I was interrupted in the act,
and had to make an excuse and lay them aside, and a
dog got them.

Night approached, and with it a storm. The dark-
ness came on fast. We must camp, of course. I
found a good shelter for the demoiselle under a rock,
and went off and found another for myself. But I was
obliged to remain in my armor, because I could not get
it off by myself and yet could not allow Alisande to
help, because it would have seemed so like undressing
before folk. It would not have amounted to that in
reality, because I had clothes on underneath; but the
prejudices of one's breeding are not gotten rid of just
at a jump, and I knew that when it came to stripping
off that bob-tailed iron petticoat I should be embarrassed.

With the storm came a change of weather; and the
stronger the wind blew, and the wilder the rain lashed
around, the colder and colder it got. Pretty soon,
various kinds of bugs and ants and worms and things
began to flock in out of the wet and crawl down in-
side my armor to get warm; and while some of them
behaved well enough, and snuggled up amongst my
clothes and got quiet, the majority were of a restless,
uncomfortable sort, and never stayed still, but went
on prowling and hunting for they did not know what;
especially the ants, which went tickling along in
wearisome procession from one end of me to the other
by the hour, and are a kind of creatures which I
never wish to sleep with again. It would be my advice
to persons situated in this way, to not roll or thrash
around, because this excites the interest of all the
different sorts of animals and makes every last one of
them want to turn out and see what is going on, and
this makes things worse than they were before, and of
course makes you objurgate harder, too, if you can.
Still, if one did not roll and thrash around he would
die; so perhaps it is as well to do one way as the other;
there is no real choice. Even after I was frozen solid
I could still distinguish that tickling, just as a corpse
does when he is taking electric treatment. I said I
would never wear armor after this trip.

All those trying hours whilst I was frozen and yet
was in a living fire, as you may say, on account of that
swarm of crawlers, that same unanswerable question
kept circling and circling through my tired head: How
do people stand this miserable armor? How have they
managed to stand it all these generations? How can
they sleep at night for dreading the tortures of next
day?

When the morning came at last, I was in a bad
enough plight: seedy, drowsy, fagged, from want of
sleep; weary from thrashing around, famished from
long fasting; pining for a bath, and to get rid of the
animals; and crippled with rheumatism. And how
had it fared with the nobly born, the titled aristocrat,
the Demoiselle Alisande la Carteloise? Why, she was
as fresh as a squirrel; she had slept like the dead; and
as for a bath, probably neither she nor any other noble
in the land had ever had one, and so she was not
missing it. Measured by modern standards, they were
merely modified savages, those people. This noble
lady showed no impatience to get to breakfast -- and
that smacks of the savage, too. On their journeys
those Britons were used to long fasts, and knew how to
bear them; and also how to freight up against probable
fasts before starting, after the style of the Indian and
the anaconda. As like as not, Sandy was loaded for a
three-day stretch.

We were off before sunrise, Sandy riding and I limp-
ing along behind. In half an hour we came upon a
group of ragged poor creatures who had assembled to
mend the thing which was regarded as a road. They
were as humble as animals to me; and when I pro-
posed to breakfast with them, they were so flattered, so
overwhelmed by this extraordinary condescension of
mine that at first they were not able to believe that I
was in earnest. My lady put up her scornful lip and
withdrew to one side; she said in their hearing that she
would as soon think of eating with the other cattle -- a
remark which embarrassed these poor devils merely be-
cause it referred to them, and not because it insulted or
offended them, for it didn't. And yet they were not
slaves, not chattels. By a sarcasm of law and phrase
they were freemen. Seven-tenths of the free popula-
tion of the country were of just their class and degree:
small "independent" farmers, artisans, etc.; which
is to say, they were the nation, the actual Nation;
they were about all of it that was useful, or worth sav-
ing, or really respect-worthy, and to subtract them would
have been to subtract the Nation and leave behind some
dregs, some refuse, in the shape of a king, nobility
and gentry, idle, unproductive, acquainted mainly with
the arts of wasting and destroying, and of no sort of
use or value in any rationally constructed world. And
yet, by ingenious contrivance, this gilded minority, in-
stead of being in the tail of the procession where it be-
longed, was marching head up and banners flying, at the
other end of it; had elected itself to be the Nation,
and these innumerable clams had permitted it so long
that they had come at last to accept it as a truth; and
not only that, but to believe it right and as it should
be. The priests had told their fathers and themselves
that this ironical state of things was ordained of God;
and so, not reflecting upon how unlike God it would
be to amuse himself with sarcasms, and especially such
poor transparent ones as this, they had dropped the
matter there and become respectfully quiet.

The talk of these meek people had a strange enough
sound in a formerly American ear. They were free-
men, but they could not leave the estates of their lord
or their bishop without his permission; they could not
prepare their own bread, but must have their corn
ground and their bread baked at his mill and his
bakery, and pay roundly for the same; they could not
sell a piece of their own property without paying him a
handsome percentage of the proceeds, nor buy a piece
of somebody else's without remembering him in cash
for the privilege; they had to harvest his grain for him
gratis, and be ready to come at a moment's notice,
leaving their own crop to destruction by the threatened
storm; they had to let him plant fruit trees in their
fields, and then keep their indignation to themselves
when his heedless fruit-gatherers trampled the grain
around the trees; they had to smother their anger when
his hunting parties galloped through their fields laying
waste the result of their patient toil; they were not
allowed to keep doves themselves, and when the swarms
from my lord's dovecote settled on their crops they
must not lose their temper and kill a bird, for awful
would the penalty be; when the harvest was at last
gathered, then came the procession of robbers to levy
their blackmail upon it: first the Church carted off its
fat tenth, then the king's commissioner took his twen-
tieth, then my lord's people made a mighty inroad
upon the remainder; after which, the skinned freeman
had liberty to bestow the remnant in his barn, in case
it was worth the trouble; there were taxes, and taxes,
and taxes, and more taxes, and taxes again, and yet
other taxes -- upon this free and independent pauper,
but none upon his lord the baron or the bishop, none
upon the wasteful nobility or the all-devouring Church;
if the baron would sleep unvexed, the freeman must sit
up all night after his day's work and whip the ponds to
keep the frogs quiet; if the freeman's daughter -- but
no, that last infamy of monarchical government is un-
printable; and finally, if the freeman, grown desperate
with his tortures, found his life unendurable under such
conditions, and sacrificed it and fled to death for mercy
and refuge, the gentle Church condemned him to
eternal fire, the gentle law buried him at midnight at the
cross-roads with a stake through his back, and his master
the baron or the bishop confiscated all his property and
turned his widow and his orphans out of doors.

And here were these freemen assembled in the early
morning to work on their lord the bishop's road three
days each -- gratis; every head of a family, and every
son of a family, three days each, gratis, and a day or
so added for their servants. Why, it was like reading
about France and the French, before the ever memor-
able and blessed Revolution, which swept a thousand
years of such villany away in one swift tidal-wave of
blood -- one: a settlement of that hoary debt in the
proportion of half a drop of blood for each hogshead
of it that had been pressed by slow tortures out of that
people in the weary stretch of ten centuries of wrong
and shame and misery the like of which was not to be
mated but in hell. There were two "Reigns of
Terror," if we would but remember it and consider it;
the one wrought murder in hot passion, the other in
heartless cold blood; the one lasted mere months, the
other had lasted a thousand years; the one inflicted
death upon ten thousand persons, the other upon a
hundred millions; but our shudders are all for the
"horrors" of the minor Terror, the momentary Ter-
ror, so to speak; whereas, what is the horror of swift
death by the axe, compared with lifelong death from
hunger, cold, insult, cruelty, and heart-break? What is
swift death by lightning compared with death by slow
fire at the stake? A city cemetery could contain the
coffins filled by that brief Terror which we have all been
so diligently taught to shiver at and mourn over; but
all France could hardly contain the coffins filled by that
older and real Terror -- that unspeakably bitter and
awful Terror which none of us has been taught to see
in its vastness or pity as it deserves.

These poor ostensible freemen who were sharing
their breakfast and their talk with me, were as full of
humble reverence for their king and Church and nobility
as their worst enemy could desire. There was some-
thing pitifully ludicrous about it. I asked them if they
supposed a nation of people ever existed, who, with a
free vote in every man's hand, would elect that a single
family and its descendants should reign over it forever,
whether gifted or boobies, to the exclusion of all other
families -- including the voter's; and would also elect
that a certain hundred families should be raised to dizzy
summits of rank, and clothed on with offensive trans-
missible glories and privileges to the exclusion of the
rest of the nation's families -- INCLUDING HIS OWN.

They all looked unhit, and said they didn't know;
that they had never thought about it before, and it
hadn't ever occurred to them that a nation could be so
situated that every man COULD have a say in the govern-
ment. I said I had seen one -- and that it would last
until it had an Established Church. Again they were
all unhit -- at first. But presently one man looked up
and asked me to state that proposition again; and state
it slowly, so it could soak into his understanding. I
did it; and after a little he had the idea, and he
brought his fist down and said HE didn't believe a
nation where every man had a vote would voluntarily
get down in the mud and dirt in any such way; and
that to steal from a nation its will and preference must
be a crime and the first of all crimes. I said to myself:

"This one's a man. If I were backed by enough of
his sort, I would make a strike for the welfare of this
country, and try to prove myself its loyalest citizen
by making a wholesome change in its system of
government."

You see my kind of loyalty was loyalty to one's
country, not to its institutions or its office-holders.
The country is the real thing, the substantial thing, the
eternal thing; it is the thing to watch over, and care
for, and be loyal to; institutions are extraneous, they
are its mere clothing, and clothing can wear out, be-
come ragged, cease to be comfortable, cease to protect
the body from winter, disease, and death. To be
loyal to rags, to shout for rags, to worship rags, to die
for rags -- that is a loyalty of unreason, it is pure
animal; it belongs to monarchy, was invented by
monarchy; let monarchy keep it. I was from Con-
necticut, whose Constitution declares "that all political
power is inherent in the people, and all free govern-
ments are founded on their authority and instituted for
their benefit; and that they have AT ALL TIMES an undeni-
able and indefeasible right to ALTER THEIR FORM OF GOVERN-
MENT in such a manner as they may think expedient."

Under that gospel, the citizen who thinks he sees
that the commonwealth's political clothes are worn out,
and yet holds his peace and does not agitate for a new
suit, is disloyal; he is a traitor. That he may be the
only one who thinks he sees this decay, does not ex-
cuse him; it is his duty to agitate anyway, and it is the
duty of the others to vote him down if they do not see
the matter as he does.

And now here I was, in a country where a right to
say how the country should be governed was restricted
to six persons in each thousand of its population.
For the nine hundred and ninety-four to express dis-
satisfaction with the regnant system and propose to
change it, would have made the whole six shudder as
one man, it would have been so disloyal, so dishonor-
able, such putrid black treason. So to speak, I was
become a stockholder in a corporation where nine hun-
dred and ninety-four of the members furnished all the
money and did all the work, and the other six elected
themselves a permanent board of direction and took all
the dividends. It seemed to me that what the nine
hundred and ninety-four dupes needed was a new deal.
The thing that would have best suited the circus side
of my nature would have been to resign the Boss-ship
and get up an insurrection and turn it into a revolution;
but I knew that the Jack Cade or the Wat Tyler who
tries such a thing without first educating his materials
up to revolution grade is almost absolutely certain to
get left. I had never been accustomed to getting left,
even if I do say it myself. Wherefore, the "deal"
which had been for some time working into shape
in my mind was of a quite different pattern from the
Cade-Tyler sort.

So I did not talk blood and insurrection to that man
there who sat munching black bread with that abused
and mistaught herd of human sheep, but took him
aside and talked matter of another sort to him. After
I had finished, I got him to lend me a little ink from
his veins; and with this and a sliver I wrote on a piece
of bark --

  Put him in the Man-factory --

and gave it to him, and said:

"Take it to the palace at Camelot and give it into
the hands of Amyas le Poulet, whom I call Clarence,
and he will understand."

"He is a priest, then," said the man, and some of
the enthusiasm went out of his face.

"How -- a priest? Didn't I tell you that no chattel
of the Church, no bond-slave of pope or bishop can
enter my Man-Factory? Didn't I tell you that YOU
couldn't enter unless your religion, whatever it might
be, was your own free property?"

"Marry, it is so, and for that I was glad; wherefore
it liked me not, and bred in me a cold doubt, to hear
of this priest being there."

"But he isn't a priest, I tell you."

The man looked far from satisfied. He said:

"He is not a priest, and yet can read?"

"He is not a priest and yet can read -- yes, and
write, too, for that matter. I taught him myself."
The man's face cleared. "And it is the first thing
that you yourself will be taught in that Factory --"

"I? I would give blood out of my heart to know
that art. Why, I will be your slave, your --"

"No you won't, you won't be anybody's slave.
Take your family and go along. Your lord the bishop
will confiscate your small property, but no matter.
Clarence will fix you all right."


CHAPTER XIV.
"DEFEND THEE, LORD"

I PAID three pennies for my breakfast, and a most
extravagant price it was, too, seeing that one could
have breakfasted a dozen persons for that money; but
I was feeling good by this time, and I had always been
a kind of spendthrift anyway; and then these people
had wanted to give me the food for nothing, scant as
their provision was, and so it was a grateful pleasure to
emphasize my appreciation and sincere thankfulness
with a good big financial lift where the money would
do so much more good than it would in my helmet,
where, these pennies being made of iron and not stinted
in weight, my half-dollar's worth was a good deal of a
burden to me. I spent money rather too freely in
those days, it is true; but one reason for it was that I
hadn't got the proportions of things entirely adjusted,
even yet, after so long a sojourn in Britain -- hadn't
got along to where I was able to absolutely realize that
a penny in Arthur's land and a couple of dollars in
Connecticut were about one and the same thing: just
twins, as you may say, in purchasing power. If my
start from Camelot could have been delayed a very few
days I could have paid these people in beautiful new
coins from our own mint, and that would have pleased
me; and them, too, not less. I had adopted the
American values exclusively. In a week or two now,
cents, nickels, dimes, quarters, and half-dollars, and
also a trifle of gold, would be trickling in thin but
steady streams all through the commercial veins of the
kingdom, and I looked to see this new blood freshen up
its life.

The farmers were bound to throw in something, to
sort of offset my liberality, whether I would or no; so
I let them give me a flint and steel; and as soon as
they had comfortably bestowed Sandy and me on our
horse, I lit my pipe. When the first blast of smoke
shot out through the bars of my helmet, all those
people broke for the woods, and Sandy went over
backwards and struck the ground with a dull thud.
They thought I was one of those fire-belching dragons
they had heard so much about from knights and other
professional liars. I had infinite trouble to persuade
those people to venture back within explaining distance.
Then I told them that this was only a bit of enchant-
ment which would work harm to none but my enemies.
And I promised, with my hand on my heart, that if all
who felt no enmity toward me would come forward and
pass before me they should see that only those who re-
mained behind would be struck dead. The procession
moved with a good deal of promptness. There were no
casualties to report, for nobody had curiosity enough
to remain behind to see what would happen.

I lost some time, now, for these big children, their
fears gone, became so ravished with wonder over my
awe-compelling fireworks that I had to stay there and
smoke a couple of pipes out before they would let me
go. Still the delay was not wholly unproductive, for
it took all that time to get Sandy thoroughly wonted to
the new thing, she being so close to it, you know. It
plugged up her conversation mill, too, for a consider-
able while, and that was a gain. But above all other
benefits accruing, I had learned something. I was
ready for any giant or any ogre that might come along,
now.

We tarried with a holy hermit, that night, and my
opportunity came about the middle of the next after-
noon. We were crossing a vast meadow by way of
short-cut, and I was musing absently, hearing nothing,
seeing nothing, when Sandy suddenly interrupted a re-
mark which she had begun that morning, with the cry:

"Defend thee, lord! -- peril of life is toward!"

And she slipped down from the horse and ran a little
way and stood. I looked up and saw, far off in the
shade of a tree, half a dozen armed knights and their
squires; and straightway there was bustle among them
and tightening of saddle-girths for the mount. My
pipe was ready and would have been lit, if I had not
been lost in thinking about how to banish oppression
from this land and restore to all its people their stolen
rights and manhood without disobliging anybody. I lit
up at once, and by the time I had got a good head of
reserved steam on, here they came. All together, too;
none of those chivalrous magnanimities which one
reads so much about -- one courtly rascal at a time, and
the rest standing by to see fair play. No, they came
in a body, they came with a whirr and a rush, they
came like a volley from a battery; came with heads low
down, plumes streaming out behind, lances advanced at
a level. It was a handsome sight, a beautiful sight --
for a man up a tree. I laid my lance in rest and waited,
with my heart beating, till the iron wave was just ready
to break over me, then spouted a column of white
smoke through the bars of my helmet. You should
have seen the wave go to pieces and scatter! This was
a finer sight than the other one.

But these people stopped, two or three hundred
yards away, and this troubled me. My satisfaction
collapsed, and fear came; I judged I was a lost man.
But Sandy was radiant; and was going to be eloquent --
but I stopped her, and told her my magic had mis-
carried, somehow or other, and she must mount, with
all despatch, and we must ride for life. No, she
wouldn't. She said that my enchantment had disabled
those knights; they were not riding on, because they
couldn't; wait, they would drop out of their saddles
presently, and we would get their horses and harness.
I could not deceive such trusting simplicity, so I said
it was a mistake; that when my fireworks killed at all,
they killed instantly; no, the men would not die, there
was something wrong about my apparatus, I couldn't
tell what; but we must hurry and get away, for those
people would attack us again, in a minute. Sandy
laughed, and said:

"Lack-a-day, sir, they be not of that breed! Sir
Launcelot will give battle to dragons, and will abide by
them, and will assail them again, and yet again, and
still again, until he do conquer and destroy them; and
so likewise will Sir Pellinore and Sir Aglovale and Sir
Carados, and mayhap others, but there be none else
that will venture it, let the idle say what the idle will.
And, la, as to yonder base rufflers, think ye they have
not their fill, but yet desire more?"

"Well, then, what are they waiting for? Why
don't they leave? Nobody's hindering. Good land,
I'm willing to let bygones be bygones, I'm sure."

"Leave, is it? Oh, give thyself easement as to that.
They dream not of it, no, not they. They wait to
yield them."

"Come -- really, is that 'sooth' -- as you people
say? If they want to, why don't they?"

"It would like them much; but an ye wot how
dragons are esteemed, ye would not hold them blam-
able. They fear to come."

"Well, then, suppose I go to them instead, and --"

"Ah, wit ye well they would not abide your coming.
I will go."

And she did. She was a handy person to have
along on a raid. I would have considered this a doubt-
ful errand, myself. I presently saw the knights riding
away, and Sandy coming back. That was a relief. I
judged she had somehow failed to get the first innings
-- I mean in the conversation; otherwise the interview
wouldn't have been so short. But it turned out that
she had managed the business well; in fact, admirably.
She said that when she told those people I was The
Boss, it hit them where they lived: "smote them sore
with fear and dread" was her word; and then they
were ready to put up with anything she might require.
So she swore them to appear at Arthur's court within
two days and yield them, with horse and harness, and
be my knights henceforth, and subject to my command.
How much better she managed that thing than I should
have done it myself! She was a daisy.


CHAPTER XV.
SANDY'S TALE

AND so I'm proprietor of some knights," said I,
as we rode off. "Who would ever have sup-
posed that I should live to list up assets of that sort.
I shan't know what to do with them; unless I raffle
them off. How many of them are there, Sandy?"

"Seven, please you, sir, and their squires."

"It is a good haul. Who are they? Where do they
hang out?"

"Where do they hang out?"

"Yes, where do they live?"

"Ah, I understood thee not. That will I tell
eftsoons." Then she said musingly, and softly, turn-
ing the words daintily over her tongue: "Hang they
out -- hang they out -- where hang -- where do they
hang out; eh, right so; where do they hang out. Of
a truth the phrase hath a fair and winsome grace, and
is prettily worded withal. I will repeat it anon and
anon in mine idlesse, whereby I may peradventure
learn it. Where do they hang out. Even so! already
it falleth trippingly from my tongue, and forasmuch
as --"

"Don't forget the cowboys, Sandy."

"Cowboys?"

"Yes; the knights, you know: You were going to
tell me about them. A while back, you remember.
Figuratively speaking, game's called."

"Game --"

"Yes, yes, yes! Go to the bat. I mean, get to
work on your statistics, and don't burn so much
kindling getting your fire started. Tell me about the
knights."

"I will well, and lightly will begin. So they two
departed and rode into a great forest. And --"

"Great Scott!"

You see, I recognized my mistake at once. I had
set her works a-going; it was my own fault; she would
be thirty days getting down to those facts. And she
generally began without a preface and finished without
a result. If you interrupted her she would either go
right along without noticing, or answer with a couple of
words, and go back and say the sentence over again.
So, interruptions only did harm; and yet I had to in-
terrupt, and interrupt pretty frequently, too, in order
to save my life; a person would die if he let her mo-
notony drip on him right along all day.

"Great Scott! " I said in my distress. She went
right back and began over again:

"So they two departed and rode into a great forest.
And --"

"WHICH two?"

"Sir Gawaine and Sir Uwaine. And so they came
to an abbey of monks, and there were well lodged. So
on the morn they heard their masses in the abbey, and
so they rode forth till they came to a great forest; then
was Sir Gawaine ware in a valley by a turret, of
twelve fair damsels, and two knights armed on great
horses, and the damsels went to and fro by a tree.
And then was Sir Gawaine ware how there hung a
white shield on that tree, and ever as the damsels came
by it they spit upon it, and some threw mire upon the
shield --"

"Now, if I hadn't seen the like myself in this country,
Sandy, I wouldn't believe it. But I've seen it, and I
can just see those creatures now, parading before that
shield and acting like that. The women here do cer-
tainly act like all possessed. Yes, and I mean your
best, too, society's very choicest brands. The hum-
blest hello-girl along ten thousand miles of wire could
teach gentleness, patience, modesty, manners, to the
highest duchess in Arthur's land."

"Hello-girl?"

"Yes, but don't you ask me to explain; it's a new
kind of a girl; they don't have them here; one often
speaks sharply to them when they are not the least in
fault, and he can't get over feeling sorry for it and
ashamed of himself in thirteen hundred years, it's such
shabby mean conduct and so unprovoked; the fact is,
no gentleman ever does it -- though I -- well, I myself,
if I've got to confess --"

"Peradventure she --"

"Never mind her; never mind her; I tell you I
couldn't ever explain her so you would understand."

"Even so be it, sith ye are so minded. Then Sir
Gawaine and Sir Uwaine went and saluted them, and
asked them why they did that despite to the shield.
Sirs, said the damsels, we shall tell you. There is a
knight in this country that owneth this white shield, and
he is a passing good man of his hands, but he hateth
all ladies and gentlewomen, and therefore we do all this
despite to the shield. I will say you, said Sir Gawaine,
it beseemeth evil a good knight to despise all ladies and
gentlewomen, and peradventure though he hate you he
hath some cause, and peradventure he loveth in some
other places ladies and gentlewomen, and to be loved
again, and he such a man of prowess as ye speak of --"

"Man of prowess -- yes, that is the man to please
them, Sandy. Man of brains -- that is a thing they
never think of. Tom Sayers -- John Heenan -- John
L. Sullivan -- pity but you could be here. You
would have your legs under the Round Table and a
'Sir' in front of your names within the twenty-four
hours; and you could bring about a new distribution
of the married princesses and duchesses of the Court in
another twenty-four. The fact is, it is just a sort of
polished-up court of Comanches, and there isn't a
squaw in it who doesn't stand ready at the dropping of
a hat to desert to the buck with the biggest string of
scalps at his belt."

"-- and he be such a man of prowess as ye speak of,
said Sir Gawaine. Now, what is his name? Sir, said
they, his name is Marhaus the king's son of Ireland."

"Son of the king of Ireland, you mean; the other
form doesn't mean anything. And look out and hold
on tight, now, we must jump this gully....
There, we are all right now. This horse belongs in the
circus; he is born before his time."

"I know him well, said Sir Uwaine, he is a passing
good knight as any is on live."

"ON LIVE. If you've got a fault in the world,
Sandy, it is that you are a shade too archaic. But it
isn't any matter."

"-- for I saw him once proved at a justs where many
knights were gathered, and that time there might no
man withstand him. Ah, said Sir Gawaine, damsels,
methinketh ye are to blame, for it is to suppose he that
hung that shield there will not be long therefrom, and
then may those knights match him on horseback, and
that is more your worship than thus; for I will abide
no longer to see a knight's shield dishonored. And
therewith Sir Uwaine and Sir Gawaine departed a little
from them, and then were they ware where Sir Marhaus
came riding on a great horse straight toward them.
And when the twelve damsels saw Sir Marhaus they
fled into the turret as they were wild, so that some of
them fell by the way. Then the one of the knights of
the tower dressed his shield, and said on high, Sir Mar-
haus defend thee. And so they ran together that the
knight brake his spear on Marhaus, and Sir Marhaus
smote him so hard that he brake his neck and the
horse's back --"

"Well, that is just the trouble about this state of
things, it ruins so many horses."

"That saw the other knight of the turret, and
dressed him toward Marhaus, and they went so eagerly
together, that the knight of the turret was soon smitten
down, horse and man, stark dead --"

"ANOTHER horse gone; I tell you it is a custom that
ought to be broken up. I don't see how people with
any feeling can applaud and support it."

....

"So these two knights came together with great
random --"

I saw that I had been asleep and missed a chapter,
but I didn't say anything. I judged that the Irish
knight was in trouble with the visitors by this time, and
this turned out to be the case.

"-- that Sir Uwaine smote Sir Marhaus that his
spear brast in pieces on the shield, and Sir Marhaus
smote him so sore that horse and man he bare to the
earth, and hurt Sir Uwaine on the left side --

"The truth is, Alisande, these archaics are a little
TOO simple; the vocabulary is too limited, and so, by
consequence, descriptions suffer in the matter of
variety; they run too much to level Saharas of fact,
and not enough to picturesque detail; this throws about
them a certain air of the monotonous; in fact the fights
are all alike: a couple of people come together with
great random -- random is a good word, and so is
exegesis, for that matter, and so is holocaust, and de-
falcation, and usufruct and a hundred others, but land!
a body ought to discriminate -- they come together
with great random, and a spear is brast, and one party
brake his shield and the other one goes down, horse
and man, over his horse-tail and brake his neck, and
then the next candidate comes randoming in, and brast
HIS spear, and the other man brast his shield, and
down HE goes, horse and man, over his horse-tail, and
brake HIS neck, and then there's another elected, and
another and another and still another, till the material
is all used up; and when you come to figure up results,
you can't tell one fight from another, nor who whip-
ped; and as a PICTURE, of living, raging, roaring battle,
sho! why, it's pale and noiseless -- just ghosts scuffling
in a fog. Dear me, what would this barren vocabulary
get out of the mightiest spectacle? -- the burning of
Rome in Nero's time, for instance? Why, it would
merely say, 'Town burned down; no insurance; boy
brast a window, fireman brake his neck!' Why, THAT
ain't a picture!"

It was a good deal of a lecture, I thought, but it
didn't disturb Sandy, didn't turn a feather; her steam
soared steadily up again, the minute I took off the lid:

"Then Sir Marhaus turned his horse and rode toward
Gawaine with his spear. And when Sir Gawaine saw
that, he dressed his shield, and they aventred their
spears, and they came together with all the might of
their horses, that either knight smote other so hard in
the midst of their shields, but Sir Gawaine's spear
brake --"

"I knew it would."

-- "but Sir Marhaus's spear held; and therewith Sir
Gawaine and his horse rushed down to the earth --"

"Just so -- and brake his back."

-- "and lightly Sir Gawaine rose upon his feet and
pulled out his sword, and dressed him toward Sir Mar-
haus on foot, and therewith either came unto other
eagerly, and smote together with their swords, that their
shields flew in cantels, and they bruised their helms and
their hauberks, and wounded either other. But Sir
Gawaine, fro it passed nine of the clock, waxed by the
space of three hours ever stronger and stronger. and
thrice his might was increased. All this espied Sir
Marhaus, and had great wonder how his might in-
creased, and so they wounded other passing sore; and
then when it was come noon --"

The pelting sing-song of it carried me forward to
scenes and sounds of my boyhood days:

"N-e-e-ew Haven! ten minutes for refreshments --
knductr'll strike the gong-bell two minutes before train
leaves -- passengers for the Shore line please take seats
in the rear k'yar, this k'yar don't go no furder -- AHH -
pls, AW-rnjz, b'NANners, S-A-N-D'ches, p--OP-corn!"

-- "and waxed past noon and drew toward even-
song. Sir Gawaine's strength feebled and waxed pass-
ing faint, that unnethes he might dure any longer, and
Sir Marhaus was then bigger and bigger --"

"Which strained his armor, of course; and yet little
would one of these people mind a small thing like that."

-- "and so, Sir Knight, said Sir Marhaus, I have
well felt that ye are a passing good knight, and a mar-
velous man of might as ever I felt any, while it lasteth,
and our quarrels are not great, and therefore it were a
pity to do you hurt, for I feel you are passing feeble.
Ah, said Sir Gawaine, gentle knight, ye say the word
that I should say. And therewith they took off their
helms and either kissed other, and there they swore
together either to love other as brethren --"

But I lost the thread there, and dozed off to slumber,
thinking about what a pity it was that men with such
superb strength -- strength enabling them to stand up
cased in cruelly burdensome iron and drenched with
perspiration, and hack and batter and bang each other
for six hours on a stretch -- should not have been
born at a time when they could put it to some useful
purpose. Take a jackass, for instance: a jackass has
that kind of strength, and puts it to a useful purpose,
and is valuable to this world because he is a jackass;
but a nobleman is not valuable because he is a jackass.
It is a mixture that is always ineffectual, and should
never have been attempted in the first place. And yet,
once you start a mistake, the trouble is done and you
never know what is going to come of it.

When I came to myself again and began to listen, I
perceived that I had lost another chapter, and that
Alisande had wandered a long way off with her people.

"And so they rode and came into a deep valley full
of stones, and thereby they saw a fair stream of water;
above thereby was the head of the stream, a fair foun-
tain, and three damsels sitting thereby. In this coun-
try, said Sir Marhaus, came never knight since it was
christened, but he found strange adventures --"

"This is not good form, Alisande. Sir Marhaus the
king's son of Ireland talks like all the rest; you ought
to give him a brogue, or at least a characteristic exple-
tive; by this means one would recognize him as soon
as he spoke, without his ever being named. It is a
common literary device with the great authors. You
should make him say, 'In this country, be jabers, came
never knight since it was christened, but he found
strange adventures, be jabers.' You see how much
better that sounds."

-- "came never knight but he found strange adven-
tures, be jabers. Of a truth it doth indeed, fair lord,
albeit 'tis passing hard to say, though peradventure
that will not tarry but better speed with usage. And
then they rode to the damsels, and either saluted other,
and the eldest had a garland of gold about her head,
and she was threescore winter of age or more --"

"The DAMSEL was?"

"Even so, dear lord -- and her hair was white under
the garland --"

"Celluloid teeth, nine dollars a set, as like as not --
the loose-fit kind, that go up and down like a portcullis
when you eat, and fall out when you laugh."

"The second damsel was of thirty winter of age,
with a circlet of gold about her head. The third damsel
was but fifteen year of age --"

Billows of thought came rolling over my soul, and
the voice faded out of my hearing!

Fifteen! Break -- my heart! oh, my lost darling!
Just her age who was so gentle, and lovely, and all the
world to me, and whom I shall never see again! How
the thought of her carries me back over wide seas of
memory to a vague dim time, a happy time, so many,
many centuries hence, when I used to wake in the soft
summer mornings, out of sweet dreams of her, and say
"Hello, Central!" just to hear her dear voice come
melting back to me with a "Hello, Hank!" that was
music of the spheres to my enchanted ear. She got
three dollars a week, but she was worth it.

I could not follow Alisande's further explanation of
who our captured knights were, now -- I mean in case
she should ever get to explaining who they were. My
interest was gone, my thoughts were far away, and sad.
By fitful glimpses of the drifting tale, caught here and
there and now and then, I merely noted in a vague way
that each of these three knights took one of these three
damsels up behind him on his horse, and one rode
north, another east, the other south, to seek adventures,
and meet again and lie, after year and day. Year and
day -- and without baggage. It was of a piece with
the general simplicity of the country.

The sun was now setting. It was about three in the
afternoon when Alisande had begun to tell me who the
cowboys were; so she had made pretty good progress
with it -- for her. She would arrive some time or
other, no doubt, but she was not a person who could
be hurried.

We were approaching a castle which stood on high
ground; a huge, strong, venerable structure, whose
gray towers and battlements were charmingly draped
with ivy, and whose whole majestic mass was drenched
with splendors flung from the sinking sun. It was the
largest castle we had seen, and so I thought it might be
the one we were after, but Sandy said no. She did
not know who owned it; she said she had passed it
without calling, when she went down to Camelot.


CHAPTER XVI.
MORGAN LE FAY

IF knights errant were to be believed, not all castles
were desirable places to seek hospitality in. As a
matter of fact, knights errant were NOT persons to be
believed -- that is, measured by modern standards of
veracity; yet, measured by the standards of their own
time, and scaled accordingly, you got the truth. It
was very simple: you discounted a statement ninety-
seven per cent.; the rest was fact. Now after making
this allowance, the truth remained that if I could find
out something about a castle before ringing the door-
bell -- I mean hailing the warders -- it was the sensible
thing to do. So I was pleased when I saw in the dis-
tance a horseman making the bottom turn of the road
that wound down from this castle.

As we approached each other, I saw that he wore a
plumed helmet, and seemed to be otherwise clothed in
steel, but bore a curious addition also -- a stiff square
garment like a herald's tabard. However, I had to
smile at my own forgetfulness when I got nearer and
read this sign on his tabard:

  "Persimmon's Soap -- All the Prime-Donna Use It."

That was a little idea of my own, and had several
wholesome purposes in view toward the civilizing and
uplifting of this nation. In the first place, it was a
furtive, underhand blow at this nonsense of knight
errantry, though nobody suspected that but me. I
had started a number of these people out -- the bravest
knights I could get -- each sandwiched between bul-
letin-boards bearing one device or another, and I
judged that by and by when they got to be numerous
enough they would begin to look ridiculous; and then,
even the steel-clad ass that HADN'T any board would
himself begin to look ridiculous because he was out of
the fashion.

Secondly, these missionaries would gradually, and
without creating suspicion or exciting alarm, introduce
a rudimentary cleanliness among the nobility, and from
them it would work down to the people, if the priests
could be kept quiet. This would undermine the
Church. I mean would be a step toward that. Next,
education -- next, freedom -- and then she would begin
to crumble. It being my conviction that any Estab-
lished Church is an established crime, an established
slave-pen, I had no scruples, but was willing to assail
it in any way or with any weapon that promised to
hurt it. Why, in my own former day -- in remote
centuries not yet stirring in the womb of time -- there
were old Englishmen who imagined that they had been
born in a free country: a "free" country with the
Corporation Act and the Test still in force in it --
timbers propped against men's liberties and dishonored
consciences to shore up an Established Anachronism
with.

My missionaries were taught to spell out the gilt
signs on their tabards -- the showy gilding was a neat
idea, I could have got the king to wear a bulletin-board
for the sake of that barbaric splendor -- they were to
spell out these signs and then explain to the lords and
ladies what soap was; and if the lords and ladies were
afraid of it, get them to try it on a dog. The mission-
ary's next move was to get the family together and try
it on himself; he was to stop at no experiment, how-
ever desperate. that could convince the nobility that
soap was harmless; if any final doubt remained, he
must catch a hermit -- the woods were full of them;
saints they called themselves, and saints they were be-
lieved to be. They were unspeakably holy, and worked
miracles, and everybody stood in awe of them. If a
hermit could survive a wash, and that failed to convince
a duke, give him up, let him alone.

Whenever my missionaries overcame a knight errant
on the road they washed him, and when he got well
they swore him to go and get a bulletin-board and dis-
seminate soap and civilization the rest of his days. As
a consequence the workers in the field were increasing
by degrees, and the reform was steadily spreading.
My soap factory felt the strain early. At first I had
only two hands; but before I had left home I was
already employing fifteen, and running night and day;
and the atmospheric result was getting so pronounced
that the king went sort of fainting and gasping around
and said he did not believe he could stand it much
longer, and Sir Launcelot got so that he did hardly
anything but walk up and down the roof and swear,
although I told him it was worse up there than any-
where else, but he said he wanted plenty of air; and
he was always complaining that a palace was no place
for a soap factory anyway, and said if a man was to
start one in his house he would be damned if he
wouldn't strangle him. There were ladies present,
too, but much these people ever cared for that; they
would swear before children, if the wind was their way
when the factory was going.

This missionary knight's name was La Cote Male
Taile, and he said that this castle was the abode of
Morgan le Fay, sister of King Arthur, and wife of
King Uriens. monarch of a realm about as big as the
District of Columbia -- you could stand in the middle
of it and throw bricks into the next kingdom.
"Kings" and "Kingdoms" were as thick in Britain
as they had been in little Palestine in Joshua's time,
when people had to sleep with their knees pulled up
because they couldn't stretch out without a passport.

La Cote was much depressed, for he had scored
here the worst failure of his campaign. He had not
worked off a cake; yet he had tried all the tricks of
the trade, even to the washing of a hermit; but the
hermit died. This was, indeed, a bad failure, for this
animal would now be dubbed a martyr, and would take
his place among the saints of the Roman calendar.
Thus made he his moan, this poor Sir La Cote Male
Taile, and sorrowed passing sore. And so my heart
bled for him, and I was moved to comfort and stay
him. Wherefore I said:

"Forbear to grieve, fair knight, for this is not a
defeat. We have brains, you and I; and for such as
have brains there are no defeats, but only victories.
Observe how we will turn this seeming disaster into an
advertisement; an advertisement for our soap; and
the biggest one, to draw, that was ever thought of; an
advertisement that will transform that Mount Washing-
ton defeat into a Matterhorn victory. We will put on
your bulletin-board, 'PATRONIZED BY THE ELECT.' How
does that strike you?"

"Verily, it is wonderly bethought!"

"Well, a body is bound to admit that for just a
modest little one-line ad., it's a corker."

So the poor colporteur's griefs vanished away. He
was a brave fellow, and had done mighty feats of arms
in his time. His chief celebrity rested upon the events
of an excursion like this one of mine, which he had
once made with a damsel named Maledisant, who was
as handy with her tongue as was Sandy, though in a
different way, for her tongue churned forth only rail-
ings and insult, whereas Sandy's music was of a
kindlier sort. I knew his story well, and so I knew
how to interpret the compassion that was in his face
when he bade me farewell. He supposed I was having
a bitter hard time of it.

Sandy and I discussed his story, as we rode along,
and she said that La Cote's bad luck had begun with
the very beginning of that trip; for the king's fool had
overthrown him on the first day, and in such cases it
was customary for the girl to desert to the conqueror,
but Maledisant didn't do it; and also persisted after-
ward in sticking to him, after all his defeats. But,
said I, suppose the victor should decline to accept his
spoil? She said that that wouldn't answer -- he must.
He couldn't decline; it wouldn't be regular. I made
a note of that. If Sandy's music got to be too
burdensome, some time, I would let a knight defeat
me, on the chance that she would desert to him.

In due time we were challenged by the warders,
from the castle walls, and after a parley admitted. I
have nothing pleasant to tell about that visit. But it
was not a disappointment, for I knew Mrs. le Fay by
reputation, and was not expecting anything pleasant.
She was held in awe by the whole realm, for she had
made everybody believe she was a great sorceress. All
her ways were wicked, all her instincts devilish. She
was loaded to the eyelids with cold malice. All her
history was black with crime; and among her crimes
murder was common. I was most curious to see her;
as curious as I could have been to see Satan. To my
surprise she was beautiful; black thoughts had failed
to make her expression repulsive, age had failed to
wrinkle her satin skin or mar its bloomy freshness.
She could have passed for old Uriens' granddaughter,
she could have been mistaken for sister to her own son.

As soon as we were fairly within the castle gates we
were ordered into her presence. King Uriens was
there, a kind-faced old man with a subdued look; and
also the son, Sir Uwaine le Blanchemains, in whom I
was, of course, interested on account of the tradition
that he had once done battle with thirty knights, and
also on account of his trip with Sir Gawaine and Sir
Marhaus, which Sandy had been aging me with. But
Morgan was the main attraction, the conspicuous per-
sonality here; she was head chief of this household,
that was plain. She caused us to be seated, and then
she began, with all manner of pretty graces and
graciousnesses, to ask me questions. Dear me, it was
like a bird or a flute, or something, talking. I felt
persuaded that this woman must have been misrepre-
sented, lied about. She trilled along, and trilled along,
and presently a handsome young page, clothed like the
rainbow, and as easy and undulatory of movement as a
wave, came with something on a golden salver, and,
kneeling to present it to her, overdid his graces and
lost his balance, and so fell lightly against her knee.
She slipped a dirk into him in as matter-of-course a
way as another person would have harpooned a rat!

Poor child! he slumped to the floor, twisted his silken
limbs in one great straining contortion of pain, and was
dead. Out of the old king was wrung an involuntary
"O-h!" of compassion. The look he got, made him
cut it suddenly short and not put any more hyphens in
it. Sir Uwaine, at a sign from his mother, went to
the anteroom and called some servants, and meanwhile
madame went rippling sweetly along with her talk.

I saw that she was a good housekeeper, for while
she talked she kept a corner of her eye on the servants
to see that they made no balks in handling the body
and getting it out; when they came with fresh clean
towels, she sent back for the other kind; and when
they had finished wiping the floor and were going, she
indicated a crimson fleck the size of a tear which their
duller eyes had overlooked. It was plain to me that
La Cote Male Taile had failed to see the mistress of
the house. Often, how louder and clearer than any
tongue, does dumb circumstantial evidence speak.

Morgan le Fay rippled along as musically as ever.
Marvelous woman. And what a glance she had: when
it fell in reproof upon those servants, they shrunk and
quailed as timid people do when the lightning flashes
out of a cloud. I could have got the habit myself. It
was the same with that poor old Brer Uriens; he was
always on the ragged edge of apprehension; she could
not even turn toward him but he winced.

In the midst of the talk I let drop a complimentary
word about King Arthur, forgetting for the moment
how this woman hated her brother. That one little
compliment was enough. She clouded up like
storm; she called for her guards, and said:

"Hale me these varlets to the dungeons."

That struck cold on my ears, for her dungeons had
a reputation. Nothing occurred to me to say -- or
do. But not so with Sandy. As the guard laid a
hand upon me, she piped up with the tranquilest con-
fidence, and said:

"God's wounds, dost thou covet destruction, thou
maniac? It is The Boss!"

Now what a happy idea that was! -- and so simple;
yet it would never have occurred to me. I was born
modest; not all over, but in spots; and this was one
of the spots.

The effect upon madame was electrical. It cleared
her countenance and brought back her smiles and all
her persuasive graces and blandishments; but never-
theless she was not able to entirely cover up with them
the fact that she was in a ghastly fright. She said:

"La, but do list to thine handmaid! as if one
gifted with powers like to mine might say the thing
which I have said unto one who has vanquished
Merlin, and not be jesting. By mine enchantments I
foresaw your coming, and by them I knew you when
you entered here. I did but play this little jest with
hope to surprise you into some display of your art, as
not doubting you would blast the guards with occult
fires, consuming them to ashes on the spot, a marvel
much beyond mine own ability, yet one which I have
long been childishly curious to see."

The guards were less curious, and got out as soon as
they got permission.


CHAPTER XVII.
A ROYAL BANQUET

MADAME, seeing me pacific and unresentful, no
doubt judged that I was deceived by her excuse;
for her fright dissolved away, and she was soon so
importunate to have me give an exhibition and kill
somebody, that the thing grew to be embarrassing.
However, to my relief she was presently interrupted by
the call to prayers. I will say this much for the
nobility: that, tyrannical, murderous, rapacious, and
morally rotten as they were, they were deeply and
enthusiastically religious. Nothing could divert them
from the regular and faithful performance of the pieties
enjoined by the Church. More than once I had seen
a noble who had gotten his enemy at a disadvantage,
stop to pray before cutting his throat; more than once
I had seen a noble, after ambushing and despatching
his enemy, retire to the nearest wayside shrine and
humbly give thanks, without even waiting to rob the
body. There was to be nothing finer or sweeter in the
life of even Benvenuto Cellini, that rough-hewn saint,
ten centuries later. All the nobles of Britain, with
their families, attended divine service morning and
night daily, in their private chapels, and even the
worst of them had family worship five or six times a
day besides. The credit of this belonged entirely to
the Church. Although I was no friend to that Cath-
olic Church, I was obliged to admit this. And often,
in spite of me, I found myself saying, "What would
this country be without the Church?"

After prayers we had dinner in a great banqueting
hall which was lighted by hundreds of grease-jets, and
everything was as fine and lavish and rudely splendid
as might become the royal degree of the hosts. At
the head of the hall, on a dais, was the table of the
king, queen, and their son, Prince Uwaine. Stretching
down the hall from this, was the general table, on the
floor. At this, above the salt, sat the visiting nobles
and the grown members of their families, of both
sexes, -- the resident Court, in effect -- sixty-one per-
sons; below the salt sat minor officers of the house-
hold, with their principal subordinates: altogether a
hundred and eighteen persons sitting, and about as
many liveried servants standing behind their chairs, or
serving in one capacity or another. It was a very fine
show. In a gallery a band with cymbals, horns, harps,
and other horrors, opened the proceedings with what
seemed to be the crude first-draft or original agony of
the wail known to later centuries as "In the Sweet
Bye and Bye." It was new, and ought to have been
rehearsed a little more. For some reason or other the
queen had the composer hanged, after dinner.

After this music, the priest who stood behind the
royal table said a noble long grace in ostensible Latin.
Then the battalion of waiters broke away from their
posts, and darted, rushed, flew, fetched and carried,
and the mighty feeding began; no words anywhere,
but absorbing attention to business. The rows of
chops opened and shut in vast unison, and the sound
of it was like to the muffled burr of subterranean
machinery.

The havoc continued an hour and a half, and unim-
aginable was the destruction of substantials. Of the
chief feature of the feast -- the huge wild boar that lay
stretched out so portly and imposing at the start --
nothing was left but the semblance of a hoop-skirt;
and he was but the type and symbol of what had hap-
pened to all the other dishes.

With the pastries and so on, the heavy drinking
began -- and the talk. Gallon after gallon of wine and
mead disappeared, and everybody got comfortable,
then happy, then sparklingly joyous -- both sexes, --
and by and by pretty noisy. Men told anecdotes that
were terrific to hear, but nobody blushed; and when
the nub was sprung, the assemblage let go with a
horse-laugh that shook the fortress. Ladies answered
back with historiettes that would almost have made
Queen Margaret of Navarre or even the great Elizabeth
of England hide behind a handkerchief, but nobody
hid here, but only laughed -- howled, you may say.
In pretty much all of these dreadful stories, ecclesiastics
were the hardy heroes, but that didn't worry the chap-
lain any, he had his laugh with the rest; more than
that, upon invitation he roared out a song which was
of as daring a sort as any that was sung that night.

By midnight everybody was fagged out, and sore
with laughing; and, as a rule, drunk: some weepingly,
some affectionately, some hilariously, some quarrel-
somely, some dead and under the table. Of the
ladies, the worst spectacle was a lovely young duch-
ess, whose wedding-eve this was; and indeed she was
a spectacle, sure enough. Just as she was she could
have sat in advance for the portrait of the young
daughter of the Regent d'Orleans, at the famous dinner
whence she was carried, foul-mouthed, intoxicated, and
helpless, to her bed, in the lost and lamented days of
the Ancient Regime.

Suddenly, even while the priest was lifting his hands,
and all conscious heads were bowed in reverent expec-
tation of the coming blessing, there appeared under
the arch of the far-off door at the bottom of the hall
an old and bent and white-haired lady, leaning upon a
crutch-stick; and she lifted the stick and pointed it
toward the queen and cried out:

"The wrath and curse of God fall upon you, woman
without pity, who have slain mine innocent grandchild
and made desolate this old heart that had nor chick, nor
friend nor stay nor comfort in all this world but him!"

Everybody crossed himself in a grisly fright, for a
curse was an awful thing to those people; but the
queen rose up majestic, with the death-light in her
eye, and flung back this ruthless command:

"Lay hands on her! To the stake with her!"

The guards left their posts to obey. It was a
shame; it was a cruel thing to see. What could be
done? Sandy gave me a look; I knew she had an-
other inspiration. I said:

"Do what you choose."

She was up and facing toward the queen in a mo-
ment. She indicated me, and said:

"Madame, HE saith this may not be. Recall the
commandment, or he will dissolve the castle and it
shall vanish away like the instable fabric of a dream!"

Confound it, what a crazy contract to pledge a per-
son to! What if the queen --

But my consternation subsided there, and my panic
passed off; for the queen, all in a collapse, made no
show of resistance but gave a countermanding sign and
sunk into her seat. When she reached it she was
sober. So were many of the others. The assemblage
rose, whiffed ceremony to the winds, and rushed for
the door like a mob; overturning chairs, smashing
crockery, tugging, struggling, shouldering, crowding
-- anything to get out before I should change my
mind and puff the castle into the measureless dim
vacancies of space. Well, well, well, they WERE a
superstitious lot. It is all a body can do to conceive
of it.

The poor queen was so scared and humbled that she
was even afraid to hang the composer without first
consulting me. I was very sorry for her -- indeed, any
one would have been, for she was really suffering; so
I was willing to do anything that was reasonable, and
had no desire to carry things to wanton extremities. I
therefore considered the matter thoughtfully, and ended
by having the musicians ordered into our presence to
play that Sweet Bye and Bye again, which they did.
Then I saw that she was right, and gave her permission
to hang the whole band. This little relaxation of
sternness had a good effect upon the queen. A states-
man gains little by the arbitrary exercise of iron-clad
authority upon all occasions that offer, for this wounds
the just pride of his subordinates, and thus tends to
undermine his strength. A little concession, now and
then, where it can do no harm, is the wiser policy.

Now that the queen was at ease in her mind once
more, and measurably happy, her wine naturally began
to assert itself again, and it got a little the start of her.
I mean it set her music going -- her silver bell of a
tongue. Dear me, she was a master talker. It would
not become me to suggest that it was pretty late and
that I was a tired man and very sleepy. I wished I
had gone off to bed when I had the chance. Now I
must stick it out; there was no other way. So she
tinkled along and along, in the otherwise profound and
ghostly hush of the sleeping castle, until by and by
there came, as if from deep down under us, a far-away
sound, as of a muffled shriek -- with an expression of
agony about it that made my flesh crawl. The queen
stopped, and her eyes lighted with pleasure; she tilted
her graceful head as a bird does when it listens. The
sound bored its way up through the stillness again.

"What is it?" I said.

"It is truly a stubborn soul, and endureth long. It
is many hours now."

"Endureth what?"

"The rack. Come -- ye shall see a blithe sight.
An he yield not his secret now, ye shall see him torn
asunder."

What a silky smooth hellion she was; and so com-
posed and serene, when the cords all down my legs
were hurting in sympathy with that man's pain. Con-
ducted by mailed guards bearing flaring torches, we
tramped along echoing corridors, and down stone stair-
ways dank and dripping, and smelling of mould and
ages of imprisoned night -- a chill, uncanny journey
and a long one, and not made the shorter or the
cheerier by the sorceress's talk, which was about this
sufferer and his crime. He had been accused by an
anonymous informer, of having killed a stag in the
royal preserves. I said:

"Anonymous testimony isn't just the right thing,
your Highness. It were fairer to confront the accused
with the accuser."

"I had not thought of that, it being but of small
consequence. But an I would, I could not, for that
the accuser came masked by night, and told the
forester, and straightway got him hence again, and so
the forester knoweth him not."

"Then is this Unknown the only person who saw
the stag killed?"

"Marry, NO man SAW the killing, but this Unknown
saw this hardy wretch near to the spot where the stag
lay, and came with right loyal zeal and betrayed him
to the forester."

"So the Unknown was near the dead stag, too?
Isn't it just possible that he did the killing himself?
His loyal zeal -- in a mask -- looks just a shade sus-
picious. But what is your highness's idea for racking
the prisoner? Where is the profit?"

"He will not confess, else; and then were his soul
lost. For his crime his life is forfeited by the law --
and of a surety will I see that he payeth it! -- but it
were peril to my own soul to let him die unconfessed
and unabsolved. Nay, I were a fool to fling me into
hell for HIS accommodation."

"But, your Highness, suppose he has nothing to
confess?"

"As to that, we shall see, anon. An I rack him to
death and he confess not, it will peradventure show
that he had indeed naught to confess -- ye will grant
that that is sooth? Then shall I not be damned for
an unconfessed man that had naught to confess --
wherefore, I shall be safe."

It was the stubborn unreasoning of the time. It was
useless to argue with her. Arguments have no chance
against petrified training; they wear it as little as the
waves wear a cliff. And her training was everybody's.
The brightest intellect in the land would not have been
able to see that her position was defective.

As we entered the rack-cell I caught a picture that
will not go from me; I wish it would. A native young
giant of thirty or thereabouts lay stretched upon the
frame on his back, with his wrists and ankles tied to
ropes which led over windlasses at either end. There
was no color in him; his features were contorted and
set, and sweat-drops stood upon his forehead. A
priest bent over him on each side; the executioner
stood by; guards were on duty; smoking torches
stood in sockets along the walls; in a corner crouched
a poor young creature, her face drawn with anguish,
a half-wild and hunted look in her eyes, and in her lap
lay a little child asleep. Just as we stepped across the
threshold the executioner gave his machine a slight
turn, which wrung a cry from both the prisoner and
the woman; but I shouted, and the executioner released
the strain without waiting to see who spoke. I could
not let this horror go on; it would have killed me to
see it. I asked the queen to let me clear the place
and speak to the prisoner privately; and when she was
going to object I spoke in a low voice and said I did
not want to make a scene before her servants, but I
must have my way; for I was King Arthur's repre-
sentative, and was speaking in his name. She saw she
had to yield. I asked her to indorse me to these peo-
ple, and then leave me. It was not pleasant for her,
but she took the pill; and even went further than I
was meaning to require. I only wanted the backing of
her own authority; but she said:

"Ye will do in all things as this lord shall command.
It is The Boss."

It was certainly a good word to conjure with: you
could see it by the squirming of these rats. The
queen's guards fell into line, and she and they marched
away, with their torch-bearers, and woke the echoes of
the cavernous tunnels with the measured beat of their
retreating footfalls. I had the prisoner taken from
the rack and placed upon his bed, and medicaments
applied to his hurts, and wine given him to drink.
The woman crept near and looked on, eagerly, lov-
ingly, but timorously, -- like one who fears a repulse;
indeed, she tried furtively to touch the man's forehead,
and jumped back, the picture of fright, when I turned
unconsciously toward her. It was pitiful to see.

"Lord," I said, "stroke him, lass, if you want to.
Do anything you're a mind to; don't mind me."

Why, her eyes were as grateful as an animal's, when
you do it a kindness that it understands. The baby
was out of her way and she had her cheek against the
man's in a minute. and her hands fondling his hair,
and her happy tears running down. The man revived
and caressed his wife with his eyes, which was all he
could do. I judged I might clear the den, now, and I
did; cleared it of all but the family and myself. Then
I said:

"Now, my friend, tell me your side of this matter;
I know the other side."

The man moved his head in sign of refusal. But
the woman looked pleased -- as it seemed to me --
pleased with my suggestion. I went on --

"You know of me?"

"Yes. All do, in Arthur's realms."

"If my reputation has come to you right and
straight, you should not be afraid to speak."

The woman broke in, eagerly:

"Ah, fair my lord, do thou persuade him! Thou
canst an thou wilt. Ah, he suffereth so; and it is for
me -- for ME! And how can I bear it? I would I
might see him die -- a sweet, swift death; oh, my
Hugo, I cannot bear this one!"

And she fell to sobbing and grovelling about my
feet, and still imploring. Imploring what? The man's
death? I could not quite get the bearings of the thing.
But Hugo interrupted her and said:

"Peace! Ye wit not what ye ask. Shall I starve
whom I love, to win a gentle death? I wend thou
knewest me better."

"Well," I said, "I can't quite make this out. It
is a puzzle. Now --"

"Ah, dear my lord, an ye will but persuade him!
Consider how these his tortures wound me! Oh, and
he will not speak! -- whereas, the healing, the solace
that lie in a blessed swift death --"

"What ARE you maundering about? He's going out
from here a free man and whole -- he's not going to
die."

The man's white face lit up, and the woman flung
herself at me in a most surprising explosion of joy,
and cried out:

"He is saved! -- for it is the king's word by the
mouth of the king's servant -- Arthur, the king whose
word is gold!"

"Well, then you do believe I can be trusted, after
all. Why didn't you before?"

"Who doubted? Not I, indeed; and not she."

"Well, why wouldn't you tell me your story, then?"

"Ye had made no promise; else had it been other-
wise."

"I see, I see.... And yet I believe I don't quite
see, after all. You stood the torture and refused to
confess; which shows plain enough to even the dull-
est understanding that you had nothing to confess --"

"I, my lord? How so? It was I that killed the
deer!"

"You DID? Oh, dear, this is the most mixed-up
business that ever --"

"Dear lord, I begged him on my knees to confess,
but --"

"You DID! It gets thicker and thicker. What did
you want him to do that for?"

"Sith it would bring him a quick death and save
him all this cruel pain."

"Well -- yes, there is reason in that. But HE didn't
want the quick death."

"He? Why, of a surety he DID."

"Well, then, why in the world DIDN'T he confess?"

"Ah, sweet sir, and leave my wife and chick with-
out bread and shelter?"

"Oh, heart of gold, now I see it! The bitter law
takes the convicted man's estate and beggars his widow
and his orphans. They could torture you to death,
but without conviction or confession they could not
rob your wife and baby. You stood by them like a
man; and YOU -- true wife and the woman that you
are -- you would have bought him release from torture
at cost to yourself of slow starvation and death -- well,
it humbles a body to think what your sex can do when
it comes to self-sacrifice. I'll book you both for my
colony; you'll like it there; it's a Factory where I'm
going to turn groping and grubbing automata into
MEN."


CHAPTER XVIII.
IN THE QUEEN'S DUNGEONS

WELL, I arranged all that; and I had the man sent
to his home. I had a great desire to rack the
executioner; not because he was a good, painstaking
and paingiving official, -- for surely it was not to his
discredit that he performed his functions well -- but to
pay him back for wantonly cuffing and otherwise dis-
tressing that young woman. The priests told me about
this, and were generously hot to have him punished.
Something of this disagreeable sort was turning up
every now and then. I mean, episodes that showed
that not all priests were frauds and self-seekers, but
that many, even the great majority, of these that were
down on the ground among the common people, were
sincere and right-hearted, and devoted to the alleviation
of human troubles and sufferings. Well, it was a thing
which could not be helped, so I seldom fretted about
it, and never many minutes at a time; it has never
been my way to bother much about things which you
can't cure. But I did not like it, for it was just the
sort of thing to keep people reconciled to an Estab-
lished Church. We MUST have a religion -- it goes
without saying -- but my idea is, to have it cut up into
forty free sects, so that they will police each other, as
had been the case in the United States in my time.
Concentration of power in a political machine is bad;
and and an Established Church is only a political machine;
it was invented for that; it is nursed, cradled, pre-
served for that; it is an enemy to human liberty, and
does no good which it could not better do in a split-up
and scattered condition. That wasn't law; it wasn't
gospel: it was only an opinion -- my opinion, and I
was only a man, one man: so it wasn't worth any
more than the pope's -- or any less, for that matter.

Well, I couldn't rack the executioner, neither would
I overlook the just complaint of the priests. The man
must be punished somehow or other, so I degraded
him from his office and made him leader of the band
-- the new one that was to be started. He begged
hard, and said he couldn't play -- a plausible excuse,
but too thin; there wasn't a musician in the country
that could.

The queen was a good deal outraged, next morning
when she found she was going to have neither Hugo's
life nor his property. But I told her she must bear
this cross; that while by law and custom she certainly
was entitled to both the man's life and his property,
there were extenuating circumstances, and so in Arthur
the king's name I had pardoned him. The deer was
ravaging the man's fields, and he had killed it in sud-
den passion, and not for gain; and he had carried it
into the royal forest in the hope that that might make
detection of the misdoer impossible. Confound her, I
couldn't make her see that sudden passion is an ex-
tenuating circumstance in the killing of venison -- or
of a person -- so I gave it up and let her sulk it out
I DID think I was going to make her see it by remark-
ing that her own sudden passion in the case of the
page modified that crime.

"Crime!" she exclaimed. "How thou talkest!
Crime, forsooth! Man, I am going to PAY for him!"

Oh, it was no use to waste sense on her. Training
-- training is everything; training is all there is TO a
person. We speak of nature; it is folly; there is no
such thing as nature; what we call by that misleading
name is merely heredity and training. We have no
thoughts of our own, no opinions of our own; they
are transmitted to us, trained into us. All that is
original in us, and therefore fairly creditable or dis-
creditable to us, can be covered up and hidden by the
point of a cambric needle, all the rest being atoms
contributed by, and inherited from, a procession of
ancestors that stretches back a billion years to the
Adam-clam or grasshopper or monkey from whom our
race has been so tediously and ostentatiously and un-
profitably developed. And as for me, all that I think
about in this plodding sad pilgrimage, this pathetic
drift between the eternities, is to look out and humbly
live a pure and high and blameless life, and save that
one microscopic atom in me that is truly ME: the rest
may land in Sheol and welcome for all I care.

No, confound her, her intellect was good, she had
brains enough, but her training made her an ass -- that
is, from a many-centuries-later point of view. To kill
the page was no crime -- it was her right; and upon
her right she stood, serenely and unconscious of
offense. She was a result of generations of training
in the unexamined and unassailed belief that the law
which permitted her to kill a subject when she chose
was a perfectly right and righteous one.

Well, we must give even Satan his due. She de-
served a compliment for one thing; and I tried to pay
it, but the words stuck in my throat. She had a right
to kill the boy, but she was in no wise obliged to pay
for him. That was law for some other people, but
not for her. She knew quite well that she was doing a
large and generous thing to pay for that lad, and that
I ought in common fairness to come out with some-
thing handsome about it, but I couldn't -- my mouth
refused. I couldn't help seeing, in my fancy, that
poor old grandma with the broken heart, and that fair
young creature lying butchered, his little silken pomps
and vanities laced with his golden blood. How could
she PAY for him! WHOM could she pay? And so,
well knowing that this woman, trained as she had been,
deserved praise, even adulation, I was yet not able to
utter it, trained as I had been. The best I could do
was to fish up a compliment from outside, so to speak
-- and the pity of it was, that it was true:

"Madame, your people will adore you for this."

Quite true, but I meant to hang her for it some day
if I lived. Some of those laws were too bad, altogether
too bad. A master might kill his slave for nothing --
for mere spite, malice, or to pass the time -- just as
we have seen that the crowned head could do it with
HIS slave, that is to say, anybody. A gentleman could
kill a free commoner, and pay for him -- cash or
garden-truck. A noble could kill a noble without ex-
pense, as far as the law was concerned, but reprisals in
kind were to be expected. ANYbody could kill SOME-
body, except the commoner and the slave; these had
no privileges. If they killed, it was murder, and the
law wouldn't stand murder. It made short work of
the experimenter -- and of his family, too, if he mur-
dered somebody who belonged up among the orna-
mental ranks. If a commoner gave a noble even so
much as a Damiens-scratch which didn't kill or even
hurt, he got Damiens' dose for it just the same; they
pulled him to rags and tatters with horses, and all the
world came to see the show, and crack jokes, and have
a good time; and some of the performances of the
best people present were as tough, and as properly
unprintable, as any that have been printed by the
pleasant Casanova in his chapter about the dismember-
ment of Louis XV.'s poor awkward enemy.

I had had enough of this grisly place by this time,
and wanted to leave, but I couldn't, because I had
something on my mind that my conscience kept prod-
ding me about, and wouldn't let me forget. If I had
the remaking of man, he wouldn't have any conscience.
It is one of the most disagreeable things connected
with a person; and although it certainly does a great
deal of good, it cannot be said to pay, in the long run;
it would be much better to have less good and more
comfort. Still, this is only my opinion, and I am only
one man; others, with less experience, may think
differently. They have a right to their view. I only
stand to this: I have noticed my conscience for many
years, and I know it is more trouble and bother to me
than anything else I started with. I suppose that in
the beginning I prized it, because we prize anything
that is ours; and yet how foolish it was to think so.
If we look at it in another way, we see how absurd it
is: if I had an anvil in me would I prize it? Of course
not. And yet when you come to think, there is no
real difference between a conscience and an anvil -- I
mean for comfort. I have noticed it a thousand times.
And you could dissolve an anvil with acids, when you
couldn't stand it any longer; but there isn't any way
that you can work off a conscience -- at least so it will
stay worked off; not that I know of, anyway.

There was something I wanted to do before leaving,
but it was a disagreeable matter, and I hated to go at
it. Well, it bothered me all the morning. I could
have mentioned it to the old king, but what would be
the use? -- he was but an extinct volcano; he had
been active in his time, but his fire was out, this good
while, he was only a stately ash-pile now; gentle
enough, and kindly enough for my purpose, without
doubt, but not usable. He was nothing, this so-called
king: the queen was the only power there. And she
was a Vesuvius. As a favor, she might consent to
warm a flock of sparrows for you, but then she might
take that very opportunity to turn herself loose and
bury a city. However, I reflected that as often as any
other way, when you are expecting the worst, you get
something that is not so bad, after all.

So I braced up and placed my matter before her
royal Highness. I said I had been having a general
jail-delivery at Camelot and among neighboring castles,
and with her permission I would like to examine her
collection, her bric-a-brac -- that is to say, her prison-
ers. She resisted; but I was expecting that. But she
finally consented. I was expecting that, too, but not
so soon. That about ended my discomfort. She
called her guards and torches, and we went down into
the dungeons. These were down under the castle's
foundations, and mainly were small cells hollowed out
of the living rock. Some of these cells had no light at
all. In one of them was a woman, in foul rags, who
sat on the ground, and would not answer a question or
speak a word, but only looked up at us once or twice,
through a cobweb of tangled hair, as if to see what
casual thing it might be that was disturbing with sound
and light the meaningless dull dream that was become
her life; after that, she sat bowed, with her dirt-caked
fingers idly interlocked in her lap, and gave no further
sign. This poor rack of bones was a woman of middle
age, apparently; but only apparently; she had been
there nine years, and was eighteen when she entered.
She was a commoner, and had been sent here on her
bridal night by Sir Breuse Sance Pite, a neighboring
lord whose vassal her father was, and to which said
lord she had refused what has since been called le droit
du seigneur, and, moreover, had opposed violence to
violence and spilt half a gill of his almost sacred blood.
The young husband had interfered at that point. be-
lieving the bride's life in danger, and had flung the
noble out into the midst of the humble and trembling
wedding guests, in the parlor, and left him there aston-
ished at this strange treatment, and implacably embit-
tered against both bride and groom. The said lord
being cramped for dungeon-room had asked the queen
to accommodate his two criminals, and here in her
bastile they had been ever since; hither, indeed, they
had come before their crime was an hour old, and had
never seen each other since. Here they were, ken-
neled like toads in the same rock; they had passed
nine pitch dark years within fifty feet of each other,
yet neither knew whether the other was alive or not.
All the first years, their only question had been --
asked with beseechings and tears that might have
moved stones, in time, perhaps, but hearts are not
stones: "Is he alive?" "Is she alive?" But they
had never got an answer; and at last that question was
not asked any more -- or any other.

I wanted to see the man, after hearing all this. He
was thirty-four years old, and looked sixty. He sat
upon a squared block of stone, with his head bent
down, his forearms resting on his knees, his long hair
hanging like a fringe before his face, and he was
muttering to himself. He raised his chin and looked
us slowly over, in a listless dull way, blinking with the
distress of the torchlight, then dropped his head and
fell to muttering again and took no further notice of
us. There were some pathetically suggestive dumb
witnesses present. On his wrists and ankles were
cicatrices, old smooth scars, and fastened to the stone
on which he sat was a chain with manacles and fetters
attached; but this apparatus lay idle on the ground,
and was thick with rust. Chains cease to be needed
after the spirit has gone out of a prisoner.

I could not rouse the man; so I said we would take
him to her, and see -- to the bride who was the fairest
thing in the earth to him, once -- roses, pearls, and dew
made flesh, for him; a wonder-work, the master-work
of nature: with eyes like no other eyes, and voice like
no other voice, and a freshness, and lithe young grace,
and beauty, that belonged properly to the creatures of
dreams -- as he thought -- and to no other. The sight
of her would set his stagnant blood leaping; the sight
of her --

But it was a disappointment. They sat together on
the ground and looked dimly wondering into each
other's faces a while, with a sort of weak animal curi-
osity; then forgot each other's presence, and dropped
their eyes, and you saw that they were away again and
wandering in some far land of dreams and shadows
that we know nothing about.

I had them taken out and sent to their friends. The
queen did not like it much. Not that she felt any
personal interest in the matter, but she thought it dis-
respectful to Sir Breuse Sance Pite. However, I
assured her that if he found he couldn't stand it I
would fix him so that he could.

I set forty-seven prisoners loose out of those awful
rat-holes, and left only one in captivity. He was a
lord, and had killed another lord, a sort of kinsman of
the queen. That other lord had ambushed him to
assassinate him, but this fellow had got the best of him
and cut his throat. However, it was not for that that
I left him jailed, but for maliciously destroying the
only public well in one of his wretched villages. The
queen was bound to hang him for killing her kinsman,
but I would not allow it: it was no crime to kill an
assassin. But I said I was willing to let her hang him
for destroying the well; so she concluded to put up
with that, as it was better than nothing.

Dear me, for what trifling offenses the most of those
forty-seven men and women were shut up there! In-
deed, some were there for no distinct offense at all,
but only to gratify somebody's spite; and not always
the queen's by any means, but a friend's. The newest
prisoner's crime was a mere remark which he had
made. He said he believed that men were about all
alike, and one man as good as another, barring clothes.
He said he believed that if you were to strip the nation
naked and send a stranger through the crowd, he
couldn't tell the king from a quack doctor, nor a duke
from a hotel clerk. Apparently here was a man whose
brains had not been reduced to an ineffectual mush by
idiotic training. I set him loose and sent him to the
Factory.

Some of the cells carved in the living rock were just
behind the face of the precipice, and in each of these
an arrow-slit had been pierced outward to the daylight,
and so the captive had a thin ray from the blessed sun
for his comfort. The case of one of these poor fel-
lows was particularly hard. From his dusky swallow's
hole high up in that vast wall of native rock he could
peer out through the arrow-slit and see his own home
off yonder in the valley; and for twenty-two years he
had watched it, with heartache and longing, through
that crack. He could see the lights shine there at
night, and in the daytime he could see figures go in
and come out -- his wife and children, some of them,
no doubt, though he could not make out at that dis-
tance. In the course of years he noted festivities
there, and tried to rejoice, and wondered if they were
weddings or what they might be. And he noted
funerals; and they wrung his heart. He could make
out the coffin, but he could not determine its size, and
so could not tell whether it was wife or child. He
could see the procession form, with priests and mourn-
ers, and move solemnly away, bearing the secret with
them. He had left behind him five children and a
wife; and in nineteen years he had seen five funerals
issue, and none of them humble enough in pomp to
denote a servant. So he had lost five of his treasures;
there must still be one remaining -- one now infinitely,
unspeakably precious, -- but WHICH one? wife, or child?
That was the question that tortured him, by night and
by day, asleep and awake. Well, to have an interest,
of some sort, and half a ray of light, when you are in
a dungeon, is a great support to the body and preserver
of the intellect. This man was in pretty good condi-
tion yet. By the time he had finished telling me his
distressful tale, I was in the same state of mind that
you would have been in yourself, if you have got
average human curiosity; that is to say, I was as
burning up as he was to find out which member of
the family it was that was left. So I took him over
home myself; and an amazing kind of a surprise party
it was, too -- typhoons and cyclones of frantic joy,
and whole Niagaras of happy tears; and by George!
we found the aforetime young matron graying toward
the imminent verge of her half century, and the babies
all men and women, and some of them married and
experimenting familywise themselves -- for not a soul
of the tribe was dead! Conceive of the ingenious
devilishness of that queen: she had a special hatred
for this prisoner, and she had INVENTED all those funer-
als herself, to scorch his heart with; and the sublimest
stroke of genius of the whole thing was leaving the
family-invoice a funeral SHORT, so as to let him wear his
poor old soul out guessing.

But for me, he never would have got out. Morgan
le Fay hated him with her whole heart, and she never
would have softened toward him. And yet his crime
was committed more in thoughtlessness than deliberate
depravity. He had said she had red hair. Well, she
had; but that was no way to speak of it. When red-
headed people are above a certain social grade their
hair is auburn.

Consider it: among these forty-seven captives there
were five whose names, offenses, and dates of incar-
ceration were no longer known! One woman and four
men -- all bent, and wrinkled, and mind-extinguished
patriarchs. They themselves had long ago forgotten
these details; at any rate they had mere vague theories
about them, nothing definite and nothing that they re-
peated twice in the same way. The succession of
priests whose office it had been to pray daily with the
captives and remind them that God had put them
there, for some wise purpose or other, and teach them
that patience, humbleness, and submission to oppres-
sion was what He loved to see in parties of a subordi-
nate rank, had traditions about these poor old human
ruins, but nothing more. These traditions went but
little way, for they concerned the length of the incar-
ceration only, and not the names of the offenses. And
even by the help of tradition the only thing that could
be proven was that none of the five had seen daylight
for thirty-five years: how much longer this privation
has lasted was not guessable. The king and the queen
knew nothing about these poor creatures, except that
they were heirlooms, assets inherited, along with the
throne, from the former firm. Nothing of their history
had been transmitted with their persons, and so the
inheriting owners had considered them of no value,
and had felt no interest in them. I said to the queen:

"Then why in the world didn't you set them free?"

The question was a puzzler. She didn't know WHY
she hadn't, the thing had never come up in her mind.
So here she was, forecasting the veritable history of
future prisoners of the Castle d'If, without knowing it.
It seemed plain to me now, that with her training,
those inherited prisoners were merely property -- noth-
ing more, nothing less. Well, when we inherit prop-
erty, it does not occur to us to throw it away, even
when we do not value it.

When I brought my procession of human bats up
into the open world and the glare of the afternoon sun
-- previously blindfolding them, in charity for eyes
so long untortured by light --  they were a spectacle
to look at. Skeletons, scarecrows, goblins, pathetic
frights, every one; legitimatest possible children of
Monarchy by the Grace of God and the Established
Church. I muttered absently:

"I WISH I could photograph them!"

You have seen that kind of people who will never let
on that they don't know the meaning of a new big
word. The more ignorant they are, the more pitifully
certain they are to pretend you haven't shot over their
heads. The queen was just one of that sort, and was
always making the stupidest blunders by reason of it.
She hesitated a moment; then her face brightened up
with sudden comprehension, and she said she would
do it for me.

I thought to myself: She? why what can she know
about photography? But it was a poor time to be
thinking. When I looked around, she was moving on
the procession with an axe!

Well, she certainly was a curious one, was Morgan
le Fay. I have seen a good many kinds of women in
my time, but she laid over them all for variety. And
how sharply characteristic of her this episode was.
She had no more idea than a horse of how to photo-
graph a procession; but being in doubt, it was just
like her to try to do it with an axe.


CHAPTER XIX.
KNIGHT-ERRANTRY AS A TRADE

SANDY and I were on the road again, next morn-
ing, bright and early. It was so good to open up
one's lungs and take in whole luscious barrels-ful of
the blessed God's untainted, dew-fashioned, woodland-
scented air once more, after suffocating body and mind
for two days and nights in the moral and physical
stenches of that intolerable old buzzard-roost!
mean, for me: of course the place was all right and
agreeable enough for Sandy, for she had been used to
high life all her days.

Poor girl, her jaws had had a wearisome rest now
for a while, and I was expecting to get the conse-
quences. I was right; but she had stood by me most
helpfully in the castle, and had mightily supported and
reinforced me with gigantic foolishnesses which were
worth more for the occasion than wisdoms double
their size; so I thought she had earned a right to work
her mill for a while, if she wanted to, and I felt not a
pang when she started it up:

"Now turn we unto Sir Marhaus that rode with the
damsel of thirty winter of age southward --"

"Are you going to see if you can work up another
half-stretch on the trail of the cowboys, Sandy?"

"Even so, fair my lord."

"Go ahead, then. I won't interrupt this time, if I
can help it. Begin over again; start fair, and shake
out all your reefs, and I will load my pipe and give
good attention."

"Now turn we unto Sir Marhaus that rode with the
damsel of thirty winter of age southward. And so
they came into a deep forest, and by fortune they were
nighted, and rode along in a deep way, and at the last
they came into a courtelage where abode the duke of
South Marches, and there they asked harbour. And
on the morn the duke sent unto Sir Marhaus, and bad
him make him ready. And so Sir Marhaus arose and
armed him, and there was a mass sung afore him, and
he brake his fast, and so mounted on horseback in the
court of the castle, there they should do the battle.
So there was the duke already on horseback, clean
armed, and his six sons by him, and every each had a
spear in his hand, and so they encountered, whereas
the duke and his two sons brake their spears upon
him, but Sir Marhaus held up his spear and touched
none of them. Then came the four sons by couples,
and two of them brake their spears, and so did the
other two. And all this while Sir Marhaus touched
them not. Then Sir Marhaus ran to the duke, and
smote him with his spear that horse and man fell to
the earth. And so he served his sons. And then Sir
Marhaus alight down, and bad the duke yield him or
else he would slay him. And then some of his sons
recovered, and would have set upon Sir Marhaus.
Then Sir Marhaus said to the duke, Cease thy sons, or
else I will do the uttermost to you all. When the
duke saw he might not escape the death, he cried to
his sons, and charged them to yield them to Sir Mar-
haus. And they kneeled all down and put the pom-
mels of their swords to the knight, and so he received
them. And then they holp up their father, and so by
their common assent promised unto Sir Marhaus never
to be foes unto King Arthur, and thereupon at Whit-
suntide after, to come he and his sons, and put them
in the king's grace. *

[* Footnote: The story is borrowed, language and
all, from the Morte d'Arthur. --M.T.]

"Even so standeth the history, fair Sir Boss. Now
ye shall wit that that very duke and his six sons are
they whom but few days past you also did overcome
and send to Arthur's court!"

"Why, Sandy, you can't mean it!"

"An I speak not sooth, let it be the worse for me."

"Well, well, well, -- now who would ever have
thought it? One whole duke and six dukelets; why,
Sandy, it was an elegant haul. Knight-errantry is a
most chuckle-headed trade, and it is tedious hard
work, too, but I begin to see that there IS money in
it, after all, if you have luck. Not that I would ever
engage in it as a business, for I wouldn't. No sound
and legitimate business can be established on a basis of
speculation. A successful whirl in the knight-errantry
line -- now what is it when you blow away the non-
sense and come down to the cold facts? It's just a
corner in pork, that's all, and you can't make anything
else out of it. You're rich -- yes, -- suddenly rich --
for about a day, maybe a week; then somebody cor-
ners the market on YOU, and down goes your bucket-
shop; ain't that so, Sandy?"

"Whethersoever it be that my mind miscarrieth,
bewraying simple language in such sort that the words
do seem to come endlong and overthwart --"

"There's no use in beating about the bush and
trying to get around it that way, Sandy, it's SO, just as
I say. I KNOW it's so. And, moreover, when you
come right down to the bedrock, knight-errantry is
WORSE than pork; for whatever happens, the pork's
left, and so somebody's benefited anyway; but when
the market breaks, in a knight-errantry whirl, and
every knight in the pool passes in his checks, what
have you got for assets? Just a rubbish-pile of bat-
tered corpses and a barrel or two of busted hardware.
Can you call THOSE assets? Give me pork, every time.
Am I right?"

"Ah, peradventure my head being distraught by
the manifold matters whereunto the confusions of these
but late adventured haps and fortunings whereby not
I alone nor you alone, but every each of us, meseem-
eth --"

"No, it's not your head, Sandy. Your head's all
right, as far as it goes, but you don't know business;
that's where the trouble is. It unfits you to argue
about business, and you're wrong to be always trying.
However, that aside, it was a good haul, anyway, and
will breed a handsome crop of reputation in Arthur's
court. And speaking of the cowboys, what a curious
country this is for women and men that never get old.
Now there's Morgan le Fay, as fresh and young as a
Vassar pullet, to all appearances, and here is this old
duke of the South Marches still slashing away with
sword and lance at his time of life, after raising such a
family as he has raised. As I understand it, Sir
Gawaine killed seven of his sons, and still he had six
left for Sir Marhaus and me to take into camp. And
then there was that damsel of sixty winter of age still
excursioning around in her frosty bloom -- How old
are you, Sandy?"

It was the first time I ever struck a still place in her.
The mill had shut down for repairs, or something.


CHAPTER XX.
THE OGRE'S CASTLE

BETWEEN six and nine we made ten miles, which
was plenty for a horse carrying triple -- man,
woman, and armor; then we stopped for a long noon-
ing under some trees by a limpid brook.

Right so came by and by a knight riding; and as he
drew near he made dolorous moan, and by the words
of it I perceived that he was cursing and swearing; yet
nevertheless was I glad of his coming, for that I saw
he bore a bulletin-board whereon in letters all of
shining gold was writ:

  "USE PETERSON S PROPHYLACTIC TOOTH-BRUSH--
  ALL THE GO."

I was glad of his coming, for even by this token I
knew him for knight of mine. It was Sir Madok de
la Montaine, a burly great fellow whose chief distinc-
tion was that he had come within an ace of sending Sir
Launcelot down over his horse-tail once. He was
never long in a stranger's presence without finding
some pretext or other to let out that great fact. But
there was another fact of nearly the same size, which
he never pushed upon anybody unasked, and yet never
withheld when asked: that was, that the reason he
didn't quite succeed was, that he was interrupted and
sent down over horse-tail himself. This innocent vast
lubber did not see any particular difference between
the two facts. I liked him, for he was earnest in his
work, and very valuable. And he was so fine to look
at, with his broad mailed shoulders, and the grand
leonine set of his plumed head, and his big shield
with its quaint device of a gauntleted hand clutch-
ing a prophylactic tooth-brush, with motto: "Try
Noyoudont." This was a tooth-wash that I was
introducing.

He was aweary, he said, and indeed he looked it;
but he would not alight. He said he was after the
stove-polish man; and with this he broke out cursing
and swearing anew. The bulletin-boarder referred to
was Sir Ossaise of Surluse, a brave knight, and of
considerable celebrity on account of his having tried
conclusions in a tournament once, with no less a Mogul
that Sir Gaheris himself -- although not successfully.
He was of a light and laughing disposition, and to him
nothing in this world was serious. It was for this
reason that I had chosen him to work up a stove-polish
sentiment. There were no stoves yet, and so there
could be nothing serious about stove-polish. All that
the agent needed to do was to deftly and by degrees
prepare the public for the great change, and have them
established in predilections toward neatness against the
time when the stove should appear upon the stage.

Sir Madok was very bitter, and brake out anew with
cursings. He said he had cursed his soul to rags;
and yet he would not get down from his horse, neither
would he take any rest, or listen to any comfort, until
he should have found Sir Ossaise and settled this ac-
count. It appeared, by what I could piece together
of the unprofane fragments of his statement, that he
had chanced upon Sir Ossaise at dawn of the morning,
and been told that if he would make a short cut across
the fields and swamps and broken hills and glades, he
could head off a company of travelers who would be
rare customers for prophylactics and tooth-wash. With
characteristic zeal Sir Madok had plunged away at
once upon this quest, and after three hours of awful
crosslot riding had overhauled his game. And behold,
it was the five patriarchs that had been released from
the dungeons the evening before! Poor old creatures,
it was all of twenty years since any one of them had
known what it was to be equipped with any remaining
snag or remnant of a tooth.

"Blank-blank-blank him," said Sir Madok, "an I
do not stove-polish him an I may find him, leave it to
me; for never no knight that hight Ossaise or aught
else may do me this disservice and bide on live, an I
may find him, the which I have thereunto sworn a
great oath this day."

And with these words and others, he lightly took his
spear and gat him thence. In the middle of the after-
noon we came upon one of those very patriarchs our-
selves, in the edge of a poor village. He was basking
in the love of relatives and friends whom he had not
seen for fifty years; and about him and caressing him
were also descendants of his own body whom he had
never seen at all till now; but to him these were all
strangers, his memory was gone, his mind was stag-
nant. It seemed incredible that a man could outlast
half a century shut up in a dark hole like a rat, but
here were his old wife and some old comrades to
testify to it. They could remember him as he was in
the freshness and strength of his young manhood,
when he kissed his child and delivered it to its mother's
hands and went away into that long oblivion. The
people at the castle could not tell within half a genera-
tion the length of time the man had been shut up there
for his unrecorded and forgotten offense; but this old
wife knew; and so did her old child, who stood there
among her married sons and daughters trying to realize
a father who had been to her a name, a thought, a
formless image, a tradition, all her life, and now was
suddenly concreted into actual flesh and blood and set
before her face.

It was a curious situation; yet it is not on that ac-
count that I have made room for it here, but on
account of a thing which seemed to me still more
curious. To wit, that this dreadful matter brought
from these downtrodden people no outburst of rage
against these oppressors. They had been heritors and
subjects of cruelty and outrage so long that nothing
could have startled them but a kindness. Yes, here
was a curious revelation, indeed, of the depth to which
this people had been sunk in slavery. Their entire
being was reduced to a monotonous dead level of
patience, resignation, dumb uncomplaining acceptance
of whatever might befall them in this life. Their very
imagination was dead. When you can say that of a
man, he has struck bottom, I reckon; there is no
lower deep for him.

I rather wished I had gone some other road. This
was not the sort of experience for a statesman to en-
counter who was planning out a peaceful revolution in
his mind. For it could not help bringing up the un-
get-aroundable fact that, all gentle cant and philoso-
phizing to the contrary notwithstanding, no people in
the world ever did achieve their freedom by goody-
goody talk and moral suasion: it being immutable law
that all revolutions that will succeed must BEGIN in
blood, whatever may answer afterward. If history
teaches anything, it teaches that. What this folk
needed, then, was a Reign of Terror and a guillotine,
and I was the wrong man for them.

Two days later, toward noon, Sandy began to show
signs of excitement and feverish expectancy. She
said we were approaching the ogre's castle. I was
surprised into an uncomfortable shock. The object of
our quest had gradually dropped out of my mind; this
sudden resurrection of it made it seem quite a real and
startling thing for a moment, and roused up in me a
smart interest. Sandy's excitement increased every
moment; and so did mine, for that sort of thing is
catching. My heart got to thumping. You can't
reason with your heart; it has its own laws, and
thumps about things which the intellect scorns. Pres-
ently, when Sandy slid from the horse, motioned me
to stop, and went creeping stealthily, with her head
bent nearly to her knees, toward a row of bushes that
bordered a declivity, the thumpings grew stronger and
quicker. And they kept it up while she was gaining
her ambush and getting her glimpse over the declivity;
and also while I was creeping to her side on my knees.
Her eyes were burning now, as she pointed with her
finger, and said in a panting whisper:

"The castle! The castle! Lo, where it looms!"

What a welcome disappointment I experienced! I
said:

"Castle? It is nothing but a pigsty; a pigsty with
a wattled fence around it."

She looked surprised and distressed. The animation
faded out of her face; and during many moments she
was lost in thought and silent. Then:

"It was not enchanted aforetime," she said in a
musing fashion, as if to herself. "And how strange
is this marvel, and how awful -- that to the one per-
ception it is enchanted and dight in a base and shame-
ful aspect; yet to the perception of the other it is not
enchanted, hath suffered no change, but stands firm
and stately still, girt with its moat and waving its ban-
ners in the blue air from its towers. And God shield
us, how it pricks the heart to see again these gracious
captives, and the sorrow deepened in their sweet faces!
We have tarried along, and are to blame."

I saw my cue. The castle was enchanted to ME, not
to her. It would be wasted time to try to argue her
out of her delusion, it couldn't be done; I must just
humor it. So I said:

"This is a common case -- the enchanting of a thing
to one eye and leaving it in its proper form to another.
You have heard of it before, Sandy, though you
haven't happened to experience it. But no harm is
done. In fact, it is lucky the way it is. If these
ladies were hogs to everybody and to themselves, it
would be necessary to break the enchantment, and that
might be impossible if one failed to find out the par-
ticular process of the enchantment. And hazardous,
too; for in attempting a disenchantment without the
true key, you are liable to err, and turn your hogs into
dogs, and the dogs into cats, the cats into rats, and so
on, and end by reducing your materials to nothing
finally, or to an odorless gas which you can't follow --
which, of course, amounts to the same thing. But
here, by good luck, no one's eyes but mine are under
the enchantment, and so it is of no consequence to
dissolve it. These ladies remain ladies to you, and to
themselves, and to everybody else; and at the same
time they will suffer in no way from my delusion, for
when I know that an ostensible hog is a lady, that is
enough for me, I know how to treat her."

"Thanks, oh, sweet my lord, thou talkest like an
angel. And I know that thou wilt deliver them, for
that thou art minded to great deeds and art as strong a
knight of your hands and as brave to will and to do,
as any that is on live."

"I will not leave a princess in the sty, Sandy. Are
those three yonder that to my disordered eyes are
starveling swine-herds --"

"The ogres, Are THEY changed also? It is most
wonderful. Now am I fearful; for how canst thou
strike with sure aim when five of their nine cubits of
stature are to thee invisible? Ah, go warily, fair sir;
this is a mightier emprise than I wend."

"You be easy, Sandy. All I need to know is, how
MUCH of an ogre is invisible; then I know how to
locate his vitals. Don't you be afraid, I will make
short work of these bunco-steerers. Stay where you
are."

I left Sandy kneeling there, corpse-faced but plucky
and hopeful, and rode down to the pigsty, and struck
up a trade with the swine-herds. I won their gratitude
by buying out all the hogs at the lump sum of sixteen
pennies, which was rather above latest quotations. I
was just in time; for the Church, the lord of the
manor, and the rest of the tax-gatherers would have
been along next day and swept off pretty much all the
stock, leaving the swine-herds very short of hogs and
Sandy out of princesses. But now the tax people
could be paid in cash, and there would be a stake left
besides. One of the men had ten children; and he
said that last year when a priest came and of his ten
pigs took the fattest one for tithes, the wife burst out
upon him, and offered him a child and said:

"Thou beast without bowels of mercy, why leave
me my child, yet rob me of the wherewithal to feed it?"

How curious. The same thing had happened in the
Wales of my day, under this same old Established
Church, which was supposed by many to have changed
its nature when it changed its disguise.

I sent the three men away, and then opened the sty
gate and beckoned Sandy to come -- which she did;
and not leisurely, but with the rush of a prairie fire.
And when I saw her fling herself upon those hogs,
with tears of joy running down her cheeks, and strain
them to her heart, and kiss them, and caress them,
and call them reverently by grand princely names, I
was ashamed of her, ashamed of the human race.

We had to drive those hogs home -- ten miles; and
no ladies were ever more fickle-minded or contrary.
They would stay in no road, no path; they broke out
through the brush on all sides, and flowed away in all
directions, over rocks, and hills, and the roughest
places they could find. And they must not be struck,
or roughly accosted; Sandy could not bear to see
them treated in ways unbecoming their rank. The
troublesomest old sow of the lot had to be called my
Lady, and your Highness, like the rest. It is annoy-
ing and difficult to scour around after hogs, in armor.
There was one small countess, with an iron ring in her
snout and hardly any hair on her back, that was the
devil for perversity. She gave me a race of an hour,
over all sorts of country, and then we were right where
we had started from, having made not a rod of real
progress. I seized her at last by the tail, and brought
her along squealing. When I overtook Sandy she was
horrified, and said it was in the last degree indelicate
to drag a countess by her train.

We got the hogs home just at dark -- most of them.
The princess Nerovens de Morganore was missing, and
two of her ladies in waiting: namely, Miss Angela
Bohun, and the Demoiselle Elaine Courtemains, the
former of these two being a young black sow with a
white star in her forehead, and the latter a brown one
with thin legs and a slight limp in the forward shank
on the starboard side -- a couple of the tryingest blis-
ters to drive that I ever saw. Also among the missing
were several mere baronesses -- and I wanted them to
stay missing; but no, all that sausage-meat had to be
found; so servants were sent out with torches to scour
the woods and hills to that end.

Of course, the whole drove was housed in the house,
and, great guns! -- well, I never saw anything like it.
Nor ever heard anything like it. And never smelt
anything like it. It was like an insurrection in a gaso-
meter.


CHAPTER XXI.
THE PILGRIMS

WHEN I did get to bed at last I was unspeakably
tired; the stretching out, and the relaxing of
the long-tense muscles, how luxurious, how delicious!
but that was as far as I could get -- sleep was out of
the question for the present. The ripping and tearing
and squealing of the nobility up and down the halls
and corridors was pandemonium come again, and kept
me broad awake. Being awake, my thoughts were
busy, of course; and mainly they busied themselves
with Sandy's curious delusion. Here she was, as sane
a person as the kingdom could produce; and yet,
from my point of view she was acting like a crazy
woman. My land, the power of training! of influence!
of education! It can bring a body up to believe any-
thing. I had to put myself in Sandy's place to realize
that she was not a lunatic. Yes, and put her in mine,
to demonstrate how easy it is to seem a lunatic to a
person who has not been taught as you have been
taught. If I had told Sandy I had seen a wagon,
uninfluenced by enchantment, spin along fifty miles an
hour; had seen a man, unequipped with magic powers,
get into a basket and soar out of sight among the
clouds; and had listened, without any necromancer's
help, to the conversation of a person who was several
hundred miles away, Sandy would not merely have
supposed me to be crazy, she would have thought she
knew it. Everybody around her believed in enchant-
ments; nobody had any doubts; to doubt that a castle
could be turned into a sty, and its occupants into hogs,
would have been the same as my doubting among Con-
necticut people the actuality of the telephone and its
wonders, -- and in both cases would be absolute proof
of a diseased mind, an unsettled reason. Yes, Sandy
was sane; that must be admitted. If I also would be
sane -- to Sandy -- I must keep my superstitions about
unenchanted and unmiraculous locomotives, balloons,
and telephones, to myself. Also, I believed that the
world was not flat, and hadn't pillars under it to sup-
port it, nor a canopy over it to turn off a universe of
water that occupied all space above; but as I was the
only person in the kingdom afflicted with such impious
and criminal opinions, I recognized that it would be
good wisdom to keep quiet about this matter, too, if I
did not wish to be suddenly shunned and forsaken by
everybody as a madman.

The next morning Sandy assembled the swine in the
dining-room and gave them their breakfast, waiting
upon them personally and manifesting in every way
the deep reverence which the natives of her island,
ancient and modern, have always felt for rank, let its
outward casket and the mental and moral contents be
what they may. I could have eaten with the hogs if I
had had birth approaching my lofty official rank; but
I hadn't, and so accepted the unavoidable slight and
made no complaint. Sandy and I had our breakfast at
the second table. The family were not at home. I
said:

"How many are in the family, Sandy, and where
do they keep themselves?"

"Family?"

"Yes."

"Which family, good my lord?"

"Why, this family; your own family."

"Sooth to say, I understand you not. I have no
family."

"No family? Why, Sandy, isn't this your home?"

"Now how indeed might that be? I have no home."

"Well, then, whose house is this?"

"Ah, wit you well I would tell you an I knew
myself."

"Come -- you don't even know these people?
Then who invited us here?"

"None invited us. We but came; that is all."

"Why, woman, this is a most extraordinary per-
formance. The effrontery of it is beyond admiration.
We blandly march into a man's house, and cram it
full of the only really valuable nobility the sun has yet
discovered in the earth, and then it turns out that we
don't even know the man's name. How did you ever
venture to take this extravagant liberty? I supposed,
of course, it was your home. What will the man say?"

"What will he say? Forsooth what can he say but
give thanks?"

"Thanks for what?"

Her face was filled with a puzzled surprise:

"Verily, thou troublest mine understanding with
strange words. Do ye dream that one of his estate is
like to have the honor twice in his life to entertain
company such as we have brought to grace his house
withal?"

"Well, no -- when you come to that. No, it's an
even bet that this is the first time he has had a treat
like this."

"Then let him be thankful, and manifest the same
by grateful speech and due humility; he were a dog,
else, and the heir and ancestor of dogs."

To my mind, the situation was uncomfortable. It
might become more so. It might be a good idea to
muster the hogs and move on. So I said:

"The day is wasting, Sandy. It is time to get the
nobility together and be moving."

"Wherefore, fair sir and Boss?"

"We want to take them to their home, don't we?"

"La, but list to him! They be of all the regions of
the earth! Each must hie to her own home; wend
you we might do all these journeys in one so brief life
as He hath appointed that created life, and thereto
death likewise with help of Adam, who by sin done
through persuasion of his helpmeet, she being wrought
upon and bewrayed by the beguilements of the great
enemy of man, that serpent hight Satan, aforetime
consecrated and set apart unto that evil work by over-
mastering spite and envy begotten in his heart through
fell ambitions that did blight and mildew a nature erst
so white and pure whenso it hove with the shining
multitudes its brethren-born in glade and shade of that
fair heaven wherein all such as native be to that rich
estate and --"

"Great Scott!"

"My lord?"

"Well, you know we haven't got time for this sort
of thing. Don't you see, we could distribute these
people around the earth in less time than it is going to
take you to explain that we can't. We mustn't talk
now, we must act. You want to be careful; you
mustn't let your mill get the start of you that way, at
a time like this. To business now -- and sharp's the
word. Who is to take the aristocracy home?"

"Even their friends. These will come for them
from the far parts of the earth."

This was lightning from a clear sky, for unexpected-
ness; and the relief of it was like pardon to a prisoner.
She would remain to deliver the goods, of course.

"Well, then, Sandy, as our enterprise is handsomely
and successfully ended, I will go home and report;
and if ever another one --"

"I also am ready; I will go with thee."

This was recalling the pardon.

"How? You will go with me? Why should you?"

"Will I be traitor to my knight, dost think? That
were dishonor. I may not part from thee until in
knightly encounter in the field some overmatching
champion shall fairly win and fairly wear me. I were
to blame an I thought that that might ever hap."

"Elected for the long term," I sighed to myself.
"I may as well make the best of it." So then I spoke
up and said:

"All right; let us make a start."

While she was gone to cry her farewells over the
pork, I gave that whole peerage away to the servants.
And I asked them to take a duster and dust around a
little where the nobilities had mainly lodged and prom-
enaded; but they considered that that would be hardly
worth while, and would moreover be a rather grave
departure from custom, and therefore likely to make
talk. A departure from custom -- that settled it; it
was a nation capable of committing any crime but
that. The servants said they would follow the fashion,
a fashion grown sacred through immemorial observ-
ance; they would scatter fresh rushes in all the rooms
and halls, and then the evidence of the aristocratic
visitation would be no longer visible. It was a kind of
satire on Nature: it was the scientific method, the
geologic method; it deposited the history of the family
in a stratified record; and the antiquary could dig
through it and tell by the remains of each period what
changes of diet the family had introduced successively
for a hundred years.

The first thing we struck that day was a procession
of pilgrims. It was not going our way, but we joined
it, nevertheless; for it was hourly being borne in
upon me now, that if I would govern this country
wisely, I must be posted in the details of its life,
and not at second hand, but by personal observation
and scrutiny.

This company of pilgrims resembled Chaucer's in
this: that it had in it a sample of about all the upper
occupations and professions the country could show,
and a corresponding variety of costume. There were
young men and old men, young women and old
women, lively folk and grave folk. They rode upon
mules and horses, and there was not a side-saddle in
the party; for this specialty was to remain unknown in
England for nine hundred years yet.

It was a pleasant, friendly, sociable herd; pious,
happy, merry and full of unconscious coarsenesses and
innocent indecencies. What they regarded as the
merry tale went the continual round and caused no
more embarrassment than it would have caused in the
best English society twelve centuries later. Practical
jokes worthy of the English wits of the first quarter of
the far-off nineteenth century were sprung here and
there and yonder along the line, and compelled the
delightedest applause; and sometimes when a bright
remark was made at one end of the procession and
started on its travels toward the other, you could note
its progress all the way by the sparkling spray of
laughter it threw off from its bows as it plowed along;
and also by the blushes of the mules in its wake.

Sandy knew the goal and purpose of this pilgrimage,
and she posted me. She said:

"They journey to the Valley of Holiness, for to be
blessed of the godly hermits and drink of the miracu-
lous waters and be cleased from sin."

"Where is this watering place?"

"It lieth a two-day journey hence, by the borders
of the land that hight the Cuckoo Kingdom."

"Tell me about it. Is it a celebrated place?"

"Oh, of a truth, yes. There be none more so. Of
old time there lived there an abbot and his monks.
Belike were none in the world more holy than these;
for they gave themselves to study of pious books, and
spoke not the one to the other, or indeed to any, and
ate decayed herbs and naught thereto, and slept hard,
and prayed much, and washed never; also they wore
the same garment until it fell from their bodies through
age and decay. Right so came they to be known of
all the world by reason of these holy austerities, and
visited by rich and poor, and reverenced."

"Proceed."

"But always there was lack of water there. Whereas,
upon a time, the holy abbot prayed, and for answer
a great stream of clear water burst forth by miracle
in a desert place. Now were the fickle monks tempted
of the Fiend, and they wrought with their abbot un-
ceasingly by beggings and beseechings that he would
construct a bath; and when he was become aweary and
might not resist more, he said have ye your will, then,
and granted that they asked. Now mark thou what
'tis to forsake the ways of purity the which He loveth,
and wanton with such as be worldly and an offense.
These monks did enter into the bath and come thence
washed as white as snow; and lo, in that moment His
sign appeared, in miraculous rebuke! for His insulted
waters ceased to flow, and utterly vanished away."

"They fared mildly, Sandy, considering how that
kind of crime is regarded in this country."

"Belike; but it was their first sin; and they had
been of perfect life for long, and differing in naught
from the angels. Prayers, tears, torturings of the
flesh, all was vain to beguile that water to flow again.
Even processions; even burnt-offerings; even votive
candles to the Virgin, did fail every each of them;
and all in the land did marvel."

"How odd to find that even this industry has its
financial panics, and at times sees its assignats and
greenbacks languish to zero, and everything come to a
standstill. Go on, Sandy."

"And so upon a time, after year and day, the good
abbot made humble surrender and destroyed the bath.
And behold, His anger was in that moment appeased,
and the waters gushed richly forth again, and even
unto this day they have not ceased to flow in that
generous measure."

"Then I take it nobody has washed since."

"He that would essay it could have his halter free;
yes, and swiftly would he need it, too."

"The community has prospered since?"

"Even from that very day. The fame of the miracle
went abroad into all lands. From every land came
monks to join; they came even as the fishes come, in
shoals; and the monastery added building to building,
and yet others to these, and so spread wide its arms
and took them in. And nuns came, also; and more
again, and yet more; and built over against the mon-
astery on the yon side of the vale, and added building
to building, until mighty was that nunnery. And
these were friendly unto those, and they joined their
loving labors together, and together they built a fair
great foundling asylum midway of the valley between."

"You spoke of some hermits, Sandy."

"These have gathered there from the ends of the
earth. A hermit thriveth best where there be multi-
tudes of pilgrims. Ye shall not find no hermit of no
sort wanting. If any shall mention a hermit of a kind
he thinketh new and not to be found but in some far
strange land, let him but scratch among the holes and
caves and swamps that line that Valley of Holiness,
and whatsoever be his breed, it skills not, he shall find
a sample of it there."

I closed up alongside of a burly fellow with a fat
good-humored face, purposing to make myself agree-
able and pick up some further crumbs of fact; but I
had hardly more than scraped acquaintance with him
when he began eagerly and awkwardly to lead up, in
the immemorial way, to that same old anecdote -- the
one Sir Dinadan told me, what time I got into trouble
with Sir Sagramor and was challenged of him on ac-
count of it. I excused myself and dropped to the rear
of the procession, sad at heart, willing to go hence
from this troubled life, this vale of tears, this brief day
of broken rest, of cloud and storm, of weary struggle
and monotonous defeat; and yet shrinking from the
change, as remembering how long eternity is, and how
many have wended thither who know that anecdote.

Early in the afternoon we overtook another proces-
sion of pilgrims; but in this one was no merriment, no
jokes, no laughter, no playful ways, nor any happy
giddiness, whether of youth or age. Yet both were
here, both age and youth; gray old men and women,
strong men and women of middle age, young hus-
bands, young wives, little boys and girls, and three
babies at the breast. Even the children were smileless;
there was not a face among all these half a hundred
people but was cast down, and bore that set expression
of hopelessness which is bred of long and hard trials
and old acquaintance with despair. They were slaves.
Chains led from their fettered feet and their manacled
hands to a sole-leather belt about their waists; and all
except the children were also linked together in a file
six feet apart, by a single chain which led from collar
to collar all down the line. They were on foot, and
had tramped three hundred miles in eighteen days,
upon the cheapest odds and ends of food, and stingy
rations of that. They had slept in these chains every
night, bundled together like swine. They had upon
their bodies some poor rags, but they could not be
said to be clothed. Their irons had chafed the skin
from their ankles and made sores which were ulcerated
and wormy. Their naked feet were torn, and none
walked without a limp. Originally there had been a
hundred of these unfortunates, but about half had been
sold on the trip. The trader in charge of them rode
a horse and carried a whip with a short handle and a
long heavy lash divided into several knotted tails at the
end. With this whip he cut the shoulders of any that
tottered from weariness and pain, and straightened
them up. He did not speak; the whip conveyed his
desire without that. None of these poor creatures
looked up as we rode along by; they showed no con-
sciousness of our presence. And they made no sound
but one; that was the dull and awful clank of their
chains from end to end of the long file, as forty-three
burdened feet rose and fell in unison. The file moved
in a cloud of its own making.

All these faces were gray with a coating of dust.
One has seen the like of this coating upon furniture in
unoccupied houses, and has written his idle thought in
it with his finger. I was reminded of this when I
noticed the faces of some of those women, young
mothers carrying babes that were near to death and
freedom, how a something in their hearts was written
in the dust upon their faces, plain to see, and lord, how
plain to read! for it was the track of tears. One of
these young mothers was but a girl, and it hurt me to
the heart to read that writing, and reflect that it was
come up out of the breast of such a child, a breast
that ought not to know trouble yet, but only the glad-
ness of the morning of life; and no doubt --

She reeled just then, giddy with fatigue, and down
came the lash and flicked a flake of skin from her
naked shoulder. It stung me as if I had been hit in-
stead. The master halted the file and jumped from his
horse. He stormed and swore at this girl, and said
she had made annoyance enough with her laziness, and
as this was the last chance he should have, he would
settle the account now. She dropped on her knees
and put up her hands and began to beg, and cry, and
implore, in a passion of terror, but the master gave no
attention. He snatched the child from her, and then
made the men-slaves who were chained before and
behind her throw her on the ground and hold her there
and expose her body; and then he laid on with his
lash like a madman till her back was flayed, she shriek-
ing and struggling the while piteously. One of the
men who was holding her turned away his face, and
for this humanity he was reviled and flogged.

All our pilgrims looked on and commented -- on the
expert way in which the whip was handled. They
were too much hardened by lifelong everyday familiar-
ity with slavery to notice that there was anything else
in the exhibition that invited comment. This was what
slavery could do, in the way of ossifying what one may
call the superior lobe of human feeling; for these pil-
grims were kind-hearted people, and they would not
have allowed that man to treat a horse like that.

I wanted to stop the whole thing and set the slaves
free, but that would not do. I must not interfere too
much and get myself a name for riding over the
country's laws and the citizen's rights roughshod. If
I lived and prospered I would be the death of slavery,
that I was resolved upon; but I would try to fix it so
that when I became its executioner it should be by
command of the nation.

Just here was the wayside shop of a smith; and now
arrived a landed proprietor who had bought this girl a
few miles back, deliverable here where her irons could
be taken off. They were removed; then there was a
squabble between the gentleman and the dealer as to
which should pay the blacksmith. The moment the
girl was delivered from her irons, she flung herself, all
tears and frantic sobbings, into the arms of the slave
who had turned away his face when she was whipped.
He strained her to his breast, and smothered her
face and the child's with kisses, and washed them
with the rain of his tears. I suspected. I inquired.
Yes, I was right; it was husband and wife. They had
to be torn apart by force; the girl had to be dragged
away, and she struggled and fought and shrieked like
one gone mad till a turn of the road hid her from
sight; and even after that, we could still make out the
fading plaint of those receding shrieks. And the hus-
band and father, with his wife and child gone, never to
be seen by him again in life? -- well, the look of him
one might not bear at all, and so I turned away; but I
knew I should never get his picture out of my mind
again, and there it is to this day, to wring my heart-
strings whenever I think of it.

We put up at the inn in a village just at nightfall,
and when I rose next morning and looked abroad, I
was ware where a knight came riding in the golden
glory of the new day, and recognized him for knight
of mine -- Sir Ozana le Cure Hardy. He was in the
gentlemen's furnishing line, and his missionarying
specialty was plug hats. He was clothed all in steel,
in the beautifulest armor of the time -- up to where his
helmet ought to have been; but he hadn't any helmet,
he wore a shiny stove-pipe hat, and was ridiculous a
spectacle as one might want to see. It was another of
my surreptitious schemes for extinguishing knighthood
by making it grotesque and absurd. Sir Ozana's sad-
dle was hung about with leather hat boxes, and every
time he overcame a wandering knight he swore him
into my service and fitted him with a plug and made
him wear it. I dressed and ran down to welcome Sir
Ozana and get his news.

"How is trade?" I asked.

"Ye will note that I have but these four left; yet
were they sixteen whenas I got me from Camelot."

"Why, you have certainly done nobly, Sir Ozana.
Where have you been foraging of late?"

"I am but now come from the Valley of Holiness,
please you sir."

"I am pointed for that place myself. Is there
anything stirring in the monkery, more than com-
mon?"

"By the mass ye may not question it!.... Give him
good feed, boy, and stint it not, an thou valuest thy
crown; so get ye lightly to the stable and do even as I
bid......  Sir, it is parlous news I bring, and -- be
these pilgrims? Then ye may not do better, good
folk, than gather and hear the tale I have to tell, sith it
concerneth you, forasmuch as ye go to find that ye
will not find, and seek that ye will seek in vain, my life
being hostage for my word, and my word and message
being these, namely: That a hap has happened where-
of the like has not been seen no more but once this
two hundred years, which was the first and last time
that that said misfortune strake the holy valley in that
form by commandment of the Most High whereto by
reasons just and causes thereunto contributing, wherein
the matter --"

"The miraculous fount hath ceased to flow!" This
shout burst from twenty pilgrim mouths at once.

"Ye say well, good people. I was verging to it,
even when ye spake. "

"Has somebody been washing again?"

"Nay, it is suspected, but none believe it. It is
thought to be some other sin, but none wit what."

"How are they feeling about the calamity?"

"None may describe it in words. The fount is
these nine days dry. The prayers that did begin then,
and the lamentations in sackcloth and ashes, and the
holy processions, none of these have ceased nor night
nor day; and so the monks and the nuns and the
foundlings be all exhausted, and do hang up prayers
writ upon parchment, sith that no strength is left in
man to lift up voice. And at last they sent for thee,
Sir Boss, to try magic and enchantment; and if you
could not come, then was the messenger to fetch
Merlin, and he is there these three days now, and
saith he will fetch that water though he burst the globe
and wreck its kingdoms to accomplish it; and right
bravely doth he work his magic and call upon his
hellions to hie them hither and help, but not a whiff
of moisture hath he started yet, even so much as might
qualify as mist upon a copper mirror an ye count not
the barrel of sweat he sweateth betwixt sun and sun
over the dire labors of his task; and if ye --"

Breakfast was ready. As soon as it was over I
showed to Sir Ozana these words which I had written
on the inside of his hat: Chemical Department, Labor-
atory extension, Section G. Pxxp. Send two of first
size, two of No. 3, and six of No. 4, together with the
proper complementary details -- and two of my trained
assistants." And I said:

"Now get you to Camelot as fast as you can fly,
brave knight, and show the writing to Clarence, and
tell him to have these required matters in the Valley of
Holiness with all possible dispatch."

"I will well, Sir Boss," and he was off.


CHAPTER XXII.
THE HOLY FOUNTAIN

THE pilgrims were human beings. Otherwise they
would have acted differently. They had come a
long and difficult journey, and now when the journey
was nearly finished, and they learned that the main
thing they had come for had ceased to exist, they
didn't do as horses or cats or angle-worms would
probably have done -- turn back and get at something
profitable -- no, anxious as they had before been to
see the miraculous fountain, they were as much as
forty times as anxious now to see the place where it
had used to be. There is no accounting for human
beings.

We made good time; and  a couple of hours before
sunset we stood upon the high confines of the Valley
of Holiness, and our eyes swept it from end to end
and noted its features. That is, its large features.
These were the three masses of buildings. They were
distant and isolated temporalities shrunken to toy con-
structions in the lonely waste of what seemed a desert
-- and was. Such a scene is always mournful, it is so
impressively still, and looks so steeped in death. But
there was a sound here which interrupted the stillness
only to add to its mournfulness; this was the faint far
sound of tolling bells which floated fitfully to us on the
passing breeze, and so faintly, so softly, that we hardly
knew whether we heard it with our ears or with our
spirits.

We reached the monastery before dark, and there
the males were given lodging, but the women were sent
over to the nunnery. The bells were close at hand
now, and their solemn booming smote upon the ear
like a message of doom. A superstitious despair pos-
sessed the heart of every monk and published itself
in his ghastly face. Everywhere, these black-robed,
soft-sandaled, tallow-visaged specters appeared, flitted
about and disappeared, noiseless as the creatures of a
troubled dream, and as uncanny.

The old abbot's joy to see me was pathetic. Even
to tears; but he did the shedding himself. He said:

"Delay not, son, but get to thy saving work. An
we bring not the water back again, and soon, we are
ruined, and the good work of two hundred years must
end. And see thou do it with enchantments that be
holy, for the Church will not endure that work in her
cause be done by devil's magic."

"When I work, Father, be sure there will be no
devil's work connected with it. I shall use no arts
that come of the devil, and no elements not created
by the hand of God. But is Merlin working strictly
on pious lines?"

"Ah, he said he would, my son, he said he would,
and took oath to make his promise good."

"Well, in that case, let him proceed."

"But surely you will not sit idle by, but help?"

"It will not answer to mix methods, Father; neither
would it be professional courtesy. Two of a trade
must not underbid each other. We might as well cut
rates and be done with it; it would arrive at that in
the end. Merlin has the contract; no other magician
can touch it till he throws it up."

"But I will take it from him; it is a terrible emer-
gency and the act is thereby justified. And if it were
not so, who will give law to the Church? The Church
giveth law to all; and what she wills to do, that she
may do, hurt whom it may. I will take it from him;
you shall begin upon the moment."

"It may not be, Father. No doubt, as you say,
where power is supreme, one can do as one likes and
suffer no injury; but we poor magicians are not so
situated. Merlin is a very good magician in a small
way, and has quite a neat provincial reputation. He
is struggling along, doing the best he can, and it would
not be etiquette for me to take his job until he himself
abandons it."

The abbot's face lighted.

"Ah, that is simple. There are ways to persuade
him to abandon it."

"No-no, Father, it skills not, as these people say.
If he were persuaded against his will, he would load
that well with a malicious enchantment which would
balk me until I found out its secret. It might take a
month. I could set up a little enchantment of mine
which I call the telephone, and he could not find out
its secret in a hundred years. Yes, you perceive, he
might block me for a month. Would you like to risk a
month in a dry time like this?"

"A month! The mere thought of it maketh me to
shudder. Have it thy way, my son. But my heart is
heavy with this disappointment. Leave me, and let
me wear my spirit with weariness and waiting, even as
I have done these ten long days, counterfeiting thus
the thing that is called rest, the prone body making
outward sign of repose where inwardly is none."

Of course, it would have been best, all round, for
Merlin to waive etiquette and quit and call it half a
day, since he would never be able to start that water,
for he was a true magician of the time; which is to
say, the big miracles, the ones that gave him his repu-
tation, always had the luck to be performed when
nobody but Merlin was present; he couldn't start this
well with all this crowd around to see; a crowd was as
bad for a magician's miracle in that day as it was for a
spiritualist's miracle in mine; there was sure to be
some skeptic on hand to turn up the gas at the crucial
moment and spoil everything. But I did not want
Merlin to retire from the job until I was ready to take
hold of it effectively myself; and I could not do that
until I got my things from Camelot, and that would
take two or three days.

My presence gave the monks hope, and cheered
them up a good deal; insomuch that they ate a square
meal that night for the first time in ten days. As
soon as their stomachs had been properly reinforced
with food, their spirits began to rise fast; when the
mead began to go round they rose faster. By the
time everybody was half-seas over, the holy com-
munity was in good shape to make a night of it; so
we stayed by the board and put it through on that
line. Matters got to be very jolly. Good old ques-
tionable stories were told that made the tears run down
and cavernous mouths stand wide and the round bellies
shake with laughter; and questionable songs were
bellowed out in a mighty chorus that drowned the
boom of the tolling bells.

At last I ventured a story myself; and vast was the
success of it. Not right off, of course, for the native
of those islands does not, as a rule, dissolve upon the
early applications of a humorous thing; but the fifth
time I told it, they began to crack in places; the eight
time I told it, they began to crumble; at the twelfth
repetition they fell apart in chunks; and at the fifteenth
they disintegrated, and I got a broom and swept them
up. This language is figurative. Those islanders --
well, they are slow pay at first, in the matter of return
for your investment of effort, but in the end they make
the pay of all other nations poor and small by contrast.

I was at the well next day betimes. Merlin was
there, enchanting away like a beaver, but not raising
the moisture. He was not in a pleasant humor; and
every time I hinted that perhaps this contract was a
shade too hefty for a novice he unlimbered his tongue
and cursed like a bishop -- French bishop of the
Regency days, I mean.

Matters were about as I expected to find them.
The "fountain" was an ordinary well, it had been dug
in the ordinary way, and stoned up in the ordinary
way. There was no miracle about it. Even the lie
that had created its reputation was not miraculous; I
could have told it myself, with one hand tied behind
me. The well was in a dark chamber which stood in
the center of a cut-stone chapel, whose walls were
hung with pious pictures of a workmanship that would
have made a chromo feel good; pictures historically
commemorative of curative miracles which had been
achieved by the waters when nobody was looking.
That is, nobody but angels; they are always on deck
when there is a miracle to the fore -- so as to get put
in the picture, perhaps. Angels are as fond of that as
a fire company; look at the old masters.

The well-chamber was dimly lighted by lamps; the
water was drawn with a windlass and chain by monks,
and poured into troughs which delivered it into stone
reservoirs outside in the chapel -- when there was
water to draw, I mean -- and none but monks could
enter the well-chamber. I entered it, for I had tempo-
rary authority to do so, by courtesy of my professional
brother and subordinate. But he hadn't entered it
himself. He did everything by incantations; he never
worked his intellect. If he had stepped in there and
used his eyes, instead of his disordered mind, he could
have cured the well by natural means, and then turned
it into a miracle in the customary way; but no, he was
an old numskull, a magician who believed in his own
magic; and no magician can thrive who is handicapped
with a superstition like that.

I had an idea that the well had sprung a leak; that
some of the wall stones near the bottom had fallen and
exposed fissures that allowed the water to escape. I
measured the chain -- 98 feet. Then I called in
couple of monks, locked the door, took a candle, and
made them lower me in the bucket. When the chain
was all paid out, the candle confirmed my suspicion;
a considerable section of the wall was gone, exposing a
good big fissure.

I almost regretted that my theory about the well's
trouble was correct, because I had another one that
had a showy point or two about it for a miracle. I
remembered that in America, many centuries later,
when an oil well ceased to flow, they used to blast it
out with a dynamite torpedo. If I should find this
well dry and no explanation of it, I could astonish
these people most nobly by having a person of no
especial value drop a dynamite bomb into it. It was
my idea to appoint Merlin. However, it was plain
that there was no occasion for the bomb. One cannot
have everything the way he would like it. A man has
no business to be depressed by a disappointment, any-
way; he ought to make up his mind to get even.
That is what I did. I said to myself, I am in no
hurry, I can wait; that bomb will come good yet.
And it did, too.

When I was above ground again, I turned out the
monks, and let down a fish-line; the well was a hun-
dred and fifty feet deep, and there was forty-one feet
of water in it I I called in a monk and asked:

A Yankee in King Arthur's Court     187

"How deep is the well?"

"That, sir, I wit not, having never been told."

"How does the water usually stand in it?"

"Near to the top, these two centuries, as the testi-
mony goeth, brought down to us through our prede-
cessors."

It was true -- as to recent times at least -- for there
was witness to it, and better witness than a monk;
only about twenty or thirty feet of the chain showed
wear and use, the rest of it was unworn and rusty.
What had happened when the well gave out that other
time? Without doubt some practical person had come
along and mended the leak, and then had come up and
told the abbot he had discovered by divination that if
the sinful bath were destroyed the well would flow
again. The leak had befallen again now, and these
children would have prayed, and processioned, and
tolled their bells for heavenly succor till they all dried
up and blew away, and no innocent of them all would
ever have thought to drop a fish-line into the well or
go down in it and find out what was really the matter.
Old habit of mind is one of the toughest things to
get away from in the world. It transmits itself like
physical form and feature; and for a man, in those
days, to have had an idea that his ancestors hadn't
had, would have brought him under suspicion of being
illegitimate. I said to the monk:

"It is a difficult miracle to restore water in a dry
well, but we will try, if my brother Merlin fails.
Brother Merlin is a very passable artist, but only in the
parlor-magic line, and he may not succeed; in fact, is
not likely to succeed. But that should be nothing to
his discredit; the man that can do THIS kind of miracle
knows enough to keep hotel."

"Hotel? I mind not to have heard --"

"Of hotel? It's what you call hostel. The man
that can do this miracle can keep hostel. I can do this
miracle; I shall do this miracle; yet I do not try to
conceal from you that it is a miracle to tax the occult
powers to the last strain."

"None knoweth that truth better than the brother-
hood, indeed; for it is of record that aforetime it was
parlous difficult and took a year. Natheless, God send
you good success, and to that end will we pray."

As a matter of business it was a good idea to get the
notion around that the thing was difficult. Many a
small thing has been made large by the right kind of
advertising. That monk was filled up with the diffi-
culty of this enterprise; he would fill up the others.
In two days the solicitude would be booming.

On my way home at noon, I met Sandy. She had
been sampling the hermits. I said:

"I would like to do that myself. This is Wednes-
day. Is there a matinee?"

"A which, please you, sir?"

"Matinee. Do they keep open afternoons?"

"Who?"

"The hermits, of course."

"Keep open?"

"Yes, keep open. Isn't that plain enough? Do
they knock off at noon?"

"Knock off?"

"Knock off? -- yes, knock off. What is the matter
with knock off? I never saw such a dunderhead;
can't you understand anything at all? In plain terms,
do they shut up shop, draw the game, bank the
fires --"

"Shut up shop, draw --"

"There, never mind, let it go; you make me tired.
You can't seem to understand the simplest thing."

I would I might please thee, sir, and it is to me
dole and sorrow that I fail, albeit sith I am but a
simple damsel and taught of none, being from the
cradle unbaptized in those deep waters of learning that
do anoint with a sovereignty him that partaketh of that
most noble sacrament, investing him with reverend
state to the mental eye of the humble mortal who, by
bar and lack of that great consecration seeth in his
own unlearned estate but a symbol of that other sort
of lack and loss which men do publish to the pitying
eye with sackcloth trappings whereon the ashes of
grief do lie bepowdered and bestrewn, and so, when
such shall in the darkness of his mind encounter these
golden phrases of high mystery, these shut-up-shops,
and draw-the-game, and bank-the-fires, it is but by the
grace of God that he burst not for envy of the mind
that can beget, and tongue that can deliver so great
and mellow-sounding miracles of speech, and if there
do ensue confusion in that humbler mind, and failure
to divine the meanings of these wonders, then if so be
this miscomprehension is not vain but sooth and true,
wit ye well it is the very substance of worshipful dear
homage and may not lightly be misprized, nor had
been, an ye had noted this complexion of mood
and mind and understood that that I would I could
not, and that I could not I might not, nor yet nor
might NOR could, nor might-not nor could-not, might
be by advantage turned to the desired WOULD, and so I
pray you mercy of my fault, and that ye will of your
kindness and your charity forgive it, good my master
and most dear lord."

I couldn't make it all out -- that is, the details -- but
I got the general idea; and enough of it, too, to be
ashamed. It was not fair to spring those nineteenth
century technicalities upon the untutored infant of the
sixth and then rail at her because she couldn't get
their drift; and when she was making the honest best
drive at it she could, too, and no fault of hers that she
couldn't fetch the home plate; and so I apologized.
Then we meandered pleasantly away toward the hermit
holes in sociable converse together, and better friends
than ever.

I was gradually coming to have a mysterious and
shuddery reverence for this girl; nowadays whenever
she pulled out from the station and got her train fairly
started on one of those horizonless transcontinental
sentences of hers, it was borne in upon me that I was
standing in the awful presence of the Mother of the
German Language. I was so impressed with this, that
sometimes when she began to empty one of these sen-
tences on me I unconsciously took the very attitude of
reverence, and stood uncovered; and if words had
been water, I had been drowned, sure. She had ex-
actly the German way; whatever was in her mind to
be delivered, whether a mere remark, or a sermon, or
a cyclopedia, or the history of a war, she would get it
into a single sentence or die. Whenever the literary
German dives into a sentence, that is the last you are
going to see of him till he emerges on the other side of
his Atlantic with his verb in his mouth.

We drifted from hermit to hermit all the afternoon.
It was a most strange menagerie. The chief emulation
among them seemed to be, to see which could manage
to be the uncleanest and most prosperous with vermin.
Their manner and attitudes were the last expression of
complacent self-righteousness. It was one anchorite's
pride to lie naked in the mud and let the insects bite
him and blister him unmolested; it was another's to
lean against a rock, all day long, conspicuous to the
admiration of the throng of pilgrims and pray; it was
another's to go naked and crawl around on all fours;
it was another's to drag about with him, year in and
year out, eighty pounds of iron; it was another's to
never lie down when he slept, but to stand among the
thorn-bushes and snore when there were pilgrims
around to look; a woman, who had the white hair of
age, and no other apparel, was black from crown to
heel with forty-seven years of holy abstinence from
water. Groups of gazing pilgrims stood around all
and every of these strange objects, lost in reverent
wonder, and envious of the fleckless sanctity which
these pious austerities had won for them from an
exacting heaven.

By and by we went to see one of the supremely
great ones. He was a mighty celebrity; his fame had
penetrated all Christendom; the noble and the re-
nowned journeyed from the remotest lands on the
globe to pay him reverence. His stand was in the
center of the widest part of the valley; and it took all
that space to hold his crowds.

His stand was a pillar sixty feet high, with a broad
platform on the top of it. He was now doing what he
had been doing every day for twenty years up there --
bowing his body ceaselessly and rapidly almost to his
feet. It was his way of praying. I timed him with a
stop watch, and he made 1,244 revolutions in 24 min-
utes and 46 seconds. It seemed a pity to have all this
power going to waste. It was one of the most useful
motions in mechanics, the pedal movement; so I made
a note in my memorandum book, purposing some day
to apply a system of elastic cords to him and run a
sewing machine with it. I afterward carried out that
scheme, and got five years' good service out of him;
in which time he turned out upward of eighteen thou-
sand first-rate tow-linen shirts, which was ten a day. I
worked him Sundays and all; he was going, Sundays,
the same as week days, and it was no use to waste the
power. These shirts cost me nothing but just the mere
trifle for the materials -- I furnished those myself, it
would not have been right to make him do that -- and
they sold like smoke to pilgrims at a dollar and a half
apiece, which was the price of fifty cows or a blooded
race horse in Arthurdom. They were regarded as a
perfect protection against sin, and advertised as such
by my knights everywhere, with the paint-pot and
stencil-plate; insomuch that there was not a cliff or a
bowlder or a dead wall in England but you could read
on it at a mile distance:

  "Buy the only genuine St. Stylite; patronized by the
  Nobility. Patent applied for."

There was more money in the business than one
knew what to do with. As it extended, I brought out
a line of goods suitable for kings, and a nobby thing
for duchesses and that sort, with ruffles down the fore-
hatch and the running-gear clewed up with a feather-
stitch to leeward and then hauled aft with a back-stay
and triced up with a half-turn in the standing rigging
forward of the weather-gaskets. Yes, it was a daisy.

But about that time I noticed that the motive power
had taken to standing on one leg, and I found that
there was something the matter with the other one; so
I stocked the business and unloaded, taking Sir Bors
de Ganis into camp financially along with certain of his
friends; for the works stopped within a year, and the
good saint got him to his rest. But he had earned it.
I can say that for him.

When I saw him that first time -- however, his per-
sonal condition will not quite bear description here.
You can read it in the Lives of the Saints. *

[* All the details concerning the hermits, in this
chapter, are from Lecky -- but greatly modified. This
book not being a history but only a tale, the majority
of the historian's frank details were too strong for
reproduction in it. - EDITOR]


CHAPTER XXIII.
RESTORATION OF THE FOUNTAIN

SATURDAY noon I went to the well and looked on
a while. Merlin was still burning smoke-powders,
and pawing the air, and muttering gibberish as hard as
ever, but looking pretty down-hearted, for of course
he had not started even a perspiration in that well yet.
Finally I said:

"How does the thing promise by this time, partner?"

"Behold, I am even now busied with trial of the
powerfulest enchantment known to the princes of the oc-
cult arts in the lands of the East; an it fail me, naught
can avail. Peace, until I finish."

He raised a smoke this time that darkened all the
region, and must have made matters uncomfortable for
the hermits, for the wind was their way, and it rolled
down over their dens in a dense and billowy fog. He
poured out volumes of speech to match, and contorted
his body and sawed the air with his hands in a most
extraordinary way. At the end of twenty minutes he
dropped down panting, and about exhausted. Now
arrived the abbot and several hundred monks and nuns,
and behind them a multitude of pilgrims and a couple
of acres of foundlings, all drawn by the prodigious smoke,
and all in a grand state of excitement. The abbot
inquired anxiously for results. Merlin said:

"If any labor of mortal might break the spell that
binds these waters, this which I have but just essayed
had done it. It has failed; whereby I do now know
that that which I had feared is a truth established; the
sign of this failure is, that the most potent spirit known
to the magicians of the East, and whose name none
may utter and live, has laid his spell upon this well.
The mortal does not breathe, nor ever will, who can
penetrate the secret of that spell, and without that
secret none can break it. The water will flow no more
forever, good Father. I have done what man could.
Suffer me to go."

Of course this threw the abbot into a good deal of a
consternation. He turned to me with the signs of it in
his face, and said:

"Ye have heard him. Is it true?"

"Part of it is."

"Not all, then, not all! What part is true?"

"That that spirit with the Russian name has put his
spell upon the well."

"God's wownds, then are we ruined!"

"Possibly."

"But not certainly? Ye mean, not certainly?"

"That is it."

"Wherefore, ye also mean that when he saith none
can break the spell --"

"Yes, when he says that, he says what isn't neces-
sarily true. There are conditions under which an effort
to break it may have some chance -- that is, some
small, some trifling chance -- of success."

"The conditions --"

"Oh, they are nothing difficult. Only these: I
want the well and the surroundings for the space of
half a mile, entirely to myself from sunset to-day until
I remove the ban -- and nobody allowed to cross the
ground but by my authority."

"Are these all?"

"Yes."

"And you have no fear to try?"

"Oh, none. One may fail, of course; and one
may also succeed. One can try, and I am ready to
chance it. I have my conditions?"

"These and all others ye may name. I will issue
commandment to that effect."

"Wait," said Merlin, with an evil smile. "Ye
wit that he that would break this spell must know that
spirit's name?"

"Yes, I know his name."

"And wit you also that to know it skills not of
itself, but ye must likewise pronounce it? Ha-ha!
Knew ye that?"

"Yes, I knew that, too."

"You had that knowledge! Art a fool? Are ye
minded to utter that name and die?"

"Utter it? Why certainly. I would utter it if it
was Welsh."

"Ye are even a dead man, then; and I go to
tell Arthur."

"That's all right. Take your gripsack and get
along. The thing for YOU to do is to go home and
work the weather, John W. Merlin."

It was a home shot, and it made him wince; for he
was the worst weather-failure in the kingdom. When-
ever he ordered up the danger-signals along the coast
there was a week's dead calm, sure, and every time he
prophesied fair weather it rained brickbats. But I kept
him in the weather bureau right along, to undermine
his reputation. However, that shot raised his bile, and
instead of starting home to report my death, he said
he would remain and enjoy it.

My two experts arrived in the evening, and pretty
well fagged, for they had traveled double tides. They
had pack-mules along, and had brought everything I
needed -- tools, pump, lead pipe, Greek fire, sheaves
of big rockets, roman candles, colored fire sprays,
electric apparatus, and a lot of sundries -- everything
necessary for the stateliest kind of a miracle. They
got their supper and a nap, and about midnight we
sallied out through a solitude so wholly vacant and
complete that it quite overpassed the required condi-
tions. We took possession of the well and its sur-
roundings. My boys were experts in all sorts of
things, from the stoning up of a well to the construct-
ing of a mathematical instrument. An hour before
sunrise we had that leak mended in ship-shape fashion,
and the water began to rise. Then we stowed our fire-
works in the chapel, locked up the place, and went
home to bed.

Before the noon mass was over, we were at the well
again; for there was a deal to do yet, and I was deter-
mined to spring the miracle before midnight, for busi-
ness reasons: for whereas a miracle worked for the
Church on a week-day is worth a good deal, it is worth
six times as much if you get it in on a Sunday. In
nine hours the water had risen to its customary level --
that is to say, it was within twenty-three feet of the
top. We put in a little iron pump, one of the first
turned out by my works near the capital; we bored
into a stone reservoir which stood against the outer
wall of the well-chamber and inserted a section of lead
pipe that was long enough to reach to the door of the
chapel and project beyond the threshold, where the
gushing water would be visible to the two hundred and
fifty acres of people I was intending should be present
on the flat plain in front of this little holy hillock at
the proper time.

We knocked the head out of an empty hogshead and
hoisted this hogshead to the flat roof of the chapel,
where we clamped it down fast, poured in gunpowder
till it lay loosely an inch deep on the bottom, then we
stood up rockets in the hogshead as thick as they
could loosely stand, all the different breeds of rockets
there are; and they made a portly and imposing sheaf,
I can tell you. We grounded the wire of a pocket
electrical battery in that powder, we placed a whole
magazine of Greek fire on each corner of the roof --
blue on one corner, green on another, red on another,
and purple on the last -- and grounded a wire in each.

About two hundred yards off, in the flat, we built a
pen of scantlings, about four feet high, and laid planks
on it, and so made a platform. We covered it with
swell tapestries borrowed for the occasion, and topped
it off with the abbot's own throne. When you are
going to do a miracle for an ignorant race, you want
to get in every detail that will count; you want to
make all the properties impressive to the public eye;
you want to make matters comfortable for your head
guest; then you can turn yourself loose and play your
effects for all they are worth. I know the value of
these things, for I know human nature. You can't
throw too much style into a miracle. It costs trouble,
and work, and sometimes money; but it pays in the
end. Well, we brought the wires to the ground at the
chapel, and then brought them under the ground to
the platform, and hid the batteries there. We put a
rope fence a hundred feet square around the platform
to keep off the common multitude, and that finished
the work. My idea was, doors open at 10:30, per-
formance to begin at 11:25 sharp. I wished I could
charge admission, but of course that wouldn't answer.
I instructed my boys to be in the chapel as early as
10, before anybody was around, and be ready to man
the pumps at the proper time, and make the fur fly.
Then we went home to supper.

The news of the disaster to the well had traveled far
by this time; and now for two or three days a steady
avalanche of people had been pouring into the valley.
The lower end of the valley was become one huge
camp; we should have a good house, no question
about that. Criers went the rounds early in the eve-
ning and announced the coming attempt, which put
every pulse up to fever heat. They gave notice that
the abbot and his official suite would move in state and
occupy the platform at 10:30, up to which time all the
region which was under my ban must be clear; the
bells would then cease from tolling, and this sign
should be permission to the multitudes to close in and
take their places.

I was at the platform and all ready to do the honors
when the abbot's solemn procession hove in sight --
which it did not do till it was nearly to the rope fence,
because it was a starless black night and no torches
permitted. With it came Merlin, and took a front seat
on the platform; he was as good as his word for once.
One could not see the multitudes banked together be-
yond the ban, but they were there, just the same.
The moment the bells stopped, those banked masses
broke and poured over the line like a vast black wave,
and for as much as a half hour it continued to flow,
and then it solidified itself, and you could have walked
upon a pavement of human heads to -- well, miles.

We had a solemn stage-wait, now, for about twenty
minutes -- a thing I had counted on for effect; it is
always good to let your audience have a chance to
work up its expectancy. At length, out of the silence
a noble Latin chant -- men's voices -- broke and
swelled up and rolled away into the night, a majestic
tide of melody. I had put that up, too, and it was one
of the best effects I ever invented. When it was finished
I stood up on the platform and extended my hands
abroad, for two minutes, with my face uplifted -- that
always produces a dead hush -- and then slowly pro-
nounced this ghastly word with a kind of awfulness which
caused hundreds to tremble, and many women to faint:

  "Constantinopolitanischerdudelsackspfeifen-
  machersgesellschafft!"

Just as I was moaning out the closing hunks of that
word, I touched off one of my electric connections
and all that murky world of people stood revealed in a
hideous blue glare! It was immense -- that effect!
Lots of people shrieked, women curled up and quit in
every direction, foundlings collapsed by platoons. The
abbot and the monks crossed themselves nimbly and
their lips fluttered with agitated prayers. Merlin held
his grip, but he was astonished clear down to his
corns; he had never seen anything to begin with that,
before. Now was the time to pile in the effects. I
lifted my hands and groaned out this word -- as it were
in agony:

  "Nihilistendynamittheaterkaestchensspreng-
  ungsattentaetsversuchungen!"

-- and turned on the red fire! You should have heard
that Atlantic of people moan and howl when that
crimson hell joined the blue! After sixty seconds I
shouted:

  "Transvaaltruppentropentransporttrampelthier-
  treibertrauungsthraenentragoedie!"

-- and lit up the green fire! After waiting only forty
seconds this time, I spread my arms abroad and
thundered out the devastating syllables of this word of
words:

  "Mekkamuselmannenmassenmenchenmoerdermohrenmutter-
  marmormonumentenmacher!"

-- and whirled on the purple glare! There they were,
all going at once, red, blue, green, purple! -- four
furious volcanoes pouring vast clouds of radiant smoke
aloft, and spreading a blinding rainbowed noonday to
the furthest confines of that valley. In the distance
one could see that fellow on the pillar standing rigid
against the background of sky, his seesaw stopped for
the first time in twenty years. I knew the boys were
at the pump now and ready. So I said to the abbot:

"The time is come, Father. I am about to pro-
nounce the dread name and command the spell to dis-
solve. You want to brace up, and take hold of some-
thing." Then I shouted to the people: "Behold, in
another minute the spell will be broken, or no mortal
can break it. If it break, all will know it, for you will
see the sacred water gush from the chapel door!"

I stood a few moments, to let the hearers have a
chance to spread my announcement to those who
couldn't hear, and so convey it to the furthest ranks,
then I made a grand exhibition of extra posturing and
gesturing, and shouted:

"Lo, I command the fell spirit that possesses the
holy fountain to now disgorge into the skies all the
infernal fires that still remain in him, and straightway
dissolve his spell and flee hence to the pit, there to lie
bound a thousand years. By his own dread name I
command it -- BGWJJILLIGKKK!"

Then I touched off the hogshead of rockets, and a
vast fountain of dazzling lances of fire vomited itself
toward the zenith with a hissing rush, and burst in
mid-sky into a storm of flashing jewels! One mighty
groan of terror started up from the massed people --
then suddenly broke into a wild hosannah of joy -- for
there, fair and plain in the uncanny glare, they saw
the freed water leaping forth! The old abbot could not
speak a word, for tears and the chokings in his throat;
without utterance of any sort, he folded me in his arms
and mashed me. It was more eloquent than speech.
And harder to get over, too, in a country where there
were really no doctors that were worth a damaged
nickel.

You should have seen those acres of people throw
themselves down in that water and kiss it; kiss it, and
pet it, and fondle it, and talk to it as if it were alive,
and welcome it back with the dear names they gave
their darlings, just as if it had been a friend who was
long gone away and lost, and was come home again.
Yes, it was pretty to see, and made me think more of
them than I had done before.

I sent Merlin home on a shutter. He had caved in
and gone down like a landslide when I pronounced that
fearful name, and had never come to since. He never
had heard that name before, -- neither had I -- but to
him it was the right one. Any jumble would have
been the right one. He admitted, afterward, that
that spirit's own mother could not have pronounced
that name better than I did. He never could under-
stand how I survived it, and I didn't tell him. It is
only young magicians that give away a secret like that.
Merlin spent three months working enchantments to
try to find out the deep trick of how to pronounce that
name and outlive it. But he didn't arrive.

When I started to the chapel, the populace un-
covered and fell back reverently to make a wide way
for me, as if I had been some kind of a superior being
-- and I was. I was aware of that. I took along a
night shift of monks, and taught them the mystery of
the pump, and set them to work, for it was plain that
a good part of the people out there were going to sit
up with the water all night, consequently it was but
right that they should have all they wanted of it. To
those monks that pump was a good deal of a miracle
itself, and they were full of wonder over it; and of
admiration, too, of the exceeding effectiveness of its
performance.

It was a great night, an immense night. There was
reputation in it. I could hardly get to sleep for glory-
ing over it.


CHAPTER XXIV.
A RIVAL MAGICIAN

MY influence in the Valley of Holiness was some-
thing prodigious now. It seemed worth while
to try to turn it to some valuable account. The
thought came to me the next morning, and was sug-
gested by my seeing one of my knights who was in
the soap line come riding in. According to history,
the monks of this place two centuries before had been
worldly minded enough to want to wash. It might be
that there was a leaven of this unrighteousness still re-
maining. So I sounded a Brother:

"Wouldn't you like a bath?"

He shuddered at the thought -- the thought of the
peril of it to the well -- but he said with feeling:

"One needs not to ask that of a poor body who has
not known that blessed refreshment sith that he was a
boy. Would God I might wash me! but it may not
be, fair sir, tempt me not; it is forbidden."

And then he sighed in such a sorrowful way that I
was resolved he should have at least one layer of his
real estate removed, if it sized up my whole influence
and bankrupted the pile. So I went to the abbot and
asked for a permit for this Brother. He blenched at
the idea -- I don't mean that you could see him blench,
for of course you couldn't see it without you scraped
him, and I didn't care enough about it to scrape him,
but I knew the blench was there, just the same, and
within a book-cover's thickness of the surface, too --
blenched, and trembled. He said:

"Ah, son, ask aught else thou wilt, and it is thine,
and freely granted out of a grateful heart -- but this,
oh, this! Would you drive away the blessed water
again?"

"No, Father, I will not drive it away. I have
mysterious knowledge which teaches me that there
was an error that other time when it was thought the
institution of the bath banished the fountain." A
large interest began to show up in the old man's face.
"My knowledge informs me that the bath was inno-
cent of that misfortune, which was caused by quite
another sort of sin."

"These are brave words -- but -- but right welcome,
if they be true."

"They are true, indeed. Let me build the bath
again, Father. Let me build it again, and the fountain
shall flow forever."

"You promise this? -- you promise it? Say the
word -- say you promise it!"

"I do promise it."

"Then will I have the first bath myself! Go --
get ye to your work. Tarry not, tarry not, but go."

I and my boys were at work, straight off. The
ruins of the old bath were there yet in the basement of
the monastery, not a stone missing. They had been
left just so, all these lifetimes, and avoided with a
pious fear, as things accursed. In two days we had it
all done and the water in -- a spacious pool of clear
pure water that a body could swim in. It was running
water, too. It came in, and went out, through the
ancient pipes. The old abbot kept his word, and was
the first to try it. He went down black and shaky,
leaving the whole black community above troubled and
worried and full of bodings; but he came back white
and joyful, and the game was made! another triumph
scored.

It was a good campaign that we made in that Valley
of Holiness, and I was very well satisfied, and ready to
move on now, but I struck a disappointment. I caught
a heavy cold, and it started up an old lurking rheuma-
tism of mine. Of course the rheumatism hunted up
my weakest place and located itself there. This was
the place where the abbot put his arms about me and
mashed me, what time he was moved to testify his
gratitude to me with an embrace.

When at last I got out, I was a shadow. But every-
body was full of attentions and kindnesses, and these
brought cheer back into my life, and were the right
medicine to help a convalescent swiftly up toward
health and strength again; so I gained fast.

Sandy was worn out with nursing; so I made up my
mind to turn out and go a cruise alone, leaving her at
the nunnery to rest up. My idea was to disguise myself
as a freeman of peasant degree and wander through
the country a week or two on foot. This would give
me a chance to eat and lodge with the lowliest and
poorest class of free citizens on equal terms. There
was no other way to inform myself perfectly of their
everyday life and the operation of the laws upon it. If
I went among them as a gentleman, there would be
restraints and conventionalities which would shut me
out from their private joys and troubles, and I should
get no further than the outside shell.

One morning I was out on a long walk to get up
muscle for my trip, and had climbed the ridge which
bordered the northern extremity of the valley, when I
came upon an artificial opening in the face of a low
precipice, and recognized it by its location as a hermit-
age which had often been pointed out to me from a
distance as the den of a hermit of high renown for dirt
and austerity. I knew he had lately been offered a
situation in the Great Sahara, where lions and sandflies
made the hermit-life peculiarly attractive and difficult,
and had gone to Africa to take possession, so I thought
I would look in and see how the atmosphere of this
den agreed with its reputation.

My surprise was great: the place was newly swept
and scoured. Then there was another surprise. Back
in the gloom of the cavern I heard the clink of a little
bell, and then this exclamation:

"Hello Central! Is this you, Camelot? -- Be-
hold, thou mayst glad thy heart an thou hast faith to
believe the wonderful when that it cometh in unex-
pected guise and maketh itself manifest in impossible
places -- here standeth in the flesh his mightiness The
Boss, and with thine own ears shall ye hear him
speak!"

Now what a radical reversal of things this was; what
a jumbling together of extravagant incongruities; what
a fantastic conjunction of opposites and irreconcilables
-- the home of the bogus miracle become the home of
a real one, the den of a mediaeval hermit turned into a
telephone office!

The telephone clerk stepped into the light, and I
recognized one of my young fellows. I said:

"How long has this office been established here,
Ulfius?"

"But since midnight, fair Sir Boss, an it please you.
We saw many lights in the valley, and so judged it
well to make a station, for that where so many lights
be needs must they indicate a town of goodly size."

"Quite right. It isn't a town in the customary
sense, but it's a good stand, anyway. Do you know
where you are?"

"Of that I have had no time to make inquiry; for
whenas my comradeship moved hence upon their
labors, leaving me in charge, I got me to needed rest,
purposing to inquire when I waked, and report the
place's name to Camelot for record."

"Well, this is the Valley of Holiness."

It didn't take; I mean, he didn't start at the name,
as I had supposed he would. He merely said:

"I will so report it."

"Why, the surrounding regions are filled with the
noise of late wonders that have happened here! You
didn't hear of them?"

"Ah, ye will remember we move by night, and
avoid speech with all. We learn naught but that we
get by the telephone from Camelot."

"Why THEY know all about this thing. Haven't
they told you anything about the great miracle of the
restoration of a holy fountain?"

"Oh, THAT? Indeed yes. But the name of THIS
valley doth woundily differ from the name of THAT one;
indeed to differ wider were not pos --"

"What was that name, then?"

"The Valley of Hellishness."

"THAT explains it. Confound a telephone, anyway.
It is the very demon for conveying similarities of sound
that are miracles of divergence from similarity of sense.
But no matter, you know the name of the place now.
Call up Camelot."

He did it, and had Clarence sent for. It was good
to hear my boy's voice again. It was like being home.
After some affectionate interchanges, and some account
of my late illness, I said:

"What is new?"

"The king and queen and many of the court do
start even in this hour, to go to your valley to pay
pious homage to the waters ye have restored, and
cleanse themselves of sin, and see the place where the
infernal spirit spouted true hell-flames to the clouds --
an ye listen sharply ye may hear me wink and hear me
likewise smile a smile, sith 'twas I that made selection
of those flames from out our stock and sent them by
your order."

"Does the king know the way to this place?"

"The king? -- no, nor to any other in his realms,
mayhap; but the lads that holp you with your miracle
will be his guide and lead the way, and appoint the
places for rests at noons and sleeps at night."

"This will bring them here -- when?"

"Mid-afternoon, or later, the third day."

"Anything else in the way of news?"

"The king hath begun the raising of the standing
army ye suggested to him; one regiment is complete
and officered."

"The mischief! I wanted a main hand in that my-
self. There is only one body of men in the kingdom
that are fitted to officer a regular army."

"Yes -- and now ye will marvel to know there's not
so much as one West Pointer in that regiment."

"What are you talking about? Are you in earnest?"

"It is truly as I have said."

"Why, this makes me uneasy. Who were chosen,
and what was the method? Competitive examination?"

"Indeed, I know naught of the method. I but
know this -- these officers be all of noble family, and
are born -- what is it you call it? -- chuckleheads."

"There's something wrong, Clarence. "

"Comfort yourself, then; for two candidates for a
lieutenancy do travel hence with the king -- young
nobles both -- and if you but wait where you are you
will hear them questioned."

"That is news to the purpose. I will get one West
Pointer in, anyway. Mount a man and send him to
that school with a message; let him kill horses, if
necessary, but he must be there before sunset to-night
and say -- "

"There is no need. I have laid a ground wire to
the school. Prithee let me connect you with it."

It sounded good! In this atmosphere of telephones
and lightning communication with distant regions, I
was breathing the breath of life again after long suffo-
cation. I realized, then, what a creepy, dull, inanimate
horror this land had been to me all these years, and
how I had been in such a stifled condition of mind as
to have grown used to it almost beyond the power to
notice it.

I gave my order to the superintendent of the Acad-
emy personally. I also asked him to bring me some
paper and a fountain pen and a box or so of safety
matches. I was getting tired of doing without these
conveniences. I could have them now, as I wasn't
going to wear armor any more at present, and there-
fore could get at my pockets.

When I got back to the monastery, I found a thing
of interest going on. The abbot and his monks were
assembled in the great hall, observing with childish
wonder and faith the performances of a new magician,
a fresh arrival. His dress was the extreme of the
fantastic; as showy and foolish as the sort of thing an
Indian medicine-man wears. He was mowing, and
mumbling, and gesticulating, and drawing mystical
figures in the air and on the floor, -- the regular thing,
you know. He was a celebrity from Asia -- so he
said, and that was enough. That sort of evidence was
as good as gold, and passed current everywhere.

How easy and cheap it was to be a great magician
on this fellow's terms. His specialty was to tell you
what any individual on the face of the globe was doing
at the moment; and what he had done at any time in
the past, and what he would do at any time in the
future. He asked if any would like to know what the
Emperor of the East was doing now? The sparkling
eyes and the delighted rubbing of hands made eloquent
answer -- this reverend crowd WOULD like to know what
that monarch was at, just as this moment. The fraud
went through some more mummery, and then made
grave announcement:

"The high and mighty Emperor of the East doth at
this moment put money in the palm of a holy begging
friar -- one, two, three pieces, and they be all of
silver."

A buzz of admiring exclamations broke out, all
around:

"It is marvelous!" "Wonderful!" "What study,
what labor, to have acquired a so amazing power as this!"

Would they like to know what the Supreme Lord of
Inde was doing? Yes. He told them what the
Supreme Lord of Inde was doing. Then he told
them what the Sultan of Egypt was at; also what the
King of the Remote Seas was about. And so on and
so on; and with each new marvel the astonishment at
his accuracy rose higher and higher. They thought
he must surely strike an uncertain place some time;
but no, he never had to hesitate, he always knew, and
always with unerring precision. I saw that if this thing
went on I should lose my supremacy, this fellow would
capture my following, I should be left out in the cold.
I must put a cog in his wheel, and do it right away,
too. I said:

"If I might ask, I should very greatly like to know
what a certain person is doing."

"Speak, and freely. I will tell you."

"It will be difficult -- perhaps impossible."

"My art knoweth not that word. The more difficult
it is, the more certainly will I reveal it to you."

You see, I was working up the interest. It was
getting pretty high, too; you could see that by the
craning necks all around, and the half-suspended
breathing. So now I climaxed it:

"If you make no mistake -- if you tell me truly
what I want to know -- I will give you two hundred
silver pennies."

"The fortune is mine! I will tell you what you
would know."

"Then tell me what I am doing with my right hand."

"Ah-h!" There was a general gasp of surprise.
It had not occurred to anybody in the crowd -- that
simple trick of inquiring about somebody who wasn't
ten thousand miles away. The magician was hit hard;
it was an emergency that had never happened in his
experience before, and it corked him; he didn't know
how to meet it. He looked stunned, confused; he
couldn't say a word. "Come," I said, "what are
you waiting for? Is it possible you can answer up,
right off, and tell what anybody on the other side of
the earth is doing, and yet can't tell what a person is
doing who isn't three yards from you? Persons behind
me know what I am doing with my right hand -- they
will indorse you if you tell correctly." He was still
dumb. "Very well, I'll tell you why you don't speak
up and tell; it is because you don't know. YOU a
magician! Good friends, this tramp is a mere fraud
and liar."

This distressed the monks and terrified them. They
were not used to hearing these awful beings called
names, and they did not know what might be the con-
sequence. There was a dead silence now; superstitious
bodings were in every mind. The magician began to
pull his wits together, and when he presently smiled an
easy, nonchalant smile, it spread a mighty relief
around; for it indicated that his mood was not destruc-
tive. He said:

"It hath struck me speechless, the frivolity of this
person's speech. Let all know, if perchance there be
any who know it not, that enchanters of my degree
deign not to concern themselves with the doings of any
but kings, princes, emperors, them that be born in the
purple and them only. Had ye asked me what Arthur
the great king is doing, it were another matter, and I
had told ye; but the doings of a subject interest me
not."

"Oh, I misunderstood you. I thought you said
'anybody,' and so I supposed 'anybody' included --
well, anybody; that is, everybody."

"It doth -- anybody that is of lofty birth; and the
better if he be royal."

"That, it meseemeth, might well be," said the abbot,
who saw his opportunity to smooth things and avert
disaster, "for it were not likely that so wonderful a
gift as this would be conferred for the revelation of the
concerns of lesser beings than such as be born near to
the summits of greatness. Our Arthur the king --"

"Would you know of him?" broke in the en-
chanter.

"Most gladly, yea, and gratefully."

Everybody was full of awe and interest again right
away, the incorrigible idiots. They watched the incan-
tations absorbingly, and looked at me with a "There,
now, what can you say to that?" air, when the
announcement came:

"The king is weary with the chase, and lieth in his
palace these two hours sleeping a dreamless sleep."

"God's benison upon him!" said the abbot, and
crossed himself; "may that sleep be to the refresh-
ment of his body and his soul."

"And so it might be, if he were sleeping," I said,
"but the king is not sleeping, the king rides."

Here was trouble again -- a conflict of authority.
Nobody knew which of us to believe; I still had some
reputation left. The magician's scorn was stirred, and
he said:

"Lo, I have seen many wonderful soothsayers and
prophets and magicians in my life days, but none be-
fore that could sit idle and see to the heart of things
with never an incantation to help."

"You have lived in the woods, and lost much by it.
I use incantations myself, as this good brotherhood are
aware -- but only on occasions of moment."

When it comes to sarcasming, I reckon I know how
to keep my end up. That jab made this fellow squirm.
The abbot inquired after the queen and the court, and
got this information:

"They be all on sleep, being overcome by fatigue,
like as to the king."

I said:

"That is merely another lie. Half of them are
about their amusements, the queen and the other half
are not sleeping, they ride. Now perhaps you can
spread yourself a little, and tell us where the king and
queen and all that are this moment riding with them
are going?"

"They sleep now, as I said; but on the morrow
they will ride, for they go a journey toward the sea."

"And where will they be the day after to-morrow at
vespers?"

"Far to the north of Camelot, and half their journey
will be done."

"That is another lie, by the space of a hundred and
fifty miles. Their journey will not be merely half
done, it will be all done, and they will be HERE, in this
valley."

THAT was a noble shot! It set the abbot and the
monks in a whirl of excitement, and it rocked the en-
chanter to his base. I followed the thing right up:

"If the king does not arrive, I will have myself
ridden on a rail: if he does I will ride you on a rail
instead."

Next day I went up to the telephone office and found
that the king had passed through two towns that were
on the line. I spotted his progress on the succeeding
day in the same way. I kept these matters to myself.
The third day's reports showed that if he kept up his
gait he would arrive by four in the afternoon. There
was still no sign anywhere of interest in his coming;
there seemed to be no preparations making to receive
him in state; a strange thing, truly. Only one thing
could explain this: that other magician had been cut-
ting under me, sure. This was true. I asked a friend
of mine, a monk, about it, and he said, yes, the
magician had tried some further enchantments and
found out that the court had concluded to make no
journey at all, but stay at home. Think of that!
Observe how much a reputation was worth in such a
country. These people had seen me do the very
showiest bit of magic in history, and the only one
within their memory that had a positive value, and yet
here they were, ready to take up with an adventurer
who could offer no evidence of his powers but his mere
unproven word.

However, it was not good politics to let the king
come without any fuss and feathers at all, so I went
down and drummed up a procession of pilgrims and
smoked out a batch of hermits and started them out at
two o'clock to meet him. And that was the sort of
state he arrived in. The abbot was helpless with rage
and humiliation when I brought him out on a balcony
and showed him the head of the state marching in and
never a monk on hand to offer him welcome, and no
stir of life or clang of joy-bell to glad his spirit. He
took one look and then flew to rouse out his forces.
The next minute the bells were dinning furiously, and
the various buildings were vomiting monks and nuns,
who went swarming in a rush toward the coming pro-
cession; and with them went that magician -- and he
was on a rail, too, by the abbot's order; and his
reputation was in the mud, and mine was in the sky
again. Yes, a man can keep his trademark current in
such a country, but he can't sit around and do it; he
has got to be on deck and attending to business right
along.


CHAPTER XXV.
A COMPETITIVE EXAMINATION

WHEN the king traveled for change of air, or made
a progress, or visited a distant noble whom he
wished to bankrupt with the cost of his keep, part of
the administration moved with him. It was a fashion
of the time. The Commission charged with the ex-
amination of candidates for posts in the army came
with the king to the Valley, whereas they could have
transacted their business just as well at home. And
although this expedition was strictly a holiday excur-
sion for the king, he kept some of his business func-
tions going just the same. He touched for the evil, as
usual; he held court in the gate at sunrise and tried
cases, for he was himself Chief Justice of the King's
Bench.

He shone very well in this latter office. He was a
wise and humane judge, and he clearly did his honest
best and fairest, -- according to his lights. That is a
large reservation. His lights -- I mean his rearing --
often colored his decisions. Whenever there was a
dispute between a noble or gentleman and a person of
lower degree, the king's leanings and sympathies were
for the former class always, whether he suspected it or
not. It was impossible that this should be otherwise.
The blunting effects of slavery upon the slaveholder's
moral perceptions are known and conceded, the world
over; and a privileged class, an aristocracy, is but a
band of slaveholders under another name. This has a
harsh sound, and yet should not be offensive to any --
even to the noble himself -- unless the fact itself be an
offense: for the statement simply formulates a fact.
The repulsive feature of slavery is the THING, not its
name. One needs but to hear an aristocrat speak of
the classes that are below him to recognize -- and in
but indifferently modified measure -- the very air and
tone of the actual slaveholder; and behind these are
the slaveholder's spirit, the slaveholder's blunted feel-
ing. They are the result of the same cause in both
cases: the possessor's old and inbred custom of re-
garding himself as a superior being. The king's judg-
ments wrought frequent injustices, but it was merely
the fault of his training, his natural and unalterable
sympathies. He was as unfitted for a judgeship as
would be the average mother for the position of milk-
distributor to starving children in famine-time; her
own children would fare a shade better than the rest.

One very curious case came before the king. A
young girl, an orphan, who had a considerable estate,
married a fine young fellow who had nothing. The
girl's property was within a seigniory held by the
Church. The bishop of the diocese, an arrogant scion
of the great nobility, claimed the girl's estate on the
ground that she had married privately, and thus had
cheated the Church out of one of its rights as lord of
the seigniory -- the one heretofore referred to as le droit
du seigneur. The penalty of refusal or avoidance was
confiscation. The girl's defense was, that the lordship
of the seigniory was vested in the bishop, and the par-
ticular right here involved was not transferable, but
must be exercised by the lord himself or stand vacated;
and that an older law, of the Church itself, strictly
barred the bishop from exercising it. It was a very
odd case, indeed.

It reminded me of something I had read in my
youth about the ingenious way in which the aldermen
of London raised the money that built the Mansion
House. A person who had not taken the Sacrament
according to the Anglican rite could not stand as a
candidate for sheriff of London. Thus Dissenters were
ineligible; they could not run if asked, they could not
serve if elected. The aldermen, who without any
question were Yankees in disguise, hit upon this neat
device: they passed a by-law imposing a fine of L400
upon any one who should refuse to be a candidate for
sheriff, and a fine of L600 upon any person who, after
being elected sheriff, refused to serve. Then they went
to work and elected a lot of Dissenters, one after
another, and kept it up until they had collected
L15,000 in fines; and there stands the stately Man-
sion House to this day, to keep the blushing citizen in
mind of a long past and lamented day when a band of
Yankees slipped into London and played games of the
sort that has given their race a unique and shady
reputation among all truly good and holy peoples that
be in the earth.

The girl's case seemed strong to me; the bishop's
case was just as strong. I did not see how the king
was going to get out of this hole. But he got out. I
append his decision:

"Truly I find small difficulty here, the matter being
even a child's affair for simpleness. An the young
bride had conveyed notice, as in duty bound, to her
feudal lord and proper master and protector the bishop,
she had suffered no loss, for the said bishop could have
got a dispensation making him, for temporary con-
veniency, eligible to the exercise of his said right, and
thus would she have kept all she had. Whereas, fail-
ing in her first duty, she hath by that failure failed in
all; for whoso, clinging to a rope, severeth it above
his hands, must fall; it being no defense to claim that
the rest of the rope is sound, neither any deliverance
from his peril, as he shall find. Pardy, the woman's
case is rotten at the source. It is the decree of the
court that she forfeit to the said lord bishop all her
goods, even to the last farthing that she doth possess,
and be thereto mulcted in the costs. Next!"

Here was a tragic end to a beautiful honeymoon not
yet three months old. Poor young creatures! They
had lived these three months lapped to the lips in
worldly comforts. These clothes and trinkets they
were wearing were as fine and dainty as the shrewdest
stretch of the sumptuary laws allowed to people of
their degree; and in these pretty clothes, she crying
on his shoulder, and he trying to comfort her with
hopeful words set to the music of despair, they went
from the judgment seat out into the world homeless,
bedless, breadless; why, the very beggars by the road-
sides were not so poor as they.

Well, the king was out of the hole; and on terms
satisfactory to the Church and the rest of the aristoc-
racy, no doubt. Men write many fine and plausible
arguments in support of monarchy, but the fact re-
mains that where every man in a State has a vote,
brutal laws are impossible. Arthur's people were of
course poor material for a republic, because they had
been debased so long by monarchy; and yet even they
would have been intelligent enough to make short work
of that law which the king had just been administering
if it had been submitted to their full and free vote.
There is a phrase which has grown so common in the
world's mouth that it has come to seem to have sense
and meaning -- the sense and meaning implied when it
is used; that is the phrase which refers to this or that
or the other nation as possibly being "capable of self-
government"; and the implied sense of it is, that there
has been a nation somewhere, some time or other
which WASN'T capable of it -- wasn't as able to govern
itself as some self-appointed specialists were or would
be to govern it. The master minds of all nations, in
all ages, have sprung in affluent multitude from the
mass of the nation, and from the mass of the nation
only -- not from its privileged classes; and so, no
matter what the nation's intellectual grade was; whether
high or low, the bulk of its ability was in the long
ranks of its nameless and its poor, and so it never saw
the day that it had not the material in abundance
whereby to govern itself. Which is to assert an always
self-proven fact: that even the best governed and most
free and most enlightened monarchy is still behind the
best condition attainable by its people; and that the
same is true of kindred governments of lower grades,
all the way down to the lowest.

King Arthur had hurried up the army business
altogether beyond my calculations. I had not sup-
posed he would move in the matter while I was away;
and so I had not mapped out a scheme for determining
the merits of officers; I had only remarked that it
would be wise to submit every candidate to a sharp
and searching examination; and privately I meant to
put together a list of military qualifications that no-
body could answer to but my West Pointers. That
ought to have been attended to before I left; for the
king was so taken with the idea of a standing army
that he couldn't wait but must get about it at once,
and get up as good a scheme of examination as he
could invent out of his own head.

I was impatient to see what this was; and to show,
too, how much more admirable was the one which I
should display to the Examining Board. I intimated
this, gently, to the king, and it fired his curiosity
When the Board was assembled, I followed him in;
and behind us came the candidates. One of these
candidates was a bright young West Pointer of mine,
and with him were a couple of my West Point pro-
fessors.

When I saw the Board, I did not know whether to
cry or to laugh. The head of it was the officer known
to later centuries as Norroy King-at-Arms! The two
other members were chiefs of bureaus in his depart-
ment; and all three were priests, of course; all officials
who had to know how to read and write were priests.

My candidate was called first, out of courtesy to
me, and the head of the Board opened on him with
official solemnity:

"Name?"

"Mal-ease."

"Son of?"

"Webster."

"Webster -- Webster. H'm -- I -- my memory
faileth to recall the name. Condition?"

"Weaver."

"Weaver! -- God keep us!"

The king was staggered, from his summit to his
foundations; one clerk fainted, and the others came
near it. The chairman pulled himself together, and
said indignantly:

"It is sufficient. Get you hence."

But I appealed to the king. I begged that my can-
didate might be examined. The king was willing, but
the Board, who were all well-born folk, implored the
king to spare them the indignity of examining the
weaver's son. I knew they didn't know enough to
examine him anyway, so I joined my prayers to theirs
and the king turned the duty over to my professors.
I had had a blackboard prepared, and it was put up
now, and the circus began. It was beautiful to hear
the lad lay out the science of war, and wallow in de-
tails of battle and siege, of supply, transportation,
mining and countermining, grand tactics, big strategy
and little strategy, signal service, infantry, cavalry,
artillery, and all about siege guns, field guns, gatling
guns, rifled guns, smooth bores, musket practice,
revolver practice -- and not a solitary word of it all
could these catfish make head or tail of, you under-
stand -- and it was handsome to see him chalk off
mathematical nightmares on the blackboard that would
stump the angels themselves, and do it like nothing,
too -- all about eclipses, and comets, and solstices, and
constellations, and mean time, and sidereal time, and
dinner time, and bedtime, and every other imaginable
thing above the clouds or under them that you could
harry or bullyrag an enemy with and make him wish
he hadn't come -- and when the boy made his military
salute and stood aside at last, I was proud enough to
hug him, and all those other people were so dazed they
looked partly petrified, partly drunk, and wholly caught
out and snowed under. I judged that the cake was ours,
and by a large majority.

Education is a great thing. This was the same
youth who had come to West Point so ignorant that
when I asked him, "If a general officer should have a
horse shot under him on the field of battle, what ought
he to do?" answered up naively and said:

"Get up and brush himself."

One of the young nobles was called up now. I
thought I would question him a little myself. I said:

"Can your lordship read?"

His face flushed indignantly, and he fired this at me:

"Takest me for a clerk? I trow I am not of a blood
that --"

"Answer the question!"

He crowded his wrath down and made out to answer
"No."

"Can you write?"

He wanted to resent this, too, but I said:

"You will confine yourself to the questions, and
make no comments. You are not here to air your
blood or your graces, and nothing of the sort will be
permitted. Can you write?"

"No."

"Do you know the multiplication table?"

"I wit not what ye refer to."

"How much is 9 times 6?"

"It is a mystery that is hidden from me by reason
that the emergency requiring the fathoming of it hath
not in my life-days occurred, and so, not having no
need to know this thing, I abide barren of the knowl-
edge."

"If A trade a barrel of onions to B, worth 2 pence
the bushel, in exchange for a sheep worth 4 pence and
a dog worth a penny, and C kill the dog before de-
livery, because bitten by the same, who mistook him
for D, what sum is still due to A from B, and which
party pays for the dog, C or D, and who gets the
money? If A, is the penny sufficient, or may he claim
consequential damages in the form of additional money
to represent the possible profit which might have
inured from the dog, and classifiable as earned incre-
ment, that is to say, usufruct?"

"Verily, in the all-wise and unknowable providence of
God, who moveth in mysterious ways his wonders to
perform, have I never heard the fellow to this question
for confusion of the mind and congestion of the ducts
of thought. Wherefore I beseech you let the dog and
the onions and these people of the strange and godless
names work out their several salvations from their
piteous and wonderful difficulties without help of mine,
for indeed their trouble is sufficient as it is, whereas an
I tried to help I should but damage their cause the
more and yet mayhap not live myself to see the deso-
lation wrought."

"What do you know of the laws of attraction and
gravitation?"

"If there be such, mayhap his grace the king did pro-
mulgate them whilst that I lay sick about the beginning
of the year and thereby failed to hear his proclamation."

"What do you know of the science of optics?"

"I know of governors of places, and seneschals of
castles, and sheriffs of counties, and many like small
offices and titles of honor, but him you call the Science
of Optics I have not heard of before; peradventure it
is a new dignity."

"Yes, in this country."

Try to conceive of this mollusk gravely applying for
an official position, of any kind under the sun! Why,
he had all the earmarks of a typewriter copyist, if you
leave out the disposition to contribute uninvited emen-
dations of your grammar and punctuation. It was
unaccountable that he didn't attempt a little help of
that sort out of his majestic supply of incapacity for
the job. But that didn't prove that he hadn't material
in him for the disposition, it only proved that he
wasn't a typewriter copyist yet. After nagging him a
little more, I let the professors loose on him and they
turned him inside out, on the line of scientific war, and
found him empty, of course. He knew somewhat
about the warfare of the time -- bushwhacking around
for ogres, and bull-fights in the tournament ring, and
such things -- but otherwise he was empty and useless.
Then we took the other young noble in hand, and he
was the first one's twin, for ignorance and incapacity.
I delivered them into the hands of the chairman of the
Board with the comfortable consciousness that their
cake was dough. They were examined in the previous
order of precedence.

"Name, so please you?"

"Pertipole, son of Sir Pertipole, Baron of Barley
Mash."

"Grandfather?"

"Also Sir Pertipole, Baron of Barley Mash."

"Great-grandfather?"

"The same name and title."

"Great-great-grandfather?"

"We had none, worshipful sir, the line failing be-
fore it had reached so far back."

"It mattereth not. It is a good four generations,
and fulfilleth the requirements of the rule."

"Fulfills what rule?" I asked.

"The rule requiring four generations of nobility or
else the candidate is not eligible."

"A man not eligible for a lieutenancy in the
army unless he can prove four generations of noble
descent?"

"Even so; neither lieutenant nor any other officer
may be commissioned without that qualification."

"Oh, come, this is an astonishing thing. What
good is such a qualification as that?"

"What good? It is a hardy question, fair sir and
Boss, since it doth go far to impugn the wisdom of
even our holy Mother Church herself."

"As how?"

"For that she hath established the self-same rule
regarding saints. By her law none may be canonized
until he hath lain dead four generations."

"I see, I see -- it is the same thing. It is wonder-
ful. In the one case a man lies dead-alive four genera-
tions -- mummified in ignorance and sloth -- and that
qualifies him to command live people, and take their
weal and woe into his impotent hands; and in the
other case, a man lies bedded with death and worms
four generations, and that qualifies him for office in the
celestial camp. Does the king's grace approve of this
strange law?"

The king said:

"Why, truly I see naught about it that is strange.
All places of honor and of profit do belong, by natural
right, to them that be of noble blood, and so these
dignities in the army are their property and would be
so without this or any rule. The rule is but to mark a
limit. Its purpose is to keep out too recent blood,
which would bring into contempt these offices, and
men of lofty lineage would turn their backs and scorn
to take them. I were to blame an I permitted this
calamity. YOU can permit it an you are minded so to
do, for you have the delegated authority, but that the
king should do it were a most strange madness and not
comprehensible to any."

"I yield. Proceed, sir Chief of the Herald's Col-
lege. "

The chairman resumed as follows:

"By what illustrious achievement for the honor of
the Throne and State did the founder of your great
line lift himself to the sacred dignity of the British
nobility?"

"He built a brewery."

"Sire, the Board finds this candidate perfect in all
the requirements and qualifications for military com-
mand, and doth hold his case open for decision after
due examination of his competitor."

The competitor came forward and proved exactly
four generations of nobility himself. So there was a
tie in military qualifications that far.

He stood aside a moment, and Sir Pertipole was
questioned further:

"Of what condition was the wife of the founder of
your line?"

"She came of the highest landed gentry, yet she
was not noble; she was gracious and pure and chari-
table, of a blameless life and character, insomuch that
in these regards was she peer of the best lady in the
land."

"That will do. Stand down." He called up the
competing lordling again, and asked: "What was the
rank and condition of the great-grandmother who con-
ferred British nobility upon your great house?"

"She was a king's leman and did climb to that
splendid eminence by her own unholpen merit from
the sewer where she was born."

"Ah, this, indeed, is true nobility, this is the right
and perfect intermixture. The lieutenancy is yours,
fair lord. Hold it not in contempt; it is the humble
step which will lead to grandeurs more worthy of the
splendor of an origin like to thine."

I was down in the bottomless pit of humiliation. I
had promised myself an easy and zenith-scouring
triumph, and this was the outcome!

I was almost ashamed to look my poor disappointed
cadet in the face. I told him to go home and be
patient, this wasn't the end.

I had a private audience with the king, and made a
proposition. I said it was quite right to officer that
regiment with nobilities, and he couldn't have done a
wiser thing. It would also be a good idea to add five
hundred officers to it; in fact, add as many officers
as there were nobles and relatives of nobles in the
country, even if there should finally be five times as
many officers as privates in it; and thus make it the
crack regiment, the envied regiment, the King's Own
regiment, and entitled to fight on its own hook and in
its own way, and go whither it would and come when
it pleased, in time of war, and be utterly swell and
independent. This would make that regiment the
heart's desire of all the nobility, and they would all
be satisfied and happy. Then we would make up the
rest of the standing army out of commonplace materi-
als, and officer it with nobodies, as was proper --
nobodies selected on a basis of mere efficiency -- and
we would make this regiment toe the line, allow it no
aristocratic freedom from restraint, and force it to do
all the work and persistent hammering, to the end that
whenever the King's Own was tired and wanted to go
off for a change and rummage around amongst ogres
and have a good time, it could go without uneasiness,
knowing that matters were in safe hands behind it, and
business going to be continued at the old stand, same
as usual. The king was charmed with the idea.

When I noticed that, it gave me a valuable notion.
I thought I saw my way out of an old and stubborn
difficulty at last. You see, the royalties of the Pen-
dragon stock were a long-lived race and very fruitful.
Whenever a child was born to any of these -- and it
was pretty often -- there was wild joy in the nation's
mouth, and piteous sorrow in the nation's heart. The
joy was questionable, but the grief was honest. Be-
cause the event meant another call for a Royal Grant.
Long was the list of these royalties, and they were a
heavy and steadily increasing burden upon the treasury
and a menace to the crown. Yet Arthur could not
believe this latter fact, and he would not listen to any
of my various projects for substituting something in
the place of the royal grants. If I could have per-
suaded him to now and then provide a support for one
of these outlying scions from his own pocket, I could
have made a grand to-do over it, and it would have
had a good effect with the nation; but no, he wouldn't
hear of such a thing. He had something like a
religious passion for royal grant; he seemed to look
upon it as a sort of sacred swag, and one could not
irritate him in any way so quickly and so surely as by
an attack upon that venerable institution. If I ven-
tured to cautiously hint that there was not another
respectable family in England that would humble itself
to hold out the hat -- however, that is as far as I ever
got; he always cut me short there, and peremptorily,
too.

But I believed I saw my chance at last. I would
form this crack regiment out of officers alone -- not a
single private. Half of it should consist of nobles,
who should fill all the places up to Major-General, and
serve gratis and pay their own expenses; and they
would be glad to do this when they should learn that
the rest of the regiment would consist exclusively of
princes of the blood. These princes of the blood should
range in rank from Lieutenant-General up to Field
Marshal, and be gorgeously salaried and equipped and
fed by the state. Moreover -- and this was the master
stroke -- it should be decreed that these princely gran-
dees should be always addressed by a stunningly gaudy
and awe-compelling title (which I would presently in-
vent), and they and they only in all England should
be so addressed. Finally, all princes of the blood
should have free choice; join that regiment, get that
great title, and renounce the royal grant, or stay out
and receive a grant. Neatest touch of all: unborn but
imminent princes of the blood could be BORN into the
regiment, and start fair, with good wages and a per-
manent situation, upon due notice from the parents.

All the boys would join, I was sure of that; so, all
existing grants would be relinquished; that the newly
born would always join was equally certain. Within
sixty days that quaint and bizarre anomaly, the Royal
Grant, would cease to be a living fact, and take its
place among the curiosities of the past.


CHAPTER XXVI.
THE FIRST NEWSPAPER

WHEN I told the king I was going out disguised as
a petty freeman to scour the country and
familiarize myself with the humbler life of the people,
he was all afire with the novelty of the thing in a
minute, and was bound to take a chance in the adven-
ture himself -- nothing should stop him -- he would
drop everything and go along -- it was the prettiest
idea he had run across for many a day. He wanted
to glide out the back way and start at once; but I
showed him that that wouldn't answer. You see, he
was billed for the king's-evil -- to touch for it, I mean
-- and it wouldn't be right to disappoint the house
and it wouldn't make a delay worth considering, any-
way, it was only a one-night stand. And I thought
he ought to tell the queen he was going away. He
clouded up at that and looked sad. I was sorry I had
spoken, especially when he said mournfully:

"Thou forgettest that Launcelot is here; and where
Launcelot is, she noteth not the going forth of the
king, nor what day he returneth."

Of course, I changed the Subject. Yes, Guenever
was beautiful, it is true, but take her all around she
was pretty slack. I never meddled in these matters,
they weren't my affair, but I did hate to see the way
things were going on, and I don't mind saying that
much. Many's the time she had asked me, "Sir
Boss, hast seen Sir Launcelot about?" but if ever she
went fretting around for the king I didn't happen to be
around at the time.

There was a very good lay-out for the king's-evil
business -- very tidy and creditable. The king sat
under a canopy of state; about him were clustered a
large body of the clergy in full canonicals. Conspicu-
ous, both for location and personal outfit, stood
Marinel, a hermit of the quack-doctor species, to
introduce the sick. All abroad over the spacious
floor, and clear down to the doors, in a thick jumble,
lay or sat the scrofulous, under a strong light. It
was as good as a tableau; in fact, it had all the look
of being gotten up for that, though it wasn't. There
were eight hundred sick people present. The work
was slow; it lacked the interest of novelty for me,
because I had seen the ceremonies before; the thing
soon became tedious, but the proprieties required me
to stick it out. The doctor was there for the reason
that in all such crowds there were many people who
only imagined something was the matter with them,
and many who were consciously sound but wanted the
immortal honor of fleshly contact with a king, and yet
others who pretended to illness in order to get the
piece of coin that went with the touch. Up to this
time this coin had been a wee little gold piece worth
about a third of a dollar. When you consider how
much that amount of money would buy, in that age
and country, and how usual it was to be scrofulous,
when not dead, you would understand that the annual
king's-evil appropriation was just the River and Harbor
bill of that government for the grip it took on the
treasury and the chance it afforded for skinning the
surplus. So I had privately concluded to touch the
treasury itself for the king's-evil. I covered six-
sevenths of the appropriation into the treasury a week
before starting from Camelot on my adventures, and
ordered that the other seventh be inflated into five-
cent nickels and delivered into the hands of the head
clerk of the King's Evil Department; a nickel to take
the place of each gold coin, you see, and do its work
for it. It might strain the nickel some, but I judged it
could stand it. As a rule, I do not approve of water-
ing stock, but I considered it square enough in this
case, for it was just a gift, anyway. Of course, you
can water a gift as much as you want to; and I gener-
ally do. The old gold and silver coins of the country
were of ancient and unknown origin, as a rule, but
some of them were Roman; they were ill-shapen, and
seldom rounder than a moon that is a week past the
full; they were hammered, not minted, and they were
so worn with use that the devices upon them were as
illegible as blisters, and looked like them. I judged
that a sharp, bright new nickel, with a first-rate like-
ness of the king on one side of it and Guenever on the
other, and a blooming pious motto, would take the
tuck out of scrofula as handy as a nobler coin and
please the scrofulous fancy more; and I was right.
This batch was the first it was tried on, and it worked
to a charm. The saving in expense was a notable
economy. You will see that by these figures: We
touched a trifle over 700 of the 800 patients; at former
rates, this would have cost the government about
$240; at the new rate we pulled through for about
$35, thus saving upward of $200 at one swoop. To
appreciate the full magnitude of this stroke, consider
these other figures: the annual expenses of a national
government amount to the equivalent of a contribution
of three days' average wages of every individual of the
population, counting every individual as if he were a
man. If you take a nation of 60,000,000, where
average wages are $2 per day, three days' wages taken
from each individual will provide $360,000,000 and
pay the government's expenses. In my day, in my
own country, this money was collected from imposts,
and the citizen imagined that the foreign importer paid
it, and it made him comfortable to think so; whereas,
in fact, it was paid by the American people, and was
so equally and exactly distributed among them that
the annual cost to the 100-millionaire and the annual
cost to the sucking child of the day-laborer was pre-
cisely the same -- each paid $6. Nothing could be
equaler than that, I reckon. Well, Scotland and
Ireland were tributary to Arthur, and the united popu-
lations of the British Islands amounted to something
less than 1,OOO,OOO. A mechanic's average wage was
3 cents a day, when he paid his own keep. By this
rule the national government's expenses were $90,000
a year, or about $250 a day. Thus, by the substitu-
tion of nickels for gold on a king's-evil day, I not
only injured no one, dissatisfied no one, but pleased
all concerned and saved four-fifths of that day's
national expense into the bargain -- a saving which
would have been the equivalent of $800,000 in my
day in America. In making this substitution I had
drawn upon the wisdom of a very remote source -- the
wisdom of my boyhood -- for the true statesman does
not despise any wisdom, howsoever lowly may be its
origin: in my boyhood I had always saved my pennies
and contributed buttons to the foreign missionary
cause. The buttons would answer the ignorant savage
as well as the coin, the coin would answer me better
than the buttons; all hands were happy and nobody
hurt.

Marinel took the patients as they came. He ex-
amined the candidate; if he couldn't qualify he was
warned off; if he could he was passed along to the
king. A priest pronounced the words, "They shall
lay their hands on the sick, and they shall recover."
Then the king stroked the ulcers, while the reading
continued; finally, the patient graduated and got his
nickel -- the king hanging it around his neck himself --
and was dismissed. Would you think that that would
cure? It certainly did. Any mummery will cure if
the patient's faith is strong in it. Up by Astolat there
was a chapel where the Virgin had once appeared to a
girl who used to herd geese around there -- the girl
said so herself -- and they built the chapel upon that
spot and hung a picture in it representing the occur-
rence -- a picture which you would think it dangerous
for a sick person to approach; whereas, on the con-
trary, thousands of the lame and the sick came and
prayed before it every year and went away whole and
sound; and even the well could look upon it and live.
Of course, when I was told these things I did not be-
lieve them; but when I went there and saw them I had
to succumb. I saw the cures effected myself; and
they were real cures and not questionable. I saw
cripples whom I had seen around Camelot for years
on crutches, arrive and pray before that picture, and
put down their crutches and walk off without a limp.
There were piles of crutches there which had been left
by such people as a testimony.

In other places people operated on a patient's mind,
without saying a word to him, and cured him. In
others, experts assembled patients in a room and
prayed over them, and appealed to their faith, and
those patients went away cured. Wherever you find a
king who can't cure the king's-evil you can be sure
that the most valuable superstition that supports his
throne -- the subject's belief in the divine appointment
of his sovereign -- has passed away. In my youth the
monarchs of England had ceased to touch for the evil,
but there was no occasion for this diffidence: they
could have cured it forty-nine times in fifty.

Well, when the priest had been droning for three
hours, and the good king polishing the evidences, and
the sick were still pressing forward as plenty as ever, I
got to feeling intolerably bored. I was sitting by an
open window not far from the canopy of state. For
the five hundredth time a patient stood forward to have
his repulsivenesses stroked; again those words were
being droned out: "they shall lay their hands on the
sick" -- when outside there rang clear as a clarion a
note that enchanted my soul and tumbled thirteen
worthless centuries about my ears: "Camelot WEEKLY
HOSANNAH AND LITERARY VOLCANO! -- latest irruption --
only two cents -- all about the big miracle in the
Valley of Holiness!" One greater than kings had
arrived -- the newsboy. But I was the only person in
all that throng who knew the meaning of this mighty
birth, and what this imperial magician was come into
the world to do.

I dropped a nickel out of the window and got my
paper; the Adam-newsboy of the world went around
the corner to get my change; is around the corner
yet. It was delicious to see a newspaper again, yet I
was conscious of a secret shock when my eye fell upon
the first batch of display head-lines. I had lived in a
clammy atmosphere of reverence, respect, deference,
so long that they sent a quivery little cold wave
through me:

              HIGH TIMES IN THE VALLEY

                    OF HOLINESS!

                        ----

               THE WATER-WORKS CORKED!

                        ----

         BRER MERLIN WORKS HIS ARTS, BUT GETS
                        LEFT?

                        ----

      But the Boss scores on his first Innings!

                        ----

          The Miraculous Well Uncorked amid
                  awful outbursts of

              INFERNAL FIRE AND SMOKE
                     ATHUNDER!

                        ----

           THE BUZZARD-ROOST ASTONISHED!

                        ----

              UNPARALLELED REJOIBINGS!

-- and so on, and so on. Yes, it was too loud. Once
I could have enjoyed it and seen nothing out of the
way about it, but now its note was discordant. It was
good Arkansas journalism, but this was not Arkansas.
Moreover, the next to the last line was calculated to
give offense to the hermits, and perhaps lose us their
advertising. Indeed, there was too lightsome a tone
of flippancy all through the paper. It was plain I had
undergone a considerable change without noticing it.
I found myself unpleasantly affected by pert little
irreverencies which would have seemed but proper and
airy graces of speech at an earlier period of my life.
There was an abundance of the following breed of
items, and they discomforted me:

   LOCAL SMOKE AND CINDERS.

   Sir Launcelot met up with old King
   Agrivance of Ireland unexpectedly last
   weok over on the moor south of Sir
   Balmoral le Merveilleuse's hog dasture.
   The widow has been notified.

   Expedition No. 3 will start adout the
   first of mext month on a search f8r Sir
   Sagramour le Desirous. It is in com-
   and of the renowned Knight of the Red
   Lawns, assissted by Sir Persant of Inde,
   who is compete9t. intelligent, courte-
   ous, and in every way a brick, and fur-
   tHer assisted by Sir Palamides the Sara-
   cen, who is no huckleberry hinself.
   This is no pic-nic, these boys mean
   busine&s.

   The readers of the Hosannah will re-
   gret to learn that the hadndsome and
   popular Sir Charolais of Gaul, who dur-
   ing his four weeks' stay at the Bull and
   Halibut, this city, has won every heart
   by his polished manners and elegant
   cPnversation, will pUll out to-day for
   home. Give us another call, Charley!

   The bdsiness end of the funeral of
   the late Sir Dalliance the duke's son of
   Cornwall, killed in an encounter with
   the Giant of the Knotted Bludgeon last
   Tuesday on the borders of the Plain of
   Enchantment was in the hands of the
   ever affable and efficient Mumble,
   prince of un3ertakers, then whom there
   exists none by whom it were a more
   satisfying pleasure to have the last sad
   offices performed. Give him a trial.

   The cordial thanks of the Hosannah
   office are due, from editor down to
   devil, to the ever courteous and thought-
   ful Lord High Stew d of the Palace's
   Third Assistant V  t for several sau-
   ceTs of ice crEam a quality calculated
   to make the ey of the recipients hu-
   mid with grt  ude; and it done it.
   When this  administration wants to
   chalk up a desirable name for early
   promotion, the Hosannah would like a
   chance to sudgest.

   The Demoiselle Irene Dewlap, of
   South Astolat, is visiting her uncle, the
   popular host of the Cattlemen's Board-
   ing Ho&se, Liver Lane, this city.

   Young Barker the bellows-mender is
   hoMe again, and looks much improved
   by his vacation round-up among the ut-
   lying smithies. See his ad.

       A Yankee in King Arthur's Court     239

Of course it was good enough journalism for a be-
ginning; I knew that quite well, and yet it was some-
how disappointing. The "Court Circular" pleased
me better; indeed, its simple and dignified respect-
fulness was a distinct refreshment to me after all those
disgraceful familiarities. But even it could have been
improved. Do what one may, there is no getting an
air of variety into a court circular, I acknowledge that.
There is a profound monotonousness about its facts
that baffles and defeats one's sincerest efforts to make
them sparkle and enthuse. The best way to manage --
in fact, the only sensible way -- is to disguise repeti-
tiousness of fact under variety of form: skin your fact
each time and lay on a new cuticle of words. It de-
ceives the eye; you think it is a new fact; it gives you
the idea that the court is carrying on like everything;
this excites you, and you drain the whole column, with
a good appetite, and perhaps never notice that it's a
barrel of soup made out of a single bean. Clarence's
way was good, it was simple, it was dignified, it was
direct and business-like; all I say is, it was not the
best way:

             COURT CIRCULAR.

   On Monday, the king rode in the park.
   "  Tuesday,      "      "        "
   "  Wendesday     "      "        "
   "  Thursday      "      "        "
   "  Friday,       "      "        "
   "  Saturday      "      "        "
   "  Sunday,       "      "        "

However, take the paper by and large, I was vastly
pleased with it. Little crudities of a mechanical sort
were observable here and there, but there were not
enough of them to amount to anything, and it was
good enough Arkansas proof-reading, anyhow, and
better than was needed in Arthur's day and realm.
As a rule, the grammar was leaky and the construc-
tion more or less lame; but I did not much mind these
things. They are common defects of my own, and
one mustn't criticise other people on grounds where he
can't stand perpendicular himself.

I was hungry enough for literature to want to take
down the whole paper at this one meal, but I got only
a few bites, and then had to postpone, because the
monks around me besieged me so with eager ques-
tions: What is this curious thing? What is it for? Is
it a handkerchief? -- saddle blanket? -- part of a shirt?
What is it made of? How thin it is, and how dainty
and frail; and how it rattles. Will it wear, do you
think, and won't the rain injure it? Is it writing that
appears on it, or is it only ornamentation? They sus-
pected it was writing, because those among them who
knew how to read Latin and had a smattering of
Greek, recognized some of the letters, but they could
make nothing out of the result as a whole. I put my
information in the simplest form I could:

"It is a public journal; I will explain what that is,
another time. It is not cloth, it is made of paper;
some time I will explain what paper is. The lines on
it are reading matter; and not written by hand, but
printed; by and by I will explain what printing is. A
thousand of these sheets have been made, all exactly
like this, in every minute detail -- they can't be told
apart." Then they all broke out with exclamations of
surprise and admiration:

"A thousand! Verily a mighty work -- a year's
work for many men."

"No -- merely a day's work for a man and a boy."

They crossed themselves, and whiffed out a protec-
tive prayer or two.

"Ah-h -- a miracle, a wonder! Dark work of en-
chantment."

I let it go at that. Then I read in a low voice, to as
many as could crowd their shaven heads within hearing
distance, part of the account of the miracle of the
restoration of the well, and was accompanied by aston-
ished and reverent ejaculations all through: "Ah-h-h!"
"How true!" "Amazing, amazing!" "These be
the very haps as they happened, in marvelous exact-
ness!" And might they take this strange thing in
their hands, and feel of it and examine it? -- they
would be very careful. Yes. So they took it, hand-
ling it as cautiously and devoutly as if it had been
some holy thing come from some supernatural region;
and gently felt of its texture, caressed its pleasant
smooth surface with lingering touch, and scanned the
mysterious characters with fascinated eyes. These
grouped bent heads, these charmed faces, these speak-
ing eyes -- how beautiful to me! For was not this my
darling, and was not all this mute wonder and interest
and homage a most eloquent tribute and unforced
compliment to it? I knew, then, how a mother feels
when women, whether strangers or friends, take her
new baby, and close themselves about it with one
eager impulse, and bend their heads over it in a
tranced adoration that makes all the rest of the uni-
verse vanish out of their consciousness and be as if it
were not, for that time. I knew how she feels, and
that there is no other satisfied ambition, whether of
king, conqueror, or poet, that ever reaches half-way to
that serene far summit or yields half so divine a con-
tentment.

During all the rest of the seance my paper traveled
from group to group all up and down and about that
huge hall, and my happy eye was upon it always, and
I sat motionless, steeped in satisfaction, drunk with
enjoyment. Yes, this was heaven; I was tasting it
once, if I might never taste it more.


CHAPTER XXVII.
THE YANKEE AND THE KING TRAVEL INCOGNITO

ABOUT bedtime I took the king to my private
quarters to cut his hair and help him get the
hang of the lowly raiment he was to wear. The high
classes wore their hair banged across the forehead but
hanging to the shoulders the rest of the way around,
whereas the lowest ranks of commoners were banged
fore and aft both; the slaves were bangless, and
allowed their hair free growth. So I inverted a bowl
over his head and cut away all the locks that hung
below it. I also trimmed his whiskers and mustache
until they were only about a half-inch long; and tried
to do it inartistically, and succeeded. It was a villainous
disfigurement. When he got his lubberly sandals on,
and his long robe of coarse brown linen cloth, which
hung straight from his neck to his ankle-bones, he was
no longer the comeliest man in his kingdom, but one
of the unhandsomest and most commonplace and un-
attractive. We were dressed and barbered alike, and
could pass for small farmers, or farm bailiffs, or
shepherds, or carters; yes, or for village artisans, if
we chose, our costume being in effect universal among
the poor, because of its strength and cheapness. I
don't mean that it was really cheap to a very poor
person, but I do mean that it was the cheapest material
there was for male attire -- manufactured material, you
understand.

We slipped away an hour before dawn, and by broad
sun-up had made eight or ten miles, and were in the
midst of a sparsely settled country. I had a pretty
heavy knapsack; it was laden with provisions -- pro-
visions for the king to taper down on, till he could
take to the coarse fare of the country without damage.

I found a comfortable seat for the king by the road-
side, and then gave him a morsel or two to stay his
stomach with. Then I said I would find some water
for him, and strolled away. Part of my project was to
get out of sight and sit down and rest a little myself.
It had always been my custom to stand when in his
presence; even at the council board, except upon
those rare occasions when the sitting was a very long
one, extending over hours; then I had a trifling little
backless thing which was like a reversed culvert and
was as comfortable as the toothache. I didn't want to
break him in suddenly, but do it by degrees. We
should have to sit together now when in company, or
people would notice; but it would not be good politics
for me to be playing equality with him when there was
no necessity for it.

I found the water some three hundred yards away,
and had been resting about twenty minutes, when I
heard voices. That is all right, I thought -- peasants
going to work; nobody else likely to be stirring this
early. But the next moment these comers jingled into
sight around a turn of the road -- smartly clad people
of quality, with luggage-mules and servants in their
train! I was off like a shot, through the bushes, by
the shortest cut. For a while it did seem that these
people would pass the king before I could get to him;
but desperation gives you wings, you know, and I
canted my body forward, inflated my breast, and held
my breath and flew. I arrived. And in plenty good
enough time, too.

"Pardon, my king, but it's no time for ceremony --
jump! Jump to your feet -- some quality are coming!"

"Is that a marvel? Let them come."

"But my liege! You must not be seen sitting.
Rise! -- and stand in humble posture while they pass.
You are a peasant, you know."

"True -- I had forgot it, so lost was I in planning
of a huge war with Gaul" -- he was up by this time,
but a farm could have got up quicker, if there was
any kind of a boom in real estate -- "and right-so a
thought came randoming overthwart this majestic
dream the which --"

"A humbler attitude, my lord the king -- and
quick! Duck your head! -- more! -- still more! --
droop it!"

He did his honest best, but lord, it was no great
things. He looked as humble as the leaning tower at
Pisa. It is the most you could say of it. Indeed, it
was such a thundering poor success that it raised
wondering scowls all along the line, and a gorgeous
flunkey at the tail end of it raised his whip; but I
jumped in time and was under it when it fell; and
under cover of the volley of coarse laughter which fol-
lowed, I spoke up sharply and warned the king to take
no notice. He mastered himself for the moment, but
it was a sore tax; he wanted to eat up the procession.
I said:

"It would end our adventures at the very start;
and we, being without weapons, could do nothing with
that armed gang. If we are going to succeed in our
emprise, we must not only look the peasant but act
the peasant."

"It is wisdom; none can gainsay it. Let us go on,
Sir Boss. I will take note and learn, and do the best
I may."

He kept his word. He did the best he could, but
I've seen better. If you have ever seen an active,
heedless, enterprising child going diligently out of
one mischief and into another all day long, and an
anxious mother at its heels all the while, and just
saving it by a hair from drowning itself or breaking
its neck with each new experiment, you've seen the
king and me.

If I could have foreseen what the thing was going to
be like, I should have said, No, if anybody wants to
make his living exhibiting a king as a peasant, let him
take the layout; I can do better with a menagerie, and
last longer. And yet, during the first three days I
never allowed him to enter a hut or other dwelling. If
he could pass muster anywhere during his early
novitiate it would be in small inns and on the road;
so to these places we confined ourselves. Yes, he
certainly did the best he could, but what of that? He
didn't improve a bit that I could see.

He was always frightening me, always breaking out
with fresh astonishers, in new and unexpected places.
Toward evening on the second day, what does he do
but blandly fetch out a dirk from inside his robe!

"Great guns, my liege, where did you get that?"

"From a smuggler at the inn, yester eve."

"What in the world possessed you to buy it?"

"We have escaped divers dangers by wit -- thy wit
-- but I have bethought me that it were but prudence
if I bore a weapon, too. Thine might fail thee in
some pinch."

"But people of our condition are not allowed to
carry arms. What would a lord say -- yes, or any
other person of whatever condition -- if he caught an
upstart peasant with a dagger on his person?"

It was a lucky thing for us that nobody came along
just then. I persuaded him to throw the dirk away;
and it was as easy as persuading a child to give up
some bright fresh new way of killing itself. We walked
along, silent and thinking. Finally the king said:

"When ye know that I meditate a thing incon-
venient, or that hath a peril in it, why do you not
warn me to cease from that project?"

It was a startling question, and a puzzler. I didn't
quite know how to take hold of it, or what to say, and
so, of course, I ended by saying the natural thing:

"But, sire, how can I know what your thoughts
are?"

The king stopped dead in his tracks, and stared at
me.

"I believed thou wert greater than Merlin; and
truly in magic thou art. But prophecy is greater than
magic. Merlin is a prophet."

I saw I had made a blunder. I must get back my
lost ground. After a deep reflection and careful plan-
ning, I said:

"Sire, I have been misunderstood. I will explain.
There are two kinds of prophecy. One is the gift to
foretell things that are but a little way off, the other is
the gift to foretell things that are whole ages and
centuries away. Which is the mightier gift, do you
think?"

"Oh, the last, most surely!"

"True. Does Merlin possess it?"

"Partly, yes. He foretold mysteries about my birth
and future kingship that were twenty years away."

"Has he ever gone beyond that?"

"He would not claim more, I think."

"It is probably his limit. All prophets have their
limit. The limit of some of the great prophets has
been a hundred years."

"These are few, I ween."

"There have been two still greater ones, whose limit
was four hundred and six hundred years, and one
whose limit compassed even seven hundred and
twenty."

"Gramercy, it is marvelous!"

"But what are these in comparison with me? They
are nothing."

"What? Canst thou truly look beyond even so
vast a stretch of time as --"

"Seven hundred years? My liege, as clear as the
vision of an eagle does my prophetic eye penetrate and
lay bare the future of this world for nearly thirteen
centuries and a half!"

My land, you should have seen the king's eyes
spread slowly open, and lift the earth's entire atmos-
phere as much as an inch! That settled Brer Merlin.
One never had any occasion to prove his facts, with
these people; all he had to do was to state them. It
never occurred to anybody to doubt the statement.

"Now, then," I continued, "I COULD work both
kinds of prophecy -- the long and the short -- if I
chose to take the trouble to keep in practice; but I
seldom exercise any but the long kind, because the
other is beneath my dignity. It is properer to Merlin's
sort -- stump-tail prophets, as we call them in the pro-
fession. Of course, I whet up now and then and flirt
out a minor prophecy, but not often -- hardly ever, in
fact. You will remember that there was great talk,
when you reached the Valley of Holiness, about my
having prophesied your coming and the very hour of
your arrival, two or three days beforehand."

"Indeed, yes, I mind it now."

"Well, I could have done it as much as forty times
easier, and piled on a thousand times more detail into
the bargain, if it had been five hundred years away
instead of two or three days."

"How amazing that it should be so!"

"Yes, a genuine expert can always foretell a thing
that is five hundred years away easier than he can a
thing that's only five hundred seconds off."

"And yet in reason it should clearly be the other
way; it should be five hundred times as easy to fore-
tell the last as the first, for, indeed, it is so close by
that one uninspired might almost see it. In truth, the
law of prophecy doth contradict the likelihoods, most
strangely making the difficult easy, and the easy
difficult."

It was a wise head. A peasant's cap was no safe
disguise for it; you could know it for a king's under a
diving-bell, if you could hear it work its intellect.

I had a new trade now, and plenty of business in it.
The king was as hungry to find out everything that was
going to happen during the next thirteen centuries as
if he were expecting to live in them. From that time
out, I prophesied myself bald-headed trying to supply
the demand. I have done some indiscreet things in
my day, but this thing of playing myself for a prophet
was the worst. Still, it had its ameliorations. A
prophet doesn't have to have any brains. They are
good to have, of course, for the ordinary exigencies of
life, but they are no use in professional work. It is
the restfulest vocation there is. When the spirit of
prophecy comes upon you, you merely cake your
intellect and lay it off in a cool place for a rest, and
unship your jaw and leave it alone; it will work itself:
the result is prophecy.

Every day a knight-errant or so came along, and
the sight of them fired the king's martial spirit every
time. He would have forgotten himself, sure, and
said something to them in a style a suspicious shade
or so above his ostensible degree, and so I always got
him well out of the road in time. Then he would stand
and look with all his eyes; and a proud light would
flash from them, and his nostrils would inflate like a
war-horse's, and I knew he was longing for a brush
with them. But about noon of the third day I had
stopped in the road to take a precaution which had
been suggested by the whip-stroke that had fallen to
my share two days before; a precaution which I had
afterward decided to leave untaken, I was so loath to
institute it; but now I had just had a fresh reminder:
while striding heedlessly along, with jaw spread and
intellect at rest, for I was prophesying, I stubbed my
toe and fell sprawling. I was so pale I couldn't think
for a moment; then I got softly and carefully up and
unstrapped my knapsack. I had that dynamite bomb
in it, done up in wool in a box. It was a good thing
to have along; the time would come when I could do
a valuable miracle with it, maybe, but it was a nervous
thing to have about me, and I didn't like to ask the
king to carry it. Yet I must either throw it away or
think up some safe way to get along with its society.
I got it out and slipped it into my scrip, and just then
here came a couple of knights. The king stood,
stately as a statue, gazing toward them -- had for-
gotten himself again, of course -- and before I could
get a word of warning out, it was time for him to skip,
and well that he did it, too. He supposed they would
turn aside. Turn aside to avoid trampling peasant dirt
under foot? When had he ever turned aside himself --
or ever had the chance to do it, if a peasant saw him
or any other noble knight in time to judiciously save
him the trouble? The knights paid no attention to
the king at all; it was his place to look out himself,
and if he hadn't skipped he would have been placidly
ridden down, and laughed at besides.

The king was in a flaming fury, and launched out
his challenge and epithets with a most royal vigor.
The knights were some little distance by now. They
halted, greatly surprised, and turned in their saddles
and looked back, as if wondering if it might be worth
while to bother with such scum as we. Then they
wheeled and started for us. Not a moment must be
lost. I started for THEM. I passed them at a rattling
gait, and as I went by I flung out a hair-lifting soul-
scorching thirteen-jointed insult which made the king's
effort poor and cheap by comparison. I got it out of
the nineteenth century where they know how. They
had such headway that they were nearly to the king
before they could check up; then, frantic with rage,
they stood up their horses on their hind hoofs and
whirled them around, and the next moment here they
came, breast to breast. I was seventy yards off, then,
and scrambling up a great bowlder at the roadside.
When they were within thirty yards of me they let their
long lances droop to a level, depressed their mailed
heads, and so, with their horse-hair plumes streaming
straight out behind, most gallant to see, this lightning
express came tearing for me! When they were within
fifteen yards, I sent that bomb with a sure aim, and it
struck the ground just under the horses' noses.

Yes, it was a neat thing, very neat and pretty to
see. It resembled a steamboat explosion on the Mis-
sissippi; and during the next fifteen minutes we stood
under a steady drizzle of microscopic fragments of
knights and hardware and horse-flesh. I say we, for
the king joined the audience, of course, as soon as he
had got his breath again. There was a hole there
which would afford steady work for all the people in
that region for some years to come -- in trying to ex-
plain it, I mean; as for filling it up, that service would
be comparatively prompt, and would fall to the lot of
a select few -- peasants of that seignory; and they
wouldn't get anything for it, either.

But I explained it to the king myself. I said it was
done with a dynamite bomb, This information did
him no damage, because it left him as intelligent as he
was before. However, it was a noble miracle, in his
eyes, and was another settler for Merlin. I thought it
well enough to explain that this was a miracle of so
rare a sort that it couldn't be done except when the
atmospheric conditions were just right. Otherwise he
would be encoring it every time we had a good sub-
ject, and that would be inconvenient, because I hadn't
any more bombs along.


CHAPTER XXVIII.
DRILLING THE KING

ON the morning of the fourth day, when it was just
sunrise, and we had been tramping an hour in
the chill dawn, I came to a resolution: the king MUST
be drilled; things could not go on so, he must be
taken in hand and deliberately and conscientiously
drilled, or we couldn't ever venture to enter a dwelling;
the very cats would know this masquerader for a hum-
bug and no peasant. So I called a halt and said:

"Sire, as between clothes and countenance, you are
all right, there is no discrepancy; but as between your
clothes and your bearing, you are all wrong, there is a
most noticeable discrepancy. Your soldierly stride,
your lordly port -- these will not do. You stand too
straight, your looks are too high, too confident. The
cares of a kingdom do not stoop the shoulders, they do
not droop the chin, they do not depress the high level
of the eye-glance, they do not put doubt and fear in
the heart and hang out the signs of them in slouching
body and unsure step. It is the sordid cares of the
lowly born that do these things. You must learn the
trick; you must imitate the trademarks of poverty,
misery, oppression, insult, and the other several and
common inhumanities that sap the manliness out of a
man and make him a loyal and proper and approved
subject and a satisfaction to his masters, or the very
infants will know you for better than your disguise,
and we shall go to pieces at the first hut we stop at.
Pray try to walk like this."

The king took careful note, and then tried an
imitation.

"Pretty fair -- pretty fair. Chin a little lower,
please -- there, very good. Eyes too high; pray don't
look at the horizon, look at the ground, ten steps in
front of you. Ah -- that is better, that is very good.
Wait, please; you betray too much vigor, too much
decision; you want more of a shamble. Look at me,
please -- this is what I mean......Now you are get-
ting it; that is the idea -- at least, it sort of approaches
it......Yes, that is pretty fair. BUT! There is a
great big something wanting, I don't quite know what
it is. Please walk thirty yards, so that I can get
a perspective on the thing......Now, then -- your
head's right, speed's right, shoulders right, eyes right,
chin right, gait, carriage, general style right -- every-
thing's right! And yet the fact remains, the aggre-
gate's wrong. The account don't balance. Do it
again, please......NOW I think I begin to see what it
is. Yes, I've struck it. You see, the genuine spirit-
lessness is wanting; that's what's the trouble. It's all
AMATUEUR -- mechanical details all right, almost to a
hair; everything about the delusion perfect, except
that it don't delude."

"What, then, must one do, to prevail?"

"Let me think......I can't seem to quite get at it.
In fact, there isn't anything that can right the matter
but practice. This is a good place for it: roots and
stony ground to break up your stately gait, a region
not liable to interruption, only one field and one hut in
sight, and they so far away that nobody could see us
from there. It will be well to move a little off the
road and put in the whole day drilling you, sire."

After the drill had gone on a little while, I said:

"Now, sire, imagine that we are at the door of the
hut yonder, and the family are before us. Proceed,
please -- accost the head of the house."

The king unconsciously straightened up like a monu-
ment, and said, with frozen austerity:

"Varlet, bring a seat; and serve to me what cheer
ye have."

"Ah, your grace, that is not well done."

"In what lacketh it?"

"These people do not call EACH OTHER varlets."

"Nay, is that true?"

"Yes; only those above them call them so."

"Then must I try again. I will call him villein."

"No-no; for he may be a freeman."

"Ah -- so. Then peradventure I should call him
goodman."

"That would answer, your grace, but it would be
still better if you said friend, or brother."

"Brother! -- to dirt like that?"

"Ah, but WE are pretending to be dirt like that,
too."

"It is even true. I will say it. Brother, bring a
seat, and thereto what cheer ye have, withal. Now
'tis right."

"Not quite, not wholly right. You have asked for
one, not US -- for one, not both; food for one, a seat
for one."

The king looked puzzled -- he wasn't a very heavy
weight, intellectually. His head was an hour-glass; it
could stow an idea, but it had to do it a grain at a
time, not the whole idea at once.

"Would YOU have a seat also -- and sit?"

"If I did not sit, the man would perceive that we
were only pretending to be equals -- and playing the
deception pretty poorly, too."

"It is well and truly said! How wonderful is truth,
come it in whatsoever unexpected form it may! Yes,
he must bring out seats and food for both, and in
serving us present not ewer and napkin with more
show of respect to the one than to the other."

"And there is even yet a detail that needs correct-
ing. He must bring nothing outside; we will go in --
in among the dirt, and possibly other repulsive things,
-- and take the food with the household, and after the
fashion of the house, and all on equal terms, except the
man be of the serf class; and finally, there will be no
ewer and no napkin, whether he be serf or free. Please
walk again, my liege. There -- it is better -- it is the
best yet; but not perfect. The shoulders have known
no ignobler burden than iron mail, and they will not
stoop."

"Give me, then, the bag. I will learn the spirit
that goeth with burdens that have not honor. It is
the spirit that stoopeth the shoulders, I ween, and not
the weight; for armor is heavy, yet it is a proud
burden, and a man standeth straight in it......Nay,
but me no buts, offer me no objections. I will have
the thing. Strap it upon my back."

He was complete now with that knapsack on, and
looked as little like a king as any man I had ever seen.
But it was an obstinate pair of shoulders; they could
not seem to learn the trick of stooping with any sort of
deceptive naturalness. The drill went on, I prompting
and correcting:

"Now, make believe you are in debt, and eaten up
by relentless creditors; you are out of work -- which
is horse-shoeing, let us say -- and can get none; and
your wife is sick, your children are crying because
they are hungry --"

And so on, and so on. I drilled him as represent-
ing in turn all sorts of people out of luck and suffering
dire privations and misfortunes. But lord, it was only
just words, words -- they meant nothing in the world
to him, I might just as well have whistled. Words
realize nothing, vivify nothing to you, unless you have
suffered in your own person the thing which the words
try to describe. There are wise people who talk ever
so knowingly and complacently about "the working
classes," and satisfy themselves that a day's hard in-
tellectual work is very much harder than a day's hard
manual toil, and is righteously entitled to much bigger
pay. Why, they really think that, you know, because
they know all about the one, but haven't tried the
other. But I know all about both; and so far as I am
concerned, there isn't money enough in the universe
to hire me to swing a pickaxe thirty days, but I will do
the hardest kind of intellectual work for just as near
nothing as you can cipher it down -- and I will be
satisfied, too.

Intellectual "work" is misnamed; it is a pleasure,
a dissipation, and is its own highest reward. The
poorest paid architect, engineer, general, author,
sculptor, painter, lecturer, advocate, legislator, actor,
preacher, singer is constructively in heaven when he is
at work; and as for the musician with the fiddle-bow
in his hand who sits in the midst of a great orchestra
with the ebbing and flowing tides of divine sound
washing over him -- why, certainly, he is at work, if
you wish to call it that, but lord, it's a sarcasm just
the same. The law of work does seem utterly unfair
-- but there it is, and nothing can change it: the
higher the pay in enjoyment the worker gets out of it,
the higher shall be his pay in cash, also. And it's
also the very law of those transparent swindles, trans-
missible nobility and kingship.


CHAPTER XXIX.
THE SMALLPOX HUT

WHEN we arrived at that hut at mid-afternoon, we
saw no signs of life about it. The field near by
had been denuded of its crop some time before, and
had a skinned look, so exhaustively had it been har-
vested and gleaned. Fences, sheds, everything had a
ruined look, and were eloquent of poverty. No animal
was around anywhere, no living thing in sight. The
stillness was awful, it was like the stillness of death.
The cabin was a one-story one, whose thatch was
black with age, and ragged from lack of repair.

The door stood a trifle ajar. We approached it
stealthily -- on tiptoe and at half-breath -- for that is
the way one's feeling makes him do, at such a time.
The king knocked. We waited. No answer. Knocked
again. No answer. I pushed the door softly open
and looked in. I made out some dim forms, and a
woman started up from the ground and stared at me,
as one does who is wakened from sleep. Presently
she found her voice:

"Have mercy!" she pleaded. "All is taken,
nothing is left."

"I have not come to take anything, poor woman."

"You are not a priest?"

"No."

"Nor come not from the lord of the manor?"

"No, I am a stranger."

"Oh, then, for the fear of God, who visits with
misery and death such as be harmless, tarry not here,
but fly! This place is under his curse -- and his
Church's."

"Let me come in and help you -- you are sick and
in trouble."

I was better used to the dim light now. I could see
her hollow eyes fixed upon me. I could see how
emaciated she was.

"I tell you the place is under the Church's ban.
Save yourself -- and go, before some straggler see thee
here, and report it."

"Give yourself no trouble about me; I don't care
anything for the Church's curse. Let me help you."

"Now all good spirits -- if there be any such --
bless thee for that word. Would God I had a sup of
water! -- but hold, hold, forget I said it, and fly; for
there is that here that even he that feareth not the
Church must fear: this disease whereof we die. Leave
us, thou brave, good stranger, and take with thee such
whole and sincere blessing as them that be accursed
can give."

But before this I had picked up a wooden bowl and
was rushing past the king on my way to the brook.
It was ten yards away. When I got back and entered,
the king was within, and was opening the shutter that
closed the window-hole, to let in air and light. The
place was full of a foul stench. I put the bowl to the
woman's lips, and as she gripped it with her eager
talons the shutter came open and a strong light flooded
her face. Smallpox!

I sprang to the king, and said in his ear:

"Out of the door on the instant, sire! the woman
is dying of that disease that wasted the skirts of
Camelot two years ago."

He did not budge.

"Of a truth I shall remain -- and likewise help."

I whispered again:

"King, it must not be. You must go."

"Ye mean well, and ye speak not unwisely. But it
were shame that a king should know fear, and shame
that belted knight should withhold his hand where be
such as need succor. Peace, I will not go. It is you
who must go. The Church's ban is not upon me, but
it forbiddeth you to be here, and she will deal with
you with a heavy hand an word come to her of your
trespass."

It was a desperate place for him to be in, and might
cost him his life, but it was no use to argue with him.
If he considered his knightly honor at stake here, that
was the end of argument; he would stay, and nothing
could prevent it; I was aware of that. And so I
dropped the subject. The woman spoke:

"Fair sir, of your kindness will ye climb the ladder
there, and bring me news of what ye find? Be not
afraid to report, for times can come when even a
mother's heart is past breaking -- being already broke."

"Abide," said the king, "and give the woman to
eat. I will go." And he put down the knapsack.

I turned to start, but the king had already started.
He halted, and looked down upon a man who lay in a
dim light, and had not noticed us thus far, or spoken.

"Is it your husband?" the king asked.

"Yes."

"Is he asleep?"

"God be thanked for that one charity, yes -- these
three hours. Where shall I pay to the full, my grati-
tude! for my heart is bursting with it for that sleep he
sleepeth now."

I said:

"We will be careful. We will not wake him."

"Ah, no, that ye will not, for he is dead."

"Dead?"

"Yes, what triumph it is to know it! None can
harm him, none insult him more. He is in heaven
now, and happy; or if not there, he bides in hell and
is content; for in that place he will find neither abbot
nor yet bishop. We were boy and girl together; we
were man and wife these five and twenty years, and
never separated till this day. Think how long that is
to love and suffer together. This morning was he out
of his mind, and in his fancy we were boy and girl
again and wandering in the happy fields; and so in
that innocent glad converse wandered he far and
farther, still lightly gossiping, and entered into those
other fields we know not of, and was shut away from
mortal sight. And so there was no parting, for in his
fancy I went with him; he knew not but I went with
him, my hand in his -- my young soft hand, not this
withered claw. Ah, yes, to go, and know it not; to
separate and know it not; how could one go peace --
fuller than that? It was his reward for a cruel life
patiently borne."

There was a slight noise from the direction of the
dim corner where the ladder was. It was the king
descending. I could see that he was bearing some-
thing in one arm, and assisting himself with the other.
He came forward into the light; upon his breast lay a
slender girl of fifteen. She was but half conscious;
she was dying of smallpox. Here was heroism at its
last and loftiest possibility, its utmost summit; this
was challenging death in the open field unarmed, with
all the odds against the challenger, no reward set upon
the contest, and no admiring world in silks and cloth
of gold to gaze and applaud; and yet the king's bear-
ing was as serenely brave as it had always been in those
cheaper contests where knight meets knight in equal
fight and clothed in protecting steel. He was great
now; sublimely great. The rude statues of his ances-
tors in his palace should have an addition -- I would
see to that; and it would not be a mailed king killing
a giant or a dragon, like the rest, it would be a king
in commoner's garb bearing death in his arms that a
peasant mother might look her last upon her child and
be comforted.

He laid the girl down by her mother, who poured
out endearments and caresses from an overflowing
heart, and one could detect a flickering faint light of
response in the child's eyes, but that was all. The
mother hung over her, kissing her, petting her, and
imploring her to speak, but the lips only moved and
no sound came. I snatched my liquor flask from my
knapsack, but the woman forbade me, and said:

"No -- she does not suffer; it is better so. It
might bring her back to life. None that be so good
and kind as ye are would do her that cruel hurt. For
look you -- what is left to live for? Her brothers are
gone, her father is gone, her mother goeth, the
Church's curse is upon her, and none may shelter or
befriend her even though she lay perishing in the road.
She is desolate. I have not asked you, good heart, if
her sister be still on live, here overhead; I had no
need; ye had gone back, else, and not left the poor
thing forsaken --"

"She lieth at peace," interrupted the king, in a
subdued voice.

"I would not change it. How rich is this day in
happiness! Ah, my Annis, thou shalt join thy sister
soon -- thou'rt on thy way, and these be merciful
friends that will not hinder."

And so she fell to murmuring and cooing over the
girl again, and softly stroking her face and hair, and
kissing her and calling her by endearing names; but
there was scarcely sign of response now in the glazing
eyes. I saw tears well from the king's eyes, and
trickle down his face. The woman noticed them, too,
and said:

"Ah, I know that sign: thou'st a wife at home,
poor soul, and you and she have gone hungry to bed,
many's the time, that the little ones might have your
crust; you know what poverty is, and the daily insults
of your betters, and the heavy hand of the Church and
the king."

The king winced under this accidental home-shot,
but kept still; he was learning his part; and he was
playing it well, too, for a pretty dull beginner. I
struck up a diversion. I offered the woman food and
liquor, but she refused both. She would allow noth-
ing to come between her and the release of death.
Then I slipped away and brought the dead child from
aloft, and laid it by her. This broke her down again,
and there was another scene that was full of heart-
break. By and by I made another diversion, and
beguiled her to sketch her story.

"Ye know it well yourselves, having suffered it --
for truly none of our condition in Britain escape it.
It is the old, weary tale. We fought and struggled
and succeeded; meaning by success, that we lived and
did not die; more than that is not to be claimed. No
troubles came that we could not outlive, till this year
brought them; then came they all at once, as one
might say, and overwhelmed us. Years ago the lord
of the manor planted certain fruit trees on our farm;
in the best part of it, too -- a grievous wrong and
shame --"

"But it was his right," interrupted the king.

"None denieth that, indeed; an the law mean any-
thing, what is the lord's is his, and what is mine is his
also. Our farm was ours by lease, therefore 'twas
likewise his, to do with it as he would. Some little
time ago, three of those trees were found hewn down.
Our three grown sons ran frightened to report the
crime. Well, in his lordship's dungeon there they lie,
who saith there shall they lie and rot till they confess.
They have naught to confess, being innocent, where-
fore there will they remain until they die. Ye know
that right well, I ween. Think how this left us; a
man, a woman and two children, to gather a crop that
was planted by so much greater force, yes, and pro-
tect it night and day from pigeons and prowling
animals that be sacred and must not be hurt by any
of our sort. When my lord's crop was nearly ready
for the harvest, so also was ours; when his bell rang
to call us to his fields to harvest his crop for nothing,
he would not allow that I and my two girls should
count for our three captive sons, but for only two of
them; so, for the lacking one were we daily fined.
All this time our own crop was perishing through neg-
lect; and so both the priest and his lordship fined us
because their shares of it were suffering through
damage. In the end the fines ate up our crop -- and
they took it all; they took it all and made us harvest
it for them, without pay or food, and we starving.
Then the worst came when I, being out of my mind
with hunger and loss of my boys, and grief to see my
husband and my little maids in rags and misery and
despair, uttered a deep blasphemy -- oh! a thousand
of them! -- against the Church and the Church's ways.
It was ten days ago. I had fallen sick with this dis-
ease, and it was to the priest I said the words, for he
was come to chide me for lack of due humility under
the chastening hand of God. He carried my trespass
to his betters; I was stubborn; wherefore, presently
upon my head and upon all heads that were dear to
me, fell the curse of Rome.

"Since that day we are avoided, shunned with horror.
None has come near this hut to know whether we live
or not. The rest of us were taken down. Then I
roused me and got up, as wife and mother will. It
was little they could have eaten in any case; it was
less than little they had to eat. But there was water,
and I gave them that. How they craved it! and how
they blessed it! But the end came yesterday; my
strength broke down. Yesterday was the last time I
ever saw my husband and this youngest child alive. I
have lain here all these hours -- these ages, ye may
say -- listening, listening for any sound up there
that --"

She gave a sharp quick glance at her eldest daughter,
then cried out, "Oh, my darling!" and feebly gath-
ered the stiffening form to her sheltering arms. She
had recognized the death-rattle.


CHAPTER XXX.
THE TRAGEDY OF THE MANOR-HOUSE

AT midnight all was over, and we sat in the presence
of four corpses. We covered them with such
rags as we could find, and started away, fastening the
door behind us. Their home must be these people's
grave, for they could not have Christian burial, or be
admitted to consecrated ground. They were as dogs,
wild beasts, lepers, and no soul that valued its hope of
eternal life would throw it away by meddling in any
sort with these rebuked and smitten outcasts.

We had not moved four steps when I caught a sound
as of footsteps upon gravel. My heart flew to my
throat. We must not be seen coming from that house.
I plucked at the king's robe and we drew back and
took shelter behind the corner of the cabin.

"Now we are safe," I said, "but it was a close
call -- so to speak. If the night had been lighter he
might have seen us, no doubt, he seemed to be so
near."

"Mayhap it is but a beast and not a man at all."

"True. But man or beast, it will be wise to stay
here a minute and let it get by and out of the way."

"Hark! It cometh hither."

True again. The step was coming toward us --
straight toward the hut. It must be a beast, then, and
we might as well have saved our trepidation. I was
going to step out, but the king laid his hand upon my
arm. There was a moment of silence, then we heard
a soft knock on the cabin door. It made me shiver.
Presently the knock was repeated, and then we heard
these words in a guarded voice:

"Mother! Father! Open -- we have got free, and
we bring news to pale your cheeks but glad your
hearts; and we may not tarry, but must fly! And --
but they answer not. Mother! father! --"

I drew the king toward the other end of the hut and
whispered:

"Come -- now we can get to the road."

The king hesitated, was going to demur; but just
then we heard the door give way, and knew that those
desolate men were in the presence of their dead.

"Come, my liege! in a moment they will strike a
light, and then will follow that which it would break
your heart to hear."

He did not hesitate this time. The moment we were
in the road I ran; and after a moment he threw dig-
nity aside and followed. I did not want to think of
what was happening in the hut -- I couldn't bear it; I
wanted to drive it out of my mind; so I struck into
the first subject that lay under that one in my mind:

"I have had the disease those people died of, and
so have nothing to fear; but if you have not had it
also --"

He broke in upon me to say he was in trouble, and
it was his conscience that was troubling him:

"These young men have got free, they say -- but
HOW? It is not likely that their lord hath set them
free."

"Oh, no, I make no doubt they escaped."

"That is my trouble; I have a fear that this is so,
and your suspicion doth confirm it, you having the
same fear.

"I should not call it by that name though. I do
suspect that they escaped, but if they did, I am not
sorry, certainly."

"I am not sorry, I THINK -- but --"

"What is it? What is there for one to be troubled
about?"

"IF they did escape, then are we bound in duty to
lay hands upon them and deliver them again to their
lord; for it is not seemly that one of his quality should
suffer a so insolent and high-handed outrage from
persons of their base degree."

There it was again. He could see only one side of
it. He was born so, educated so, his veins were full
of ancestral blood that was rotten with this sort of
unconscious brutality, brought down by inheritance
from a long procession of hearts that had each done
its share toward poisoning the stream. To imprison
these men without proof, and starve their kindred, was
no harm, for they were merely peasants and subject to
the will and pleasure of their lord, no matter what
fearful form it might take; but for these men to break
out of unjust captivity was insult and outrage, and a
thing not to be countenanced by any conscientious
person who knew his duty to his sacred caste.

I worked more than half an hour before I got him to
change the subject -- and even then an outside matter
did it for me. This was a something which caught our
eyes as we struck the summit of a small hill -- a red
glow, a good way off.

"That's a fire," said I.

Fires interested me considerably, because I was get-
ting a good deal of an insurance business started, and
was also training some horses and building some steam
fire-engines, with an eye to a paid fire department by
and by. The priests opposed both my fire and life in-
surance, on the ground that it was an insolent attempt
to hinder the decrees of God; and if you pointed out
that they did not hinder the decrees in the least, but
only modified the hard consequences of them if you
took out policies and had luck, they retorted that that
was gambling against the decrees of God, and was
just as bad. So they managed to damage those in-
dustries more or less, but I got even on my Accident
business. As a rule, a knight is a lummox, and some
times even a labrick, and hence open to pretty poor
arguments when they come glibly from a supersti-
tion-monger, but even HE could see the practical side
of a thing once in a while; and so of late you couldn't
clean up a tournament and pile the result without finding
one of my accident-tickets in every helmet.

We stood there awhile, in the thick darkness and
stillness, looking toward the red blur in the distance,
and trying to make out the meaning of a far-away
murmur that rose and fell fitfully on the night. Some-
times it swelled up and for a moment seemed less
remote; but when we were hopefully expecting it to
betray its cause and nature, it dulled and sank again,
carrying its mystery with it. We started down the hill
in its direction, and the winding road plunged us at
once into almost solid darkness -- darkness that was
packed and crammed in between two tall forest walls.
We groped along down for half a mile, perhaps, that
murmur growing more and more distinct all the time.
the coming storm threatening more and more, with
now and then a little shiver of wind, a faint show of
lightning, and dull grumblings of distant thunder. I
was in the lead. I ran against something -- a soft
heavy something which gave, slightly, to the impulse
of my weight; at the same moment the lightning glared
out, and within a foot of my face was the writhing face
of a man who was hanging from the limb of a tree!
That is, it seemed to be writhing, but it was not. It
was a grewsome sight. Straightway there was an ear-
splitting explosion of thunder, and the bottom of
heaven fell out; the rain poured down in a deluge.
No matter, we must try to cut this man down, on the
chance that there might be life in him yet, mustn't
we? The lightning came quick and sharp now, and
the place was alternately noonday and midnight. One
moment the man would be hanging before me in an
intense light, and the next he was blotted out again in
the darkness. I told the king we must cut him down.
The king at once objected.

"If he hanged himself, he was willing to lose him
property to his lord; so let him be. If others hanged
him, belike they had the right -- let him hang."

"But --"

"But me no buts, but even leave him as he is. And
for yet another reason. When the lightning cometh
again -- there, look abroad."

Two others hanging, within fifty yards of us!

"It is not weather meet for doing useless courtesies
unto dead folk. They are past thanking you. Come
-- it is unprofitable to tarry here."

There was reason in what he said, so we moved on.
Within the next mile we counted six more hanging
forms by the blaze of the lightning, and altogether it
was a grisly excursion. That murmur was a murmur
no longer, it was a roar; a roar of men's voices. A
man came flying by now, dimly through the darkness,
and other men chasing him. They disappeared. Pres-
ently another case of the kind occurred, and then an-
other and another. Then a sudden turn of the road
brought us in sight of that fire -- it was a large manor-
house, and little or nothing was left of it -- and every-
where men were flying and other men raging after
them in pursuit.

I warned the king that this was not a safe place for
strangers. We would better get away from the light,
until matters should improve. We stepped back a
little, and hid in the edge of the wood. From this
hiding-place we saw both men and women hunted by
the mob. The fearful work went on until nearly dawn.
Then, the fire being out and the storm spent, the voices
and flying footsteps presently ceased, and darkness and
stillness reigned again.

We ventured out, and hurried cautiously away; and
although we were worn out and sleepy, we kept on
until we had put this place some miles behind us.
Then we asked hospitality at the hut of a charcoal
burner, and got what was to be had. A woman was
up and about, but the man was still asleep, on a straw
shake-down, on the clay floor. The woman seemed
uneasy until I explained that we were travelers and had
lost our way and been wandering in the woods all
night. She became talkative, then, and asked if we
had heard of the terrible goings-on at the manor-house
of Abblasoure. Yes, we had heard of them, but what
we wanted now was rest and sleep. The king broke in:

"Sell us the house and take yourselves away, for
we be perilous company, being late come from people
that died of the Spotted Death."

It was good of him, but unnecessary. One of the
commonest decorations of the nation was the waffle-
iron face. I had early noticed that the woman and her
husband were both so decorated. She made us entirely
welcome, and had no fears; and plainly she was im-
mensely impressed by the king's proposition; for, of
course, it was a good deal of an event in her life to
run across a person of the king's humble appearance
who was ready to buy a man's house for the sake of a
night's lodging. It gave her a large respect for us,
and she strained the lean possibilities of her hovel to
the utmost to make us comfortable.

We slept till far into the afternoon, and then got up
hungry enough to make cotter fare quite palatable to
the king, the more particularly as it was scant in quan-
tity. And also in variety; it consisted solely of onions,
salt, and the national black breadmade out of horse-
feed. The woman told us about the affair of the even-
ing before. At ten or eleven at night, when everybody
was in bed, the manor-house burst into flames. The
country-side swarmed to the rescue, and the family
were saved, with one exception, the master. He did
not appear. Everybody was frantic over this loss, and
two brave yeomen sacrificed their lives in ransacking
the burning house seeking that valuable personage.
But after a while he was found -- what was left of
him -- which was his corpse. It was in a copse three
hundred yards away, bound, gagged, stabbed in a
dozen places.

Who had done this? Suspicion fell upon a humble
family in the neighborhood who had been lately treated
with peculiar harshness by the baron; and from these
people the suspicion easily extended itself to their
relatives and familiars. A suspicion was enough; my
lord's liveried retainers proclaimed an instant crusade
against these people, and were promptly joined by the
community in general. The woman's husband had
been active with the mob, and had not returned home
until nearly dawn. He was gone now to find out
what the general result had been. While we were still
talking he came back from his quest. His report was
revolting enough. Eighteen persons hanged or butch-
ered, and two yeomen and thirteen prisoners lost in
the fire.

"And how many prisoners were there altogether in
the vaults?"

"Thirteen."

"Then every one of them was lost?"

"Yes, all."

"But the people arrived in time to save the family;
how is it they could save none of the prisoners?"

The man looked puzzled, and said:

"Would one unlock the vaults at such a time?
Marry, some would have escaped."

"Then you mean that nobody DID unlock them?"

"None went near them, either to lock or unlock.
It standeth to reason that the bolts were fast; where-
fore it was only needful to establish a watch, so that if
any broke the bonds he might not escape, but be
taken. None were taken."

"Natheless, three did escape," said the king, "and
ye will do well to publish it and set justice upon their
track, for these murthered the baron and fired the
house."

I was just expecting he would come out with that.
For a moment the man and his wife showed an eager
interest in this news and an impatience to go out and
spread it; then a sudden something else betrayed itself
in their faces, and they began to ask questions. I
answered the questions myself, and narrowly watched
the effects produced. I was soon satisfied that the
knowledge of who these three prisoners were had some-
how changed the atmosphere; that our hosts' con-
tinued eagerness to go and spread the news was now
only pretended and not real. The king did not notice
the change, and I was glad of that. I worked the
conversation around toward other details of the night's
proceedings, and noted that these people were relieved
to have it take that direction.

The painful thing observable about all this business
was the alacrity with which this oppressed community
had turned their cruel hands against their own class in
the interest of the common oppressor. This man and
woman seemed to feel that in a quarrel between a
person of their own class and his lord, it was the
natural and proper and rightful thing for that poor
devil's whole caste to side with the master and fight
his battle for him, without ever stopping to inquire
into the rights or wrongs of the matter. This man
had been out helping to hang his neighbors, and had
done his work with zeal, and yet was aware that there
was nothing against them but a mere suspicion, with
nothing back of it describable as evidence, still neither
he nor his wife seemed to see anything horrible about it.

This was depressing -- to a man with the dream of a
republic in his head. It reminded me of a time thirteen
centuries away, when the "poor whites" of our South
who were always despised and frequently insulted by
the slave-lords around them, and who owed their base
condition simply to the presence of slavery in their
midst, were yet pusillanimously ready to side with the
slave-lords in all political moves for the upholding and
perpetuating of slavery, and did also finally shoulder
their muskets and pour out their lives in an effort to
prevent the destruction of that very institution which
degraded them. And there was only one redeeming
feature connected with that pitiful piece of history;
and that was, that secretly the "poor white" did de-
test the slave-lord, and did feel his own shame. That
feeling was not brought to the surface, but the fact
that it was there and could have been brought out, under
favoring circumstances, was something -- in fact, it
was enough; for it showed that a man is at bottom a
man, after all, even if it doesn't show on the outside.

Well, as it turned out, this charcoal burner was just
the twin of the Southern "poor white" of the far
future. The king presently showed impatience, and
said:

"An ye prattle here all the day, justice will mis-
carry. Think ye the criminals will abide in their
father's house? They are fleeing, they are not wait-
ing. You should look to it that a party of horse be
set upon their track."

The woman paled slightly, but quite perceptibly,
and the man looked flustered and irresolute. I said:

"Come, friend, I will walk a little way with you,
and explain which direction I think they would try to
take. If they were merely resisters of the gabelle or
some kindred absurdity I would try to protect them
from capture; but when men murder a person of high
degree and likewise burn his house, that is another
matter."

The last remark was for the king -- to quiet him.
On the road the man pulled his resolution together,
and began the march with a steady gait, but there was
no eagerness in it. By and by I said:

"What relation were these men to you -- cousins?"

He turned as white as his layer of charcoal would let
him, and stopped, trembling.

"Ah, my God, how know ye that?"

"I didn't know it; it was a chance guess."

"Poor lads, they are lost. And good lads they
were, too."

"Were you actually going yonder to tell on them?"

He didn't quite know how to take that; but he said,
hesitatingly:

"Ye-s."

"Then I think you are a damned scoundrel!"

It made him as glad as if I had called him an angel.

"Say the good words again, brother! for surely ye
mean that ye would not betray me an I failed of my
duty."

"Duty? There is no duty in the matter, except the
duty to keep still and let those men get away. They've
done a righteous deed."

He looked pleased; pleased, and touched with ap-
prehension at the same time. He looked up and down
the road to see that no one was coming, and then said
in a cautious voice:

"From what land come you, brother, that you speak
such perilous words, and seem not to be afraid?"

"They are not perilous words when spoken to one
of my own caste, I take it. You would not tell any-
body I said them?"

"I? I would be drawn asunder by wild horses
first."

"Well, then, let me say my say. I have no fears
of your repeating it. I think devil's work has been
done last night upon those innocent poor people.
That old baron got only what he deserved. If I had
my way. all his kind should have the same luck."

Fear and depression vanished from the man's manner,
and gratefulness and a brave animation took their
place:

"Even though you be a spy, and your words a trap
for my undoing, yet are they such refreshment that to
hear them again and others like to them, I would go to
the gallows happy, as having had one good feast at
least in a starved life. And I will say my say now,
and ye may report it if ye be so minded. I helped to
hang my neighbors for that it were peril to my own
life to show lack of zeal in the master's cause; the
others helped for none other reason. All rejoice to-
day that he is dead, but all do go about seemingly
sorrowing, and shedding the hypocrite's tear, for in
that lies safety. I have said the words, I have said the
words! the only ones that have ever tasted good in
my mouth, and the reward of that taste is sufficient.
Lead on, an ye will, be it even to the scaffold, for I
am ready."

There it was, you see. A man is a man, at bottom.
Whole ages of abuse and oppression cannot crush the
manhood clear out of him. Whoever thinks it a mis-
take is himself mistaken. Yes, there is plenty good
enough material for a republic in the most degraded
people that ever existed -- even the Russians; plenty
of manhood in them -- even in the Germans -- if one
could but force it out of its timid and suspicious
privacy, to overthrow and trample in the mud any
throne that ever was set up and any nobility that ever
supported it. We should see certain things yet, let us
hope and believe. First, a modified monarchy, till
Arthur's days were done, then the destruction of the
throne, nobility abolished, every member of it bound
out to some useful trade, universal suffrage instituted,
and the whole government placed in the hands of the
men and women of the nation there to remain. Yes,
there was no occasion to give up my dream yet a while.


CHAPTER XXXI.
MARCO

WE strolled along in a sufficiently indolent fashion
now, and talked. We must dispose of about
the amount of time it ought to take to go to the little
hamlet of Abblasoure and put justice on the track of
those murderers and get back home again. And mean-
time I had an auxiliary interest which had never paled
yet, never lost its novelty for me since I had been in
Arthur's kingdom: the behavior -- born of nice and
exact subdivisions of caste -- of chance passers-by
toward each other. Toward the shaven monk who
trudged along with his cowl tilted back and the sweat
washing down his fat jowls, the coal-burner was deeply
reverent; to the gentleman he was abject; with the
small farmer and the free mechanic he was cordial and
gossipy; and when a slave passed by with a counte-
nance respectfully lowered, this chap's nose was in the
air -- he couldn't even see him. Well, there are times
when one would like to hang the whole human race
and finish the farce.

Presently we struck an incident. A small mob of
half-naked boys and girls came tearing out of the
woods, scared and shrieking. The eldest among them
were not more than twelve or fourteen years old.
They implored help, but they were so beside them-
selves that we couldn't make out what the matter was.
However, we plunged into the wood, they skurrying in
the lead, and the trouble was quickly revealed: they
had hanged a little fellow with a bark rope, and he was
kicking and struggling, in the process of choking to
death. We rescued him, and fetched him around. It
was some more human nature; the admiring little folk
imitating their elders; they were playing mob, and
had achieved a success which promised to be a good
deal more serious than they had bargained for.

It was not a dull excursion for me. I managed to
put in the time very well. I made various acquaintance-
ships, and in my quality of stranger was able to ask as
many questions as I wanted to. A thing which natur-
ally interested me, as a statesman, was the matter of
wages. I picked up what I could under that head
during the afternoon. A man who hasn't had much
experience, and doesn't think, is apt to measure a
nation's prosperity or lack of prosperity by the mere
size of the prevailing wages; if the wages be high, the
nation is prosperous; if low, it isn't. Which is an
error. It isn't what sum you get, it's how much you
can buy with it, that's the important thing; and it's
that that tells whether your wages are high in fact or
only high in name. I could remember how it was in
the time of our great civil war in the nineteenth cen-
tury. In the North a carpenter got three dollars a
day, gold valuation; in the South he got fifty -- pay-
able in Confederate shinplasters worth a dollar a
bushel. In the North a suit of overalls cost three
dollars -- a day's wages; in the South it cost seventy-
five -- which was two days' wages. Other things were
in proportion. Consequently, wages were twice as
high in the North as they were in the South, because
the one wage had that much more purchasing power
than the other had.

Yes, I made various acquaintances in the hamlet
and a thing that gratified me a good deal was to find
our new coins in circulation -- lots of milrays, lots of
mills, lots of cents, a good many nickels, and some
silver; all this among the artisans and commonalty
generally; yes, and even some gold -- but that was at
the bank, that is to say, the goldsmith's. I dropped
in there while Marco, the son of Marco, was haggling
with a shopkeeper over a quarter of a pound of salt,
and asked for change for a twenty-dollar gold piece.
They furnished it -- that is, after they had chewed the
piece, and rung it on the counter, and tried acid on it,
and asked me where I got it, and who I was, and
where I was from, and where I was going to, and
when I expected to get there, and perhaps a couple of
hundred more questions; and when they got aground,
I went right on and furnished them a lot of informa-
tion voluntarily; told them I owned a dog, and his
name was Watch, and my first wife was a Free Will
Baptist, and her grandfather was a Prohibitionist, and
I used to know a man who had two thumbs on each
hand and a wart on the inside of his upper lip, and
died in the hope of a glorious resurrection, and so on,
and so on, and so on, till even that hungry village
questioner began to look satisfied, and also a shade
put out; but he had to respect a man of my financial
strength, and so he didn't give me any lip, but I
noticed he took it out of his underlings, which was a
perfectly natural thing to do. Yes, they changed my
twenty, but I judged it strained the bank a little, which
was a thing to be expected, for it was the same as
walking into a paltry village store in the nineteenth
century and requiring the boss of it to change a two
thousand-dollar bill for you all of a sudden. He could
do it, maybe; but at the same time he would wonder
how a small farmer happened to be carrying so much
money around in his pocket; which was probably this
goldsmith's thought, too; for he followed me to
the door and stood there gazing after me with reverent
admiration.

Our new money was not only handsomely circulating,
but its language was already glibly in use; that is to
say, people had dropped the names of the former
moneys, and spoke of things as being worth so many
dollars or cents or mills or milrays now. It was very
gratifying. We were progressing, that was sure.

I got to know several master mechanics, but about
the most interesting fellow among them was the black-
smith, Dowley. He was a live man and a brisk talker,
and had two journeymen and three apprentices, and was
doing a raging business. In fact, he was getting rich,
hand over fist, and was vastly respected. Marco was
very proud of having such a man for a friend. He
had taken me there ostensibly to let me see the big
establishment which bought so much of his charcoal,
but really to let me see what easy and almost familiar
terms he was on with this great man. Dowley and I
fraternized at once; I had had just such picked men,
splendid fellows, under me in the Colt Arms Factory.
I was bound to see more of him, so I invited him to
come out to Marco's Sunday, and dine with us.
Marco was appalled, and held his breath; and when
the grandee accepted, he was so grateful that he almost
forgot to be astonished at the condescension.

Marco's joy was exuberant -- but only for a mo-
ment; then he grew thoughtful, then sad; and when
he heard me tell Dowley I should have Dickon, the
boss mason, and Smug, the boss wheelwright, out
there, too, the coal-dust on his face turned to chalk,
and he lost his grip. But I knew what was the matter
with him; it was the expense. He saw ruin before
him; he judged that his financial days were numbered.
However, on our way to invite the others, I said:

"You must allow me to have these friends come;
and you must also allow me to pay the costs."

His face cleared, and he said with spirit:

"But not all of it, not all of it. Ye cannot well
bear a burden like to this alone."

I stopped him, and said:

"Now let's understand each other on the spot, old
friend. I am only a farm bailiff, it is true; but I am
not poor, nevertheless. I have been very fortunate
this year -- you would be astonished to know how I
have thriven. I tell you the honest truth when I say
I could squander away as many as a dozen feasts like
this and never care THAT for the expense!" and I
snapped my fingers. I could see myself rise a foot at
a time in Marco's estimation, and when I fetched out
those last words I was become a very tower for style
and altitude. "So you see, you must let me have my
way. You can't contribute a cent to this orgy, that's
SETTLED."

"It's grand and good of you --"

"No, it isn't. You've opened your house to Jones
and me in the most generous way; Jones was remark-
ing upon it to-day, just before you came back from
the village; for although he wouldn't be likely to say
such a thing to you -- because Jones isn't a talker, and
is diffident in society -- he has a good heart and a
grateful, and knows how to appreciate it when he is
well treated; yes, you and your wife have been very
hospitable toward us --"

"Ah, brother, 'tis nothing -- SUCH hospitality!"

"But it IS something; the best a man has, freely
given, is always something, and is as good as a prince
can do, and ranks right along beside it -- for even a
prince can but do his best. And so we'll shop around
and get up this layout now, and don't you worry about
the expense. I'm one of the worst spendthrifts that ever
was born. Why, do you know, sometimes in a single
week I spend -- but never mind about that -- you'd
never believe it anyway."

And so we went gadding along, dropping in here
and there, pricing things, and gossiping with the shop-
keepers about the riot, and now and then running
across pathetic reminders of it, in the persons of
shunned and tearful and houseless remnants of families
whose homes had been taken from them and their
parents butchered or hanged. The raiment of Marco
and his wife was of coarse tow-linen and linsey-woolsey
respectively, and resembled township maps, it being
made up pretty exclusively of patches which had been
added, township by township, in the course of five or
six years, until hardly a hand's-breadth of the original
garments was surviving and present. Now I wanted
to fit these people out with new suits, on account of
that swell company, and I didn't know just how to get
at it -- with delicacy, until at last it struck me that as I
had already been liberal in inventing wordy gratitude
for the king, it would be just the thing to back it up
with evidence of a substantial sort; so I said:

"And Marco, there's another thing which you must
permit -- out of kindness for Jones -- because you
wouldn't want to offend him. He was very anxious
to testify his appreciation in some way, but he is so
diffident he couldn't venture it himself, and so he
begged me to buy some little things and give them to
you and Dame Phyllis and let him pay for them with-
out your ever knowing they came from him -- you
know how a delicate person feels about that sort of
thing -- and so I said I would, and we would keep
mum. Well, his idea was, a new outfit of clothes for
you both --"

"Oh, it is wastefulness! It may not be, brother, it
may not be. Consider the vastness of the sum --"

"Hang the vastness of the sum! Try to keep quiet
for a moment, and see how it would seem; a body
can't get in a word edgeways, you talk so much. You
ought to cure that, Marco; it isn't good form, you
know, and it will grow on you if you don't check it.
Yes, we'll step in here now and price this man's stuff
-- and don't forget to remember to not let on to Jones
that you know he had anything to do with it. You
can't think how curiously sensitive and proud he is.
He's a farmer -- pretty fairly well-to-do farmer -- an
I'm his bailiff; BUT -- the imagination of that man!
Why, sometimes when he forgets himself and gets to
blowing off, you'd think he was one of the swells of
the earth; and you might listen to him a hundred
years and never take him for a farmer -- especially if
he talked agriculture. He THINKS he's a Sheol of a
farmer; thinks he's old Grayback from Wayback; but
between you and me privately he don't know as much
about farming as he does about running a kingdom --
still, whatever he talks about, you want to drop your
underjaw and listen, the same as if you had never
heard such incredible wisdom in all your life before,
and were afraid you might die before you got enough
of it. That will please Jones."

It tickled Marco to the marrow to hear about such
an odd character; but it also prepared him for acci-
dents; and in my experience when you travel with a
king who is letting on to be something else and can't
remember it more than about half the time, you can't
take too many precautions.

This was the best store we had come across yet; it
had everything in it, in small quantities, from anvils
and drygoods all the way down to fish and pinchbeck
jewelry. I concluded I would bunch my whole invoice
right here, and not go pricing around any more. So
I got rid of Marco, by sending him off to invite the
mason and the wheelwright, which left the field free to
me. For I never care to do a thing in a quiet way;
it's got to be theatrical or I don't take any interest in
it. I showed up money enough, in a careless way, to
corral the shopkeeper's respect, and then I wrote down
a list of the things I wanted, and handed it to him to
see if he could read it. He could, and was proud to
show that he could. He said he had been educated by
a priest, and could both read and write. He ran it
through, and remarked with satisfaction that it was a
pretty heavy bill. Well, and so it was, for a little
concern like that. I was not only providing a swell
dinner, but some odds and ends of extras. I ordered
that the things be carted out and delivered at the
dwelling of Marco, the son of Marco, by Saturday
evening, and send me the bill at dinner-time Sunday.
He said I could depend upon his promptness and exacti-
tude, it was the rule of the house. He also observed
that he would throw in a couple of miller-guns for the
Marcos gratis -- that everybody was using them now.
He had a mighty opinion of that clever device. I said:

"And please fill them up to the middle mark, too;
and add that to the bill."

He would, with pleasure. He filled them, and I
took them with me. I couldn't venture to tell him
that the miller-gun was a little invention of my own,
and that I had officially ordered that every shopkeeper
in the kingdom keep them on hand and sell them at
government price -- which was the merest trifle, and
the shopkeeper got that, not the government. We
furnished them for nothing.

The king had hardly missed us when we got back at
nightfall. He had early dropped again into his dream
of a grand invasion of Gaul with the whole strength of
his kingdom at his back, and the afternoon had slipped
away without his ever coming to himself again.


CHAPTER XXXII.
DOWLEY'S HUMILIATION

WELL, when that cargo arrived toward sunset, Sat-
urday afternoon, I had my hands full to keep
the Marcos from fainting. They were sure Jones and
I were ruined past help, and they blamed themselves
as accessories to this bankruptcy. You see, in addi-
tion to the dinner-materials, which called for a suffi-
ciently round sum, I had bought a lot of extras for the
future comfort of the family: for instance, a big lot of
wheat, a delicacy as rare to the tables of their class as
was ice-cream to a hermit's; also a sizeable deal
dinner-table; also two entire pounds of salt, which
was another piece of extravagance in those people's
eyes; also crockery, stools, the clothes, a small cask
of beer, and so on. I instructed the Marcos to keep
quiet about this sumptuousness, so as to give me a
chance to surprise the guests and show off a little.
Concerning the new clothes, the simple couple were
like children; they were up and down, all night, to
see if it wasn't nearly daylight, so that they could put
them on, and they were into them at last as much as
an hour before dawn was due. Then their pleasure --
not to say delirium -- was so fresh and novel and in-
spiring that the sight of it paid me well for the inter-
ruptions which my sleep had suffered. The king had
slept just as usual -- like the dead. The Marcos could
not thank him for their clothes, that being forbidden;
but they tried every way they could think of to make
him see how grateful they were. Which all went for
nothing: he didn't notice any change.

It turned out to be one of those rich and rare fall
days which is just a June day toned down to a degree
where it is heaven to be out of doors. Toward noon
the guests arrived, and we assembled under a great tree
and were soon as sociable as old acquaintances. Even
the king's reserve melted a little, though it was some
little trouble to him to adjust himself to the name of
Jones along at first. I had asked him to try to not
forget that he was a farmer; but I had also considered
it prudent to ask him to let the thing stand at that,
and not elaborate it any. Because he was just the
kind of person you could depend on to spoil a little
thing like that if you didn't warn him, his tongue was
so handy, and his spirit so willing, and his information
so uncertain.

Dowley was in fine feather, and I early got him
started, and then adroitly worked him around onto his
own history for a text and himself for a hero, and then
it was good to sit there and hear him hum. Self-made
man, you know. They know how to talk. They do
deserve more credit than any other breed of men, yes,
that is true; and they are among the very first to find
it out, too. He told how he had begun life an orphan
lad without money and without friends able to help
him; how he had lived as the slaves of the meanest
master lived; how his day's work was from sixteen to
eighteen hours long, and yielded him only enough
black bread to keep him in a half-fed condition; how
his faithful endeavors finally attracted the attention of
a good blacksmith, who came near knocking him dead
with kindness by suddenly offering, when he was totally
unprepared, to take him as his bound apprentice for
nine years and give him board and clothes and teach
him the trade -- or "mystery" as Dowley called it.
That was his first great rise, his first gorgeous stroke
of fortune; and you saw that he couldn't yet speak of
it without a sort of eloquent wonder and delight that
such a gilded promotion should have fallen to the lot
of a common human being. He got no new clothing
during his apprenticeship, but on his graduation day
his master tricked him out in spang-new tow-linens
and made him feel unspeakably rich and fine.

"I remember me of that day!" the wheelwright
sang out, with enthusiasm.

"And I likewise!" cried the mason. "I would not
believe they were thine own; in faith I could not."

"Nor other!" shouted Dowley, with sparkling eyes.
"I was like to lose my character, the neighbors wend-
ing I had mayhap been stealing. It was a great day,
a great day; one forgetteth not days like that."

Yes, and his master was a fine man, and prosperous,
and always had a great feast of meat twice in the year,
and with it white bread, true wheaten bread; in fact,
lived like a lord, so to speak. And in time Dowley
succeeded to the business and married the daughter.

"And now consider what is come to pass," said
he, impressively. "Two times in every month there
is fresh meat upon my table." He made a pause
here, to let that fact sink home, then added -- "and
eight times salt meat."

"It is even true," said the wheelwright, with bated
breath.

"I know it of mine own knowledge," said the mason,
in the same reverent fashion.

"On my table appeareth white bread every Sunday
in the year," added the master smith, with solemnity.
"I leave it to your own consciences, friends, if this is
not also true?"

"By my head, yes," cried the mason.

"I can testify it -- and I do," said the wheelwright.

"And as to furniture, ye shall say yourselves what
mine equipment is. " He waved his hand in fine
gesture of granting frank and unhampered freedom
of speech, and added: "Speak as ye are moved;
speak as ye would speak; an I were not here."

"Ye have five stools, and of the sweetest workman-
ship at that, albeit your family is but three," said the
wheelwright, with deep respect.

"And six wooden goblets, and six platters of wood
and two of pewter to cat and drink from withal," said
the mason, impressively. "And I say it as knowing
God is my judge, and we tarry not here alway, but
must answer at the last day for the things said in the
body, be they false or be they sooth."

"Now ye know what manner of man I am, brother
Jones," said the smith, with a fine and friendly conde-
scension, "and doubtless ye would look to find me a
man jealous of his due of respect and but sparing of
outgo to strangers till their rating and quality be
assured, but trouble yourself not, as concerning that;
wit ye well ye shall find me a man that regardeth not
these matters but is willing to receive any he as his
fellow and equal that carrieth a right heart in his body,
be his worldly estate howsoever modest. And in token
of it, here is my hand; and I say with my own mouth
we are equals -- equals "-- and he smiled around on
the company with the satisfaction of a god who is
doing the handsome and gracious thing and is quite
well aware of it.

The king took the hand with a poorly disguised
reluctance, and let go of it as willingly as a lady lets
go of a fish; all of which had a good effect, for it was
mistaken for an embarrassment natural to one who was
being called upon by greatness.

The dame brought out the table now, and set it
under the tree. It caused a visible stir of surprise, it
being brand new and a sumptuous article of deal. But
the surprise rose higher still when the dame, with a
body oozing easy indifference at every pore, but eyes
that gave it all away by absolutely flaming with vanity,
slowly unfolded an actual simon-pure tablecloth and
spread it. That was a notch above even the black-
smith's domestic grandeurs, and it hit him hard; you
could see it. But Marco was in Paradise; you could
see that, too. Then the dame brought two fine new
stools -- whew! that was a sensation; it was visible in
the eyes of every guest. Then she brought two more
-- as calmly as she could. Sensation again -- with
awed murmurs. Again she brought two -- walking on
air, she was so proud. The guests were petrified, and
the mason muttered:

"There is that about earthly pomps which doth
ever move to reverence."

As the dame turned away, Marco couldn't help
slapping on the climax while the thing was hot; so he
said with what was meant for a languid composure but
was a poor imitation of it:

"These suffice; leave the rest."

So there were more yet! It was a fine effect. I
couldn't have played the hand better myself.

From this out, the madam piled up the surprises
with a rush that fired the general astonishment up to a
hundred and fifty in the shade, and at the same time
paralyzed expression of it down to gasped "Oh's"
and "Ah's," and mute upliftings of hands and eyes.
She fetched crockery -- new, and plenty of it; new
wooden goblets and other table furniture; and beer,
fish, chicken, a goose, eggs, roast beef, roast mutton,
a ham, a small roast pig, and a wealth of genuine white
wheaten bread. Take it by and large, that spread laid
everything far and away in the shade that ever that
crowd had seen before. And while they sat there just
simply stupefied with wonder and awe, I sort of waved
my hand as if by accident, and the storekeeper's son
emerged from space and said he had come to collect.

"That's all right," I said, indifferently. "What is
the amount? give us the items."

Then he read off this bill, while those three amazed
men listened, and serene waves of satisfaction rolled
over my soul and alternate waves of terror and admira-
tion surged over Marco's:

   2 pounds salt . . . . . . . . . . . . . .   200
   8 dozen pints beer, in the wood . . . . .   800
   3 bushels wheat . . . . . . . . . . . . . 2,700
   2 pounds fish . . . . . . . . . . . . . .   100
   3 hens  . . . . . . . . . . . . . . . . .   400
   1 goose . . . . . . . . . . . . . . . . .   400
   3 dozen eggs  . . . . . . . . . . . . . .   150
   1 roast of beef . . . . . . . . . . . . .   450
   1 roast of mutton . . . . . . . . . . . .   400
   1 ham . . . . . . . . . . . . . . . . . .   800
   1 sucking pig . . . . . . . . . . . . . .   500
   2 crockery dinner sets  . . . . . . . . . 6,000
   2 men's suits and underwear . . . . . . . 2,800
   1 stuff and 1 linsey-woolsey gown 
     and underwear . . . . . . . . . . . . . 1,600
   8 wooden goblets  . . . . . . . . . . . .   800
   Various table furniture . . . . . . . . .10,000
   1 deal table  . . . . . . . . . . . . . . 3,000
   8 stools  . . . . . . . . . . . . . . . . 4,000
   2 miller guns, loaded . . . . . . . . . . 3,000

He ceased. There was a pale and awful silence.
Not a limb stirred. Not a nostril betrayed the passage
of breath.

"Is that all?" I asked, in a voice of the most per-
fect calmness.

"All, fair sir, save that certain matters of light mo-
ment are placed together under a head hight sundries.
If it would like you, I will sepa --"

"It is of no consequence," I said, accompanying
the words with a gesture of the most utter indifference;
"give me the grand total, please."

The clerk leaned against the tree to stay himself, and
said:

"Thirty-nine thousand one hundred and fifty mil-
rays!"

The wheelwright fell off his stool, the others grabbed
the table to save themselves, and there was a deep and
general ejaculation of:

"God be with us in the day of disaster!"

The clerk hastened to say:

"My father chargeth me to say he cannot honorably
require you to pay it all at this time, and therefore
only prayeth you --"

I paid no more heed than if it were the idle breeze,
but, with an air of indifference amounting almost to
weariness, got out my money and tossed four dollars
on to the table. Ah, you should have seen them stare!

The clerk was astonished and charmed. He asked
me to retain one of the dollars as security, until he
could go to town and -- I interrupted:

"What, and fetch back nine cents? Nonsense!
Take the whole. Keep the change."

There was an amazed murmur to this effect:

"Verily this being is MADE of money! He throweth
it away even as if it were dirt."

The blacksmith was a crushed man.

The clerk took his money and reeled away drunk
with fortune. I said to Marco and his wife:

"Good folk, here is a little trifle for you" -- hand-
ing the miller-guns as if it were a matter of no conse-
quence, though each of them contained fifteen cents in
solid cash; and while the poor creatures went to pieces
with astonishment and gratitude, I turned to the others
and said as calmly as one would ask the time of day:

"Well, if we are all ready, I judge the dinner is.
Come, fall to."

Ah, well, it was immense; yes, it was a daisy. I
don't know that I ever put a situation together better,
or got happier spectacular effects out of the materials
available. The blacksmith -- well, he was simply
mashed. Land! I wouldn't have felt what that man
was feeling, for anything in the world. Here he had
been blowing and bragging about his grand meat-feast
twice a year, and his fresh meat twice a month, and
his salt meat twice a week, and his white bread every
Sunday the year round -- all for a family of three; the
entire cost for the year not above 69.2.6 (sixty-nine
cents, two mills and six milrays), and all of a sudden
here comes along a man who slashes out nearly four
dollars on a single blow-out; and not only that, but
acts as if it made him tired to handle such small sums.
Yes, Dowley was a good deal wilted, and shrunk-up
and collapsed; he had the aspect of a bladder-balloon
that's been stepped on by a cow.


CHAPTER XXXIII.
SIXTH CENTURY POLITICAL ECONOMY

HOWEVER, I made a dead set at him, and before
the first third of the dinner was reached, I had
him happy again. It was easy to do -- in a country
of ranks and castes. You see, in a country where
they have ranks and castes, a man isn't ever a man,
he is only part of a man, he can't ever get his full
growth. You prove your superiority over him in
station, or rank, or fortune, and that's the end of it --
he knuckles down. You can't insult him after that.
No, I don't mean quite that; of course you CAN insult
him, I only mean it's difficult; and so, unless you've
got a lot of useless time on your hands it doesn't pay
to try. I had the smith's reverence now, because I
was apparently immensely prosperous and rich; I
could have had his adoration if I had had some
little gimcrack title of nobility. And not only his, but
any commoner's in the land, though he were the
mightiest production of all the ages, in intellect, worth,
and character, and I bankrupt in all three. This was
to remain so, as long as England should exist in the
earth. With the spirit of prophecy upon me, I could
look into the future and see her erect statues and
monuments to her unspeakable Georges and other
royal and noble clothes-horses, and leave unhonored
the creators of this world -- after God -- Gutenburg,
Watt, Arkwright, Whitney, Morse, Stephenson, Bell.

The king got his cargo aboard, and then, the talk
not turning upon battle, conquest, or iron-clad duel,
he dulled down to drowsiness and went off to take a
nap. Mrs. Marco cleared the table, placed the beer
keg handy, and went away to eat her dinner of leavings
in humble privacy, and the rest of us soon drifted into
matters near and dear to the hearts of our sort -- busi-
ness and wages, of course. At a first glance, things
appeared to be exceeding prosperous in this little
tributary kingdom -- whose lord was King Bagdemagus
-- as compared with the state of things in my own
region. They had the "protection" system in full
force here, whereas we were working along down
toward free-trade, by easy stages, and were now about
half way. Before long, Dowley and I were doing all
the talking, the others hungrily listening. Dowley
warmed to his work, snuffed an advantage in the air,
and began to put questions which he considered pretty
awkward ones for me, and they did have something of
that look:

"In your country, brother, what is the wage of a
master bailiff, master hind, carter, shepherd, swine-
herd?"

"Twenty-five milrays a day; that is to say, a quarter
of a cent.

The smith's face beamed with joy. He said:

"With us they are allowed the double of it! And
what may a mechanic get -- carpenter, dauber, mason,
painter, blacksmith, wheelwright, and the like?"

"On the average, fifty milrays; half a cent a day."

"Ho-ho! With us they are allowed a hundred!
With us any good mechanic is allowed a cent a day!
I count out the tailor, but not the others -- they are
all allowed a cent a day, and in driving times they get
more -- yes, up to a hundred and ten and even fifteen
milrays a day. I've paid a hundred and fifteen my-
self, within the week. 'Rah for protection -- to Sheol
with free-trade!"

And his face shone upon the company like a sun-
burst. But I didn't scare at all. I rigged up my
pile-driver, and allowed myself fifteen minutes to drive
him into the earth -- drive him ALL in -- drive him in
till not even the curve of his skull should show above
ground. Here is the way I started in on him. I asked:

"What do you pay a pound for salt?"

"A hundred milrays."

"We pay forty. What do you pay for beef and
mutton -- when you buy it?" That was a neat hit; it
made the color come.

"It varieth somewhat, but not much; one may say
75 milrays the pound."

"WE pay 33. What do you pay for eggs?"

"Fifty milrays the dozen."

"We pay 20. What do you pay for beer?"

"It costeth us 8 1/2 milrays the pint."

"We get it for 4; 25 bottles for a cent. What do
you pay for wheat?"

"At the rate of 900 milrays the bushel."

"We pay 400. What do you pay for a man's tow-
linen suit?"

"Thirteen cents."

"We pay 6. What do you pay for a stuff gown
for the wife of the laborer or the mechanic?"

"We pay 8.4.0."

"Well, observe the difference: you pay eight cents
and four mills, we pay only four cents." I prepared
now to sock it to him. l said: "Look here, dear
friend, WHAT'S BECOME OF YOUR HIGH WAGES YOU WERE
BRAGGING SO ABOUT A FEW MINUTES AGO?" -- and I looked
around on the company with placid satisfaction, for I
had slipped up on him gradually and tied him hand
and foot, you see, without his ever noticing that he
was being tied at all. "What's become of those noble
high wages of yours? -- I seem to have knocked the
stuffing all out of them, it appears to me."

But if you will believe me, he merely looked sur-
prised, that is all! he didn't grasp the situation at all,
didn't know he had walked into a trap, didn't discover
that he was IN a trap. I could have shot him, from
sheer vexation. With cloudy eye and a struggling in-
tellect he fetched this out:

"Marry, I seem not to understand. It is PROVED
that our wages be double thine; how then may it be
that thou'st knocked therefrom the stuffing? -- an
miscall not the wonderly word, this being the first time
under grace and providence of God it hath been
granted me to hear it."

Well, I was stunned; partly with this unlooked-for
stupidity on his part, and partly because his fellows so
manifestly sided with him and were of his mind -- if
you might call it mind. My position was simple
enough, plain enough; how could it ever be simplified
more? However, I must try:

"Why, look here, brother Dowley, don't you see?
Your wages are merely higher than ours in NAME, not
in FACT."

"Hear him! They are the DOUBLE -- ye have con-
fessed it yourself."

"Yes-yes, I don't deny that at all. But that's got
nothing to do with it; the AMOUNT of the wages in
mere coins, with meaningless names attached to them
to know them by, has got nothing to do with it. The
thing is, how much can you BUY with your wages? --
that's the idea. While it is true that with you a good
mechanic is allowed about three dollars and a half a year,
and with us only about a dollar and seventy-five --"

"There -- ye're confessing it again, ye're confess-
ing it again!"

"Confound it, I've never denied it, I tell you!
What I say is this. With us HALF a dollar buys more
than a DOLLAR buys with you -- and THEREFORE it stands
to reason and the commonest kind of common-sense,
that our wages are HIGHER than yours."

He looked dazed, and said, despairingly:

"Verily, I cannot make it out. Ye've just said ours
are the higher, and with the same breath ye take it
back."

"Oh, great Scott, isn't it possible to get such a
simple thing through your head? Now look here --
let me illustrate. We pay four cents for a woman's
stuff gown, you pay 8.4.0, which is four mills more
than DOUBLE. What do you allow a laboring woman
who works on a farm?"

"Two mills a day."

"Very good; we allow but half as much; we pay
her only a tenth of a cent a day; and --"

"Again ye're conf --"

"Wait! Now, you see, the thing is very simple;
this time you'll understand it. For instance, it takes
your woman 42 days to earn her gown, at 2 mills a
day -- 7 weeks' work; but ours earns hers in forty
days -- two days SHORT of 7 weeks. Your woman has
a gown, and her whole seven weeks wages are gone;
ours has a gown, and two days' wages left, to buy
something else with. There -- NOW you understand
it!"

He looked -- well, he merely looked dubious, it's
the most I can say; so did the others. I waited -- to
let the thing work. Dowley spoke at last -- and be-
trayed the fact that he actually hadn't gotten away
from his rooted and grounded superstitions yet. He
said, with a trifle of hesitancy:

"But -- but -- ye cannot fail to grant that two mills
a day is better than one."

Shucks! Well, of course, I hated to give it up. So
I chanced another flyer:

"Let us suppose a case. Suppose one of your jour-
neymen goes out and buys the following articles:

  "1 pound of salt;
   1 dozen eggs;
   1 dozen pints of beer;
   1 bushel of wheat;
   1 tow-linen suit;
   5 pounds of beef;
   5 pounds of mutton.

"The lot will cost him 32 cents. It takes him 32
working days to earn the money -- 5 weeks and 2
days. Let him come to us and work 32 days at HALF
the wages; he can buy all those things for a shade
under 14 1/2 cents; they will cost him a shade under 29
days' work, and he will have about half a week's
wages over. Carry it through the year; he would
save nearly a week's wages every two months, YOUR
man nothing; thus saving five or six weeks' wages in
a year, your man not a cent. NOW I reckon you
understand that 'high wages' and 'low wages' are
phrases that don't mean anything in the world until
you find out which of them will BUY the most!"

It was a crusher.

But, alas! it didn't crush. No, I had to give it up.
What those people valued was HIGH WAGES; it didn't
seem to be a matter of any consequence to them
whether the high wages would buy anything or not.
They stood for "protection," and swore by it, which
was reasonable enough, because interested parties had
gulled them into the notion that it was protection which
had created their high wages. I proved to them that
in a quarter of a century their wages had advanced but
30 per cent., while the cost of living had gone up 100;
and that with us, in a shorter time, wages had ad-
vanced 40 per cent. while the cost of living had gone
steadily down. But it didn't do any good. Nothing
could unseat their strange beliefs.

Well, I was smarting under a sense of defeat. Un-
deserved defeat, but what of that? That didn't soften
the smart any. And to think of the circumstances!
the first statesman of the age, the capablest man, the
best-informed man in the entire world, the loftiest un-
crowned head that had moved through the clouds of
any political firmament for centuries, sitting here ap-
parently defeated in argument by an ignorant country
blacksmith! And I could see that those others were
sorry for me -- which made me blush till I could smell
my whiskers scorching. Put yourself in my place;
feel as mean as I did, as ashamed as I felt -- wouldn't
YOU have struck below the belt to get even? Yes, you
would; it is simply human nature. Well, that is what
I did. I am not trying to justify it; I'm only saying
that I was mad, and ANYBODY would have done it.

Well, when I make up my mind to hit a man, I
don't plan out a love-tap; no, that isn't my way; as
long as I'm going to hit him at all, I'm going to hit
him a lifter. And I don't jump at him all of a sudden,
and risk making a blundering half-way business of it;
no, I get away off yonder to one side, and work up on
him gradually, so that he never suspects that I'm going
to hit him at all; and by and by, all in a flash, he's
flat on his back, and he can't tell for the life of him
how it all happened. That is the way I went for
brother Dowley. I started to talking lazy and com-
fortable, as if I was just talking to pass the time; and
the oldest man in the world couldn't have taken the
bearings of my starting place and guessed where I was
going to fetch up:

"Boys, there's a good many curious things about
law, and custom, and usage, and all that sort of thing,
when you come to look at it; yes, and about the drift
and progress of human opinion and movement, too.
There are written laws -- they perish; but there are
also unwritten laws -- THEY are eternal. Take the un-
written law of wages: it says they've got to advance,
little by little, straight through the centuries. And
notice how it works. We know what wages are now,
here and there and yonder; we strike an average, and say
that's the wages of to-day. We know what the wages
were a hundred years ago, and what they were two
hundred years ago; that's as far back as we can get,
but it suffices to give us the law of progress, the
measure and rate of the periodical augmentation; and
so, without a document to help us, we can come pretty
close to determining what the wages were three and
four and five hundred years ago. Good, so far. Do
we stop there? No. We stop looking backward; we
face around and apply the law to the future. My
friends, I can tell you what people's wages are going
to be at any date in the future you want to know, for
hundreds and hundreds of years."

"What, goodman, what!"

"Yes. In seven hundred years wages will have
risen to six times what they are now, here in your
region, and farm hands will be allowed 3 cents a day,
and mechanics 6."

"I would't I might die now and live then!" inter-
rupted Smug, the wheelwright, with a fine avaricious
glow in his eye.

"And that isn't all; they'll get their board besides --
such as it is: it won't bloat them. Two hundred and
fifty years later -- pay attention now -- a mechanic's
wages will be --  mind you, this is law, not guesswork;
a mechanic's wages will then be TWENTY cents a day!"

There was a general gasp of awed astonishment,
Dickon the mason murmured, with raised eyes and
hands:

"More than three weeks' pay for one day's work!"

"Riches! -- of a truth, yes, riches!" muttered
Marco, his breath coming quick and short, with ex-
citement.

"Wages will keep on rising, little by little, little by
little, as steadily as a tree grows, and at the end of
three hundred and forty years more there'll be at least
ONE country where the mechanic's average wage will be
TWO HUNDRED cents a day!"

It knocked them absolutely dumb! Not a man of
them could get his breath for upwards of two minutes.
Then the coal-burner said prayerfully:

"Might I but live to see it!"

"It is the income of an earl!" said Smug.

"An earl, say ye?" said Dowley; "ye could say
more than that and speak no lie; there's no earl in the
realm of Bagdemagus that hath an income like to
that. Income of an earl -- mf! it's the income of an
angel!"

"Now, then, that is what is going to happen as re-
gards wages. In that remote day, that man will earn,
with ONE week's work, that bill of goods which it takes
you upwards of FIFTY weeks to earn now. Some other
pretty surprising things are going to happen, too.
Brother Dowley, who is it that determines, every
spring, what the particular wage of each kind of
mechanic, laborer, and servant shall be for that year?"

"Sometimes the courts, sometimes the town coun-
cil; but most of all, the magistrate. Ye may say, in
general terms, it is the magistrate that fixes the wages."

"Doesn't ask any of those poor devils to HELP him
fix their wages for them, does he?"

"Hm! That WERE an idea! The master that's to
pay him the money is the one that's rightly concerned
in that matter, ye will notice "

"Yes -- but I thought the other man might have
some little trifle at stake in it, too; and even his wife
and children, poor creatures. The masters are these:
nobles, rich men, the prosperous generally. These
few, who do no work, determine what pay the vast
hive shall have who DO work. You see? They're a
'combine' -- a trade union, to coin a new phrase --
who band themselves together to force their lowly
brother to take what they choose to give. Thirteen
hundred years hence -- so says the unwritten law -- the
'combine' will be the other way, and then how these
fine people's posterity will fume and fret and grit their
teeth over the insolent tyranny of trade unions! Yes,
indeed! the magistrate will tranquilly arrange the
wages from now clear away down into the nineteenth
century; and then all of a sudden the wage-earner will
consider that a couple of thousand years or so is
enough of this one-sided sort of thing; and he will
rise up and take a hand in fixing his wages himself.
Ah, he will have a long and bitter account of wrong
and humiliation to settle."

"Do ye believe -- "

"That he actually will help to fix his own wages?
Yes, indeed. And he will be strong and able, then."

"Brave times, brave times, of a truth!" sneered
the prosperous smith.

"Oh, -- and there's another detail. In that day, a
master may hire a man for only just one day, or one
week, or one month at a time, if he wants to."

"What?"

"It's true. Moreover, a magistrate won't be able
to force a man to work for a master a whole year on a
stretch whether the man wants to or not."

"Will there be NO law or sense in that day?"

"Both of them, Dowley. In that day a man will
be his own property, not the property of magistrate
and master. And he can leave town whenever he
wants to, if the wages don't suit him! -- and they
can't put him in the pillory for it."

"Perdition catch such an age!" shouted Dowley,
in strong indignation. "An age of dogs, an age barren
of reverence for superiors and respect for authority!
The pillory --"

"Oh, wait, brother; say no good word for that in-
stitution. I think the pillory ought to be abolished."

"A most strange idea. Why?"

"Well, I'll tell you why. Is a man ever put in the
pillory for a capital crime?"

"No."

"Is it right to condemn a man to a slight punish-
ment for a small offense and then kill him?"

There was no answer. I had scored my first point!
For the first time, the smith wasn't up and ready.
The company noticed it. Good effect.

"You don't answer, brother. You were about to
glorify the pillory a while ago, and shed some pity on
a future age that isn't going to use it. I think the
pillory ought to be abolished. What usually happens
when a poor fellow is put in the pillory for some little
offense that didn't amount to anything in the world?
The mob try to have some fun with him, don't they?"

"Yes."

"They begin by clodding him; and they laugh
themselves to pieces to see him try to dodge one clod
and get hit with another?"

"Yes."

"Then they throw dead cats at him, don't they?"

"Yes."

"Well, then, suppose he has a few personal enemies
in that mob and here and there a man or a woman
with a secret grudge against him -- and suppose
especially that he is unpopular in the community, for
his pride, or his prosperity, or one thing or another --
stones and bricks take the place of clods and cats
presently, don't they?"

"There is no doubt of it."

"As a rule he is crippled for life, isn't he? -- jaws
broken, teeth smashed out? -- or legs mutilated, gan-
grened, presently cut off? -- or an eye knocked out,
maybe both eyes?"

"It is true, God knoweth it."

"And if he is unpopular he can depend on DYING,
right there in the stocks, can't he?"

"He surely can! One may not deny it."

"I take it none of YOU are unpopular -- by reason
of pride or insolence, or conspicuous prosperity, or
any of those things that excite envy and malice among
the base scum of a village? YOU wouldn't think it
much of a risk to take a chance in the stocks?"

Dowley winced, visibly. I judged he was hit. But
he didn't betray it by any spoken word. As for the
others, they spoke out plainly, and with strong feeling.
They said they had seen enough of the stocks to know
what a man's chance in them was, and they would
never consent to enter them if they could compromise
on a quick death by hanging.

"Well, to change the subject -- for I think I've
established my point that the stocks ought to be abol-
ished. I think some of our laws are pretty unfair.
For instance, if I do a thing which ought to deliver
me to the stocks, and you know I did it and yet keep
still and don't report me, YOU will get the stocks if
anybody informs on you."

"Ah, but that would serve you but right," said
Dowley, "for you MUST inform. So saith the law."

The others coincided.

"Well, all right, let it go, since you vote me down.
But there's one thing which certainly isn't fair. The
magistrate fixes a mechanic's wage at 1 cent a day,
for instance. The law says that if any master shall
venture, even under utmost press of business, to pay
anything OVER that cent a day, even for a single day,
he shall be both fined and pilloried for it; and who-
ever knows he did it and doesn't inform, they also shall
be fined and pilloried. Now it seems to me unfair,
Dowley, and a deadly peril to all of us, that because
you thoughtlessly confessed, a while ago, that within a
week you have paid a cent and fifteen mil --"

Oh, I tell YOU it was a smasher! You ought to have
seen them to go to pieces, the whole gang. I had just
slipped up on poor smiling and complacent Dowley so
nice and easy and softly, that he never suspected any-
thing was going to happen till the blow came crashing
down and knocked him all to rags.

A fine effect. In fact, as fine as any I ever pro-
duced, with so little time to work it up in.

But I saw in a moment that I had overdone the
thing a little. I was expecting to scare them, but I
wasn't expecting to scare them to death. They were
mighty near it, though. You see they had been a
whole lifetime learning to appreciate the pillory; and
to have that thing staring them in the face, and every
one of them distinctly at the mercy of me, a stranger,
if I chose to go and report -- well, it was awful, and
they couldn't seem to recover from the shock, they
couldn't seem to pull themselves together. Pale,
shaky, dumb, pitiful? Why, they weren't any better
than so many dead men. It was very uncomfortable.
Of course, I thought they would appeal to me to keep
mum, and then we would shake hands, and take a
drink all round, and laugh it off, and there an end.
But no; you see I was an unknown person, among a
cruelly oppressed and suspicious people, a people
always accustomed to having advantage taken of their
helplessness, and never expecting just or kind treat-
ment from any but their own families and very closest
intimates. Appeal to ME to be gentle, to be fair, to
be generous? Of course, they wanted to, but they
couldn't dare.


CHAPTER XXXIV.
THE YANKEE AND THE KING SOLD AS SLAVES

WELL, what had I better do? Nothing in a hurry,
sure. I must get up a diversion; anything to
employ me while I could think, and while these poor
fellows could have a chance to come to life again.
There sat Marco, petrified in the act of trying to get
the hang of his miller-gun -- turned to stone, just in
the attitude he was in when my pile-driver fell, the toy
still gripped in his unconscious fingers. So I took it
from him and proposed to explain its mystery.
Mystery! a simple little thing like that; and yet it
was mysterious enough, for that race and that age.

I never saw such an awkward people, with machin-
ery; you see, they were totally unused to it. The
miller-gun was a little double-barreled tube of tough-
ened glass, with a neat little trick of a spring to it,
which upon pressure would let a shot escape. But the
shot wouldn't hurt anybody, it would only drop into
your hand. In the gun were two sizes -- wee mustard-
seed shot, and another sort that were several times
larger. They were money. The mustard-seed shot
represented milrays, the larger ones mills. So the
gun was a purse; and very handy, too; you could
pay out money in the dark with it, with accuracy; and
you could carry it in your mouth; or in your vest
pocket, if you had one. I made them of several sizes
-- one size so large that it would carry the equivalent
of a dollar. Using shot for money was a good thing
for the government; the metal cost nothing, and the
money couldn't be counterfeited, for I was the only
person in the kingdom who knew how to manage a
shot tower. "Paying the shot" soon came to be a
common phrase. Yes, and I knew it would still be
passing men's lips, away down in the nineteenth cen-
tury, yet none would suspect how and when it origi-
nated.

The king joined us, about this time, mightily re-
freshed by his nap, and feeling good. Anything could
make me nervous now, I was so uneasy -- for our lives
were in danger; and so it worried me to detect a com-
placent something in the king's eye which seemed to
indicate that he had been loading himself up for a
performance of some kind or other; confound it, why
must he go and choose such a time as this?

I was right. He began, straight off, in the most
innocently artful, and transparent, and lubberly way,
to lead up to the subject of agriculture. The cold
sweat broke out all over me. I wanted to whisper in
his ear, "Man, we are in awful danger! every moment
is worth a principality till we get back these men's
confidence; DON'T waste any of this golden time."
But of course I couldn't do it. Whisper to him? It
would look as if we were conspiring. So I had to sit
there and look calm and pleasant while the king stood
over that dynamite mine and mooned along about his
damned onions and things. At first the tumult of my
own thoughts, summoned by the danger-signal and
swarming to the rescue from every quarter of my
skull, kept up such a hurrah and confusion and fifing
and drumming that I couldn't take in a word; but
presently when my mob of gathering plans began to
crystallize and fall into position and form line of battle,
a sort of order and quiet ensued and I caught the boom
of the king's batteries, as if out of remote distance:

"-- were not the best way, methinks, albeit it is not
to be denied that authorities differ as concerning this
point, some contending that the onion is but an un-
wholesome berry when stricken early from the tree --"

The audience showed signs of life, and sought each
other's eyes in a surprised and troubled way.

"-- whileas others do yet maintain, with much show
of reason, that this is not of necessity the case, instanc-
ing that plums and other like cereals do be always dug
in the unripe state --"

The audience exhibited distinct distress; yes, and
also fear.

"-- yet are they clearly wholesome, the more espe-
cially when one doth assuage the asperities of their
nature by admixture of the tranquilizing juice of the
wayward cabbage --"

The wild light of terror began to glow in these men's
eyes, and one of them muttered, "These be errors,
every one -- God hath surely smitten the mind of this
farmer." I was in miserable apprehension; I sat upon
thorns.

"-- and further instancing the known truth that in
the case of animals, the young, which may be called
the green fruit of the creature, is the better, all con-
fessing that when a goat is ripe, his fur doth heat and
sore engame his flesh, the which defect, taken in con-
nection with his several rancid habits, and fulsome
appetites, and godless attitudes of mind, and bilious
quality of morals --"

They rose and went for him! With a fierce shout,
"The one would betray us, the other is mad! Kill
them! Kill them!" they flung themselves upon us.
What joy flamed up in the king's eye! He might be
lame in agriculture, but this kind of thing was just in
his line. He had been fasting long, he was hungry
for a fight. He hit the blacksmith a crack under the
jaw that lifted him clear off his feet and stretched him
flat on his back. "St. George for Britain!" and he
downed the wheelwright. The mason was big, but I
laid him out like nothing. The three gathered them-
selves up and came again; went down again; came
again; and kept on repeating this, with native British
pluck, until they were battered to jelly, reeling with
exhaustion, and so blind that they couldn't tell us
from each other; and yet they kept right on, hammer-
ing away with what might was left in them. Ham-
mering each other -- for we stepped aside and looked
on while they rolled, and struggled, and gouged, and
pounded, and bit, with the strict and wordless attention
to business of so many bulldogs. We looked on with-
out apprehension, for they were fast getting past
ability to go for help against us, and the arena was
far enough from the public road to be safe from
intrusion.

Well, while they were gradually playing out, it sud-
denly occurred to me to wonder what had become of
Marco. I looked around; he was nowhere to be seen.
Oh, but this was ominous! I pulled the king's sleeve,
and we glided away and rushed for the hut. No Marco
there, no Phyllis there! They had gone to the road
for help, sure. I told the king to give his heels wings,
and I would explain later. We made good time across
the open ground, and as we darted into the shelter of
the wood I glanced back and saw a mob of excited
peasants swarm into view, with Marco and his wife at
their head. They were making a world of noise, but
that couldn't hurt anybody; the wood was dense, and
as soon as we were well into its depths we would take
to a tree and let them whistle. Ah, but then came
another sound -- dogs! Yes, that was quite another
matter. It magnified our contract -- we must find
running water.

We tore along at a good gait, and soon left the
sounds far behind and modified to a murmur. We
struck a stream and darted into it. We waded swiftly
down it, in the dim forest light, for as much as three
hundred yards, and then came across an oak with a
great bough sticking out over the water. We climbed
up on this bough, and began to work our way along it
to the body of the tree; now we began to hear those
sounds more plainly; so the mob had struck our trail.
For a while the sounds approached pretty fast. And
then for another while they didn't. No doubt the
dogs had found the place where we had entered the
stream, and were now waltzing up and down the shores
trying to pick up the trail again.

When we were snugly lodged in the tree and cur-
tained with foliage, the king was satisfied, but I was
doubtful. I believed we could crawl along a branch
and get into the next tree, and I judged it worth while
to try. We tried it, and made a success of it, though
the king slipped, at the junction, and came near failing
to connect. We got comfortable lodgment and satis-
factory concealment among the foliage, and then we
had nothing to do but listen to the hunt.

Presently we heard it coming -- and coming on the
jump, too; yes, and down both sides of the stream.
Louder -- louder -- next minute it swelled swiftly up
into a roar of shoutings, barkings, tramplings, and
swept by like a cyclone.

"I was afraid that the overhanging branch would
suggest something to them," said I, "but I don't
mind the disappointment. Come, my liege, it were
well that we make good use of our time. We've
flanked them. Dark is coming on, presently. If we
can cross the stream and get a good start, and borrow
a couple of horses from somebody's pasture to use for
a few hours, we shall be safe enough."

We started down, and got nearly to the lowest limb,
when we seemed to hear the hunt returning. We
stopped to listen.

"Yes," said I, "they're baffled, they've given it
up, they're on their way home. We will climb back
to our roost again, and let them go by."

So we climbed back. The king listened a moment
and said:

"They still search -- I wit the sign. We did best to
abide."

He was right. He knew more about hunting than I
did. The noise approached steadily, but not with a
rush. The king said:

"They reason that we were advantaged by no par-
lous start of them, and being on foot are as yet no
mighty way from where we took the water."

"Yes, sire, that is about it, I am afraid, though I
was hoping better things."

The noise drew nearer and nearer, and soon the van
was drifting under us, on both sides of the water. A
voice called a halt from the other bank, and said:

"An they were so minded, they could get to yon
tree by this branch that overhangs, and yet not touch
ground. Ye will do well to send a man up it."

"Marry, that we will do!"

I was obliged to admire my cuteness in foreseeing
this very thing and swapping trees to beat it. But,
don't you know, there are some things that can beat
smartness and foresight? Awkwardness and stupidity
can. The best swordsman in the world doesn't need
to fear the second best swordsman in the world; no,
the person for him to be afraid of is some ignorant
antagonist who has never had a sword in his hand be-
fore; he doesn't do the thing he ought to do, and so
the expert isn't prepared for him; he does the thing
he ought not to do; and often it catches the expert
out and ends him on the spot. Well, how could I,
with all my gifts, make any valuable preparation against
a near-sighted, cross-eyed, pudding-headed clown who
would aim himself at the wrong tree and hit the right
one? And that is what he did. He went for the
wrong tree, which was, of course, the right one by
mistake, and up he started.

Matters were serious now. We remained still, and
awaited developments. The peasant toiled his difficult
way up. The king raised himself up and stood; he
made a leg ready, and when the comer's head arrived
in reach of it there was a dull thud, and down went
the man floundering to the ground. There was a wild
outbreak of anger below, and the mob swarmed in
from all around, and there we were treed, and prison-
ers. Another man started up; the bridging bough
was detected, and a volunteer started up the tree that
furnished the bridge. The king ordered me to play
Horatius and keep the bridge. For a while the enemy
came thick and fast; but no matter, the head man of
each procession always got a buffet that dislodged him
as soon as he came in reach. The king's spirits rose,
his joy was limitless. He said that if nothing occurred
to mar the prospect we should have a beautiful night,
for on this line of tactics we could hold the tree against
the whole country-side.

However, the mob soon came to that conclusion
themselves; wherefore they called off the assault and
began to debate other plans. They had no weapons,
but there were plenty of stones, and stones might
answer. We had no objections. A stone might pos-
sibly penetrate to us once in a while, but it wasn't
very likely; we were well protected by boughs and
foliage, and were not visible from any good aiming
point. If they would but waste half an hour in stone-
throwing, the dark would come to our help. We were
feeling very well satisfied. We could smile; almost
laugh.

But we didn't; which was just as well, for we should
have been interrupted. Before the stones had been
raging through the leaves and bouncing from the
boughs fifteen minutes, we began to notice a smell.
A couple of sniffs of it was enough of an explanation --
it was smoke! Our game was up at last. We recog-
nized that. When smoke invites you, you have to
come. They raised their pile of dry brush and damp
weeds higher and higher, and when they saw the thick
cloud begin to roll up and smother the tree, they broke
out in a storm of joy-clamors. I got enough breath to
say:

"Proceed, my liege; after you is manners."

The king gasped:

"Follow me down, and then back thyself against
one side of the trunk, and leave me the other. Then
will we fight. Let each pile his dead according to his
own fashion and taste."

Then he descended, barking and coughing, and I
followed. I struck the ground an instant after him;
we sprang to our appointed places, and began to give
and take with all our might. The powwow and racket
were prodigious; it was a tempest of riot and con-
fusion and thick-falling blows. Suddenly some horse-
men tore into the midst of the crowd, and a voice
shouted:

"Hold -- or ye are dead men!"

How good it sounded! The owner of the voice
bore all the marks of a gentleman: picturesque and
costly raiment, the aspect of command, a hard coun-
tenance, with complexion and features marred by dis-
sipation. The mob fell humbly back, like so many
spaniels. The gentleman inspected us critically, then
said sharply to the peasants:

"What are ye doing to these people?"

"They be madmen, worshipful sir, that have come
wandering we know not whence, and --"

"Ye know not whence? Do ye pretend ye know
them not?"

"Most honored sir, we speak but the truth. They
are strangers and unknown to any in this region; and
they be the most violent and bloodthirsty madmen that
ever --"

"Peace! Ye know not what ye say. They are not
mad. Who are ye? And whence are ye? Explain."

"We are but peaceful strangers, sir," I said, "and
traveling upon our own concerns. We are from a far
country, and unacquainted here. We have purposed
no harm; and yet but for your brave interference and
protection these people would have killed us. As you
have divined, sir, we are not mad; neither are we
violent or bloodthirsty."

The gentleman turned to his retinue and said calmly:
"Lash me these animals to their kennels!"

The mob vanished in an instant; and after them
plunged the horsemen, laying about them with their
whips and pitilessly riding down such as were witless
enough to keep the road instead of taking to the bush.
The shrieks and supplications presently died away in
the distance, and soon the horsemen began to straggle
back. Meantime the gentleman had been questioning
us more closely, but had dug no particulars out of us.
We were lavish of recognition of the service he was
doing us, but we revealed nothing more than that we
were friendless strangers from a far country. When
the escort were all returned, the gentleman said to one
of his servants:

"Bring the led-horses and mount these people."

"Yes, my lord."

We were placed toward the rear, among the servants.
We traveled pretty fast, and finally drew rein some
time after dark at a roadside inn some ten or twelve
miles from the scene of our troubles. My lord went
immediately to his room, after ordering his supper,
and we saw no more of him. At dawn in the morning
we breakfasted and made ready to start.

My lord's chief attendant sauntered forward at that
moment with indolent grace, and said:

"Ye have said ye should continue upon this road,
which is our direction likewise; wherefore my lord,
the earl Grip, hath given commandment that ye retain
the horses and ride, and that certain of us ride with
ye a twenty mile to a fair town that hight Cambenet,
whenso ye shall be out of peril."

We could do nothing less than express our thanks
and accept the offer. We jogged along, six in the
party, at a moderate and comfortable gait, and in con-
versation learned that my lord Grip was a very great
personage in his own region, which lay a day's journey
beyond Cambenet. We loitered to such a degree that
it was near the middle of the forenoon when we entered
the market square of the town. We dismounted, and
left our thanks once more for my lord, and then ap-
proached a crowd assembled in the center of the
square, to see what might be the object of interest.
It was the remnant of that old peregrinating band of
slaves! So they had been dragging their chains about,
all this weary time. That poor husband was gone, and
also many others; and some few purchases had been
added to the gang. The king was not interested, and
wanted to move along, but I was absorbed, and full of
pity. I could not take my eyes away from these worn
and wasted wrecks of humanity. There they sat,
grounded upon the ground, silent, uncomplaining, with
bowed heads, a pathetic sight. And by hideous con-
trast, a redundant orator was making a speech to
another gathering not thirty steps away, in fulsome
laudation of "our glorious British liberties!"

I was boiling. I had forgotten I was a plebeian, I
was remembering I was a man. Cost what it might, I
would mount that rostrum and --

Click! the king and I were handcuffed together!
Our companions, those servants, had done it; my lord
Grip stood looking on. The king burst out in a fury,
and said:

"What meaneth this ill-mannered jest?"

My lord merely said to his head miscreant, coolly:

"Put up the slaves and sell them!"

SLAVES! The word had a new sound -- and how
unspeakably awful! The king lifted his manacles and
brought them down with a deadly force; but my lord
was out of the way when they arrived. A dozen of
the rascal's servants sprang forward, and in a moment
we were helpless, with our hands bound behind us.
We so loudly and so earnestly proclaimed ourselves
freemen, that we got the interested attention of that
liberty-mouthing orator and his patriotic crowd, and
they gathered about us and assumed a very determined
attitude. The orator said:

"If, indeed, ye are freemen, ye have nought to
fear -- the God-given liberties of Britain are about ye
for your shield and shelter! (Applause.) Ye shall
soon see. Bring forth your proofs."

"What proofs?"

"Proof that ye are freemen."

Ah -- I remembered! I came to myself; I said
nothing. But the king stormed out:

"Thou'rt insane, man. It were better, and more
in reason, that this thief and scoundrel here prove that
we are NOT freemen."

You see, he knew his own laws just as other people
so often know the laws; by words, not by effects.
They take a MEANING, and get to be very vivid, when
you come to apply them to yourself.

All hands shook their heads and looked disap-
pointed; some turned away, no longer interested. The
orator said -- and this time in the tones of business,
not of sentiment:

"An ye do not know your country's laws, it were
time ye learned them. Ye are strangers to us; ye will
not deny that. Ye may be freemen, we do not deny
that; but also ye may be slaves. The law is clear: it
doth not require the claimant to prove ye are slaves, it
requireth you to prove ye are not."

I said:

"Dear sir, give us only time to send to Astolat; or
give us only time to send to the Valley of Holiness --"

"Peace, good man, these are extraordinary requests,
and you may not hope to have them granted. It would
cost much time, and would unwarrantably inconveni-
ence your master --"

"MASTER, idiot!" stormed the king. "I have no
master, I myself am the m--"

"Silence, for God's sake!"

I got the words out in time to stop the king. We
were in trouble enough already; it could not help us
any to give these people the notion that we were
lunatics.

There is no use in stringing out the details. The
earl put us up and sold us at auction. This same in-
fernal law had existed in our own South in my own
time, more than thirteen hundred years later, and
under it hundreds of freemen who could not prove that
they were freemen had been sold into lifelong slavery
without the circumstance making any particular im-
pression upon me; but the minute law and the auction
block came into my personal experience, a thing
which had been merely improper before became sud-
denly hellish. Well, that's the way we are made.

Yes, we were sold at auction, like swine. In a big
town and an active market we should have brought a
good price; but this place was utterly stagnant and so
we sold at a figure which makes me ashamed, every
time I think of it. The King of England brought
seven dollars, and his prime minister nine; whereas
the king was easily worth twelve dollars and I as easily
worth fifteen. But that is the way things always go;
if you force a sale on a dull market, I don't care what
the property is, you are going to make a poor business
of it, and you can make up your mind to it. If the
earl had had wit enough to --

However, there is no occasion for my working my
sympathies up on his account. Let him go, for the
present; I took his number, so to speak.

The slave-dealer bought us both, and hitched us
onto that long chain of his, and we constituted the rear
of his procession. We took up our line of march and
passed out of Cambenet at noon; and it seemed to me
unaccountably strange and odd that the King of Eng-
land and his chief minister, marching manacled and
fettered and yoked, in a slave convoy, could move by
all manner of idle men and women, and under windows
where sat the sweet and the lovely, and yet never
attract a curious eye, never provoke a single remark.
Dear, dear, it only shows that there is nothing diviner
about a king than there is about a tramp, after all.
He is just a cheap and hollow artificiality when you
don't know he is a king. But reveal his quality, and
dear me it takes your very breath away to look at him.
I reckon we are all fools. Born so, no doubt.


CHAPTER XXXV.
A PITIFUL INCIDENT

IT'S a world of surprises. The king brooded; this
was natural. What would he brood about, should
you say? Why, about the prodigious nature of his
fall, of course -- from the loftiest place in the world to
the lowest; from the most illustrious station in the
world to the obscurest; from the grandest vocation
among men to the basest. No, I take my oath that
the thing that graveled him most, to start with, was
not this, but the price he had fetched! He couldn't
seem to get over that seven dollars. Well, it stunned
me so, when I first found it out, that I couldn't believe
it; it didn't seem natural. But as soon as my mental
sight cleared and I got a right focus on it, I saw I was
mistaken; it WAS natural. For this reason: a king is
a mere artificiality, and so a king's feelings, like the
impulses of an automatic doll, are mere artificialities;
but as a man, he is a reality, and his feelings, as a
man, are real, not phantoms. It shames the average
man to be valued below his own estimate of his worth,
and the king certainly wasn't anything more than an
average man, if he was up that high.

Confound him, he wearied me with arguments to
show that in anything like a fair market he would have
fetched twenty-five dollars, sure -- a thing which was
plainly nonsense, and full or the baldest conceit; I
wasn't worth it myself. But it was tender ground for
me to argue on. In fact, I had to simply shirk argu-
ment and do the diplomatic instead. I had to throw
conscience aside, and brazenly concede that he ought
to have brought twenty-five dollars; whereas I was
quite well aware that in all the ages, the world had
never seen a king that was worth half the money, and
during the next thirteen centuries wouldn't see one
that was worth the fourth of it. Yes, he tired me. If
he began to talk about the crops; or about the recent
weather; or about the condition of politics; or about
dogs, or cats, or morals, or theology -- no matter
what -- I sighed, for I knew what was coming; he
was going to get out of it a palliation of that tiresome
seven-dollar sale. Wherever we halted where there
was a crowd, he would give me a look which said
plainly: "if that thing could be tried over again now,
with this kind of folk, you would see a different re-
sult." Well, when he was first sold, it secretly tickled
me to see him go for seven dollars; but before he was
done with his sweating and worrying I wished he had
fetched a hundred. The thing never got a chance to
die, for every day, at one place or another, possible
purchasers looked us over, and, as often as any other
way, their comment on the king was something like
this:

"Here's a two-dollar-and-a-half chump with a thirty-
dollar style. Pity but style was marketable."

At last this sort of remark produced an evil result.
Our owner was a practical person and he perceived
that this defect must be mended if he hoped to find a
purchaser for the king. So he went to work to take
the style out of his sacred majesty. I could have
given the man some valuable advice, but I didn't; you
mustn't volunteer advice to a slave-driver unless you
want to damage the cause you are arguing for. I had
found it a sufficiently difficult job to reduce the king's
style to a peasant's style, even when he was a willing
and anxious pupil; now then, to undertake to reduce
the king's style to a slave's style -- and by force -- go
to! it was a stately contract. Never mind the details
-- it will save me trouble to let you imagine them. I
will only remark that at the end of a week there was
plenty of evidence that lash and club and fist had done
their work well; the king's body was a sight to see --
and to weep over; but his spirit? -- why, it wasn't
even phased. Even that dull clod of a slave-driver
was able to see that there can be such a thing as a
slave who will remain a man till he dies; whose bones
you can break, but whose manhood you can't. This
man found that from his first effort down to his latest,
he couldn't ever come within reach of the king, but the
king was ready to plunge for him, and did it. So he
gave up at last, and left the king in possession of his
style unimpaired. The fact is, the king was a good
deal more than a king, he was a man; and when a
man is a man, you can't knock it out of him.

We had a rough time for a month, tramping to and
fro in the earth, and suffering. And what Englishman
was the most interested in the slavery question by that
time? His grace the king! Yes; from being the
most indifferent, he was become the most interested.
He was become the bitterest hater of the institution I
had ever heard talk. And so I ventured to ask once
more a question which I had asked years before and
had gotten such a sharp answer that I had not thought
it prudent to meddle in the matter further. Would he
abolish slavery?

His answer was as sharp as before, but it was music
this time; I shouldn't ever wish to hear pleasanter,
though the profanity was not good, being awkwardly
put together, and with the crash-word almost in the
middle instead of at the end, where, of course, it ought
to have been.

I was ready and willing to get free now; I hadn't
wanted to get free any sooner. No, I cannot quite
say that. I had wanted to, but I had not been willing
to take desperate chances, and had always dissuaded
the king from them. But now -- ah, it was a new
atmosphere! Liberty would be worth any cost that
might be put upon it now. I set about a plan, and
was straightway charmed with it. It would require
time, yes, and patience, too, a great deal of both.
One could invent quicker ways, and fully as sure ones;
but none that would be as picturesque as this; none
that could be made so dramatic. And so I was not
going to give this one up. It might delay us months,
but no matter, I would carry it out or break some-
thing.

Now and then we had an adventure. One night we
were overtaken by a snow-storm while still a mile from
the village we were making for. Almost instantly we
were shut up as in a fog, the driving snow was so
thick. You couldn't see a thing, and we were soon
lost. The slave-driver lashed us desperately, for he
saw ruin before him, but his lashings only made mat-
ters worse, for they drove us further from the road and
from likelihood of succor. So we had to stop at last
and slump down in the snow where we were. The
storm continued until toward midnight, then ceased.
By this time two of our feebler men and three of our
women were dead, and others past moving and threat-
ened with death. Our master was nearly beside him-
self. He stirred up the living, and made us stand,
jump, slap ourselves, to restore our circulation, and he
helped as well as he could with his whip.

Now came a diversion. We heard shrieks and yells,
and soon a woman came running and crying; and see-
ing our group, she flung herself into our midst and
begged for protection. A mob of people came tearing
after her, some with torches, and they said she was a
witch who had caused several cows to die by a strange
disease, and practiced her arts by help of a devil in
the form of a black cat. This poor woman had been
stoned until she hardly looked human, she was so
battered and bloody. The mob wanted to burn her.

Well, now, what do you suppose our master did?
When we closed around this poor creature to shelter
her, he saw his chance. He said, burn her here, or
they shouldn't have her at all. Imagine that! They
were willing. They fastened her to a post; they
brought wood and piled it about her; they applied
the torch while she shrieked and pleaded and strained
her two young daughters to her breast; and our brute,
with a heart solely for business, lashed us into position
about the stake and warmed us into life and commer-
cial value by the same fire which took away the inno-
cent life of that poor harmless mother. That was the
sort of master we had. I took HIS number. That
snow-storm cost him nine of his flock; and he was
more brutal to us than ever, after that, for many days
together, he was so enraged over his loss.

We had adventures all along. One day we ran into
a procession. And such a procession! All the riffraff
of the kingdom seemed to be comprehended in it; and
all drunk at that. In the van was a cart with a coffin
in it, and on the coffin sat a comely young girl of
about eighteen suckling a baby, which she squeezed to
her breast in a passion of love every little while, and
every little while wiped from its face the tears which
her eyes rained down upon it; and always the foolish
little thing smiled up at her, happy and content, knead-
ing her breast with its dimpled fat hand, which she
patted and fondled right over her breaking heart.

Men and women, boys and girls, trotted along beside
or after the cart, hooting, shouting profane and ribald
remarks, singing snatches of foul song, skipping,
dancing -- a very holiday of hellions, a sickening sight.
We had struck a suburb of London, outside the walls,
and this was a sample of one sort of London society.
Our master secured a good place for us near the
gallows. A priest was in attendance, and he helped
the girl climb up, and said comforting words to her,
and made the under-sheriff provide a stool for her.
Then he stood there by her on the gallows, and for a
moment looked down upon the mass of upturned faces
at his feet, then out over the solid pavement of heads
that stretched away on every side occupying the
vacancies far and near, and then began to tell the
story of the case. And there was pity in his voice --
how seldom a sound that was in that ignorant and
savage land! I remember every detail of what he said,
except the words he said it in; and so I change it into
my own words:

"Law is intended to mete out justice. Sometimes
it fails. This cannot be helped. We can only grieve,
and be resigned, and pray for the soul of him who
falls unfairly by the arm of the law, and that his fel-
lows may be few. A law sends this poor young thing
to death -- and it is right. But another law had placed
her where she must commit her crime or starve with
her child -- and before God that law is responsible for
both her crime and her ignominious death!

"A little while ago this young thing, this child of
eighteen years, was as happy a wife and mother as
any in England; and her lips were blithe with song,
which is the native speech of glad and innocent hearts.
Her young husband was as happy as she; for he was
doing his whole duty, he worked early and late at his
handicraft, his bread was honest bread well and fairly
earned, he was prospering, he was furnishing shelter
and sustenance to his family, he was adding his mite
to the wealth of the nation. By consent of a treacher-
ous law, instant destruction fell upon this holy home
and swept it away! That young husband was waylaid
and impressed, and sent to sea. The wife knew
nothing of it. She sought him everywhere, she moved
the hardest hearts with the supplications of her tears,
the broken eloquence of her despair. Weeks dragged
by, she watching, waiting, hoping, her mind going
slowly to wreck under the burden of her misery.
Little by little all her small possessions went for food.
When she could no longer pay her rent, they turned
her out of doors. She begged, while she had strength;
when she was starving at last, and her milk failing, she
stole a piece of linen cloth of the value of a fourth part
of a cent, thinking to sell it and save her child. But
she was seen by the owner of the cloth. She was put
in jail and brought to trial. The man testified to the
facts. A plea was made for her, and her sorrowful
story was told in her behalf. She spoke, too, by per-
mission, and said she did steal the cloth, but that her
mind was so disordered of late by trouble that when
she was overborne with hunger all acts, criminal or
other, swam meaningless through her brain and she
knew nothing rightly, except that she was so hungry!
For a moment all were touched, and there was disposi-
tion to deal mercifully with her, seeing that she was so
young and friendless, and her case so piteous, and the
law that robbed her of her support to blame as being
the first and only cause of her transgression; but the
prosecuting officer replied that whereas these things
were all true, and most pitiful as well, still there was
much small theft in these days, and mistimed mercy
here would be a danger to property -- oh, my God, is
there no property in ruined homes, and orphaned
babes, and broken hearts that British law holds
precious! -- and so he must require sentence.

"When the judge put on his black cap, the owner
of the stolen linen rose trembling up, his lip quivering,
his face as gray as ashes; and when the awful words
came, he cried out, 'Oh, poor child, poor child, I did
not know it was death!' and fell as a tree falls. When
they lifted him up his reason was gone; before the
sun was set, he had taken his own life. A kindly
man; a man whose heart was right, at bottom; add
his murder to this that is to be now done here; and
charge them both where they belong -- to the rulers
and the bitter laws of Britain. The time is come, my
child; let me pray over thee -- not FOR thee, dear
abused poor heart and innocent, but for them that be
guilty of thy ruin and death, who need it more."

After his prayer they put the noose around the
young girl's neck, and they had great trouble to adjust
the knot under her ear, because she was devouring the
baby all the time, wildly kissing it, and snatching it to
her face and her breast, and drenching it with tears,
and half moaning, half shrieking all the while, and the
baby crowing, and laughing, and kicking its feet with
delight over what it took for romp and play. Even
the hangman couldn't stand it, but turned away.
When all was ready the priest gently pulled and tugged
and forced the child out of the mother's arms, and
stepped quickly out of her reach; but she clasped her
hands, and made a wild spring toward him, with a
shriek; but the rope -- and the under-sheriff -- held
her short. Then she went on her knees and stretched
out her hands and cried:

"One more kiss -- oh, my God, one more, one
more, -- it is the dying that begs it!"

She got it; she almost smothered the little thing.
And when they got it away again, she cried out:

"Oh, my child, my darling, it will die! It has no
home, it has no father, no friend, no mother --"

"It has them all!" said that good priest. "All
these will I be to it till I die."

You should have seen her face then! Gratitude?
Lord, what do you want with words to express that?
Words are only painted fire; a look is the fire itself.
She gave that look, and carried it away to the treasury
of heaven, where all things that are divine belong.


CHAPTER XXXVI.
AN ENCOUNTER IN THE DARK

LONDON -- to a slave -- was a sufficiently interest-
ing place. It was merely a great big village;
and mainly mud and thatch. The streets were muddy,
crooked, unpaved. The populace was an ever flocking
and drifting swarm of rags, and splendors, of nodding
plumes and shining armor. The king had a palace
there; he saw the outside of it. It made him sigh;
yes, and swear a little, in a poor juvenile sixth century
way. We saw knights and grandees whom we knew,
but they didn't know us in our rags and dirt and raw
welts and bruises, and wouldn't have recognized us if
we had hailed them, nor stopped to answer, either, it
being unlawful to speak with slaves on a chain. Sandy
passed within ten yards of me on a mule -- hunting
for me, I imagined. But the thing which clean broke
my heart was something which happened in front of
our old barrack in a square, while we were enduring
the spectacle of a man being boiled to death in oil for
counterfeiting pennies. It was the sight of a newsboy
-- and I couldn't get at him! Still, I had one com-
fort -- here was proof that Clarence was still alive and
banging away. I meant to be with him before long;
the thought was full of cheer.

I had one little glimpse of another thing, one day,
which gave me a great uplift. It was a wire stretching
from housetop to housetop. Telegraph or telephone,
sure. I did very much wish I had a little piece of it.
It was just what I needed, in order to carry out my
project of escape. My idea was to get loose some
night, along with the king, then gag and bind our
master, change clothes with him, batter him into the
aspect of a stranger, hitch him to the slave-chain,
assume possession of the property, march to Camelot,
and --

But you get my idea; you see what a stunning
dramatic surprise I would wind up with at the palace.
It was all feasible, if I could only get hold of a slender
piece of iron which I could shape into a lock-pick. I
could then undo the lumbering padlocks with which
our chains were fastened, whenever I might choose.
But I never had any luck; no such thing ever hap-
pened to fall in my way. However, my chance came
at last. A gentleman who had come twice before to
dicker for me, without result, or indeed any approach
to a result, came again. I was far from expecting
ever to belong to him, for the price asked for me from
the time I was first enslaved was exorbitant, and always
provoked either anger or derision, yet my master stuck
stubbornly to it -- twenty-two dollars. He wouldn't
bate a cent. The king was greatly admired, because
of his grand physique, but his kingly style was against
him, and he wasn't salable; nobody wanted that kind
of a slave. I considered myself safe from parting
from him because of my extravagant price. No, I
was not expecting to ever belong to this gentleman
whom I have spoken of, but he had something which
I expected would belong to me eventually, if he would
but visit us often enough. It was a steel thing with a
long pin to it, with which his long cloth outside gar-
ment was fastened together in front. There were
three of them. He had disappointed me twice, be-
cause he did not come quite close enough to me to
make my project entirely safe; but this time I suc-
ceeded; I captured the lower clasp of the three, and
when he missed it he thought he had lost it on the
way.

I had a chance to be glad about a minute, then
straightway a chance to be sad again. For when the
purchase was about to fail, as usual, the master sud-
denly spoke up and said what would be worded thus --
in modern English:

"I'll tell you what I'll do. I'm tired supporting
these two for no good. Give me twenty-two dollars
for this one, and I'll throw the other one in."

The king couldn't get his breath, he was in such a
fury. He began to choke and gag, and meantime the
master and the gentleman moved away discussing.

"An ye will keep the offer open --"

"'Tis open till the morrow at this hour."

"Then I will answer you at that time," said the
gentleman, and disappeared, the master following him.

I had a time of it to cool the king down, but I
managed it. I whispered in his ear, to this effect:

"Your grace WILL go for nothing, but after another
fashion. And so shall I. To-night we shall both be
free."

"Ah! How is that?"

"With this thing which I have stolen, I will unlock
these locks and cast off these chains to-night. When
he comes about nine-thirty to inspect us for the night,
we will seize him, gag him, batter him, and early in
the morning we will march out of this town, proprietors
of this caravan of slaves."

That was as far as I went, but the king was charmed
and satisfied. That evening we waited patiently for
our fellow-slaves to get to sleep and signify it by the
usual sign, for you must not take many chances on
those poor fellows if you can avoid it. It is best to
keep your own secrets. No doubt they fidgeted only
about as usual, but it didn't seem so to me. It seemed
to me that they were going to be forever getting down
to their regular snoring. As the time dragged on I
got nervously afraid we shouldn't have enough of it
left for our needs; so I made several premature
attempts, and merely delayed things by it; for I
couldn't seem to touch a padlock, there in the dark,
without starting a rattle out of it which interrupted
somebody's sleep and made him turn over and wake
some more of the gang.

But finally I did get my last iron off, and was a free
man once more. I took a good breath of relief, and
reached for the king's irons. Too late! in comes the
master, with a light in one hand and his heavy walking-
staff in the other. I snuggled close among the wallow
of snorers, to conceal as nearly as possible that I was
naked of irons; and I kept a sharp lookout and pre-
pared to spring for my man the moment he should
bend over me.

But he didn't approach. He stopped, gazed ab-
sently toward our dusky mass a minute, evidently
thinking about something else; then set down his
light, moved musingly toward the door, and before a
body could imagine what he was going to do, he was
out of the door and had closed it behind him.

"Quick!" said the king. "Fetch him back!"

Of course, it was the thing to do, and I was up and
out in a moment. But, dear me, there were no lamps
in those days, and it was a dark night. But I glimpsed
a dim figure a few steps away. I darted for it, threw
myself upon it, and then there was a state of things
and lively! We fought and scuffled and struggled,
and drew a crowd in no time. They took an immense
interest in the fight and encouraged us all they could,
and, in fact, couldn't have been pleasanter or more
cordial if it had been their own fight. Then a tremen-
dous row broke out behind us, and as much as half of
our audience left us, with a rush, to invest some sym-
pathy in that. Lanterns began to swing in all direc-
tions; it was the watch gathering from far and near.
Presently a halberd fell across my back, as a reminder,
and I knew what it meant. I was in custody. So
was my adversary. We were marched off toward
prison, one on each side of the watchman. Here was
disaster, here was a fine scheme gone to sudden de-
struction! I tried to imagine what would happen
when the master should discover that it was I who
had been fighting him; and what would happen if they
jailed us together in the general apartment for brawlers
and petty law-breakers, as was the custom; and what
might --

Just then my antagonist turned his face around in
my direction, the freckled light from the watchman's
tin lantern fell on it, and, by George, he was the wrong
man!


CHAPTER XXXVII.
AN AWFUL PREDICAMENT

SLEEP? It was impossible. It would naturally
have been impossible in that noisome cavern of
a jail, with its mangy crowd of drunken, quarrelsome,
and song-singing rapscallions. But the thing that
made sleep all the more a thing not to be dreamed of,
was my racking impatience to get out of this place and
find out the whole size of what might have happened
yonder in the slave-quarters in consequence of that
intolerable miscarriage of mine.

It was a long night, but the morning got around at
last. I made a full and frank explanation to the court.
I said I was a slave, the property of the great Earl
Grip, who had arrived just after dark at the Tabard
inn in the village on the other side of the water, and
had stopped there over night, by compulsion, he being
taken deadly sick with a strange and sudden disorder.
I had been ordered to cross to the city in all haste and
bring the best physician; I was doing my best;
naturally I was running with all my might; the night
was dark, I ran against this common person here, who
seized me by the throat and began to pummel me,
although I told him my errand, and implored him, for
the sake of the great earl my master's mortal peril --

The common person interrupted and said it was a
lie; and was going to explain how I rushed upon him
and attacked him without a word --

"Silence, sirrah!" from the court. "Take him
hence and give him a few stripes whereby to teach
him how to treat the servant of a nobleman after a
different fashion another time. Go!"

Then the court begged my pardon, and hoped I
would not fail to tell his lordship it was in no wise the
court's fault that this high-handed thing had happened.
I said I would make it all right, and so took my leave.
Took it just in time, too; he was starting to ask me
why I didn't fetch out these facts the moment I was
arrested. I said I would if I had thought of it --
which was true -- but that I was so battered by that
man that all my wit was knocked out of me -- and
so forth and so on, and got myself away, still mumbling.
I didn't wait for breakfast. No grass grew under
my feet. I was soon at the slave quarters. Empty --
everybody gone! That is, everybody except one body
-- the slave-master's. It lay there all battered to pulp;
and all about were the evidences of a terrific fight.
There was a rude board coffin on a cart at the door,
and workmen, assisted by the police, were thinning a
road through the gaping crowd in order that they
might bring it in.

I picked out a man humble enough in life to conde-
scend to talk with one so shabby as I, and got his ac-
count of the matter.

"There were sixteen slaves here. They rose against
their master in the night, and thou seest how it ended."

"Yes. How did it begin?"

"There was no witness but the slaves. They said
the slave that was most valuable got free of his bonds
and escaped in some strange way -- by magic arts
'twas thought, by reason that he had no key, and the
locks were neither broke nor in any wise injured.
When the master discovered his loss, he was mad with
despair, and threw himself upon his people with his
heavy stick, who resisted and brake his back and in
other and divers ways did give him hurts that brought
him swiftly to his end."

"This is dreadful. It will go hard with the slaves,
no doubt, upon the trial."

"Marry, the trial is over."

"Over!"

"Would they be a week, think you -- and the
matter so simple? They were not the half of a quarter
of an hour at it."

"Why, I don't see how they could determine which
were the guilty ones in so short a time."

"WHICH ones? Indeed, they considered not par-
ticulars like to that. They condemned them in a body.
Wit ye not the law? -- which men say the Romans left
behind them here when they went -- that if one slave
killeth his master all the slaves of that man must die
for it."

"True. I had forgotten. And when will these
die?"

"Belike within a four and twenty hours; albeit some
say they will wait a pair of days more, if peradventure
they may find the missing one meantime."

The missing one! It made me feel uncomfortable.

"Is it likely they will find him?"

"Before the day is spent -- yes. They seek him
everywhere. They stand at the gates of the town,
with certain of the slaves who will discover him to
them if he cometh, and none can pass out but he will
be first examined."

"Might one see the place where the rest are con-
fined?"

"The outside of it -- yes. The inside of it -- but
ye will not want to see that."

I took the address of that prison for future reference
and then sauntered off. At the first second-hand
clothing shop I came to, up a back street, I got a
rough rig suitable for a common seaman who might be
going on a cold voyage, and bound up my face with a
liberal bandage, saying I had a toothache. This con-
cealed my worst bruises. It was a transformation. I
no longer resembled my former self. Then I struck
out for that wire, found it and followed it to its den.
It was a little room over a butcher's shop -- which
meant that business wasn't very brisk in the telegraphic
line. The young chap in charge was drowsing at his
table. I locked the door and put the vast key in my
bosom. This alarmed the young fellow, and he was
going to make a noise; but I said:

"Save your wind; if you open your mouth you are
dead, sure. Tackle your instrument. Lively, now!
Call Camelot."

"This doth amaze me! How should such as you
know aught of such matters as --"

"Call Camelot! I am a desperate man. Call
Camelot, or get away from the instrument and I will
do it myself."

"What -- you?"

"Yes -- certainly. Stop gabbling. Call the palace."

He made the call.

"Now, then, call Clarence."

"Clarence WHO?"

"Never mind Clarence who. Say you want Clar-
ence; you'll get an answer."

He did so. We waited five nerve-straining minutes
-- ten minutes -- how long it did seem! -- and then
came a click that was as familiar to me as a human
voice; for Clarence had been my own pupil.

"Now, my lad, vacate! They would have known
MY touch, maybe, and so your call was surest; but I'm
all right now."

He vacated the place and cocked his ear to listen --
but it didn't win. I used a cipher. I didn't waste
any time in sociabilities with Clarence, but squared
away for business, straight-off -- thus:

"The king is here and in danger. We were cap-
tured and brought here as slaves. We should not be
able to prove our identity -- and the fact is, I am not
in a position to try. Send a telegram for the palace
here which will carry conviction with it."

His answer came straight back:

"They don't know anything about the telegraph;
they haven't had any experience yet, the line to Lon-
don is so new. Better not venture that. They might
hang you. Think up something else."

Might hang us! Little he knew how closely he was
crowding the facts. I couldn't think up anything for
the moment. Then an idea struck me, and I started
it along:

"Send five hundred picked knights with Launcelot
in the lead; and send them on the jump. Let them
enter by the southwest gate, and look out for the man
with a white cloth around his right arm."

The answer was prompt:

"They shall start in half an hour."

"All right, Clarence; now tell this lad here that I'm
a friend of yours and a dead-head; and that he must
be discreet and say nothing about this visit of mine."

The instrument began to talk to the youth and I
hurried away. I fell to ciphering. In half an hour it
would be nine o'clock. Knights and horses in heavy
armor couldn't travel very fast. These would make
the best time they could, and now that the ground was
in good condition, and no snow or mud, they would
probably make a seven-mile gait; they would have to
change horses a couple of times; they would arrive
about six, or a little after; it would still be plenty light
enough; they would see the white cloth which I should
tie around my right arm, and I would take command.
We would surround that prison and have the king out
in no time. It would be showy and picturesque
enough, all things considered, though I would have
preferred noonday, on account of the more theatrical
aspect the thing would have.

Now, then, in order to increase the strings to my
bow, I thought I would look up some of those people
whom I had formerly recognized, and make myself
known. That would help us out of our scrape, with-
out the knights. But I must proceed cautiously, for it
was a risky business. I must get into sumptuous
raiment, and it wouldn't do to run and jump into it.
No, I must work up to it by degrees, buying suit after
suit of clothes, in shops wide apart, and getting a little
finer article with each change, until I should finally
reach silk and velvet, and be ready for my project.
So I started.

But the scheme fell through like scat! The first
corner I turned, I came plump upon one of our slaves,
snooping around with a watchman. I coughed at the
moment, and he gave me a sudden look that bit right
into my marrow. I judge he thought he had heard
that cough before. I turned immediately into a shop
and worked along down the counter, pricing things
and watching out of the corner of my eye. Those
people had stopped, and were talking together and
looking in at the door. I made up my mind to get
out the back way, if there was a back way, and I asked
the shopwoman if I could step out there and look for
the escaped slave, who was believed to be in hiding
back there somewhere, and said I was an officer in
disguise, and my pard was yonder at the door with
one of the murderers in charge, and would she be good
enough to step there and tell him he needn't wait, but
had better go at once to the further end of the back
alley and be ready to head him off when I rousted him
out.

She was blazing with eagerness to see one of those
already celebrated murderers, and she started on the
errand at once. I slipped out the back way, locked
the door behind me, put the key in my pocket and
started off, chuckling to myself and comfortable.

Well, I had gone and spoiled it again, made another
mistake. A double one, in fact. There were plenty
of ways to get rid of that officer by some simple and
plausible device, but no, I must pick out a picturesque
one; it is the crying defect of my character. And
then, I had ordered my procedure upon what the
officer, being human, would NATURALLY do; whereas
when you are least expecting it, a man will now and
then go and do the very thing which it's NOT natural
for him to do. The natural thing for the officer to do,
in this case, was to follow straight on my heels; he
would find a stout oaken door, securely locked, be-
tween him and me; before he could break it down, I
should be far away and engaged in slipping into a suc-
cession of baffling disguises which would soon get me
into a sort of raiment which was a surer protection
from meddling law-dogs in Britain than any amount of
mere innocence and purity of character. But instead
of doing the natural thing, the officer took me at my
word, and followed my instructions. And so, as I
came trotting out of that cul de sac, full of satisfaction
with my own cleverness, he turned the corner and I
walked right into his handcuffs. If I had known it was
a cul de sac -- however, there isn't any excusing a
blunder like that, let it go. Charge it up to profit and
loss.

Of course, I was indignant, and swore I had just
come ashore from a long voyage, and all that sort of
thing -- just to see, you know, if it would deceive that
slave. But it didn't. He knew me. Then I re-
proached him for betraying me. He was more sur-
prised than hurt. He stretched his eyes wide, and
said:

"What, wouldst have me let thee, of all men, escape
and not hang with us, when thou'rt the very CAUSE of
our hanging? Go to!"

"Go to" was their way of saying "I should smile!"
or "I like that!" Queer talkers, those people.

Well, there was a sort of bastard justice in his view
of the case, and so I dropped the matter. When you
can't cure a disaster by argument, what is the use to
argue? It isn't my way. So I only said:

"You're not going to be hanged. None of us are."

Both men laughed, and the slave said:

"Ye have not ranked as a fool -- before. You
might better keep your reputation, seeing the strain
would not be for long."

"It will stand it, I reckon. Before to-morrow we
shall be out of prison, and free to go where we will,
besides."

The witty officer lifted at his left ear with his thumb,
made a rasping noise in his throat, and said:

"Out of prison -- yes -- ye say true. And free
likewise to go where ye will, so ye wander not out of
his grace the Devil's sultry realm."

I kept my temper, and said, indifferently:

"Now I suppose you really think we are going to
hang within a day or two."

"I thought it not many minutes ago, for so the
thing was decided and proclaimed."

"Ah, then you've changed your mind, is that it?"

"Even that. I only THOUGHT, then; I KNOW, now."

I felt sarcastical, so I said:

"Oh, sapient servant of the law, condescend to tell
us, then, what you KNOW."

"That ye will all be hanged TO-DAY, at mid-after-
noon! Oho! that shot hit home! Lean upon me."

The fact is I did need to lean upon somebody. My
knights couldn't arrive in time. They would be as
much as three hours too late. Nothing in the world
could save the King of England; nor me, which was
more important. More important, not merely to me,
but to the nation -- the only nation on earth standing
ready to blossom into civilization. I was sick. I said
no more, there wasn't anything to say. I knew what
the man meant; that if the missing slave was found,
the postponement would be revoked, the execution
take place to-day. Well, the missing slave was found.


CHAPTER XXXVIII.
SIR LAUNCELOT AND KNIGHTS TO THE RESCUE

NEARING four in the afternoon. The scene was
just outside the walls of London. A cool, com-
fortable, superb day, with a brilliant sun; the kind of
day to make one want to live, not die. The multitude
was prodigious and far-reaching; and yet we fifteen
poor devils hadn't a friend in it. There was something
painful in that thought, look at it how you might.
There we sat, on our tall scaffold, the butt of the hate
and mockery of all those enemies. We were being
made a holiday spectacle. They had built a sort of
grand stand for the nobility and gentry, and these were
there in full force, with their ladies. We recognized a
good many of them.

The crowd got a brief and unexpected dash of
diversion out of the king. The moment we were
freed of our bonds he sprang up, in his fantastic rags,
with face bruised out of all recognition, and proclaimed
himself Arthur, King of Britain, and denounced the
awful penalties of treason upon every soul there present
if hair of his sacred head were touched. It startled
and surprised him to hear them break into a vast roar
of laughter. It wounded his dignity, and he locked
himself up in silence. then, although the crowd begged
him to go on, and tried to provoke him to it by cat-
calls, jeers, and shouts of

"Let him speak! The king! The king! his hum-
ble subjects hunger and thirst for words of wisdom out
of the mouth of their master his Serene and Sacred
Raggedness!"

But it went for nothing. He put on all his majesty
and sat under this rain of contempt and insult un-
moved. He certainly was great in his way. Absently,
I had taken off my white bandage and wound it about
my right arm. When the crowd noticed this, they
began upon me. They said:

"Doubtless this sailor-man is his minister -- observe
his costly badge of office!"

I let them go on until they got tired, and then I
said:

"Yes, I am his minister, The Boss; and to-morrow
you will hear that from Camelot which --"

I got no further. They drowned me out with joyous
derision. But presently there was silence; for the
sheriffs of London, in their official robes, with their
subordinates, began to make a stir which indicated
that business was about to begin. In the hush which
followed, our crime was recited, the death warrant
read, then everybody uncovered while a priest uttered
a prayer.

Then a slave was blindfolded; the hangman unslung
his rope. There lay the smooth road below us, we
upon one side of it, the banked multitude wailing its
other side -- a good clear road, and kept free by the
police -- how good it would be to see my five hundred
horsemen come tearing down it! But no, it was out
of the possibilities. I followed its receding thread out
into the distance -- not a horseman on it, or sign of
one.

There was a jerk, and the slave hung dangling;
dangling and hideously squirming, for his limbs were
not tied.

A second rope was unslung, in a moment another
slave was dangling.

In a minute a third slave was struggling in the air.
It was dreadful. I turned away my head a moment,
and when I turned back I missed the king! They
were blindfolding him! I was paralyzed; I couldn't
move, I was choking, my tongue was petrified. They
finished blindfolding him, they led him under the
rope. I couldn't shake off that clinging impotence.
But when I saw them put the noose around his neck,
then everything let go in me and I made a spring
to the rescue -- and as I made it I shot one
more glance abroad -- by George! here they came,
a-tilting! -- five hundred mailed and belted knights on
bicycles!

The grandest sight that ever was seen. Lord, how
the plumes streamed, how the sun flamed and flashed
from the endless procession of webby wheels!

I waved my right arm as Launcelot swept in -- he
recognized my rag -- I tore away noose and bandage,
and shouted:

"On your knees, every rascal of you, and salute the
king! Who fails shall sup in hell to-night!"

I always use that high style when I'm climaxing an
effect. Well, it was noble to see Launcelot and the
boys swarm up onto that scaffold and heave sheriffs
and such overboard. And it was fine to see that
astonished multitude go down on their knees and beg
their lives of the king they had just been deriding and
insulting. And as he stood apart there, receiving this
homage in rags, I thought to myself, well, really there
is something peculiarly grand about the gait and bear-
ing of a king, after all.

I was immensely satisfied. Take the whole situation
all around, it was one of the gaudiest effects I ever
instigated.

And presently up comes Clarence, his own self! and
winks, and says, very modernly:

"Good deal of a surprise, wasn't it? I knew you'd
like it. I've had the boys practicing this long time,
privately; and just hungry for a chance to show off."


CHAPTER XXXIX.
THE YANKEE'S FIGHT WITH THE KNIGHTS

HOME again, at Camelot. A morning or two later
I found the paper, damp from the press, by my
plate at the breakfast table. I turned to the adver-
tising columns, knowing I should find something of
personal interest to me there. It was this:

             DE PAR LE ROI.

   Know that the great lord and illus-
   trious Kni8ht, SIR SAGRAMOR LE
   DESIROUS naving condescended to
   meet the King's Minister, Hank Mor-
    gan, the which is surnamed The Boss,
   for satisfgction of offence anciently given,
   these wilL engage in the lists by
   Camelot about the fourth hour of the
   morning of the sixteenth day of this
   next succeeding month. The battle
   will be a l outrance, sith the said offence
   was of a deadly sort, admitting of no
   comPosition.

             DE PAR LE ROI


Clarence's editorial reference to this affair was to this
effect:

   It will be observed, by a gl7nce at our
   advertising columns, that the commu-
   nity is to be favored with a treat of un-
   usual interest in the tournament line.
   The n ames of the artists are warrant of
   good enterTemment. The box-office
   will be open at noon of the 13th; ad-
   mission 3 cents, reserved seatsh 5; pro-
   ceeds to go to the hospital fund  The
   royal pair and all the Court will be pres-
   ent. With these exceptions, and the
   press and the clergy, the free list is strict-
   ly susPended. Parties are hereby warn-
   ed against buying tickets of speculators;
   they will not be good at the door.
   Everybody knows and likes The Boss,
   everybody knows and likes Sir Sag.;
   come, let us give the lads a good send-
   off. ReMember, the proceeds go to a
   great and free charity, and one whose
   broad begevolence stretches out its help-
   ing hand, warm with the blood of a lov-
   ing heart, to all that suffer, regardless of
   race, creed, condition or color--the
   only charity yet established in the earth
   which has no politico-religious stop-
   cock on its compassion, but says Here
   flows the stream, let ALL come and
   drink! Turn out, all hands! fetch along
   your dou3hnuts and your gum-drops
   and have a good time. Pie for sale on
   the grounds, and rocks to crack it with;
   and ciRcus-lemonade--three drops of
   lime juice to a barrel of water.
   N.B. This is the first tournament
   under the new law, whidh allow each
   combatant to use any weapon he may pre-
   fer. You may want to make a note of that.

Up to the day set, there was no talk in all Britain of
anything but this combat. All other topics sank into
insignificance and passed out of men's thoughts and
interest. It was not because a tournament was a great
matter, it was not because Sir Sagramor had found
the Holy Grail, for he had not, but had failed; it was
not because the second (official) personage in the king-
dom was one of the duellists; no, all these features
were commonplace. Yet there was abundant reason
for the extraordinary interest which this coming fight
was creating. It was born of the fact that all the
nation knew that this was not to be a duel between
mere men, so to speak, but a duel between two mighty
magicians; a duel not of muscle but of mind, not of
human skill but of superhuman art and craft; a final
struggle for supremacy between the two master en-
chanters of the age. It was realized that the most
prodigious achievements of the most renowned knights
could not be worthy of comparison with a spectacle
like this; they could be but child's play, contrasted
with this mysterious and awful battle of the gods.
Yes, all the world knew it was going to be in reality a
duel between Merlin and me, a measuring of his magic
powers against mine. It was known that Merlin had
been busy whole days and nights together, imbuing Sir
Sagramor's arms and armor with supernal powers of
offense and defense, and that he had procured for him
from the spirits of the air a fleecy veil which would
render the wearer invisible to his antagonist while
still visible to other men. Against Sir Sagramor, so
weaponed and protected, a thousand knights could
accomplish nothing; against him no known enchant-
ments could prevail. These facts were sure; regard-
ing them there was no doubt, no reason for doubt.
There was but one question: might there be still other
enchantments, UNKNOWN to Merlin, which could render
Sir Sagramor's veil transparent to me, and make his
enchanted mail vulnerable to my weapons? This was
the one thing to be decided in the lists. Until then
the world must remain in suspense.

So the world thought there was a vast matter at stake
here, and the world was right, but it was not the one
they had in their minds. No, a far vaster one was
upon the cast of this die: THE LIFE OF KNIGHT-ERRANTRY.
I was a champion, it was true, but not the champion
of the frivolous black arts, I was the champion of hard
unsentimental common-sense and reason. I was enter-
ing the lists to either destroy knight-errantry or be its
victim.

Vast as the show-grounds were, there were no vacant
spaces in them outside of the lists, at ten o'clock on
the morning of the 16th. The mammoth grand-stand
was clothed in flags, streamers, and rich tapestries, and
packed with several acres of small-fry tributary kings,
their suites, and the British aristocracy; with our own
royal gang in the chief place, and each and every
individual a flashing prism of gaudy silks and velvets --
well, I never saw anything to begin with it but a fight
between an Upper Mississippi sunset and the aurora
borealis. The huge camp of beflagged and gay-
colored tents at one end of the lists, with a stiff-
standing sentinel at every door and a shining shield
hanging by him for challenge, was another fine sight.
You see, every knight was there who had any ambition
or any caste feeling; for my feeling toward their order
was not much of a secret, and so here was their
chance. If I won my fight with Sir Sagramor, others
would have the right to call me out as long as I might
be willing to respond.

Down at our end there were but two tents; one for
me, and another for my servants. At the appointed
hour the king made a sign, and the heralds, in their
tabards, appeared and made proclamation, naming the
combatants and stating the cause of quarrel. There
was a pause, then a ringing bugle-blast, which was the
signal for us to come forth. All the multitude caught
their breath, and an eager curiosity flashed into every
face.

Out from his tent rode great Sir Sagramor, an im-
posing tower of iron, stately and rigid, his huge spear
standing upright in its socket and grasped in his strong
hand, his grand horse's face and breast cased in steel,
his body clothed in rich trappings that almost dragged
the ground -- oh, a most noble picture. A great shout
went up, of welcome and admiration.

And then out I came. But I didn't get any shout.
There was a wondering and eloquent silence for a mo-
ment, then a great wave of laughter began to sweep
along that human sea, but a warning bugle-blast cut its
career short. I was in the simplest and comfortablest
of gymnast costumes -- flesh-colored tights from neck
to heel, with blue silk puffings about my loins, and
bareheaded. My horse was not above medium size,
but he was alert, slender-limbed, muscled with watch-
springs, and just a greyhound to go. He was a beauty,
glossy as silk, and naked as he was when he was born,
except for bridle and ranger-saddle.

The iron tower and the gorgeous bedquilt came
cumbrously but gracefully pirouetting down the lists,
and we tripped lightly up to meet them. We halted;
the tower saluted, I responded; then we wheeled and
rode side by side to the grand-stand and faced our king
and queen, to whom we made obeisance. The queen
exclaimed:

"Alack, Sir Boss, wilt fight naked, and without
lance or sword or --"

But the king checked her and made her understand,
with a polite phrase or two, that this was none of her
business. The bugles rang again; and we separated
and rode to the ends of the lists, and took position.
Now old Merlin stepped into view and cast a dainty
web of gossamer threads over Sir Sagramor which
turned him into Hamlet's ghost; the king made a
sign, the bugles blew, Sir Sagramor laid his great
lance in rest, and the next moment here he came
thundering down the course with his veil flying out
behind, and I went whistling through the air like an
arrow to meet him -- cocking my ear the while, as if
noting the invisible knight's position and progress by
hearing, not sight. A chorus of encouraging shouts
burst out for him, and one brave voice flung out a
heartening word for me -- said:

"Go it, slim Jim!"

It was an even bet that Clarence had procured that
favor for me -- and furnished the language, too. When
that formidable lance-point was within a yard and a
half of my breast I twitched my horse aside without an
effort, and the big knight swept by, scoring a blank.
I got plenty of applause that time. We turned,
braced up, and down we came again. Another blank
for the knight, a roar of applause for me. This same
thing was repeated once more; and it fetched such a
whirlwind of applause that Sir Sagramor lost his
temper, and at once changed his tactics and set him-
self the task of chasing me down. Why, he hadn't
any show in the world at that; it was a game of tag,
with all the advantage on my side; I whirled out of
his path with ease whenever I chose, and once I
slapped him on the back as I went to the rear. Finally
I took the chase into my own hands; and after that,
turn, or twist, or do what he would, he was never able
to get behind me again; he found himself always in
front at the end of his maneuver. So he gave up that
business and retired to his end of the lists. His temper
was clear gone now, and he forgot himself and flung
an insult at me which disposed of mine. I slipped my
lasso from the horn of my saddle, and grasped the coil
in my right hand. This time you should have seen
him come! -- it was a business trip, sure; by his gait
there was blood in his eye. I was sitting my horse at
ease, and swinging the great loop of my lasso in wide
circles about my head; the moment he was under way,
I started for him; when the space between us had
narrowed to forty feet, I sent the snaky spirals of the
rope a-cleaving through the air, then darted aside and
faced about and brought my trained animal to a halt
with all his feet braced under him for a surge. The
next moment the rope sprang taut and yanked Sir
Sagramor out of the saddle! Great Scott, but there
was a sensation!

Unquestionably, the popular thing in this world is
novelty. These people had never seen anything of
that cowboy business before, and it carried them clear
off their feet with delight. From all around and every-
where, the shout went up:

"Encore! encore!"

I wondered where they got the word, but there was
no time to cipher on philological matters, because the
whole knight-errantry hive was just humming now, and
my prospect for trade couldn't have been better. The
moment my lasso was released and Sir Sagramor had
been assisted to his tent, I hauled in the slack, took
my station and began to swing my loop around my
head again. I was sure to have use for it as soon as
they could elect a successor for Sir Sagramor, and
that couldn't take long where there were so many
hungry candidates. Indeed, they elected one straight
off -- Sir Hervis de Revel.

BZZ! Here he came, like a house afire; I dodged:
he passed like a flash, with my horse-hair coils settling
around his neck; a second or so later, FST! his saddle
was empty.

I got another encore; and another, and another, and
still another. When I had snaked five men out, things
began to look serious to the ironclads, and they
stopped and consulted together. As a result, they de-
cided that it was time to waive etiquette and send their
greatest and best against me. To the astonishment of
that little world, I lassoed Sir Lamorak de Galis, and
after him Sir Galahad. So you see there was simply
nothing to be done now, but play their right bower --
bring out the superbest of the superb, the mightiest of
the mighty, the great Sir Launcelot himself!

A proud moment for me? I should think so.
Yonder was Arthur, King of Britain; yonder was
Guenever; yes, and whole tribes of little provincial
kings and kinglets; and in the tented camp yonder,
renowned knights from many lands; and likewise the
selectest body known to chivalry, the Knights of the
Table Round, the most illustrious in Christendom; and
biggest fact of all, the very sun of their shining system
was yonder couching his lance, the focal point of forty
thousand adoring eyes; and all by myself, here was I
laying for him. Across my mind flitted the dear
image of a certain hello-girl of West Hartford, and I
wished she could see me now. In that moment, down
came the Invincible, with the rush of a whirlwind --
the courtly world rose to its feet and bent forward --
the fateful coils went circling through the air, and
before you could wink I was towing Sir Launcelot
across the field on his back, and kissing my hand to
the storm of waving kerchiefs and the thunder-crash of
applause that greeted me!

Said I to myself, as I coiled my lariat and hung it on
my saddle-horn, and sat there drunk with glory, "The
victory is perfect -- no other will venture against me --
knight-errantry is dead." Now imagine my astonish-
ment -- and everybody else's, too -- to hear the peculiar
bugle-call which announces that another competitor is
about to enter the lists! There was a mystery here; I
couldn't account for this thing. Next, I noticed Mer-
lin gliding away from me; and then I noticed that my
lasso was gone! The old sleight-of-hand expert had
stolen it, sure, and slipped it under his robe.

The bugle blew again. I looked, and down came
Sagramor riding again, with his dust brushed off and
is veil nicely re-arranged. I trotted up to meet him,
and pretended to find him by the sound of his horse's
hoofs. He said:

"Thou'rt quick of ear, but it will not save thee from
this!" and he touched the hilt of his great sword .
"An ye are not able to see it, because of the influence
of the veil, know that it is no cumbrous lance, but a
sword -- and I ween ye will not be able to avoid it."

His visor was up; there was death in his smile. I
should never be able to dodge his sword, that was
plain. Somebody was going to die this time. If he
got the drop on me, I could name the corpse. We
rode forward together, and saluted the royalties. This
time the king was disturbed. He said:

"Where is thy strange weapon?"

"It is stolen, sire."

"Hast another at hand?"

"No, sire, I brought only the one."

Then Merlin mixed in:

"He brought but the one because there was but the
one to bring. There exists none other but that one.
It belongeth to the king of the Demons of the Sea.
This man is a pretender, and ignorant, else he had
known that that weapon can be used in but eight
bouts only, and then it vanisheth away to its home
under the sea."

"Then is he weaponless," said the king. "Sir
Sagramore, ye will grant him leave to borrow."

"And I will lend!" said Sir Launcelot, limping
up. "He is as brave a knight of his hands as any
that be on live, and he shall have mine."

He put his hand on his sword to draw it, but Sir
Sagramor said:

"Stay, it may not be. He shall fight with his own
weapons; it was his privilege to choose them and bring
them. If he has erred, on his head be it."

"Knight!" said the king. "Thou'rt overwrought
with passion; it disorders thy mind. Wouldst kill a
naked man?"

"An he do it, he shall answer it to me," said Sir
Launcelot.

"I will answer it to any he that desireth!" retorted
Sir Sagramor hotly.

Merlin broke in, rubbing his hands and smiling his
lowdownest smile of malicious gratification:

"'Tis well said, right well said! And 'tis enough
of parleying, let my lord the king deliver the battle
signal."

The king had to yield. The bugle made proclama-
tion, and we turned apart and rode to our stations.
There we stood, a hundred yards apart, facing each
other, rigid and motionless, like horsed statues. And
so we remained, in a soundless hush, as much as a full
minute, everybody gazing, nobody stirring. It seemed
as if the king could not take heart to give the signal.
But at last he lifted his hand, the clear note of the
bugle followed, Sir Sagramor's long blade described a
flashing curve in the air, and it was superb to see him
come. I sat still. On he came. I did not move.
People got so excited that they shouted to me:

"Fly, fly! Save thyself! This is murther!"

I never budged so much as an inch till that thunder-
ng apparition had got within fifteen paces of me; then
I snatched a dragoon revolver out of my holster, there
was a flash and a roar, and the revolver was back in
the holster before anybody could tell what had hap-
pened.

Here was a riderless horse plunging by, and yonder
lay Sir Sagramor, stone dead.

The people that ran to him were stricken dumb to
find that the life was actually gone out of the man and
no reason for it visible, no hurt upon his body, nothing
like a wound. There was a hole through the breast of
his chain-mail, but they attached no importance to a
little thing like that; and as a bullet wound there pro-
duces but little blood, none came in sight because of
the clothing and swaddlings under the armor. The
body was dragged over to let the king and the swells
look down upon it. They were stupefied with aston-
ishment naturally. I was requested to come and ex-
plain the miracle. But I remained in my tracks, like
a statue, and said:

"If it is a command, I will come, but my lord the
king knows that I am where the laws of combat require
me to remain while any desire to come against me."

I waited. Nobody challenged. Then I said:

"If there are any who doubt that this field is well
and fairly won, I do not wait for them to challenge
me, I challenge them."

"It is a gallant offer," said the king, "and well be-
seems you. Whom will you name first?"

"I name none, I challenge all! Here I stand, and
dare the chivalry of England to come against me -- not
by individuals, but in mass!"

"What!" shouted a score of knights.

"You have heard the challenge. Take it, or I pro-
claim you recreant knights and vanquished, every
one!"

It was a "bluff" you know. At such a time it is
sound judgment to put on a bold face and play your
hand for a hundred times what it is worth; forty-nine
times out of fifty nobody dares to "call," and you
rake in the chips. But just this once -- well, things
looked squally! In just no time, five hundred knights
were scrambling into their saddles, and before you
could wink a widely scattering drove were under way
and clattering down upon me. I snatched both revol-
vers from the holsters and began to measure distances
and calculate chances.

Bang! One saddle empty. Bang! another one.
Bang -- bang, and I bagged two. Well, it was nip and
tuck with us, and I knew it. If I spent the eleventh
shot without convincing these people, the twelfth man
would kill me, sure. And so I never did feel so happy
as I did when my ninth downed its man and I detected
the wavering in the crowd which is premonitory of
panic. An instant lost now could knock out my last
chance. But I didn't lose it. I raised both revolvers
and pointed them -- the halted host stood their ground
just about one good square moment, then broke and
fled.

The day was mine. Knight-errantry was a doomed
institution. The march of civilization was begun.
How did I feel? Ah, you never could imagine it.

And Brer Merlin? His stock was flat again. Some-
how, every time the magic of fol-de-rol tried conclu-
sions with the magic of science, the magic of fol-de-rol
got left.


CHAPTER XL.
THREE YEARS LATER

WHEN I broke the back of knight-errantry that
time, I no longer felt obliged to work in secret.
So, the very next day I exposed my hidden schools,
my mines, and my vast system of clandestine factories
and workshops to an astonished world. That is to
say, I exposed the nineteenth century to the inspec-
tion of the sixth.

Well, it is always a good plan to follow up an
advantage promptly. The knights were temporarily
down, but if I would keep them so I must just simply
paralyze them -- nothing short of that would answer.
You see, I was "bluffing" that last time in the field;
it would be natural for them to work around to that
conclusion, if I gave them a chance. So I must not
give them time; and I didn't.

I renewed my challenge, engraved it on brass, posted
it up where any priest could read it to them, and also
kept it standing in the advertising columns of the
paper.

I not only renewed it, but added to its proportions.
I said, name the day, and I would take fifty assistants
and stand up AGAINST THE MASSED CHIVALRY OF THE WHOLE
EARTH AND DESTROY IT.

I was not bluffing this time. I meant what I said;
I could do what I promised. There wasn't any way
to misunderstand the language of that challenge.
Even the dullest of the chivalry perceived that this
was a plain case of "put up, or shut up." They
were wise and did the latter. In all the next three
years they gave me no trouble worth mentioning.

Consider the three years sped. Now look around
on England. A happy and prosperous country, and
strangely altered. Schools everywhere, and several
colleges; a number of pretty good newspapers. Even
authorship was taking a start; Sir Dinadan the Humor-
ist was first in the field, with a volume of gray-headed
jokes which I had been familiar with during thirteen
centuries. If he had left out that old rancid one about
the lecturer I wouldn't have said anything; but I
couldn't stand that one. I suppressed the book and
hanged the author.

Slavery was dead and gone; all men were equal
before the law; taxation had been equalized. The
telegraph, the telephone, the phonograph, the type-
writer, the sewing-machine, and all the thousand will-
ing and handy servants of steam and electricity were
working their way into favor. We had a steamboat or
two on the Thames, we had steam warships, and the
beginnings of a steam commercial marine; I was getting
ready to send out an expedition to discover America.

We were building several lines of railway, and our
line from Camelot to London was already finished and
in operation. I was shrewd enough to make all offices
connected with the passenger service places of high
and distinguished honor. My idea was to attract the
chivalry and nobility, and make them useful and keep
them out of mischief. The plan worked very well, the
competition for the places was hot. The conductor of
the 4.33 express was a duke; there wasn't a passenger
conductor on the line below the degree of earl. They
were good men, every one, but they had two defects
which I couldn't cure, and so had to wink at: they
wouldn't lay aside their armor, and they would "knock
down" fare -- I mean rob the company.

There was hardly a knight in all the land who wasn't
in some useful employment. They were going from
end to end of the country in all manner of useful
missionary capacities; their penchant for wandering,
and their experience in it, made them altogether the
most effective spreaders of civilization we had. They
went clothed in steel and equipped with sword and
lance and battle-axe, and if they couldn't persuade a
person to try a sewing-machine on the installment
plan, or a melodeon, or a barbed-wire fence, or a
prohibition journal, or any of the other thousand and
one things they canvassed for, they removed him and
passed on.

I was very happy. Things were working steadily
toward a secretly longed-for point. You see, I had
two schemes in my head which were the vastest of all
my projects. The one was to overthrow the Catholic
Church and set up the Protestant faith on its ruins --
not as an Established Church, but a go-as-you-please
one; and the other project was to get a decree issued
by and by, commanding that upon Arthur's death
unlimited suffrage should be introduced, and given to
men and women alike -- at any rate to all men, wise
or unwise, and to all mothers who at middle age should
be found to know nearly as much as their sons at
twenty-one. Arthur was good for thirty years yet, he
being about my own age -- that is to say, forty -- and
I believed that in that time I could easily have the
active part of the population of that day ready and
eager for an event which should be the first of its kind
in the history of the world -- a rounded and complete
governmental revolution without bloodshed. The re-
sult to be a republic. Well, I may as well confess,
though I do feel ashamed when I think of it: I was
beginning to have a base hankering to be its first presi-
dent myself. Yes, there was more or less human
nature in me; I found that out.

Clarence was with me as concerned the revolution,
but in a modified way. His idea was a republic, with-
out privileged orders, but with a hereditary royal
family at the head of it instead of an elective chief
magistrate. He believed that no nation that had ever
known the joy of worshiping a royal family could
ever be robbed of it and not fade away and die of
melancholy. I urged that kings were dangerous. He
said, then have cats. He was sure that a royal family
of cats would answer every purpose. They would be
as useful as any other royal family, they would know
as much, they would have the same virtues and the
same treacheries, the same disposition to get up shin-
dies with other royal cats, they would be laughably
vain and absurd and never know it, they would be
wholly inexpensive; finally, they would have as sound
a divine right as any other royal house, and "Tom
VII., or Tom XI., or Tom XIV. by the grace of God
King," would sound as well as it would when applied
to the ordinary royal tomcat with tights on. "And as
a rule," said he, in his neat modern English, "the
character of these cats would be considerably above
the character of the average king, and this would be
an immense moral advantage to the nation, for the
reason that a nation always models its morals after its
monarch's. The worship of royalty being founded in
unreason, these graceful and harmless cats would easily
become as sacred as any other royalties, and indeed
more so, because it would presently be noticed that
they hanged nobody, beheaded nobody, imprisoned
nobody, inflicted no cruelties or injustices of any sort,
and so must be worthy of a deeper love and reverence
than the customary human king, and would certainly
get it. The eyes of the whole harried world would
soon be fixed upon this humane and gentle system,
and royal butchers would presently begin to disappear;
their subjects would fill the vacancies with catlings
from our own royal house; we should become a fac-
tory; we should supply the thrones of the world;
within forty years all Europe would be governed by
cats, and we should furnish the cats. The reign of
universal peace would begin then, to end no more
forever...... Me-e-e-yow-ow-ow-ow -- fzt! -- wow!"

Hang him, I supposed he was in earnest, and was
beginning to be persuaded by him, until he exploded
that cat-howl and startled me almost out of my clothes.
But he never could be in earnest. He didn't know
what it was. He had pictured a distinct and perfectly
rational and feasible improvement upon constitutional
monarchy, but he was too feather-headed to know it,
or care anything about it, either. I was going to give
him a scolding, but Sandy came flying in at that
moment, wild with terror, and so choked with sobs that
for a minute she could not get her voice. I ran and
took her in my arms, and lavished caresses upon her
and said, beseechingly:

"Speak, darling, speak! What is it?"

Her head fell limp upon my bosom, and she gasped,
almost inaudibly:

"HELLO-CENTRAL!"

"Quick!" I shouted to Clarence; "telephone the
king's homeopath to come!"

In two minutes I was kneeling by the child's crib,
and Sandy was dispatching servants here, there, and
everywhere, all over the palace. I took in the situa-
tion almost at a glance -- membranous croup! I bent
down and whispered:

"Wake up, sweetheart! Hello-Central"

She opened her soft eyes languidly, and made out
to say:

"Papa."

That was a comfort. She was far from dead yet. I
sent for preparations of sulphur, I rousted out the
croup-kettle myself; for I don't sit down and wait for
doctors when Sandy or the child is sick. I knew how
to nurse both of them, and had had experience. This
little chap had lived in my arms a good part of its
small life, and often I could soothe away its troubles
and get it to laugh through the tear-dews on its eye-
lashes when even its mother couldn't.

Sir Launcelot, in his richest armor, came striding
along the great hall now on his way to the stock-
board; he was president of the stock-board, and occu-
pied the Siege Perilous, which he had bought of Sir
Galahad; for the stock-board consisted of the Knights
of the Round Table, and they used the Round Table
for business purposes now. Seats at it were worth --
well, you would never believe the figure, so it is no
use to state it. Sir Launcelot was a bear, and he had
put up a corner in one of the new lines, and was just
getting ready to squeeze the shorts to-day; but what
of that? He was the same old Launcelot, and when
he glanced in as he was passing the door and found out
that his pet was sick, that was enough for him; bulls
and bears might fight it out their own way for all him,
he would come right in here and stand by little Hello-
Central for all he was worth. And that was what he
did. He shied his helmet into the corner, and in half
a minute he had a new wick in the alcohol lamp and
was firing up on the croup-kettle. By this time Sandy
had built a blanket canopy over the crib, and every-
thing was ready.

Sir Launcelot got up steam, he and I loaded up the
kettle with unslaked lime and carbolic acid, with a
touch of lactic acid added thereto, then filled the thing
up with water and inserted the steam-spout under the
canopy. Everything was ship-shape now, and we sat
down on either side of the crib to stand our watch.
Sandy was so grateful and so comforted that she
charged a couple of church-wardens with willow-bark
and sumach-tobacco for us, and told us to smoke as
much as we pleased, it couldn't get under the canopy,
and she was used to smoke, being the first lady in the
land who had ever seen a cloud blown. Well, there
couldn't be a more contented or comfortable sight
than Sir Launcelot in his noble armor sitting in gracious
serenity at the end of a yard of snowy church-warden.
He was a beautiful man, a lovely man, and was just
intended to make a wife and children happy. But, of
course Guenever -- however, it's no use to cry over
what's done and can't be helped.

Well, he stood watch-and-watch with me, right
straight through, for three days and nights, till the
child was out of danger; then he took her up in his
great arms and kissed her, with his plumes falling
about her golden head, then laid her softly in Sandy's
lap again and took his stately way down the vast hall,
between the ranks of admiring men-at-arms and menials,
and so disappeared. And no instinct warned me that
I should never look upon him again in this world!
Lord, what a world of heart-break it is.

The doctors said we must take the child away, if we
would coax her back to health and strength again.
And she must have sea-air. So we took a man-of-
war, and a suite of two hundred and sixty persons, and
went cruising about, and after a fortnight of this we
stepped ashore on the French coast, and the doctors
thought it would be a good idea to make something of
a stay there. The little king of that region offered us
his hospitalities, and we were glad to accept. If he
had had as many conveniences as he lacked, we should
have been plenty comfortable enough; even as it was,
we made out very well, in his queer old castle, by the
help of comforts and luxuries from the ship.

At the end of a month I sent the vessel home for
fresh supplies, and for news. We expected her back
in three or four days. She would bring me, along
with other news, the result of a certain experiment
which I had been starting. It was a project of mine
to replace the tournament with something which might
furnish an escape for the extra steam of the chivalry,
keep those bucks entertained and out of mischief, and
at the same time preserve the best thing in them,
which was their hardy spirit of emulation. I had had
a choice band of them in private training for some time,
and the date was now arriving for their first public
effort.

This experiment was baseball. In order to give the
thing vogue from the start, and place it out of the
reach of criticism, I chose my nines by rank, not
capacity. There wasn't a knight in either team who
wasn't a sceptered sovereign. As for material of this
sort, there was a glut of it always around Arthur.
You couldn't throw a brick in any direction and not
cripple a king. Of course, I couldn't get these people
to leave off their armor; they wouldn't do that when
they bathed. They consented to differentiate the armor
so that a body could tell one team from the other, but
that was the most they would do. So, one of the
teams wore chain-mail ulsters, and the other wore plate-
armor made of my new Bessemer steel. Their prac-
tice in the field was the most fantastic thing I ever saw.
Being ball-proof, they never skipped out of the way,
but stood still and took the result; when a Bessemer
was at the bat and a ball hit him, it would bound a
hundred and fifty yards sometimes. And when a man
was running, and threw himself on his stomach to slide
to his base, it was like an iron-clad coming into port.
At first I appointed men of no rank to act as umpires,
but I had to discontinue that. These people were no
easier to please than other nines. The umpire's first
decision was usually his last; they broke him in two
with a bat, and his friends toted him home on a
shutter. When it was noticed that no umpire ever
survived a game, umpiring got to be unpopular. So
I was obliged to appoint somebody whose rank and
lofty position under the government would protect
him.

Here are the names of the nines:

     BESSEMERS                   ULSTERS

   KING ARTHUR.                EMPEROR LUCIUS.
   KING LOT OF LOTHIAN.        KING LOGRIS.
   KING OF NORTHGALIS.         KING MARHALT OF IRELAND.
   KING MARSIL.                KING MORGANORE.
   KING OF LITTLE BRITAIN.     KING MARK OF CORNWALL.
   KING LABOR.                 KING NENTRES OF GARLOT.
   KING PELLAM OF LISTENGESE.  KING MELIODAS OF LIONES.
   KING BAGDEMAGUS.            KING OF THE LAKE.
   KING TOLLEME LA FEINTES.    THE SOWDAN OF SYRIA.

                  Umpire -- CLARENCE.

The first public game would certainly draw fifty
thousand people; and for solid fun would be worth
going around the world to see. Everything would be
favorable; it was balmy and beautiful spring weather
now, and Nature was all tailored out in her new clothes.


CHAPTER XLI.
THE INTERDICT

HOWEVER, my attention was suddenly snatched
from such matters; our child began to lose
ground again, and we had to go to sitting up with her,
her case became so serious. We couldn't bear to
allow anybody to help in this service, so we two stood
watch-and-watch, day in and day out. Ah, Sandy,
what a right heart she had, how simple, and genuine,
and good she was! She was a flawless wife and
mother; and yet I had married her for no other par-
ticular reasons, except that by the customs of chivalry
she was my property until some knight should win her
from me in the field. She had hunted Britain over for
me; had found me at the hanging-bout outside of
London, and had straightway resumed her old place at
my side in the placidest way and as of right. I was a
New Englander, and in my opinion this sort of partner-
ship would compromise her, sooner or later. She
couldn't see how, but I cut argument short and we
had a wedding.

Now I didn't know I was drawing a prize, yet that
was what I did draw. Within the twelvemonth I be-
came her worshiper; and ours was the dearest and
perfectest comradeship that ever was. People talk
about beautiful friendships between two persons of the
same sex. What is the best of that sort, as compared
with the friendship of man and wife, where the best
impulses and highest ideals of both are the same?
There is no place for comparison between the two
friendships; the one is earthly, the other divine.

In my dreams, along at first, I still wandered thirteen
centuries away, and my unsatisfied spirit went calling
and harking all up and down the unreplying vacancies
of a vanished world. Many a time Sandy heard that
imploring cry come from my lips in my sleep. With
a grand magnanimity she saddled that cry of mine
upon our child, conceiving it to be the name of some
lost darling of mine. It touched me to tears, and it
also nearly knocked me off my feet, too, when she
smiled up in my face for an earned reward, and played
her quaint and pretty surprise upon me:

"The name of one who was dear to thee is here
preserved, here made holy, and the music of it will
abide alway in our ears. Now thou'lt kiss me, as
knowing the name I have given the child."

But I didn't know it, all the same. I hadn't an
idea in the world; but it would have been cruel to
confess it and spoil her pretty game; so I never let on,
but said:

"Yes, I know, sweetheart -- how dear and good it
is of you, too! But I want to hear these lips of yours,
which are also mine, utter it first -- then its music will
be perfect."

Pleased to the marrow, she murmured:

"HELLO-CENTRAL!"

I didn't laugh -- I am always thankful for that -- but
the strain ruptured every cartilage in me, and for weeks
afterward I could hear my bones clack when I walked.
She never found out her mistake. The first time she
heard that form of salute used at the telephone she was
surprised, and not pleased; but I told her I had given
order for it: that henceforth and forever the tele-
phone must always be invoked with that reverent for-
mality, in perpetual honor and remembrance of my
lost friend and her small namesake. This was not
true. But it answered.

Well, during two weeks and a half we watched by
the crib, and in our deep solicitude we were uncon-
scious of any world outside of that sick-room. Then
our reward came: the center of the universe turned the
corner and began to mend. Grateful? It isn't the
term. There ISN'T any term for it. You know that
yourself, if you've watched your child through the
Valley of the Shadow and seen it come back to life
and sweep night out of the earth with one all-illumi-
nating smile that you could cover with your hand.

Why, we were back in this world in one instant!
Then we looked the same startled thought into each
other's eyes at the same moment; more than two
weeks gone, and that ship not back yet!

In another minute I appeared in the presence of my
train. They had been steeped in troubled bodings all
this time -- their faces showed it. I called an escort
and we galloped five miles to a hilltop overlooking the
sea. Where was my great commerce that so lately
had made these glistening expanses populous and
beautiful with its white-winged flocks? Vanished,
every one! Not a sail, from verge to verge, not a
smoke-bank -- just a dead and empty solitude, in place
of all that brisk and breezy life.

I went swiftly back, saying not a word to anybody.
I told Sandy this ghastly news. We could imagine no
explanation that would begin to explain. Had there
been an invasion? an earthquake? a pestilence? Had
the nation been swept out of existence? But guessing
was profitless. I must go -- at once. I borrowed the
king's navy -- a "ship" no bigger than a steam
launch -- and was soon ready.

The parting -- ah, yes, that was hard. As I was
devouring the child with last kisses, it brisked up and
jabbered out its vocabulary! -- the first time in more
than two weeks, and it made fools of us for joy. The
darling mispronunciations of childhood! -- dear me,
there's no music that can touch it; and how one
grieves when it wastes away and dissolves into correct-
ness, knowing it will never visit his bereaved ear again.
Well, how good it was to be able to carry that gracious
memory away with me!

I approached England the next morning, with the
wide highway of salt water all to myself. There were
ships in the harbor, at Dover, but they were naked as
to sails, and there was no sign of life about them. It
was Sunday; yet at Canterbury the streets were
empty; strangest of all, there was not even a priest
in sight, and no stroke of a bell fell upon my ear.
The mournfulness of death was everywhere. I couldn't
understand it. At last, in the further edge of that
town I saw a small funeral procession -- just a family
and a few friends following a coffin -- no priest; a
funeral without bell, book, or candle; there was a
church there close at hand, but they passed it by
weeping, and did not enter it; I glanced up at the
belfry, and there hung the bell, shrouded in black,
and its tongue tied back. Now I knew! Now I
understood the stupendous calamity that had overtaken
England. Invasion? Invasion is a triviality to it. It
was the INTERDICT!

I asked no questions; I didn't need to ask any.
The Church had struck; the thing for me to do was
to get into a disguise, and go warily. One of my
servants gave me a suit of clothes, and when we were
safe beyond the town I put them on, and from that
time I traveled alone; I could not risk the embarrass-
ment of company.

A miserable journey. A desolate silence everywhere.
Even in London itself. Traffic had ceased; men did
not talk or laugh, or go in groups, or even in couples;
they moved aimlessly about, each man by himself,
with his head down, and woe and terror at his heart.
The Tower showed recent war-scars. Verily, much
had been happening.

Of course, I meant to take the train for Camelot.
Train! Why, the station was as vacant as a cavern.
I moved on. The journey to Camelot was a repetition
of what I had already seen. The Monday and the
Tuesday differed in no way from the Sunday. I
arrived far in the night. From being the best electric-
lighted town in the kingdom and the most like a
recumbent sun of anything you ever saw, it was be-
come simply a blot -- a blot upon darkness -- that is
to say, it was darker and solider than the rest of the
darkness, and so you could see it a little better; it
made me feel as if maybe it was symbolical -- a sort of
sign that the Church was going to KEEP the upper hand
now, and snuff out all my beautiful civilization just like
that. I found no life stirring in the somber streets. I
groped my way with a heavy heart. The vast castle
loomed black upon the hilltop, not a spark visible
about it. The drawbridge was down, the great gate
stood wide, I entered without challenge, my own heels
making the only sound I heard -- and it was sepulchral
enough, in those huge vacant courts.


CHAPTER XLII.
WAR!

I FOUND Clarence alone in his quarters, drowned in
melancholy; and in place of the electric light, he
had reinstituted the ancient rag-lamp, and sat there in
a grisly twilight with all curtains drawn tight. He
sprang up and rushed for me eagerly, saying:

"Oh, it's worth a billion milrays to look upon a
live person again!"

He knew me as easily as if I hadn't been disguised
at all. Which frightened me; one may easily believe
that.

"Quick, now, tell me the meaning of this fearful
disaster," I said. "How did it come about?"

"Well, if there hadn't been any Queen Guenever, it
wouldn't have come so early; but it would have come,
anyway. It would have come on your own account
by and by; by luck, it happened to come on the
queen's."

"AND Sir Launcelot's?"

"Just so."

"Give me the details."

"I reckon you will grant that during some years
there has been only one pair of eyes in these kingdoms
that has not been looking steadily askance at the queen
and Sir Launcelot --"

"Yes, King Arthur's."

"-- and only one heart that was without suspicion --"

"Yes -- the king's; a heart that isn't capable of
thinking evil of a friend."

"Well, the king might have gone on, still happy
and unsuspecting, to the end of his days, but for one
of your modern improvements -- the stock-board.
When you left, three miles of the London, Canterbury
and Dover were ready for the rails, and also ready and
ripe for manipulation in the stock-market. It was
wildcat, and everybody knew it. The stock was for
sale at a give-away. What does Sir Launcelot do,
but --"

"Yes, I know; he quietly picked up nearly all of it
for a song; then he bought about twice as much more,
deliverable upon call; and he was about to call when I
left."

"Very well, he did call. The boys couldn't de-
liver. Oh, he had them -- and he just settled his grip
and squeezed them. They were laughing in their
sleeves over their smartness in selling stock to him at
15 and 16 and along there that wasn't worth 10.
Well, when they had laughed long enough on that
side of their mouths, they rested-up that side by shift-
ing the laugh to the other side. That was when they
compromised with the Invincible at 283!"

"Good land!"

"He skinned them alive, and they deserved it --
anyway, the whole kingdom rejoiced. Well, among
the flayed were Sir Agravaine and Sir Mordred,
nephews to the king. End of the first act. Act
second, scene first, an apartment in Carlisle castle,
where the court had gone for a few days' hunting.
Persons present, the whole tribe of the king's nephews.
Mordred and Agravaine propose to call the guileless
Arthur's attention to Guenever and Sir Launcelot. Sir
Gawaine, Sir Gareth, and Sir Gaheris will have nothing
to do with it. A dispute ensues, with loud talk; in
the midst of it enter the king. Mordred and Agravaine
spring their devastating tale upon him. TABLEAU. A
trap is laid for Launcelot, by the king's command, and
Sir Launcelot walks into it. He made it sufficiently
uncomfortable for the ambushed witnesses -- to wit,
Mordred, Agravaine, and twelve knights of lesser rank,
for he killed every one of them but Mordred; but of
course that couldn't straighten matters between Launce-
lot and the king, and didn't."

"Oh, dear, only one thing could result -- I see that.
War, and the knights of the realm divided into a king's
party and a Sir Launcelot's party."

"Yes -- that was the way of it. The king sent the
queen to the stake, proposing to purify her with fire.
Launcelot and his knights rescued her, and in doing it
slew certain good old friends of yours and mine -- in
fact, some of the best we ever had; to wit, Sir Belias le
Orgulous, Sir Segwarides, Sir Griflet le Fils de Dieu,
Sir Brandiles, Sir Aglovale --"

"Oh, you tear out my heartstrings."

"-- wait, I'm not done yet -- Sir Tor, Sir Gauter,
Sir Gillimer --"

"The very best man in my subordinate nine.
What a handy right-fielder he was!"

"-- Sir Reynold's three brothers, Sir Damus, Sir
Priamus, Sir Kay the Stranger --"

"My peerless short-stop! I've seen him catch a
daisy-cutter in his teeth. Come, I can't stand this!"

"-- Sir Driant, Sir Lambegus, Sir Herminde, Sir
Pertilope, Sir Perimones, and -- whom do you think?"

"Rush! Go on."

"Sir Gaheris, and Sir Gareth -- both!"

"Oh, incredible! Their love for Launcelot was in-
destructible."

"Well, it was an accident. They were simply on-
lookers; they were unarmed, and were merely there to
witness the queen's punishment. Sir Launcelot smote
down whoever came in the way of his blind fury, and
he killed these without noticing who they were. Here
is an instantaneous photograph one of our boys got of
the battle; it's for sale on every news-stand. There
-- the figures nearest the queen are Sir Launcelot with
his sword up, and Sir Gareth gasping his latest breath.
You can catch the agony in the queen's face through
the curling smoke. It's a rattling battle-picture."

"Indeed, it is. We must take good care of it; its
historical value is incalculable. Go on."

"Well, the rest of the tale is just war, pure and
simple. Launcelot retreated to his town and castle of
Joyous Gard, and gathered there a great following of
knights. The king, with a great host, went there, and
there was desperate fighting during several days, and,
as a result, all the plain around was paved with corpses
and cast-iron. Then the Church patched up a peace
between Arthur and Launcelot and the queen and
everybody -- everybody but Sir Gawaine. He was
bitter about the slaying of his brothers, Gareth and
Gaheris, and would not be appeased. He notified
Launcelot to get him thence, and make swift prepara-
tion, and look to be soon attacked. So Launcelot
sailed to his Duchy of Guienne with his following, and
Gawaine soon followed with an army, and he beguiled
Arthur to go with him. Arthur left the kingdom in
Sir Mordred's hands until you should return --"

"Ah -- a king's customary wisdom!"

"Yes. Sir Mordred set himself at once to work to
make his kingship permanent. He was going to marry
Guenever, as a first move; but she fled and shut her-
self up in the Tower of London. Mordred attacked;
the Bishop of Canterbury dropped down on him with
the Interdict. The king returned; Mordred fought
him at Dover, at Canterbury, and again at Barham
Down. Then there was talk of peace and a composi-
tion. Terms, Mordred to have Cornwall and Kent
during Arthur's life, and the whole kingdom after-
ward."

"Well, upon my word! My dream of a republic to
BE a dream, and so remain."

"Yes. The two armies lay near Salisbury. Ga-
waine -- Gawaine's head is at Dover Castle, he fell in
the fight there -- Gawaine appeared to Arthur in a
dream, at least his ghost did, and warned him to re-
frain from conflict for a month, let the delay cost what
it might. But battle was precipitated by an accident.
Arthur had given order that if a sword was raised
during the consultation over the proposed treaty with
Mordred, sound the trumpet and fall on! for he had
no confidence in Mordred. Mordred had given a
similar order to HIS people. Well, by and by an
adder bit a knight's heel; the knight forgot all about
the order, and made a slash at the adder with his
sword. Inside of half a minute those two prodigious
hosts came together with a crash! They butchered
away all day. Then the king -- however, we have
started something fresh since you left -- our paper
has."

"No? What is that?"

"War correspondence!"

"Why, that's good."

"Yes, the paper was booming right along, for the
Interdict made no impression, got no grip, while the
war lasted. I had war correspondents with both
armies. I will finish that battle by reading you what
one of the boys says:

   Then the king looked about him, and then was he
   ware of all his host and of all his good knights
   were left no more on live but two knights, that
   was Sir Lucan de Butlere, and his brother Sir
   Bedivere: and they were full sore wounded. Jesu
   mercy, said the king, where are all my noble
   knights becomen? Alas that ever I should see this
   doleful day. For now, said Arthur, I am come to
   mine end. But would to God that I wist where were
   that traitor Sir Mordred, that hath caused all
   this mischief. Then was King Arthur ware where Sir
   Mordred leaned upon his sword among a great heap
   of dead men. Now give me my spear, said Arthur
   unto Sir Lucan, for yonder I have espied the
   traitor that all this woe hath wrought. Sir, let
   him be, said Sir Lucan, for he is unhappy; and if
   ye pass this unhappy day, ye shall be right well
   revenged upon him. Good lord, remember ye of your
   night's dream, and what the spirit of Sir Gawaine
   told you this night, yet God of his great goodness
   hath preserved you hitherto. Therefore, for God's
   sake, my lord, leave off by this. For blessed be
   God ye have won the field: for here we be three
   on live, and with Sir Mordred is none on live.
   And if ye leave off now, this wicked day of
   destiny is past. Tide me death, betide me life,
   saith the king, now I see him yonder alone, he
   shall never escape mine hands, for at a better
   avail shall I never have him. God speed you well,
   said Sir Bedivere. Then the king gat his spear
   in both his hands, and ran toward Sir Mordred
   crying, Traitor, now is thy death day come. And
   when Sir Mordred heard Sir Arthur, he ran until
   him with his sword drawn in his hand. And then
   King Arthur smote Sir Mordred under the shield,
   with a foin of his spear throughout the body more
   than a fathom. And when Sir Mordred felt that he
   had his death's wound, he thrust himself, with
   the might that he had, up to the butt of King
   Arthur's spear. And right so he smote his father
   Arthur with his sword holden in both his hands,
   on the side of the head, that the sword pierced
   the helmet and the brain-pan, and therewithal
   Sir Mordred fell stark dead to the earth. And
   the noble Arthur fell in a swoon to the earth,
   and there he swooned oft-times

"That is a good piece of war correspondence,
Clarence; you are a first-rate newspaper man. Well
-- is the king all right?" Did he get well?"

"Poor soul, no. He is dead."

I was utterly stunned; it had not seemed to me that
any wound could be mortal to him.

"And the queen, Clarence?"

"She is a nun, in Almesbury."

"What changes! and in such a short while. It is
inconceivable. What next, I wonder?"

"I can tell you what next."

"Well?"

"Stake our lives and stand by them!"

"What do you mean by that?"

"The Church is master now. The Interdict in-
cluded you with Mordred; it is not to be removed
while you remain alive. The clans are gathering. The
Church has gathered all the knights that are left alive,
and as soon as you are discovered we shall have busi-
ness on our hands."

"Stuff! With our deadly scientific war-material;
with our hosts of trained --"

"Save your breath -- we haven't sixty faithful left!"

"What are you saying? Our schools, our colleges,
our vast workshops, our --"

"When those knights come, those establishments
will empty themselves and go over to the enemy. Did
you think you had educated the superstition out of
those people?"

"I certainly did think it."

"Well, then, you may unthink it. They stood
every strain easily -- until the Interdict. Since then,
they merely put on a bold outside -- at heart they are
quaking. Make up your mind to it -- when the armies
come, the mask will fall."

"It's hard news. We are lost. They will turn our
own science against us."

"No they won't."

"Why?"

"Because I and a handful of the faithful have
blocked that game. I'll tell you what I've done, and
what moved me to it. Smart as you are, the Church
was smarter. It was the Church that sent you cruising
-- through her servants, the doctors."

"Clarence!"

"It is the truth. I know it. Every officer of your
ship was the Church's picked servant, and so was every
man of the crew."

"Oh, come!"

"It is just as I tell you. I did not find out these
things at once, but I found them out finally. Did you
send me verbal information, by the commander of the
ship, to the effect that upon his return to you, with
supplies, you were going to leave Cadiz --"

"Cadiz! I haven't been at Cadiz at all!"

"-- going to leave Cadiz and cruise in distant seas
indefinitely, for the health of your family? Did you
send me that word?"

"Of course not. I would have written, wouldn't
I?"

"Naturally. I was troubled and suspicious. When
the commander sailed again I managed to ship a spy
with him. I have never heard of vessel or spy since.
I gave myself two weeks to hear from you in. Then I
resolved to send a ship to Cadiz. There was a reason
why I didn't."

"What was that?"

"Our navy had suddenly and mysteriously disap-
peared! Also, as suddenly and as mysteriously, the
railway and telegraph and telephone service ceased,
the men all deserted, poles were cut down, the Church
laid a ban upon the electric light! I had to be up
and doing -- and straight off. Your life was safe --
nobody in these kingdoms but Merlin would venture to
touch such a magician as you without ten thousand
men at his back -- I had nothing to think of but how
to put preparations in the best trim against your
coming. I felt safe myself -- nobody would be anxious
to touch a pet of yours. So this is what I did. From
our various works I selected all the men -- boys I
mean -- whose faithfulness under whatsoever pressure
I could swear to, and I called them together secretly
and gave them their instructions. There are fifty-two
of them; none younger than fourteen, and none above
seventeen years old."

"Why did you select boys?"

"Because all the others were born in an atmosphere
of superstition and reared in it. It is in their blood
and bones. We imagined we had educated it out of
them; they thought so, too; the Interdict woke them
up like a thunderclap! It revealed them to themselves,
and it revealed them to me, too. With boys it was
different. Such as have been under our training from
seven to ten years have had no acquaintance with the
Church's terrors, and it was among these that I found
my fifty-two. As a next move, I paid a private visit
to that old cave of Merlin's -- not the small one -- the
big one --"

"Yes, the one where we secretly established our first
great electric plant when I was projecting a miracle."

"Just so. And as that miracle hadn't become
necessary then, I thought it might be a good idea to
utilize the plant now. I've provisioned the cave for a
siege --"

"A good idea, a first-rate idea."

"I think so. I placed four of my boys there as a
guard -- inside, and out of sight. Nobody was to be
hurt -- while outside; but any attempt to enter -- well,
we said just let anybody try it! Then I went out into
the hills and uncovered and cut the secret wires which
connected your bedroom with the wires that go to the
dynamite deposits under all our vast factories, mills,
workshops, magazines, etc., and about midnight I and
my boys turned out and connected that wire with the
cave, and nobody but you and I suspects where the
other end of it goes to. We laid it under ground, of
course, and it was all finished in a couple of hours or
so. We sha'n't have to leave our fortress now when
we want to blow up our civilization."

"It was the right move -- and the natural one;
military necessity, in the changed condition of things.
Well, what changes HAVE come! We expected to be
besieged in the palace some time or other, but -- how-
ever, go on."

"Next, we built a wire fence."

"Wire fence?"

"Yes. You dropped the hint of it yourself, two or
three years ago."

"Oh, I remember -- the time the Church tried her
strength against us the first time, and presently thought
it wise to wait for a hopefuler season. Well, how have
you arranged the fence?"

"I start twelve immensely strong wires -- naked, not
insulated -- from a big dynamo in the cave -- dynamo
with no brushes except a positive and a negative one --"

"Yes, that's right."

"The wires go out from the cave and fence in a
circle of level ground a hundred yards in diameter;
they make twelve independent fences, ten feet apart --
that is to say, twelve circles within circles -- and their
ends come into the cave again."

"Right; go on."

"The fences are fastened to heavy oaken posts only
three feet apart, and these posts are sunk five feet in
the ground."

"That is good and strong."

"Yes. The wires have no ground-connection out-
side of the cave. They go out from the positive brush
of the dynamo; there is a ground-connection through
the negative brush; the other ends of the wire return
to the cave, and each is grounded independently."

"Nono, that won't do!"

"Why?"

"It's too expensive -- uses up force for nothing.
You don't want any ground-connection except the one
through the negative brush. The other end of every
wire must be brought back into the cave and fastened
independently, and WITHOUT any ground-connection.
Now, then, observe the economy of it. A cavalry
charge hurls itself against the fence; you are using no
power, you are spending no money, for there is only
one ground-connection till those horses come against
the wire; the moment they touch it they form a con-
nection with the negative brush THROUGH THE GROUND,
and drop dead. Don't you see? -- you are using no
energy until it is needed; your lightning is there, and
ready, like the load in a gun; but it isn't costing you
a cent till you touch it off. Oh, yes, the single
ground-connection --"

"Of course! I don't know how I overlooked that.
It's not only cheaper, but it's more effectual than the
other way, for if wires break or get tangled, no harm
is done.

"No, especially if we have a tell-tale in the cave
and disconnect the broken wire. Well, go on. The
gatlings?"

"Yes -- that's arranged. In the center of the inner
circle, on a spacious platform six feet high, I've
grouped a battery of thirteen gatling guns, and pro-
vided plenty of ammunition."

"That's it. They command every approach, and
when the Church's knights arrive, there's going to be
music. The brow of the precipice over the cave --"

"I've got a wire fence there, and a gatling. They
won't drop any rocks down on us."

"Well, and the glass-cylinder dynamite torpedoes?"

"That's attended to. It's the prettiest garden that
was ever planted. It's a belt forty feet wide, and goes
around the outer fence -- distance between it and the
fence one hundred yards -- kind of neutral ground that
space is. There isn't a single square yard of that
whole belt but is equipped with a torpedo. We laid
them on the surface of the ground, and sprinkled a
layer of sand over them. It's an innocent looking
garden, but you let a man start in to hoe it once, and
you'll see."

"You tested the torpedoes?"

"Well, I was going to, but --"

"But what? Why, it's an immense oversight not
to apply a --"

"Test? Yes, I know; but they're all right; I laid
a few in the public road beyond our lines and they've
been tested."

"Oh, that alters the case. Who did it?"

"A Church committee."

"How kind!"

"Yes. They came to command us to make submis-
sion . You see they didn't really come to test the
torpedoes; that was merely an incident."

"Did the committee make a report?"

"Yes, they made one. You could have heard it a
mile."

"Unanimous?"

"That was the nature of it. After that I put up
some signs, for the protection of future committees,
and we have had no intruders since."

"Clarence, you've done a world of work, and done
it perfectly."

"We had plenty of time for it; there wasn't any
occasion for hurry."

We sat silent awhile, thinking. Then my mind was
made up, and I said:

"Yes, everything is ready; everything is shipshape,
no detail is wanting. I know what to do now."

"So do I; sit down and wait."

"No, SIR! rise up and STRIKE!"

"Do you mean it?"

"Yes, indeed! The DEfensive isn't in my line, and
the OFfensive is. That is, when I hold a fair hand --
two-thirds as good a hand as the enemy. Oh, yes,
we'll rise up and strike; that's our game."

" A hundred to one you are right. When does the
performance begin?"

"NOW! We'll proclaim the Republic."

"Well, that WILL precipitate things, sure enough!"

"It will make them buzz, I tell you! England will
be a hornets' nest before noon to-morrow, if the
Church's hand hasn't lost its cunning -- and we know
it hasn't. Now you write and I'll dictate thus:

                      "PROCLAMATION

                           ---

   "BE IT KNOWN UNTO ALL. Whereas the king having died
   and left no heir, it becomes my duty to continue the
   executive authority vested in me, until a government
   shall have been created and set in motion. The
   monarchy has lapsed, it no longer exists. By
   consequence, all political power has reverted to its
   original source, the people of the nation. With the
   monarchy, its several adjuncts died also; wherefore
   there is no longer a nobility, no longer a privileged
   class, no longer an Established Church; all men are
   become exactly equal; they are upon one common
   level, and religion is free. A REPUBLIC IS HEREBY
   PROCLAIMED,  as being the natural estate of a nation
   when other authority has ceased. It is the duty of
   the British people to meet together immediately,
   and by their votes elect representatives and deliver
   into their hands the government."

I signed it "The Boss," and dated it from Merlin's
Cave. Clarence said --

"Why, that tells where we are, and invites them to
call right away."

"That is the idea. We STRIKE -- by the Proclama-
tion -- then it's their innings. Now have the thing set
up and printed and posted, right off; that is, give the
order; then, if you've got a couple of bicycles handy
at the foot of the hill, ho for Merlin's Cave!"

"I shall be ready in ten minutes. What a cyclone
there is going to be to-morrow when this piece of
paper gets to work!...... It's a pleasant old palace,
this is; I wonder if we shall ever again -- but never
mind about that."


CHAPTER XLIII.
THE BATTLE OF THE SAND BELT

IN Merlin's Cave -- Clarence and I and fifty-two
fresh, bright, well-educated, clean-minded young
British boys. At dawn I sent an order to the factories
and to all our great works to stop operations and re-
move all life to a safe distance, as everything was
going to be blown up by secret mines, "AND NO TELLING
AT WHAT MOMENT -- THEREFORE, VACATE AT ONCE." These
people knew me, and had confidence in my word.
They would clear out without waiting to part their
hair, and I could take my own time about dating the
explosion. You couldn't hire one of them to go back
during the century, if the explosion was still impending.

We had a week of waiting. It was not dull for me,
because I was writing all the time. During the first
three days, I finished turning my old diary into this
narrative form; it only required a chapter or so to
bring it down to date. The rest of the week I took up
in writing letters to my wife. It was always my habit
to write to Sandy every day, whenever we were
separate, and now I kept up the habit for love of it,
and of her, though I couldn't do anything with the
letters, of course, after I had written them. But it
put in the time, you see, and was almost like talking;
it was almost as if I was saying, "Sandy, if you and
Hello-Central were here in the cave, instead of only
your photographs, what good times we could have!"
And then, you know, I could imagine the baby goo-
gooing something out in reply, with its fists in its
mouth and itself stretched across its mother's lap on
its back, and she a-laughing and admiring and worship-
ing, and now and then tickling under the baby's chin
to set it cackling, and then maybe throwing in a word
of answer to me herself -- and so on and so on -- well,
don't you know, I could sit there in the cave with my
pen, and keep it up, that way, by the hour with them.
Why, it was almost like having us all together again.

I had spies out every night, of course, to get news.
Every report made things look more and more im-
pressive. The hosts were gathering, gathering; down
all the roads and paths of England the knights were
riding, and priests rode with them, to hearten these
original Crusaders, this being the Church's war. All
the nobilities, big and little, were on their way, and all
the gentry. This was all as was expected. We should
thin out this sort of folk to such a degree that the
people would have nothing to do but just step to the
front with their republic and --

Ah, what a donkey I was! Toward the end of the
week I began to get this large and disenchanting fact
through my head: that the mass of the nation had
swung their caps and shouted for the republic for
about one day, and there an end! The Church, the
nobles, and the gentry then turned one grand, all-
disapproving frown upon them and shriveled them
into sheep! From that moment the sheep had begun
to gather to the fold -- that is to say, the camps -- and
offer their valueless lives and their valuable wool to the
"righteous cause." Why, even the very men who
had lately been slaves were in the "righteous cause,"
and glorifying it, praying for it, sentimentally slabber-
ing over it, just like all the other commoners. Im-
agine such human muck as this; conceive of this
folly!

Yes, it was now "Death to the Republic!" every-
where -- not a dissenting voice. All England was
marching against us! Truly, this was more than I had
bargained for.

I watched my fifty-two boys narrowly; watched their
faces, their walk, their unconscious attitudes: for all
these are a language -- a language given us purposely
that it may betray us in times of emergency, when we
have secrets which we want to keep. I knew that that
thought would keep saying itself over and over again
in their minds and hearts, ALL ENGLAND IS MARCHING
AGAINST US! and ever more strenuously imploring atten-
tion with each repetition, ever more sharply realizing
itself to their imaginations, until even in their sleep
they would find no rest from it, but hear the vague
and flitting creatures of the dreams say, ALL ENG-
LAND -- ALL ENGLAND! -- IS MARCHING AGAINST YOU! I
knew all this would happen; I knew that ultimately
the pressure would become so great that it would
compel utterance; therefore, I must be ready with an
answer at that time -- an answer well chosen and tran-
quilizing.

I was right. The time came. They HAD to speak.
Poor lads, it was pitiful to see, they were so pale, so
worn, so troubled. At first their spokesman could
hardly find voice or words; but he presently got both.
This is what he said -- and he put it in the neat modern
English taught him in my schools:

"We have tried to forget what we are -- English
boys! We have tried to put reason before sentiment,
duty before love; our minds approve, but our hearts
reproach us. While apparently it was only the nobility,
only the gentry, only the twenty-five or thirty thousand
knights left alive out of the late wars, we were of one
mind, and undisturbed by any troubling doubt; each
and every one of these fifty-two lads who stand here
before you, said, 'They have chosen -- it is their
affair.' But think! -- the matter is altered -- ALL ENG-
LAND IS MARCHING AGAINST US! Oh, sir, consider! --
reflect! -- these people are our people, they are bone
of our bone, flesh of our flesh, we love them -- do not
ask us to destroy our nation!"

Well, it shows the value of looking ahead, and being
ready for a thing when it happens. If I hadn't fore-
seen this thing and been fixed, that boy would have
had me! -- I couldn't have said a word. But I was
fixed. I said:

"My boys, your hearts are in the right place, you
have thought the worthy thought, you have done the
worthy thing. You are English boys, you will remain
English boys, and you will keep that name unsmirched.
Give yourselves no further concern, let your minds be
at peace. Consider this: while all England is march-
ing against us, who is in the van? Who, by the com-
monest rules of war, will march in the front? Answer
me."

"The mounted host of mailed knights."

"True. They are 30,000 strong. Acres deep they
will march. Now, observe: none but THEY will ever
strike the sand-belt! Then there will be an episode!
Immediately after, the civilian multitude in the rear
will retire, to meet business engagements elsewhere.
None but nobles and gentry are knights, and NONE BUT
THESE will remain to dance to our music after that epi-
sode. It is absolutely true that we shall have to fight
nobody but these thirty thousand knights. Now speak,
and it shall be as you decide. Shall we avoid the
battle, retire from the field?"

"NO!!!"

The shout was unanimous and hearty.

"Are you -- are you -- well, afraid of these thirty
thousand knights?"

That joke brought out a good laugh, the boys'
troubles vanished away, and they went gaily to their
posts. Ah, they were a darling fifty-two! As pretty
as girls, too.

I was ready for the enemy now. Let the approach-
ing big day come along -- it would find us on deck.

The big day arrived on time. At dawn the sentry
on watch in the corral came into the cave and reported
a moving black mass under the horizon, and a faint
sound which he thought to be military music. Break-
fast was just ready; we sat down and ate it.

This over, I made the boys a little speech, and then
sent out a detail to man the battery, with Clarence in
command of it.

The sun rose presently and sent its unobstructed
splendors over the land, and we saw a prodigious host
moving slowly toward us, with the steady drift and
aligned front of a wave of the sea. Nearer and nearer
it came, and more and more sublimely imposing be-
came its aspect; yes, all England was there, appar-
ently. Soon we could see the innumerable banners
fluttering, and then the sun struck the sea of armor
and set it all aflash. Yes, it was a fine sight; I hadn't
ever seen anything to beat it.

At last we could make out details. All the front
ranks, no telling how many acres deep, were horse-
men -- plumed knights in armor. Suddenly we heard
the blare of trumpets; the slow walk burst into a
gallop, and then -- well, it was wonderful to see!
Down swept that vast horse-shoe wave -- it approached
the sand-belt -- my breath stood still; nearer, nearer --
the strip of green turf beyond the yellow belt grew
narrow -- narrower still -- became a mere ribbon in
front of the horses -- then disappeared under their
hoofs. Great Scott! Why, the whole front of that
host shot into the sky with a thunder-crash, and be-
came a whirling tempest of rags and fragments; and
along the ground lay a thick wall of smoke that hid
what was left of the multitude from our sight.

Time for the second step in the plan of campaign!
I touched a button, and shook the bones of England
loose from her spine!

In that explosion all our noble civilization-factories
went up in the air and disappeared from the earth. It
was a pity, but it was necessary. We could not afford
to let the enemy turn our own weapons against us.

Now ensued one of the dullest quarter-hours I had
ever endured. We waited in a silent solitude enclosed
by our circles of wire, and by a circle of heavy smoke
outside of these. We couldn't see over the wall of
smoke, and we couldn't see through it. But at last it
began to shred away lazily, and by the end of another
quarter-hour the land was clear and our curiosity was
enabled to satisfy itself. No living creature was in
sight! We now perceived that additions had been
made to our defenses. The dynamite had dug a ditch
more than a hundred feet wide, all around us, and cast
up an embankment some twenty-five feet high on both
borders of it. As to destruction of life, it was amazing.
Moreover, it was beyond estimate. Of course, we
could not COUNT the dead, because they did not exist
as individuals, but merely as homogeneous protoplasm,
with alloys of iron and buttons.

No life was in sight, but necessarily there must have
been some wounded in the rear ranks, who were carried
off the field under cover of the wall of smoke; there
would be sickness among the others -- there always is,
after an episode like that. But there would be no
reinforcements; this was the last stand of the chivalry
of England; it was all that was left of the order, after
the recent annihilating wars. So I felt quite safe in
believing that the utmost force that could for the future
be brought against us would be but small; that is, of
knights. I therefore issued a congratulatory proclama-
tion to my army in these words:

   SOLDIERS, CHAMPIONS OF HUMAN LIBERTY AND EQUALITY:
   Your General congratulates you! In the pride of his
   strength and the vanity of his renown, an arrogant
   enemy came against you. You were ready. The conflict
   was brief; on your side, glorious. This mighty
   victory, having been achieved utterly without loss,
   stands without example in history. So long as the
   planets shall continue to move in their orbits, the
   BATTLE OF THE SAND-BELT will not perish out of the
   memories of men.

                                THE BOSS.

I read it well, and the applause I got was very grati-
fying to me. I then wound up with these remarks:

"The war with the English nation, as a nation, is at
an end. The nation has retired from the field and the
war. Before it can be persuaded to return, war will
have ceased. This campaign is the only one that is
going to be fought. It will be brief -- the briefest in
history. Also the most destructive to life, considered
from the standpoint of proportion of casualties to
numbers engaged. We are done with the nation;
henceforth we deal only with the knights. English
knights can be killed, but they cannot be conquered.
We know what is before us. While one of these men
remains alive, our task is not finished, the war is not
ended. We will kill them all." [Loud and long con-
tinued applause.]

I picketed the great embankments thrown up around
our lines by the dynamite explosion -- merely a look-
out of a couple of boys to announce the enemy when
he should appear again.

Next, I sent an engineer and forty men to a point
just beyond our lines on the south, to turn a mountain
brook that was there, and bring it within our lines and
under our command, arranging it in such a way that I
could make instant use of it in an emergency. The
forty men were divided into two shifts of twenty each,
and were to relieve each other every two hours. In
ten hours the work was accomplished.

It was nightfall now, and I withdrew my pickets.
The one who had had the northern outlook reported a
camp in sight, but visible with the glass only. He also
reported that a few knights had been feeling their way
toward us, and had driven some cattle across our lines,
but that the knights themselves had not come very
near. That was what I had been expecting. They
were feeling us, you see; they wanted to know if we
were going to play that red terror on them again.
They would grow bolder in the night, perhaps. I be-
lieved I knew what project they would attempt, because
it was plainly the thing I would attempt myself if I
were in their places and as ignorant as they were. I
mentioned it to Clarence.

"I think you are right," said he; "it is the obvious
thing for them to try."

"Well, then," I said, "if they do it they are
doomed.

"Certainly."

They won't have the slightest show in the world."

"Of course they won't."

"It's dreadful, Clarence. It seems an awful pity."

The thing disturbed me so that I couldn't get any
peace of mind.for thinking of it and worrying over it.
So, at last, to quiet my conscience, I framed this
message to the knights:

   TO THE HONORABLE THE COMMANDER OF THE INSURGENT
   CHIVALRY OF ENGLAND: YOU fight in vain. We know
   your strength -- if one may call it by that name.
   We know that at the utmost you cannot bring 
   against us above five and twenty thousand knights.
   Therefore, you have no chance -- none whatever.
   Reflect: we are well equipped, well fortified, we
   number 54. Fifty-four what? Men? No, MINDS -- the
   capablest in the world; a force against which
   mere animal might may no more hope to prevail than
   may the idle waves of the sea hope to prevail
   against the granite barriers of England. Be advised.
   We offer you your lives; for the sake of your
   families, do not reject the gift. We offer you
   this chance, and it is the last: throw down your
   arms; surrender unconditionally to the Republic,
   and all will be forgiven.

                          (Signed) THE BOSS.

I read it to Clarence, and said I proposed to send it
by a flag of truce. He laughed the sarcastic laugh he
was born with, and said:

"Somehow it seems impossible for you to ever fully
realize what these nobilities are. Now let us save a
little time and trouble. Consider me the commander
of the knights yonder. Now, then, you are the flag
of truce; approach and deliver me your message, and
I will give you your answer."

I humored the idea. I came forward under an
imaginary guard of the enemy's soldiers, produced my
paper, and read it through. For answer, Clarence
struck the paper out of my hand, pursed up a scorn-
ful lip and said with lofty disdain:

"Dismember me this animal, and return him in a
basket to the base-born knave who sent him; other
answer have I none!"

How empty is theory in presence of fact! And this
was just fact, and nothing else. It was the thing that
would have happened, there was no getting around
that. I tore up the paper and granted my mistimed
sentimentalities a permanent rest.

Then, to business. I tested the electric signals from
the gatling platform to the cave, and made sure that
they were all right; I tested and retested those which
commanded the fences -- these were signals whereby I
could break and renew the electric current in each
fence independently of the others at will. I placed
the brook-connection under the guard and authority of
three of my best boys, who would alternate in two-
hour watches all night and promptly obey my signal,
if I should have occasion to give it -- three revolver-
shots in quick succession. Sentry-duty was discarded
for the night, and the corral left empty of life; I
ordered that quiet be maintained in the cave, and the
electric lights turned down to a glimmer.

As soon as it was good and dark, I shut off the
current from all the fences, and then groped my way
out to the embankment bordering our side of the great
dynamite ditch. I crept to the top of it and lay there
on the slant of the muck to watch. But it was too
dark to see anything. As for sounds, there were none.
The stillness was deathlike. True, there were the
usual night-sounds of the country -- the whir of night-
birds, the buzzing of insects, the barking of distant
dogs, the mellow lowing of far-off kine -- but these
didn't seem to break the stillness, they only intensified
it, and added a grewsome melancholy to it into the
bargain.

I presently gave up looking, the night shut down so
black, but I kept my ears strained to catch the least
suspicious sound, for I judged I had only to wait, and
I shouldn't be disappointed. However, I had to wait
a long time. At last I caught what you may call in
distinct glimpses of sounddulled metallic sound. I
pricked up my ears, then, and held my breath, for this
was the sort of thing I had been waiting for. This
sound thickened, and approached -- from toward the
north. Presently, I heard it at my own level -- the
ridge-top of the opposite embankment, a hundred feet
or more away. Then I seemed to see a row of black
dots appear along that ridge -- human heads? I
couldn't tell; it mightn't be anything at all; you
can't depend on your eyes when your imagination is
out of focus. However, the question was soon settled.
I heard that metallic noise descending into the great
ditch. It augmented fast, it spread all along, and it
unmistakably furnished me this fact: an armed host
was taking up its quarters in the ditch. Yes, these
people were arranging a little surprise party for us.
We could expect entertainment about dawn, possibly
earlier.

I groped my way back to the corral now; I had
seen enough. I went to the platform and signaled to
turn the current on to the two inner fences. Then I
went into the cave, and found everything satisfactory
there -- nobody awake but the working-watch. I woke
Clarence and told him the great ditch was filling up
with men, and that I believed all the knights were
coming for us in a body. It was my notion that as
soon as dawn approached we could expect the ditch's
ambuscaded thousands to swarm up over the embank-
ment and make an assault, and be followed immediately
by the rest of their army.

Clarence said:

"They will be wanting to send a scout or two in the
dark to make preliminary observations. Why not take
the lightning off the outer fences, and give them a
chance?"

"I've already done it, Clarence. Did you ever
know me to be inhospitable?"

"No, you are a good heart. I want to go and --"

"Be a reception committee? I will go, too."

We crossed the corral and lay down together between
the two inside fences. Even the dim light of the cave
had disordered our eyesight somewhat, but the focus
straightway began to regulate itself and soon it was ad-
justed for present circumstances. We had had to feel
our way before, but we could make out to see the
fence posts now. We started a whispered conversa-
tion, but suddenly Clarence broke off and said:

"What is that?"

"What is what?"

"That thing yonder."

"What thing -- where?"

"There beyond you a little piece -- dark some-
thing -- a dull shape of some kind -- against the second
fence."

I gazed and he gazed. I said:

"Could it be a man, Clarence?"

"No, I think not. If you notice, it looks a lit --
why, it IS a man! -- leaning on the fence."

"I certainly believe it is; let us go and see."

We crept along on our hands and knees until we
were pretty close, and then looked up. Yes, it was a
man -- a dim great figure in armor, standing erect,
with both hands on the upper wire -- and, of course,
there was a smell of burning flesh. Poor fellow, dead
as a door-nail, and never knew what hurt him. He
stood there like a statue -- no motion about him, ex-
cept that his plumes swished about a little in the night
wind. We rose up and looked in through the bars of
his visor, but couldn't make out whether we knew him
or not -- features too dim and shadowed.

We heard muffled sounds approaching, and we sank
down to the ground where we were. We made out
another knight vaguely; he was coming very stealthily,
and feeling his way. He was near enough now for us
to see him put out a hand, find an upper wire, then
bend and step under it and over the lower one. Now
he arrived at the first knight -- and started slightly
when he discovered him. He stood a moment -- no
doubt wondering why the other one didn't move on;
then he said, in a low voice, "Why dreamest thou
here, good Sir Mar --" then he laid his hand on the
corpse's shoulder -- and just uttered a little soft moan
and sunk down dead. Killed by a dead man, you
see -- killed by a dead friend, in fact. There was
something awful about it.

These early birds came scattering along after each
other, about one every five minutes in our vicinity,
during half an hour. They brought no armor of
offense but their swords; as a rule, they carried the
sword ready in the hand, and put it forward and found
the wires with it. We would now and then see a blue
spark when the knight that caused it was so far away
as to be invisible to us; but we knew what had hap-
pened, all the same; poor fellow, he had touched a
charged wire with his sword and been elected. We
had brief intervals of grim stillness, interrupted with
piteous regularity by the clash made by the falling of
an iron-clad; and this sort of thing was going on, right
along, and was very creepy there in the dark and
lonesomeness.

We concluded to make a tour between the inner
fences. We elected to walk upright, for convenience's
sake; we argued that if discerned, we should be taken
for friends rather than enemies, and in any case we
should be out of reach of swords, and these gentry did
not seem to have any spears along. Well, it was a
curious trip. Everywhere dead men were lying out-
side the second fence -- not plainly visible, but still
visible; and we counted fifteen of those pathetic
statues -- dead knights standing with their hands on
the upper wire.

One thing seemed to be sufficiently demonstrated:
our current was so tremendous that it killed before the
victim could cry out. Pretty soon we detected a
muffled and heavy sound, and next moment we guessed
what it was. It was a surprise in force coming!
whispered Clarence to go and wake the army, and
notify it to wait in silence in the cave for further orders.
He was soon back, and we stood by the inner fence
and watched the silent lightning do its awful work
upon that swarming host. One could make out but
little of detail; but he could note that a black mass
was piling itself up beyond the second fence. That
swelling bulk was dead men! Our camp was enclosed
with a solid wall of the dead -- a bulwark, a breast-
work, of corpses, you may say. One terrible thing
about this thing was the absence of human voices;
there were no cheers, no war cries; being intent upon
a surprise, these men moved as noiselessly as they
could; and always when the front rank was near
enough to their goal to make it proper for them to
begin to get a shout ready, of course they struck the
fatal line and went down without testifying.

I sent a current through the third fence now; and
almost immediately through the fourth and fifth, so
quickly were the gaps filled up. I believed the time
was come now for my climax; I believed that that
whole army was in our trap. Anyway, it was high
time to find out. So I touched a button and set fifty
electric suns aflame on the top of our precipice.

Land, what a sight! We were enclosed in three
walls of dead men! All the other fences were pretty
nearly filled with the living, who were stealthily work-
ing their way forward through the wires. The sudden
glare paralyzed this host, petrified them, you may say,
with astonishment; there was just one instant for me
to utilize their immobility in, and I didn't lose the
chance. You see, in another instant they would have
recovered their faculties, then they'd have burst into a
cheer and made a rush, and my wires would have gone
down before it; but that lost instant lost them their
opportunity forever; while even that slight fragment of
time was still unspent, I shot the current through all
the fences and struck the whole host dead in their
tracks! THERE was a groan you could HEAR! It voiced
the death-pang of eleven thousand men. It swelled
out on the night with awful pathos.

A glance showed that the rest of the enemy -- per-
haps ten thousand strong -- were between us and the
encircling ditch, and pressing forward to the assault.
Consequently we had them ALL! and had them past
help. Time for the last act of the tragedy. I fired the
three appointed revolver shots -- which meant:

"Turn on the water!"

There was a sudden rush and roar, and in a minute
the mountain brook was raging through the big ditch
and creating a river a hundred feet wide and twenty-
five deep.

"Stand to your guns, men! Open fire!"

The thirteen gatlings began to vomit death into the
fated ten thousand. They halted, they stood their
ground a moment against that withering deluge of fire,
then they broke, faced about and swept toward the
ditch like chaff before a gale. A full fourth part of
their force never reached the top of the lofty embank-
ment; the three-fourths reached it and plunged over --
to death by drowning.

Within ten short minutes after we had opened fire,
armed resistance was totally annihilated, the campaign
was ended, we fifty-four were masters of England.
Twenty-five thousand men lay dead around us.

But how treacherous is fortune! In a little while --
say an hour -- happened a thing, by my own fault, which
-- but I have no heart to write that. Let the record
end here.


CHAPTER XLIV.
A POSTSCRIPT BY CLARENCE

I, CLARENCE, must write it for him. He proposed
that we two go out and see if any help could be
accorded the wounded. I was strenuous against the
project. I said that if there were many, we could do
but little for them; and it would not be wise for us to
trust ourselves among them, anyway. But he could
seldom be turned from a purpose once formed; so we
shut off the electric current from the fences, took an
escort along, climbed over the enclosing ramparts of
dead knights, and moved out upon the field. The first
wounded mall who appealed for help was sitting with
his back against a dead comrade. When The Boss
bent over him and spoke to him, the man recognized
him and stabbed him. That knight was Sir Meliag-
raunce, as I found out by tearing off his helmet. He
will not ask for help any more.

We carried The Boss to the cave and gave his
wound, which was not very serious, the best care we
could. In this service we had the help of Merlin,
though we did not know it. He was disguised as a
woman, and appeared to be a simple old peasant good-
wife. In this disguise, with brown-stained face and
smooth shaven, he had appeared a few days after The
Boss was hurt and offered to cook for us, saying her
people had gone off to join certain new camps which
the enemy were forming, and that she was starving.
The Boss had been getting along very well, and had
amused himself with finishing up his record.

We were glad to have this woman, for we were short
handed. We were in a trap, you see -- a trap of our
own making. If we stayed where we were, our dead
would kill us; if we moved out of our defenses, we
should no longer be invincible. We had conquered;
in turn we were conquered. The Boss recognized
this; we all recognized it. If we could go to one of
those new camps and patch up some kind of terms
with the enemy -- yes, but The Boss could not go, and
neither could I, for I was among the first that were
made sick by the poisonous air bred by those dead
thousands. Others were taken down, and still others.
To-morrow --

TO-MORROW. It is here. And with it the end.
About midnight I awoke, and saw that hag making
curious passes in the air about The Boss's head and
face, and wondered what it meant. Everybody but
the dynamo-watch lay steeped in sleep; there was no
sound. The woman ceased from her mysterious fool-
ery, and started tip-toeing toward the door. I called
out:

"Stop! What have you been doing?"

She halted, and said with an accent of malicious
satisfaction:

"Ye were conquerors; ye are conquered! These
others are perishing -- you also. Ye shall all die in
this place -- every one -- except HIM. He sleepeth
now -- and shall sleep thirteen centuries. I am
Merlin!"

Then such a delirium of silly laughter overtook him
that he reeled about like a drunken man, and presently
fetched up against one of our wires. His mouth is
spread open yet; apparently he is still laughing. I
suppose the face will retain that petrified laugh until
the corpse turns to dust.

The Boss has never stirred -- sleeps like a stone. If
he does not wake to-day we shall understand what
kind of a sleep it is, and his body will then be borne
to a place in one of the remote recesses of the cave
where none will ever find it to desecrate it. As for
the rest of us -- well, it is agreed that if any one of us
ever escapes alive from this place, he will write the
fact here, and loyally hide this Manuscript with The
Boss, our dear good chief, whose property it is, be he
alive or dead.

              THE END OF THE MANUSCRIPT


FINAL P.S. BY M.T.

THE dawn was come when I laid the Manuscript
aside. The rain had almost ceased, the world
was gray and sad, the exhausted storm was sighing
and sobbing itself to rest. I went to the stranger's
room, and listened at his door, which was slightly ajar.
I could hear his voice, and so I knocked. There was
no answer, but I still heard the voice. I peeped in.
The man lay on his back in bed, talking brokenly but
with spirit, and punctuating with his arms, which he
thrashed about, restlessly, as sick people do in de-
lirium. I slipped in softly and bent over him. His
mutterings and ejaculations went on. I spoke -- merely
a word, to call his attention. His glassy eyes and his
ashy face were alight in an instant with pleasure, grati-
tude, gladness, welcome:

"Oh, Sandy, you are come at last -- how I have
longed for you! Sit by me -- do not leave me --
never leave me again, Sandy, never again. Where is
your hand? -- give it me, dear, let me hold it -- there
-- now all is well, all is peace, and I am happy again --
WE are happy again, isn't it so, Sandy? You are so
dim, so vague, you are but a mist, a cloud, but you
are HERE, and that is blessedness sufficient; and I have
your hand; don't take it away -- it is for only a little
while, I shall not require it long...... Was that the
child?...... Hello-Central!...... she doesn't answer.
Asleep, perhaps? Bring her when she wakes, and let
me touch her hands, her face, her hair, and tell her
good-bye...... Sandy! Yes, you are there. I 
lost myself a moment, and I thought you were
gone...... Have I been sick long? It must be so;
it seems months to me. And such dreams! such
strange and awful dreams, Sandy! Dreams that were
as real as reality -- delirium, of course, but SO real!
Why, I thought the king was dead, I thought you
were in Gaul and couldn't get home, I thought there
was a revolution; in the fantastic frenzy of these
dreams, I thought that Clarence and I and a hand-
ful of my cadets fought and exterminated the whole
chivalry of England! But even that was not the
strangest. I seemed to be a creature out of a remote
unborn age, centuries hence, and even THAT was as real
as the rest! Yes, I seemed to have flown back out of
that age into this of ours, and then forward to it again,
and was set down, a stranger and forlorn in that strange
England, with an abyss of thirteen centuries yawning
between me and you! between me and my home and
my friends! between me and all that is dear to me, all
that could make life worth the living! It was awful --
awfuler than you can ever imagine, Sandy. Ah,
watch by me, Sandy -- stay by me every moment --
DON'T let me go out of my mind again; death is noth-
ing, let it come, but not with those dreams, not with
the torture of those hideous dreams -- I cannot endure
THAT again...... Sandy?......"

He lay muttering incoherently some little time; then
for a time he lay silent, and apparently sinking away
toward death. Presently his fingers began to pick
busily at the coverlet, and by that sign I knew that his
end was at hand with the first suggestion of the
death-rattle in his throat he started up slightly, and
seemed to listen: then he said:

"A bugle?...... It is the king! The drawbridge,
there! Man the battlements! -- turn out the --"

He was getting up his last "effect"; but he never
finished it.

                        THE END

