                *** ANSIPLUS VERSION 2.04 RELEASE NOTES ***
                             Shareware Package

Thank you for evaluating ANSIPLUS.  This file briefly describes ANSIPLUS, lists
the files included in the ANSIPLUS Shareware package, gives quick installation
instructions, and describes recent changes made to ANSIPLUS.


What is ANSIPLUS?
---- -- ---------

The ANSIPLUS console device driver integrates major console elements missing
from DOS and the personal computer BIOS into a single compact device driver that
can easily be controlled and personalized.  With ANSIPLUS installed:

 * User interaction with the DOS command shell and many applications will be
   significantly improved.

 * Screen output will be faster than with DOS's ANSI and non-ANSI drivers.

 * The user will have complete control over colors and VGA/EGA capabilities.

 * Users of Windows 3 will have access to ANSIPLUS features in all windowed
   and full screen DOS sessions.

 * The user will also benefit from all the other display and keyboard features
   provided by ANSIPLUS.


The ANSIPLUS enhanced DOS console device driver is tailored to take advantage of
VGA and EGA display capabilities:

 * It automatically adapts to VGA or EGA screen modes, both text and graphics,
   including extended modes with large numbers of lines and/or columns.  The
   driver also automatically compensates for older video controllers with very
   limited numbers of colors or shades (eg. CGA or monochrome boards).

 * In text and in 16-color VGA/EGA graphics display modes, the driver bypasses
   the BIOS and writes directly to the video RAM, so it can operate much faster
   than either the original DOS console driver or the DOS ANSI driver.

 * ANSIPLUS gives the user control over VGA/EGA palette registers and VGA DAC
   registers to select and maintain colors using the video controller's full
   capabilities.

 * Text character height can be selected in any VGA/EGA display mode, extending
   user control to the number of lines per display page.

 * Smooth scrolling is provided as an option (requires a faster computer, eg.
   80386 with 16-bit VGA).



The ANSIPLUS driver efficiently integrates several useful console functions that
in the past had to be provided by separate TSR programs or device drivers:

 * Keyboard buffer size is increased and configurable.

 * Undesired repeat keys are suppressed and several other key processing
   options are provided.

 * A screen saver monitors display, keyboard and mouse activity.

 * Scroll-back lets the user examine lines that have scrolled off the top of
   the screen.

 * Fast screen output can be frozen and released with the Scroll Lock key.

 * A timer-controlled beep tone generator allows user customizable tones.

Other ANSIPLUS features include:

 * Menu driven utilities give the user full control over selected colors,
   color palettes, border colors, video modes, text height, key reassignment,
   beep tone definition, driver table sizes, and all other configurable
   features.

 * Special loading options for XMS upper memory blocks or DOS 5.0 high memory
   area reduce low memory requirements to below 4K.

 * Highlighting of user-typed keys when they are displayed by DOS on the screen
   gives a clear visual separation of typed entries from computer output.

 * All DOS ANSI.sys escape sequences are supported, plus additional ANSI/VT-100
   escape sequences for clearing the screen, erasing lines, inserting and
   deleting lines, and inserting and deleting characters.

 * And much, much more.

See "Features Summary" in the ANSIPLUS documentation for more information about
ANSIPLUS features.


ANSIPLUS Packing List
-------- ------- ----

     File                Description
     ----                -----------

     ANSIPLUS.sys        ANSIPLUS console device driver
     ANSIPLUS.doc        ANSIPLUS Shareware documentation
     SETCOLOR.exe        Color control utility program
     SETAPLUS.exe        Driver features control utility program
     ANSICOM.exe         ANSI escape sequence editor
     NEWAPLUS.exe        ANSIPLUS bootup configuration program
     APLUSLIB.exe        Execution library for the utility programs
     SETCOLOR.sch        Color schemes file for SETCOLOR.exe
     CONSETUP.com        Sample escape sequence program
     PUSHVID.com         Save current video mode, video page and colors
     POPVID.com          Restore saved video mode, page and colors
     INSTALL.exe         Installation program
     INSTALL.inf         Installation control file
     REGISTER.pls        ANSIPLUS registration form
     README.pls          Release notes, this file


The documentation file, ANSIPLUS.doc, is a complete and up to date copy of the
ANSIPLUS Shareware manual, except for the section on ANSIPLUS Escape Sequences,
which are covered in detail only in the printed version.  The file is formatted
for 80 characters per line and 60 lines per page, and uses no special characters
or other printer control other than form feeds.



Quick Installation Instructions
----- ------------ ------------

Before installing ANSIPLUS, or any other new device driver, be sure you have a
bootable floppy disk as insurance against trouble getting your system to run
after the device driver is installed.

The ANSIPLUS package includes an installation and configuration program called
INSTALL.exe, which should properly handle most installations.  Context
sensitive help (via the F1 key) is provided for all entries.  The following
three examples illustrate using INSTALL to install ANSIPLUS:

 * If you received ANSIPLUS on a floppy disk and want to install it on your
   hard disk, use the following installation procedure:

    (1) Set the default directory to the hard disk (ie. get a C> prompt).
    (2) Insert the ANSIPLUS diskette in drive A: (or other floppy drive).
    (3) Enter the following command:

            A:INSTALL

 * If you received ANSIPLUS as a ZIP file, use the following procedure:

    (1) Create a subdirectory on the hard disk to contain the unzipped ANSIPLUS
        files.  Move ANSIPLUS.zip to this directory and make it be the default
        directory.
    (2) Unzip the files into the directory with the command:

            PKUNZIP ANSIPLUS

    (3) Then enter the command:

            INSTALL


 * To install ANSIPLUS on bootable disk B:, from hard disk directory C:\APLUS,
   enter the command:

            C:\APLUS\INSTALL B:

See "Installing ANSIPLUS" in the documentation for more information about
ANSIPLUS installation.


Recent ANSIPLUS Changes
------ -------- -------

 9/18/92 Version 2.04 released.

 9/17/92 Revised installation program (NEWAPLUS.exe) to be more tolerant of and
         informative about missing or unreadable files during installation.
         Versions of ANSIPLUS on some BBS's seem to be missing files (usually
         SETCOLOR.sch, which is a minor supporting file), and this has prevented
         potential users from evaluating ANSIPLUS.

 9/04/92 When Scroll-Lock is used to freeze the screen during rapid output, and
         then the screen is released by Page-Down, Tab, Down arrow, or a shift
         key until the next input prompt is made by the computer, the driver can
         now recognize the input request and will automatically release the
         scroll freeze condition after a key is typed.

 9/04/92 Under Windows and OS/2, the driver now yields the CPU for the remainder
         of a time slice whenever it is in a tight key input/testing loop.

 9/03/92 Under Windows, whenever the scroll-back storage area is initialized, a
         RAM search is now made to see if the video RAM is a full 32k.  If less
         is available, the scroll-back storage is reduced accordingly, and
         smooth scrolling, which uses the top of the 32k video RAM, is disabled.
         This should work around problems with 256-color Windows drivers that do
         not provide a full 32k of text mode video RAM in certain situations.

 9/02/92 Under Windows, in a virtual 8086 DOS session running in a window,
         scroll-back appeared to be inoperative because Windows 3.1 failed to
         update the windowed screen as it was scrolled backward or forward. If
         the same DOS session was run full screen, scroll back would perform
         correctly.  The driver is now able to cause the windowed screen to be
         updated in most cases (such as when DOS keyboard input is requested),
         so scroll-back should work in a window most of the time.  However, it
         is still not possible to scroll the screen backward in a window while
         it has been frozen by Scroll-Lock during rapid screen output.

 8/31/92 Version 2.03 released.

 8/22/92 Bug fix: made VGA screen saver less likely to interfere with running
         programs by disabling interrupts while the screen is being blanked or
         unblanked and by restoring the sequencer index after the operation.

 8/22/92 Bug fix: push/pop mismatch in VESA set mode processing.  Symptom was
         inability to start Windows.

 8/22/92 Now use Int 15h keyboard intercept rather than direct port access to
         get key scan codes for repeated-key detection and other key processing.

 8/21/92 Version 2.02 released.

 8/14/92 Added mouse reset to Windows exit processing.  Windows 3.1 leaves some
         mice (for example, Logitech C7) in an undefined state at termination,
         so the mouse could not unblank the screen until the next DOS mouse-
         using program had been executed.

 8/12/92 Bug fix: still intermittent trouble with keyboard under Windows 3.1.
         Made all of Int 09h handler uninterruptible.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 7/22/92 Version 2.01 released.

 7/21/92 Extended repeated key suppression to the Scroll Lock key.  Now, when
         Scroll Lock is held down for a long time, the scroll lock or smooth
         scroll toggles will not change repeatedly.

 7/17/92 Bug fix: 16-color to monochrome text attribute adjustments for EGA
         monochrome now show low intensity as well as high intensity for both
         foreground and background. VGA, CGA, MDA and color EGA are unaffected.

 7/16/92 Minor changes to INSTALL/NEWAPLUS target drive and file path selection.

 7/16/92 Minor changes to scroll freeze when smooth scrolling is active.

 7/16/92 Bug fix: Scroll back storage is reorganized whenever a previously
         unused display page is selected.  In several display modes, including
         25x80 text, a bug caused the scroll-back data to be scrambled when
         reorganization was required.

 7/15/92 Bug fix: On certain PC/XT compatible computers, all keystrokes were
         erroneously recognized as repeat keys, causing all digit keys to be
         ignored.  Repeated key suppression is now disabled on XT's.

 7/15/92 Bug fix: Repeated keys entered to QuickBasic programs such as DOS 5.0
         EDIT.com caused pointer errors when keys were transferred between BIOS
         and extended key buffers.  Symptom was strange jumps in cursor position
         or "phantom" keystrokes while holding down an arrow key.  Fixed by
         making the key shuffling subroutine uninterruptible.

 6/09/92 Version 2.00 released.

 5/28/92 Bug fix: Made 16-color graphics mode pseudo-cursor XOR operations to
         screen uninterruptible to prevent "mouse droppings" following mouse
         movement in IBM DOS 4.0 shell or other programs that draw to the screen
         during an interrupt and assume normal EGA/VGA graphics write mode is in
         force.

 5/26/92 Took over VGA/EGA BIOS text mode custom character generator load
         function to speed it up and to prevent BIOS's restoration of OEM
         palette when only one or a few character codes are changed.

 5/18/92 Added Generic IOCTL and Int 2Fh functions that are also provided by the
         DOS 4.0 and 5.0 ANSI.sys drivers.  A few programs may rely on these
         functions for information about the screen after they determine that an
         ANSI driver is running.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 5/08/92 Screen scroll-back completed.  Between video display mode sets, the
         driver now captures all lines scrolled off the top of the screen and
         places them in unused portions of display RAM.  To view the saved
         lines, hit the Scroll-Lock key at any time.  When Scroll-Lock is on
         (as indicated by the light on enhanced keyboards), normal key input is
         disabled and the following keys apply:

              Home        Go to the top of the saved lines
              PageUp      Scroll up one page
              Shift tab   Scroll up one-half page
              Up arrow    Scroll up one line
              End         Go to the bottom (ie. the original screen display)
              PageDn      Scroll down one page
              Tab         Scroll down one-half page
              Down arrow  Scroll down one line
              Insert      Save the current screen page for later scroll-back
              Left arrow  View a lower numbered display page
              Right arrow View a higher numbered display page
              Escape      Cancel scroll lock, return to normal key processing
              Scroll lock Cancel scroll lock, return to normal key processing

         When you try to exceed the limit of travel up, down, left or right,
         a short low pitched tone will sound.  If you enter any key other than
         those above, you will hear a short warbling sound, Scroll Lock will be
         canceled, the screen will return to its normal display, and the key
         will be passed back to the running program.

 5/04/92 ANSIPLUS can now load itself to upper memory under DOS 5.0 with EMM386
         and the CONFIG.sys DOS=UMB command active.  The DEVICE=ANSIPLUS.sys /U
         command should work correctly under EMM386, 386MAX and QEMM, with or
         without DOS=UMB.

 5/02/92 The ANSIPLUS installation and configuration program, NEWAPLUS.exe, has
         been completed.  The program analyzes the runtime environment and
         CONFIG.sys of the target drive, locates the source files, copies
         ANSIPLUS to the target drive (or any directories of the user's
         choice), and updates CONFIG.sys for a new install.  The configuration
         section lets the user set the startup (boot) driver table sizes,
         colors and feature settings, as well as high memory loading options in
         CONFIG.sys.  Context sensitive help is provided for all entries.
         See Installing ANSIPLUS in the documentation for instructions on
         using NEWAPLUS.

 4/24/92 Version 2 of the ANSICOM utility has been completed.  The program is
         now more user friendly, with colors and context sensitive help.

 4/15/92 Repeated key suppression has been extended to the numeric keys (0-9).
         This makes it impossible to key in an inaccurate number just because
         a numeric key is held down too long.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 4/14/92 To prevent escape sequence conflicts with programs written for other
         ANSI terminal emulators or when displaying data downloaded from systems
         configured for terminals such as the DEC VT-100, the six non-standard
         (ie. added) ANSIPLUS escape commands have been changed to require a
         "!" after the left bracket.  The following table shows the affected
         escape sequences:

            Obsolete        Revised
            Sequence        Sequence        Description
            --------        --------        -----------

            Esc [v          Esc [!v         Select video page
            Esc [t          Esc [!t         Set text height
            Esc [e          Esc [!e         Set text treatments
            Esc [c          Esc [!c         Define colors, palette, etc.
            Esc [d          Esc [!d         Set driver features
            Esc [g          Esc [!g         Define beep tone

         Any escape sequences using these ANSIPLUS commands but without the "!"
         will be ignored.  If the "!" appears in any escape sequence that
         doesn't need it, the escape command will execute correctly anyway.

         Also in the name of compatibility, the Esc [K command (Erase Line) has
         been corrected.  To erase from the cursor to the end of line, you must
         output Esc [K or Esc [0K.  ANSIPLUS's extended parameters to limit the
         character count and set the fill character are now the second and third
         parameters instead of first and second.

         ANSI and DEC VT-100 emulation have been enhanced by adding support for
         the following escape sequences:

                Esc [0J     Clear from cursor to end of screen
                Esc [1J     Clear from start of screen to cursor

                Esc [1K     Clear from start of line to cursor
                Esc [2K     Clear entire line

 4/10/92 ANSIPLUS can now load itself into either XMS upper memory blocks or
         into the high memory area used by DOS 5.0.  The option is selected at
         load time with DEVICE=ANSIPLUS.sys /U or /H.  See Installing ANSIPLUS
         in the documentation for details.

 4/06/92 SETAPLUS can now list all key reassignments currently in force.  Just
         enter SETAPLUS LISTKEYS.

 3/31/92 Added black outline text treatment for 16-color VGA/EGA graphics modes.

 3/28/92 Improved handling of monochrome and CGA display modes.  ANSIPLUS should
         now give reasonable and readable displays in all modes, including those
         with a very limited number of colors or shades.  Programs written in
         terms of 16 colors will be executable on machines with simpler video
         capabilities, if ANSIPLUS is running on that machine.


Recent ANSIPLUS Changes (continued)
------ -------- ------- -----------

 3/19/92 Interrupts are now enabled as much as possible in all ANSIPLUS
         interrupt service routines, minimizing any impact on communications
         or other time sensitive processes.

 3/18/92 Version 2 of the SETCOLOR and SETAPLUS utilities have been completed.
         They now are menu driven, with context sensitive help, and should be
         much easier to use.  The command line interface for these utilities is
         also still supported.

