;Script file for Eudora by Ken Gould, 9/28/97
;Modified with some new functions and for better performance with Eudora 3.0.5 by Ken Gould, 1/4/98.

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants

Script  NextDocumentWindow() 
var
Int AddressControlID
{control+tab}
delay (1)
Let AddressControlID = GetCurrentControlID ()
if (IsMultiPageDialog ()) then
	SayString (GetDialogPageName ())
	return
endif
If (AddressControlID == 1453) Then
SayString ("E-mail address")
EndIf
If (AddressControlId == 1454) Then
SayString ("Notes")
EndIf
EndScript

Script PreviousDocumentWindow() 
Var
Int AddressControlID
{control+shift+tab}
Delay (1)
Let AddressControlID = GetCurrentControlID ()
if (IsMultiPageDialog ()) then
	SayString (GetDialogPageName ())
	return
endif
If (AddressControlID == 1453) Then
SayString ("E-mail address")
EndIf
If (AddressControlId == 1454) Then
SayString ("Notes")
EndIf
EndScript

Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText(AppWindow)
endif
;If (GlobalPrevRealName == RealWindowName) then
	;SayString (GlobalPrevRealName)
	;If (GlobalPrevReal > 0) then
		;SayInteger (GlobalPrevReal)
	;else SayString ("GlobalPrevReal = 0")
	;Endif
	;Saystring (RealWindowName)
	;If (RealWindow > 0) then
		;SayInteger (RealWindow)
	;else SayString ("RealWindow = 0")
	;Endif
;Endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application, 
; for example, progman.jms
let GlobalFocusWindow = FocusWindow
SayFocusedWindow()  ; will use global variable "GlobalFocusWindow"
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
If (StringContains (GetWindowName (GetRealWindow (GetCurrentWindow ())), "Address Book")) Then
If (GetCurrentControlID () == 1453) Then 
SayString ("E-mail address")
EndIf
If (GetCurrentControlID () == 1454) Then 
SayString ("Notes")
EndIf
EndIf
EndFunction

;Script to open signature choice list

Script  OpenSignatures()
SayString ("Signatures list")
FindGraphic (GetAppMainWindow (GetCurrentWindow ()), "Priority", S_Top, S_Unrestricted)
NextWord () NextWord () NextWord () 
Pause ()
LeftMouseButton ()
PcCursor ()
EndScript

;Script to name spell check keys

Script SpellCheck ()
SayString ("Spell check")
{control+6}
EndScript

;Script to name new message keys

Script NewMessage ()
SayString ("New message")
{control+N}
EndScript

;Script to name new message with options keys

Script NewMessageWithOptions ()
SayString ("New message")
{Control+Shift+N}
EndScript

;Script to name check mail keys

Script CheckMail ()
SayString ("Check mail")
{control+M}
EndScript

;Script to name send mail keys

Script SendMail ()
SayString ("Send Mail")
{control+T}
EndScript

;Script to name queue message key	

Script QueueMessage ()
SayString ("Queue message")
{control+E}
EndScript

;Script to name address book key

Script AddressBook ()
SayString ("Address book")
{control+L}
EndScript

;Script to name close key

Script Close ()
SayString ("Close")
{Control+W}
EndScript

;Script to name reply key

Script Reply ()
SayString ("Reply")
{control+R}
EndScript

;Script to name reply with options key

Script ReplyWithOptions ()
SayString ("Reply")
{control+shift+R}
EndScript

;Script to name Attachment key

Script Attachment ()
SayString ("Attachment")
{control+H}
EndScript

;Script to name filter key

Script FilterMessages ()
SayString ("Filter messages")
{control+J}
EndScript

;Script to name take address key

Script TakeAddress ()
SayString ("Take address")
{control+K}
EndScript

Void Function SayNonHighlightedText (handle HWND, string Buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
If Not (StringContains (Buffer, "Verif") || StringContains (Buffer, "Shut") || StringContains (Buffer, "Log") || StringContains (Buffer, "UIDL") || StringContains (Buffer, "Authen") || StringContains (Buffer, "Quit") || StringContains (Buffer, "connect
") || StringContains (Buffer, "User") || StringContains (Buffer, "new mail") || StringContains (Buffer, "Starting")) Then
if ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == "#32771" ) || (TheClass == "ToolTips_Class32") || ((TheClass == "Static") && (GetWindowClass (GetFocus ())) == "Button")) then
	SayString(buffer)
EndIf
EndIf
EndFunction

Script ScriptFileName ()
ScriptAndAppNames ("Eudora")
EndScript

;Script to say unknown word in spell checker

Script UnknownWord ()
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
JAWSPageUp ()
NextLine ()
JAWSHome ()
NextWord ()
SayLine ()
Delay (4)
SpellWord ()
EndScript

;Script to read word in context

Script ReadWordInContext ()
InvisibleCursor ()
MoveTo (1, 1)
FindFirstAttribute (Attrib_Highlight)
If (StringContains (GetChunk (), "Check Spelling")) Then
SayString ("I can't find a highlighted mis-spelled word.  It may be that the Check Spelling dialog is covering it or the word may be in the subject line and isn't being highlighted.")
Else
SayLine ()
EndIf
PcCursor ()
EndScript

;Script to speak default spelling suggestion

Script NewWord ()
SaveCursor ()
RouteInvisibleToPc ()
InvisibleCursor ()
JAWSPageUp ()
NextLine ()
NextLine ()
NextLine ()
JAWSHome ()
NextWord ()
NextWord ()
SayLine ()
Delay (4)
SpellString (GetChunk ())
EndScript

;Script for hot key help

Script HotKeyHelp ()
SayString ("For optimum results with Eudora scripts, maximize Eudora and all mail boxes.")
SayString ("To open the signature selection combo box while creating a new message, use control+shift+S.")
SayString ("While in the spell checker, use control+Shift+U to hear the unknown word.")
SayString ("Use control+shift+O to hear the default new word replacement.")
SayString ("Use Insert+C to hear the misspelled word in context.")
SayString ("If this macro says the highlighted word is covered up, change the message window back to restored for better results.")
SayString ("While creating a new message, use Control+Shift+t to hear who the message is to,")
SayString ("use Control+Shift+c to hear the CCese, and use Control+Shift +B to hear the BCCese.")
EndScript

;Script to read names in To field of message

Script NewMessageTo ()
Var
Int UserLevel
Let UserLevel = GetJcfOption (Opt_User_Mode)
SetJcfOption (Opt_User_Mode, 2)
SaveCursor ()
RouteInvisibleToPc ()
RouteJAWSToPc ()
JAWSCursor ()
FindString (GetCurrentWindow (), "to:", s_top, s_Unrestricted)
NextWord ()
LeftMouseButton ()
Pause ()
RoutePCToInvisible ()
Pause ()
SetJcfOption (Opt_User_Mode, UserLevel)
EndScript

;Script to speak name in CC field of message

Script NewMessageCC ()
Var
Int UserLevel
Let UserLevel = GetJcfOption (Opt_User_Mode)
SetJcfOption (Opt_User_Mode, 2)
SaveCursor ()
RouteInvisibleToPc ()
RouteJAWSToPc ()
JAWSCursor ()
FindString (GetCurrentWindow (), "cc:", s_top, s_Unrestricted)
NextWord ()
LeftMouseButton ()
Pause ()
RoutePCToInvisible ()
Pause ()
SetJcfOption (Opt_User_Mode, UserLevel)
EndScript

;Script to speak names in BCC field of new message

Script NewMessageBCC ()
Var
Int UserLevel
Let UserLevel = GetJcfOption (Opt_User_Mode)
SetJcfOption (Opt_User_Mode, 2)
SaveCursor ()
RouteInvisibleToPc ()
RouteJAWSToPc ()
JAWSCursor ()
FindString (GetCurrentWindow (), "bcc:", s_top, s_Unrestricted)
NextWord ()
LeftMouseButton ()
Pause ()
RoutePCToInvisible ()
Pause ()
SetJcfOption (Opt_User_Mode, UserLevel)
EndScript
