    TITLE III-PUBLIC ACCOMMODATIONS AND SERVICES OPERATED BY PRIVATE ENTITIES 

 SEC. 301. DEFINITIONS.

    As used in this title:
    (1) COMMERCE.-The term "commerce" means travel, trade, traffic, commerce,
 transportation, or communication-
    (A) among the several States;
    (B) between any foreign country or any territory or possession and any
 State; or
    (C) between points in the same State but through another State or foreign
 country.
    (2) COMMERCIAL FACILITIES.-The term "commercial facilities" means
 facilities-
    (A) that are intended for nonresidential use; and
    (B) whose operations will affect commerce. 
    Such term shall not include railroad locomotives, railroad freight cars, 
 railroad cabooses, railroad cars described in section 242 or covered under 
 this title, railroad rights-of-way, or facilities that are covered or 
 expressly exempted from coverage under the Fair Housing Act of 1968 (42 
 U.S.C. 3601 et seq.). 
    (3) DEMAND RESPONSIVE SYSTEM.-The term "demand responsive system" means 
 any system of providing transportation of individuals by a vehicle, other 
 than a system which is a fixed route system. 
    (4) FIXED ROUTE SYSTEM.-The term "fixed route system" means a system of
 providing transportation of individuals (other than by aircraft) on which a
 vehicle is operated along a prescribed route according to a fixed schedule.
    (5) OVER-THE-ROAD BUS.-The term "over-the-road bus" means a bus 
 characterized by an elevated passenger deck located over a baggage 
 compartment. 
    (6) PRIVATE ENTITY.-The term "private entity" means any entity other than 
 a public entity (as defined in section 201(1)). 
    (7) PUBLIC ACCOMMODATION.-The following private entities are considered
 public accommodations for purposes of this title, if the operations of such
 entities affect commerce-
    (A) an inn, hotel, motel, or other place of lodging, except for an 
 establishment located within a building that contains not more than five 
 rooms for rent or hire and that is actually occupied by the proprietor of 
 such establishment as the residence of such proprietor; 
    (B) a restaurant, bar, or other establishment serving food or drink; 
    (C) a motion picture house, theater, concert hall, stadium, or other place 
 of exhibition or entertainment; 
    (D) an auditorium, convention center, lecture hall, or other place of 
 public gathering; 
    (E) a bakery, grocery store, clothing store, hardware store, shopping
 center, or other sales or rental establishment;
    (F) a laundromat, dry-cleaner, bank, barber shop, beauty shop, travel
 service, shoe repair service, funeral parlor, gas station, office of an
 accountant or lawyer, pharmacy, insurance office, professional office of a
 health care provider, hospital, or other service establishment;
    (G) a terminal, depot, or other station used for specified public
 transportation;
    (H) a museum, library, gallery, or other place of public display or
 collection;
    (I) a park, zoo, amusement park, or other place of recreation;
    (J) a nursery, elementary, secondary, undergraduate, or postgraduate 
 private school, or other place of education; 
    (K) a day care center, senior citizen center, homeless shelter, food bank,
 adoption agency, or other social service center establishment; and
    (L) a gymnasium, health spa, bowling alley, golf course, or other place of
 exercise or recreation.
    (8) RAIL AND RAILROAD.-The terms "rail" and "railroad" have the meaning 
 given the term "railroad" in section 202(e) of the Federal Railroad Safety 
 Act of 1970 (45 U.S.C. 431(e)). 
    (9) READILY ACHIEVABLE.-The term "readily achievable" means easily
 accomplishable and able to be carried out without much difficulty or expense.
 In determining whether an action is readily achievable, factors to be
 considered include-
    (A) the nature and cost of the action needed under this Act;
    (B) the overall financial resources of the facility or facilities involved
 in the action; the number of persons employed at such facility; the effect on
 expenses and resources, or the impact otherwise of such action upon the
 operation of the facility;
    (C) the overall financial resources of the covered entity; the overall 
 size of the business of a covered entity with respect to the number of its 
 employees; the number, type, and location of its facilities; and 
    (D) the type of operation or operations of the covered entity, including 
 the composition, structure, and functions of the workforce of such entity; 
 the geographic separateness, administrative or fiscal relationship of the 
 facility or facilities in question to the covered entity. 
    (10) SPECIFIED PUBLIC TRANSPORTATION.-The term "specified public 
 transportation" means transportation by bus, rail, or any other conveyance 
 (other than by aircraft) that provides the general public with general or 
 special service (including charter service) on a regular and continuing 
 basis. 
    (11) VEHICLE.-The term "vehicle" does not include a rail passenger car, 
 railroad locomotive, railroad freight car, railroad caboose, or a railroad 
 car described in section 242 or covered under this title. 

 SEC. 302. PROHIBITION OF DISCRIMINATION BY PUBLIC ACCOMMODATIONS.
    (a) GENERAL RULE.-No individual shall be discriminated against on the 
 basis of disability in the full and equal enjoyment of the goods, services, 
 facilities, privileges, advantages, or accommodations of any place of public 
 accommodation by any person who owns, leases (or leases to), or operates a 
 place of public accommodation. 
    (b) CONSTRUCTION.-
    (1) GENERAL PROHIBITION.-
    (A) ACTIVITIES.-
    (i) DENIAL OF PARTICIPATION.-It shall be discriminatory to subject an 
 individual or class of individuals on the basis of a disability or 
 disabilities of such individual or class, directly, or through contractual, 
 licensing, or other arrangements, to a denial of the opportunity of the 
 individual or class to participate in or benefit from the goods, services, 
 facilities, privileges, advantages, or accommodations of an entity. 
    (ii) PARTICIPATION IN UNEQUAL BENEFIT.-It shall be discriminatory to 
 afford an individual or class of individuals, on the basis of a disability or 
 disabilities of such individual or class, directly, or through contractual, 
 licensing, or other arrangements with the opportunity to participate in or 
 benefit from a good, service, facility, privilege, advantage, or 
 accommodation that is not equal to that afforded to other individuals. 
    (iii) SEPARATE BENEFIT.-It shall be discriminatory to provide an 
 individual or class of individuals, on the basis of a disability or 
 disabilities of such individual or class, directly, or through contractual, 
 licensing, or other arrangements with a good, service, facility, privilege, 
 advantage, or accommodation that is different or separate from that provided 
 to other individuals, unless such action is necessary to provide the 
 individual or class of individuals with a good, service, facility, privilege, 
 advantage, or accommodation, or other opportunity that is as effective as 
 that provided to others. 
    (iv) INDIVIDUAL OR CLASS OF INDIVIDUALS.- For purposes of clauses (i) 
 through (iii) of this subparagraph, the term "individual or class of 
 individuals" refers to the clients or customers of the covered public 
 accommodation that enters into the contractual, licensing or other 
 arrangement. 
    (B) INTEGRATED SETTINGS.-Goods, services, facilities, privileges,
 advantages, and accommodations shall be afforded to an individual with a
 disability in the most integrated setting appropriate to the needs of the
 individual.
    (C) OPPORTUNITY TO PARTICIPATE.-Notwithstanding the existence of separate 
 or different programs or activities provided in accordance with this section, 
 an individual with a disability shall not be denied the opportunity to 
 participate in such programs or activities that are not separate or 
 different. 
    (D) ADMINISTRATIVE METHODS.-An individual or entity shall not, directly or 
 through contractual or other arrangements, utilize standards or criteria or 
 methods of administration-
    (i) that have the effect of discriminating on the basis of disability; or 
    (ii) that perpetuate the discrimination of others who are subject to 
 common administrative control. 
    (E) ASSOCIATION.-It shall be discriminatory to exclude or otherwise deny 
 equal goods, services, facilities, privileges, advantages, accommodations, or 
 other opportunities to an individual or entity because of the known 
 disability of an individual with whom the individual or entity is known to 
 have a relationship or association. 
    (2) SPECIFIC PROHIBITIONS.-
    (A) DISCRIMINATION.-For purposes of subsection (a), discrimination 
 includes-
    (i) the imposition or application of eligibility criteria that screen out 
 or tend to screen out an individual with a disability or any class of 
 individuals with disabilities from fully and equally enjoying any goods, 
 services, facilities, privileges, advantages, or accommodations, unless such 
 criteria can be shown to be necessary for the provision of the goods, 
 services, facilities, privileges, advantages, or accommodations being 
 offered; 
    (ii) a failure to make reasonable modifications in policies, practices, or 
 procedures, when such modifications are necessary to afford such goods, 
 services, facilities, privileges, advantages, or accommodations to 
 individuals with disabilities, unless the entity can demonstrate that making 
 such modifications would fundamentally alter the nature of such goods, 
 services, facilities, privileges, advantages, or accommodations; 
    (iii) a failure to take such steps as may be necessary to ensure that no 
 individual with a disability is excluded, denied services, segregated or 
 otherwise treated differently than other individuals because of the absence 
 of auxiliary aids and services, unless the entity can demonstrate that taking 
 such steps would fundamentally alter the nature of the good, service, 
 facility, privilege, advantage, or accommodation being offered or would 
 result in an undue burden; 
    (iv) a failure to remove architectural barriers, and communication 
 barriers that are structural in nature, in existing facilities, and 
 transportation barriers in existing vehicles and rail passenger cars used by 
 an establishment for transporting individuals (not including barriers that 
 can only be removed through the retrofitting of vehicles or rail passenger 
 cars by the installation of a hydraulic or other lift), where such removal is 
 readily achievable; and 
    (v) where an entity can demonstrate that the removal of a barrier under 
 clause (iv) is not readily achievable, a failure to make such goods, 
 services, facilities, privileges, advantages, or accommodations available 
 through alternative methods if such methods are readily achievable. 
    (B) FIXED ROUTE SYSTEM.-
    (i) ACCESSIBILITY.-It shall be considered discrimination for a private 
 entity which operates a fixed route system and which is not subject to 
 section 304 to purchase or lease a vehicle with a seating capacity in excess 
 of 16 passengers (including the driver) for use on such system, for which a 
 solicitation is made after the 30th day following the effective date of this 
 subparagraph, that is not readily accessible to and usable by individuals 
 with disabilities, including individuals who use wheelchairs. 
    (ii) EQUIVALENT SERVICE.-If a private entity which operates a fixed route 
 system and which is not subject to section 304 purchases or leases a vehicle 
 with a seating capacity of 16 passengers or less (including the driver) for 
 use on such system after the effective date of this subparagraph that is not 
 readily accessible to or usable by individuals with disabilities, it shall be 
 considered discrimination for such entity to fail to operate such system so 
 that, when viewed in its entirety, such system ensures a level of service to 
 individuals with disabilities, including individuals who use wheelchairs, 
 equivalent to the level of service provided to individuals without 
 disabilities. 
    (C) DEMAND RESPONSIVE SYSTEM.-For purposes of subsection (a), 
 discrimination includes-
    (i) a failure of a private entity which operates a demand responsive 
 system and which is not subject to section 304 to operate such system so 
 that, when viewed in its entirety, such system ensures a level of service to 
 individuals with disabilities, including individuals who use wheelchairs, 
 equivalent to the level of service provided to individuals without 
 disabilities; and 
    (ii) the purchase or lease by such entity for use on such system of a 
 vehicle with a seating capacity in excess of 16 passengers (including the 
 driver), for which solicitations are made after the 30th day following the 
 effective date of this subparagraph, that is not readily accessible to and 
 usable by individuals with disabilities (including individuals who use 
 wheelchairs) unless such entity can demonstrate that such system, when viewed 
 in its entirety, provides a level of service to individuals with disabilities 
 equivalent to that provided to individuals without disabilities. 
    (D) OVER-THE-ROAD BUSES.-
    (i) LIMITATION ON APPLICABILITY.-Subparagraphs (B) and (C) do not apply to 
 over-the-road buses. 
    (ii) ACCESSIBILITY REQUIREMENTS.-For purposes of subsection (a), 
 discrimination includes (I) the purchase or lease of an over-the-road bus 
 which does not comply with the regulations issued under section 306(a)(2) by 
 a private entity which provides transportation of individuals and which is 
 not primarily engaged in the business of transporting people, and (II) any 
 other failure of such entity to comply with such regulations. 
    (3) SPECIFIC CONSTRUCTION.-Nothing in this title shall require an entity 
 to permit an individual to participate in or benefit from the goods, 
 services, facilities, privileges, advantages and accommodations of such 
 entity where such individual poses a direct threat to the health or safety of 
 others. The term " direct threat" means a significant risk to the health or 
 safety of others that cannot be eliminated by a modification of policies, 
 practices, or procedures or by the provision of auxiliary aids or services. 

 SEC. 303. NEW CONSTRUCTION AND ALTERATIONS IN PUBLIC ACCOMMODATIONS AND
 COMMERCIAL FACILITIES.

    (a) APPLICATION OF TERM.-Except as provided in subsection (b), as applied 
 to public accommodations and commercial facilities, discrimination for 
 purposes of section 302(a) includes-
    (1) a failure to design and construct facilities for first occupancy later 
 than 30 months after the date of enactment of this Act that are readily 
 accessible to and usable by individuals with disabilities, except where an 
 entity can demonstrate that it is structurally impracticable to meet the 
 requirements of such subsection in accordance with standards set forth or 
 incorporated by reference in regulations issued under this title; and 
    (2) with respect to a facility or part thereof that is altered by, on 
 behalf of, or for the use of an establishment in a manner that affects or 
 could affect the usability of the facility or part thereof, a failure to make 
 alterations in such a manner that, to the maximum extent feasible, the 
 altered portions of the facility are readily accessible to and usable by 
 individuals with disabilities, including individuals who use wheelchairs. 
 Where the entity is undertaking an alteration that affects or could affect 
 usability of or access to an area of the facility containing a primary 
 function, the entity shall also make the alterations in such a manner that, 
 to the maximum extent feasible, the path of travel to the altered area and 
 the bathrooms, telephones, and drinking fountains serving the altered area, 
 are readily accessible to and usable by individuals with disabilities where 
 such alterations to the path of travel or the bathrooms, telephones, and 
 drinking fountains serving the altered area are not disproportionate to the 
 overall alterations in terms of cost and scope (as determined under criteria 
 established by the Attorney General). 
    (b) ELEVATOR.-Subsection (a) shall not be construed to require the 
 installation of an elevator for facilities that are less than three stories 
 or have less than 3,000 square feet per story unless the building is a 
 shopping center, a shopping mall, or the professional office of a health care 
 provider or unless the Attorney General determines that a particular category 
 of such facilities requires the installation of elevators based on the usage 
 of such facilities. 

 SEC. 304. PROHIBITION OF DISCRIMINATION IN SPECIFIED PUBLIC TRANSPORTATION
 SERVICES PROVIDED BY PRIVATE ENTITIES.

    (a) GENERAL RULE.-No individual shall be discriminated against on the 
 basis of disability in the full and equal enjoyment of specified public 
 transportation services provided by a private entity that is primarily 
 engaged in the business of transporting people and whose operations affect 
 commerce. 
    (b) CONSTRUCTION.-For purposes of subsection (a), discrimination includes-
    (1) the imposition or application by a entity described in subsection (a) 
 of eligibility criteria that screen out or tend to screen out an individual 
 with a disability or any class of individuals with disabilities from fully 
 enjoying the specified public transportation services provided by the entity, 
 unless such criteria can be shown to be necessary for the provision of the 
 services being offered; 
    (2) the failure of such entity to-
    (A) make reasonable modifications consistent with those required under 
 section 302(b)(2)(A)(ii); 
    (B) provide auxiliary aids and services consistent with the requirements 
 of section 302(b)(2)(A)(iii); and 
    (C) remove barriers consistent with the requirements of section 
 302(b)(2)(A) and with the requirements of section 303(a)(2); 
    (3) the purchase or lease by such entity of a new vehicle (other than an 
 automobile, a van with a seating capacity of less than 8 passengers, 
 including the driver, or an over-the-road bus) which is to be used to provide 
 specified public transportation and for which a solicitation is made after 
 the 30th day following the effective date of this section, that is not 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs; except that the new vehicle need not be 
 readily accessible to and usable by such individuals if the new vehicle is to 
 be used solely in a demand responsive system and if the entity can 
 demonstrate that such system, when viewed in its entirety, provides a level 
 of service to such individuals equivalent to the level of service provided to 
 the general public; 
    (4)(A) the purchase or lease by such entity of an over-the-road bus which 
 does not comply with the regulations issued under section 306(a)(2); and 
    (B) any other failure of such entity to comply with such regulations; and 
    (5) the purchase or lease by such entity of a new van with a seating 
 capacity of less than 8 passengers, including the driver, which is to be used 
 to provide specified public transportation and for which a solicitation is 
 made after the 30th day following the effective date of this section that is 
 not readily accessible to or usable by individuals with disabilities, 
 including individuals who use wheelchairs; except that the new van need not 
 be readily accessible to and usable by such individuals if the entity can 
 demonstrate that the system for which the van is being purchased or leased, 
 when viewed in its entirety, provides a level of service to such individuals 
 equivalent to the level of service provided to the general public; 
    (6) the purchase or lease by such entity of a new rail passenger car that 
 is to be used to provide specified public transportation, and for which a 
 solicitation is made later than 30 days after the effective date of this 
 paragraph, that is not readily accessible to and usable by individuals with 
 disabilities, including individuals who use wheelchairs; and 
    (7) the remanufacture by such entity of a rail passenger car that is to be 
 used to provide specified public transportation so as to extend its usable 
 life for 10 years or more, or the purchase or lease by such entity of such a 
 rail car, unless the rail car, to the maximum extent feasible, is made 
 readily accessible to and usable by individuals with disabilities, including 
 individuals who use wheelchairs. 
    (c) HISTORICAL OR ANTIQUATED CARS.-
    (1) EXCEPTION.-To the extent that compliance with subsection (b)(2)(C) or 
 (b)(7) would significantly alter the historic or antiquated character of a 
 historical or antiquated rail passenger car, or a rail station served 
 exclusively by such cars, or would result in violation of any rule, 
 regulation, standard, or order issued by the Secretary of Transportation 
 under the Federal Railroad Safety Act of 1970, such compliance shall not be 
 required. 
    (2) DEFINITION.-As used in this subsection, the term "historical or 
 antiquated rail passenger car" means a rail passenger car-
    (A) which is not less than 30 years old at the time of its use for 
 transporting individuals; 
    (B) the manufacturer of which is no longer in the business of 
 manufacturing rail passenger cars; and 
    (C) which-
    (i) has a consequential association with events or persons significant to 
 the past; or 
    (ii) embodies, or is being restored to embody, the distinctive 
 characteristics of a type of rail passenger car used in the past, or to 
 represent a time period which has passed. 

 SEC. 305. STUDY.

    (a) PURPOSES.-The Office of Technology Assessment shall undertake a study 
 to determine-
    (1) the access needs of individuals with disabilities to over-the-road 
 buses and over-the-road bus service; and 
    (2) the most cost-effective methods for providing access to over-the-road 
 buses and over-the-road bus service to individuals with disabilities, 
 particularly individuals who use wheelchairs, through all forms of boarding 
 options. 
    (b) CONTENTS.-The study shall include, at a minimum, an analysis of the 
 following: 
    (1) The anticipated demand by individuals with disabilities for accessible
 over-the-road buses and over-the-road bus service.
    (2) The degree to which such buses and service, including any service
 required under sections 304(b)(4) and 306(a)(2), are readily accessible to and
 usable by individuals with disabilities.
    (3) The effectiveness of various methods of providing accessibility to 
 such buses and service to individuals with disabilities. 
    (4) The cost of providing accessible over-the-road buses and bus service 
 to individuals with disabilities, including consideration of recent 
 technological and cost saving developments in equipment and devices. 
    (5) Possible design changes in over-the-road buses that could enhance 
 accessibility, including the installation of accessible restrooms which do 
 not result in a loss of seating capacity. 
    (6) The impact of accessibility requirements on the continuation of over-
 the-road bus service, with particular consideration of the impact of such
 requirements on such service to rural communities.
    (c) ADVISORY COMMITTEE.-In conducting the study required by subsection (a),
 the Office of Technology Assessment shall establish an advisory committee,
 which shall consist of-
    (1) members selected from among private operators and manufacturers of 
 over-the-road buses; 
    (2) members selected from among individuals with disabilities, 
 particularly individuals who use wheelchairs, who are potential riders of 
 such buses; and 
    (3) members selected for their technical expertise on issues included in 
 the study, including manufacturers of boarding assistance equipment and 
 devices. 
    The number of members selected under each of paragraphs (1) and (2) shall 
 be equal, and the total number of members selected under paragraphs (1) and 
 (2) shall exceed the number of members selected under paragraph (3). 
    (d) DEADLINE.-The study required by subsection (a), along with 
 recommendations by the Office of Technology Assessment, including any policy 
 options for legislative action, shall be submitted to the President and 
 Congress within 36 months after the date of the enactment of this Act. If the 
 President determines that compliance with the regulations issued pursuant to 
 section 306(a)(2)(B) on or before the applicable deadlines specified in 
 section 306(a)(2)(B) will result in a significant reduction in intercity 
 over-the-road bus service, the President shall extend each such deadline by 1 
 year. 
    (e) REVIEW.-In developing the study required by subsection (a), the Office 
 of Technology Assessment shall provide a preliminary draft of such study to 
 the Architectural and Transportation Barriers Compliance Board established 
 under section 502 of the Rehabilitation Act of 1973 (29 U.S.C. 792). The 
 Board shall have an opportunity to comment on such draft study, and any such 
 comments by the Board made in writing within 120 days after the Board's 
 receipt of the draft study shall be incorporated as part of the final study 
 required to be submitted under subsection (d). 

 SEC. 306. REGULATIONS.

    (a) TRANSPORTATION PROVISIONS.-
    (1) GENERAL RULE.-Not later than 1 year after the date of the enactment of 
 this Act, the Secretary of Transportation shall issue regulations in an 
 accessible format to carry out sections 302(b)(2)(B) and (C) and to carry out 
 section 304 (other than subsection (b)(4)). 
    (2) SPECIAL RULES FOR PROVIDING ACCESS TO OVER-THE-ROAD BUSES.-
    (A) INTERIM REQUIREMENTS-
    (i) ISSUANCE.-Not later than 1 year after the date of the enactment of 
 this Act, the Secretary of Transportation shall issue regulations in an 
 accessible format to carry out sections 304(b)(4) and 302(b)(2)(D)(ii) that 
 require each private entity which uses an over-the-road bus to provide 
 transportation of individuals to provide accessibility to such bus; except 
 that such regulations shall not require any structural changes in over-the-
 road buses in order to provide access to individuals who use wheelchairs 
 during the effective period of such regulations and shall not require the 
 purchase of boarding assistance devices to provide access to such 
 individuals. 
    (ii) EFFECTIVE PERIOD.-The regulations issued pursuant to this 
 subparagraph shall be effective until the effective date of the regulations 
 issued under subparagraph (B). 
    (B) FINAL REQUIREMENT.-
    (i) REVIEW OF STUDY AND INTERIM REQUIREMENTS.-The Secretary shall review 
 the study submitted under section 305 and the regulations issued pursuant to 
 subparagraph (A). 
    (ii) ISSUANCE.-Not later than 1 year after the date of the submission of 
 the study under section 305, the Secretary shall issue in an accessible 
 format new regulations to carry out sections 304(b)(4) and 302(b)(2)(D)(ii) 
 that require, taking into account the purposes of the study under section 305 
 and any recommendations resulting from such study, each private entity which 
 uses an over-the-road bus to provide transportation to individuals to provide 
 accessibility to such bus to individuals with disabilities, including 
 individuals who use wheelchairs. 
    (iii) EFFECTIVE PERIOD.-Subject to section 305(d), the regulations issued 
 pursuant to this subparagraph shall take effect-
    (I) with respect to small providers of transportation (as defined by the
 Secretary), 7 years after the date of the enactment of this Act; and
    (II) with respect to other providers of transportation, 6 years after such
 date of enactment.
    (C) LIMITATION ON REQUIRING INSTALLATION OF ACCESSIBLE RESTROOMS.-The
 regulations issued pursuant to this paragraph shall not require the
 installation of accessible restrooms in over-the-road buses if such
 installation would result in a loss of seating capacity.
    (3) STANDARDS.-The regulations issued pursuant to this subsection shall
 include standards applicable to facilities and vehicles covered by sections
 302(b)(2) and 304.
    (b) OTHER PROVISIONS.-Not later than 1 year after the date of the 
 enactment of this Act, the Attorney General shall issue regulations in an 
 accessible format to carry out the provisions of this title not referred to 
 in subsection (a) that include standards applicable to facilities and 
 vehicles covered under section 302. 
    (c) CONSISTENCY WITH ATBCB GUIDELINES.-Standards included in regulations 
 issued under subsections (a) and (b) shall be consistent with the minimum 
 guidelines and requirements issued by the Architectural and Transportation 
 Barriers Compliance Board in accordance with section 504 of this Act. 
    (d) INTERIM ACCESSIBILITY STANDARDS.-
    (1) FACILITIES.-If final regulations have not been issued pursuant to this 
 section, for new construction or alterations for which a valid and 
 appropriate State or local building permit is obtained prior to the issuance 
 of final regulations under this section, and for which the construction or 
 alteration authorized by such permit begins within one year of the receipt of 
 such permit and is completed under the terms of such permit, compliance with 
 the Uniform Federal Accessibility Standards in effect at the time the 
 building permit is issued shall suffice to satisfy the requirement that 
 facilities be readily accessible to and usable by persons with disabilities 
 as required under section 303, except that, if such final regulations have 
 not been issued one year after the Architectural and Transportation Barriers 
 Compliance Board has issued the supplemental minimum guidelines required 
 under section 504(a) of this Act, compliance with such supplemental minimum 
 guidelines shall be necessary to satisfy the requirement that facilities be 
 readily accessible to and usable by persons with disabilities prior to 
 issuance of the final regulations. 
    (2) VEHICLES AND RAIL PASSENGER CARS.-If final regulations have not been 
 issued pursuant to this section, a private entity shall be considered to have 
 complied with the requirements of this title, if any, that a vehicle or rail 
 passenger car be readily accessible to and usable by individuals with 
 disabilities, if the design for such vehicle or car complies with the laws 
 and regulations (including the Minimum Guidelines and Requirements for 
 Accessible Design and such supplemental minimum guidelines as are issued 
 under section 504(a) of this Act) governing accessibility of such vehicles or 
 cars, to the extent that such laws and regulations are not inconsistent with 
 this title and are in effect at the time such design is substantially 
 completed. 

 SEC. 307. EXEMPTIONS FOR PRIVATE CLUBS AND RELIGIOUS ORGANIZATIONS.

    The provisions of this title shall not apply to private clubs or 
 establishments exempted from coverage under title II of the Civil Rights Act 
 of 1964 (42 U.S.C. 2000-a(e)) or to religious organizations or entities 
 controlled by religious organizations, including places of worship. 

 SEC. 308. ENFORCEMENT.

    (a) IN GENERAL.-
    (1) AVAILABILITY OF REMEDIES AND PROCEDURES.-The remedies and procedures 
 set forth in section 204(a) of the Civil Rights Act of 1964 (42 U.S.C. 2000a-
 3(a)) are the remedies and procedures this title provides to any person who 
 is being subjected to discrimination on the basis of disability in violation 
 of this title or who has reasonable grounds for believing that such person is 
 about to be subjected to discrimination in violation of section 303. Nothing 
 in this section shall require a person with a disability to engage in a 
 futile gesture if such person has actual notice that a person or organization 
 covered by this title does not intend to comply with its provisions. 
    (2) INJUNCTIVE RELIEF.-In the case of violations of sections 
 302(b)(2)(A)(iv) and section 303(a), injunctive relief shall include an order 
 to alter facilities to make such facilities readily accessible to and usable 
 by individuals with disabilities to the extent required by this title. Where 
 appropriate, injunctive relief shall also include requiring the provision of 
 an auxiliary aid or service, modification of a policy, or provision of 
 alternative methods, to the extent required by this title. 
    (b) ENFORCEMENT BY THE ATTORNEY GENERAL.-
    (1) DENIAL OF RIGHTS.-
    (A) DUTY TO INVESTIGATE.-
    (i) IN GENERAL.-The Attorney General shall investigate alleged violations 
 of this title, and shall undertake periodic reviews of compliance of covered 
 entities under this title. 
    (ii) ATTORNEY GENERAL CERTIFICATION.-On the application of a State or 
 local government, the Attorney General may, in consultation with the 
 Architectural and Transportation Barriers Compliance Board, and after prior 
 notice and a public hearing at which persons, including individuals with 
 disabilities, are provided an opportunity to testify against such 
 certification, certify that a State law or local building code or similar 
 ordinance that establishes accessibility requirements meets or exceeds the 
 minimum requirements of this Act for the accessibility and usability of 
 covered facilities under this title. At any enforcement proceeding under this 
 section, such certification by the Attorney General shall be rebuttable 
 evidence that such State law or local ordinance does meet or exceed the 
 minimum requirements of this Act. 
    (B) POTENTIAL VIOLATION.-If the Attorney General has reasonable cause to 
 believe that-
    (i) any person or group of persons is engaged in a pattern or practice of 
 discrimination under this title; or 
    (ii) any person or group of persons has been discriminated against under 
 this title and such discrimination raises an issue of general public 
 importance, 
    the Attorney General may commence a civil action in any appropriate United 
 States district court. 
    (2) AUTHORITY OF COURT.-In a civil action under paragraph (1)(B), the 
 court-
    (A) may grant any equitable relief that such court considers to be 
 appropriate, including, to the extent required by this title-
    (i) granting temporary, preliminary, or permanent relief; 
    (ii) providing an auxiliary aid or service, modification of policy,
 practice, or procedure, or alternative method; and
    (iii) making facilities readily accessible to and usable by individuals 
 with disabilities; 
    (B) may award such other relief as the court considers to be appropriate,
 including monetary damages to persons aggrieved when requested by the Attorney
 General; and
    (C) may, to vindicate the public interest, assess a civil penalty against
 the entity in an amount-
    (i) not exceeding $50,000 for a first violation; and
    (ii) not exceeding $100,000 for any subsequent violation.
    (3) SINGLE VIOLATION.-For purposes of paragraph (2)(C), in determining 
 whether a first or subsequent violation has occurred, a determination in a 
 single action, by judgment or settlement, that the covered entity has engaged 
 in more than one discriminatory act shall be counted as a single violation. 
    (4) PUNITIVE DAMAGES.-For purposes of subsection (b)(2)(B), the term " 
 monetary damages" and "such other relief" does not include punitive damages. 
    (5) JUDICIAL CONSIDERATION.-In a civil action under paragraph (1)(B), the 
 court, when considering what amount of civil penalty, if any, is appropriate, 
 shall give consideration to any good faith effort or attempt to comply with 
 this Act by the entity. In evaluating good faith, the court shall consider, 
 among other factors it deems relevant, whether the entity could have 
 reasonably anticipated the need for an appropriate type of auxiliary aid 
 needed to accommodate the unique needs of a particular individual with a 
 disability. 

 SEC. 309. EXAMINATIONS AND COURSES.

    Any person that offers examinations or courses related to applications, 
 licensing, certification, or credentialing for secondary or postsecondary 
 education, professional, or trade purposes shall offer such examinations or 
 courses in a place and manner accessible to persons with disabilities or 
 offer alternative accessible arrangements for such individuals. 

 SEC. 310. EFFECTIVE DATE.

    (a) GENERAL RULE.-Except as provided in subsections (b) and (c), this 
 title shall become effective 18 months after the date of the enactment of 
 this Act. 
    (b) CIVIL ACTIONS.-Except for any civil action brought for a violation of 
 section 303, no civil action shall be brought for any act or omission 
 described in section 302 which occurs-
    (1) during the first 6 months after the effective date, against businesses 
 that employ 25 or fewer employees and have gross receipts of $1,000,000 or 
 less; and 
    (2) during the first year after the effective date, against businesses 
 that employ 10 or fewer employees and have gross receipts of $500,000 or 
 less. 
    (c) EXCEPTION.-Sections 302(a) for purposes of section 302(b)(2)(B) and 
 (C) only, 304(a) for purposes of section 304(b)(3) only, 304(b)(3), 305, and 
 306 shall take effect on the date of the enactment of this Act. 

