/*nfbtrans.c converted from Pascal to C by Randy formenti N8KL*/
/*internet rcf@genrad.com */
/*November 28, 1992*/
/*Ammended to by Brian Buhrow in order to use under the Unix operating
system*/
/*$Log: nfbtrans.c,v $
 * Revision 1.4  1993/07/09  08:00:00  formenti
 *Added several options ip= sp= i0-i5= and ex=
 *Added formatting commands ~% ~4 ~5 and ~[
 *Added support for wildcard characters in DOS
 *rejoins hyphenated words
 *
 * Revision 1.3  1993/05/18  06:09:50  buhrow
 * 	Just changed RCSID code to show actual revision.
 *
 * Revision 1.2  1993/05/18  06:06:48  buhrow
 * 	Added the ability to translate with a centrally located translation table
 * , or, if one prefers, one can set the NFBTAB environment variable to point
 * to a valid translation table and use that instead.
 **/
#ifndef unix
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__) || defined(__COMPACT__) || defined(__LARGE__)
#define TURBOC     /* turbo C++ 3.0 or later */
#endif             /* TURBOC */
#define LINT_ARGS
#define DOS
#endif             /* unix */
#ifndef lint
char RCSID[] = "$Id: nfbtrans.c,v 1.3 1993/05/18 06:09:50 buhrow Exp buhrow $";
#endif             /* lint */
#include        <stdio.h>
#ifdef DOS
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <conio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#else
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#endif             /* DOS */
#include <malloc.h>
#ifdef DOS
#include <memory.h>
#include <process.h>
#endif             /* DOS */
#include <time.h>

#ifdef unix
#define CONFIG_FILE "nfbtrans.cnf"      /* For us Unix types who hate
                                         * uppercase */
#define MAXPATHLEN 1023 /* For the longest possible pathname */
#define O_BINARY 0 /* We don't need it here */
/*Definition of mode bits for open*/
#ifndef S_ISUID    /* If we've seen this before, no redefinition */
#define S_ISUID 04000   /* set User id on execution */
#define S_ISGID 02000   /* set Group id on execution */
#define S_ISVTX 01000   /* save text image after termination */
#define S_IREAD 00400   /* read by owner */
#define S_IWRITE 00200  /* write by owner */
#define S_IEXEC 00100   /* execute by owner */
#endif             /* The following are not usually defined */
#define S_GREAD 00040   /* read by group */
#define S_GWRITE 00020  /* write by group */
#define S_GEXEC 00010   /* execute by group */
#define S_WREAD 00004   /* read by world */
#define S_WWRITE 00002  /* write by world */
#define S_WEXEC 00001   /* execute by world */
#define STD_OPEN S_IWRITE | S_IREAD | S_GWRITE | S_GREAD | S_WWRITE | S_WREAD
#define delay(a) delay_unix(a)
#define FOPEN_READ "r"
#define FOPEN_WRITE "w"
#else              /* DOS */
#define CONFIG_FILE "NFBTRANS.CNF"      /* For those DOS heades */
#define STD_OPEN S_IWRITE       /* Standard DOs open */
#define MAXPATHLEN 127  /* for the longest possible path name in DOS */
#define FOPEN_READ "rt"
#define FOPEN_WRITE "wt"
#endif             /* unix */

/*defines and defaults*/
#ifdef DOS
#define 	VERSION 	"DOS Version 7.17, August 24, 1993"
#else              /* unix */
#define VERSION "Unix Version 7.17, August 24, 1993"
#endif             /* DOS */

#define COPYRIGHT "Copyright National Federation of the Blind, 1983-1993"
#define MAX_MATCH 15
#define MAX_REP 10
#define MAXTAB		1200    /* number of entries in binary table of
                                 * braille rules */
#define TABLENAME "braille.tab" /* for DOS, or Unix */
#define MAX_FILES 50    /* max # of files stored using wildcard spec in dos */
#define MAX_EXTENSIONS 30       /* # of extensions for auto format */
#define TRUE 1
#define FALSE 0
#define BUFSIZE 2048
#define GRADE0 0
#define GRADE1 1
#define GRADE2 2
#define GRADE3 3
#define POETRY 1
# define TEXT 2
#define BLOCK 3
#define LISTS 4
#define BLOCK_PARA 5
#define UPPER 2
#define LOWER 1
#define NUMERIC 4
#define NOTRANS 8

/*global variables*/
char temp[160];
int paramcount;
char **paramstr;
char *options[46] =/* all allowed options alphabetically */
{"CF", "CL", "CO", "CS", "DB", "DE", "DS", "EX", "FP", "FS", "FX", "HK", "I0", "I1", "I2",
  "I3", "I4", "I5", "I6", "I7", "I8", "I9", "IP", "LM", "LS", "MM", "NC", "OW",
  "PA", "PD", "PE", "PF", "PL", "PS", "PW", "S0", "SO", "SP", "ST", "TF", "TM", "TP", "TV",
NULL};
char *main_menu[3] = {
  "  1 - Translate a Text File\n",
  "  2 - Emboss a File that has already been Translated\n",
"  3 - Back Translate a Grade Two file\n"};
char *call_prefix[12] =
{"KA", "KB", "KC", "KD", "K", "N", "WA", "WB", "WD", "W", "VE", NULL};
char *token_names[14] = /* used in external format language */
{"D", "T", "L", "SK", "C", "IND", "PAG", "FIE", "O", "ST", "A", "MAT", NULL};
short token_vals[14] =  /* values for tokens above */
{1, 2, 3, 4, 5, 6, 80, 100, 101, 102, 199, 202, 999};
char *stateid[60] =
{"AK\000Alaska", "AL\000Alabama", "AR\000Arkansas",
  "AZ\000Arizona", "AS\000American Samoa", "CA\000California",
  "CO\000Colorado", "CT\000Connecticut", "CZ\000Canal Zone",
  "DC\000District of Columbia", "DE\000Delaware", "FL\000Florida",
  "GA\000Georgia", "GU\000Guam", "HI\000Hawaii",
  "ID\000Idaho", "IL\000Ilinois", "IN\000Indiana",
  "IA\000Iowa",
  "KS\000Kansas", "KY\000Kentucky", "LA\000Lousiana", "ME\000Maine",
  "MD\000Maryland", "MA\000Massachusetts", "MI\000Michigan",
  "MN\000Minnesota", "MS\000Mississippi", "MO\000Missouri",
  "MT\000Montana", "NE\000Nebraska", "NV\000Nevada",
  "NH\000New Hampshire", "NJ\000New Jersey", "NM\000New Mexico",
  "NY\000New York", "NC\000North Carolina", "ND\000North Dakota",
  "CN\000Northern Mariana Is", "OH\000Ohio", "OK\000Oklahoma",
  "OR\000Oregon", "PA\000Pennsylvania", "PR\000Puerto Rico",
  "RI\000Rhode Island", "SC\000South Carolina", "SD\000South Dakota",
  "TN\000Tennessee", "TT\000Trust Territories", "TX\000Texas",
  "UT\000Utah", ",VT\000Vermont", "VA\000Virginia",
  "VI\000Virgin Islands", "WA\000Washington", "WV\000West Virginia",
"Wi\000Wisconsin", "WY\000Wyoming"};

typedef short BOOL;

/*globals for buffered read*/
char iobuf[BUFSIZE + 1];
unsigned int bytes_in_buf;
char *ioptr, *eolptr;
short timer = 0xe00;    /* default delay timing value only if linked with
                         * nfbasm.asm */
short emboss_delay = 0;
short hot_key = 0; /* no hot keys by default */
short max_menu = 2;/* 2 options printed on main uenu */
short ab_flag = 0; /* abort */
short stdin_tty = 0, stdout_tty = 0;    /* is stdin or stdout 1 keyboard or 0
                                         * file */
short print_date = 0, print_file = 0;   /* prints date and file on first page
                                         * if true */
short spool = 0, charspersec = 40;
short prog_init;
short file_count, current_file;
struct tm *tm;

typedef struct
{
  unsigned short lstart;
  unsigned short lend;
  BOOL lflag;
  short fopstart;
  short fopcount, lopcount;
}   loptype;

typedef struct
{
  unsigned char fop;    /* operation */
  short fstart;    /* field start */
  short flen;      /* field length */
  short fappo;     /* pointer to data */
}   foptype;

typedef struct
{                  /* holds binary form of braille rules */
  short start1[256];
  short start2[27][27];
  short typex[MAXTAB + 1];
  char match[MAXTAB + 1][MAX_MATCH + 1];
  char replace[MAXTAB + 1][MAX_REP + 1];
}   tablet;

typedef struct
{
  char ext[4];
  short init_val;
}   extension_t;

typedef struct
{
  short total;
  extension_t prog_ext[MAX_EXTENSIONS];
}   prog_ext_t;
prog_ext_t prog_extension;

typedef struct
{
  char pre_init[20], post_init[20], format[4];
}   init_t;
init_t init[10];   /* for i0 - i9 */

short statecount = 58;
BOOL usr_default = FALSE;
short pagestart = 0, pageend = -1;
char fiel[256];
char *field = fiel;
short count, copies, lastcopy = 0;
short bpagec;
char token[100][40];
short tcount;
short tcur;
short fopcount, lopcount;
short lineskips = 99, linesperpage = 25;
short maxline = 0, make_sound = 1;
short display_braille = -1;
short display_source = -1;
BOOL printit = TRUE;
short skip_output = 0, over_write = 0;
short table_entries;
BOOL no_copyright = FALSE;      /* display copyright by default */
short leftmargin = -1;
short capvec[256], subvec[256];
short trans_mode = -1;
short pause_time = 0;
long total_words, total_dots[8], total_cells, total_lines;
time_t time1, time2;
long in_length, out_length, total = 0l;
BOOL usetemplate = FALSE;
char inf_name[MAXPATHLEN] = {0};
char inf_name_ext[10];
char file_name[MAX_FILES][13];
int outf_des = 0;;
FILE *intext = NULL, *lfile;
int inf_des;
char outf_name[49] = {0};
char filetemp[49];
typedef foptype INTER_ARR8[40];
INTER_ARR8 f;
char appdat[40][41];
short appcount, lcount, temperror;
BOOL lopactive = FALSE;
unsigned short inpglen = 66;    /* input page length */
char transpath[81] = {0};
char table_file[MAXPATHLEN + 1];
char stat_file[20] = {0};
char config_file[20] = {CONFIG_FILE};
char indent[30] = {"  "};
char format_string[4] = {"^~"};
char date_string[20];
char *dayofweek[7] = {"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
char s0_init[20] = {0};
typedef loptype INTER_ARR10[40];
static INTER_ARR10 l;
unsigned char dot_table[128] = {        /* braille dot equivilent for each
                                         * ascii char, used in statistics
                                         * file */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 0-15 b0 = dot
                                                         * 1, b1 = dot 2 ... */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 16-31 */
  0, 46, 16, 60, 43, 41, 47, 4, 55, 62, 33, 44, 32, 36, 40, 12, /* / ascii 32-47 */
  52, 2, 6, 18, 50, 34, 22, 54, 38, 20, 49, 48, 35, 63, 28, 57, /* ? ascii 48-63 */
  8, 65, 67, 73, 89, 81, 75, 91, 83, 74, 90, 69, 71, 77, 93, 75,        /* @-O */
  79, 95, 87, 78, 94, 101, 103, 122, 109, 125, 117, 42, 51, 59, 24, 56, /* _ */
  0, 1, 3, 9, 25, 17, 11, 27, 19, 10, 26, 5, 7, 13, 29, 21,     /* 96-o */
  15, 31, 23, 14, 30, 37, 39, 58, 45, 61, 53, 0, 0, 0, 0, 0,    /* p-127 */
};
unsigned char graph_tab[128] = {
  /* converts ascii representation of braille to ibm graphic characters */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 0-15 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 16-31 */
  32, 221, 189, 163, 196, 211, 219, 0, 224, 208, 220, 201, 190, 173, 251, 175,  /* 32-47 ' */
  162, 172, 0, 186, 174, 206, 161, 0, 191, 170, 215, 223, 0, 198, 193, 212,     /* 63 27< */
  0, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, /* 64-79 @ */
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 188, 197, 252, 253     /* 80-95 */
};

char bnumber[] = {"jabcdefghi"};        /* lowercase for 8 dot braille */
tablet *b = NULL;
/*variables for do_translate*/
BOOL done;
BOOL endfile;
char oldword[256];
char oldline[256];
char oldline6[256];
char tline[256];
char fline[256];
char hline[256];
char bline[256];
char bline6[256];
char lline[256];
char wline[256];
short blinec;
short bpageb;
short bpageh;
short linelength;
short center_length = 30;
short first_page = FALSE;
short curmax;

char c;
char words[81];
char bword[81];
char bword6[81];

BOOL join;
BOOL group;
BOOL pjoin;
BOOL pgroup;
BOOL hyphen;
BOOL phyphen;
BOOL xjoin;
BOOL xgroup;
BOOL xpjoin;
BOOL xpgroup;
BOOL xhyphen;
BOOL xphyphen;

int xgrade = -1, grade_mod = 0;
BOOL xcenter;
short xformat = -1;
short blank_lines;
BOOL xdouble;
BOOL xtab;
BOOL xacronym;
BOOL xheading;
BOOL xfooting;
BOOL makefoot;
BOOL makehead;
BOOL fillit;

BOOL quoteopen, quoteclose;

short margin, point, firstletter, chardec, lastmatch;
char linein[256], *plinein;
unsigned short lineinct;
BOOL newline;
short quotecount;
BOOL dopagenum = -1;
BOOL doroman;
BOOL dobook;
unsigned char tabtable[256];
BOOL disablecol;
short setmargin, oldmargin;
BOOL tabmargin;
BOOL pageset;
char addchar[11];
short actualpage;
short interpoint = FALSE;
char *roman[10] =
{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
char *roman10[10] = {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};

#ifdef DOS
struct find_t fileinfo; /* wildcard support for dos */
#endif             /* DOS */

/*function prototypes*/
void top_of_form(void);
void backspace_int(short);
void dofillit(void);
void make_roman(void);
void make_arabic(short *);
void make_book(void);
void bpurge(void);
void build_line(void);
void test_purge(void);
void add_case(void);
void add_dots(char *);
short get_integer(char *);
void get_digit(void);
void get_date(void);
void do_commands(void);
void do_lop_op(short, short, short, short);
void do_lop(void);
void getline(void);
void get_input(char *, short);
void check_purge(void);
void get_word(void);
void set_vect(void);
void do_letter(void);
void do_number(void);
void do_punct(void);
void build_word(void);
void check_ham_call(void);
void trans_word(void);
BOOL get_token(void);
void pop_tok(char *);
short check_token(char *);
void do_ops(void);
void do_template(void);
void do_translate(void);
void do_stat(void);
void advance_page(void);
void load_tables(void);
void translate_file(void);
void backtranslate_file(void);
short test_extension(char *);
#ifndef TURBOC
void delay(int);
void sound(int);
void nosound(void);
#endif
void emboss_file(void);
void get_copies(void);
void get_page_range(void);
void get_config(void);
void process_options(char *);
void trim(char *);
short strpos(char *, char *);
void insert(char *, char *, short);
void move(char *, char *, short);
void do_pause(void);
void write_string(char *);
void write_char(char);
void no_space(void);
void sort_names(void);
void copy_string(char *, char *, short);
void main(int, char **);
#ifdef unix
extern char *strlwr(char *string);
extern char *strupr(char *string);
extern short getch(void);
extern short getche(void);
extern long filelength(int descriptor);
extern short beep(int count);
extern void delay(int count);
extern short kbhit(void);
extern void get_tablename(char *string);
#endif             /* unix */

void top_of_form()
{
  short i;
  BOOL dopagesave = dopagenum;
  actualpage++;
  bpagec++;
  if (bpagec > pageend)
  {
    done = TRUE;
    bline[0] = bline6[0] = bword[0] = 0;
    return;
  }
  if (bpagec > pagestart)
  {                /* page in range */
    if (lineskips < 99)
      for (i = 0; i < lineskips + linesperpage - blinec; i++)
      {            /* i */
        write_string(" ");
        if (display_braille)
          printf("\n");
      }            /* i */
    else
    {
      if (lineskips == 99)
        write_char(12); /* formfeed */
      else
      {
        if (lineskips == 999)
          write_string("\13");
        else
        if (lineskips == 9999)
        {          /* 9999 */
          write_string("\14");
          printf("\nTo Continue, Press Return\7");
          getch();
        }          /* 9999 */
      }
    }
  }                /* page in range */
/*if interpoint mode do not print even page numbers*/
  if (interpoint && (bpagec & 1) == 0)
    dopagenum = FALSE;
  if (dopagenum && ((bpagec > 1 - (first_page > 0)) || pageset) && !xheading)
    linelength = curmax - 6 - margin - (short) strlen(addchar);
  else
    linelength = curmax + 1 - margin;
  if (xcenter)
    linelength = center_length;
  dopagenum = dopagesave;

  blinec = 0;
  if (make_sound)
  {
#ifndef unix
    sound(2000);
    delay(30);
    nosound();
#else
    beep(1);       /* Beep terminal */
#endif             /* unix */
  }
  if (display_braille)
  {                /* display_braille */
    sprintf(wline, "Copy %d of %d   page %d", copies, lastcopy, bpagec);
    strcpy(temp, wline);
    i = ((short) strlen(wline) - maxline) >> 1;
    if (i > 0)
    {
      memset(field, 32, maxline);
      strnset(field, '*', i);
      field[i] = 0;
      sprintf(wline, "%s%s%s", field, temp, field);
    }
    printf("%s\n", wline);
  }                /* display_braille */
  else
  if (!skip_output)
  {
    if (bpagec < pagestart)
      printf("Skipping");
    else
      printf("On");
    printf(" page %d  Copy %d of %d\n", bpagec, copies, lastcopy);
  }

  if (printit)
    delay(emboss_delay);
}                  /* top_of_form */

void backspace_int(short j)
{                  /* output a packspace so cursor is at first number of
                    * integer */
  do
  {
    j /= 10;
    fprintf(stderr, "%c", 8);
  }
  while (j > 0);
}                  /* backspace_int */

void dofillit()
{
  int j;
  fillit = FALSE;
  j = strlen(bline) - 1;
  if (j <= 0)
    return;
  /* find out where last word on bline begins */
  while (bline[j] != ' ' && j > 1)
    j--;
  strcpy(field, bline + j + 1); /* store the last word of bline */
  memset(bline + j, '\42', curmax - j); /* fill with quotes dot 5 */
  bline[j] = ' ';
  j = maxline - margin - strlen(field);
  strcpy(bline + j, field);
  bline[j - 1] = ' ';
}                  /* dofillit */

void make_roman()
{
  if (bpagec >= 100)
    make_arabic(&bpagec);
  else
    sprintf(field, "%s%s", roman10[bpagec / 10], roman[bpagec % 10]);
}                  /* make_roman */

void make_arabic(short *page)
{
  short i;
  sprintf(field, "#%d", *page);
  i = 1;
  while (field[i])
  {
    field[i] = bnumber[(short) (field[i] - (char) 48)];
    i++;
  }                /* while */
  if (page == &bpagec)
    strcat(field, addchar);
}                  /* make_arabec */

void make_book()
{
  field++;         /* make room for possible character at beginning */
  make_arabic(&bpageb);
  field--;         /* put pointer back where it was */
  if (bpagec - bpageh > 1)
    field[0] = (char) ((int) ('A') + bpagec - 2 - bpageh);
  else
    strcpy(field, field + 1);   /* remove first char of field */
}                  /* make_book */

void bpurge()
{
  short j;
  BOOL dopagesave = dopagenum;
  blinec++;        /* increment current braille line */

  if (bline[0])
  {                /* bline not empty */
    if (strlen(bline6) > strlen(bline))
      strcpy(bline, bline6);
    bline[curmax] = 0;  /* set bline to <curmax chars long */

    if (margin > 1)
    {              /* insert space before left margin */
      move(bline, bline + margin - 1, curmax + 1 - margin);
      /* insert space in front of line is necessary */
      memset(bline, 32, margin - 1);    /* fill in left margin with spaces */
    }              /* insert space before left margin */
  }                /* bline not empty */

  if (xcenter)
  {                /* center */
    trim(bline);
    j = (curmax - (short) strlen(bline)) >> 1;
    if (j > 0)
    {
      move(bline, bline + j, (short) strlen(bline));
      memset(bline, 32, j);
    }
    if (newline)
      xcenter = FALSE;
  }                /* center */

  if (fillit && newline)
    dofillit();

  if (blinec == 1)
  {                /* first line on this page */
    field[0] = 0;
    if (interpoint && (bpagec & 1) == 0)
      dopagenum = FALSE;        /* no even page numbers for interpoint */
    if (((bpagec > 1 - (first_page > 0)) || pageset || dobook) && dopagenum)
    {              /* store braille page number in field */
      if (doroman)
        make_roman();
      else
      if (dobook)
        make_book();
      else
        make_arabic(&bpagec);
    }              /* store braille page number in field */
    dopagenum = dopagesave;
    if (xheading)
    {              /* xheading */
      strcpy(hline + strlen(hline) - strlen(field), field);
      if (bpagec >= pagestart)
      {            /* output */
        if (display_braille)
          printf("%s\n", hline);
        write_string(hline);
      }            /* output */
      blinec++;
    }              /* xheading */
    else
    {              /* not xheading */
      j = (short) strlen(bline);
      memset(bline + j, 32, maxline - j);
      strcpy(bline + maxline - strlen(field), field);
    }              /* not xheading */
  }                /* first line on page */

  if (dobook && blinec >= linesperpage)
  {                /* put braille page in lower right corner */
    make_arabic(&bpagec);
    j = (short) strlen(bline);
    memset(bline + j, 32, maxline - j);
    strcpy(bline + maxline - strlen(field), field);
  }                /* put braille page number in lower right corner. */

  if (bpagec >= pagestart)
  {                /* output */
    if (display_braille)
      printf("%s\n", bline);
    if (!bline[0])
      strcpy(bline, " ");
    write_string(bline);
  }                /* output */
  if (xdouble && (bpagec >= pagestart))
  {
    write_string(" ");
    blinec++;
  }

  bline[0] = bline6[0] = 0;
  if (!(xformat == TEXT) || fillit)
    strcat(bline, indent);
  if (xformat == BLOCK || xformat == BLOCK_PARA)
    bline[0] = 0;
  strcpy(bline6, bline);
  pjoin = FALSE;
  pgroup = FALSE;
  if (xfooting && (blinec >= linesperpage - 1))
  {                /* put footing on bottom of current page */
    if (dobook)
    {              /* adjust footing for braille page in lower right corner */
      make_arabic(&bpagec);
      strcpy(oldline, fline);   /* save fline */
      strcpy(fline, fline + strlen(field) + 1);
      sprintf(fline + strlen(fline), " %s", field);
    }              /* adjust footing for braille page in lower right corner */
    if (bpagec >= pagestart)
    {              /* output */
      write_string(fline);
      if (display_braille)
        printf("%s\n", fline);
    }              /* output */
    if (dobook)
      strcpy(fline, oldline);
    blinec++;
  }                /* put footing on bottom of current page */
  if (blinec >= linesperpage)
    top_of_form();
  else
  if (dobook && (blinec >= linesperpage - 1) && !xfooting)
    linelength = curmax - 6 - margin;
  else
    linelength = curmax + 1 - margin;
  if (xcenter)
    linelength = center_length;
  newline = FALSE;
}                  /* bpurge */

void build_line()
{
  short i, j, r;
  i = (short) strlen(bline);
  if (xtab)
  {                /* xtab */
    j = r = 0;
    do
    {
      r++;
      if (tabtable[i + r] != 0)
        j = r;     /* found tab */
    }
    while (j == 0 && (i + r < linelength));

    if (!j)
      j = 1;
    for (r = 1; r < j; r++)
    {
      strcat(bline, " ");
      strcat(bline6, " ");
    }
    pjoin = FALSE;
    pgroup = FALSE;
    phyphen = FALSE;
    xtab = FALSE;
  }                /* xtab */

  if (!(phyphen || pjoin || (pgroup && group)))
    i++;           /* account for space */
  j = i + (short) strlen(bword6);
  i += (short) strlen(bword);

  if (((i > linelength) || (j > linelength)) ||
      (fillit && ((i > linelength - 6) || (j > linelength - 6))))
    bpurge();

  if (pjoin || (pgroup && group) || (strcmp(bword, "1") == 0 && xgrade > 0)
      || (strlen(bline) == 0) || phyphen)
  {
    sprintf(bline6, "%s%s", bline, bword6);
    strcat(bline, bword);
  }
  else
  if (bline[strlen(bline) - 1] == ' ')
  {
    sprintf(bline6, "%s%s", bline, bword6);
    strcat(bline, bword);
  }
  else
  {
    sprintf(bline6, "%s %s", bline, bword6);
    sprintf(bline + strlen(bline), " %s", bword);
  }

  if (!strcmp(bline, "BE"))
    if (xgrade > 1)
      strcpy(bline, "2");       /* braille for be */
  bword6[0] = 0;
  pgroup = group;
  pjoin = join;
  phyphen = hyphen;
}                  /* build_line */

void test_purge()
{
  short i, j = -1;
  for (i = 0; bline[i] != '\0'; i++)
    if (bline[i] != ' ')
      j = i;
  if (j >= 0)      /* bline contains a nonspace char, so flush it */
    bpurge();
}                  /* test_purge */

short get_integer(char *string)
{                  /* returns integer from string and removes digits. 18hello
                    * becomes hello returning 18 */
  short j = 0, retval = 0;
  while (isdigit(string[j]))
  {
    retval = 10 * retval + (short) (string[j] - (char) 48);
    j++;
  }                /* while */
  if (j)
    strcpy(string, string + j); /* remove digits */
  return (retval);
}                  /* get_integer */

void get_digit()
{
  if (hot_key)
  {
    temp[1] = 0;
    temp[0] = (char) getche();
    if (temp[0] <= '\r')
      temp[0] = 0;
    if (temp[0] == (char) 27)
    {              /* escape */
      fprintf(stderr, "\n");
      exit(0);
    }              /* escape */
  }
  else
    get_input(temp, 80);
}                  /* get_digit */

void get_date()
{                  /* stores date in date_string */
  time(&time1);
  tm = localtime(&time1);
  sprintf(date_string, "%s %02d/%02d/%02d %02d:%02d",
          dayofweek[tm->tm_wday], tm->tm_mon + 1, tm->tm_mday, tm->tm_year,
          tm->tm_hour, tm->tm_min);
}                  /* get_date */

void add_dots(char *string)
{
  int dot, i = 0, j;
  while (string[i])
  {
    dot = dot_table[(int) string[i]];
    if (xgrade)
      dot &= 63;   /* remove dot 7 unless we're doing computer braille */
    total_cells++;
    for (j = 0; j < 7; j++)
    {
      if (dot & 1)
        total_dots[j]++;
      dot = dot >> 1;
    }              /* j */
    i++;
  }                /* while */
}                  /* add_dots */
void add_case()
{
  short i, j = 0;
  BOOL show_caps = TRUE, show_lower = FALSE;
  for (i = 0; words[i]; i++)
  {
    if (isupper(words[i]) && show_caps)
    {              /* add comma */
      bword[j++] = ',';
      if (isupper(words[i + 1]))
      {            /* add another comma */
        bword[j++] = ',';
        show_caps = FALSE;
        show_lower = TRUE;
      }            /* add another comma */
    }              /* add a comma */
    if (islower(words[i]) && show_lower)
    {
      bword[j++] = ';';
      show_lower = FALSE;
    }
    bword[j++] = words[i];
  }                /* i */
  bword[j] = 0;
}                  /* add_case */

void do_commands()
{
  short tilpos, i, j;
  char c, *cptr;
  if ((cptr = strpbrk(words, format_string)) == NULL)
    return;        /* no format commands in word */
  newline = TRUE;

  tilpos = 1 + (short) (cptr - words);
  if (words[tilpos])    /* theres a character after the tilda */
    do
    {
      c = (char) toupper(words[tilpos]);        /* the character after the ~ */
      if (!strchr("ILZj[", c))
        strcpy(words + tilpos - 1, words + tilpos + 1); /* for every char except
                                                         * ILZ[ */

      switch (c)
      {
      case 'A':   /* Acronym Logic - Betty Desimone */
        xacronym = TRUE;
        newline = FALSE;
        break;
      case 'B':   /* Textbook Break */
        doroman = FALSE;
        dobook = TRUE;
        bpageh = bpagec;        /* set to current page */
        if (blinec < linesperpage)
          bpageh--;
        bpageb = get_integer(words);
        if (!bpageb)
          bpageb = 1;   /* set to 1 if invalid integer */
        test_purge();
        memset(tline, '-', maxline);    /* dots 3/6 */
        i = maxline;
        make_arabic(&bpageb);
        strcpy(tline + maxline - strlen(field), field); /* put page num at end
                                                         * of line */
        if (blinec > 1 && blinec < linesperpage - 1)
        {
          if (bpagec >= pagestart)
          {        /* page in range */
            write_string(tline);
            if (display_braille)
              printf("%s\n", tline);
          }        /* page in range */
          blinec++;
        }
        else
          linelength = curmax - 6 - margin;
        break;
      case 'C':   /* Center */
        newline = TRUE;
        test_purge();
        xcenter = TRUE;
        if (center_length > (short) (curmax - 6))
          center_length = (short) (curmax - 6);
        linelength = center_length;
        break;
      case 'D':   /* Double Toggle */
        xdouble ^= xdouble;
        break;
      case 'E':   /* Poetry */
        test_purge();
        xformat = POETRY;
        break;
      case 'F':   /* Fill Line - Index table of contents */
        test_purge();
        fillit = TRUE;
        break;
      case 'G':   /* Set Right Margin */
        i = curmax;
        curmax = get_integer(words);
        if (curmax < 1)
          curmax = 1;
        if (curmax > maxline)
          curmax = maxline;
        linelength = curmax + 1 - margin;
        break;
      case 'H':   /* Heading */
        strcpy(oldline, bline);
        strcpy(oldline6, bline6);
        xheading = TRUE;
        xpgroup = pgroup;
        xpjoin = pjoin;
        xjoin = join;
        xgroup = group;
        xhyphen = hyphen;
        xphyphen = phyphen;
        makehead = TRUE;
        bline[0] = 0;
        bline6[0] = 0;
        pgroup = FALSE;
        group = FALSE;
        join = FALSE;
        pjoin = FALSE;
        break;
      case 'I':   /* Italics */
        words[tilpos] = '_';
        if (tilpos > 1)
        {          /* >=1 char before ~ */
          if (isalpha(words[tilpos - 2]))
            words[tilpos - 1] = '-';
          else
            strcpy(words + tilpos - 1, words + tilpos);
        }
        else
          strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case 'J':   /* Stop Heading */
        xheading = FALSE;
        break;
      case 'K':   /* Stop Footing */
        xfooting = FALSE;
        break;
      case 'L':   /* Letter Sign */
        words[tilpos] = '\\';
        strcpy(words + tilpos - 1, words + tilpos);
        /* newline=FALSE;  */
        break;
      case 'M':   /* Left Margin Set */
        newline = TRUE;
        test_purge();
        i = margin;
        margin = get_integer(words);
        if (margin < 1)
          margin = 1;
        if (margin > 30)
          margin = 30;
        linelength += i - margin;
        setmargin += margin - oldmargin;
        oldmargin = margin;
        break;
      case 'N':   /* Set PageNum */
        addchar[0] = 0;
        dopagenum = TRUE;
        doroman = FALSE;
        bpagec = get_integer(words);
        if (isupper(words[0]))
        {          /* uppercase letter followed number */
          sprintf(addchar, ";%c", words[0]);
          words[0] = 0;
        }          /* uppercase letter followed word */
        if (bpagec == 1)
          pageset = TRUE;
        bpageh = bpagec;
        if (blinec == 0)
          linelength = curmax - 6 - margin - (short) strlen(addchar);
        break;
      case 'O':   /* Offset for Wrap */
        i = get_integer(words);
        if (i >= 30)
          i = 0;   /* keep values reasonable */
        memset(indent, 32, i);
        break;
      case 'P':   /* New page */
        if (blinec >= linesperpage - 1)
        {
          bpurge();
        }
        else
        {
          test_purge();
          if (dobook)
          {
            /* we have to put page number in lower right corner */
            j = blinec;
            for (i = j; i <= linesperpage; i++)
              bpurge();
          }
          else
            top_of_form();
        }
        break;
      case 'Q':   /* clear all tabs */
        memset(tabtable, 0, sizeof(tabtable));
        break;
      case 'R':   /* Roman Numerals */
        doroman = TRUE;
        dobook = FALSE;
        break;
      case 'S':   /* Skip a line */
        newline = TRUE;
        test_purge();
        bpurge();
        break;
      case 'T':   /* Text Format */
        xformat = TEXT;
        test_purge();
        strcat(bline, indent);
        strcpy(bline6, bline);
        break;
      case 'U':   /* page Numbering Off */
        addchar[0] = 0;
        dopagenum = FALSE;
        break;
      case 'V':   /* set tab */
        i = (short) (get_integer(words) & 255);
        if (!i)
          i++;
        tabtable[i] = 1;
        break;
      case 'W':   /* Footing */
        strcpy(oldline, bline);
        strcpy(oldline6, bline6);
        xfooting = TRUE;
        xpgroup = pgroup;
        xpjoin = pjoin;
        xjoin = join;
        xgroup = group;
        xhyphen = hyphen;
        xphyphen = phyphen;
        makefoot = TRUE;
        bline[0] = 0;
        bline6[0] = 0;
        pgroup = FALSE;
        group = FALSE;
        join = FALSE;
        pjoin = FALSE;
        break;
      case 'X':
        xtab = TRUE;
        break;
      case 'Y':
        xformat = LISTS;        /* TABLE Format */
        break;
      case 'Z':   /* Terminator */
        words[tilpos] = '`';
        strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case '\47': /* Apostrophe */
        words[tilpos] = '=';
        strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case '0':   /* Grade 0 */
        newline = FALSE;
        xgrade = GRADE0;
        goto test_mod;
      case '1':   /* Grade 1 */
        newline = FALSE;
        xgrade = GRADE1;
        break;
      case '2':   /* Grade 2 */
        newline = FALSE;
        xgrade = GRADE2;
        load_tables();
        break;
      case '3':   /* grade 3 */
        newline = FALSE;
        xgrade = GRADE3;
        load_tables();
    test_mod:
        grade_mod = 0;
        if (isdigit(words[tilpos - 1]))
        {
          grade_mod = (short) (words[tilpos - 1] - (char) 48);
          strcpy(words + tilpos - 1, words + tilpos);
        }
        break;
      case '4':   /* block */
        newline = FALSE;
        xformat = BLOCK;
        break;
      case '5':   /* block paragraphs */
        newline = FALSE;
        xformat = BLOCK_PARA;
        break;
      case '[':   /* escape */
        test_purge();
        i = (short) (tilpos - 1);
        words[i] = (char) 27;   /* escape character */
        strcpy(words + tilpos, words + tilpos + 1);     /* remove the [ */
        do
        {          /* write escape sequence directly to printer or file */
          write_char(words[i]);
          i++;
        }
        while (words[i] != '\0' && words[i] != '~');
        strcpy(words + tilpos - 1, words + i);
        break;
      case '-':   /* process as command line option */
        strcpy(temp, words + tilpos - 1);
        words[0] = '\0';
        strupr(temp);
        process_options(temp);
        break;
      case '~':
        format_string[0] = 0;
        break;
      default:
        fprintf(stderr, "Format error in ");
        if (total_lines)
          fprintf(stderr, "line %ld\n%s", total_lines, linein);
        else
          fprintf(stderr, "i%d=%s|%s\n", prog_init,
                  init[prog_init].pre_init, init[prog_init].post_init);
        exit(1);
      }            /* switch */
      if ((cptr = strpbrk(words, format_string)) != NULL)
        tilpos = 1 + (short) (cptr - words);
    }
    while (cptr != NULL);
}                  /* do_commands */

/*** Execute the Operation ***/
void do_lop_op(short op, short fstart, short flen, short fapdat)
{
  short i, j;
  if (op < 100)
    switch (op)
    {
    case 1:
      linein[0] = 0;
      break;       /* delete */
    case 2:
      xformat = TEXT;
      break;       /* text */
    case 3:
      xformat = LISTS;
      break;       /* lists */
    case 4:
      strcpy(linein, "~S ");
      linein[0] = format_string[0];
      break;       /* skip line */
    case 5:       /* center */
      while (linein[0] == ' ')
        strcpy(linein, linein + 1);     /* remove leading blanks */
      strcpy(field, linein);
      sprintf(linein, "~C%s", field);
      linein[0] = format_string[0];
      break;
    case 6:       /* indent */
      setmargin = (short) (oldmargin + 2);
      break;
    case 80:      /* page */
      inpglen = (unsigned short) fstart;
      break;
    }              /* switch */
  else
  if (op < 200)
  {                /* <200 */
    if (!linein[0])
      return;
    tabmargin = TRUE;
    if ((short) strlen(linein) < fstart)
      for (i = (short) (strlen(linein) - 1); i < (short) (strlen(linein) + flen); i++)
        strcat(linein, " ");
    strcpy(field, linein + fstart - 1);
    field[flen] = 0;
    strcpy(linein + fstart - 1, linein + fstart + flen - 1);
    trim(field);

    switch (op)
    {              /* switch op */
    case 101:
      field[0] = 0;
      break;
    case 102:     /* state */
      if (field[0])
      {            /* field not empty */
        for (i = 0; i < statecount; i++)
        {          /* i */
          j = strpos(field, stateid[i]);
          if (j)
          {        /* found state abbreviation */
            strcpy(field + j - 1, field + j + 1);
            insert(stateid[i] + 3, field, (short) (j - 1));
            break;
          }        /* found state abbrevation */
        }          /* i */
      }            /* field not empty */
    }              /* switch */
    if (fapdat > 0)
    {
      sprintf(temp, "%s %s", field, appdat[fapdat]);
      strcpy(field, temp);
    }
    insert(field, linein, (short) (fstart - 1));
  }                /* <200 */
  else
  if (op < 255)
  {                /* <255 */
    if (!linein[0])
      return;
    if ((int) strlen(linein) < fstart)
      for (i = (short) strlen(linein); i < (short) (strlen(linein) + flen); i++)
        strcat(linein, " ");
    strcpy(field, linein + fstart);
    field[flen] = 0;
    if ((fapdat > 0) && (strpos(field, appdat[fapdat]) > 0))
    {
      disablecol = TRUE;
      switch (op)
      {
      case 201:
        linein[0] = 0;
        break;
      case 202:
        disablecol = TRUE;
        break;
      }            /* switch */
    }
  }
}                  /* do_lop_op */

/*** Do Line Operation Processing -- outer loop ***/
void do_lop()
{
  short i, j;
  disablecol = FALSE;
  if (!lopcount)   /* no instructions were stored */
    return;
  for (i = 1; i <= lopcount; i++)
    if (l[i].lflag)
      if ((lineinct >= l[i].lstart) && (lineinct <= l[i].lend))
      {            /* line within range */
        j = l[i].fopstart;
        do_lop_op((short) f[j].fop, (short) f[j].fstart, (short) f[j].flen, (short) f[j].fappo);
        if (disablecol)
          for (j = (short) (l[i].fopstart + 1); j <= (short) (l[i].fopstart + l[i].fopcount - 1); j++)
            do_lop_op((short) f[j].fop, (short) f[j].fstart, (short) f[j].flen, (short) f[j].fappo);
      }            /* line within range */
  if (!disablecol)
    for (i = 1; i <= lopcount; i++)
      if (!l[i].lflag)
        if ((lineinct >= l[i].lstart) && (lineinct <= l[i].lend))
          for (j = l[i].fopstart; j < l[i].fopstart + l[i].fopcount; j++)
            do_lop_op((short) f[j].fop, (short) f[j].fstart, (short) f[j].flen, (short) f[j].fappo);

  if (disablecol)
    tabmargin = FALSE;
}                  /* do_lop */

void getline()
{
  short i = -1;
  for (;;)
  {                /* do until line read, line too long, or eof */
    i++;
    if (!bytes_in_buf)
    {              /* empty buffer so fill it up */
      bytes_in_buf = read(inf_des, iobuf, (unsigned int) BUFSIZE);
      if (bytes_in_buf <= 0)
      {            /* eof */
        endfile = done = TRUE;
        break;
      }            /* eof */
      ioptr = iobuf;
    }              /* buffer empty so fill it up */
    c = (char) (*ioptr & 127);  /* remove b7 if present */
    bytes_in_buf--;
    ioptr++;
    if (c == 31)
      c = '|';
    if (c == (char) 30)
      i--;
    else
      linein[i] = c;
    if (c == '\13' || c == '\14')
      lineinct = 0;
    if (c == '\n')
    {              /* actual eol */
      eolptr = linein + i;
      break;
    }              /* actual end of line */
    if (i > 170)
    {
      if (c == ' ')
        break;     /* line too long, end at word */
      if (i > 250)
        break;     /* emergency break ten four */
    }
    if (c < ' ')
      linein[i] = ' ';  /* remove all control chars */
  }                /* for */
  linein[i] = linein[i + 1] = 0;
  i--;
  while (i >= 0 && linein[i] == ' ')
    linein[i--] = 0;    /* remove trailing spaces */
  plinein = &linein[0];
  if (lineinct > inpglen && inpglen > 0)
    lineinct = 0;  /* reset lineinct for next input page */
  lineinct++;
  total_lines++;

  if (lopactive)
    do_lop();

  if (display_source)
    printf("=>%s\n", linein);
}                  /* getline */

void get_input(char *string, short length)
{                  /* gets a line of input from stdin up to length bytes */
  short l;
  fgets(string, length, stdin);
  l = (short) (strlen(string) - 1);
  if (string[l] == '\n' && l >= 0)
    string[l] = 0;
}                  /* get_input */

/*** See if Line should be written ***/
void check_purge(void)
{
  short i, j;
  BOOL purgit = TRUE;
  /* flush unless the first leftmargin-1 chars contain a nonspace char */
  for (i = 0; i < leftmargin; i++)
    /* Determine whether to flush */
    if (linein[i] != ' ' && linein[i] != '\0')  /* when reading a new Line */
      purgit = FALSE;

  if (xformat == LISTS || xformat == BLOCK)
    purgit ^= 1;   /* toggle purgeit */
  if (xformat == BLOCK_PARA)
    if (!linein[0])
    {              /* blank */
      if (!blank_lines++)
        purgit = TRUE;  /* indent since this line is blank */
      else
        purgit = FALSE;
    }
    else
    {
      purgit = FALSE;
      blank_lines = 0;
    }

  if (disablecol)
    purgit = TRUE;

  if (purgit)      /* Check for Indentation */
  {
    newline = TRUE;
    j = -1;
    for (i = 0; bline[i] != 0; i++)
      if (bline[i] != ' ')
        j = i;
    if (j >= 0 || xformat == BLOCK_PARA)
      bpurge();
    bline[0] = 0;
    if (xformat == TEXT || xformat == BLOCK_PARA)
      strcat(bline, indent);
    strcpy(bline6, bline);
    quotecount = 0;
    if (tabmargin)
      margin = setmargin;
    else
      margin = oldmargin;
    tabmargin = FALSE;
  }
}                  /* check_purge */

/***   Extract a Word From the	 ***/
/***   Input Text -- check for	 ***/
/***	      commands		 ***/
void get_word()
{
  char *cptr;
  int l;
  hyphen = FALSE;
  xacronym = FALSE;

  newline = FALSE;
  while (*plinein == '\0' && !done)
  {                /* blank line and not eof */
    /*
     * line could also be blank because all words were removed from read
     * buffer
     */
    l = strlen(bline);  /* length of pending braille line */
    if (makefoot)
    {              /* foot */
      makefoot = FALSE; /* only do once for each ~w command */
      memset(fline, 32, curmax);
      fline[linelength] = 0;
      if (bline[0])
        move(bline, fline + linelength - l + 1, (short) (l - 1));
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }              /* foot */
    if (makehead)
    {              /* head */
      /* use bline to consstruct header */
      makehead = FALSE; /* only do this once for each ~h command */
      memset(hline, 32, curmax);        /* fill with spaces */
      hline[curmax] = 0;
      if (bline[0])
        move(bline, hline + (linelength - l) / 2, (short) (l - 1));
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }              /* head */
    getline();
    check_purge();
  }                /* blank line and not eof */

  if (done)
  {
    words[0] = 0;
    return;
  }
  while (*plinein == ' ')
    plinein++;     /* skip leading blanks */
  cptr = strpbrk(plinein, " ");
  if (cptr)
  {                /* space found */
    *cptr = 0;     /* put null at end of word */
    strncpy(words, plinein, sizeof(words));
    *cptr = ' ';   /* restore linein */
    plinein = cptr + 1; /* where to search for next word */
  }                /* space found */
  else
  {                /* word at end of line */
    strncpy(words, plinein, sizeof(words));
    plinein += strlen(words);   /* we are done with this line */
  }                /* word at end of line */
  if (strpbrk(words, format_string))
    do_commands();
  /* change words containing string of _ to -, looks better in braille */
  if (words[0] == '_')
  {
    l = 0;
    while (words[++l] == '_');
    if (l > 2 && words[l] == '\0')
      strnset(words, '-', linelength);
  }
  return;
}                  /* get_word */

/*** Set up the Vector for the characters in a Word ***/
void set_vect()
{
  short i = 0;
  do
  {
    capvec[i] = subvec[i] = 0;
    if (isupper(words[i]))
      capvec[i] = UPPER;
    else
    {              /* not uppercase */
      if (islower(words[i]))
        capvec[i] = LOWER;
      else
      if (words[i] == '|' && format_string[0] != '\0')
      {            /* vertical bar */
        strcpy(words + i, words + i + 1);       /* delete | */
        capvec[i] = NOTRANS;    /* do not translate character after | */
        words[i] |= 128;        /* set b7 on character not to be trahnslated */
        /* this prevents this char from being a match in do_letter */
      }            /* vertical bar */
    }              /* is not uppercase */
    i++;
  }
  while (words[i]);
  strupr(words);
  capvec[i] = subvec[i] = 0;
}                  /* set_vect */

/***   Check the extracted word  ***/
/*** against the table of valid  ***/
/*** types:			 ***/
/***	  1-use anywhere	 ***/
/***	  2-must be exact match  ***/
/***	  3-at beginning or all  ***/
/***	  4-only in middle	 ***/
/***	  5-joins with same type ***/
/***	  6-joins next-to,into,by***/
/***	  7-not at beginning	 ***/
/***	  8-the word BE 	 ***/
/***	  9-his,was,were,enough  ***/
/***	 10-only at end 	 ***/
void do_letter()
{
  short i, j, k, l, matchend, wlength, wstart, casetype;
  BOOL atend, matched;
  char *current_match, *next_match;
  lastmatch = count;
  wlength = (short) strlen(words);
  wstart = 0;

  join = group = FALSE;
  matched = FALSE;
  firstletter++;
  subvec[count] = point;        /* subvec indexes single letter in case
                                 * there's no match */
  i = (short) (short) (words[count] - 64);
  /* we know i >=1 <=27 since word[count] is a letter */
  j = (short) (words[count + 1] - 64);
  if (j < 0 || j > 27)
    j = 0;         /* not a letter */
  i = b->start2[i][j];
/*for example the word this i=20 j=8 and start2[i][j] points to where words
* starting with th start*/
/*if i is 0 we know there isn't a match*/
  if (i > 0 && xgrade >= GRADE2 && !xacronym)
    do
    {
      current_match = b->match[i];
      l = (short) strlen(current_match);
      matchend = (short) (count + l - 1);       /* points to last character
                                                 * of proposed match */
      if (strncmp(current_match, words + count, l))
        goto l10;  /* not a match */

      k = b->typex[i];
      if (firstletter > wstart && (k == 2 || k == 3 || k == 6 || k == 8))
        goto l10;
      if (firstletter == wstart && (k == 4 || k == 7))
        goto l10;

      j = b->typex[b->start1[(short) words[matchend + 1]]];     /* Next Letter */
      if (j > 0 && j < 11)
        atend = FALSE;  /* next char is a letter */
      else         /* Set end of Word if next char not Letter */
        atend = TRUE;

      if (atend == FALSE && (k == 2 || k == 6 || k == 10))
        goto l10;

      if (atend && ((k == 4) ||
                    ((!strcmp(current_match, "IN")) && (k == 3))))
        /* in [3,4] */
        goto l10;

      if ((k == 5) && (atend) && (firstletter == wstart)
          && (words[wstart] != '\\'))
        group = TRUE;

      if (pjoin && k == 8 && atend)
        goto l10;

      if ((k == 8) && (matchend == wlength - 1)
          && (wlength != l))
        goto l10;

      if ((k == 9) &&   /* was, his, etc. */
          ((l != wlength) ||
           pjoin))
        goto l10;

      if (k == 6)
      {
        if (matchend - wstart + 1 != wlength)
          goto l10;/* to Into by */
        join = TRUE;
      }

      casetype = capvec[count];
      if (casetype == LOWER)    /* lowercase */
        for (k = 0; current_match[k + 1]; k++)
          if (isupper(current_match[k + 1]))
            if (capvec[count + k + 1] != casetype)
              goto l10;

      subvec[count] = i;
      count = matchend;
      matched = TRUE;

  l10:if (!matched)
        i++;
      next_match = b->match[i];
    }              /* while */
    while ((!matched) && next_match[1] == current_match[1]);
  quoteopen = quoteclose = FALSE;
}                  /* do_letter */

/***	  Convert NumberS	 ***/
/***	       Type 11		 ***/
void do_number()
{
  if (xgrade == GRADE0)
    return;        /* check for minus - make in (9) sign */
  firstletter = -1;
  subvec[count] = point;
  capvec[count] = NUMERIC;
  quoteopen = quoteclose = FALSE;
}                  /* do_number */

/***  Convert THE PUNCTUATION	 ***/
/***  Type 21 - Simple Replace	 ***/
/***	   22 - .		 ***/
/***	   24 - '                ***/
/***	   25 - "                ***/
/***	   27 - -		 ***/
void do_punct()
{
  short i, k;
  BOOL matched;
  BOOL apostrophe;

  while (strncmp(b->match[point], words + count, strlen(b->match[point])))
    point++;

  if (count > 0)   /* Check for capital mark requirement */
    if (lastmatch >= 0)
    {
      k = b->typex[abs(subvec[lastmatch])];
      if (k == 6 || k == 8 || k == 9)
        subvec[lastmatch] = (short) -abs(subvec[lastmatch]);
    }

  matched = FALSE;

  join = FALSE;
  group = FALSE;
  pgroup = FALSE;
  apostrophe = FALSE;
  k = b->typex[point];

  if (k == 24)
  {
    if ((isupper(words[count - 1]) || isdigit(words[count - 1])) &&
        (isupper(words[count + 1]) || isdigit(words[count + 1])))
      apostrophe = TRUE;
    if ((isupper(words[count - 1]) || isdigit(words[count - 1])) && quotecount == 0)
      apostrophe = TRUE;
    if (count - 1 == (int) strlen(words) && (words[count - 1] == 'S' || words[count - 1] == 'N'))
      ;            /* Maybe an apostrophe */
  }
  if (apostrophe == FALSE && (k == 24 || k == 25))
  {                /* Handle quotes */
    c = words[count - 1];
    if (quoteopen || ((count > 0) &&
            !(c == '(' || c == '-' || c == '"' || c == '\47' || c == '[') &&
                      !quoteclose))
    {              /* Ending quote */
      if (quotecount & 1)
        subvec[count] = b->start1[(int) '>'];
      else
        subvec[count] = b->start1[(int) '}'];
      quotecount--;
      quoteopen = TRUE;
    }              /* ending quote */
    else
    {              /* Beginning quote */
      if (pjoin)
      {
        pjoin = FALSE;
        strcpy(bline, bline6);  /* reset for to into by */
      }
      quotecount++;
      if (quotecount & 1)
        subvec[count] = b->start1[(int) '<'];
      else
        subvec[count] = b->start1[(int) '{'];
      quoteclose = TRUE;
    }              /* beginning quote */
    return;
  }                /* handle quote */

  do
  {                /* Find replacement */
    i = (short) (count + strlen(b->match[point]) - 1);
    if (!strncmp(b->match[point], words + count, strlen(b->match[point])))
    {
      matched = TRUE;
      subvec[count] = point;
      count = i;
    }
    else
      point++;
  }
  while (!matched);

  if (b->typex[point] != 27)
    firstletter = -1;
  quoteopen = FALSE;
  quoteclose = FALSE;
}                  /* do_punct */

/***   Build the Word From the	 ***/
/***   Information kept in the	 ***/
/***	 contraction vector	 ***/
void build_word()
{
  BOOL nolow, num = FALSE, allcaps = FALSE;
  short i, i1, j, k;
  bword[0] = bword6[0] = 0;     /* start with no word */
  bword[70] = 0;   /* tells if word gets too long */

  strcpy(oldword, words);
  for (i = 0; words[i]; i++)
  {
    if (bword[70])
      break;       /* quit before bword overflows */
    if (capvec[i] == NOTRANS)
    {              /* do not translate this char */
      j = (short) strlen(bword);
      bword[j] = (char) (words[i] & 127);
      bword[j + 1] = 0; /* only 1 character was added to bword */
    }              /* do not translate this char */
    else
    if (subvec[i])
    {
      if (subvec[i] < 0)
      {
        nolow = TRUE;
        subvec[i] = -subvec[i];
      }
      else
        nolow = FALSE;

      i1 = subvec[i];
      k = b->typex[i1];
      if ((!num) && ((k == 11)
                     || ((k == 22) && (b->typex[subvec[i + 1]] == 11))))
      {
        strcat(bword, "#");
        num = TRUE;
        allcaps = FALSE;
        join = FALSE;
        group = FALSE;
        pgroup = FALSE;
      }

      if (k == 11 || k == 21 || k == 23 || k == 24 || k == 25 || k == 27)
        strcat(bword, b->replace[i1]);

      if (k == 22) /* period */
        if (b->typex[subvec[i + 1]] == 11)      /* numeric follows period */
          strcat(bword, ".");   /* decimal point */
        else
          strcat(bword, b->replace[i1]);

      if (num && k == 26)       /* Percent */
      {
        j = strpos(bword, "#");
        if (!j)
          j++;
        insert(b->replace[i1], bword, (short) (j - 1));
      }

      if (k > 0 && k < 11)
      {
        if (num && strcmp(b->match[i1], "-"))
        {
          num = FALSE;
          if (words[i] == 'S' && words[i - 1] != '\47')
            strcat(bword, "'");
          if (capvec[i] == LOWER && (words[i] < 'K') &&
              (!isupper(words[i + 1])))
            strcat(bword, ";");
        }
        if (allcaps == FALSE && capvec[i] == UPPER)
        {
          pgroup = FALSE;
          strcat(bword, ",");
          if (capvec[i + 1] == UPPER)
          {
            strcat(bword, ",");
            allcaps = TRUE;
          }
        }
        if (k == 6)
        {
          sprintf(bword6, "%s%s", bword, b->match[subvec[i]]);
          if (!strcmp(bword6, "INTO"))
            strcpy(bword6, "9TO");
        }

        if (nolow)
          strcat(bword, b->match[i1]);
        else
          strcat(bword, b->replace[i1]);
      }
    }
    if (!strcmp(words, "$"))
    {
      strcpy(bword, "4#");
      strcpy(bword6, bword);
    }
  }                /* i */
  bword[curmax] = 0;
}                  /* build_word */

void check_ham_call()
{
  short i = 0, l = (short) strlen(words), l1;
  if (l > 6)
    return;
  strcpy(temp, words);
  strupr(temp);
  if (strcmp(temp, words))
    return;
  while (call_prefix[i])
  {
    l1 = (short) strlen(call_prefix[i]);
    if (!strncmp(temp, call_prefix[i], l1))
    {              /* match */
      if (!isdigit(temp[l1]))
        return;
      xacronym = TRUE;
      strlwr(words + l1 + 1);
      break;
    }              /* match */
    i++;
  }                /* while */
}                  /* check_ham_call */

void trans_word()
{
  short k;
  quoteopen = quoteclose = FALSE;
  lastmatch = 0;
  firstletter = count = -1;
  do
  {
    count++;
    if (capvec[count] != NOTRANS)
    {              /* not | */
      chardec = (short) words[count];
      point = b->start1[chardec];       /* = first table entry for this
                                         * character */
      k = b->typex[point];
      if (!k)
        continue;  /* character not in table, not translated */
      if (k <= 10)
        do_letter();
      else
      {            /* not a letter */
        if (k == 11)
          do_number();
        else
          do_punct();
      }            /* not letter */
    }              /* not | */
  }
  while (words[count + 1]);
}                  /* trans_word */

BOOL get_token()
{
  char delim = ' ';
  char *cptr;
  while ((lline[0]) && lline[0] == ' ')
    strcpy(lline, lline + 1);
  if (!lline[0])
    return (FALSE);
  if (lline[0] == (char) 39 || lline[0] == (char) 34)
  {                /* ' or " */
    delim = lline[0];
    strcpy(lline, lline + 1);
  }
  if (!lline[0])
    return (FALSE);

  tcount++;
  cptr = strchr(lline, delim);
  if (cptr == NULL)
  {
    strcpy(token[tcount], lline);
    lline[0] = 0;
    return (FALSE);
  }
  *cptr = 0;
  strcpy(token[tcount], lline);
  strcpy(lline, cptr + 1);
  return (TRUE);
}                  /* get_token */

void pop_tok(char *string)
{
  string[0] = 0;
  if (tcur >= tcount)
    return;
  tcur++;
  strcpy(string, token[tcur]);
}                  /* pop_tok */

short check_token(char *string)
{
  int i;
  if (!string[0])
    return (999);
  if (atol(string) > 0)
    return (888);  /* number */
  strupr(string);
  i = -1;
  do
  {
    i++;
    if (!strncmp(string, token_names[i], strlen(token_names[i])))
      break;
  }
  while (token_names[i] != NULL);
  if (token_vals[i] == 999)
  {                /* unknown token */
    fprintf(stderr, "Unknown token %s in line %d\n", field, lcount);
    exit(1);
  }                /* unknown token */
  return (token_vals[i]);
}                  /* check_token */

void do_ops()
{
  int i;
  tcur = 0;
  pop_tok(field);
  strupr(field);
  if (strcmp(field, "LINE"))
  {
    fprintf(stderr, "Invalid first Operation - must be LINE in line %d", lcount);
    fprintf(stderr, "%\n%s\n", lline);
    temperror = 100;
    return;
  }

  pop_tok(field);
  if (check_token(field) != 888)
  {                /* not a number */
    fprintf(stderr, "No line numbers specified in line %d\n%s\n", lcount, lline);
    temperror = 110;
    return;
  }                /* not a number */

  lopcount++;
  l[lopcount].lstart = (short) atoi(field);     /* starting line */
  l[lopcount].lend = l[lopcount].lstart;        /* in case there isn't a
                                                 * second line number */
  l[lopcount].fopstart = (short) (fopcount + 1);
  pop_tok(field);
  if (check_token(field) == 888)
  {                /* ending line number specified */
    l[lopcount].lend = (short) atoi(field);
    if (l[lopcount].lend < l[lopcount].lstart)
    {              /* bad line range */
      fprintf(stderr, "Ending line less than starting line in line %d\n", lcount);
      exit(1);
    }              /* bad line range */
    pop_tok(field);
  }                /* ending line number specified */

  while (check_token(field) < 100)
  {
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fop = (unsigned char) check_token(field);
    pop_tok(field);
    if (f[fopcount].fop == 80)
    {              /* page */
      f[fopcount].fstart = (short) atoi(field);
      pop_tok(field);
    }              /* page */
  }                /* while */

  if (check_token(field) == 202)
  {                /* match */
    pop_tok(field);
    if (check_token(field) != 888)
    {              /* not a number */
      fprintf(stderr, "No Match column numbers specified in line %d\n%s\n",
              lcount, lline);
      temperror = 210;
    }              /* not a number */
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fstart = (short) atoi(field);
    f[fopcount].flen = 1;
    l[lopcount].lflag = TRUE;
    pop_tok(field);
    if (check_token(field) == 888)
    {              /* got a number */
      i = atoi(field);
      if (i > f[fopcount].fstart)
        f[fopcount].flen = (short) (i - f[fopcount].fstart + 1);
      pop_tok(field);
    }              /* got a number */

    f[fopcount].fop = (unsigned char) 202;
    appcount++;
    f[fopcount].fappo = appcount;
    strcpy(appdat[appcount], field);
    pop_tok(field);
    if (check_token(field) == 1)        /* delete */
      f[fopcount].fop = (unsigned char) 201;
  }                /* match */

  while (check_token(field) == 100)
  {                /* field */
    pop_tok(field);
    if (check_token(field) != 888)
    {              /* no field number specified */
      fprintf(stderr, "No field numbers specified in line %d\n%s\n",
              lcount, lline);
      temperror = 210;
    }              /* no field number specified */
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fstart = (short) atoi(field);
    f[fopcount].flen = 1;

    pop_tok(field);
    if (check_token(field) == 888)
    {
      i = atoi(field);
      if (i > f[fopcount].fstart)
        f[fopcount].flen = (short) (i - f[fopcount].fstart + 1);
      pop_tok(field);
    }              /* while */

    if (check_token(field) > 100 && check_token(field) < 199)
    {
      f[fopcount].fop = (unsigned char) check_token(field);
      pop_tok(field);
    }

    if (check_token(field) == 199)
    {              /* append */
      if (f[fopcount].fop == (unsigned char) 0)
        f[fopcount].fop = (unsigned char) 199;
      appcount++;
      f[fopcount].fappo = appcount;
      pop_tok(appdat[appcount]);
      pop_tok(field);
    }              /* append */
  }                /* while */
}                  /* do_op */

void do_template()
{
  temperror = 0;
  lcount = 0;
  lopcount = 0;
  fopcount = 0;
  appcount = 0;
  memset(f, 0, sizeof(foptype));
  memset(l, 0, sizeof(loptype));
  memset(appdat, 0, sizeof(appdat));
  lfile = fopen(filetemp, FOPEN_READ);
  if (lfile == NULL)
  {                /* not found */
    fprintf(stderr, "*** External Format File %s not found ... ***\7", filetemp);
    exit(1);
  }                /* not found */

  printf("External Format File %s\n", filetemp);
  while (fgets(lline, 200, lfile))
  {                /* while there are lines to read */
    lline[strlen(lline) - 1] = 0;       /* get rid of lf */
    lcount++;
    if (lline[0] == ';')
      continue;    /* skip comment */
    tcount = 0;    /* tokens found on this line */
    while (get_token());        /* store tokens from entire line */
    if (tcount > 0)
      do_ops();    /* tokens were found */
  }                /* while */
  if (lopcount)
    printf("External Format Processing Complete\n");
  else
    fprintf(stderr, "No external format lines were processed\n");
  lopactive = TRUE;
  fclose(lfile);
}                  /* do_template */

void do_translate()
{
  short i;
  memset(tabtable, 0, sizeof(tabtable));

  pgroup = FALSE;
  pjoin = FALSE;
  join = FALSE;
  group = FALSE;
  hyphen = FALSE;
  phyphen = FALSE;
  if (xgrade < 0)
    xgrade = GRADE2;
  xacronym = TRUE;
  xcenter = FALSE;
  blank_lines = 0;
  if (xformat < 0)
    xformat = TEXT;
  xtab = FALSE;
  dobook = FALSE;
  xdouble = FALSE;
  xheading = FALSE;
  xfooting = FALSE;
  makefoot = FALSE;
  makehead = FALSE;
  if (dopagenum < 0)
    dopagenum = TRUE;
  pageset = FALSE;
  doroman = FALSE;
  disablecol = FALSE;
  fillit = FALSE;
  quotecount = 0;
  margin = 1;
  setmargin = 1;
  oldmargin = 1;
  tabmargin = FALSE;
  bpageb = 0;
  bpagec = 0;
  blinec = 0;
  actualpage = 0;
  lineinct = 0;
  inpglen = 0;
  total_words = total_cells = total_lines = 0l;
  memset(total_dots, 0, 28);
  field[0] = 0;
  addchar[0] = 0;
  curmax = maxline;
  linelength = maxline + 1 - margin;
  plinein = &linein[0];

  copies++;
  top_of_form();
  if (print_file)
  {
    strcpy(bline, inf_name);
#ifdef DOS
    strlwr(bline);
#endif
  }
  if (print_date)
  {                /* date */
    if (bline[0])
      strcat(bline, " ");
    strcat(bline, date_string);
  }                /* date */
  if (bline[0] && pagestart == 1)
    bpurge();
  bline[0] = 0;

  if (inf_des)
    lseek(inf_des, 0l, 0);      /* start from beginning for each copy */
  bytes_in_buf = 0;/* no bytes in iobuf */

  endfile = FALSE;
  done = FALSE;
  do
  {
    get_word();
    i = (short) strlen(words);
    if (i > 1 && words[i - 1] == '-' && isalpha(words[i - 2]))
      /* may be a hyphenated word we want to join to next word */
      if (plinein + 2 >= eolptr)
      { 	   /* last word on line */
        strcpy(oldword, words);
        get_word();
	if(isalpha(words[0]))
	{/*join*/
	strcpy(oldword +i-1, words);
	oldword[curmax] = 0;
	strcpy(words, oldword);
}/*join*/
else
	{/*doesn't begin with a letter so don't join*/
		plinein = &linein[0];/*unget the word*/
		strcpy(words,oldword);
	}/*word doesn't begin with letter so don't join*/
      }            /* remove hyphen from last word on line */
    if (words[0])
    {              /* word not empty */
      total_words++;
      if (xgrade)
      {
        check_ham_call();
        set_vect();
        trans_word();
        build_word();
      }
      else
      {
        if (!grade_mod)
        {          /* grade 0 no translation */
          strcpy(bword, words);
          strcpy(bword6, words);
        }          /* grade 0 no translation */
        else
          add_case();
      }
      build_line();
    }              /* word not empty */
    if (stdin_tty)
    {
      if (kbhit())
        if (getch() == 27)
        {          /* escape */
          done = TRUE;  /* abort */
          ab_flag = 1;
          return;
        }          /* escape */
    }              /* stdin_tty */
  }                /* while */
  while (!done);
  if (bpagec < pagestart)
    return;
  bpurge();

  if (xfooting && blinec > 0)
  {                /* put footing on last page */
    for (i = (short) (blinec + 2); i <= linesperpage; i++)
      if (bpagec > pagestart)
      {
        write_string(" ");
        if (display_braille)
          printf("\n");
      }
    if (bpagec > pagestart)
    {
      write_string(fline);
      if (display_braille)
        printf("%s\n", fline);
    }
    blinec = linesperpage;
  }                /* put footing on last page */

  if (blinec > 0)
  {                /* advance to top of next page */
    advance_page();
    /* we are at the top of bpagec+1 */
    actualpage++;
  }                /* advance to top of next page */

  if (interpoint)
  {
    if (!(actualpage & 1))
    {              /* skip interpoint even page */
      blinec = 0;  /* skip whole page */
      advance_page();
    }              /* skip interpoint even page */
    if (interpoint > 1)
      for (i = 0; i < 2; i++)
        advance_page();
  }                /* interpoint */
}                  /* do_translate */

void do_stat()
{
  int i;
  if (bpagec < pagestart)
    return;        /* no output */
  if (stat_file[0] && intext == NULL)
    intext = fopen(stat_file, "a");
  if (intext != NULL)
  {                /* open */
    time(&time2);
    time2 -= time1;
    /* if file is not empty, output blank line to separate entry */
    if (filelength(fileno(intext)) > 0l)
      fprintf(intext, "\n");
    fprintf(intext, "%s\n", date_string);
    if (inf_name[0])
      fprintf(intext, "Input: %s\n", inf_name);
    fprintf(intext, "%ld minutes %ld seconds\n", time2 / 60l, time2 % 60l);
    fprintf(intext, "LinesPerPage: %d\n", linesperpage);
    fprintf(intext, "LineLength: %d\n", linelength);
    fprintf(intext, "%ld Words, %d Pages, %ld words per page\n", total_words,
            bpagec, total_words / (long) bpagec);
    fprintf(intext, "Total cells: %ld\n", total_cells);
    total = 0l;
    for (i = 0; i <= 5; i++)
      total += total_dots[i];
    fprintf(intext, "Total dots: %ld\n", total);
    for (i = 0; i <= 5; i++)
      fprintf(intext, "Dot%d: %6ld = %ld%%\n", i + 1, total_dots[i],
              total_dots[i] * 100l / total);
    if (total_dots[6])
      fprintf(intext, "Dot 7 = %6ld\n", total_dots[6]);
    fprintf(intext, "Input file length: %ld\n", in_length);
    fprintf(intext, "Output file length: %ld\n", out_length);
    if (!ab_flag)
      if (in_length != 0l && ab_flag == 0)
        fprintf(intext, "Output is %ld%% of input\n", 100l * out_length / in_length);
    if (ab_flag)
      fprintf(intext, "Aborted\n");
    fprintf(intext, "Entries in table: %d\n", table_entries);
  }                /* open */
}                  /* do_stat */

void advance_page()
{
  short i;
  if (lineskips < 99)
    for (i = blinec; i < linesperpage + lineskips; i++)
    {
      write_string(" ");        /* do it with linefeeds */
    }
  if (lineskips == 99)
    write_char(12);/* do it with a formfeed */
  if (lineskips == 999)
    write_char(11);/* vertical tab no lf */
  if (lineskips == 9999)
  {
    write_string("\14");        /* formfeed with linefeed */
    printf("\nTo Continue, Press Return\n");
    getch();
  }
}                  /* advance_page */

void load_tables()
{
  short j, k, error = 0, current_line = 0;
  char match[20], prev_match[20];
  short lenmat, lenrep, typex;
  FILE *btable;
  char *ver_bar, *c;
  sprintf(temp, "%s%s", transpath, table_file);
  if ((btable = fopen(temp, FOPEN_READ)) == NULL)
  {                /* error */
    fprintf(stderr, "Cannot find %s\n", temp);
    exit(1);
  }                /* error */
  if (b == NULL)   /* only allocate once */
    if ((b = (tablet *) malloc(sizeof(tablet))) == NULL)
    {              /* error */
      fprintf(stderr, "Cannot allocate memory for table\n");
      exit(1);
    }              /* error */
  table_entries = 0;
  memset(b, 0, sizeof(tablet)); /* fill in structure with zeros */
  prev_match[0] = '\0'; /* forces mismatch between match and prev_match on
                         * first line */
  while (fgets(temp, 80, btable))
  {                /* while there are lines to read */
    current_line++;
    trim(temp);
    /* skip blank lines and comments starting with ; or # */
    if (temp[0] < ' ' || temp[0] == ';' || temp[0] == '#')
      continue;
    strupr(temp);
    if ((ver_bar = strpbrk(temp, "|")) == NULL)
    {              /* error */
  no_ver_bar:error++;
      fprintf(stderr, "Improper placement of | error in line %d\n", current_line);
      break;
    }              /* error */
    *ver_bar = (char) 0;
    typex = (short) atoi(temp);
    *ver_bar = '|';/* restore temp */
    c = ver_bar + 1;    /* beginning of match */
    if ((ver_bar = strpbrk(ver_bar + 1, "|")) == NULL)
      goto no_ver_bar;
    *ver_bar = (char) 0;
    lenmat = (short) strlen(c);
    if (lenmat > MAX_MATCH)
    {              /* too long */
      fprintf(stderr, "Error - match too long in line %d\n%s\n", current_line,
              temp);
      error++;
      break;
    }              /* too long */
    strcpy(match, c);
    *ver_bar = '|';/* restore temp */
    c = strpbrk(ver_bar, " ");
    if (c)
      *c = '\0';   /* remove extra comment words after table entry */
    lenrep = (short) strlen(ver_bar + 1);
    if (lenrep > MAX_REP)
    {              /* replace too long */
      fprintf(stderr, "Error - Replace too long in line %d\n%s\n", current_line,
              temp);
      error++;
      break;
    }              /* replace too long */
    if (table_entries >= MAXTAB)
    {              /* too many entries */
      fprintf(stderr, "More then %d entries in table not allowed\n", MAXTAB);
      fprintf(stderr, "Remaining entries will be ignored.\n");
      break;       /* quit reading the table not fatal */
    }              /* too many entries */
    if (typex <= -32 || typex >= 64)
    {              /* bad type */
      fprintf(stderr, "Invalid type in line %d\n", current_line);
      error++;
      break;
    }              /* type error */
    if (xgrade == GRADE3)
    {              /* grade 3 */
      if (grade_mod == 0 && typex < 0)
        continue;  /* skip unwanted g2 entry */
      if (typex > 32 && grade_mod > 0)
      {            /* grade_mod nonstandard grade 3 */
        /* skip entries other than dot 4 5 45 and 456 contractions */
        if (!strpbrk(ver_bar + 1, "@\042^_"))
          continue;
        if (grade_mod == 1 && (!isupper(ver_bar[2])))
          continue;/* char after @"^_ is not a letter */
      }            /* grade_mod */

      typex &= 31;
    }              /* grade 3 */
    else
    if (typex > 32)
      continue;    /* skip g3 entry */
    table_entries++;    /* we found a valid line, store results */
    b->typex[table_entries] = (short) abs(typex);
    strcpy(b->match[table_entries], match);
    strcpy(b->replace[table_entries], ver_bar + 1);
    if (table_entries > 1)      /* store previous match in prev_match */
      strcpy(prev_match, b->match[table_entries - 1]);
    j = (short) (match[0] - '@');
    if (j < 0 || j > 26)
      j = 0;
    if (strcmp(prev_match, match) >= 0)
      if (strncmp(prev_match, match, lenmat))
      {
        fprintf(stderr, "\007Sorting error in line %d\n", current_line);
        error++;
        break;
      }
    if (match[0] != prev_match[0])
    {              /* first characters differ */
      if (lenmat != 1 && isupper(match[0]))
      {            /* error */
        fprintf(stderr, "Match should be a single character in line %d\n"
                ,current_line);
        error++;
        break;
      }            /* error */
      b->start1[(short) (match[0])] = table_entries;
      b->start2[j][0] = table_entries;
    }              /* first characters differ */
    else
    if ((match[1] != prev_match[1]))
    {              /* second element of match and previous match differ */
      k = (short) (match[1] - '@');
      if (k < 0 || k > 26)
        k = 0;
      b->start2[j][k] = table_entries;
    }              /* second elements differ */
  }                /* while */
  fclose(btable);
  if (error)
  {                /* fatal error occurred */
    fprintf(stderr, "Correct error in %s and restart program.\n", table_file);
    exit(1);
  }                /* fatal error occurred */
}                  /* load_tables */

void get_config()
{
  short i;
  char *c, *cptr;
  /* initialize structures */
  memset(l, 0, sizeof(l));
  memset(init, 0, sizeof(init_t));
  memset(&prog_extension.total, 0, sizeof(prog_ext_t));
  stdin_tty = (short) isatty(0);
  stdout_tty = (short) isatty(1);
#ifdef unix
  if (stdout_tty)
    setbuf(stdout, NULL);       /* so printf always prints */
#endif             /* unix */
  for (i = 0; i < 3; i++)
  {                /* try current directory first, then use nfbtrans
                    * environment variable then program path */
    switch (i)
    {
    case 1:       /* check environment */
      c = (char *) getenv("NFBTRANS");
      if (c)
      {            /* nfbtrans defined */
        strcpy(transpath, c);
        if (transpath[strlen(transpath) - 1] != '\\')
          strcat(transpath, "\\");
      }            /* nfbtrans defined */
      break;
    case 2:       /* program path */
#ifdef unix
      break;       /* path not in argv[0] */
#endif
      strcpy(transpath, paramstr[0]);
      c = strrchr(transpath, '\\');
      if (c)
        c[1] = 0;  /* we have program path */
    }              /* switch */
open_config:      /* sloppy programming but what the hell */
    sprintf(temp, "%s%s", transpath, config_file);
    if ((intext = fopen(temp, FOPEN_READ)) == NULL)
      continue;
    break;         /* file is open */
  }                /* i */
  if (intext)
  {                /* read config file */
    while (fgets(temp, 80, intext))
    {              /* while there are lines to read */
      strupr(temp);
      trim(temp);
      if (temp[0] == '\n' || temp[0] == ';' || temp[0] == '#')
        continue;  /* skip */
      if ((cptr = strpbrk(temp, " ")) != NULL)
        *cptr = 0; /* allows comments starting with second word */
      process_options(temp);
    }              /* while */
    fclose(intext);
  }                /* read config file */
  for (i = 1; i <= paramcount; i++)
  {
    strupr(paramstr[i]);
    if (paramstr[i][2] == '=')
    {              /* xx= */
      process_options(paramstr[i]);
      if (!paramcount)
        goto open_config;       /* cf=newfile was found */
    }              /* xx= */
    else
    {              /* not xx= */
      usr_default = TRUE;
      if (stdin_tty)
      {            /* tty */
        if (!inf_name[0])
        {
          strcpy(inf_name, paramstr[i]);
          continue;
        }
      }            /* tty */
      if (stdout_tty)
      {
        strcpy(outf_name, paramstr[i]);
      }
    }              /* not xx= */
  }                /* i */
  if (!stdin_tty)
  {
    inf_des = 0;
    usr_default = TRUE;
  }
  if (!stdout_tty)
  {
    skip_output = TRUE;
    outf_des = 1;
    trans_mode = 11;
  }
  if (usr_default)
  {
    display_source = FALSE;
    lastcopy = 1;
    if (pagestart <= 0)
      pagestart = 1;
    if (pageend < pagestart)
      pageend = 9999;   /* print entire document */
    if (leftmargin < 1)
      leftmargin = 1;
    if (maxline <= 1)
      maxline = 40;
    if (linesperpage <= 0)
      linesperpage = 25;
    if (lineskips < 0)
      lineskips = 99;
    if (trans_mode <= 0)
      trans_mode = 21;
    display_braille = 0;
  }
}                  /* get_config */

void process_options(char *string)
{
  short j, x;
  char *cptr = string + 3, *vptr;
  for (j = 0; options[j] != NULL; j++)
  {
    if (!strncmp(string, options[j], 2))
    {              /* option matched */
      if (*cptr <= ' ')
        j = -1;    /* error since nothing follows xx= */
      x = (short) atoi(cptr);   /* saves multiple calls to atoi */
      switch (j)
      {
      case 0:     /* cf */
        strcpy(config_file, cptr);
        paramcount = 0;
        break;
      case 1:
        center_length = x;
        break;
      case 2:     /* co */
        lastcopy = x;
        break;
      case 3:     /* cs */
        charspersec = x;
        break;
      case 4:     /* db */
        display_braille = x;
        break;
      case 5:     /* de */
        emboss_delay = x;
        break;
      case 6:     /* ds */
        display_source = x;
        break;
      case 7:     /* ex */
        for (;;)
        {
          if (prog_extension.total >= MAX_EXTENSIONS)
          {        /* too many extensions */
            fprintf(stderr,
             "\007Too many extensions.  only the first %d will be stored\n",
                    MAX_EXTENSIONS);
            break;
          }        /* too many extensions */
          vptr = strpbrk(cptr, "=");
          if (vptr == NULL)
            break; /* no more extensions */
          *vptr = 0;    /* terminate extension */
          strncpy(prog_extension.prog_ext[prog_extension.total].ext, cptr, 3);
          *vptr = ' ';  /* in case theres an error */
          if (vptr[1] > '9')
            goto invalid;
          prog_extension.prog_ext[prog_extension.total].init_val = (short) (vptr[1] - 48);
          cptr = vptr + 2;
          prog_extension.total++;
        }
        break;
      case 8:     /* fp */
        first_page = x;
        break;
      case 9:     /* fs */
        copy_string(format_string, cptr, 3);
        break;
      case 10:    /* fx */
        strcpy(filetemp, cptr);
        if (*cptr >= 'A')
          usetemplate = TRUE;
        break;
      case 11:    /* hk */
        hot_key = x;
        break;
      case 12:    /* i0 */
      case 13:    /* i1 */
      case 14:    /* i2 */
      case 15:    /* i3 */
      case 16:    /* i4 */
      case 17:    /* i5 */
      case 18:    /* i6 */
      case 19:    /* i7 */
      case 20:    /* i8 */
      case 21:    /* i9 */
        x = (short) (string[1] - 48);
        vptr = strpbrk(cptr, "|");
        if (!vptr)
        {
      no_ver_bar:fprintf(stderr, "\007Missing | in %s\n", string);
          exit(1);
        }
        *vptr = 0;
        copy_string(init[x].pre_init, cptr, 19);
        cptr = vptr + 1;
        vptr = strpbrk(cptr, "|");
        if (!vptr)
          goto no_ver_bar;
        *vptr = 0;
        copy_string(init[x].post_init, cptr, 19);
        copy_string(init[x].format, vptr + 1, 3);
        break;
      case 22:    /* interpoint */
        interpoint = x;
        break;
      case 23:    /* lm */
        leftmargin = x;
        break;
      case 24:    /* ls */
        lineskips = x;
        break;
      case 25:    /* mm */
        max_menu = x != 3 ? (short) 2 : (short) 3;
        break;
      case 26:    /* nc */
        no_copyright = x;
        break;
      case 27:    /* ow */
        over_write = x;
        break;
      case 28:    /* pa */
        pause_time = x;
        display_braille = display_source = FALSE;
        break;
      case 29:    /* pd */
        print_date = x;
        break;
      case 30:    /* pe */
        pageend = x;
        break;
      case 31:    /* pf */
        print_file = x;
        break;
      case 32:    /* pl */
        linesperpage = x;
        break;
      case 33:    /* ps */
        pagestart = x;
        break;
      case 34:    /* pw */
        maxline = x;
        break;
      case 35:    /* s0 */
        strcpy(s0_init, cptr);
        break;
      case 36:    /* so */
        make_sound = x;
        break;
      case 37:    /* sp */
        spool = x;
        break;
      case 38:    /* st */
        strncpy(stat_file, cptr, sizeof(stat_file));
#ifdef unix
        strlwr(stat_file);
#endif
        break;
      case 39:    /* tf */
        strcpy(table_file, cptr);
        break;
      case 40:    /* tm */
        trans_mode = x;
        break;
      case 41:    /* tp */
        strcpy(transpath, cptr);
        break;
      case 42:    /* tv */
        timer = x;
        break;
      default:
        fprintf(stderr, "\7Improper option format: %s nothing follows =.\n", string);
        exit(1);
      }            /* switch */
      break;
    }              /* option matched */
  }                /* j */
  if (options[j] == NULL)
  {                /* invalid */
invalid:
    fprintf(stderr, "\7Invalid option %s\n", string);
    exit(1);
  }                /* invalid */
}                  /* process_options */

void trim(char *string)
{
  int i, l = strlen(string);
/*remove trailing cr lf and spaces*/
  for (i = l - 1; i >= 0; i--)
  {
    switch (string[i])
    {
    case ' ':
    case '\12':   /* lf */
    case '\15':   /* cr */
      break;
    default:
      string[i + 1] = 0;
      i = 0;
      while (string[i] == ' ')
        i++;
      if (i)
        strcpy(string, string + i);
      return;
    }
  }                /* i */
}                  /* trim */

short strpos(char *string, char *substring)
{
  int i = 0, j, stringlen, sublen;
  stringlen = strlen(string);
  sublen = strlen(substring);
  if ((!stringlen) || (!sublen) || (sublen > stringlen))
    return (0);
  do
  {
    for (j = 0; j < sublen; j++)
      if (string[i + j] != substring[j])
        goto retry;
    return (short) (i + 1);
retry:;
  }
  while (++i < stringlen);
  return (0);
}                  /* strpos */

void insert(char *ins, char *string, short ins_point)
{
  char buf[256];
  memcpy(buf, string, ins_point);       /* save beginning of string */
  strcpy(buf + ins_point, ins);
  strcat(buf, string + ins_point);
  strcpy(string, buf);
}                  /* insert */

void move(char *string1, char *string2, short bytes)
{
  while (bytes >= 0)
  {
    string2[bytes] = string1[bytes];
    bytes--;
  }                /* while */
}                  /* move */

#ifdef DOS
void sort_names()
{                  /* sorts names in file_names */
  short i, j;
  if (file_count < 2)
    return;        /* nothing to sort */
  for (i = 0; i < file_count; i++)
    for (j = (short) (i + 1); j < file_count; j++)
      if (strcmp(file_name[i], file_name[j]) > 0)
      {            /* out of order */
        strcpy(temp, file_name[i]);
        strcpy(file_name[i], file_name[j]);
        strcpy(file_name[j], temp);
      }            /* out of order */
}                  /* sort_names */

#endif             /* DOS */

/***      Translate A File       ***/

void translate_file()
{
  short i, inf_path_len = 0, input_flag = 0;
  long emboss_time;
  if (stdin_tty != 0)
  {                /* input filename required */
    if (!inf_name[0])
    {
  get_file_name:
      fprintf(stderr, "\nEnter source File name <RETURN> to exit? ");
      get_input(temp, 48);
    }
    if (!temp[0])
      exit(0);
    if (!inf_name[0])
      strcpy(inf_name, temp);
    input_flag = 1;
    /* get path component of name */
    inf_path_len = 0;
    for (i = 0; inf_name[i] != '\0'; i++)
      if (inf_name[i] == '\\' || inf_name[i] == ':')
        inf_path_len = (short) (i + 1);
    file_count = current_file = 0;
    intext = NULL;
#ifdef DOS
    if (strpbrk(inf_name, "?*"))
    {              /* wildcard chars */
      input_flag = 2;   /* wildcard chars specified */
      pagestart = 1;
    }              /* wildcard chars */
    if (!_dos_findfirst(inf_name, 0, &fileinfo))
      do
      {            /* store and sort matching file names */
        if (test_extension(fileinfo.name) < 0)
          continue;/* extension was excluded */
        strcpy(file_name[file_count++], fileinfo.name);
        if (file_count >= MAX_FILES)
          break;   /* don't store any more */
      }
      while (!_dos_findnext(&fileinfo));
    if (!file_count)
/*no file was found in search but store name anyway*/
      strcpy(file_name[file_count++], inf_name + inf_path_len);
    sort_names();
get_next_file:
    strcpy(inf_name + inf_path_len, file_name[current_file++]);
#endif
    prog_init = test_extension(inf_name);
    if (prog_init < 0)
    {              /* excluded */
      fprintf(stderr, ".%s: Excluded extension", inf_name_ext);
      exit(1);
    }              /* excluded */
    get_date();    /* store date in date_string */
#ifdef DOS
    if (input_flag == 2 && stdout_tty > 0)
      if (fileinfo.name[0])
        printf("Translating %s\n", inf_name);
#endif             /* DOS */
  }                /* input filename required */
  if (inf_name[0])
    inf_des = open(inf_name, O_BINARY | O_RDONLY);
  if (inf_des < 0)
  {                /* error */
    if (!inf_name[0])
      strcpy(inf_name, "File");
    fprintf(stderr, "\7%s not found...\n", inf_name);
    inf_name[0] = 0;
    if (paramcount < 1)
      goto get_file_name;
    exit(1);
  }                /* error */
  if (leftmargin < 0)
  {                /* get left margin */
    leftmargin = 1;
    fprintf(stderr, "Enter Number of spaces before Left Margin of source File \n");
    fprintf(stderr, "     (usually 1)? %d", leftmargin);
    backspace_int(leftmargin);
    get_input(temp, 4);
    leftmargin = (short) atoi(temp);
    if (leftmargin <= 0)
      leftmargin = 1;
  }                /* get left margin */
  if (maxline <= 0)
  {                /* get maxline */
    maxline = 40;
    fprintf(stderr, "Enter Number of braille cells to emboss\n");
    fprintf(stderr, "  on a Line (usually 40)? %d", maxline);
    backspace_int(maxline);
    get_input(temp, 3);
    maxline = (short) atoi(temp);
    if (maxline <= 0)
      maxline = 40;
  }                /* get maxline */
  get_page_range();
  if (display_source < 0)
  {                /* display source? */
    fprintf(stderr, "\nDisplay Source Text (Y/N)? N\010");
    get_digit();
    if (temp[0] == 'y' || temp[0] == 'Y')
      display_source = TRUE;
    else
      display_source = FALSE;
  }                /* display source? */
  if (display_braille < 0)
  {                /* display braille? */
    fprintf(stderr, "\nDisplay Translated Text (Y/N)? Y\010");
    get_digit();
    if (temp[0] == 'n' || temp[0] == 'N')
      display_braille = FALSE;
  }                /* display braille? */
  if (linesperpage <= 0)
  {
    linesperpage = 25;
    fprintf(stderr, "\nNumber of Lines per Page? %d", linesperpage);
    backspace_int(linesperpage);
    get_input(temp, 5);
    if (temp[0])
      linesperpage = (short) atoi(temp);
    if (linesperpage <= 0)
      linesperpage = 25;
  }
  if (lineskips < 0)
  {
    lineskips = 99;
    fprintf(stderr, "Line Skips between Pages (99-FF, 999-VT)? %d", lineskips);
    backspace_int(lineskips);
    get_input(temp, 5);
    if (temp[0])
      lineskips = (short) atoi(temp);
    if (lineskips < 0)
      lineskips = 99;
  }
  if (current_file < 2)
    printit = TRUE;
  if (trans_mode < 10)
  {                /* get secondary translation mode */
    fprintf(stderr, "\nPlease select ");
    fprintf(stderr, "\n  1 to Translate and store in a File or");
    fprintf(stderr, "\n  2 Translate and emboss immediately.");
    fprintf(stderr, "\n  Choice? 2\010");
    do
    {
      get_digit();
      if (!temp[0])
        i = 2;
      else
        i = (short) atoi(temp);
    }
    while (i < 1 || i > 2);
  }                /* get secondary translation mode */
  else
    i = (short) (trans_mode / 10);
  trans_mode = (short) ((10 * i) + 1);
  if (i == 1)
  {                /* translate and store */
    printit = FALSE;
    if (!outf_name[0] && stdout_tty != 0)
    {              /* output file required */
      fprintf(stderr, "\nEnter name of File to create? ");
      get_input(outf_name, 48);
      if (!outf_name[0])
        exit(0);
    }              /* output file required */
  }                /* translate and store */
  if (!filetemp[0])
  {
    fprintf(stderr, "\nName of External Format File (RETURN for none)? ");
    get_input(filetemp, 48);
  }
  if ((filetemp[0]) && filetemp[0] != '/')
    usetemplate = TRUE;
  if ((printit && !(usr_default)))
    get_page_range();
  get_copies();
  fprintf(stderr, "\n");
  if (usetemplate)
    do_template();
  if (printit == FALSE && stdout_tty != 0)
  {                /* disk file */
    if (access(outf_name, 0) == 0 && over_write == 0)
    {              /* file already exists */
      printf("\007File %s exists - Overwrite (Y/N)? Y\010", outf_name);
      get_digit();
      if (temp[0] == 'n' || temp[0] == 'N')
        return;
    }              /* file already exist */
    if (stdout_tty)
      printf("Writing to file - %s\n", outf_name);
  }                /* disk file */
  else
    do_pause();
  if (ab_flag)
    return;
  time(&time1);
  if (outf_name[0] && outf_des == 0)
    outf_des = open(outf_name, (int) (O_BINARY | O_CREAT | O_TRUNC | O_WRONLY), STD_OPEN);
  strcpy(format_string, "~");
  strcpy(words, init[prog_init].pre_init);
  do_commands();
  strcpy(format_string, init[prog_init].format);
  if (printit && spool)
  {                /* printer ignore formfeed */
    strcpy(format_string, "~");
    strcpy(words, s0_init);
    do_commands();
    strcpy(format_string, init[prog_init].format);
  }                /* printer ignore formfeed */
#ifdef unix
  unbuf_stdin();   /* so we can check for esc */
#endif
  do
  {
    do_translate();
  }
  while (copies < lastcopy);
  strcpy(format_string, "~");
  strcpy(words, init[prog_init].post_init);
  do_commands();
  in_length = filelength(inf_des);
  out_length = filelength(outf_des);
  close(inf_des);
  do_stat();
#ifdef DOS
  if (printit && spool && ab_flag == 0)
  {                /* spool */
    emboss_time = total_cells / (60l * (long) charspersec);
    if (stdout_tty && emboss_time > 1l)
      printf("Estimated embossing time: %ld minutes\n",
             emboss_time);
    sprintf(temp, "print %s", outf_name);
    if (system(temp))
      fprintf(stderr, "Could not execute %s\n", temp);
  }                /* spool */
  if (input_flag)
  {
    copies = 0;
    if (current_file < file_count)
      goto get_next_file;
  }
#endif             /* DOS */
  close(outf_des);
  if (intext)
    fclose(intext);
}                  /* translate_file */

void backtranslate_file()
{
  fprintf(stderr, "\nI can't do that yet.\n");
  exit(1);
}                  /* backtranslate_file */

short test_extension(char *string)
{
  short i, j = 0;
  char *cptr;
  /* get file extension */
  cptr = strpbrk(string, ".");
  if (cptr == NULL)
    cptr = string + strlen(string) - 1;
  strcpy(inf_name_ext, cptr + 1);
  strupr(inf_name_ext);
  /* find out if extension is in an ex= option */
  for (i = 0; i < prog_extension.total; i++)
    if (!strcmp(inf_name_ext, prog_extension.prog_ext[i].ext))
      j = (short) (i + 1);      /* extension was in list */
  if (j)
    return (prog_extension.prog_ext[j - 1].init_val);
  return (0);      /* for extensions not in ex= */
}                  /* test_extension */

/*** Emboss a translated File ***/

void emboss_file()
{
  char ch, *cptr;
  if (!inf_name[0])
  {                /* get filename */
    printf("Enter the name of the already Translated File <RETURN> to exit: ");
    get_input(temp, 48);
    if (!temp[0])
      exit(0);
    strcpy(inf_name, temp);
  }                /* get filename */
  if ((intext = fopen(inf_name, FOPEN_READ)) == NULL)
  {                /* error */
    fprintf(stderr, "\7%s does not exist\n", inf_name);
    exit(1);
  }                /* error */
  get_copies();
  get_page_range();
  usr_default = FALSE;
  printit = TRUE;
  do_pause();
  outf_des = open(outf_name, O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
  do
  {                /* while there are copies to emboss */
    copies++;
    actualpage = 0;
    bpagec = 1;    /* current braille page */
    lineinct = 0;
    rewind(intext);/* start from beginning of file for this copy */
    while ((fgets(field, 80, intext)) && bpagec <= pageend)
    {              /* while there are lines to read and not passed ending
                    * page */
      if (kbhit())
        if (getch() == 27)
        {          /* escape */
          ab_flag = 1;
          break;
        }          /* escape */
      lineinct++;
      lcount = (short) strlen(field);
      field[lcount - 1] = 0;    /* remove \n */
      if ((cptr = strpbrk(field, "\013\014")) != NULL || (short) lineinct > linesperpage)
      {            /* new page */
        bpagec++;  /* ff or vt */
        lineinct = 1;   /* first line on new page */
        if (bpagec > pageend)
          break;   /* done */
        if ((display_braille && (bpagec > pagestart)))
        {          /* display braille */
          printf("%s\n", field);
          if (strlen(field) > 20)
            printf("       Copy %d of %d\n", copies, lastcopy);
        }          /* display_braille */
      }            /* new page */
      if (bpagec >= pagestart)
      {            /* process page */
        if (cptr)
        {          /* vt or ff */
          ch = *cptr;
          if (!pause_time)
            printf("%s\n", field);
          strcpy(field, cptr + 1);
          if (actualpage)
            write_char(ch);
          actualpage++;
          delay(emboss_delay);
          if (field[0])
            write_string(field);
        }          /* ff or vt */
        else
        {          /* no ff or vt */
          write_string(field);
          if (!pause_time)
            printf("%s\n", field);
        }          /* no f or vt */
      }            /* process page */
    }              /* while */
  }
  while (copies < lastcopy);
  fclose(intext);
  close(outf_des);
}                  /* emboss_file */

void get_page_range()
{
  char *cptr;
  if (pagestart <= 0)
  {                /* get starting page */
    pagestart = 1;
    fprintf(stderr, "Start at Page? 1\010");
    get_input(temp, 80);
    pagestart = (short) atoi(temp);
    cptr = strpbrk(temp, "-, ");
    if (cptr)
      pageend = (short) atoi(cptr + 1);
    if (pagestart <= 0)
      pagestart = 1;
  }                /* get starting page */
  /* if interpoint then pagestart should be odd */
  if (interpoint && (pagestart & 1) == 0)
    pagestart--;
  if (pageend < pagestart)
  {                /* pageend */
    pageend = 9999;
    fprintf(stderr, "Stop at Page (RETURN for end)? %d", pageend);
    backspace_int(pageend);
    get_input(temp, 5);
    pageend = (short) atoi(temp);
    if (!temp[0])
      pageend = 9999;
    if (pageend < 1)
      pageend = 9999;
  }                /* pageend */
}                  /* get_page_range */

void get_copies()
{
  if (lastcopy <= 0)
  {
    lastcopy = 1;
    printf("\nNumber of Copies? %d\010", lastcopy);
    get_input(temp, 80);
    lastcopy = (short) atoi(temp);
    if (lastcopy <= 0)
      lastcopy = 1;
  }
}                  /* get_copies */

void do_pause()
{
  short i;
  char *cptr;
  if (printit)
    if (stdout_tty)
    {              /* stdout is tty */
      if (!spool)
        strcpy(outf_name, "prn");
      else
      {            /* spool */
        /* get location of temp file */
        cptr = (char *) getenv("TMP");
        if (cptr)
          strcpy(temp, cptr);
        else
          temp[0] = 0;
        sprintf(outf_name, "%s%02d%02d%02d", temp, tm->tm_hour, tm->tm_min,
                tm->tm_sec);
        if (interpoint > 1)
          interpoint = 1;       /* don't eject blank page */
        printf("Creating %s\n", outf_name);
        return;
      }            /* spool */
    }              /* stdout is printer */
  if (pause_time && printit)
  {                /* pause */
    for (i = 0; i < pause_time; i++)
    {
      if (make_sound)
#ifdef DOS
        sound(440);
      delay(80);
      nosound();
#else              /* unix */
        beep(1);
#endif             /* DOS */
      delay(800);
      if (stdin_tty)
      {
        if (kbhit())
        {
          if (getch() == 27)
          {
            ab_flag = 1;
            return;
          }
          getch();
        }
      }
    }              /* i */
    skip_output = 1;
  }                /* pause */
}                  /* do_pause */

void write_string(char *string)
{
  int l;
#ifdef DOS
  l = sprintf(temp, "%s\r\n", string);
#else
#ifdef sysv
  l = sprintf(temp, "%s\n", string);
#else              /* not sysv */
  sprintf(temp, "%s\n", string);
  l = strlen(temp);
#endif             /* sysv */
#endif             /* DOS */
  if (write(outf_des, temp, l) < l)
    no_space();
  if (printit)
    delay(emboss_delay);
  if (stat_file[0])
    add_dots(string);
}                  /* write_string */

void write_char(char ch)
{
  if (write(outf_des, &ch, 1) <= 0)
    no_space();
}                  /* write_char */

void no_space()
{
  short i;
  fprintf(stderr, "Error with output space: ");
  perror("Error");
  if (!printit)
    fprintf(stderr, "\nInsufficient disk space\n");
  if (make_sound)
    for (i = 0; i < 5; i++)
    {
#ifdef DOS
      sound(1000);
      delay(500);
      sound(1500);
      delay(500);
#else              /* unix */
      beep(2);
#endif             /* DOS */
      delay(500);
    }
#ifdef DOS
  nosound();
#endif             /* DOS */
  exit(1);
}                  /* no_space */

void copy_string(char *string1, char *string2, short maxlen)
{                  /* copies at most length bytes of string2 into string1
                    * accounting for escaped characters */
  short i, j = 0, k;
  for (i = 0; (string2[i] != '\0' && j < maxlen); i++)
    if (string2[i] != '\\')
      string1[j++] = string2[i];
    else
    {              /* escape */
      i++;         /* skip \ */
      if (isdigit(string2[i]))
      {            /* digit */
        k = (short) atoi(string2 + i);
        if (k > 9)
          i++;
        if (k > 99)
          i++;
        string1[j++] = (char) k;
      }            /* digit */
    }              /* escape */
  string1[j] = '\0';
}                  /* copy_string */

void main(int argc, char *argv[])
{
  int i;
  paramcount = argc - 1;
  paramstr = argv;
#ifdef unix
  get_tablename(table_file);
#else              /* MS-DOS */
  strcpy(table_file, TABLENAME);
#endif             /* unix */
  get_config();
  if (no_copyright == FALSE)
  {                /* display message */
    fprintf(stderr, "\nNFBTRANS Grade Two Braille Translator - Release %s\n", VERSION);
    fprintf(stderr, "%s\n\n", COPYRIGHT);
  }                /* display message */
  load_tables();
  skip_output = 0;
  copies = 0;
  if (usr_default == FALSE && pagestart <= 1 && trans_mode <= 0)
  {                /* choose mode */
    fprintf(stderr, "\nPlease select\n");
    for (i = 0; i < max_menu; i++)
      fprintf(stderr, main_menu[i]);
    while (trans_mode % 10 < 1 || trans_mode % 10 > max_menu)
    {
      fprintf(stderr, "\nChoice? 1\010");
#ifdef DOS
      if (make_sound)
      {
        sound(440);
        delay(20);
        sound(1760);
        delay(20);
        nosound();
      }
#endif             /* DOS */
      get_digit();
      if (!temp[0])
        strcpy(temp, "1");
      trans_mode = (short) atoi(temp);
    }              /* while */
  }                /* choose mode */
  if ((trans_mode % 10) == 1 || usr_default == TRUE)
    translate_file();
  else
  {
    if ((trans_mode % 10) == 2)
      emboss_file();
    else
      backtranslate_file();
  }
  if (skip_output)
  {
    do_pause();
    getch();
  }
  if (!usr_default)
  {
    if (make_sound)
#ifdef DOS
      for (i = 22; i <= 9990; i++)
        sound(i);
    nosound();
#else              /* unix */
      beep(10);
#endif             /* DOS */
  }
  if (!no_copyright)
    printf("\nReturning to Operating System...");
  exit(0);
}                  /* main */
