              PAGE      ,132
              TITLE     Faster
;
; Program to reverse the effects of slower, that is restore the original
; timer tick interrupt vector and thus remove and delays that are slowing
; the system down.  Should only be run when slower is installed, and
; only if slower is the last thing sitting in the interrupt chain for the
; timer tick.  Otherwise, reboot the system instead.  This program assumes
; a fixed offset to the location of the old timer tick interrupt vector
; in slower, and thus is able to restore it.  If you change slower such
; that this address is relocated, change faster as well.  Note that faster
; does not actually remove slower from the system, so you will continue
; to waste the memory it occupies.  You will probably not notice this unless
; you run slower/faster a number of times.
;
; Below is the hex version of this program, which can be converted to
; FASTER.COM using hc/hexcnvrt...
;
; EB269053797374656D206E6F77206261636B20746F206E6F726D616C20737065
; 65642E2E2E0D0A24B409BA0301CD21B800008EC026A172008ED8B804018BF08B
; 0446468B1CFA26A3700026891E7200FBB44CB000CD21
;
; ;checksum 0
;
; No warranty is made of the suitability of this program for any purpose
; nor any guarantee that it will function as specified.  Use it at your
; own risk... Glenn Connery/BNR Inc. June 1/1985
;
              PAGE
;
;------------ EQUATES --------------------------------------------------------
;
CR            EQU       0DH
LF            EQU       0AH
;
;------------ INTERRUPT VECTOR TABLE -----------------------------------------
;
INTERRUPTS    SEGMENT   AT 0H
              ORG       1CH*4           ;TIMER TICK INTERRUPT VECTOR
TICKOFF       DW        ?
TICKSEG       DW        ?
INTERRUPTS    ENDS
;
;------------ PROGRAM START --------------------------------------------------
;
CODE_SEG      SEGMENT
              ORG       100H           ;ORG = 100H TO MAKE THIS A .COM FILE
              ASSUME    CS:CODE_SEG
FIRST:        JMP       FASTER
;
;------------ DATA -----------------------------------------------------------
;
MESSAGE       DB        'System now back to normal speed...',CR,LF,'$'
              PAGE
;
;------------ CODE -----------------------------------------------------------
;
FASTER        PROC      NEAR
              ASSUME    CS:CODE_SEG,DS:CODE_SEG

              MOV       AH,9                     ;OUTPUT MESSAGE TO USER
              MOV       DX,OFFSET MESSAGE
              INT       21H

              ASSUME    ES:INTERRUPTS            ;ES TO INT VECTOR TABLE
              MOV       AX,INTERRUPTS
              MOV       ES,AX

              ASSUME    DS:NOTHING

              MOV       AX,ES:TICKSEG            ;LOCATE THE SLOWER SEGMENT
              MOV       DS,AX                    ;AND LOAD INTO DS
              MOV       AX,104H                  ;OFFSET TO DATA AREA WHERE
              MOV       SI,AX                    ;OLD TIMER INT STORED
SI]               ;OLD OFFSET INTO AX
              INC       SI
              INC       SI
SI]               ;OLD SEGMENT INTO BX

              CLI                                ;NO INTERRUPTS..............>
              MOV       ES:TICKOFF,AX
              MOV       ES:TICKSEG,BX
              STI                                ;<...........................

              MOV       AH,4CH                   ;EXIT WITH NO ERRORS
              MOV       AL,0
              INT       21H
FASTER        ENDP
CODE_SEG      ENDS
              END       FIRST

