              PAGE      ,132
              TITLE     Slower
;
; Resident extension to slow down a PC.  Installs itself on the timer
; tick interrupt and inserts idle loops of specified duration into the
; processing of each tick, thus slowing down the system.  This is done
; with interrupts on, so that keystrokes, etc. are not lost.  The original
; reason for this program was to slow down a PC/AT to allow certain
; games written for the PC to be run at playable speeds.  It might be
; possible to use this to get other programs (like communication programs)
; to work on a PC/AT as well, but its lack of precision will probably
; prevent this.  Because some programs will play their own tricks with
; the timer tick interrupt vector, this process may not work for some
; programs, and could even hang the system.  I have tried it with a few
; simple BASIC games (like PCTREK) only to date.
;
; Syntax: slower <delay-character>
;
; If delay-char is not specified, then a few lines of help are presented
; and no installation is done.  Otherwise, the delay-character is used
; to determine how much slower to make things, and the program will install
; itself.  Most functions should execute normally, but the system should
; be noticibly slower.  The companion program, FASTER.COM, can be used to
; reverse the process and restore normal processing speed.  It should ONLY
; be run when slower is installed, and it may not always work.  See faster
; for details.
;
; The actual slowdown is relatively simple.  Since the timer tick occurs
; 18.2 times per second, we have approximately 55ms between interrupts.
; If we consume a certain amount of processing power in the tick int
; handler, then the system will slow down.  This is done by running the
; processor in a tight LOOP.  On the 286, a branching LOOP takes 8
; cycles, or 1.33 microseconds.  The delay character's ASCII value
; (from 33-126 for the visible characters !-~) is multiplied by 100 to
; determine the number of cycles, which gives us processing delays of
; about 4ms to 20ms.  At 20ms the system is really dogging it.  If you
; need a bigger range, you can always pass control characters or even
; use the ALT-keypad method to get characters up to 255 (34 ms).
;
; Generally, experimentation seems to work best... try lower-case letters
; to start, and use faster after each test.  If you run slower on top
; of itself, effects are cumulative and the system could slow down so
; much as to be unusable...
;
              PAGE
;
; Below is the hex version of this program, which can be converted to
; SLOWER.COM using hc/hexcnvrt:
;
; E9C10090000000000000519C2EFF1E0401FB2E8B0E0801E2FE59CF0053797374
; 656D206E6F7720736C6F77696E6720646F776E2E2E2E0D0A2453796E7461783A
; 20736C6F776572203C686F776D7563683E0D0A0A686F776D7563682069732061
; 6E79206368617261637465722066726F6D202120746F207E20616E640D0A6465
; 7465726D696E657320686F77206D75636820736C6F7765722074686520737973
; 74656D0D0A77696C6C2072756E20616674657220696E7374616C6C6174696F6E
; 2E0D0A24803E800002740DB409BA3901CD21B44CB001CD21A08200B364F6E3A3
; 0801B409BA1C01CD21B800008EC026A17000A3040126A17200A30601FA26C706
; 70000A01268C0E7200FBB431B000BA1B01CD21
;
; ;checksum 2005
;
; No warranty is made of the suitability of this program for any purpose
; nor any guarantee that it will function as specified.  Use it at your
; own risk... Glenn Connery/BNR Inc. June 1/1985
;
              PAGE
;
;------------ EQUATES --------------------------------------------------------
;
CR            EQU       0DH
LF            EQU       0AH
;
;------------ INTERRUPT VECTOR TABLE -----------------------------------------
;
INTERRUPTS    SEGMENT   AT 0H
              ORG       1CH*4           ;TIMER TICK INTERRUPT VECTOR
TICKOFF       DW        ?
TICKSEG       DW        ?
INTERRUPTS    ENDS
;
;------------ PROGRAM START --------------------------------------------------
;
CODE_SEG      SEGMENT
              ORG       80H
PARMLEN       DB        ?
PARMS         DB        127 DUP (?)
              ORG       100H           ;ORG = 100H TO MAKE THIS A .COM FILE
              ASSUME    CS:CODE_SEG
FIRST:        JMP       LOAD_SLOW      ;FIRST TIME JUMP TO INITIALIZE ROUTINE
;
;------------ LOCAL DATA DECLARATIONS ----------------------------------------
;
              EVEN
OLD_TICK      DD        ?              ;LOCATION OF OLD TIMER TICK INTERRUPT
COUNT         DW        0
              PAGE
;
;------------ TIMER TICK INTERRUPT NOW COMES HERE ------------------------------
;
SLOW          PROC      NEAR
              ASSUME    CS:CODE_SEG,DS:NOTHING
              PUSH      CX
;
; First call original interrupt handler.  Since it will return with an IRET
; we need to set up the stack properly, as if we were calling it via an
; interrupt.  Pushing the flags and then doing a long call accomplishes this
; by pushing the flags, then CS then IP.
;
              PUSHF
              CALL      OLD_TICK
;
; Turn on interrupts to avoid interfering with keyboard handling etc.
;
              STI
;
; Now comes the slowdown...
;
              MOV       CX,CS:COUNT
WASTE:        LOOP      WASTE
;
;------------ TERMINATE: RESTORE REGISTERS AND RETURN FROM INTERRUPT ---------
;
              POP       CX
              IRET
SLOW          ENDP
              PAGE
;
;------------ TRANSIENT DATA -------------------------------------------------
;
LASTBYTE      DB        ?
INSTALLED     DB        'System now slowing down...',CR,LF,'$'
HELPMSG       DB        'Syntax: slower <howmuch>',CR,LF,LF
              DB        'howmuch is any character from ! to ~ and',CR,LF
              DB        'determines how much slower the system',CR,LF
              DB        'will run after installation.',CR,LF,'$'
;
;------------ EXECUTED FIRST TIME THROUGH: LOAD ROUTINE ----------------------
;
LOAD_SLOW     PROC      NEAR
              ASSUME    CS:CODE_SEG,DS:CODE_SEG
;
; Check parameters... if none given then output help info and exit
;
              CMP       PARMLEN,2
              JE        CONTINUE

              MOV       AH,9
              MOV       DX,OFFSET HELPMSG
              INT       21H

              MOV       AH,4CH
              MOV       AL,1
              INT       21H
;
; Take the character specified, and multiply its ascii code by 1000
; and save in count.  This produces a range of delays in timer tick
; processing varying from about 4ms (for !) to 20ms (for ~).  Since
; the timer ticks occur 18.2 times a second they occur every 55ms
; or so, which seems to give us a reasonable, if not very exact, range.
;
1]
              MOV       BL,100
              MUL       BL
              MOV       COUNT,AX

              MOV       AH,9                     ;INSTALLED OK
              MOV       DX,OFFSET INSTALLED
              INT       21H

              ASSUME    ES:INTERRUPTS
              MOV       AX,INTERRUPTS
              MOV       ES,AX

              MOV       AX,ES:TICKOFF            ;SAVE THE ORIGINAL INTERRUPT
              MOV       WORD PTR OLD_TICK,AX
              MOV       AX,ES:TICKSEG
2],AX

              CLI                                ;NO INTERRUPTS..............>
              MOV       ES:TICKOFF,OFFSET SLOW
              MOV       ES:TICKSEG,CS
              STI                                ;<...........................

              MOV       AH,31H                   ;EXIT AND STAY RESIDENT
              MOV       AL,0                     ;NO ERRORS
              MOV       DX,OFFSET CS:LASTBYTE    ;EXEMPT LOAD ROUTINE
              INT       21H
LOAD_SLOW     ENDP
CODE_SEG      ENDS
              END       FIRST

