Appendix A - ACCENT SYNTHESIZERS

"J_ACNTPC.EXE" is the Jaws version for the Accent internal
synthesizers from Aicom Corporation.  "J_ACNTSA.EXE" is the Jaws
version for the Accent SA stand-alone synthesizer.

Accent PC:  This is an internal board that uses a device driver to
communicate with Jaws.  Install the Accent PC board in the computer
as you would any other board.  For tips on doing this refer to the
section on Installing Synthesizers.  Connect a speaker or
headphones to the output jack by the volume knob and turn on the
PC.  It should say "Accent Ready".  

The device driver is a file named "SPKACNT.DVC" on your Accent
disk.  There may also be a copy on your Jaws disk.  Follow these
steps:

1.  Be sure the driver file is in the Jaws subdirectory of your
boot disk.  If it was not put there with the rest of the Jaws files
copy it to that subdirectory at this time.

2.  Add the following line to your CONFIG.SYS file:

device=\jaws\spkacnt.dvc

If you do not have a CONFIG.SYS file then create one using EDLIN or
some other editor or word processor.  After the device driver has
been installed re-boot the PC.  It should say "accent ready" two
times:  First, when power is turned on, then again when the device
driver is loaded.  If you do not hear it twice you have a problem;
go back and review these instructions, or the instructions in the
Accent manual, and check your work (Note:  The Mini and Toshiba
models say "ready" only once).  If it does not seem to be working
properly refer to "Hardware Conflicts" below.

Jaws and Accent will communicate "through" LPT3 as the default.  If
you want to use another parallel port refer to "Changing Ports"
below.  Refer to "Running Jaws" below for tips on running Jaws.

Accent MC (Micro Channel):  This is very similar to the Accent PC
as far as Jaws is concerned.  Refer to the Accent manual for
installation tips, and see the section above on the Accent PC for
installing the Accent driver (SPKACNT.DVC) and Jaws tips.

Accent Mini:  This is similar to the Accent PC discussed above, but
it uses a different device driver, "SPKMINI.DVC", and some versions
may use "SPKEMS.DVC", check your Accent manual to be sure.  Install
this device driver in the CONFIG.SYS file as described above for
the Accent PC.

Accent for the Toshiba Lap Tops:  These are internal synthesizers
that use a device driver, similar to the Accent PC.  Be sure you
have a line in the config.sys file to load the device driver, refer
to the Accent manual for your model to see which driver file you
should use.  It is most likely "SPKEMS.DVC".  Refer to the section
on Toshibas for more tips on these systems.

Running Jaws with Accent internals:  The Accent PC, MC, Mini, and
Toshiba models are all internal synthesizers and use the same
version of Jaws, "J_ACNTPC.EXE".  After the synthesizer and device
driver are installed correctly then you can load Jaws.  Move to the
Jaws subdirectory (or wherever you have Jaws installed) and enter
the following:

J_ACNTPC

Naturally you can use any of the relevant command line parameters,
like "/E" or "/C".  These are explained more completely in "Command
Line Parameters".  For more details refer to "Running Jaws".  For
the Toshiba models do not forget "/T" as a command line parameter. 

Accent SA (stand alone) Synthesizer:  This is a separate box,
connected to a serial port, either Com1 or Com2, the default is
Com1.  Use the cable we provide, or a straight-through modem cable. 
Be sure the "dip" switches on the back of the Accent are all off
except 4 & 8 on.  Version 4.0 (on/off switch on front) has the dip
switches down for on, older versions (on/off switch on back) have
the dip switches up for on.  This will set the communications
parameters to 9600 BAUD, Noparity, 7 data bits, 1 stop bit
(COM1:9600,N,7,1).  Turn on the accent, it should say "accent
ready".  For more details on installing and connecting or trouble-
shooting refer to the section on serial synthesizers.

Running Jaws with the Accent SA:  Change to the Jaws subdirectory
and then enter:

J_ACNTSA

or, if you are connected to com2 enter:

J_ACNTSA COM2:

If you need to use Com3 or Com4 just substitute the "3" or "4"
instead of "2" in the command above.  The Jaws logo should appear
on the screen and you should hear the registered Jaws users name
followed by "Jaws ready".  If there is a problem please refer to
the section on serial synthesizers.

Refer to the Jaws manual and training tapes for details on Jaws
features.

Extra Voice Parameters

Jaws has an "Extra" menu in the Voice menu for extra features that
may be specific to the Accent synthesizers.  Here we can put things
like "Abbreviations on/off" that other synthesizers may not have. 
Here are the Extra features:

Fast processing:  When on Accent gets the first 2 or 3 words and
starts speaking right away, in order to improve responsiveness. 
When off Accent waits for the end of the sentence or phrase, then
looks at the whole and provides some natural inflection.  The
response is slower, but may not be noticeable.

Intonation:  You have five choices, five levels off sentence
intonation.  It will speak very monotone, very lively, or in
between.  Experiment to find which you like the best.

Abbreviations:  Accent has many built-in abbreviations, like TX for
Texas.  When this parameter is "on" the abbreviations will be used
to affect the speech, when off naturally they will be ignored.  For
a complete list refer to your Accent manual (which is also provided
on disk).  Be aware that what you hear may not be exactly what
appears on the screen because the abbreviations may be affecting
it.

Single stress:  If this is on, letters appearing by themselves will
be emphasized.  For example "Suite C on the third floor".  This is
a very subtle change.

Hard A:  The letter "a" can be pronounced "ay" or "ah".  If you
want "ay" turn this on.  Otherwise Accent will decide for itself
according to context.

Punctuation on/off: This is found under "Punctuation" in the extra
menu, it turns on or off the speaking of a certain set of symbols. 
Normally Jaws translates some of the symbols before they get to the
Accent, this is controlled in the "Symbols" menu in the Voice-
Universal menu. If you want to experiment with Accent handling its
own punctuation then be sure that Jaws's symbols menu is set to
off, otherwise you may get some symbols spoken twice.  The default
for Accent's Punctuation on/off is off.

Punctuation all/some:  This is similar to Punctuation on/off
discussed above, except that it affects a different set of symbols
and the default is on.

You can use a Jaws macro to set or toggle some of the parameters in
the Extra menu.  Refer to the discussion in the Macros chapter
about "Voice Parameters and Macros".  These are the supported
Synth1 parameters for the Accents:

F = Fast processing
S = Single stress
A = Abbreviations
H = Hard A
O = Punctuation on/off
P = Punctuation all/some

Changing Ports with the internal Accents:  Use the "SETACNT"
program on the Accent disk to tell the device driver to use a
different port.  Instructions are in the Accent manual.  If you
change the device driver to another port with the setacnt program
then you must tell Jaws to use the new  port, LPT1 through LPT8. 
For Example:

J_ACNTPC LPT2

J_ACNTPC LPT8

Networks:  If you are on a network you may have a conflict.  Many
networks like to "grab" LPT3 and sometimes other printer ports for
"network" printers.  They will trap or grab all information going
out the LPT port and "spool" it for output on the network printer. 
You must resolve this conflict for Jaws and Accent to work.  You
can re-configure the network (your work station) to not use LPT3,
or you can setup Jaws and Accent to use another printer port, as
discussed above.

Hardware Conflicts

Even though the Accent PC is a very "compatible" board and is
usually very easy to get along with, occasionally a "problem" will
develop.  The most common is a base address conflict; sometimes the
hard disk controller will be configured to use the same base
address or I/O address as the Accent.  When this occurs the
symptoms are as follows:

1.  When the computer is turned on it will say "Accent ready" as it
should.
2.  When the Accent driver file is loaded it will say "Accent
ready" just as it should.
3.  The computer will act and perform normally, you can even run
the Accent demo program and it will perform okay.
4.  When you load "J_ACNTPC" it will not say the user's name or
"Jaws ready" as it should, and the system will be locked up. It may
say a few characters here and there, now and then, but it will be
obvious that something is wrong.

If you experience these symptoms it is time to change the base
address of the Accent.

The I/O Address, or Base Address, is controlled by Switch #2, which
is about 1.5 inches from the bottom of the board, directly above
the left edge of the edge connector.  On is up, off is down,
therefore up =0, down =1; switches are numbered 1-8 from left to
right;  Therefore we recommend that you hold the board upside-down,
so that up = on = 1, and the most significant digit is on the left
(8-1 from left to right).  These switches represent bits in a
binary number, but you have to add two zeroes on the right side
(least significant) in order to convert correctly to binary or
hexadecimal.  Take switches 8,7,6,5,4,3,2,1, add two zeroes, then
convert to hex based on this binary number.  Default is 1010101000
binary, equals 2A8 hex.  Do not forget that the two zeroes on the
right are always zero and that there are no physical switches to
represent that position.  Do not use 2DX, this is the address of
the hard disk controller (x represents 1 digit).  Do not use 2Fx,
32x, 33x, 37x, 38x.  100 through 1ff hex is reserved for output use
only, do not use. 39x is the highest available address.  

300 hex is used by the Prose 4000.  To set this address for the
Accent PC, first convert to binary:  300 hex = 1100000000.  To
convert to the proper switch pattern drop off the 2 zero's on the
right, remember to turn the card upside-down, then first digit on
left matches first switch on left, and up = 1, down = 0.  The first
two switches on left should be up, the rest down.  

Setacnt Program:  After changing the switches on the synthesizer
board you must use "SETACNT" to change the device driver:  Type
"SETACNT SPKACNT.DVC" and press enter; If it cannot find the device
driver be sure you are on the correct disk or sub-directory or you
have a path defined.  Select "2" from the menu;  enter the address
in hex, e.g "300" or "2A8".  This address value must match what the
board is set to.  then press "5" and "y" to exit.

If you do not want to figure out the binary to hexadecimal to
switch arithmetic take a look at the following chart.  It shows the
hex address on the left and the position of each switch, note the
number of the switches at the top, and that "o" means on, "f" means
off.  Since the numbers of the switches run from 1-8 left-right the
"board" is not upside down for the purposes of this chart.

Accent PC Switches 
 
Address    1  2  3  4  5  6  7  8 
-------    -  -  -  -  -  -  -  -
200-203    O  O  O  O  O  O  O  F
204-207    F  O  O  O  O  O  O  F
208-20B    O  F  O  O  O  O  O  F
20C-20F    F  F  O  O  O  O  O  F
250-253    O  O  F  O  F  O  O  F
254-257    F  O  F  O  F  O  O  F
258-25B    O  F  F  O  F  O  O  F
25C-25F    F  F  F  O  F  O  O  F
260-263    O  O  O  F  F  O  O  F
264-267    F  O  O  F  F  O  O  F 
268-26B    O  F  O  F  F  O  O  F 
26C-26F    F  F  O  F  F  O  O  F 
270-273    O  O  F  F  F  O  O  F 
280-283    O  O  O  O  O  F  O  F 
284-287    F  O  O  O  O  F  O  F 
288-28B    O  F  O  O  O  F  O  F 
28C-28F    F  F  O  O  O  F  O  F 
290-293    O  O  F  O  O  F  O  F 
294-297    F  O  F  O  O  F  O  F 
298-29B    O  F  F  O  O  F  O  F 
29C-29F    F  F  F  O  O  F  O  F 
2A0-2A3    O  O  O  F  O  F  O  F 
2A4-2A7    F  O  O  F  O  F  O  F 
2A8-2AB    O  F  O  F  O  F  O  F 
2AC-2AF    F  F  O  F  O  F  O  F 
2B0-2B3    O  O  F  F  O  F  O  F 
2B4-2B7    F  O  F  F  O  F  O  F 
2B8-2BB    O  F  F  F  O  F  O  F 
2BC-2BF    F  F  F  F  O  F  O  F 
2C0-2C3    O  O  O  O  F  F  O  F 
2C4-2C7    F  O  O  O  F  F  O  F 
2C8-2CB    O  F  O  O  F  F  O  F 
2CC-2CF    F  F  O  O  F  F  O  F 
300-303    O  O  O  O  O  O  F  F 
304-307    F  O  O  O  O  O  F  F 
308-30B    O  F  O  O  O  O  F  F 
30C-30F    F  F  O  O  O  O  F  F 
310-313    O  O  F  O  O  O  F  F 
314-317    F  O  F  O  O  O  F  F 
318-31B    O  F  F  O  O  O  F  F 
31C-31F    F  F  F  O  O  O  F  F 