Appendix O - SOUNDING BOARD


"J_SB.EXE" is the Jaws version for the Sounding Board from GW
Micro.

Hardware Installation

The Sounding Board is an internal synthesizer that must be put
inside your computer.  For tips on installing it in a PC refer to
the appendix on hardware installation.  If you have a Toshiba 1200
there is a slot that it fits into.  If you have a Toshiba 1000 you
must take the computer apart, we do not recommend this for the
novice.

Software Installation

The Sounding Board  requires extra software provided with the
board.  These files are called "SBLOAD.COM" and "SB.COM", be sure
you have them.  We recommend that you copy them into your Jaws
subdirectory with all the other Jaws files (see Jaws Software
Installation).

To use Jaws with the Sounding Board you first run "SBLOAD", then
"SB", then "J_SB".  Here is a sample batch file, which could be
part of your autoexec.bat file:

sbload
sb /k0
j_sb

This sample assumes that your board is set for IRQ 2, below is a
sample set for IRQ 7.  Notice the "/k0" command line parameter,
this tells SB to not take over the function keys.  Following is a
more complete batch file using IRQ 7:

echo off
path \;\jaws;\dos
prompt $p$g
cd\jaws
numoff
sbload 
sb /!i7 /k0
j_sb

Notice that this file defaults to the Jaws subdirectory before
loading any of the files, it does not take over the function keys,
and it uses IRQ 7.  Remember that the IRQ setting in the software
must match the IRQ set on the board.

Here is another sample batch file, which works well on a PS2 model
30-286.  note the "sbload /!md" to load in memory, not the ram on
the board.  note the "/!o1 /!r1" to reduce the speech buffers, this
keeps the cursor close to the speech. This file is set up for IRQ
7, be sure your board is also, or change this parameter.

echo off
path \;\jaws;\dos
prompt $p$g
KEYB US 437 
cd\jaws
numoff
sbload /!md
sb /!i7 /k0 /!o1 /!r1
j_sb

On your Jaws disk for the Sounding Board version you will find
three sample autoexec.bat files that you are welcome to use. 
"AUTOEXEC.1" is similar to the sample above, for a PS2-30-286,
using the computers RAM and small speech buffers and IRQ 7. 
"AUTOEXEC.2" is similar, but it uses the default speech buffers. 
Change these as you see fit to suit your needs.

If you have a Toshiba 1000 and the Sounding Board Lite then you
should use "autoexec.3", which has a special command line parameter
for the Toshiba: "/!BS".  Here is a copy of it:

a:
sbload
sb /!bs /k0
j_sb

We also suggest that you read the Sounding Board manual for an
explanation of more of its features.  The Jaws Extra Menu gives you
access to some of these features.

Extra Voice Parameters

Jaws has an "Extra" menu in the Voice menu for extra features that
may be specific to your synthesizer.  Here we can put things like
"Abbreviations on/off" that other synthesizers may not have.  Here
are the Extra features for the Sounding Board:

Numbers: Allow SB to handle the speaking of numbers.

Punctuation:  Let SB handle the speaking of punctuation symbols,
gets you to a sub-menu with several choices.  Normally Jaws
translates some of the symbols before they get to the Sounding
Board, this is controlled in the "Symbols" menu in the Voice-
Universal menu. If you want to experiment with Sounding Board
handling its own punctuation then be sure that Jaws's symbols menu
is set to off, otherwise you may get some symbols spoken twice and
others not at all.

Sentence:  Adjust the pause between sentences.

Hyper:  Skip over any words that are 4 characters or less, speeds
up reading, lets you scan through text.

Case:  Beep if upper case letter.

Format:  Beeps for blank spaces.

Alpha: Short for Alpha/Numeric, spell if word contains digits.

Date time:  Gets you to a sub-menu so you can ask it for the date
or the time.

You can use a Jaws macro to set or toggle some of the parameters in
the Extra menu.  Refer to the discussion in the Macros chapter
about "Voice Parameters and Macros".  These are the supported
Synth1 parameters for the Sounding Board:

N = Numbers
H = Hyper text
C = Capitalization alert, beep if upper case
F = Format alert
A = Spell if word contains digits
