procedure Brite_color;
begin
  textbackground(brite_b);
  textcolor(brite_f);
end;

procedure normcolor;
begin
  textbackground(norm_b);
  textcolor(norm_f);
end;

const _vid_mode : integer = -1;

procedure get_vid_mode;
var regs : registers;
begin
  regs.ax := $0F00;
  intr($10,regs);
  _vid_mode := regs.ax AND $FF;
end;

procedure video_disable;
begin
  repeat until (Port[$03DA] AND 8 = 8);
  Port[$03D8] := $25;
end;

procedure video_enable;
begin
  case _vid_mode of
    2 : Port[$03D8] := $2D;
    3 : Port[$03D8] := $29;
  end;
end;


procedure save_screen;
begin
  old_x := WhereX;
  old_y := WhereY;
  video_disable;
  move(video, save_image , 4000);
  video_enable;
end;

procedure restore_screen;
begin
  window(1,1,80,25);
  video_disable;
  move(save_image, video, 4000);
  video_enable;
  gotoxy(old_x,old_y);
end;

procedure save_entry_screen;
begin
  if _vid_mode = -1 then get_vid_mode;
  curs_x := whereX;
  curs_y := whereY;
  video_disable;
  move(video,screen1,4000);
  video_enable;
end;

procedure restore_entry_screen;
begin
  video_disable;
  move(screen1,video,4000);
  video_enable;
  window(1,1,80,25);
  gotoxy(curs_x,curs_y);
end;

procedure save_attr(var f,b : integer; x1,y1: integer);
var attr : integer;
begin
  video_disable;
  attr := video[ (x1 + WhereX - 2)*2 + (y1 + WhereY - 2)*160 + 1 ];
  video_enable;
  f := attr AND $0F;
  b := (attr SHR 4) AND $0F;
end;

procedure restore_attr(f,b : integer);
begin
  textcolor(f);
  textbackground(b);
end;

procedure hide_cursor;
var regs : registers;
begin
  regs.bx := 0;
  regs.dx := 25 SHL 8 ;
  regs.ax := $0200;
  intr($10,regs);
end;

