procedure save_init;
var  init_file : text;
begin
  assign(init_file,'INIT.FDY');
  rewrite(init_file);
  writeln(init_file,default_file);
  writeln(init_file,my_mult);
  writeln(init_file,norm_b:3,norm_f:3);
  writeln(init_file,brite_b:3,brite_f:3);
  if auto_section = TRUE
    then writeln(init_file,'Y')
    else writeln(init_file,'N');
  if tunes = TRUE
    then writeln(init_file,'Y')
    else writeln(init_file,'N');
  close(init_file);
end;

procedure read_init;
var  init_file : text;
     dmy : any_string;
     i, c1, c2 : integer;
     c : char;
begin
  default_file := 'FIELD.DAY';
  auto_section := TRUE;
  tunes := TRUE;
  assign(init_file,'INIT.FDY');
  {$I-}
  reset(init_file);
  if (IOresult = 0 ) then
  begin
    c1 := 1; c2 := 1;
    readln(init_file,dmy);
    if pos(';',dmy) > 0 then               { find comment field if any }
      dmy := copy(dmy,1,pos(';',dmy)) + ' ';
    while(dmy[c1]=' ') do                  { strip leading blanks }
      begin
        c1 := c1 + 1;
        c2 := c2 + 1;
      end;
    c2 := c2 + 1;
    while (dmy[c2] <> ' ') do              { strip trailing blanks }
      c2 := c2 + 1;
    default_file := copy(dmy,c1,c2-c1);
    read(init_file,my_mult); readln(init_file);
    read(init_file,norm_b);
    read(init_file,norm_f);  readln(init_file);
    read(init_file,brite_b);
    read(init_file,brite_f); readln(init_file);
    read(init_file,c); readln(init_file);
    if c in ['y','Y'] then auto_section := TRUE;
    read(init_file,c); readln(init_file);
    if c in ['y','Y'] then tunes := TRUE;
    close(init_file);
  end;
  band := B160;
  op_mode := CW;
  tbranch^.leaf.xmtmode := op_mode;
  tbranch^.leaf.band := band;
  tbranch^.leaf.callsign := '';
  tbranch^.leaf.section := '';
  tbranch^.leaf.date := '';
  tbranch^.leaf.time := '';
  for i := 0 to 10 do contacts[i] := 0;
  total_contacts := 0;
  score := 0;
end;

procedure b_w;
begin
  textcolor(7);
  textbackground(0);
end;

procedure what_color(i : integer);
begin
    case i of
      0 : write ('BLACK        ');
      1 : write ('BLUE         ');
      2 : write ('GREEN        ');
      3 : write ('CYAN         ');
      4 : write ('RED          ');
      5 : write ('MAGENTA      ');
      6 : write ('BROWN        ');
      7 : write ('WHITE        ');
      8 : write ('GRAY         ');
      9 : write ('LIGHT BLUE   ');
      10 : write('LIGHT GREEN  ');
      11 : write('LIGHT CYAN   ');
      12 : write('LIGHT RED    ');
      13 : write('LIGHT MAGENTA');
      14 : write('YELLOW       ');
      15 : write('BRIGHT WHITE ');
    end;
  hide_cursor;
end;

procedure sho_auto;
begin
  gotoxy(52,6);
  b_w;
  if auto_section = TRUE then writeln('SECTION LIST')
                         else writeln('MANUAL ENTRY');
  hide_cursor;
end;

procedure sho_tunes;
begin
  gotoxy(52,7);
  b_w;
  if tunes = TRUE then writeln('ON ')
                  else writeln('OFF');
  hide_cursor;
end;

procedure sho_norm;
begin
  normcolor;
  gotoxy(52,8); what_color(norm_b);
  gotoxy(52,9); what_color(norm_f);
  b_w;
end;

procedure sho_brit;
begin
  brite_color;
  gotoxy(52,10); what_color(brite_b);
  gotoxy(52,11); what_color(brite_f);
  b_w;
end;

procedure sho_default;
begin
  b_w; gotoxy(52,12); ClrEol; write(default_file);
end;

procedure setup;
var skey : char;
begin
  b_w;
  window(1,1,80,25);
  clrscr;
  gotoxy(20,6); write('<1> Selection Mode ............'); sho_auto;
  gotoxy(20,7); write('<2> Sound .....................'); sho_tunes;
  gotoxy(20,8); write('<3> Normal Background Color ...'); sho_norm;
  gotoxy(20,9); write('<4> Normal Forground color ....'); sho_norm;
  gotoxy(20,10); write('<5> Hi-lite Background color ..'); sho_brit;
  gotoxy(20,11); write('<6> Hi-lite Forground color ...'); sho_brit;
  gotoxy(20,12); write('<7> Default Log Path/Filename .'); sho_default;
  gotoxy(20,13); write('<S> Save init values to INIT.FDY');
  gotoxy(20,15); write('<ESC> done');
  hide_cursor;
  repeat
    skey := readkey;
    case skey of
     '1' : begin
             auto_section := NOT auto_section;
             sho_auto;
           end;
     '2' : begin
             tunes := NOT tunes;
             sho_tunes;
           end;
     '3' : begin
             norm_b := (norm_b + 1) AND 7;
             sho_norm;
           end;
     '4' : begin
             norm_f := (norm_f + 1) AND 15;
             sho_norm;
           end;
     '5' : begin
             brite_b := (brite_b + 1) AND 7;
             sho_brit;
           end;
     '6' : begin
             brite_f := (brite_f + 1) AND 15;
             sho_brit;
           end;
     '7' : begin
             gotoxy(52,12); ClrEol;
             readln(default_file);
             UpperCase(default_file);
             sho_default;
           end;
     'S','s' : save_init;
     #0 : skey := readkey;
    end;
  until skey = #27;
  color_image;
  normcolor;
end;


