{ ***********   COMPARISON AND PRINTING ROUTINES FOR FD Lists ********** }

{ NOTE  -- 86 rules defined CW, ASCII, RTTY & AMTOR to be 'cw' modes
                            AM, FM, SSB to be 'phone' modes
                       and  PACKET a unique mode
       the check_mode function complies with that requirement -- may
       have to be changed if rules change
       It should return  0 if mode 1 = mode 2
                        -1 if mode 1 < mode 2
                         1 if mode 1 > mode 2
}

procedure add_to_score;
begin
  total_contacts := total_contacts + 1;
  contacts[ord(pdata.band)] := contacts[ord(pdata.band)] + 1;
  case pdata.xmtmode of
    SSB, AM, FM : score := score + my_mult;
    CW, RTTY, AMTOR, PACKET : score := score + my_mult*2;
  end;
end;

procedure sub_fm_score(pdata : data);
begin
  total_contacts := total_contacts - 1;
  contacts[ord(pdata.band)] := contacts[ord(pdata.band)] - 1;
  case pdata.xmtmode of
    SSB, AM, FM : score := score - my_mult;
    CW, RTTY, AMTOR, PACKET : score := score - my_mult*2;
  end;
end;

function check_if_ok;
var chk_key : char;
    key_ok  : boolean;
begin
  gotoxy(12,16); ClrEol;
  Brite_color;
  with d1 do
    writeln(callsign:6,
            class:5,
            pmodstr(xmtmode):7,
            bandstr(band):4,
            section: 15,
            date:9,time:6);
  normcolor;
  gotoxy(30,18);
  write('<D>elete, <N>ext, <Esc>ape ...');
  key_ok := FALSE;
  repeat
    chk_key := readkey;
    case chk_key of
      'd','D' : begin
                  check_if_ok := 1;
                  sub_fm_score(d1);
                  key_ok := TRUE;
                end;
      'n','N' : begin
                  check_if_ok := 0;
                  key_ok := TRUE;
                end;
      #27     : begin
                  check_if_ok := -1;
                  escape := TRUE;
                  key_ok := TRUE;
                end;
      #0      : chk_key := readkey;
    end;
  until key_ok;
  gotoxy(1,16); ClrEol;
  gotoxy(1,18); ClrEol;
end;

var  del_ptr : LINK;

procedure delete_entry;
label esc_out;
var it_was : boolean;
    tstmode : mode;
    tstband : hamband;

  procedure d_entry(m : mode);
  begin
    del_ptr^.leaf.xmtmode := m;
    if (find(root,del_ptr) <> NIL)
      then it_was := delete(root,del_ptr);
  end;

begin
  del_ptr^.leaf.callsign := '';
  escape := FALSE;
  gotoxy(30,16);
  write('Enter callsign : ');
  readln(del_ptr^.leaf.callsign);
  UpperCase(del_ptr^.leaf.callsign);
  while length(del_ptr^.leaf.callsign) < 6 do
    del_ptr^.leaf.callsign := ' ' + del_ptr^.leaf.callsign;
  for tstband := B440 downto B160 do
    begin
      del_ptr^.leaf.band := tstband;
      d_entry(CW); if escape = TRUE then goto esc_out;
      d_entry(SSB); if escape = TRUE then goto esc_out;
      d_entry(PACKET); if escape = TRUE then goto esc_out;
    end;
esc_out:
end;

{ ***********   --------------------------------------------- ********** }

procedure utility;
var ukey : char;
begin
  save_screen;
  clrscr;
  window(20,9,65,24);
  gotoxy(1,1);
  writeln('UTILITIES: <L>oad data file ');
  writeln('           <S>ave data file ');
  writeln('           <D>elete entry');
  writeln('           <P>rint log');
  writeln('           <I>nit Parameters');
  writeln('           <E>xit program');
  write  ('           <ESC>ape ......');
  window(1,1,80,24);
  repeat ukey := readkey
  until  ukey in ['d','D','e','E','i','I','p','P','l','L','s','S',#27];
  case ukey of
    'e','E': begin
               clrscr;
               write('Exit to DOS .. <Y/N> ..');
               repeat ukey := readkey
               until ukey in ['n','N','y','Y'];
               case ukey of
                 'y','Y' : begin
                             restore_entry_screen;
                             halt;
                           end;
               end;
             end;
    'i','I': setup;
    'l','L': begin
               clrscr;
               read_file;
             end;
    'd','D': delete_entry;
    'p','P': begin
               window(1,1,80,24);
               clrscr;
               line_nbr := 0;
               tprint(root);
               if (escape = FALSE) then
               begin
                 gotoxy(30,24);
                 write('Press <Retrn> to continue ..');
                 repeat ukey := readkey until ukey = #13;
               end;
               escape := FALSE;
             end;
    's','S': write_file(root);
    #27    : ukey := ' ';
  end;
  restore_screen;
  window(1,1,80,25);
  hide_cursor;
end;

procedure out_of_memory;
begin
  sound(440);
  delay(1000);
  sound(360);
  delay(1000);
  nosound;
end;

