REM Sidebar from July 1997 QST Hints and Kinks Column
REM QBASIC Program
REM Computer Frequency Control of a Modified IC-245
REM STEPTUNE.BAS
REM K8CG 6/30/96
REM Demonstrate tuning radio using parallel port pulses

ParPortAddr = &H378 'Address of parallel port
TuneUpBit = 1 'Bit in par port to pulse UP
TuneDnBit = 2 'Bit in par port to pulse DN
StaticByte = 252 'State of par port when idle
DelayCount = 10 'Delay counter, adj for 1msec
TuneStep = 100 'Step size of VFO (Hz)

REM ************** MAIN LOOP ****************

INPUT "Starting Frequency (MHz):"; OldFreq

MainLoop:

INPUT "New Frequency (MHz) :"; NewFreq
GOSUB DeltaTune
GOTO MainLoop

REM ************** SUBROUTINES *****************
DeltaTune:
NSteps = (NewFreq - OldFreq) * 1000000! / TuneStep
IF NSteps = 0 THEN RETURN
FOR I = 0 TO ABS(NSteps) - 1
	IF NSteps < 0 THEN
		GOSUB PulseDn
	ELSE
		GOSUB PulseUp
	END IF
NEXT I
OldFreq = NewFreq
RETURN

PulseUp:
REM Toggle the proper bit (pulse on)
OUT ParPortAddr, (TuneUpBit XOR StaticByte)

REM Delay - adjust for 100 usec to 1 msec
FOR Counter = 0 TO DelayCount
NEXT Counter

REM Restore the bit (pulse off)
OUT ParPortAddr, StaticByte

RETURN

PulseDn:

REM Toggle the proper bit (pulse on)
OUT ParPortAddr, (TuneDnBit XOR StaticByte)

REM Delay - adjust for 100 usec to 1 msec
FOR Counter = 0 TO DelayCount
NEXT Counter

REM Restore the bit (pulse off)
OUT ParPortAddr, StaticByte
RETURN

