;-------------------------------------------------------------------;
;   EnvRetco.asm  v0.13                                 01/02/92    ;
;-------------------------------------------------------------------;
;  Program spawns specifed process and places return code of child  ;
;  process in the environment(s) as a string. It is essentially a   ;
;  very small and fast version of launch or retval, but with the    ;
;  environment access capability only dreamed of until now :-)      ;
;  Requires only about 3.5k of overhead in memory while spawning.   ;
;                                                                   ;
;   Usage: envretco [*|&] [program(.exe|.com)] [program parms]      ;
;                                                                   ;
; [*|&] store errorlevel returned by [program] in environment(s)    ;
;                                                                   ;
;       If * is specified, results will be placed in the current    ;
;       (primary) environment and any secondary (master env) found  ;
;                                                                   ;
;       If & is specified, results will be placed in only the       ;
;       current (primary) environment.                              ;
;                                                                   ;
;       In general, an environment string containing the error code ;
;       returned by the child process will be written to the env(s) ;
;       in the form: PROGROOT=retcode  where PROGROOT is the root   ;
;       name of the spawned program and retcode is the spawned      ;
;       program's exit code.                                        ;
;                                                                   ;
;       Notes: It is up to the user to cleanup after envretco, and  ;
;       remove unneeded environment variables. However, this could  ;
;       be difficult without external utilities if the * option is  ;
;       used and the master env is written to - ie: the DOS SET cmd ;
;       may not be able to access the master env to remove an env   ;
;       var set by envretco. Use the * option with discretion.      ;
;                                                                   ;
;       If * or & not specified, Envretco will act like a plain     ;
;       program launcher and will only set it's exit code to that   ;
;       of the child and display the result on the console.         ;
;                                                                   ;
;       Result string can always be redirected to devices or files  ;
;       from the command line with Dos redirection. (ie: > nul)     ;
;                                                                   ;
; [program] name of program to spawn and retrieve return code from  ;
;           Envretco will try hard to locate the program by tracing ;
;           along the Dos path and first trying .com files and then ;
;           .exe files if no extension is specified.                ;
;                                                                   ;
;   [parms] parameter list to be used by [program] This is the      ;
;           usual list of switches, filenames, and whatever one     ;
;           feeds to [program] to have it do its thing. Exactly the ;
;           same as if Envretco were not being used.                ;
;                                                                   ;
; ex: Envretco * pkzip.exe -a foo.zip bar.txt  will create an env   ;
;     string of the form: pkzip=3 in the environment(s)             ;
;                                                                   ;
; ex: Envretco & pkzip.exe -a foo.zip bar.txt  will create an env   ;
;     string of the form: pkzip=3 in the current environment        ;
;                                                                   ;
; errorlevels returned: if child process is spawned successfully,   ;
;                       the child's errorlevel will be returned.    ;
;                                                                   ;
;                       if the spawn fails for any reason, or the   ;
;                       user botches parameters, 255 is returned    ;
;                                                                   ;
;-------------------------------------------------------------------;
; v0.10 05/15/91  initial coding                                    ;
; v0.11 05/22/91  fixed problem with spawned progs that spawn also. ;
; v0.12 10/18/91  fixed minor bug in chekflop routine.              ;
; v0.13 01/02/92  changed my fidonet address, general cleanup.      ;
;                 added *|& env selection.                          ;
;                                                                   ;
;-------------------------------------------------------------------;
; <Legal Status>                                                    ;
;  In the spirit of cooperation and education within the computing  ;
;  community, and in the hope that someone may benefit:             ;
;                                                                   ;
;  This program is released into the Public Domain.                 ;
;                                                                   ;
;  Please don't abuse this concept of sharing of information.       ;
;                                                                   ;
;-------------------------------------------------------------------;
; <General Disclaimer>                                              ;
;  Please note that this program was written for my personal use    ;
;  and that I am not a professional programmer. Thus, although I    ;
;  have made every effort to ensure that the code is bug free and   ;
;  performs as advertised, I can make no guarantees of suitability  ;
;  or performance - use at your own risk!                           ;
;                                                                   ;
;  In any case, this source code is provided for your inspection,   ;
;  enlightenment, and/or general amusement.                         ;
;                                                                   ;
;  I welcome any and all comments, criticisms, suggestions, or bug  ;
;  reports at the address below.                                    ;
;                                                                   ;
;-------------------------------------------------------------------;
;    Written for and assembled under Microsoft QuickC ver 2.01      ;
;      (Should also assemble under Masm with no problems)           ;
;-------------------------------------------------------------------;
;   Bruce Desmond      Sacramento, Ca.    Fidonet (1:203/39.9)      ;
;-------------------------------------------------------------------;

; Directives

_TEXT    segment byte public 'CODE'
         assume  cs:_TEXT, ds:_TEXT
         org     100h

first:   jmp     start

;-------------------------------------------------------------------;
; Equates
;-------------------------------------------------------------------;
STCKSIZ  equ   64                  ;size of internal stack (words)

;-------------------------------------------------------------------;
; Data buffer(s)
;-------------------------------------------------------------------;
; note:  the following buffers are also used by the env routines
; after spawning as a large workspace. Don't move them!

progfil  db 128 dup (0)            ;progname storage
program  db 128 dup (0)            ;Asciiz filename storage
parmstr  db 128 dup (0)            ;psp temp buffer
pathstr  db 128 dup (0)            ;local storage of path string
ourstak  dw STCKSIZ dup (?)        ;internal stack

stakpt1  dw ?                      ;Storage for stack pointer
stakpt2  dw ?                      ;Storage for stack pointer

pathptr  dw offset pathstr         ;pointer to path vars
namelen  dw ?                      ;length of passed progname


; work area for exec function. uses our psp to minimize code size
 
parmblk  dw 0                      ;environment string seg
         dw 80h                    ;offset  default command PSP
         dw ?                      ;segment default command PSP
         dw 5ch                    ;offset  default FCB1
         dw ?                      ;segment default FCB1
         dw 6ch                    ;offset  default FCB2
         dw ?                      ;segment default FCB2

retcode  db 0                      ;child's return code
spacode  db 1                      ;spawn return code

evarlen  dw 9                      ;length of env var w/ =
envslen  dw 9                      ;length of env string
estring  db 24 dup (0)             ;env string buffer
envflag  db 0                      ;if 0 don't set any envvar(s)
secflag  db 0                      ;if 0 don't set secondary envvar

tailcnt  dw ?                      ;pointer to env tail if any
nullptr  dw ?                      ;pointer to env double nul's

primcmd  dw ?                      ;segment of int2e owner
primenv  dw ?                      ;primary env segment
primsiz  dw ?                      ;size of primary env in bytes
secoenv  dw 0                      ;second env segment
secosiz  dw 0                      ;size of second env in bytes

nameptr  dw offset program         ;filespec pointer

bozoflg  db 0                      ;no extension flag

exeext   db '.exe',0               ;add on if no extension supplied
comext   db '.com',0               ;add on if no extension supplied

crlf     db 13,10,'$'


; generic success string. Function dec3strg inserts the retcode
; in it at errret for display to the console

didit    db 13,10,' Spawned program returned errorlevel = '
errret   db 32,32,32,'$'


; generic failure message.
bogoid   db 13,10,' Spawn failed: $'


; specific failure strings. Their numbers are based on Int21h ser 59h
; failure modes. The list can be expanded by including more err states
; at updating failure checking code near end of main program.

err0     db 'Unknown failure.$'
err2     db 'Program not found.$'
err8     db 'Insufficient memory for spawn.$'
err23    db 'Drive not ready.$'


;environment manipulation status strings

enverr1  db ' Error accessing environment.',13,10,'$'
enverr2  db ' Error: Out of environment space.',13,10,'$'


verprob  db ' Requires at least Dos version 3.0',13,10,'$'


helpb    db 13,10
         db 'EnvRetco.com  v0.13  01/02/92  spawn program and display '
         db 'errorlevel',13,10
         db ' Released to the Public Domain by Bruce Desmond (1:203/39.9)'
         db 13,10,13,10
         db '  usage: envretco [*|&] [program[.exe|.com]] [program parms]'
         db 13,10,13,10
         db '[*|&]  write retcode as progroot=retcode in environment(s) '
         db 13,10
         db '       * = write current and master  & = write current only.'
         db 13,10,'$'


;----------------------start-of-main--------------------------------;
;
;-------------------------------------------------------------------;


;-------------------------------------------------------------------;
; check that Dos version is at least 3.0
;-------------------------------------------------------------------;

start:   mov     ah,030h
         int     21h
         cmp     al,3
         jnb     parseit

         mov     dx,offset verprob ;display and exit
         mov     ah,9
         int     21h
         jmp     done

;-------------------------------------------------------------------;
; parse command line (parser assumes .com if no extension supplied)
;-------------------------------------------------------------------;

parseit: call    parsecmd          ;parse command line
         cmp     bx,-1
         je      dalloc            ;ok so far.

;-------------------------------------------------------------------;
; user goofup
;-------------------------------------------------------------------;

died:    mov     dx,offset helpb
         mov     ah,9
         int     21h
         jmp     done

;-------------------------------------------------------------------;
; deallocate unneeded memory to minimize resident size when spawning
;-------------------------------------------------------------------;

dalloc:  mov     ax,offset endcode ;offset of program end
         mov     cl,4
         shr     ax,cl             ;resolve prog end to paragraphs
         add     ax,3              ;toss in extra paras for safety

         mov     bx,ax
         mov     ah,4ah
         int     21h               ;deallocate memory

;-------------------------------------------------------------------;
; set up internal stack since released mem containing old stack
; and it gets stomped by spawn
;-------------------------------------------------------------------;

         mov     ax,sp             ;save sp
         mov     stakpt1,ax
         mov     ax,cs
         mov     ss,ax             ;Set stack segment
         mov     sp,offset ourstak ;Set pointer to temporary stack

         add     sp,STCKSIZ        ;set pointer to end of stack
         add     sp,STCKSIZ        ;(twice since stack is words)

;-------------------------------------------------------------------;
; determine environment segment(s) and size(s)
;-------------------------------------------------------------------;

         call    findenvs

;-------------------------------------------------------------------;
; locate and copy Dos path since we might need to search for program
;-------------------------------------------------------------------;

         call    findpath

;-------------------------------------------------------------------;
; build full program name from path and progfil
; copies progfil to program first time through and adds path on
; subsequent passes. If program is still not found, the whole thing
; iterates again for .exe if no extension was given  
;-------------------------------------------------------------------;

reploop: call    buildnam

;-------------------------------------------------------------------;
; check any disk drive specification which may appear in the program
; path to prevent abort, retry, fail errors. Abort on error.       
;-------------------------------------------------------------------;

         mov     di,offset program ;check this string
         call    chekflop
         mov     spacode,23        ;assume drive not ready code
         jc      bail              ;error if CF set

;-------------------------------------------------------------------;
; search for program using findfirst (faster than trying to spawn
; and provides semi parsed program name for use in estring build)
;-------------------------------------------------------------------;

         mov     ah,04eh
         mov     cx,0006h          ;attrib mask
         mov     dx,offset program
         int     21h

         mov     spacode,al        ;save error code
         jc      nextdir

         mov     spacode,0         ;success code
         cld                       ;store name in estring
         mov     si,09eh           ;offset in psp of name
         mov     di,offset estring
         mov     cx,12             ;max iterations
         rep     movsb

;-------------------------------------------------------------------;
; spawn child process
;-------------------------------------------------------------------;

         call    spawnit           ;try to execute program
         cmp     spacode,0         ;ok?
         je      bail
         cmp     spacode,3         ;fatal type problem?
         ja      bail

;-------------------------------------------------------------------;
; get first/next directory on the dos path
;-------------------------------------------------------------------;
nextdir: call    pathcopy          ;copy first path var to [program]
         cmp     bx,-1
         je      reploop           ;still s'more path vars

         cmp     bozoflg,1         ;if 0, nothing more to try
         jne     bail              ;total failure.

;-------------------------------------------------------------------;
; add ".exe" extension to progfil since no extension was given
;-------------------------------------------------------------------;

         mov     cx,4
         mov     si,offset exeext  ;source
         mov     di,offset progfil ;target
         add     di,namelen        ;point to end of target

         rep     movsb

         mov     pathptr, offset pathstr   ;reset pointer
         mov     nameptr, offset program   ;reset pointer

         mov     bozoflg,0         ;clear the flag
         jmp     short reploop     ;run through again

;-------------------------------------------------------------------;
; get child's retcode (if any) and set up result strings
;-------------------------------------------------------------------;

bail:    mov     ah,04dh           ;get child's retcode
         int     21h
         mov     retcode,al        ;store retcode

         mov     di,offset errret  ;pointer to end of success string
         call    dec3strg          ;append retcode as string
         mov     al,'$'
         stosb                     ;terminate string
         mov     dx,offset didit   ;goody!

         cmp     spacode,0         ;was spawn successful?
         je      poopout

;-------------------------------------------------------------------;
; find out what went wrong and display error string
;-------------------------------------------------------------------;

         mov     retcode,255       ;bogosity indicator
         mov     dx,offset bogoid  ;bogosity message
         mov     ah,9
         int     21h

         mov     al,spacode        ;code from findfirst or exec

         cmp     al,4              ;general file not found
         jb      gfilerr

         cmp     spacode,8         ;out of memory
         jne     errchk1
         mov     dx,offset err8
         jmp     short poopout

errchk1: cmp     spacode,18        ;findfirst no file found
         je      gfilerr

         cmp     spacode,23        ;drive not ready
         jne     errchk2
         mov     dx,offset err23
         jmp     short poopout

errchk2: mov     dx,offset err0    ;unknown failure
         jmp     short poopout

gfilerr: mov     dx,offset err2    ;file not found

;-------------------------------------------------------------------;
; display result string and do env mods if required
;-------------------------------------------------------------------;

poopout: mov     ah,9              ;display success/failure string
         int     21h
         mov     dx,offset crlf    ;terminal CRLF
         int     21h

         cmp     spacode,0         ;was spawn successful?
         jne     done              ;if not leave environment alone

         cmp     envflag,1         ;need to do env var?
         jne     done

         call    stringit          ;create our envstring

         mov     di,primenv        ;ptr to primary env seg
         mov     cx,primsiz        ;size of primary env
         call    updatenv          ;inset estring into environment

         cmp     secoenv,0         ;need to do another?
         je      done

         cmp     secflag,1         ;need to do secondary env var?
         jne     done

         mov     di,secoenv        ;ptr to second env seg
         mov     cx,secosiz        ;size of second env
         call    updatenv          ;inset estring into environment

;-------------------------------------------------------------------;
done:    mov     ah,04ch
         mov     al,retcode
         int     21h               ;terminate w/ errorlevel 0

;----------------------end-main-code--------------------------------;



;-------------------------------------------------------------------;
; function spawnit     spawn child process
;-------------------------------------------------------------------;
spawnit  proc    near

         push    ax
         push    bx
         push    cx
         push    dx
         push    si
         push    di
         push    bp

; restore the psp that findfirst stomped

         mov     cx,128            ;restore psp parm string
         mov     si,offset parmstr
         mov     di,080h
         rep     movsb

         mov     ax,sp             ;save sp
         mov     stakpt2,ax
         
;align all segments to our seg

         mov     ax,cs             ;Get code segment
         mov     ds,ax             ;Set data segment
         mov     es,ax             ;Set extra segment

         mov     [parmblk+4],ax    ;Set segment for child PSP
         mov     [parmblk+8],ax    ;Set segment for child FCB1
         mov     [parmblk+12],ax   ;Set segment for child FCB2

;Execute program
         mov     dx,offset program ;Get address of filename
         mov     bx,offset parmblk ;Get address of parameter block
         mov     ah,4bh
         xor     al,al             ;function 0 : load and execute
         int     21h               ;execute child process

         mov     cs:spacode,al     ;save exec error code
         jc      klean
         mov     cs:spacode,0      ;success code

;Restore segments and stack

klean:   mov     ax,cs             ;Get code segment
         mov     ds,ax             ;Restore data segment
         mov     es,ax             ;Restore extra segment
         mov     ss,ax             ;Restore stack segment
         mov     ax,stakpt2        ;Get stack pointer
         mov     sp,ax             ;Restore stack pointer

         pop     bp
         pop     di
         pop     si
         pop     dx
         pop     cx
         pop     bx
         pop     ax

         ret

spawnit  endp



;-------------------------------------------------------------------;
; function findenvs   finds "real" environment and it's size.            
;-------------------------------------------------------------------;
findenvs proc    near

         push    ax
         push    bx
         push    cx
         push    dx
         push    di
         push    es

;-------------------------------------------------------------------;
; Locate primary command processor by int2eh method

         mov     ah,35h            ;find where Int 2eh points
         mov     al,02eh
         int     21h
         mov     cs:primcmd,es     ;save seg

;-------------------------------------------------------------------;
; Point at primary processor's arena header

         mov     ax,es
         dec     ax                ;1 para before actual code seg

;-------------------------------------------------------------------;
; chase down mcb chain

mrep:    mov     es,ax             ;es points at MCB
         mov     dl,es:[0]         ;MCB id byte
         cmp     dl,'M'            ;potential arena header?
         je      xxcd
         cmp     dl,'Z'            ;potential arena header?
         jne     nxseg

xxcd:    mov     ax,es:[1]         ;owner of block
         cmp     ax,cs:primcmd     ;is it the primary processor?
         jne     nxseg             ;ignore it

         mov     di,16             ;offset 1 para in
         cmp     byte ptr es:[di],0;look at 1st byte of actual block
         je      nxseg

         mov     cx,16                 ;scan a para for something that
ascloop: cmp     byte ptr es:[di],127  ;looks like a normal env string
         ja      nxseg                 ;this step filters out psp's
         cmp     byte ptr es:[di],0    ;and bogoid batch mem blocks
         je      gagain                ;which try to look like env
         cmp     byte ptr es:[di],32   ;blocks. There should always be
         jb      nxseg                 ;at least this 1 para, and there
gagain:  inc     di                    ;are very few legitamate things
         loop    ascloop               ;that have high ascii or control
                                       ;codes in 1st para of env.
         mov     ax,es
         inc     ax                ;point at actual env block
         mov     cs:primenv,ax

         mov     ax,es:[3]         ;block size in paras
         xor     dx,dx
         mov     bx,16
         mul     bx
         mov     cs:primsiz,ax

nxseg:   mov     ax,es             ;next para
         add     ax,1

         mov     bx,ds             ;are we done yet?
         cmp     ax,bx             ;ds is our program seg
         jb      mrep

;-------------------------------------------------------------------;
; look at what our code thinks

         mov     ax,cs:[014h]      ;primary shell
         cmp     ax,cs:primenv
         jb      efound

         mov     bx,cs:primenv     ;swap primary and secondary
         mov     cs:secoenv,bx
         mov     bx,cs:primsiz
         xchg    cs:secosiz,bx

         mov     es,ax             ;point at shell
         mov     ax,es:[02ch]      ;env seg
         mov     cs:primenv,ax

         dec     ax                ;look at arena header
         mov     es,ax
         mov     ax,es:[3]         ;block size in paras
         xor     dx,dx
         mov     bx,16
         mul     bx
         mov     cs:primsiz,ax

efound:  pop     es
         pop     di
         pop     dx
         pop     cx
         pop     bx
         pop     ax
         ret

findenvs endp



;-------------------------------------------------------------------;
; function findpath    searches envseg @ [primenv] for path
;                      returns path string in [pathstr]        
;-------------------------------------------------------------------;
findpath proc    near

         push    ax
         push    cx
         push    si
         push    di
         push    ds
         push    es
         
         mov     si,pathptr        ;local path storage
         mov     ax,primenv        ;point at env seg
         mov     cx,primsiz        ;max loops
         mov     es,ax
         xor     di,di
         cld

eqsrch:  mov     al,'='            ;target char
         repne   scasb
         jcxz    pthdone           ;no path? hmmmmmm.

         cmp     byte ptr es:[di-2],'H';look for PATH backwards
         jne     eqsrch
         cmp     byte ptr es:[di-3],'T'
         jne     eqsrch
         cmp     byte ptr es:[di-4],'A'
         jne     eqsrch
         cmp     byte ptr es:[di-5],'P'
         jne     eqsrch

         cmp     di,5                  ;first string in env?
         je      getpath
         cmp     byte ptr es:[di-6],0  ;if not 1st, preceeded by nul
         jne     eqsrch

getpath: xchg    si,di             ;swap everything :-(
         push    ds
         push    es
         pop     ds
         pop     es

getloop: cmp     byte ptr [si],0   ;terminating nul?
         je      pthdone
         movsb                     ;store locally at es:di
         loop    getloop

pthdone: pop     es
         pop     ds
         pop     di
         pop     si
         pop     cx
         pop     ax

         ret

findpath endp




;-------------------------------------------------------------------;
; function parsecmd   parse cmd line into [envflag] [program] [parms]
;                     returns bx = -1 if good  bx = 0 if bogus
;-------------------------------------------------------------------;
parsecmd proc    near

         push    ax
         push    cx
         push    si
         push    di

         mov     bx,0              ;assume failure.
         
;-------------------------------------------------------------------;
; strip spaces 

         mov     si,081h           ;strip leading space
         cld
s1loop:  lodsb
         cmp     al,13             ;end?
         je      pardied

         cmp     al,'&'            ;user doesn't want secondary env set
         jne     maybenv

         mov     envflag,1         ;user wants primary env var
         jmp     short s1loop

maybenv: cmp     al,'*'            ;env_var flag?
         jne     maybspa

         mov     envflag,1         ;user wants env var(s)
         mov     secflag,1         ;user wants secondary env var (if any)
         jmp     short s1loop

maybspa: cmp     al,32             ;space?
         je      s1loop

;-------------------------------------------------------------------;
; get [progname]

         dec     si                ;get program name
         xor     cx,cx             ;store name length
         mov     di,offset progfil

prloop:  lodsb
         cmp     al,13             ;end?
         je      chkpnam
         cmp     al,32             ;space?
         je      chkpnam
         cmp     al,'/'            ;switchchar jammed on?
         je      chkpnam
         cmp     al,65             ;capital A?
         jb      caseskp
         cmp     al,90             ;capital Z?
         ja      caseskp
         or      al,32             ;lowercase it
caseskp: stosb
         inc     cx
         jmp     short prloop

chkpnam: cmp     byte ptr progfil,0    ;was there a name?
         jne     pargogo

pardied: jmp     short parsdon     ;128 jump fixup


;-------------------------------------------------------------------;
; fix up so our psp contain only any passed parms for exec to use

pargogo: mov     namelen,cx        ;save prog namelen

         dec     si
         mov     di,offset parmstr + 1
         push    bp
         mov     bp,offset parmstr
         mov     byte ptr [bp],-1

paloop:  lodsb
         stosb
         inc     byte ptr [bp]
         cmp     al,13
         jne     paloop

         pop     bp

;-------------------------------------------------------------------;
; fix up [progfil] if no extension specified
; set bozoflag and start out assuming it to be an .com
; will fixup again and try .exe later if needed

         mov     bx,-1             ;parsing ok! just need to fixup...

         mov     di,offset progfil ;going to look for a period

         mov     al,'.'            
         repne   scasb

         jnz     extfixr

         dec     di
         mov     ax,di             ;save pointer
         mov     si,offset comext
         mov     cx,4
         repe    cmpsb             ;izit a .com?
         jcxz    parsdon           ;ok

         mov     di,ax             ;go back
         mov     si,offset exeext
         mov     cx,4
         repe    cmpsb             ;izit a .exe?
         jcxz    parsdon           ;ok

         mov     bx,0
         jmp     short parsdon     ;bad extension!

extfixr: mov     bozoflg,1         ;set noextension flag

         mov     cx,4              ;tack on ".com"
         mov     si,offset comext
         rep     movsb

parsdon: pop     di
         pop     si
         pop     cx
         pop     ax
         ret

parsecmd endp



;-------------------------------------------------------------------;
; function pathcopy   copy next path target to [program]
;                     returns bx = -1 if good  bx = 0 if bogus
;-------------------------------------------------------------------;
pathcopy proc    near

         push    ax
         push    si
         push    di
         mov     bx,0              ;assume failure.
         
         mov     si,pathptr        ;pointer to path var
         mov     di,offset program ;target

pthloop: lodsb
         cmp     al,0              ;no more vars
         je      gotpvar

         cmp     al,';'            ;path var delimiter
         je      gotpvar
         stosb                     ;copy the var
         jmp     short pthloop

gotpvar: mov     ax,[pathptr]      ;check if anything there.
         inc     ax
         cmp     ax,si
         je      pathdon           ;nothing left.

         cmp     byte ptr [di-1],'\'   ;check for trailing backslash
         je      pathrec
         mov     byte ptr [di],'\'     ;add backslash
         inc     di

pathrec: mov     pathptr,si        ;ptr to next var
         mov     nameptr,di        ;ptr to end of var
         mov     bx,-1             ;path copied ok.

pathdon: pop     ax
         pop     di
         pop     si
         ret

pathcopy endp



;-------------------------------------------------------------------;
; function buildnam   build fully defined program name
;-------------------------------------------------------------------;
buildnam proc    near

         push    ax
         push    si
         push    di
         
         mov     si,offset progfil ;pointer to base prog name
         mov     di,nameptr        ;pointer to append prog to

bldloop: lodsb
         stosb                     ;copy the var
         cmp     al,0              ;no more chars
         jne     bldloop

buildon: pop     ax
         pop     di
         pop     si
         ret

buildnam endp



;-------------------------------------------------------------------;
; function stringit   create estring from progfil
;-------------------------------------------------------------------;
stringit proc    near

         push    ax
         push    cx
         push    di
         
         mov     di,offset estring ;source
         mov     cx,envslen        ;length of progfil

         mov     al,'.'            ;look for extension
         repne   scasb

         mov     byte ptr [di-1],'='   ;tack on = sign

         mov     ax,offset estring ;start of estring
         mov     cx,di
         sub     cx,ax             ;length of string so far

         mov     evarlen,cx        ;save length of var

         mov     al,retcode        ;pass retcode to function
         call    dec3strg          ;append retcode to estring

         xor     ah,ah
         add     cx,ax             ;bytes appended by dec3str

         xor     al,al             ;asciiz it by adding a nul
         stosb                     ;dec3strg left di at last char

         inc     cx                ;include nul
         mov     envslen,cx        ;save length of estring

         pop     di
         pop     cx
         pop     ax
         ret

stringit endp



;-------------------------------------------------------------------;
; function dec3strg  convert byte in al to 3 digit string
;                    append string to buffer passed in di
;                    count of bytes added returned in al
;                    end of string pointer returned in di
;-------------------------------------------------------------------;

dec3strg proc    near

         push    bx
         push    cx

         xor     ah,ah
         xor     cx,cx

         mov     bx,100            ;get 100's digit
         div     bl
         cmp     al,0              ;no leading 0
         je      tens

         add     al,48
         stosb                     ;tack it on
         inc     cx

tens:    mov     bx,10             ;get 10's digit
         xchg    ah,al
         xor     ah,ah

         div     bl
         cmp     al,0              ;no leading 0
         jne     midz

         cmp     cx,0              ;was there a 100's digit?
         je      ones

midz:    add     al,48             ;tack it on
         stosb
         inc     cx

ones:    xchg    ah,al
         add     al,48             ;get 1's digit
         stosb
         inc     cx

         xchg    ax,cx             ;return byte count in ax

         pop     cx
         pop     bx
         ret

dec3strg endp


;-------------------------------------------------------------------;
; function chekflop   check drive in passed string pointed at by di
;                     returns: CF set if error
;-------------------------------------------------------------------;
chekflop proc    near

         push    ax
         push    bx
         push    cx
         push    dx
         push    di
         
         mov     dx,[di]           ;grab first 2 bytes
         cmp     dh,':'            ;drive designator?
         jne     nodrive

         and     dl,0dfh           ;uppercase
         sub     dl,65             ;drive digit (0-25d)

         cmp     dl,1              ;ignore hard disks
         ja      nodrive

         mov     cl,1              ;sector 1
         mov     ch,0              ;track 0
         mov     dh,0              ;side 0

         mov     ah,4
         int     13h               ;verify sector
         jmp     short bailout

nodrive: clc

bailout: pop     di
         pop     dx
         pop     cx
         pop     bx
         pop     ax
         ret

chekflop endp



;-------------------------------------------------------------------;
; function updatenv   insert estring into specified environment.
;                     Env seg passed in di  envsize passed in cx
;-------------------------------------------------------------------;
updatenv proc    near

         push    ax
         push    bx
         push    dx
         push    si
         
         call    findtail          ;find end of env
         jnc     seekvar           ;continue if no error

         mov     dx,offset enverr1 ;env access error
         mov     ah,9
         int     21h
         jmp     short updexit

seekvar: call    evarseek          ;remove any existing evar
         jnc     fixptrs           ;continue if no error

         mov     dx,offset enverr1 ;env access error
         mov     ah,9
         int     21h
         jmp     short updexit

fixptrs: call    findtail          ;new pointers
         jnc     calcsiz           ;continue if no error

         mov     dx,offset enverr1 ;env access error
         mov     ah,9
         int     21h
         jmp     short updexit

calcsiz: mov     ax,cx             ;size of env
         sub     ax,nullptr        ;ptr to double nul's
         sub     ax,2              ;word count word
         sub     ax,tailcnt        ;length of any tail string
         cmp     ax,envslen        ;enough to add estring?

         ja      insestr           ;enough room - add estring

         mov     dx,offset enverr2 ;insufficient space
         mov     ah,9
         int     21h
         jmp     short updexit

insestr: call    setestr           ;write env string

updexit: pop     si
         pop     dx
         pop     bx
         pop     ax
         ret

updatenv endp



;-------------------------------------------------------------------;
; function findtail  locate double nul's in the environment
;                    env seg passed in di  envsize in cx
;                    returns offset into env of second nul in nullptr
;                    returns bytes of env tail after nuls in tailptr
;                    CF set if error
;-------------------------------------------------------------------;
findtail proc    near

         push    ax
         push    cx
         push    di
         push    es

         mov     nullptr,0         ;initialize nul pointer
         mov     tailcnt,0         ;initialize tail count

         mov     es,di             ;change to env seg
         xor     di,di             ;start at offset 0 in env
         
         cld
         mov     al,0              ;scan for nuls
nulloop: repne   scasb
         jcxz    nonull
         clc
         cmp     byte ptr es:[di],0   ;second nul?
         jne     nulloop

         mov     nullptr,di        ;save ptr to second nul

;-------------------------------------------------------------------;
; inspect any trailing tail string and determine its size

         cmp     cx,3              ;enough env left?
         jb      nulexit

         inc     di                ;point at tail word count
         sub     cx,2              ;acount for next word
         
         cmp     word ptr es:[di],0  ;no tail?
         je      nulexit

         cmp     word ptr es:[di],1  ;wild tail string? (effectively none)
         ja      nulexit

         add     di,2              ;point at tail head

         mov     tailcnt,di        ;start of tail
         mov     al,0              ;looking for tail terminator
         repne   scasb

         dec     di
         sub     di,tailcnt        ;number bytes in tail
         mov     tailcnt,di        ;save

         jmp     short nulexit

nonull:  stc

nulexit: pop     es
         pop     di
         pop     cx
         pop     ax
         ret

findtail endp



;-------------------------------------------------------------------;
; function evarseek  locate any existing copy of out envvar and kill
;                    env seg passed in di
;                    target var contained in estring
;                    length of var + "=" in evarlen
;                    CF set if error
;-------------------------------------------------------------------;
evarseek proc    near

         push    ax
         push    bx
         push    cx
         push    dx
         push    di
         push    si
         push    es

         mov     es,di             ;change to env seg
         xor     di,di             ;start at offset 0 in env
         cld
         clc

         mov     dx,cx             ;save envsize

varloop: mov     bx,di             ;save head pointer
         mov     cx,evarlen        ;compare this many
         dec     cx                ;loop kludge
         mov     si,offset estring ;our evar

         repe    cmpsb             ;compare env vars
         jcxz    killvar           ;if cx=0 we got it

neqscan: cmp     di,nullptr        ;reached end?
         ja      varexit
         mov     di,bx             ;go back to start

         mov     cx,nullptr        ;end of env
         sub     cx,bx             ;bytes left in env

         mov     al,0              ;find next nul
         repne   scasb             ;di points at next var
         jcxz    varexit           ;all done

         cmp     di,nullptr        ;reached end?
         ja      varexit

         jmp     short varloop     ;look again

;-------------------------------------------------------------------;
; repack env which removes evar copy
; bx points at head of env copy of evar

killvar: mov     cx,nullptr        ;end of env
         sub     cx,bx             ;bytes left in env

         mov     al,0              ;find next nul
         repne   scasb             ;di points at next var
         jcxz    varerr            ;something is wrong

         cmp     di,nullptr        ;reached end?
         ja      varexit           ;something is wrong

         mov     si,di             ;point at block to be moved
         mov     di,bx             ;point at head of evar copy

         mov     cx,dx             ;envsize
         sub     cx,si             ;bytes to move

         push    ds                ;save ds
         push    es                ;align ds to es
         pop     ds                ;ds also env seg now
         rep     movsb             ;pack env via ds:si -> es:di
         pop     ds                ;restore ds

         jmp     short varexit

varerr:  stc

varexit: pop     es
         pop     si
         pop     di
         pop     dx
         pop     cx
         pop     bx
         pop     ax
         ret

evarseek endp



;-------------------------------------------------------------------;
; function setestr   write estring to env
;                    env seg passed in di
;                    target string contained in estring
;                    length of string to write in envslen
;-------------------------------------------------------------------;
setestr  proc    near

         push    ax
         push    cx
         push    di
         push    si
         push    es

;-------------------------------------------------------------------;
; save tail to buffer

         mov     ax,di             ;save passed env seg
         cld

         mov     si,nullptr        ;start at the double nuls
         mov     di,offset progfil ;buffer for env tail

         mov     cx,tailcnt        ;bytes in env tail
         add     cx,3              ;include second nul + word count

         mov     ds,ax             ;point ds at env

         rep     movsb             ;copy tail  ds:si -> es:di

;-------------------------------------------------------------------;
; write estring to env

         push    es                ;our seg
         pop     ds                ;restore ds
         mov     es,ax             ;es points at env seg

         mov     di,nullptr        ;go back to end of strings
         mov     si,offset estring ;string to write
         mov     cx,envslen        ;bytes to write

         rep     movsb             ;tack on estring  ds:si -> es:di

;-------------------------------------------------------------------;
; restore env tail from buffer

         mov     si,offset progfil ;buffer for env tail
         mov     cx,tailcnt        ;bytes in env tail
         add     cx,3              ;include second nul + word count

         rep     movsb             ;copy tail  ds:si -> es:di


setexit: pop     es
         pop     si
         pop     di
         pop     cx
         pop     ax
         ret

setestr  endp


;-------------------------------------------------------------------;
endcode  db ?                      ;end of code marker for dealloc
                                   ;do not move unless you like
                                   ;rebooting a lot.
;-------------------------------------------------------------------;
_TEXT    ends
         end     first
;-----------------------------end-of-code---------------------------;
