'PATINFO  V1.1  by Joseph Maruschek  aa344@yfn.ysu.edu
'This program shows you some of the information kept in the
'headers of the GUS's patch files.  I don't have the SDK, so
'some of the information in the header is still unknown.  I don't
'entirely understand the format of the detune field, but I include
'it's value in the display.  There is also amplitude envelope
'data that I don't yet understand, but I display it anyway.
'Feel free to write to me at the above address if you have any
'questions or comments.

'The author cannot be held responsible for damage to your files
'or computer due to mis-use of this code.


dim shared notes(12)
dim shared names$(12)
for i=1 to 12
  read y
  notes(i)=y
  read y$
  names$(i)=y$
next i

data 16.35,"C",17.32,"C#",18.35,"D",19.45,"D#",20.6,"E",21.83,"F"
data 23.12,"F#",24.5,"G",25.96,"G#",27.5,"A",29.14,"A#",30.87,"B"


'***************************SUBROUTINES***************************
sub Readfour(x,blck,t1$,t2$,offs) static

if offs-blck*128+1 <=128 then
  x=asc(mid$(t1$,offs-blck*128+1,1))
else
  x=asc(mid$(t2$,offs-(blck+1)*128+1,1))
end if
if offs-blck*128+2 <=128 then
  x=x+ 256.0*asc(mid$(t1$,offs-blck*128+2,1))
else
  x=x+ 256.0*asc(mid$(t2$,offs-(blck+1)*128+2,1))
end if
if offs-blck*128+3 <=128 then
  x=x + 65536.0*asc(mid$(t1$,offs-blck*128+3,1))
else
  x=x + 65536.0*asc(mid$(t2$,offs-(blck+1)*128+3,1))
end if
if offs-blck*128+4 <=128 then
  x=x+ 16777216.0*asc(mid$(t1$,offs-blck*128+4,1))
else
  x=x+ 16777216.0*asc(mid$(t2$,offs-(blck+1)*128+4,1))
end if

end sub

sub Readtwo(x,blck,t1$,t2$,offs) static

if offs-blck*128+1 <=128 then
  x=asc(mid$(t1$,offs-blck*128+1,1))
else
  x=asc(mid$(t2$,offs-(blck+1)*128+1,1))
end if
if offs-blck*128+2 <=128 then
  x=x+ 256.0*asc(mid$(t1$,offs-blck*128+2,1))
else
  x=x+ 256.0*asc(mid$(t2$,offs-(blck+1)*128+2,1))
end if

end sub


sub Readone(x,blck,t1$,t2$,offs) static

if offs-blck*128+1 <=128 then
  x=asc(mid$(t1$,offs-blck*128+1,1))
else
  x=asc(mid$(t2$,offs-(blck+1)*128+1,1))
end if

end sub


sub Notename(x,name$) static

name$=""
if x=0 then
  name$="None"
else
  octave=0
  i =1
  loop1:
  if abs(x-(notes(i)*2^(octave))) <1 then goto loopend
  if notes(i)*2^(octave) > x then
    name$="?"
    if abs(x-notes(i-1)*2^octave) < abs(x-notes(i)*2^octave) then i=i-1
    goto loopend
  end if
  i=i+1
  if i=13 then
    i=1
    octave=octave+1
  end if
  goto loop1

  loopend:
  name$=name$+names$(i)+chr$(48+octave)
end if
end sub

'*********************************MAIN PROGRAM************************
if Command$="" then goto help
on error goto handle
open Command$ for input as #1
close 1
open Command$ as #1
field 1, 128 as v$

get 1
if left$(v$,8)="GF1PATCH" then
  print "File: "Command$
else
  print left$(v$,8)
  print "Not a patch file."
  goto fin
end if


numsamps=asc(mid$(v$,86,1))
print "This file contains "numsamps" sample(s)."

offset=0
noff=239

for i=1 to numsamps

  print
  print "Sample #"i

  offset=offset+noff
  block=fix(offset/128.0)
  sampbegin=offset+96

  get 1,block+1
  temp1$=v$
  get 1,block+2
  temp2$=v$

  offset=offset+7
  call Readone(v,block,temp1$,temp2$,offset)
  mode=v

  offset=offset+1
  call Readfour(v,block,temp1$,temp2$,offset)
  print "Sample length:"v,
  noff=v

  offset=offset+4
  call Readfour(v,block,temp1$,temp2$,offset)
  print "Loop start: "v,

  offset=offset+4
  call Readfour(v,block,temp1$,temp2$,offset)
  print "Loop end:"v

  offset=offset+4
  call Readtwo(v,block,temp1$,temp2$,offset)
  print "Sample rate:"v"Hz"

  offset=offset+2
  call Readfour(v,block,temp1$,temp2$,offset)
  call Notename(v/1000,n$)
  print "Low freq:";v/1000;"("n$")    ";

  offset=offset+4
  call Readfour(v,block,temp1$,temp2$,offset)
  call Notename(v/1000,n$)
  print "High freq:";v/1000;"("n$")    ";

  offset=offset+4
  call Readfour(v,block,temp1$,temp2$,offset)
  call Notename(v/1000,n$)
  print "Base freq:";v/1000;"("n$")"

  offset=offset+4
  call Readone(v,block,temp1$,temp2$,offset)
  if v>128 then v=v-256
  print "Detune:"v,

  offset=offset+1
  call Readone(v,block,temp1$,temp2$,offset)
  print "Octave:"v,

  offset=offset+1
  call Readone(v,block,temp1$,temp2$,offset)
  print "Balance:"v,
  print "Mode:";
  for j=8 to 1 step -1
    if (mode and 2^(j-1)) then print " 1"; else print " 0";
  next j
  print
  print "Envelope/tremolo/vibrato data:"
  for j=1 to 18
    offset=offset+1
    call Readone(v,block,temp1$,temp2$,offset)
    print using " ###";v;
  next j
  print
  offset=offset+1
  call Readone(v,block,temp1$,temp2$,offset)
  print "Flags: ";
  if (v and 1) then print "16-bit "; else print "8-bit ";
  if (v and 4) then print "looped "; else print "no-loop ";
  if (v and 16) then print "reverse "; else print "forward ";
  if (v and 32) then print "melodic ": else print "percussive ";
  print
  offset=sampbegin
next i

fin:
close 1
end

handle:
if err=53 then
  print "File not found."
  goto fin
else
  if err=64 then
    print "Bad file name.  Don't use wildcards."
    goto fin
  else
    if err=52 then
      print "Bad file number.  Can only view one file at a time."
      goto fin
    else
      print "Error number:"err
      goto fin
    end if
  end if
end if
resume

help:
print
print "PATINFO  V1.0  by Joseph Maruschek"
print "Shows information contained in a patch file."
print
print "Usage:  PATINFO filename"
goto fin
