;written by Jeff Lawson of JL Enterprises
;email: hfrank@rcf.usc.edu

.386
IDEAL
LOCALS
JUMPS
MODEL HUGE
STACK 1024

;
MACRO           MAKEUPPERCASE letter
                LOCAL @@Quit
                cmp letter,'a'
                jb @@Quit
                cmp letter,'z'
                ja @@Quit
                sub letter,'a'-'A'
@@Quit:
ENDM            MAKEUPPERCASE

MACRO           CONVERTTOHEX digit
                mov bl,digit
                and bl,0Fh
                xor bh,bh
                mov digit,[HexTable+bx]
ENDM            CONVERTTOHEX
;
SEGMENT         Data
SerialMessage   DB 0Dh,0Ah,0Dh,0Ah,0Dh,0Ah,'The computed serial number is:'
                DB 0Dh,0Ah,09h
SerialText      DB 12 DUP (?)
                DB 0Dh,0Ah,'$'
SerialNum       DB 5 DUP (?)
MagicMultiply   DD 000Dh
MagicStart      DB 'Ahhs'
MagicEnd        DB 'Oohs'
HexTable        DB '0123456789ABCDEF'
NameBuffer      DB 0FEh,?,0FEh DUP (?)
AddressBuffer   DB 0FEh,?,0FEh DUP (?)
UserIDbuffer    DB ?,0FFh DUP (?)
                DB 4 DUP (?)            ;overflow region
Hello           DB 'Mega-Em Registration Code Generator, v1.0',0Dh,0Ah
                DB '    by JL Enterprises, 1993',0Dh,0Ah,0Dh,0Ah
                DB 'Enter nothing at any prompt to quit.',0Dh,0Ah,'$'
NamePrompt      DB 0Dh,0Ah,'please enter your name:  $'
AddressPrompt   DB 0Dh,0Ah,'now enter your address:  $'
ENDS            Data
;
SEGMENT         Code
                ASSUME CS:Code,DS:Data,ES:Data
;-----------------------------------------------------------------------------
PROC            Start
                mov ax,Data
                mov ds,ax
                mov es,ax

                call PrintGreeting
                call InputInfo
                jc @@Quit
                call TransferInfo
                call ComputeSerialNum
                call ComputeSerialCRC
                call SerialToHex
                call PrintSerialNum

@@Quit:         mov ax,4C00h
                int 21h
ENDP            Start
;-----------------------------------------------------------------------------
PROC            PrintGreeting
                mov ah,9
                mov dx,offset Hello
                int 21h
                ret
ENDP            PrintGreeting
;-----------------------------------------------------------------------------
PROC            InputInfo
                mov ah,9
                mov dx,offset NamePrompt
                int 21h
                mov ah,0Ah
                mov dx,offset NameBuffer
                int 21h
                cmp [byte NameBuffer+1],0
                jz @@Quit

                mov ah,9
                mov dx,offset AddressPrompt
                int 21h
                mov ah,0Ah
                mov dx,offset AddressBuffer
                int 21h
                cmp [byte AddressBuffer+1],0
                jz @@Quit

                clc
                ret
@@Quit:         stc
                ret
ENDP            InputInfo
;-----------------------------------------------------------------------------
PROC            TransferInfo
                mov [byte UserIDbuffer],4
                mov eax,[dword MagicStart]
                mov [dword UserIDbuffer+1],eax
                movzx bx,[byte UserIDbuffer]

                mov si,offset NameBuffer+2
                movzx cx,[byte NameBuffer+1]
@@DoName:       mov al,[byte si]
                inc si
                MAKEUPPERCASE al
                cmp al,20h
                jz @@SkipName
                cmp al,0
                jz @@SkipName
                mov [byte bx+UserIDbuffer+1],al
                inc bl
                jz @@End
@@SkipName:     loop @@DoName

                mov si,offset AddressBuffer+2
                movzx cx,[byte AddressBuffer+1]
@@DoAddress:    mov al,[byte si]
                inc si
                MAKEUPPERCASE al
                cmp al,20h
                jz @@SkipAddress
                cmp al,0
                jz @@SkipAddress
                mov [byte bx+UserIDbuffer+1],al
                inc bl
                jz @@End
@@SkipAddress:  loop @@DoAddress

                mov eax,[dword MagicEnd]
                mov [dword bx+UserIDbuffer+1],eax
                add bl,4
                jnc @@NoOverflow
                mov bl,0FFh
@@NoOverflow:   mov [byte UserIDbuffer],bl

@@End:          ret
ENDP            TransferInfo
;-----------------------------------------------------------------------------
PROC            ComputeSerialNum
                mov si,offset UserIDbuffer+1
                movzx ecx,[byte UserIDbuffer]       ;ecx shouldn't be 0
                mov ebx,00000011h

@@Compute:      mov eax,ebx
                mul [MagicMultiply]
                and eax,7FFFFFFFh
                mov ebx,eax
                movzx eax,[byte si]
                MAKEUPPERCASE al
                add ebx,eax
                add ebx,00000013h
                inc si
                loop @@Compute

                mov [dword SerialNum],ebx
                clc
                ret
ENDP            ComputeSerialNum
;-----------------------------------------------------------------------------
PROC            ComputeSerialCRC
                movzx eax,[byte SerialNum]
                mov ecx,6
                mul ecx
                mov ebx,eax

                movzx eax,[byte SerialNum+1]
                mov ecx,3
                mul ecx
                add ebx,eax

                movzx eax,[byte SerialNum+2]
                mov ecx,5
                mul ecx
                add ebx,eax
                add ebx,13h

                movzx eax,[byte SerialNum+3]
                mov ecx,2
                mul ecx
                add eax,ebx

                xor edx,edx
                mov ecx,100h
                div ecx
                mov [byte SerialNum+4],dl
                ret
ENDP            ComputeSerialCRC
;-----------------------------------------------------------------------------
PROC            SerialToHex
                mov si,offset SerialText

                mov  al,[byte SerialNum+3]
                mov ah,al
                shr ah,4
                CONVERTTOHEX ah
                mov [byte si],ah
                inc si
                CONVERTTOHEX al
                mov [byte si],al
                inc si

                mov  al,[byte SerialNum+2]
                mov ah,al
                shr ah,4
                CONVERTTOHEX ah
                mov [byte si],ah
                inc si
                CONVERTTOHEX al
                mov [byte si],al
                inc si

                mov [byte si],'-'
                inc si

                mov  al,[byte SerialNum+1]
                mov ah,al
                shr ah,4
                CONVERTTOHEX ah
                mov [byte si],ah
                inc si
                CONVERTTOHEX al
                mov [byte si],al
                inc si

                mov  al,[byte SerialNum+0]
                mov ah,al
                shr ah,4
                CONVERTTOHEX ah
                mov [byte si],ah
                inc si
                CONVERTTOHEX al
                mov [byte si],al
                inc si

                mov [byte si],'-'
                inc si

                mov  al,[byte SerialNum+4]
                mov ah,al
                shr ah,4
                CONVERTTOHEX ah
                mov [byte si],ah
                inc si
                CONVERTTOHEX al
                mov [byte si],al
                inc si

                ret
ENDP            SerialToHex
;-----------------------------------------------------------------------------
PROC            PrintSerialNum
                mov ah,9
                mov dx,offset SerialMessage
                int 21h
                ret
ENDP            PrintSerialNum
;-----------------------------------------------------------------------------
ENDS            Code
;
                END Start
