/***************************************************************************
*	NAME:  CONFIG16.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "forte.h"
#include "extern.h"
#include "extern16.h"
#include "utility.h"

/***************************************************************
 * This function will parse the configuration variable "ULTRA16"
 * to find the settings for the configuration of the board.
 * It returns FALSE if the environment variable couldn't be found.
 ***************************************************************/

int
GetUltra16Cfg(config,config16)
ULTRA_CFG *config;
ULTRA16_CFG *config16;
{
char *ptr;

config16->base_port = 0x530;
config16->play_dma = 3;
config16->rec_dma = 3;
config16->irq_num = 5;
config16->type = 0;
config16->cdrom_base = 0;	/* default this to 0 (means don't enable ..) */

ptr = getenv("ULTRA16");
if (ptr == NULL)
	{
	return(FALSE);
	}
else
	{
	/* Can save some RAM by NOT using sscanf ... */
	sscanf(ptr,"%x,%d,%d,%d,%x",&config16->base_port,
							&config16->play_dma,
							&config16->irq_num,
							&config16->type,
							&config16->cdrom_base);
	switch(config16->type)
		{
		case 0:
			config16->rec_dma = config16->play_dma;
			break;
		case 1:
			/* UltraMax - Codec shares resources with GF1 */
			config16->rec_dma = config->dram_dma_chan;
			config16->play_dma = config->adc_dma_chan;
			config16->irq_num = config->gf1_irq_num;
			break;
		}
	}
return(TRUE);
}

