UNIT GusInit;

{ Auto Init/Shutdown module for the ultrasound.  Resets the GUS for
  14 voices - allowing 44kHz playback.  Installs an exit routine.  Once
  you mention this unit in your USES clause, you don't have to worry
  about set-up and shut-down ---> it's handled automatically

  This file is copyright <C> 1993, by Kurt Kennett of Ingenuity Software.
  Modification of it is a violation of copyright.
}

INTERFACE

{ No routines interfaced.  This is an automatic-process unit }

IMPLEMENTATION

USES
  UltraDrv,  { Gravis Ultrasound Driver }
  Crt;       { Screen/Keyboard          }

CONST
  Init_Voices = 14;    { # of voices to init the card for }

VAR
  SaveExit : Pointer;  { Old Exit Procedure address }

{ Exit Procedure }
PROCEDURE ShutDown; FAR;
  BEGIN
    ExitProc := SaveExit;    { restore old Exit Procedure }
    IF NOT UltraClose THEN
      Writeln('Could NOT shut down the UltraSound correctly.');
  END;

BEGIN
  GotoXY(1,24);
  TextAttr := Red*16+White;
  ClrEol;
  Write(' Ultrasound driver Version ',UltraVersionStr);
  Gotoxy(47,WhereY);
  Write('Copyright <C> 1993, Kurt Kennett');
  TextAttr := LightGray;
  Writeln;
  ClrEol;
  IF NOT Ultra_Installed THEN
    BEGIN
      Writeln;
      Writeln('ULTRASND Environment variable NOT found.');
      Halt(1);
    END;
  IF NOT UltraProbe(Ultra_Config.Base_Port) THEN
    BEGIN
      Writeln;
      Writeln('Could NOT find an UltraSound Card at the port specified.');
      Halt(2);
    END;
  IF NOT UltraOpen(Ultra_Config,Init_Voices) THEN
    BEGIN
      Writeln;
      Writeln('Could NOT initialize (open) the UltraSound for use.');
      Halt(3);
    END;
  SaveExit := ExitProc;
  ExitProc := @ShutDown;
  IF NOT UltraReset(Init_Voices) THEN
    BEGIN
      Writeln;
      Writeln('Could NOT reset the UltraSound.');
      Halt(4);
    END;
  Delay(800);
END.