/***************************************************************************
*	NAME:  VARS.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <stdio.h>
#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "dma.h"
#include "irq.h"
#include "gf1os.h"

/* Variables needed ... */

DMA_ENTRY	_gf1_dma[MAX_DMA] = {
#ifdef NEVER
/* DMA channel 0 */
			{0,0,0x04,0x00,DMA0_PAGE,DMA0_ADDR,DMA0_CNT,
			 DMA1_SNGL,DMA1_MODE,DMA1_CLRFF,0x08,0x04},
#endif

/* DMA channel 1 */
			{0,1,0x05,0x01,DMA1_PAGE,DMA1_ADDR,DMA1_CNT,
			 DMA1_SNGL,DMA1_MODE,DMA1_CLRFF,0x09,0x05},

/* DMA channel 2 */
			{0,0,0x06,0x02,DMA2_PAGE,DMA2_ADDR,DMA2_CNT,
			 DMA1_SNGL,DMA1_MODE,DMA1_CLRFF,0x0A,0x06},

/* DMA channel 3 */
			{0,2,0x07,0x03,DMA3_PAGE,DMA3_ADDR,DMA3_CNT,
			 DMA1_SNGL,DMA1_MODE,DMA1_CLRFF,0x0B,0x07},

/* DMA channel 4 */
			{0,0,0x04,0x00,DMA4_PAGE,DMA4_ADDR,DMA4_CNT,
			 DMA2_SNGL,DMA2_MODE,DMA2_CLRFF,0x08,0x04},

/* DMA channel 5 */
			{0,3,0x05,0x01,DMA5_PAGE,DMA5_ADDR,DMA5_CNT,
			 DMA2_SNGL,DMA2_MODE,DMA2_CLRFF,0x09,0x05},

/* DMA channel 6 */
			{0,4,0x06,0x02,DMA6_PAGE,DMA6_ADDR,DMA6_CNT,
			 DMA2_SNGL,DMA2_MODE,DMA2_CLRFF,0x0A,0x06},

/* DMA channel 7 */
			{0,5,0x07,0x03,DMA7_PAGE,DMA7_ADDR,DMA7_CNT,
			 DMA2_SNGL,DMA2_MODE,DMA2_CLRFF,0x0B,0x07},
};

IRQ_ENTRY _gf1_irq[MAX_IRQ] = {
	{0,0xFE,0x60,OCR1,IMR1},	/* 0 */
	{0,0xFD,0x61,OCR1,IMR1},	/* 1 */
	{1,0xFB,0x62,OCR1,IMR1},	/* 2 */
	{3,0xF7,0x63,OCR1,IMR1},	/* 3 */
	{0,0xEF,0x64,OCR1,IMR1},	/* 4 */
	{2,0xDF,0x65,OCR1,IMR1},	/* 5 */
	{0,0xBF,0x66,OCR1,IMR1},	/* 6 */
	{4,0x7F,0x67,OCR1,IMR1},	/* 7 */
	{0,0xFE,0x60,OCR2,IMR2},	/* 8 */
	{0,0xFD,0x61,OCR2,IMR2},	/* 9 */
	{0,0xFB,0x62,OCR2,IMR2},	/* 10 */
	{5,0xF7,0x63,OCR2,IMR2},	/* 11 */
	{6,0xEF,0x64,OCR2,IMR2},	/* 12 */
	{0,0xDF,0x65,OCR2,IMR2},	/* 13 */
	{0,0xBF,0x66,OCR2,IMR2},	/* 14 */
	{7,0x7F,0x67,OCR2,IMR2},	/* 15 */
};

ULTRA_DATA _gf1_data = {
		ULTRA_PRESENT,	/* flags ... */
		220,7,7,11,5,	/* hardware config */
		(PVI)NULL,(PVI)NULL,		/* old irq vectors (gf1,midi) */
		default_func,	/* midi transmit function */
		default_func,	/* midi recieve function */
		default_func,	/* timer1 function */
		default_func,	/* timer2 function */
		default_func,	/* wavetable function */
		default_func,	/* envelope function */
		default_func,	/* dma to dram irq function */
		default_func,	/* record dma irq function */
		default_func,	/* aux irq handler function (UltraMax) */
		0x0B,			/* image of mix register */
		32,				/* # of active voices */
		0,				/* midi image */
		0L,				/* used voices */
		32L,			/* reserved DRAM */
};

