
//
//  Macros
//

//  Return values for GUS_open()

enum    LoadVals    {
    LOAD_OK, LOAD_OPENERROR, LOAD_READERROR, LOAD_MEMERROR, LOAD_NOGUS,
    LOAD_NOENVVAR, LOAD_BADVOICES, LOAD_FMTERROR
};

struct  IRQEntry
{
    ubyte   Latch;
    ubyte   Mask;
    ubyte   SpecEOI;
    ubyte   OCR;
    ubyte   IMR;
};

struct  DSMHeader
{
    char    DSm[3];         //  DSm signature
    ubyte   Num1A;
    ubyte   Version;
    char    SongName[20];   //  Song name
    char    Composer[20];   //  Composer
    ubyte   NumChn;         //  Channels used
    ubyte   NumSmp;         //  Samples used
    ubyte   SongLen;        //  Song Length
    ubyte   Pck;            //  Pack information
    ubyte   MasterVol;      //  Master volume
    ubyte   Reserved[14];
};

struct  Sample
{
    ubyte   LoopMode;
    ubyte   Bits;
    ubyte   Volume;
    ubyte   FineTune;
    uword   SmpLen;
    ulong   SmpLoc;
    ulong   RepLoc;
    ulong   SmpEnd;
};

struct  Channel
{
    ubyte   SmpNum;
    ubyte   Effect;
    ubyte   EffectValue;
    ubyte   SmpBits;
    ubyte   LoopMode;
    ubyte   Volume;
    ubyte   FineTune;
    ubyte   NewNote;
    ubyte   voice;
    ubyte   WaveControl;
    ubyte   VibratoPos;
    ubyte   VibratoCmd;
    ubyte   TremoloPos;
    ubyte   TremoloCmd;
    ubyte   GlissControl;
    ubyte   ToneDir;
    ubyte   ToneSpeed;
    ubyte   WantNote;
    ubyte   NoteNum;
    ubyte   OldNote;
    word    Period;
    word    PlayPer;
    word    WantPer;
    word    OldPer;
    ulong   SmpLoc;
    ulong   SmpEnd;
    ulong   RepLoc;
};

struct  NoteInfo
{
    ubyte   SmpNum;         //  Sample Number
    ubyte   Key;            //  Note number
    ubyte   Cmd;            //  Command
    ubyte   Dta;            //  Databyte for command
};


void    GUS_startTimer( void );
void    GUS_stopTimer( void );
ubyte   LoadModule( char * );
void    UnloadModule( void );


