@ECHO OFF
REM PLAYXMI.BAT - play .XMI files on the Gravis UltraSound in DOS
REM             - uses UltraMID and MIDPAK    - XMI = eXtended MIDI
REM             - DOS shell during playback   - Online help
REM             - v1.0 by Samer Meshreki (meshreki@udel.edu)
REM
REM Usage:  PLAYXMI filename.XMI
REM         PLAYXMI help

IF .%1.==.. GOTO usage
IF NOT .%2.==.. GOTO usage
IF %1==help GOTO install
IF %1==HELP GOTO install

IF .%ultradir%.==.. GOTO noultradir
IF .%ultrasnd%.==.. GOTO noultrasnd
IF NOT EXIST %ultradir%\ultramid\midpak.ad GOTO nomidpak
IF NOT EXIST %ultradir%\ultramid\midpak.com GOTO nomidpak
IF NOT EXIST %ultradir%\midi\ultramid.ini GOTO noultramid
IF NOT EXIST %ultradir%\ultramid\gf1midi.adv GOTO noultramid
REM IF NOT EXIST %ultradir%\ultramid.exe GOTO noultramid
IF NOT EXIST %temp%nul GOTO tempfirstfail
IF NOT .%temp%.==.. IF NOT .%temp%.==... SET temp=%temp%.
:tempfirstfail
IF NOT EXIST %temp%\nul GOTO notemp
IF EXIST %1.xmi GOTO playxmi
IF EXIST %1 GOTO playxmi
GOTO filenotfound

:playxmi
IF EXIST %temp%\midpak.adv IF EXIST %temp%\midpak.xmi GOTO resident
ECHO.
ECHO PLAYXMI.BAT v1.0 Copyright 1994 Samer Meshreki
ECHO.
IF NOT EXIST %temp%\midpak.ad COPY %ultradir%\ultramid\midpak.ad %temp%\midpak.ad >nul
IF NOT EXIST %temp%\midpak.com COPY %ultradir%\ultramid\midpak.com %temp%\midpak.com >nul
IF NOT EXIST %temp%\midpak.adv COPY %ultradir%\ultramid\gf1midi.adv %temp%\midpak.adv >nul
IF EXIST %1.xmi COPY %1.xmi %temp%\midpak.xmi >nul
IF EXIST %1 COPY %1 %temp%\midpak.xmi >nul
IF NOT EXIST %temp%\midpak.ad GOTO notempspace
IF NOT EXIST %temp%\midpak.com GOTO notempspace
IF NOT EXIST %temp%\midpak.adv GOTO notempspace
IF NOT EXIST %temp%\midpak.xmi GOTO notempspace
IF EXIST %ultradir%\ultramid.exe %ultradir%\ultramid
IF NOT EXIST %ultradir%\ultramid.exe ultramid

%temp%\midpak.com 64

REM Test to see if there is enough enivronment variable space to do
REM a DOS shell with a new, informative prompt _and_ save old prompt!
SET PXMITEST=
SET PXMIPMPT=%prompt%
SET PXMITEST=z
IF NOT .%pxmitest%.==.z. GOTO noenv
SET PXMITEST=
SET PROMPT=PLAYXMI: Type EXIT to end playback and remove drivers from memory.$_%prompt%
SET PXMITEST=z
IF .%pxmitest%.==.z. GOTO yesenv
SET PROMPT=%pxmipmpt%
GOTO noenv

:noenv  
REM *** Not enough environment variable space to do a DOS shell w/ new propmt
SET PXMIPMPT=
SET PXMITEST=
ECHO.
ECHO *** PLAYXMI will run correctly without environment space ***
ECHO.
ECHO -------------------------------------------------------------------------
ECHO PLAYXMI:  Type EXIT to end playback and remove sound drivers from memory.
ECHO -------------------------------------------------------------------------
IF NOT .%comspec%.==.. IF EXIST %comspec% %comspec%
IF .%comspec%.==.. pause
GOTO endplayxmi

:yesenv
IF NOT .%comspec%.==.. IF EXIST %comspec% %comspec%
IF .%comspec%.==.. pause
SET PROMPT=%pxmipmpt%
SET PXMIPMPT=
SET PXMITEST=
GOTO endplayxmi

:endplayxmi
%temp%\midpak u
IF EXIST %ultradir%\ultramid.exe %ultradir%\ultramid -f
IF NOT EXIST %ultradir%\ultramid.exe ultramid -f
IF EXIST %ultradir%\ultramid\midpak.xmi DEL %temp%\midpak.xmi
IF EXIST %ultradir%\ultramid\midpak.xmi DEL %temp%\midpak.*
IF EXIST %ultradir%\ultramid\midpak.adv DEL %temp%\midpak.adv
IF EXIST %ultradir%\ultramid\midpak.adv DEL %temp%\midpak.*
IF EXIST %temp%\midpak.xmi DEL %temp%\midpak.*
IF EXIST %temp%\midpak.adv DEL %temp%\midpak.*
GOTO end

:install
ECHO.
ECHO PLAYXMI.BAT requires that the ULTRADIR and ULTRASND variables be set.
ECHO This is necessary for UltraMID to find your General MIDI patches in
ECHO the MIDI subdirectory of ULTRADIR, and to help PLAYXMI find other files.
ECHO The TEMP variable, if found, will be used for file storage during playback.
ECHO The COMSPEC variable should point to COMMAND.COM or another DOS shell.
ECHO.
IF .%ultradir%.==.. ECHO Example:  SET ULTRADIR=C:\ULTRASND  (patches in C:\ULTRASND\MIDI)
IF NOT .%ultradir%.==.. ECHO           SET ULTRADIR=%ultradir%  (patches in %ultradir%\MIDI)
IF .%ultrasnd%.==.. ECHO Example:  SET ULTRASND=220,1,1,11,5
IF NOT .%ultrasnd%.==.. ECHO           SET ULTRASND=%ultrasnd%
IF .%temp%.==.. ECHO Example:  SET TEMP=C:\
IF NOT .%temp%.==.. ECHO           SET TEMP=%temp%
IF .%comspec%.==.. ECHO Example:  SET COMSPEC=C:\DOS\COMMAND.COM
IF NOT .%comspec%.==.. ECHO           SET COMSPEC=%comspec%
ECHO.
ECHO PLAYXMI.BAT uses the MIDPAK drivers which require UltraMID to function.
ECHO UltraMID can be found on the UltraSound install disks v3.11 or later.
ECHO ULTRAMID.EXE needs to be in your ULTRADIR directory or in your PATH.
ECHO ULTRAMID.INI needs to be in the MIDI subdirectory of ULTRADIR.
ECHO GF1MIDI.ADV, MIDPAK.COM, MIDPAK.AD need to be in the ULTRAMID subdirectory.
ECHO.
IF .%ultradir%.==.. ECHO Example:  C:\ULTRASND\ULTRAMID.EXE
IF NOT .%ultradir%.==.. IF NOT EXIST %ultradir%\ultramid.exe ECHO Example:  %ultradir%\ULTRAMID.EXE
IF NOT .%ultradir%.==.. IF EXIST %ultradir%\ultramid.exe ECHO           %ultradir%\ULTRAMID.EXE
IF .%ultradir%.==.. ECHO Example:  C:\ULTRASND\MIDI\ULTRAMID.INI
IF NOT .%ultradir%.==.. IF NOT EXIST %ultradir%\midi\ultramid.ini ECHO Example:  %ultradir%\MIDI\ULTRAMID.INI
IF NOT .%ultradir%.==.. IF EXIST %ultradir%\midi\ultramid.ini ECHO           %ultradir%\MIDI\ULTRAMID.INI
IF .%ultradir%.==.. ECHO Example:  C:\ULTRASND\ULTRAMID\GF1MIDI.ADV
IF NOT .%ultradir%.==.. IF NOT EXIST %ultradir%\ultramid\gf1midi.adv ECHO Example:  %ultradir%\ULTRAMID\GF1MIDI.ADV
IF NOT .%ultradir%.==.. IF EXIST %ultradir%\ultramid\gf1midi.adv ECHO           %ultradir%\ULTRAMID\GF1MIDI.ADV
IF .%ultradir%.==.. ECHO Example:  C:\ULTRASND\ULTRAMID\MIDPAK.COM
IF NOT .%ultradir%.==.. IF NOT EXIST %ultradir%\ultramid\midpak.com ECHO Example:  %ultradir%\ULTRAMID\MIDPAK.COM
IF NOT .%ultradir%.==.. IF EXIST %ultradir%\ultramid\midpak.com ECHO           %ultradir%\ULTRAMID\MIDPAK.COM
IF .%ultradir%.==.. ECHO Example:  C:\ULTRASND\ULTRAMID\MIDPAK.AD
IF NOT .%ultradir%.==.. IF NOT EXIST %ultradir%\ultramid\midpak.ad ECHO Example:  %ultradir%\ULTRAMID\MIDPAK.AD
IF NOT .%ultradir%.==.. IF EXIST %ultradir%\ultramid\midpak.ad ECHO           %ultradir%\ULTRAMID\MIDPAK.AD
GOTO end
:filenotfound
ECHO.
ECHO *** ERROR:  File %1 or %1.XMI not found ***
GOTO usage
:noultramid
ECHO.
ECHO *** ERROR:  UltraMID not found or not installed ***
ECHO.
ECHO PLAYXMI.BAT uses the MIDPAK drivers which require UltraMID to function.
ECHO UltraMID can be found on the UltraSound install disks v3.11 or later.
ECHO The General MIDI patches must also be installed and located in the 
ECHO MIDI subdirectory of ULTRADIR.
ECHO.
ECHO ULTRAMID.EXE needs to be in your ULTRADIR directory or in your PATH.
ECHO ULTRAMID.INI needs to be in the MIDI subdirectory of ULTRADIR.
ECHO GF1MIDI.ADV needs to be in the ULTRAMID subdirectory of ULTRADIR.
ECHO.
IF EXIST %ultradir%\ultramid.exe ECHO           %ultradir%\ULTRAMID.EXE
IF NOT EXIST %ultradir%\ultramid.exe ECHO Example:  %ultradir%\ULTRAMID.EXE
IF EXIST %ultradir%\midi\ultramid.ini ECHO           %ultradir%\MIDI\ULTRAMID.INI
IF NOT EXIST %ultradir%\midi\ultramid.ini ECHO Example:  %ultradir%\MIDI\ULTRAMID.INI
IF EXIST %ultradir%\ultramid\gf1midi.adv ECHO           %ultradir%\ULTRAMID\GF1MIDI.ADV
IF NOT EXIST %ultradir%\ultramid\gf1midi.adv ECHO Example:  %ultradir%\ULTRAMID\GF1MIDI.ADV
GOTO usage
:noultradir
ECHO.
ECHO *** ERROR:  ULTRADIR environment variable not found ***
ECHO.
ECHO PLAYXMI.BAT requires that the ULTRADIR environment variable be set.
ECHO This is necessary for UltraMID to find your General MIDI patches in
ECHO the MIDI subdirectory pointed to by ULTRADIR, and for PLAYXMI.BAT
ECHO to find other related files.
ECHO.
ECHO Example:  SET ULTRADIR=C:\ULTRASND    (patches in C:\ULTRASND\MIDI)
GOTO usage
:noultrasnd
ECHO.
ECHO *** ERROR:  ULTRASND environment variable not found ***
ECHO.
ECHO PLAYXMI.BAT requires that the ULTRASND environment variable be set.
ECHO This is necessary for UltraMID to work, as well as most UltraSound 
ECHO software.  The SETUP/INSTALL program provided on the v3.11 install disks
ECHO does a good job of configuring this variable and testing for compatbility.
ECHO.
ECHO Example:  SET ULTRASND=220,1,1,11,5
GOTO usage
:resident
ECHO.
ECHO *** ERROR:  PLAYXMI appears to be resident in memory ***
ECHO.
ECHO PLAYXMI.BAT executes a DOS shell so that you may continue using your computer
ECHO during playback.  This DOS shell must be exited before playing another song.
ECHO Type EXIT to end the DOS shell and remove PLAYXMI sound drivers from memory.
ECHO.
ECHO Example:  EXIT
ECHO.
ECHO If you still get this message after having typed EXIT, it is possible that
ECHO PLAYXMI was interrupted before it could erase all of its temporary files.
IF NOT .%temp%.==.. ECHO Manually delete MIDPAK.ADV and MIDPAK.XMI from the TEMP directory.
IF .%temp%.==.. ECHO Manually delete MIDPAK.ADV and MIDPAK.XMI from the root directory.
ECHO.
IF NOT .%temp%.==.. ECHO Example:  DEL %temp%\MIDPAK.ADV
IF .%temp%.==.. ECHO Example:  DEL \MIDPAK.ADV
IF NOT .%temp%.==.. ECHO Example:  DEL %temp%\MIDPAK.XMI
IF .%temp%.==.. ECHO Example:  DEL \MIDPAK.XMI
GOTO usage
:notemp
ECHO.
ECHO *** ERROR:  The directory %temp% does not exist ***
ECHO.
ECHO PLAYXMI.BAT creates some temporary files during playback.
ECHO If the TEMP environment variable is found, it will place those
ECHO files in the directory pointed to by TEMP and remove them when
ECHO playback has completed.  If the TEMP environment variable is not
ECHO set, the root directory is used.
ECHO.
ECHO Example:  SET TEMP=C:\
GOTO usage
:notempspace
ECHO.
IF NOT .%temp%.==.. ECHO *** ERROR:  Not enough free disk space  TEMP=%temp% ***
IF .%temp%.==.. ECHO *** ERROR:  Not enough free disk space on the current drive ***
ECHO.
ECHO PLAYXMI.BAT creates some temporary files during playback.  The music
ECHO drivers are currently 90K, and add to that the size of any .XMI file 
ECHO to determine the total amount of free disk space needed (about 200K).
ECHO PLAYXMI will place the temporary files in the TEMP directory.  If TEMP
ECHO is not set, then the root directory of the current drive is used.
ECHO.
ECHO Example:  SET TEMP=C:\
IF EXIST %ultradir%\ultramid\midpak.xmi DEL %temp%\midpak.xmi
IF EXIST %ultradir%\ultramid\midpak.xmi DEL %temp%\midpak.*
IF EXIST %ultradir%\ultramid\midpak.adv DEL %temp%\midpak.adv
IF EXIST %ultradir%\ultramid\midpak.adv DEL %temp%\midpak.*
IF EXIST %temp%\midpak.xmi DEL %temp%\midpak.*
IF EXIST %temp%\midpak.adv DEL %temp%\midpak.*
GOTO usage
:nomidpak
ECHO.
ECHO *** ERROR:  MIDPAK files not found ***
ECHO.
ECHO MIDPAK.AD needs to be in the ULTRAMID subdirectory of ULTRADIR.
ECHO MIDPAK.COM needs to be in the ULTRAMID subdirectory of ULTRADIR.
ECHO.
IF NOT EXIST %ultradir%\ultramid\midpak.com ECHO Example:  %ultradir%\ULTRAMID\MIDPAK.COM
IF EXIST %ultradir%\ultramid\midpak.com ECHO           %ultradir%\ULTRAMID\MIDPAK.COM
IF NOT EXIST %ultradir%\ultramid\midpak.ad ECHO Example:  %ultradir%\ULTRAMID\MIDPAK.AD
IF EXIST %ultradir%\ultramid\midpak.ad ECHO           %ultradir%\ULTRAMID\MIDPAK.AD
:usage
ECHO.
ECHO PLAYXMI.BAT - play .XMI files on the Gravis UltraSound in DOS
ECHO             - uses UltraMID and MIDPAK    - XMI = eXtended MIDI
ECHO             - DOS shell during playback   - Online help
ECHO             - v1.0 by Samer Meshreki (meshreki@udel.edu)
ECHO.
ECHO Usage:  PLAYXMI filename.XMI
ECHO         PLAYXMI help
:end
IF .%temp%.==... SET temp=
ECHO.
