#ifndef __THREED_H__
#define __THREED_H__

/***************************************************************************
*	NAME:  THREED.H
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 02/01/93
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	02/01/93		Original
***************************************************************************/

#ifdef MSOFTC
#define _Cdecl  _cdecl
#else
#if __STDC__
#undef _Cdecl
#define _Cdecl
#else
#define _Cdecl  cdecl
#endif
#endif

#define FRONT_VOICE 0
#define NEAR_VOICE  1
#define REAR_VOICE  2
#define FAR_VOICE   3
#define UP_VOICE    4
#define DOWN_VOICE  5

#define XAXIS_3D	0
#define YAXIS_3D	1
#define ZAXIS_3D	2

typedef struct {
	int voicenum;				/* voice to start */
	int curvol;					/* current volume */
	unsigned long begin;		/* start location in ultra DRAM */
	unsigned long start;		/* start loop location in ultra DRAM */
	unsigned long end;			/* end location in ultra DRAM */
} VOICE_DATA_3D;

/* flag definitions */
#define RIGHT_HEMI		0x01	/* sound is in right hemisphere */
#define FRONT_HEMI		0x02	/* sound is in front */
#define TOP_HEMI		0x04	/* sound is above horizontal */

typedef struct {
	char	type;				/* see above bits .... */
	int		flags;				/* hemisphere flags */
	char	rate;				/* set for speed of ramping ... */
	int		maxvol;				/* volume when at 0,0,0 location */
	int		num_tracks;			/* number of tracks for this sound */
	unsigned long freq;
	unsigned char vmode;		/* mode to run the voice (loop etc) */
	unsigned char dmode;		/* mode to run the dma channel in */
	VOICE_DATA_3D vdata[6];		/* voice specific data */
} SOUND_3D;

/* Error codes returned from the 3D functions */

/* Don't return a 1. Thats ULTRA_OK & defined in ultraerr.h */
#define NO_3D_FILE		101		/* Can't open file */
#define BAD_3D_HDR		102		/* Header for file is corrupt/non-existant */
#define NO_DRAM_3D		103		/* Not enough room for this sound */
#define NO_3D_HDR		104		/* No header on this file */
#define NOT_BLOCK_DATA	105		/* data not in block format */
#define BAD_FILE_DATA	106		/* not enough data as header says */
#define NOT_INTERLEAVED_DATA	107		/* data not in interleaved format */
#define BAD_3D_FREQ		108		/* invalid freq. for interleaved 3D data */

void _Cdecl UltraAbsPosition3d(SOUND_3D far *, int, int, int);
void _Cdecl UltraAngFltPosition3d(SOUND_3D far *, double, double, int);
void _Cdecl UltraAngPosition3d(SOUND_3D far *, int, int, int);
void _Cdecl UltraCloseDup3d(SOUND_3D far *);
int _Cdecl UltraDup3d(SOUND_3D far *, SOUND_3D far *);
int _Cdecl UltraLoad3dEffect(SOUND_3D far *, char far *, void far *, unsigned int);
int _Cdecl UltraSetFreq3d(SOUND_3D far *, unsigned long);
void _Cdecl UltraSetFrequency(int, unsigned long);
void _Cdecl UltraStart3d(SOUND_3D far *);
void _Cdecl UltraStop3d(SOUND_3D far *, int);
void _Cdecl UltraUnLoad3dEffect(SOUND_3D far *);

/* interleaved specific functions */
int _Cdecl UltraSetup3dInterleave(SOUND_3D far *, char far *, unsigned long);
void _Cdecl UltraRelease3dInterleave(SOUND_3D far *);

#endif

