
#ifndef  __SOCOM_US_H__
#define  __SOCOM_US_H__

//Ŀ
//                                                                           
// SOCOM                                                                     
//                                                                           
// Gravis UltraSound hardware definitions                                    
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

//Ŀ
//                                                                           
// Macros                                                                    
//                                                                           
//

#define  ADDR_HIGH( x ) (unsigned int)(( x >> 7L ) & 0x1fffL )
#define  ADDR_LOW( x )  (unsigned int)(( x & 0x7fL ) << 9L )

//Ŀ
//                                                                           
// Base register mapping                                                     
//                                                                           
//

#define  GF1_PAGE       0x102
#define  GF1_REG_SELECT 0x103
#define  GF1_DATA_LOW   0x104
#define  GF1_DATA_HIGH  0x105
#define  GF1_DRAM       0x107
#define  GF1_TIMER_CTRL 0x008
#define  GF1_TIMER_DATA 0x009
#define  GF1_IRQ_CTRL   0x00b
#define  GF1_IRQ_STAT   0x006

//Ŀ
//                                                                           
// Register select mapping                                                   
//                                                                           
//

#define  DMA_CONTROL       0x41
#define  SET_DMA_ADDRESS   0x42
#define  SET_DRAM_LOW      0x43
#define  SET_DRAM_HIGH     0x44
#define  TIMER_CONTROL     0x45
#define  TIMER1            0x46
#define  TIMER2            0x47
#define  SAMPLE_CONTROL    0x49
#define  MASTER_RESET      0x4c

//Ŀ
//                                                                           
// Voice register mapping                                                    
//                                                                           
//

#define  SET_CONTROL          0x00
#define  SET_FREQUENCY        0x01
#define  SET_START_HIGH       0x02
#define  SET_START_LOW        0x03
#define  SET_END_HIGH         0x04
#define  SET_END_LOW          0x05
#define  SET_VOLUME_RATE      0x06
#define  SET_VOLUME_START     0x07
#define  SET_VOLUME_END       0x08
#define  SET_VOLUME           0x09
#define  SET_ACC_HIGH         0x0a
#define  SET_ACC_LOW          0x0b
#define  SET_BALANCE          0x0c
#define  SET_VOLUME_CONTROL   0x0d
#define  SET_VOICES           0x0e

#define  GET_CONTROL          0x80
#define  GET_FREQUENCY        0x81
#define  GET_START_HIGH       0x82
#define  GET_START_LOW        0x83
#define  GET_END_HIGH         0x84
#define  GET_END_LOW          0x85
#define  GET_VOLUME_RATE      0x86
#define  GET_VOLUME_START     0x87
#define  GET_VOLUME_END       0x88
#define  GET_VOLUME           0x89
#define  GET_ACC_HIGH         0x8a
#define  GET_ACC_LOW          0x8b
#define  GET_BALANCE          0x8c
#define  GET_VOLUME_CONTROL   0x8d
#define  GET_VOICES           0x8e
#define  GET_IRQV             0x8f

//Ŀ
//                                                                           
// GF1 IRQ/DMA programmable latches                                          
//                                                                           
//

#define  MIDI_TX_IRQ          0x01  // pending MIDI xmit IRQ
#define  MIDI_RX_IRQ          0x02  // pending MIDI recv IRQ
#define  GF1_TIMER1_IRQ       0x04  // general purpose timer
#define  GF1_TIMER2_IRQ       0x08  // general purpose timer
#define  WAVETABLE_IRQ        0x20  // pending wavetable IRQ
#define  ENVELOPE_IRQ         0x40  // pending volume envelope IRQ
#define  DMA_TC_IRQ           0x80  // pending dma tc IRQ

//Ŀ
//                                                                           
// DMA control register                                                      
//                                                                           
//

#define  DMA_ENABLE           0x01
#define  DMA_READ             0x02  // 1=read,0=write
#define  DMA_WIDTH_16         0x04  // 1=16 bit,0=8 bit (dma chan width)
#define  DMA_RATE             0x18  // 00=fast, 11=slow
#define  DMA_IRQ_ENABLE       0x20  // 1=enable
#define  DMA_IRQ_PENDING      0x40  // read
#define  DMA_DATA_16          0x40  // write (data width)
#define  DMA_TWOS_COMP        0x80  // 1 = do twos comp

#define  DMA_R0               0x00  // fastest DMA xfer (~650khz)
#define  DMA_R1               0x08  // fastest / 2
#define  DMA_R2               0x10  // fastest / 4
#define  DMA_R3               0x18  // slowest DMA xfer (fastest / 8)

//Ŀ
//                                                                           
// Reset control register                                                    
//                                                                           
//

#define  GF1_MASTER_RESET     0x01  // 0=hold in reset
#define  GF1_OUTPUT_ENABLE    0x02  // enable output
#define  GF1_MASTER_IRQ       0x04  // master IRQ enable

//Ŀ
//                                                                           
// Mixer control register                                                    
//                                                                           
//

#define  ENABLE_LINE_IN       0x01  // 0=enable
#define  ENABLE_OUTPUT        0x02  // 0=enable
#define  ENABLE_MIC_IN        0x04  // 1=enable

//Ŀ
//                                                                           
// Voice control register                                                    
//                                                                           
//

#define  VOICE_STOPPED        0x01  // voice has stopped
#define  STOP_VOICE           0x02  // stop voice
#define  VC_DATA_TYPE         0x04  // 0=8 bit,1=16 bit
#define  VC_LOOP_ENABLE       0x08  // 1=enable
#define  VC_BI_LOOP           0x10  // 1=bi directional looping
#define  VC_WAVE_IRQ          0x20  // 1=enable voice's wave irq
#define  VC_DIRECT            0x40  // 0=increasing,1=decreasing
#define  VC_IRQ_PENDING       0x80  // 1=wavetable irq pending

//Ŀ
//                                                                           
// Volume control register                                                   
//                                                                           
//

#define  VOLUME_STOPPED       0x01  // volume has stopped
#define  STOP_VOLUME          0x02  // stop volume
#define  VC_ROLLOVER          0x04  // Roll PAST end & gen IRQ
#define  VL_LOOP_ENABLE       0x08  // 1=enable
#define  VL_BI_LOOP           0x10  // 1=bi directional looping
#define  VL_WAVE_IRQ          0x20  // 1=enable voice's wave irq
#define  VL_DIRECT            0x40  // 0=increasing,1=decreasing
#define  VL_IRQ_PENDING       0x80  // 1=wavetable irq pending

#define  DMA_AUTO_INIT        0x01  // Used by app to specify autoinit
#define  DMA_16               0x40
#define  DMA_8                0x00
#define  DMA_CVT_2            0x80
#define  DMA_NO_CVT           0x00
#define  USE_ROLLOVER         0x01

//Ŀ
//                                                                           
// Sources of IRQs                                                           
//                                                                           
//

#define  VOICE_VOLUME_IRQ     0x40
#define  VOICE_WAVE_IRQ       0x80

//Ŀ
//                                                                           
// Memory allocation definitions                                             
//                                                                           
//

#define  POOL_SIZE            256L*1024L-32L
#define  NEXT_OFFSET          0L
#define  PREV_OFFSET          4L
#define  SIZE_OFFSET          8L
#define  MEM_HEADER_SIZE      SIZE_OFFSET+4L


#endif   // __SOCOM_US_H__
