
//Ŀ
//                                                                           
// SOCOM                                                                     
//                                                                           
// Data tables                                                               
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\tables.h>

//Ŀ
//                                                                           
// Data table for the 2 cascade connected 8259 IRQ controllers               
//                                                                           
//

IRQLine  scIRQTable[16] = {
   { 0, 0xFE, 0x60, OCR1, IMR1 },
   { 0, 0xFD, 0x61, OCR1, IMR1 },
   { 1, 0xFB, 0x62, OCR1, IMR1 },
   { 3, 0xF7, 0x63, OCR1, IMR1 },
   { 0, 0xEF, 0x64, OCR1, IMR1 },
   { 2, 0xDF, 0x65, OCR1, IMR1 },
   { 0, 0xBF, 0x66, OCR1, IMR1 },
   { 4, 0x7F, 0x67, OCR1, IMR1 },
   { 0, 0xFE, 0x60, OCR2, IMR2 },
   { 0, 0xFD, 0x61, OCR2, IMR2 },
   { 0, 0xFB, 0x62, OCR2, IMR2 },
   { 5, 0xF7, 0x63, OCR2, IMR2 },
   { 6, 0xEF, 0x64, OCR2, IMR2 },
   { 0, 0xDF, 0x65, OCR2, IMR2 },
   { 0, 0xBF, 0x66, OCR2, IMR2 },
   { 7, 0x7F, 0x67, OCR2, IMR2 },
};

//Ŀ
//                                                                           
// Data table for the 2 cascade connected 8237 DMA controllers               
//                                                                           
//

DMAChan  scDMATable[8] = {
   { 0, 0x04, 0x00, DMA0_PAGE, DMA0_ADDR, DMA0_CNT, DMA1_SNGL, DMA1_MODE,
      DMA1_CLRFF, 0x48, 0x44 },  // DMA0
   { 1, 0x05, 0x01, DMA1_PAGE, DMA1_ADDR, DMA1_CNT, DMA1_SNGL, DMA1_MODE,
      DMA1_CLRFF, 0x49, 0x45 },  // DMA1
   { 0, 0x06, 0x02, DMA2_PAGE, DMA2_ADDR, DMA2_CNT, DMA1_SNGL, DMA1_MODE,
      DMA1_CLRFF, 0x4A, 0x46 },  // DMA2
   { 2, 0x07, 0x03, DMA3_PAGE, DMA3_ADDR, DMA3_CNT, DMA1_SNGL, DMA1_MODE,
      DMA1_CLRFF, 0x4B, 0x47 },  // DMA3
   { 0, 0x04, 0x00, DMA4_PAGE, DMA4_ADDR, DMA4_CNT, DMA2_SNGL, DMA2_MODE,
      DMA2_CLRFF, 0x48, 0x44 },  // DMA4
   { 3, 0x05, 0x01, DMA5_PAGE, DMA5_ADDR, DMA5_CNT, DMA2_SNGL, DMA2_MODE,
      DMA2_CLRFF, 0x49, 0x45 },  // DMA5
   { 4, 0x06, 0x02, DMA6_PAGE, DMA6_ADDR, DMA6_CNT, DMA2_SNGL, DMA2_MODE,
      DMA2_CLRFF, 0x4A, 0x46 },  // DMA6
   { 5, 0x07, 0x03, DMA7_PAGE, DMA7_ADDR, DMA7_CNT, DMA2_SNGL, DMA2_MODE,
      DMA2_CLRFF, 0x4B, 0x47 },
};

//Ŀ
//                                                                           
// Logarithmic volume table for GUS indexed on linear volumes 0-64           
//                                                                           
//

uword scUsVolTable[65] = {
   20000, 45056, 47104, 48128, 48640, 49152, 50176, 51200,
   52224, 53248, 53760, 54272, 54784, 55296, 55808, 56320,
   56832, 57344, 57600, 57856, 58112, 58368, 58624, 58880,
   58936, 59192, 59448, 59704, 59960, 60216, 60472, 60728,
   60984, 61568, 61696, 61824, 61952, 62080, 62208, 62336,
   62464, 62592, 62720, 62848, 62976, 63104, 63232, 63360,
   63488, 63616, 63744, 63872, 64000, 64128, 64256, 64384,
   64512, 64640, 64768, 64896, 65024, 65152, 65280, 65408,
   65520
};

//Ŀ
//                                                                           
// 5-octave period table                                                     
//                                                                           
//

int   scPerTable[16*60] = {
   1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960, 906,   // FT00OT0
    856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,   // FT00OT1
    428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,   // FT00OT2
    214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,   // FT00OT3
    107, 101,  95,  90,  85,  80,  75,  71,  67,  63,  60,  56,   // FT00OT4

   1700,1604,1514,1430,1348,1274,1202,1134,1070,1010, 954, 900,   // FT+1OT0
    850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450,   // FT+1OT1
    425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225,   // FT+1OT2
    213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113,   // FT+1OT3
    106, 100,  94,  89,  84,  79,  75,  71,  67,  63,  59,  56,   // FT+1OT4

   1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948, 894,   // FT+2OT0
    844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447,   // FT+2OT1
    422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224,   // FT+2OT2
    211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112,   // FT+2OT3
    105,  99,  94,  88,  83,  79,  74,  70,  66,  62,  59,  56,   // FT+2OT4

   1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940, 888,   // FT+3OT0
    838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444,   // FT+3OT1
    419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222,   // FT+3OT2
    209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111,   // FT+3OT3
    104,  99,  93,  88,  83,  78,  74,  70,  66,  62,  59,  55,   // FT+3OT4

   1664,1570,1482,1398,1320,1246,1176,1110,1048, 990, 934, 882,   // FT+4OT0
    832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441,   // FT+4OT1
    416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220,   // FT+4OT2
    208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110,   // FT+4OT3
    104,  98,  92,  87,  82,  78,  73,  69,  65,  62,  58,  55,   // FT+4OT4

   1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926, 874,   // FT+5OT0
    826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437,   // FT+5OT1
    413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219,   // FT+5OT2
    206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109,   // FT+5OT3
    103,  97,  92,  87,  82,  77,  73,  69,  65,  61,  58,  54,   // FT+5OT4

   1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920, 868,   // FT+6OT0
    820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434,   // FT+6OT1
    410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217,   // FT+6OT2
    205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109,   // FT+6OT3
    102,  96,  91,  86,  81,  77,  72,  68,  64,  61,  57,  54,   // FT+6OT4

   1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914, 862,   // FT+7OT0
    814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431,   // FT+7OT1
    407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216,   // FT+7OT2
    204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108,   // FT+7OT3
    102,  96,  90,  85,  80,  76,  72,  68,  64,  60,  57,  54,   // FT+7OT4

   1814,1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960,   // FT-8OT0
    907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480,   // FT-8OT1
    453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240,   // FT-8OT2
    226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120,   // FT-8OT3
    113, 107, 101,  95,  90,  85,  80,  75,  71,  67,  63,  60,   // FT-8OT4

   1800,1700,1604,1514,1430,1350,1272,1202,1134,1070,1010, 954,   // FT-7OT0
    900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477,   // FT-7OT1
    450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238,   // FT-7OT2
    225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119,   // FT-7OT3
    112, 106, 100,  94,  89,  84,  79,  75,  71,  67,  63,  59,   // FT-7OT4

   1788,1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948,   // FT-6OT0
    894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474,   // FT-6OT1
    447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237,   // FT-6OT2
    223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118,   // FT-6OT3
    111, 105,  99,  94,  88,  83,  79,  74,  70,  66,  62,  59,   // FT-6OT4

   1774,1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940,   // FT-5OT0
    887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470,   // FT-5OT1
    444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235,   // FT-5OT2
    222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118,   // FT-5OT3
    111, 104,  99,  93,  88,  83,  78,  74,  70,  66,  62,  59,   // FT-5OT4

   1762,1664,1570,1482,1398,1320,1246,1176,1110,1048, 988, 934,   // FT-4OT0
    881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467,   // FT-4OT1
    441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233,   // FT-4OT2
    220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117,   // FT-4OT3
    110, 104,  98,  92,  87,  82,  78,  73,  69,  65,  61,  58,   // FT-4OT4

   1750,1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926,   // FT-3OT0
    875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463,   // FT-3OT1
    437, 413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232,   // FT-3OT2
    219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116,   // FT-3OT3
    109, 103,  97,  92,  87,  82,  77,  73,  69,  65,  61,  58,   // FT-3OT4

   1736,1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920,   // FT-2OT0
    868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460,   // FT-2OT1
    434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230,   // FT-2OT2
    217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115,   // FT-2OT3
    108, 102,  96,  91,  86,  81,  77,  72,  68,  64,  61,  57,   // FT-2OT4

   1724,1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914,   // FT-1OT0
    862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457,   // FT-1OT1
    431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228,   // FT-1OT2
    216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114,   // FT-1OT3
    108, 101,  96,  90,  85,  80,  76,  72,  68,  64,  60,  57    // FT-1OT4
};

//Ŀ
//                                                                           
// The Gravis BPM table is precalculated to use a minimum amount of CPU time 
// There are 255-32+1=224 different values divided in two sections:          
//                                                                           
// Section #1: BPM rates 32-124        (320us Timer #2)                      
//                                                                           
//             Table uses formula: 256-(125*(0.02/0.00032)/BPM)              
//             Equals to 256-(7812.5/BPM)                                    
//                                                                           
// Section #2: BPM rates from 125-255  (80us Timer #1)                       
//                                                                           
//             Table uses formula: 256-(125*(0.02/0.00008)/BPM)              
//             Equals to 256-(31250/BPM)                                     
//                                                                           
//

ubyte scUsBPMTable[224] = {
    12,  19,  26,  33,  39,  45,  50,  56,  61,  65,  // TIMER2
    70,  74,  78,  82,  86,  90,  93,  97, 100, 103,  // TIMER2
   106, 109, 111, 114, 116, 119, 121, 124, 126, 128,  // TIMER2
   130, 132, 134, 136, 138, 139, 141, 143, 144, 146,  // TIMER2
   147, 149, 150, 152, 153, 155, 156, 157, 158, 160,  // TIMER2
   161, 162, 163, 164, 165, 166, 167, 168, 169, 170,  // TIMER2
   171, 172, 173, 174, 175, 175, 176, 177, 178, 179,  // TIMER2
   179, 180, 181, 182, 182, 183, 184, 184, 185, 186,  // TIMER2
   186, 187, 187, 188, 189, 189, 190, 190, 191, 191,  // TIMER2
   192, 192, 193,                                     // TIMER2

     6,   8,  10,  12,  14,  16,  17,  19,  21,  23,  // TIMER1
    25,  26,  28,  30,  31,  33,  34,  36,  37,  39,  // TIMER1
    40,  42,  43,  45,  46,  48,  49,  50,  52,  53,  // TIMER1
    54,  56,  57,  58,  59,  61,  62,  63,  64,  65,  // TIMER1
    67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  // TIMER1
    77,  78,  79,  80,  81,  82,  83,  84,  85,  86,  // TIMER1
    87,  88,  89,  90,  91,  92,  92,  93,  94,  95,  // TIMER1
    96,  97,  97,  98,  99, 100, 101, 101, 102, 103,  // TIMER1
   104, 104, 105, 106, 106, 107, 108, 109, 109, 110,  // TIMER1
   111, 111, 112, 113, 113, 114, 115, 115, 116, 116,  // TIMER1
   117, 118, 118, 119, 120, 120, 121, 121, 122, 122,  // TIMER1
   123, 124, 124, 125, 125, 126, 126, 127, 127, 128,  // TIMER1
   128, 129, 129, 130, 130, 131, 131, 132, 132, 133,  // TIMER1
   133                                                // TIMER1
};

//Ŀ
//                                                                           
// Vibrato sinewave table                                                    
//                                                                           
//

ubyte scVibratoTable[32] = {
     0,  24,  49,  74,  97, 120, 141, 161, 180, 197, 212, 224, 235, 244,
   250, 253, 255, 253, 250, 244, 235, 224, 212, 197, 180, 161, 141, 120,
    97,  74,  49,  24
};


