
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <socom\gravis.h>
#include <socom\mod.h>
#include <socom\dsm.h>
#include <socom\wav.h>

extern int mpSongPos, mpSongLen, mpPatPos;

void  error( int errnum );

void  main( int argc, char** argv )
{
   AudioDevice*   audio = new Gravis;
   Module*        aMod;
   int            looping = 1;
   int            length;
   int   value;
   int   volume, oldvolume;
   int   oldpos;

   length = strlen( argv[1] );

   if ( strcmpi( &argv[1][length-3], "mod" ) == 0 )
   {
      aMod = new MOD( argv[1] );
   }
   else if ( strcmpi( &argv[1][length-3], "dsm" ) == 0 )
   {
      aMod = new DSM( argv[1] );
   }
   else
   {
      aMod = 0;
   }

   if ( aMod != 0 )
   {
      if (( value = aMod->LoadModule()) == SOC_OK )
      {
         if ( audio->LoadModule( aMod, 0 ) == SOC_OK )
         {
            printf( "Use +/- to control master volume\n\n" );

            audio->Play( aMod );

            volume = aMod->GetMasterVolume();
            oldvolume = 0xff;
            oldpos    = 0xff;


            while ( looping )
            {
               char  c;

               if ( oldvolume != volume || oldpos != mpSongPos )
               {
                  cprintf( "MVOL: %03d SP: %03d/%03d\r", volume, mpSongPos, mpSongLen );

                  oldvolume = volume;
                  oldpos = mpPatPos;
               }

               if ( kbhit() )
               {
                  switch ( c = getch() )
                  {
                     case  0x1B:
                        looping = 0;
                        break;
                     case  0x2B:
                        volume++;
                        break;
                     case  0x2D:
                        volume--;
                        break;
                     case  0x4B:
                        if ( mpSongPos != 0 )
                        {
                           mpSongPos--;
                           mpPatPos = 0;
                        }
                        break;
                     case  0x4D:
                        mpSongPos++;
                        mpPatPos = 0;
                        break;
                     default:
                        break;
                  }
               }

               if ( c == 0x2b || c == 0x2d )
               {
                  if ( volume < 0 )
                  {
                     volume = 0;
                  }
                  else if ( volume > 255 )
                  {
                     volume = 255;
                  }

                  aMod->SetMasterVolume( volume );
               }
            }

            audio->Stop( aMod );

            audio->UnloadModule( aMod );
         }
         else
         {
            error( value );
         }
      }
      else
      {
         error( value );
      }
   }

   delete aMod;
   delete audio;
}

//
//
// Process an error message
//
//

void  error( int errnum )
{
   char* text;

   switch ( errnum )
   {
      case  SOC_NO_MEMORY:
         text = "Not enough system memory";
         break;
      case  SOC_NO_CARD:
         text = "No sound card found";
         break;
      case  SOC_NO_FREE_VOICES:
         text = "No free voices for digital playback";
         break;
      case  SOC_NO_DRAM:
         text = "Not enough on-board memory for DRAM base cards";
         break;
      case  SOC_CORRUPT_DRAM:
         text = "On-board memory is corrupt";
         break;
      case  SOC_TOO_MANY_VOICES:
         text = "Too many voices for audio device";
         break;
      case  SOC_NO_ENVVAR:
         text = "No sound card environment variable";
         break;
      case  SOC_NO_FILE:
         text = "File not found";
         break;
      case  SOC_SEEK_FAULT:
         text = "Error during file seek";
         break;
      case  SOC_READ_FAULT:
         text = "Error reading file";
         break;
      case  SOC_UNKNOWN_MOD:
         text = "Unknown module format";
         break;
      case  SOC_NO_WAV:
         text = "Not a WAV file";
         break;
      case  SOC_NO_MONO_WAV:
         text = "Not a mono WAV file";
         break;
      default:
         text = "Unknown error";
         break;
   }

   printf( "%s\n", text );
}

