
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// WAV - Implementation                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <string.h>
#include <socom\wav.h>

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

WAV::WAV( char* fileName )
{
   myStatus = ReadFile( fileName );
}

//Ŀ
//                                                                           
// Copy constructor                                                          
//                                                                           
//

WAV::WAV( const WAV& aWav ) : Sample( aWav )
{

}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

WAV::~WAV( void )
{

}

//Ŀ
//                                                                           
// Assignment operator                                                       
//                                                                           
//

WAV& WAV::operator =( const WAV& aWav )
{
   Sample::operator =( aWav );

   return *this;
}

//Ŀ
//                                                                           
// Read file into memory                                                     
//                                                                           
//

int   WAV::ReadFile( char* fileName )
{
   FILE*    fp;
   ulong    rLen;
   ulong    fLen;
   ulong    nSamplesPerSec;
   ulong    nAvgBytesPerSec;
   uword    wFormatTag;
   uword    nChannels;
   uword    nBlockAlign;
   uword    nFormatSpecific;
   char     rID[4];
   char     wID[4];
   char     fID[4];
   char     dID[4];
   int      retValue;
   uword    s;

   if (( fp = fopen( fileName, "rb" )) != 0 )   // open sample file
   {
      fread( (void*)rID, 4, 1, fp );                   // read sample information
      fread( (void*)&rLen, 4, 1, fp );
      fread( (void*)wID, 4, 1, fp );
      fread( (void*)fID, 4, 1, fp );
      fread( (void*)&fLen, 4, 1, fp );
      fread( (void*)&wFormatTag, 2, 1, fp );
      fread( (void*)&nChannels, 2, 1, fp );
      fread( (void*)&nSamplesPerSec, 4, 1, fp );
      fread( (void*)&nAvgBytesPerSec, 4, 1, fp );
      fread( (void*)&nBlockAlign, 2, 1, fp );
      fread( (void*)&nFormatSpecific, 2, 1, fp );

      // check format of WAV file
      if ( !memcmp( (void*)rID, (void*)"RIFF", 4 ) && !memcmp( (void*)wID, (void*)"WAVE", 4 ) && !memcmp( (void*)fID, (void*)"fmt", 3 ))
      {
         fseek( fp, fLen - 16, SEEK_CUR );      // seek to data ID
         fread( (void*)dID, 4, 1, fp );                // read data ID

         if ( memcmp( (void*)dID, "data", 4 ) == 0 )   // is it a data chunk ?
         {
            if ( nChannels == 1 )               // make sure it's mono
            {
               myVolume = 64;                   // set to maximum volume for now

               fread( &myLength, 4, 1, fp );    // read sample length

               mySampleMode = 0;
               myPeriod     = 3546895 / nSamplesPerSec;  // calculate period

               if ( nBlockAlign == 2 )          // is it a 16bit sample ?
               {
                  mySampleMode |= SOC_16BIT;    // if so, turn on bit
               }

               // allocate memory for sample buffer in memory
               if (( myAddress = new ubyte [myLength] ) != 0 )
               {
                  if ( mySampleMode & SOC_16BIT )
                  {
                     uword* address = (uword*)myAddress;

                     for ( int i = 0; i < myLength / 2; i++ )
                     {
                        fread( (void*)&s, 2, 1, fp );  // read one sample at a time
                                                // and put it into the buffer
                        address[i] = s;
                     }
                  }
                  else
                  {
                     fread( myAddress, myLength, 1, fp );   // read all samples

                     for ( int i = 0; i < myLength; i++ )
                     {
                        myAddress[i] ^= 0x80;               // 2's complement
                     }
                  }

                  retValue = SOC_OK;
               }
               else
               {
                  retValue = SOC_NO_MEMORY;
               }
            }
            else
            {
               retValue = SOC_NO_MONO_WAV;
            }
         }
         else
         {
            retValue = SOC_NO_WAV;
         }
      }
      else
      {
         retValue = SOC_NO_WAV;
      }
   }
   else
   {
      retValue = SOC_NO_FILE;
   }

   return retValue;
}

