#include "cs.h" 			/*			CSCOREFNS.C	*/
#include "cscore.h"

#define TYP_FREE   0
#define TYP_EVENT  1
#define TYP_EVLIST 2
#define TYP_SPACE  3
#define WFLOATS    4       /* extra floats for warped events */
#define NSLOTS     100     /* default slots in lcreat list   */
#define MAXALLOC   32768L

typedef struct space {
        CSHDR  h;
	struct space *nxtspace;
} SPACE;

static SPACE  spaceanchor = { { NULL, NULL, TYP_SPACE, 0 }, NULL };
static CSHDR  *nxtfree = NULL;   /* fast pointer to yet unused free space */
static EVENT  *evtmp = NULL;     /* intermed. event blk with PMAX pfields */
static EVTBLK *evtmpblk;         /* cs.h EVTBLK subset of EVENT evtmp     */
extern FILE   *scfp;
extern int    warped;

static SPACE *morespace()       /* alloc large amount of memory, keep in a chain */
{                               /* put SPACE blk at top & init rem as a FREE blk */
        register SPACE *space, *prvspace;
	register CSHDR *free;

	prvspace = &spaceanchor;
	while ((space = prvspace->nxtspace) != NULL)
	    prvspace = space;
	space = (SPACE *) mmalloc((long) MAXALLOC);
	prvspace->nxtspace = space;
	space->nxtspace = NULL;
	space->h.prvblk = NULL;
	space->h.nxtblk = (CSHDR *) ((char *) space + sizeof(SPACE));
	space->h.type = TYP_SPACE;
	space->h.size = sizeof(SPACE);
	free = space->h.nxtblk;
	free->prvblk = (CSHDR *) space;    /* init rem as a TYP_FREE blk */
	free->nxtblk = NULL;
	free->type = TYP_FREE;
	free->size = MAXALLOC - sizeof(SPACE);
	return(space);
}

static CSHDR *getfree(minfreesiz)  /* search space chains for min size free blk */
    register int minfreesiz;       /* else alloc new space blk & reset fast free */
{
        register SPACE *curspace;
	register CSHDR *blkp;

	curspace = &spaceanchor;
	while ((curspace = curspace->nxtspace) != NULL) {
	    blkp = curspace->h.nxtblk;
	    do {
	        if (blkp->type == TYP_FREE && blkp->size >= minfreesiz)
		    return(blkp);
	    } while ((blkp = blkp->nxtblk) != NULL);
	}
	curspace = morespace();              /* else alloc more space, and  */
	nxtfree = curspace->h.nxtblk;        /* reset the fast free pointer */
	return(nxtfree);
}

static void csfree(bp)       /* return a TYP_EVENT or TYP_EVLIST to free space */
     register CSHDR *bp;     /* consolidate with any prev or follow free space */
{
        register CSHDR *prvp, *nxtp;

        if ((prvp = bp->prvblk) != NULL && prvp->type == TYP_FREE) {
	    if ((nxtp = bp->nxtblk) != NULL && nxtp->type == TYP_FREE) {
	        if ((prvp->nxtblk = nxtp->nxtblk) != NULL)
		    nxtp->nxtblk->prvblk = prvp;
		prvp->size += bp->size + nxtp->size;
	    }
	    else {
	        if ((prvp->nxtblk = bp->nxtblk) != NULL)
		    bp->nxtblk->prvblk = prvp;
		prvp->size += bp->size;
	    }
	}
	else {
	    if ((nxtp = bp->nxtblk) != NULL && nxtp->type == TYP_FREE) {
	        if ((bp->nxtblk = nxtp->nxtblk) != NULL)
		    nxtp->nxtblk->prvblk = bp;
		bp->size += nxtp->size;
	    }
	    bp->type = TYP_FREE;
	}
}

EVLIST * lcreat(nslots)             /* creat an array of event pointer slots */
 int nslots;
{
        register CSHDR *newblk, *newfree;
	register EVLIST *a;
	register int   needsiz = sizeof(EVLIST) + nslots * sizeof(EVENT *);
	register int   minfreesiz = needsiz + sizeof(CSHDR);
	
        if (nxtfree != NULL && nxtfree->size >= minfreesiz)
	    newblk = nxtfree;
	else newblk = getfree(minfreesiz);
	newfree = (CSHDR *) ((char *)newblk + needsiz);
	newfree->prvblk = newblk;
	newfree->nxtblk = newblk->nxtblk;
	newfree->type = TYP_FREE;
	newfree->size = newblk->size - needsiz;
	newblk->nxtblk = newfree;
	newblk->type = TYP_EVLIST;
	newblk->size = needsiz;
	if (newblk == nxtfree)	nxtfree = newfree;
	a = (EVLIST *) newblk;
	a->nslots = nslots;
	a->nevents= 0;
	return(a);
}

EVENT * createv(pcnt)                   /* creat a new event space */
 int pcnt;
{
        register CSHDR *newblk, *newfree;
	register EVENT *e;
	register int   needsiz = sizeof(EVENT) + pcnt * sizeof(float);
	register int   minfreesiz = needsiz + sizeof(CSHDR);
	
        if (nxtfree != NULL && nxtfree->size >= minfreesiz)
	    newblk = nxtfree;
	else newblk = getfree(minfreesiz);
	newfree = (CSHDR *) ((char *)newblk + needsiz);
	newfree->prvblk = newblk;
	newfree->nxtblk = newblk->nxtblk;
	newfree->type = TYP_FREE;
	newfree->size = newblk->size - needsiz;
	newblk->nxtblk = newfree;
	newblk->type = TYP_EVENT;
	newblk->size = needsiz;
	if (newblk == nxtfree)	nxtfree = newfree;
	e = (EVENT *) newblk;
	e->pcnt = pcnt;
	return(e);
}

EVENT * copyev(e)                     /* make a new copy of an event */
 EVENT *e;
{
	EVENT *f;
register int  n;
register float *p, *q;

	n = e->pcnt;
	f = createv(n);
	f->op = e->op;
	f->strarg = e->strarg;
	p = &e->p2orig;
	q = &f->p2orig;
	n += WFLOATS;
	while (n--)
	    *q++ = *p++;
	return(f);
}

static void setevtmp()        /* creat max EVENT blk to receive score data */
{                             /*   and equate subset to cs.h EVTBLK struct */
	evtmp = createv(PMAX);
	evtmpblk = (EVTBLK *) &evtmp->strarg;
}

EVENT * defev(s)                    /* define an event from string arg */
 register char *s;
{
register float *p, *q;

	if (evtmp == NULL)  setevtmp();
	while (*s == ' ')
	    s++;
	evtmp->op = *s++;				/* read opcode */
	while (*s == ' ')
	    s++;
        p = &evtmp->p[1];
	q = &evtmp->p[PMAX];
	while (sscanf(s,"%f",p++) > 0) {		/* read pfields */
	    while (*s >= '0' && *s <= '9' || *s == '.' || *s == '-')
		s++;
	    while (*s == ' ')
		s++;
	    if (p > q && *s != '\0')  {		/* too many ? */
		p++;
		printf("PMAX exceeded, string event truncated.\n");
		break;
	    }
	}
	evtmp->pcnt = p - &evtmp->p[1] - 1;   /* set count of params recvd */
	evtmp->p2orig = evtmp->p[2];
	evtmp->p3orig = evtmp->p[3];
	return(copyev(evtmp));                /* copy event to a new space */
}

EVENT * getev()                        /* read an event from the score file */
{
	if (evtmp == NULL)  setevtmp();
	if (!(rdscor(evtmpblk)))
	    return(NULL);
	else return(copyev(evtmp));
}

void putev(e)                                    /* put an event to stdout */
 register EVENT *e;
{
        register int  pcnt;
	register float *q;

	printf("%c",e->op);
	q = &e->p[1];
	if ((pcnt = e->pcnt)) {
	    if (pcnt--)                 printf(" %g",*q++);
	    else goto termin;
	    if (warped && e->op != 'w')	printf(" %g", e->p2orig);
	    if (pcnt--)         	printf(" %g",*q++);
	    else goto termin;
	    if (warped && e->op != 'w')	printf(" %g", e->p3orig);
	    while (pcnt--)
	        printf(" %g",*q++);
	}
termin:	printf("\n");
}

static EVLIST * lexpand(a)     /* expand an event list by NSLOTS more slots */
 EVLIST *a;                    /* copy the previous list, free up the old   */
{
        EVLIST *b;
register EVENT **p, **q;
register int n;

	b = lcreat(a->nslots + NSLOTS);
	b->nevents = n = a->nevents;
	p = &a->e[1];
	q = &b->e[1];
	while (n--)
	    *q++ = *p++;
	csfree((CSHDR *) a);
	return(b);
}

EVLIST * lappev(a,e)                     /* append an event to a list */
 EVLIST *a;
 EVENT *e;
{
register int  n;

	if ((n = a->nevents) == a->nslots)
	    a = lexpand(a);
	a->e[n+1] = e;
	a->nevents++;
	return(a);
}

EVLIST * lget()              /* get section events from the scorefile */
{
register EVLIST *a;
register EVENT *e, **p;
	int nevents = 0;

	a = lcreat(NSLOTS);
	p = &a->e[1];
	while ((e = getev()) != NULL) {
	    if (e->op == 's' || e->op == 'e')
		break;
	    if (nevents == a->nslots) {
	        a->nevents = nevents;
	        a = lexpand(a);
		p = &a->e[nevents+1];
	    }
	    *p++ = e;
	    nevents++;
	}
	a->nevents = nevents;
	return(a);
}

void lput(a) 			/* put listed events to stdout */
 EVLIST *a;
{
        EVENT **p;
	int  n;

	n = a->nevents;
	p = &a->e[1];
	while (n--)
	    putev(*p++);
}

EVLIST * lcopy(a)
 EVLIST *a;
{
	EVLIST *b;
register EVENT **p, **q;
register int  n = a->nevents;

	b = lcreat(n);
	b->nevents = n;
	p = &a->e[1];
	q = &b->e[1];
	while (n--)
	    *q++ = *p++;
	return(b);
}

EVLIST * lcopyev(a)
 EVLIST *a;
{
	EVLIST *b;
	EVENT **p, **q;
	int  n = a->nevents;

	b = lcreat(n);
	b->nevents = n;
	p = &a->e[1];
	q = &b->e[1];
	while (n--)
	    *q++ = copyev(*p++);
	return(b);
}

EVLIST * lcat(a,b)
 EVLIST *a, *b;
{
register EVENT **p, **q;
register int i, j;

	i = a->nevents;
	j = b->nevents;
	if (i + j >= a->nslots) {
	    EVLIST *c;
	    register int n = i;
	    c = lcreat(i+j);
	    p = &a->e[1];
	    q = &c->e[1];
	    while (n--)
		*q++ = *p++;
	    csfree((CSHDR *) a);
	    a = c;
	}
	a->nevents = i+j;
	p = &a->e[i+1];
	q = &b->e[1];
	while (j--)
	    *p++ = *q++;
	return(a);
}

void lsort(a)		/* put evlist pointers into chronological order */
 EVLIST *a;
{
	EVENT **p, **q;
register EVENT *e, *f;
	int  n, gap, i, j;

	n = a->nevents;
	e = a->e[n];
	if (e->op == 's' || e->op == 'e')
	    --n;
	for (gap = n/2;  gap > 0;  gap /=2)
	    for (i = gap;  i < n;  i++)
		for (j = i-gap;  j >= 0;  j -= gap) {
		    p = &a->e[j+1];     e = *p;
		    q = &a->e[j+1+gap]; f = *q;
		    if (e->op == 'w')
		        break;
		    if (e->p[2] < f->p[2])
			break;
		    if (e->p[2] == f->p[2]) {
			if (e->op == f->op) {
			    if (e->op == 'f')
				break;
			    if (e->p[1] < f->p[1])
				break;
			    if (e->p[1] == f->p[1])
				if (e->p[3] <= f->p[3])
				    break;
			}
			else if (e->op < f->op)
			    break;
		    }
                    *p = f;  *q = e;         
		}
}

EVLIST * lxins(a,s)                      /* list extract by instr numbers */
 EVLIST *a;
 char *s;
{
	int  x[5], xcnt;
register int xn, *xp, insno, n;
	EVENT **p, **q, *e;
	EVLIST *b, *c;

	xcnt = sscanf(s,"%d%d%d%d%d",&x[0],&x[1],&x[2],&x[3],&x[4]);
	n = a->nevents;
	b = lcreat(n);
	p = &a->e[1];
	q = &b->e[1];
	while ((n--) && (e = *p++) != NULL) {
	    if (e->op != 'i')
		*q++ = e;
	    else {
		insno = e->p[1];
		xn = xcnt;  xp = x;
		while (xn--)
		    if (*xp++ == insno) {
			*q++ = e;
			break;
		    }
	    }    
	}
	c = lcopy(b);
	csfree((CSHDR *) b);
        return(c);
}

EVLIST * lxtimev(a,from,to)                      /* list extract by time */
 EVLIST *a;
 float from, to;
{
register EVENT **p, **q, *e;
	EVLIST *b, *c;
	float maxp3;
	int  n;

	n = a->nevents;
	b = lcreat(n);
	p = &a->e[1];
	q = &b->e[1];
	maxp3 = to - from;
	while ((n--) && (e = *p++) != NULL)
	    switch (e->op) {
	    case 'f':
		    if (e->p[2] < to) {
			*q++ = e = copyev(e);
			if (e->p[2] <= from)
			    e->p[2] = 0;
			else e->p[2] -= from;
		    }
		    break;
	    case 'i':
		    if (e->p[2] < from) {
			if (e->p[2] + e->p[3] > from) {
			    *q++ = e = copyev(e);
			    e->p[3] -= from - e->p[2];
			    e->p[2] = 0;
			    if (e->p[3] > maxp3)
				e->p[3] = maxp3;
			}
		    }
		    else if (e->p[2] < to) {
			*q++ = e = copyev(e);
			if (e->p[2] + e->p[3] > to)
			    e->p[3] = to - e->p[2];
			e->p[2] -= from;
		    }
		    break;
	    default:
		    *q++ = copyev(e);
		    break;
	    }
	c = lcopy(b);
	csfree((CSHDR *) b);
	return(c);
}

static void fp2chk(a,s)        /* look for f statements with non-0 p[2] */
 EVLIST *a;
 char *s;
{
register EVENT *e, **ep = &a->e[1];
register int n = a->nevents, count = 0;

	while (n--)
	    if ((e = *ep++) && e->op == 'f' && e->p[2] != 0.)
	        count++;
	if (count)
	    printf("warning: %s found %d f event%s with non-zero p2\n",
		   s, count, count==1 ? "" : "s");
}

EVLIST * lsepf(a)                        /* separate f events from evlist */
 EVLIST *a;
{
	EVLIST *b, *c;
register EVENT **p, **q, **r;
register int   n;

	n = a->nevents;
	b = lcreat(n);
	p = q = &a->e[1];
	r = &b->e[1];
	while (n--) {
	    if ((*p)->op == 'f')
		*r++ = *p++;
	    else *q++ = *p++;
	}
	a->nevents = q - &a->e[1];
	b->nevents = r - &b->e[1];
	c = lcopy(b);
	csfree((CSHDR *) b);
	fp2chk(c,"lsepf");
	return(c);
}

EVLIST * lseptwf(a)                        /* separate t,w,f events from evlist */
 EVLIST *a;
{
	EVLIST *b, *c;
register EVENT **p, **q, **r;
register int   n, op;

	n = a->nevents;
	b = lcreat(n);
	p = q = &a->e[1];
	r = &b->e[1];
	while (n--) {
	    if ((op = (*p)->op) == 't' || op == 'w' || op == 'f')
		*r++ = *p++;
	    else *q++ = *p++;
	}
	a->nevents = q - &a->e[1];
	b->nevents = r - &b->e[1];
	c = lcopy(b);
	csfree((CSHDR *) b);
	fp2chk(c,"lseptwf");
	return(c);
}

void relev(e)                        /* give back event space */
 EVENT *e;
{
	csfree((CSHDR *) e);
}

void lrel(a) 			/* give back list space */
 EVLIST *a;
{
	csfree((CSHDR *) a);
}

void lrelev(a)			/* give back list and its event spaces */
 EVLIST *a;
{
        EVENT **p = &a->e[1];
	int  n = a->nevents;

	while (n--)
	    csfree((CSHDR *) *p++);
	csfree((CSHDR *) a);
}

#define MAXOPEN 5

static FILE **scfps = NULL;    /* array of open scorefile pointers */
static int  warps[MAXOPEN];    /* warp status of these input files */

static scfpsinit()          /* alloc an array of NULL scfp's */
{
	scfps = (FILE **) mcalloc((long)MAXOPEN * sizeof(FILE *));
}

static clrfp(fp)
 FILE *fp;
{
        register int n;
	if (fp == NULL) {
	    printf("clrfp: NULL file pointer\n");
	    return;
	}
	if (scfps != NULL)
	    for (n = 0; n < MAXOPEN; n++)
	        if (scfps[n] == fp) {
		    scfps[n] = NULL;
		    return;
		}
	printf("clrfp: fp not recorded\n");
}

static void storwarp(fp,warp)  /* store fp and warp in available slots */
 FILE *fp;
 int warp;
{
	register int  n;
	if (scfps == NULL) {
	    scfpsinit();
	    scfps[0] = fp;
	    warps[0] = warp;
	    return;
	}
	for (n = 0; n < MAXOPEN; n++)
	    if (scfps[n] == fp) {
		warps[n] = warp;
		return;
	    }
	for (n = 0; n < MAXOPEN; n++)
	    if (scfps[n] == NULL) {
		scfps[n] = fp;
		warps[n] = warp;
		return;
	    }
	printf("storwarp: too many files open\n");
	exit(0);
}

static int getwarp(fp)
 FILE *fp;
{
        register int n;
	if (scfps != NULL)
	    for (n = 0; n < MAXOPEN; n++)
	        if (scfps[n] == fp)
		    return(warps[n]);
	printf("getwarp: fp warp not recorded\n");
	exit(0);
}

FILE *filopen(name)
 char *name;
{
        FILE *fp;

	if ((fp = fopen(name, "r")) == NULL) {
	    printf("error in opening %s\n", name);
	    exit(0);
	}
	storwarp(fp,0);  /* initially non-warped */
	return(fp);
}

void filclose(fp)
 FILE *fp;
{
        clrfp(fp);
        fclose(fp);
	if (scfp == fp) scfp = NULL;
}

FILE *getcurfp()
{
        if (scfp == NULL) {
	    printf("getcurfp: no fp current\n");
	    exit(0);
	}
        return(scfp);
}

void setcurfp(fp)
 FILE *fp;
{
        if (scfp != NULL)
	    storwarp(scfp,warped);
        warped = getwarp(fp);
        scfp = fp;
}
