#include "cs.h"                                      /*  DUMPF.C  */
#include "dumpf.h"

extern int  openout();
extern char *retfilnam;

void kdmpset(p)
 KDUMP *p;
{
        char *sfname;

        if (*p->ifilcod == sstrcod) {
	    sfname = unquote(p->strarg);              /* open in curdir or pathname */
	    if ((p->fdch.fd = openout(sfname, 1)) <= 0) {
	        sprintf(errmsg,"cannot open %s", retfilnam);
		initerror(errmsg);
		return;
	    }
	    fdrecord(&p->fdch);
	    if ((p->format = *p->iformat) < 1 || p->format > 8)
	        initerror("unknown format request");
	    if (p->format == 2 || p->format == 3)
	        initerror("alaw and ulaw not implemented here");
	    if ((p->timcount = *p->iprd * ekr) <= 0)
	        p->timcount = 1;
	    p->countdown = p->timcount;
	}
	else initerror("need quoted filename");
}

void kdmp2set(p)
 KDUMP2 *p;
{
        char *sfname;

        if (*p->ifilcod == sstrcod) {
	    sfname = unquote(p->strarg);              /* open in curdir or pathname */
	    if ((p->fdch.fd = openout(sfname, 1)) <= 0) {
	        sprintf(errmsg,"cannot open %s", retfilnam);
		initerror(errmsg);
		return;
	    }
	    fdrecord(&p->fdch);
	    if ((p->format = *p->iformat) < 1 || p->format > 8)
	        initerror("unknown format request");
	    if (p->format == 2 || p->format == 3)
	        initerror("alaw and ulaw not implemented here");
	    if ((p->timcount = *p->iprd * ekr) <= 0)
	        p->timcount = 1;
	    p->countdown = p->timcount;
	}
	else initerror("need quoted filename");
}

void kdmp3set(p)
 KDUMP3 *p;
{
        char *sfname;

        if (*p->ifilcod == sstrcod) {
	    sfname = unquote(p->strarg);              /* open in curdir or pathname */
	    if ((p->fdch.fd = openout(sfname, 1)) <= 0) {
	        sprintf(errmsg,"cannot open %s", retfilnam);
		initerror(errmsg);
		return;
	    }
	    fdrecord(&p->fdch);
	    if ((p->format = *p->iformat) < 1 || p->format > 8)
	        initerror("unknown format request");
	    if (p->format == 2 || p->format == 3)
	        initerror("alaw and ulaw not implemented here");
	    if ((p->timcount = *p->iprd * ekr) <= 0)
	        p->timcount = 1;
	    p->countdown = p->timcount;
	}
	else initerror("need quoted filename");
}

void kdmp4set(p)
 KDUMP4 *p;
{
        char *sfname;

        if (*p->ifilcod == sstrcod) {
	    sfname = unquote(p->strarg);              /* open in curdir or pathname */
	    if ((p->fdch.fd = openout(sfname, 1)) <= 0) {
	        sprintf(errmsg,"cannot open %s", retfilnam);
		initerror(errmsg);
		return;
	    }
	    fdrecord(&p->fdch);
	    if ((p->format = *p->iformat) < 1 || p->format > 8)
	        initerror("unknown format request");
	    if (p->format == 2 || p->format == 3)
	        initerror("alaw and ulaw not implemented here");
	    if ((p->timcount = *p->iprd * ekr) <= 0)
	        p->timcount = 1;
	    p->countdown = p->timcount;
	}
	else initerror("need quoted filename");
}

static float kval[4];     /* handle up to four ksig arguments */

static void nkdump(ofd, format, nk)
     int ofd, format, nk;
{
	char  outbuf[80];
	int   len;
	register float *kp = kval;

	switch(format) {               /* place formatted kvals into outbuf */
	case 1: { register char *bp = outbuf;
		  len = nk;
		  while (nk--)
		      *bp++ = *kp++ / 256.0;
		  break;
		}
	case 4: { register short *bp = (short *) outbuf;
		  len = nk * sizeof(short);
		  while (nk--)
		      *bp++ = (short) *kp++;
		  break;
		}
	case 5: { register long *bp = (long *) outbuf;
		  len = nk * sizeof(long);
		  while (nk--)
		      *bp++ = (long) *kp++;
		  break;
		}
	case 6: { register float *bp = (float *) outbuf;
		  len = nk * sizeof(float);
		  while (nk--)
		      *bp++ = *kp++;
		  break;
		}
	case 7: *outbuf = '\0';
	        while (--nk) {
	          sprintf(errmsg,"%ld\t", (long) *kp++);
		  strcat(outbuf, errmsg);
		}
	        sprintf(errmsg,"%ld\n", (long) *kp);
		strcat(outbuf, errmsg);
		len = strlen(outbuf);
	        break;
	case 8: *outbuf = '\0';
	        while (--nk) {
	          sprintf(errmsg,"%4.2f\t", *kp++);
	          strcat(outbuf, errmsg);
		}
	        sprintf(errmsg,"%4.2f\n", *kp);
		strcat(outbuf, errmsg);
		len = strlen(outbuf);
	        break;
	default: die("unknown kdump format");
	}
	write(ofd, outbuf, len);            /* now write the buffer */
}

void kdump(p)
 KDUMP *p;
{
	if (--p->countdown <= 0) {
	    p->countdown = p->timcount;
	    kval[0] = *p->ksig;
	    nkdump(p->fdch.fd, p->format, 1);
	}
}

void kdump2(p)
 KDUMP2 *p;
{
	if (--p->countdown <= 0) {
	    p->countdown = p->timcount;
	    kval[0] = *p->ksig1;
	    kval[1] = *p->ksig2;
	    nkdump(p->fdch.fd, p->format, 2);
	}
}

void kdump3(p)
 KDUMP3 *p;
{
	if (--p->countdown <= 0) {
	    p->countdown = p->timcount;
	    kval[0] = *p->ksig1;
	    kval[1] = *p->ksig2;
	    kval[2] = *p->ksig3;
	    nkdump(p->fdch.fd, p->format, 3);
	}
}

void kdump4(p)
 KDUMP4 *p;
{
	if (--p->countdown <= 0) {
	    p->countdown = p->timcount;
	    kval[0] = *p->ksig1;
	    kval[1] = *p->ksig2;
	    kval[2] = *p->ksig3;
	    kval[3] = *p->ksig4;
	    nkdump(p->fdch.fd, p->format, 4);
	}
}


