#include "cs.h"                                       /*    MIDIRECV.C    */
#include "midiops.h"

#ifndef THINK_C
#ifdef SGI
#include <sys/termio.h>
#include <sys/stropts.h>
#include <sys/z8530.h>
static struct termio tty;
static struct strioctl str;
#else
#ifdef __ZTC__
#define u_char unsigned char
#else
#include <sys/ioctl.h>
#define INBAUD    EXTB  /* ioctl baud rate: EXTA = 19200, EXTB = 38400 */
static struct sgttyb tty;
#endif
#endif
#endif

#ifdef sun
#include <sys/fcntl.h>
#undef NL0
#undef NL1
#undef CR0
#undef CR1
#undef CR2
#undef CR3
#undef TAB0
#undef TAB1
#undef TAB2
#undef XTABS
#undef BS0
#undef BS1
#undef FF0
#undef FF1
#undef ECHO
#undef NOFLSH
#undef TOSTOP
#undef FLUSHO
#undef PENDIN
#include <sys/termio.h>
#include <sys/stropts.h>
#endif

#ifdef NeXT
#include <mach.h>
#include <servers/netname.h>
#include <midi/midi_server.h>
#include <midi/midi_reply_handler.h>
#include <midi/midi_timer.h>
#include <midi/midi_timer_reply_handler.h>
#include <midi/midi_error.h>
#include <midi/midi_timer_error.h>
port_t dev_port,owner_port,timer_port,recv_port,
    recv_reply_port,neg_port;
port_set_name_t port_set;
msg_header_t *in_msg ;
int midiCnt ;

kern_return_t getMidiData
( void *		arg,
  midi_raw_t	midi_raw_data,
  u_int		midi_raw_dataCnt
)
;

midi_reply_t midi_reply =
{ getMidiData,0,0,0,0,0 };
#define midiError(msg,no) { if(no != KERN_SUCCESS) { midi_error(msg,no) ; exit(1) ;}}
#define midiTimerError(msg,no) { if(no != KERN_SUCCESS) { midi_timer_error(msg,no) ; exit(1) ;}}
#define machError(msg,no) { if(no != KERN_SUCCESS) { mach_error(msg,no) ; exit(1) ;}}

#endif

#define MBUFSIZ   1024
#define ON        1
#define OFF       0
#define MAXLONG   0x7FFFFFFFL

static u_char *mbuf, *bufp, *bufend, *endatp;
static u_char *sexbuf, *sexp, *sexend;
static u_char *fsexbuf, *fsexp, *fsexend;
static int  rtfd = 0;        /* init these to stdin */
static FILE *mfp = stdin;
MEVENT  *Midevtblk, *FMidevtblk;
MCHNBLK *m_chnbp[16];   /* ptrs to chan ctrl blks */
extern char  *Midiname, *FMidiname;
extern int   FMidiin, ringbell, termifend;
static long  MTrkrem;
static double FltMidiNxtk, kprdspertick, ekrdQmil;
long   FMidiNxtk;
int    Mforcdecs = 0, Mxtroffs = 0, MTrkend = 0;
static void  (*nxtdeltim)(), Fnxtdeltim(), Rnxtdeltim();
#ifdef __STDC__
static void m_chn_init(MEVENT *, int);
#else
static void  m_chn_init();
#endif
extern void  schedofftim(), deact();

static float f128 = 128.;
static float f8192 = 8192.;
static float f12800 = 12800.;
static float f1048576 = 1048576.;
static int   LCtl = ON;
static int   NVoices = 1;
static int   defaultinsno = 0;
extern INSTRTXT *instrtxtp[];
extern long  kcounter;

#ifndef THINK_C

void MidiOpen()       /* open a Midi event stream for reading, alloc bufs */
{                     /*     callable once from main.c                    */
        Midevtblk = (MEVENT *) mcalloc((long)sizeof(MEVENT));
	mbuf = (u_char *) mcalloc((long)MBUFSIZ);
	bufend = mbuf + MBUFSIZ;
	bufp = endatp = mbuf;
	sexbuf = (u_char *) mcalloc((long)MBUFSIZ);
	sexend = sexbuf + MBUFSIZ;
	sexp = NULL;
	m_chn_init(Midevtblk,(short)0);
	if (strcmp(Midiname,"stdin") == 0) {
#ifdef THINK_C
	    dieu("RT Midi_event Console not implemented");
#else
#ifndef __ZTC__
	    if (fcntl(rtfd, F_SETFL, fcntl(rtfd, F_GETFL, 0) | O_NDELAY) < 0)
	        die("-M stdin fcntl failed");
#endif
#endif
	}
	else {                   /* open MIDI device, & set nodelay on reads  */
	    int arg;
#ifdef __ZTC__
#define O_NDELAY (0)
#endif
	    if ((rtfd = open(Midiname, O_RDONLY | O_NDELAY, 0)) < 0)
	        dies("cannot open %s", Midiname);
#ifndef SYS5
	    if (fcntl(rtfd, F_SETFL, fcntl(rtfd, F_GETFL, 0) | O_NDELAY) < 0)
	        dies("fcntl failed on %s", Midiname);
#endif
#ifdef SGI
	    tty.c_iflag = IGNBRK;                  /* for SGI Indigo   */
	    tty.c_oflag = 0;
	    tty.c_cflag = B9600 | CS8 | CREAD | CLOCAL | HUPCL;
	    tty.c_lflag = 0;
	    tty.c_line = 1;
	    tty.c_cc[VINTR] = 0;
	    tty.c_cc[VQUIT] = 0;
	    tty.c_cc[VERASE] = 0;
	    tty.c_cc[VKILL] = 0;
	    tty.c_cc[VMIN] = 1;
	    tty.c_cc[VTIME] = 0;
	    ioctl(rtfd, TCSETAF, &tty);
	    
	    str.ic_cmd = SIOC_RS422;               /*   use RS422     */
	    str.ic_timout = 0;
	    str.ic_len = 4;
	    arg = RS422_ON;
	    str.ic_dp = (char *)&arg;
	    if (ioctl(rtfd, I_STR, &str) < 0) {
	        perror("Can't ioctl RS422");
	        exit(1);
	    }
	    str.ic_cmd = SIOC_EXTCLK;              /*   & external clock  */
	    str.ic_timout = 0;
	    str.ic_len = 4;
	    arg = EXTCLK_32X;
	    str.ic_dp = (char *)&arg;
	    if (ioctl(rtfd, I_STR, &str) < 0) {
	        perror("Can't ioctl EXTCLK");
	        exit(1);
	    }
#else
#ifdef sun
	    while (ioctl(rtfd, I_POP, 0) == 0)  /* pop the 2 STREAMS modules */
	        ;                               /*  betwn user & uart driver */
	    gtty(rtfd, &tty);
	    tty.sg_ispeed = (char)15;
	    tty.sg_ospeed = (char)15;
	    tty.sg_flags &= ~(O_TANDEM | O_ECHO | O_CRMOD | O_ANYP);
	    tty.sg_flags |= RAW;
	    stty(rtfd, &tty);
	    ioctl(rtfd, TCFLSH, 0);
	    fcntl(rtfd, F_SETFL, O_NDELAY);
#else
#ifdef NeXT
        {   kern_return_t r;
	    char *midiPort = "midi1" ; // "midi0" is A
            close(rtfd) ; // easier to close it than hassle with idndefs
            rtfd = 0 ;
	    // look up midi port on localhost
	    r = netname_look_up(name_server_port, "", midiPort, &dev_port);
	    mach_error("timer_track: netname_look_up error", r);
	    // Become owner of the device.
	    r = port_allocate(task_self(), &owner_port);
	    machError("allocate owner port", r);
	    neg_port = PORT_NULL;
	    r = midi_set_owner(dev_port, owner_port, &neg_port);
	    midiError("become owner", r);
	    // Get the timer port for the device.
	    r = midi_get_out_timer_port(dev_port, &timer_port);
	    midiError("output timer port", r);
	    //  Get the receive port for the device.
	    r = midi_get_recv(dev_port, owner_port, &recv_port);
	    midiError("recv port", r);
	    // Find out what time it is (and other vital information).
	    r = port_allocate(task_self(), &recv_reply_port);
	    machError("allocate timer reply port", r);
	    // Tell it to ignore system messages we are not interested in.
	    r = midi_set_sys_ignores(recv_port,
	       (MIDI_IGNORE_ACTIVE_SENS
		    | MIDI_IGNORE_TIMING_CLCK
		    | MIDI_IGNORE_START
		    | MIDI_IGNORE_CONTINUE
		    | MIDI_IGNORE_STOP
		    | MIDI_IGNORE_SONG_POS_P)); 
	    machError("midi_set_sys_ignores", r); 
	    // Set the protocol to indicate our preferences.
	    r = midi_set_proto(recv_port,
		    MIDI_PROTO_RAW,		// raw, cooked, or packed
		    FALSE,			// absolute time codes wanted
		    MIDI_PROTO_SYNC_SYS,	// use system clock
		    10,			// 10 clocks before data sent
		    2,			// 2 clock timeout between input chars
		    8192);			// maximum output queue size
	    machError("midi_set_proto", r);
	    // Get it to send us received data.
	    r = midi_get_data(recv_port, recv_reply_port);	// from now
	    midiTimerError("midi_get_data", r);
	    // Allocate port set.
	    r = port_set_allocate(task_self(), &port_set);
	    machError("allocate port set", r);
	    // Add data receive port to port set.
	    r = port_set_add(task_self(), port_set, recv_reply_port);
	    machError("add recv_reply_port to set", r);
	    // Start the timer up.
	    r = timer_start(timer_port, owner_port);
	    midiError("timer start", r);
            // allocate the message structure
            in_msg = (msg_header_t *)malloc(MSG_SIZE_MAX);
          }
#else
#ifdef __ZTC__
#else
	    ioctl(rtfd, TIOCGETP, &tty);           /* for other machines      */
	    tty.sg_ispeed = INBAUD;                /*   set baud rate         */
	    tty.sg_flags = RAW;                    /*   and no I/O processing */

	    ioctl(rtfd, TIOCSETP, &tty);
#endif
#endif
#endif
#endif
	}
}

#else
void MidiOpen() {}
#endif

static void Fnxtdeltim()     /* incr FMidiNxtk by next delta-time */
{                            /* standard, with var-length deltime */
        register u_long deltim = 0;
	register u_char c;
	register short count = 1;

	if (MTrkrem > 0) {
	    while ((c = getc(mfp)) & 0x80) {
		deltim += c & 0x7F;
		deltim <<= 7;
		count++;
	    }
	    MTrkrem -= count;
	    if ((deltim += c) > 0) {                  /* if deltim nonzero */
	        FltMidiNxtk += deltim * kprdspertick; /*   accum in double */
		FMidiNxtk = (long) FltMidiNxtk;       /*   the kprd equiv  */
/*		printf("FMidiNxtk = %ld\n", FMidiNxtk);  */
	    }
	}
	else {
            printf("end of track in midifile '%s'\n", FMidiname);
	    printf("%d forced decays, %d extra noteoffs\n",
		   Mforcdecs, Mxtroffs);
	    MTrkend = 1;
	    FMidiin = 0;
	    if (ringbell && !termifend)  beep();
	}
}

static void Rnxtdeltim()            /* incr FMidiNxtk by next delta-time */
{             /* Roland MPU401 form: F8 time fillers, no Trkrem val, EOF */
        register u_long deltim = 0;
	register int c;

	do {
	    if ((c = getc(mfp)) == EOF) {
	        printf("end of MPU401 midifile '%s'\n", FMidiname);
		printf("%d forced decays, %d extra noteoffs\n",
		       Mforcdecs, Mxtroffs);
		MTrkend = 1;
		FMidiin = 0;
		if (ringbell && !termifend)  beep();
		return;
	    }
	    deltim += (c &= 0xFF);
	}
	while (c == 0xF8);      /* loop while sys_realtime tming clock */
	if (deltim) {                             /* if deltim nonzero */
	    FltMidiNxtk += deltim * kprdspertick; /*   accum in double */
	    FMidiNxtk = (long) FltMidiNxtk;       /*   the kprd equiv  */
/*	    printf("FMidiNxtk = %ld\n", FMidiNxtk);  */
	}
}

void FMidiOpen()  /* open a MidiFile for reading, sense MPU401 or standard */
{                 /*     callable once from main.c      */
	short sval;
	long lval, tickspersec;
	u_long deltim;
	char inbytes[16];    /* must be long-aligned, 16 >= MThd maxlen */
extern long natlong();
extern short natshort();

	FMidevtblk = (MEVENT *) mcalloc((long)sizeof(MEVENT));
	fsexbuf = (u_char *) mcalloc((long)MBUFSIZ);
	fsexend = fsexbuf + MBUFSIZ;
	fsexp = NULL;
	m_chn_init(FMidevtblk,(short)0);

	if (strcmp(FMidiname,"stdin") == 0) {
#ifdef THINK_C
	    dieu("MidiFile Console input not implemented");
#endif
	}
	else if (!(mfp = fopen(FMidiname, "r")))
	    dies("cannot open '%s'", FMidiname);
	if ((inbytes[0] = getc(mfp)) != 'M')
	    goto mpu401;
	if ((inbytes[1] = getc(mfp)) != 'T') {
	    ungetc(inbytes[1],mfp);
	    goto mpu401;
	}
        if (fread(inbytes+2, 1, 6, mfp) < 6)
	    dies("unexpected end of '%s'", FMidiname);
	if (strncmp(inbytes, "MThd", 4) != 0)
	    dies("we're confused.  file '%s' begins with 'MT',\nbut not a legal header chunk", FMidiname);
	printf("%s: found standard midifile header\n", FMidiname);
	if ((lval = natlong(*(long *)(inbytes+4))) < 6 || lval > 16) {
	    sprintf(errmsg,"bad header length %d in '%s'", lval, FMidiname);
	    die(errmsg);
	}
        if (fread(inbytes, 1, (int)lval, mfp) < lval)
	    dies("unexpected end of '%s'", FMidiname);
	if ((sval = natshort(*(short *)inbytes)) != 0) {
	    sprintf(errmsg,"%s: Midifile format %d not supported",
		    FMidiname, sval);
	    die(errmsg);
	}
	if ((sval = natshort(*(short *)(inbytes+2))) != 1)
	    dies("illegal ntracks in '%s'", FMidiname);
	if ((inbytes[4] & 0x80)) {
	    short SMPTEformat, SMPTEticks;
	    SMPTEformat = -(inbytes[4]);
	    SMPTEticks = *(u_char *)inbytes+5;
	    if (SMPTEformat == 29)  SMPTEformat = 30;  /* for drop frame */
	    printf("SMPTE timing, %d frames/sec, %d ticks/frame\n",
		   SMPTEformat, SMPTEticks);
	    tickspersec = SMPTEformat * SMPTEticks;
	}
	else {
	    short Qticks = natshort(*(short *)(inbytes+4));
	    printf("Metrical timing, Qtempo = 120.0, Qticks = %d\n", Qticks);
	    ekrdQmil = ekr / Qticks / 1000000.;
	    tickspersec = Qticks * 2;
	}
	kprdspertick = ekr / tickspersec;
	printf("kperiods/tick = %7.3f\n", kprdspertick);

chknxt: if (fread(inbytes, 1, 8, mfp) < 8)         /* read a chunk ID & size */
	    dies("unexpected end of '%s'", FMidiname);
	if ((lval = natlong(*(long *)(inbytes+4))) <= 0)
	    dies("improper chunksize in '%s'", FMidiname);
	if (strncmp(inbytes, "MTrk", 4) != 0) {    /* if not an MTrk chunk,  */
	    do sval = getc(mfp);                   /*    skip over it        */
	    while (--lval);
	    goto chknxt;
	}
	printf("tracksize = %ld\n", lval);
	MTrkrem = lval;                            /* else we have a track   */
	FltMidiNxtk = 0.;
	FMidiNxtk = 0;                             /* init the time counters */
	nxtdeltim = Fnxtdeltim;                    /* set approp time-reader */
	nxtdeltim();                               /* incr by 1st delta-time */
	return;

mpu401:	printf("%s: assuming MPU401 midifile format, ticksize = 5 msecs\n", FMidiname);
	kprdspertick = ekr / 200.;
	ekrdQmil = 1.;                             /* temp ctrl (not needed) */
	MTrkrem = MAXLONG;                         /* no tracksize limit     */
	FltMidiNxtk = 0.;
	FMidiNxtk = 0;
	nxtdeltim = Rnxtdeltim;                    /* set approp time-reader */
	if ((deltim = (inbytes[0] & 0xFF))) {      /* if 1st time nonzero    */
	    FltMidiNxtk += deltim * kprdspertick;  /*     accum in double    */
	    FMidiNxtk = (long) FltMidiNxtk;        /*     the kprd equiv     */
/*	    printf("FMidiNxtk = %ld\n", FMidiNxtk);   */
	    if (deltim == 0xF8)     /* if char was sys_realtime timing clock */
	        nxtdeltim();                      /* then also read nxt time */
	}
}

void MidiClose()
{
        if (rtfd) close(rtfd);
        if (mfp) fclose(mfp);
}

static void AllNotesOff(chn)
 MCHNBLK *chn;
{
    register INSDS *ip, **ipp = chn->kinsptr;
    register int nn = 128;

    do {
        if ((ip = *ipp) != NULL) {  /* if find a note in kinsptr slot */
	    deact(ip);              /*    deactivate, clear the slot  */
	    *ipp = NULL;
	}
	ipp++;
    } while (--nn); /* NB this leaves xtratim-scheduled notes still active!! */
}

static void suslstoff(chn)    /* turn of all notes in the channel sustain list  */
 register MCHNBLK *chn;       /* called by SUSTAIN_SW_off only if list non-zero */
{
    register short nn, *lstp, keynum;
    register INSDS *ip;

    if (!(nn = chn->ksuscnt)) return;
    lstp = chn->ksuslst;                      /* find the sustain list     */
    do {                                      /*  & proceed as in musmon.c */
        keynum = *lstp++;
	if ((ip = chn->kinsptr[keynum]) == NULL)   /* count extra NOTE_OFFS */
	    Mxtroffs++;
        else {
	    chn->kinsptr[keynum] = NULL;
	    if (ip->xtratim) {
	        ip->relesing = 1;
		ip->offtim = (kcounter + ip->xtratim) / ekr;
		schedofftim(ip);
	    }
	    else deact(ip);
	}
    } while (--nn);
    chn->ksuscnt = 0;
}

#ifdef __STDC__
static void m_timcod_QF(int a, int b) {}  /* dummy sys_common targets */
static void m_song_pos(long a) {}
static void m_song_sel(long a) {}
#else
static void m_timcod_QF(a, b) {}  /* dummy sys_common targets */
static void m_song_pos(a) long a; {}
static void m_song_sel(a) long a; {}
#endif

static float Volume;   /*temp*/

static void m_chanmsg(mep)  /* execute non-note chnl_voice & chnl_mode commands */
 register MEVENT  *mep;
{
    register MCHNBLK *chn = m_chnbp[mep->chan];
    register short n, nn, tstchan;
    register MCHNBLK *tstchn;

    switch(mep->type) {
    case POLYAFT_TYPE:
            chn->katouch[mep->dat1] = mep->dat2;     /* Polyphon per-Key Press  */
	    break;
    case CONTROL_TYPE:                              /* CONTROL CHANGE MESSAGES: */
	    if ((n = mep->dat1) >= 121)                /* if mode msg, redirect */
	        goto modemsg;          
	    tstchan = (mep->chan + 1) & 0xF;
	    if ((tstchn = m_chnbp[tstchan]) != NULL
	      && tstchn->Omni == 0
	      && tstchn->Poly == 0) {            /* if Global Controller update */
	        chn = tstchn;                    /*   looping from chan + 1     */
		nn = chn->nchnls;
	    }
	    else nn = 1;                         /* else just a single pass     */
	    do {
	        if ((n = mep->dat1) < 32) {              /* MSB --               */
		    chn->ctl_byt[n] = mep->dat2 << 7;    /* save as shifted byte */
		    chn->ctl_val[n] = (float) mep->dat2; /* but record as float  */
		    if (n == 6)      /* Data Entry:   */
		        switch(chn->RegParNo) {
			case 0:	        /* pitch-bend sensitivity  */
			  chn->pbensens = (mep->dat2 * 100 + chn->ctl_byt[38])
			                  / f12800;
			  chn->pbendiff = chn->pchbend * chn->pbensens;
			  break;
			case 1:         /* fine tuning */
			  chn->finetune = (((mep->dat2-64)<<7) + chn->ctl_byt[38])
			                    / f1048576;
			  chn->tuning = chn->crsetune + chn->finetune;		      
			  break;
			case 2:         /* coarse tuning */
			  chn->crsetune = (((mep->dat2-64)<<7) + chn->ctl_byt[38])
			                    / f128;
			  chn->tuning = chn->crsetune + chn->finetune;
			  break;
			default:
			  printf("unrecognized RegParNo %d\n", chn->RegParNo);
			}
		    else if (n == 7)
		        Volume = chn->ctl_val[7];
		}
		else if (n < 64)                    /* LSB -- combine with MSB   */
		    chn->ctl_val[n-32] = (float)(chn->ctl_byt[n-32] + mep->dat2)
		                         / f128;
		else if (n < 70) {
		    chn->ctl_byt[n] = mep->dat2 & 0x40;  /* switches             */
		    chn->ctl_val[n] = (float) mep->dat2; /*  or controllers      */
		    switch(n) {
		        register short temp;
			extern int SusPThresh;
		    case SUSTAIN_SW:
		        temp = (mep->dat2 >= SusPThresh);
			if (chn->sustaining != temp) {   /* if sustainP changed  */
			    if (chn->sustaining && chn->ksuscnt) /*  & going off */
			        suslstoff(chn);          /*      reles any notes */
			    chn->sustaining = temp;
			}
			break;
		    }
		}
		else if (n < 96)
		    chn->ctl_val[n] = (float) mep->dat2; /* controllers */
		else if (n < 101)
		    chn->ctl_byt[n] = mep->dat2;         /* incrs & param nums */
		else if (n == 101)
		    chn->RegParNo = (((short)mep->dat2)<<7) + chn->ctl_byt[100];
		else {
		    printf("undefined controller #%d\n", n);
		    break;
		}
		if (nn > 1 && (chn = m_chnbp[++tstchan]) == NULL) {
		    printf("Global Controller update can't find MCHNBLK %d\n",
			   tstchan);
		    break;
		}
	    } while (--nn);    /* loop if Global update */
	    break;
modemsg:    if (chn->bas_chnl != mep->chan) {       /* CHANNEL MODE MESSAGES:  */
		printf("mode message %d on non-basic channel %d ignored\n",
		       n, mep->chan + 1);
		break;
	    }
	    if (n == 121) {
		register short *sp = chn->ctl_byt;
		register float *fp = chn->ctl_val;
		register short nn = 120;
		do {
		    *sp++ = 0;     /* reset all controllers to 0 */
		    *fp++ = 0.;
		} while (--nn);          /* exceptions:  */
		chn->ctl_byt[8] = 64;    /*      BALANCE */
		chn->ctl_val[8] = 64.;
		chn->ctl_byt[10] = 64;   /*      PAN     */
		chn->ctl_val[10] = 64.;
	    }
	    else if (n == 122)
		LCtl = (mep->dat2) ? ON : OFF;
	    else {
		AllNotesOff(chn);
		switch(n) {
		case 124: chn->Omni = OFF;
		          break;
		case 125: chn->Omni = ON;
		          break;
		case 126: chn->Poly = OFF;
		          NVoices = mep->dat2;
		          break;
		case 127: chn->Poly = ON;
		          NVoices = 1;
		          break;
		}
	    }
	    break;
    case PROGRAM_TYPE:
	    n = mep->dat1;                          /* program change: INSTR N  */
	    if (instrtxtp[n+1] != NULL)             /* if corresp instr exists  */
	        chn->pgmno = n+1;                   /*     assign as pgmno      */
	    else chn->pgmno = defaultinsno;         /* else assign the default  */
	    printf("midi channel %d now using instr %d\n",mep->chan+1,chn->pgmno);
	    break;
    case CHNPRES_TYPE:
	    chn->chnpress = mep->dat1;               /* channel (all-key) Press */
	    break;
    case PCHBEND_TYPE:
	    chn->pchbend = (float)(((mep->dat2 - 64) << 7) + mep->dat1) / f8192;
	    chn->pbendiff = chn->pchbend * chn->pbensens;
	    break;
    case SYSTEM_TYPE:              /* sys_common 1-3 only:  chan contains which */
	    switch(mep->chan) {
	    case 1: m_timcod_QF((int)((mep->dat1)>>4) & 0x7, (int)mep->dat1 & 0xF);
	            break;
	    case 2: m_song_pos((((long)mep->dat2)<<7) + mep->dat1);
	            break;
	    case 3: m_song_sel(mep->dat1);
	            break;
	    default:sprintf(errmsg,"unrecognized sys_common type %d", mep->chan);
	            die(errmsg);
	    }
	    break;
    default:sprintf(errmsg,"unrecognized message type %d", mep->type);
	    die(errmsg);
    }
}

static void m_chn_init(mep,chan) /* alloc a midi control blk for a midi chnl */
 register MEVENT *mep;           /*  & assign corr instr n+1, else a default */
 register short chan;
{
        register MCHNBLK *chn;

	if (!defaultinsno) {
	    register int n;                  /* find lowest instr as default */
	    for (n = 1; n <= MAXINSNO; n++)
		if (instrtxtp[n] != NULL) {
		    defaultinsno = n;
		    goto alcon;
		}
	    die("midi init cannot find any instrs");
	}
alcon:	if ((chn = m_chnbp[chan]) == NULL)
            m_chnbp[chan] = chn = (MCHNBLK *) mcalloc((long)sizeof(MCHNBLK));
	chn->Omni = 1;
	chn->Poly = 1;
        chn->bas_chnl = chan;
        chn->nchnls = 1;
	if (instrtxtp[chan+1] != NULL)           /* if corresp instr exists  */
	    chn->pgmno = chan+1;                 /*     assign as pgmno      */
	else chn->pgmno = defaultinsno;          /* else assign the default  */
	chn->pbensens = 1.0;                     /* pbend sensit 1 semitone  */
	mep->type = CONTROL_TYPE;
	mep->chan = chan;
	mep->dat1 = 121;  /* reset all controllers */
	m_chanmsg(mep);
	printf("midi channel %d using instr %d\n", chan + 1, chn->pgmno);
}

static void m_start() {}      /* dummy sys_realtime targets */
static void m_contin() {}
static void m_stop() {}
static void m_sysReset() {}
static void m_tuneReq() {}

static sexcnt = 0;
static void m_sysex(sbuf,sp)        /* sys_exclusive msg. sexbuf has ID + data */
 u_char *sbuf, *sp;
{
    int nbytes = sp - sbuf;
    if (++sexcnt >= 100) {
        printf("100th system exclusive $%x, length %d\n", *sbuf, nbytes);
	sexcnt = 0;
    }
}

static short datbyts[8] = { 2, 2, 2, 2, 1, 1, 2, 0 };
static short m_clktim = 0;
static short m_sensing = 0;

int sensMidi()             /* sense a MIDI event, collect the data & dispatch */
{                          /*  called from kperf(), return(2) if MIDI on/off  */
        register short  c, type;
	register MEVENT *mep = Midevtblk;
static short datreq, datcnt;
	int n;

nxtchr:	if (bufp >= endatp) {
#ifdef NeXT
            in_msg->msg_size = MSG_SIZE_MAX;
	    in_msg->msg_local_port = port_set;	
	    msg_receive(in_msg, RCV_TIMEOUT, 0);
	    midiCnt = 0 ;
	    if (in_msg->msg_local_port == recv_reply_port)
	        midi_reply_handler(in_msg,&midi_reply);
	    midi_get_data(recv_port, recv_reply_port);
	    if (midiCnt > 0) {
	        n = midiCnt ;
		bufp = mbuf ;
		endatp = mbuf + n ;
	    }
	    else return(0) ;
#else
            if ((n = read(rtfd, (char *)mbuf, MBUFSIZ)) > 0) {
	        bufp = mbuf;
		endatp = mbuf + n;
	    }
	    else return(0);
#endif
	}
	if ((c = *bufp++) & 0x80) {              /* STATUS byte:      */
	    type = c & 0xF0;
	    if (type == SYSTEM_TYPE) { 
	        short lo3 = (c & 0x07);
	        if (c & 0x08)                    /* sys_realtime:     */
		    switch (lo3) {               /*   dispatch now    */
		    case 0: m_clktim++;
			    goto nxtchr;
		    case 2: m_start();
			    goto nxtchr;
		    case 3: m_contin();
			    goto nxtchr;
		    case 4: m_stop();
			    goto nxtchr;
		    case 6: m_sensing = 1;
			    goto nxtchr;
		    case 7: m_sysReset();
			    goto nxtchr;
		    default: printf("undefined sys-realtime msg %x\n",c);
			    goto nxtchr;
		    }
		else {                    /* sys_non-realtime status:   */
		    if (sexp != NULL) {            /* implies           */
		        m_sysex(sexbuf,sexp);      /*   sys_exclus end  */
		        sexp = NULL;
		    }
		    switch (lo3) {                 /* dispatch on lo3:  */
		    case 7: goto nxtchr;           /* EOX: already done */
		    case 0: sexp = sexbuf;         /* sys_ex begin:     */
		            goto nxtchr;           /*   goto copy data  */
		    case 1:                        /* sys_common:       */
		    case 3: datreq = 1;            /*   need some data  */
		            break;
		    case 2: datreq = 2;            /*   (so build evt)  */
		            break;     
		    case 6: m_tuneReq();           /*   this do immed   */
		            goto nxtchr;
		    default: printf("undefined sys_common msg %x\n", c);
		            datreq = 32767; /* waste any data following */
		            datcnt = 0;
		            goto nxtchr;
		    }
		}
		mep->type = type;               /* begin sys_com event  */
		mep->chan = lo3;                /* holding code in chan */
		datcnt = 0;
		goto nxtchr;
	    }
	    else {                              /* other status types:  */
	        short chan;
		if (sexp != NULL) {                /* also implies      */
		    m_sysex(sexbuf,sexp);          /*   sys_exclus end  */
		    sexp = NULL;
		}
		chan = c & 0xF;
		if (m_chnbp[chan] == NULL)         /* chk chnl exists   */
		    m_chn_init(mep, chan);
	        mep->type = type;                  /* & begin new event */
		mep->chan = chan;
		datreq = datbyts[(type>>4) & 0x7];
		datcnt = 0;
		goto nxtchr;
	    }
	}
	if (sexp != NULL) {                   /* NON-STATUS byte:      */
	    if (sexp < sexend)                /* if sys_excl           */
	        *sexp++ = c;                  /*    special data sav   */
	    else printf("system exclusive buffer overflow\n");
	    goto nxtchr;
	}
	if (datcnt == 0)
	    mep->dat1 = c;                    /* else normal data      */
	else mep->dat2 = c;
	if (++datcnt < datreq)                /* if msg incomplete     */
	    goto nxtchr;                      /*   get next char       */
	datcnt = 0;                           /* else allow a repeat   */
	                /* NB:  this allows repeat in syscom 1,2,3 too */
	if (mep->type > NOTEON_TYPE) {        /* if control or syscom  */
	    m_chanmsg(mep);                   /*   handle from here    */
	    goto nxtchr;                      /*   & go look for more  */
	}
	return(2);                            /* else it's note_on/off */
}

static long vlendatum()  /* read variable length datum from the input stream */
{
        register long datum = 0;
	register u_char c;
	while ((c = getc(mfp)) & 0x80) {
	    datum += c & 0x7F;
	    datum <<= 7;
	    MTrkrem--;
	}
	datum += c;
	MTrkrem--;
	return(datum);
}

static void fsexdata(n)    /* place midifile data into a sys_excl buffer */
 register int n;
{
	MTrkrem -= n;
        if (fsexp == NULL)                 /* 1st call, init the ptr */
	    fsexp = fsexbuf;
	if (fsexp + n <= fsexend) {
	    fread(fsexp, 1, n, mfp);       /* addin the new bytes    */
	    fsexp += n;
	    if (*(fsexp-1) == 0xF7) {      /* if EOX at end          */
	        m_sysex(fsexbuf,fsexp);    /*    execute and clear   */
		fsexp = NULL;
	    }
	}
	else {
	    register u_char c;
	    printf("system exclusive buffer overflow\n");
	    do c = getc(mfp);
	    while (--n);
	    if (c == 0xF7)
	        fsexp = NULL;
	}
}

int sensFMidi()         /* read a MidiFile event, collect the data & dispatch */
{                          /*  called from kperf(), return(3) if MIDI on/off  */
        register short  c, type;
	register MEVENT *mep = FMidevtblk;
	long len;
static short datreq;

nxtevt:	if (--MTrkrem < 0 || (c = getc(mfp)) == EOF)
            goto Trkend;
	if (!(c & 0x80))      /* no status, assume running */
	    goto datcpy;
	if ((type = c & 0xF0) == SYSTEM_TYPE) {     /* STATUS byte:      */
	    register short lo3;
	    switch(c) {
	    case 0xF0:                          /* SYS_EX event:  */
		if ((len = vlendatum()) <= 0)
		    die("zero length sys_ex event");
		printf("reading sys_ex event, length %ld\n",len);
		fsexdata(len);
		goto nxtim;
	    case 0xF7:                          /* ESCAPE event:  */
		if ((len = vlendatum()) <= 0)
		    die("zero length escape event");
		printf("escape event, length %ld\n",len);
		if (sexp != NULL)
		    fsexdata(len);       /* if sysex contin, send  */
		else {
		    MTrkrem -= len;
		    do c = getc(mfp);    /* else for now, waste it */
		    while (--len);
		}
		goto nxtim;
	    case 0xFF:                          /* META event:     */
		if (--MTrkrem < 0 || (type = getc(mfp)) == EOF)
		    goto Trkend;
		len = vlendatum();
		MTrkrem -= len;
		switch(type) {
		  register long usecs;
		case 0x51: usecs = 0;           /* set new Tempo       */
		           do {
			       usecs <<= 8;
			       usecs += (c = getc(mfp)) & 0xFF;
			   }
		           while (--len);
		           if (usecs <= 0)
			       printf("%ld usecs illegal in Tempo event\n", usecs);
			   else {
			       kprdspertick = usecs * ekrdQmil;
	/*		       printf("Qtempo = %5.1f\n", 60000000. / usecs); */
			   }
	                   break;
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:                      /* print text events  */
		case 0x06:
		case 0x07: while (len--)
		               putchar(getc(mfp));
		           break;
		case 0x2F: goto Trkend;         /* normal end of track */
		default:   printf("skipping meta event type %x\n",type);
	                   do c = getc(mfp);
	                   while (--len);
		}
		goto nxtim;
	    }
	    lo3 = (c & 0x07);
	    if (c & 0x08) {                  /* sys_realtime:     */
		switch (lo3) {               /*   dispatch now    */
		case 0:
		case 1: break;    /* Timing Clk handled in Rnxtdeltim() */
		case 2: m_start();
		        break;
		case 3: m_contin();
		        break;
		case 4: m_stop();
		        break;
		case 6: m_sensing = 1;
		        break;
		case 7: m_sysReset();
		        break;
		default: printf("undefined sys-realtime msg %x\n",c);
		}
		goto nxtim;
	    }
	    else if (lo3 == 6) {          /* sys_non-realtime status:   */
		m_tuneReq();              /* do this one immed  */
		goto nxtim;
	    }
	    else {
		mep->type = type;         /* ident sys_com event  */
		mep->chan = lo3;          /* holding code in chan */
		switch (lo3) {            /* now need some data   */
		case 1:
		case 3: datreq = 1;
		        break;
		case 2: datreq = 2;
			break;     
		default: sprintf(errmsg,"undefined sys_common msg %x\n", c);
			die(errmsg);
		}
	    }
	}
	else {                              /* other status types:  */
	    short chan = c & 0xF;
	    if (m_chnbp[chan] == NULL)      /*   chk chnl exists    */
	        m_chn_init(mep, chan);
	    mep->type = type;               /*   & begin new event  */
	    mep->chan = chan;
	    datreq = datbyts[(type>>4) & 0x7];
	}
	c = getc(mfp);
	MTrkrem--;

datcpy:	mep->dat1 = c;                        /* sav the required data */
	if (datreq == 2) {
	    mep->dat2 = getc(mfp);
	    MTrkrem--;
	}
	if (mep->type > NOTEON_TYPE) {        /* if control or syscom  */
	    m_chanmsg(mep);                   /*   handle from here    */
	    goto nxtim;
	}
	nxtdeltim();
	return(3);                            /* else it's note_on/off */

nxtim:	nxtdeltim();
	if (FMidiin && kcounter >= FMidiNxtk)
	    goto nxtevt;
	return(0);

Trkend: printf("end of midi track in '%s'\n", FMidiname);
	printf("%d forced decays, %d extra noteoffs\n", Mforcdecs, Mxtroffs);
	MTrkend = 1;
	FMidiin = 0;
	if (ringbell && !termifend)  beep();
	return(0);
}

#ifdef NeXT
kern_return_t getMidiData(void *arg,midi_raw_t midi_raw_data,u_int midi_raw_dataCnt)
{           // copy midi data into mbuf for comsumption by sensMidi().
	    // Also, set variable midiCnt to number of incoming bytes.
	int i;
	for (i = 0; i < midi_raw_dataCnt && i <  MBUFSIZ; i++)
	    mbuf[i] = (midi_raw_data++)->data; 
	midiCnt = i;
}
#endif
