#include "cs.h"                 /*                                 MUSMON.C     */
#include "cscore.h"
#include "midiops.h"
#include "soundio.h"

#define	SEGAMPS	01
#define	SORMSG	02

extern	INSTRTXT *instrtxtp[];
extern	INSDS	actanchor, *frstoff;

int	insno;
char	strmsg[100];

float	maxamp[4], *maxampend, smaxamp[4], omaxamp[4];
long	rngcnt[4], srngcnt[4], orngcnt[4];
short	rngflg = 0, srngflg = 0, multichan = 0;
int	sensType = 0;

extern  int	Beatmode, cmdTempo, Mxtroffs, MTrkend, termifend, ringbell;
extern  int	inbufsamps, outbufsamps;
extern  MEVENT  *Midevtblk, *FMidevtblk;
extern  EVTBLK	*Linevtblk;
static  EVTBLK	*scorevtblk;
static	short	offonly = 0;
static	short	sectno = 0;
static	long	kcnt = 0;
static	float	timtot = 0.;
static  float   betsiz, ekrbetsiz;

static void settempo(tempo)
 float tempo;
{
        if (tempo > 0.) {
	    betsiz = 60. / tempo;
	    ekrbetsiz = ekr * betsiz;
	}
}

void tempset(p)
 TEMPO *p;
{
        float tempo;

        if ((tempo = *p->istartempo) <= 0.)
	    initerror("illegal istartempo value");
        else {
	    settempo(tempo);
	    p->prvtempo = tempo;
	}
}

void tempo(p)
 TEMPO *p;
{
       if (*p->ktempo != p->prvtempo) {
	   settempo(*p->ktempo);
	   p->prvtempo = *p->ktempo;
       }
}

extern  MCHNBLK *m_chnbp[];
extern  int     usingcscore, Linein, Midiin, FMidiin;
extern  void    RTLineset(), MidiOpen(), FMidiOpen();
extern  void    oload(), schedofftim(), infoff(), orcompact(), rlsmemfiles();
extern  void    timexpire(), beatexpire(), deact(), fgens(), beep();
extern	void    sfopenin(), sfopenout(), sfnopenout();
extern	void    iotranset(), sfclosein(), sfcloseout();
extern  long    kcounter;

static  int     playevents();
static  int     segamps, sormsg;
static	EVTBLK	*e = NULL;
static	float	*maxp;
static	long	*rngp;
static  EVENT   **ep, **epend;  /* pointers for stepping through lplay list */
static  EVENT   *lsect = NULL;
static  float   curbt, curp2;

void musmon()
{
	int	n;

	oload();			/* read orcfile, load orch desblks, etc	*/
	if (synterrcnt) {
	    printf("%d syntax errors in orchestra.   performance cancelled\n",
			synterrcnt);
	    exit(1);
	}
	printf("orch now loaded\n");
        multichan = (nchnls > 1) ? 1:0;
	maxampend = &maxamp[nchnls];
	segamps = msglevel & SEGAMPS;
	sormsg = msglevel & SORMSG;

	if (Linein)  RTLineset();               /* if realtime input expected	*/
	if (Midiin)  MidiOpen();                /*   alloc bufs & open files	*/
	if (FMidiin) FMidiOpen();
	if (outbufsamps < 0) { 			/* if k-aligned iobufs requestd */
	    inbufsamps = outbufsamps *= -ksmps; /*   set from absolute value    */
	    printf("k-period aligned audio buffering\n");
	}
	else {          			/* else keep the user values    */
	    if (!inbufsamps)  inbufsamps = IOBUFSAMPS;
	    if (!outbufsamps) outbufsamps = IOBUFSAMPS;     /* or get defaults  */
	}
	printf("audio buffered in %d sample-frame blocks\n", outbufsamps);
	inbufsamps *= nchnls;			/* now adjusted for n channels  */
	outbufsamps *= nchnls;
	if (sfread)     			/* if audio-in requested,	*/
	    sfopenin();         		/*   open/read? infile or device */
	if (sfwrite)    			/* if audio-out requested,	*/
	    sfopenout();        		/*   open the outfile or device	*/
	else sfnopenout();
	iotranset();    		/* point recv & tran to audio formatter	*/

	curp2 = curbt = 0.0;
	if (Beatmode)                          /* if performing from beats	*/
	    settempo((float)cmdTempo);         /*   set the initial tempo  	*/

	if (usingcscore) {
	    if (lsect == NULL) {
	        lsect = (EVENT *) mmalloc((long)sizeof(EVENT));
		lsect->op = 'l';
	    }
	    printf("using Cscore processing\n");
	    cscore();            /* call cscore & re-enter via lplay() below */
	}
	else {
	    if (e == NULL)
	        e = scorevtblk = (EVTBLK *) mmalloc((long)sizeof(EVTBLK));
	    printf("SECTION %d:\n",++sectno);
	    playevents();                      /* play all events in the score */
	}

	printf("end of score.\t\t   overall amps:");
	for (maxp=omaxamp, n=nchnls; n--; )
	    printf("%9.1f", *maxp++);
	if (outformat != AE_FLOAT) {
	    printf("\n\t   overall samples out of range:");
	    for (rngp=orngcnt, n=nchnls; n--; )
		printf("%9ld", *rngp++);
	}
	printf("\n%d errors in performance\n",perferrcnt);
	if (sfread)
	    sfclosein();
	if (sfwrite)
	    sfcloseout();
	else printf("no sound written to disk\n");
	if (ringbell) beep();
}

void lplay(a)               /* cscore re-entry into musmon */
 EVLIST *a;
{
	if (!sectno)  printf("SECTION %d:\n",++sectno);
        ep = &a->e[1];            /* from 1st evlist member */
	epend = ep + a->nevents;  /*   to last              */
	playevents();             /* play list members      */
}

static playevents() {        /* play all events in a score or an lplay list */
	int	n;
	float	prvbt, nxtim, nxtbt, *smaxp;
	long	*srngp;
	char    opcod;

	while (1) {		/* read each score event:	*/
	        if (usingcscore) {           /*   i.e. get next lplay event  */
		    if (ep < epend)
			e = (EVTBLK *) &((*ep++)->strarg);     /* nxt event  */
		    else e = (EVTBLK *) &(lsect->strarg);      /* else lcode */ 
		}
		else if (!(rdscor(e)))       /*   or rd nxt evt from scorfil */
		     e->opcod = 'e';
	retest:	offonly = 0;
		switch(e->opcod) {
		case 'w':
		        if (Beatmode)                 /* Beatmode: read 'w'  */
			    settempo(e->p2orig);      /*   to init the tempo */
			continue;                     /*   for this section  */
		case 'i':
		case 'f':
		case 'a':
			if (frstoff != NULL) {
			    if (Beatmode) {
				if (frstoff->offbet < e->p2orig)
				    goto setoff;
			    }
			    else {
				if (frstoff->offtim < e->p[2])
				    goto setoff;
			    }
			}
			nxtim = e->p[2];
			nxtbt = e->p2orig;
			break;
		case 'l':
			if (frstoff != NULL)
			    goto setoff;
			goto lcode;
		case 's':
		case 'e':
			if (frstoff == NULL)
			    goto scode;
	    setoff:	nxtim = frstoff->offtim;
	      		nxtbt = frstoff->offbet;
			offonly = 1;
			break;
		default:
			printf("error in score.  illegal opcode %c (ASCII %d)\n",
			       e->opcod, e->opcod);
			perferrcnt++;
			continue;
		}
		if (MTrkend && termifend && frstoff == NULL) {
		    printf("terminating. ");
		    return(0);                 /* aborting with perf incomplete */
		}
		if (Beatmode)
		    kcnt = (nxtbt - curbt) * ekrbetsiz + 0.5;
		else kcnt = (nxtim - curp2) * ekr + 0.5;
		if (kcnt > 0) { 		/* perf for kcnt kprds	*/
		    long kdone, kperf();
		    if (!initonly
		     && (kdone = kperf(kcnt)) < kcnt) { /* early rtn:  RTevent  */
			curp2 += kdone / ekr;           /*    update only curp2 */
			if (sensType == 1) {            /*    for Linein,       */
			    e = Linevtblk;              /*      get its evtblk  */
			    e->p[2] = curp2;            /*      & insert curp2  */
			}
			if (!kdone)                     /* if null duration,    */
			    goto mtest;                 /*  chk for midi on-off */
			if (segamps || sormsg && rngflg)
			    printf("  rtevent:\t   T%7.3f TT%7.3f M:",
				   curp2,timtot+curp2);
		    }
		    else {                              /* else a score event:  */
			prvbt = curbt;
			curbt = nxtbt;                  /*    update beats too  */
			curp2 = nxtim;
			if (segamps || sormsg && rngflg)
			    printf("B%7.3f ..%7.3f T%7.3f TT%7.3f M:",
				prvbt,	curbt,	curp2,	timtot+curp2);
		    }
		    if (segamps || sormsg && rngflg) {
			for (n=nchnls, maxp=maxamp; n--;)
			    printf("%9.1f", *maxp++);
			putchar('\n');
			if (rngflg) {
			    printf("\t number of samples out of range:");
			    for (n=nchnls, rngp=rngcnt; n--;)
				printf("%9ld", *rngp++);
			    putchar('\n');
			    rngflg = 0;
			    srngflg++;
			}
		    }
		    for (n=nchnls,maxp=maxamp-1,smaxp=smaxamp-1,
			 rngp=rngcnt,srngp=srngcnt; n--; ) {
		        if (*++maxp > *++smaxp)
			    *smaxp = *maxp;
			*maxp = 0;
			*srngp++ += *rngp;
			*rngp++ = 0;
		    }
		}
		if (sensType == 0) {     /* if this was a score or turnoff time:  */
		    if (frstoff != NULL) {		/* if turnoffs pending,   */
		        if (Beatmode)
			    beatexpire(curbt + hfkprd);	/*  rm any expired instrs */
			else timexpire(curp2 + hfkprd);
		    }
		    if (offonly)
			goto retest;    		/*  if offonly, loop back */
		}
	mtest:	if (sensType >= 2) {                    /* Midievent:             */
		    register MEVENT *mep;
		    register MCHNBLK *chn;

		    if (sensType == 2)                  /* realtime or Midifile  */
		        mep = Midevtblk;
		    else mep = FMidevtblk;
		    chn = m_chnbp[mep->chan];
		    insno = chn->pgmno;
		    if (mep->type == NOTEON_TYPE && mep->dat2) { /* midi note ON: */
		        if (n = MIDIinsert(insno,chn,mep)) {  /* alloc,init,activ */
			    printf("\t\t   T%7.3f - note deleted. ", curp2);
			    printf("instr %d had %d init errors\n", insno, n);
			    perferrcnt++;
			}
		    }
		    else {                              /* else midi note OFF:    */
		        INSDS *ip = chn->kinsptr[mep->dat1];
			if (ip == NULL)                 /*  check saved insds ptr */
			    Mxtroffs++;
			else {
			    if (chn->sustaining) {      /*  if sustain pedal on   */
			        chn->ksuslst[chn->ksuscnt] = mep->dat1;
				chn->ksuscnt++;         /*    let the note ring   */
			    }
			    else {                      /*  else prepare for off  */
			        chn->kinsptr[mep->dat1] = NULL;
				if (ip->xtratim) {      /*    if offtime delayed  */
				    ip->relesing = 1;   /*      enter reles phase */
				    ip->offtim = (kcounter + ip->xtratim) / ekr;
				    schedofftim(ip);    /*      & put in offqueue */
				}
				else deact(ip);         /*    else off now        */
			    }
			}
		    }
		}
		else switch(e->opcod) {                 /* scorevt or Linevt:     */
		case 'i':
			insno = abs((int)e->p[1]);
			if (insno > MAXINSNO || instrtxtp[insno] == NULL) {
			    if (sensType) printf("\t\t   T%7.3f",curp2);
			    else  printf("\t  B%7.3f",curbt);
			    printf(" - note deleted. instr %d undefined\n",insno);
			    perferrcnt++;
			}
			else if (e->p[1] < 0.)  	/* if p1 neg,        	  */
			    infoff(-e->p[1]);           /*  turnoff any infin cpy */
			else {
			    if (Beatmode && e->p3orig >= 0.)
				e->p[3] = e->p3orig * betsiz;
			    if (n = insert(insno,e)) {  /* else aloc,init,activat */
			        if (sensType) printf("\t\t   T%7.3f",curp2);
				else  printf("\t  B%7.3f",curbt);
				printf(" - note deleted.  i%d had %d init errors\n",
				   insno, n);
				perferrcnt++;
			    }
			}
			break;
		case 'f':
			fgens(e);
			break;
		case 'a':
			curp2 = e->p[2] + e->p[3];
			curbt = e->p2orig + e->p3orig;
			printf("time advanced %5.3f beats by score request\n",
			       e->p3orig);
			break;
		}
		if (sensType) {                    /* RT event now done:          */
		    sensType = 0;
		    e = scorevtblk;                /*    return to score context  */
		    goto retest;                   /*    and resume the kperf     */
		}
		continue;                          /* else get next score event   */

	lcode:	printf("end of lplay event list\t      peak amps:");
		for (n=nchnls, maxp=smaxamp; n--; )
		    printf("%9.1f", *maxp++);
		putchar('\n');
		if (srngflg) {
		    printf("\t number of samples out of range:");
		    for (n=nchnls, srngp=srngcnt; n--; )
			printf("%9ld", *srngp++);
		    putchar('\n');
		    srngflg = 0;
		}
		return(0);

	scode:	if ((opcod = e->opcod) == 's'       /* for s, or e after s   */
		 || (opcod == 'e' && sectno > 1)) {
		    timtot += curp2;
		    prvbt = curbt = curp2 = 0;
		    printf("end of section %d\t sect peak amps:",sectno);
		    for (n=nchnls, maxp=smaxamp; n--; )
			printf("%9.1f", *maxp++);
		    putchar('\n');
		    if (srngflg) {
			printf("\t number of samples out of range:");
			for (n=nchnls, srngp=srngcnt; n--; )
			    printf("%9ld", *srngp++);
			putchar('\n');
			srngflg = 0;
		    }
		}
		for (n=nchnls, smaxp=smaxamp-1, maxp=omaxamp-1, 
				srngp=srngcnt,   rngp=orngcnt; n--; ) {
		    if (*++smaxp > *++maxp)
		        *maxp = *smaxp;		/* keep ovrl maxamps */
		    *smaxp = 0;
		    *rngp++ += *srngp;		/*   and orng counts */
		    *srngp++ = 0;
		}
		if (opcod == 's') {             	/* if s code,        */
		    orcompact();			/*   rtn inactiv spc */
		    if (actanchor.nxtact == NULL)       /*   if no indef ins */
		        rlsmemfiles();                  /*    purge memfiles */
		    curp2 = curbt = 0.0;		/*   reset sec times */
		    printf("SECTION %d:\n", ++sectno);
		}					/*   & back for more */
		else break;
	}
	return(1);  /* done with entire score */
}

