#include "cs.h"			/*				RDSCOR.C	*/

FILE   *scfp = NULL;
int    warped = 0;
static char *sstrbuf = NULL;
static int  sstrlen = 0;

void scfopen(argc,argv)    /* simple open of command-line score input file */
 int argc;                 /* use only if not opened by other main program */
 char **argv;
{
    if (!(--argc)) {
        printf("insufficient arguments\n");
	exit(0);
    }
    if (!(scfp = fopen(*++argv, "r"))) {
        printf("cannot find %s\n", *argv);
	exit(0);
    }
}

static int scanflt(pfld)   /* read a float from scorefile; return 1 if OK, else 0 */
 float *pfld;
{
    register int  c;
    register long val=0, scale=1;

    while ((c = getc(scfp)) == ' ' || c == '\t')     /* skip leading white space */
        ;
    if (c == '"') {                                  /* if find a quoted string  */
        register char *sstrp;
	if ((sstrp = sstrbuf) == NULL)
	    sstrp = sstrbuf = mmalloc((long)SSTRSIZ);
	while ((c = getc(scfp)) != '"')
	    *sstrp++ = c;                            /*   copy the characters    */
	*sstrp++ = '\0';
	*pfld = sstrcod;                             /*   flag with hifloat      */
	sstrlen = sstrp - sstrbuf;                   /*    & overall length      */
        return(1);
    }
    if (!(c>='0' && c<='9' || c=='+' || c=='-' || c=='.'))
        return(0);
    if (c == '-') {scale = -1; c = getc(scfp);}      /* else read standard float */
    if (c == '+' || c == '0')  c = getc(scfp);
    while (c >= '0' && c <= '9') {
        val *= 10;
	val += c - '0';
	c = getc(scfp);
    }
    if (c == '.')
        c = getc(scfp);
    while (c >= '0' && c <= '9') {
        val *= 10;
	val += c - '0';
	scale *= 10;
	c = getc(scfp);
    }
    *pfld = (float) val/scale;         /* write pfield */
    ungetc(c,scfp);                    /* push next whitespace back to scorefile */
    return(1);
}

static void flushline()			/* flush scorefile to next newline */
{
    int c;
                                    
    while ((c = getc(scfp)) != EOF && c != '\n')
	;
}

rdscor(e)			/* read next score-line from scorefile     */
 register EVTBLK *e;            /* warped presumes good format from scsort */
{
    register float *pp, *plim;
    int  c;

    if (scfp == NULL) {    /* if no concurrent scorefile  */
        e->opcod = 'f';    /*     return an 'f 0 3600'    */
	e->p[1] = 0.;
	e->p[2] = 3600.;
	e->p[3] = 3600.;
	e->pcnt = 4;
	return(1);
    }
    while ((c = getc(scfp)) != EOF)   /* else read the real score */
	switch (c) {
	case ' ':
	case '\t':
	case '\n':
	    continue;            /* skip leading white space */
	case ';':
	    flushline();
	    continue;
	case 'w':
	    warped = 1;          /* w statement is itself unwarped */
unwarped:   e->opcod = c;                    /* UNWARPED scorefile:  */
	    pp = &e->p[0];
	    plim = &e->p[PMAX];
	    if ((c = getc(scfp)) != '\n') {  /* look for p1 */
	        if (c != ' ' && c != '\t')
		    ungetc(c,scfp);          /* maybe no leading whitespace */
		if (!(scanflt(++pp)))
		    goto setp;
	    }
	    else goto setp;
	    while ((c = getc(scfp)) != '\n') { /* get other pfields */
		if (!(scanflt(++pp)))
		    break;
		if (pp >= plim) {
		    flushline();
		    ++pp;
		    break;
		}
	    }
	    e->p2orig = e->p[2];                /* now go count them */
	    e->p3orig = e->p[3];
	    goto setp;
	default:                                /* WARPED scorefile:       */
	    if (!warped) goto unwarped;
	    e->opcod = c;				           /* opcod */
	    pp = &e->p[0];
	    plim = &e->p[PMAX];
	    if (getc(scfp) != '\n' && scanflt(++pp))	            /* p1      */
	      if (getc(scfp) != '\n' && scanflt(&e->p2orig))        /* p2 orig */
		if (getc(scfp) != '\n' && scanflt(++pp))            /* p2 warp */
		  if (getc(scfp) != '\n' && scanflt(&e->p3orig))    /* p3 orig */
		    if (getc(scfp) != '\n' && scanflt(++pp))        /* p3 warp */
		      while (getc(scfp) != '\n' && scanflt(++pp))   /* p4....  */
			if (pp >= plim) {
			  flushline();
			  ++pp;
			  break;
			}
setp:	    e->pcnt = pp - &e->p[0];                   /* count the pfields */
	    if (sstrlen) {                /* if string arg present, save it */
	        e->strarg = mmalloc((long) sstrlen);
		strcpy(e->strarg, sstrbuf);
		sstrlen = 0;
	    }
	    return(1);
	}
    return(0);
}
