/*                                                               RTAUDIO.C   */

/*  This module is included when RTAUDIO is defined at compile time.
    It provides an interface between Csound realtime record/play calls
    and the device-driver code that controls the actual hardware.
    Makefile defines must have ONE of:  -DDEC, -DSGI, -Dsun, -DNeXT
 */

#include "cs.h"
#include "soundio.h"

#ifdef DEC
#include "DECplay.h"   /* doesn't include record feature */
#endif

#ifdef SGI
#include <stdio.h>
#include <audio.h>
static  ALconfig iconfig, oconfig;
static  ALport   iport = NULL, oport = NULL;
#endif

#ifdef sun
#include <sun/audioio.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
static  audio_info_t  audinfo;
static  int     audiofd, sampcnt = 0;
#endif

#ifdef HP
void AWopen(), AudioWrite(), AWclose();
#endif

#ifdef NeXT
#include <stdio.h>
#include <sound/sound.h>
#include <sound/sounddriver.h>
#include <mach.h>
int low_water = 48*1024;	// Used by the driver to control the flow of samples
int high_water = 64*1024;	// Used by the driver to control the flow of samples
static port_t dev_port, owner_port, write_port, reply_port ;
#endif

static  int     ishift = 0, oshift = 0;
extern  long    nrecs;
extern  int     outbufsamps, oMaxLag;

static int getshift(dsize)     /* turn sample- or frame-size into shiftsize */
  int dsize;
{
        switch(dsize) {
	case 1:  return(0);
	case 2:  return(1);
	case 4:  return(2);
	case 8:  return(3);
	default: die("rtaudio: illegal dsize");
	}
}

void recopen(nchnls, dsize, esr, scale)        /* open for audio input */
  int nchnls, dsize, scale;
  float esr;
{
	if (oMaxLag <= 0)            /* if DAC sampframes ndef in command line */
	    oMaxLag = IODACSAMPS;    /*    use the default value               */
#ifdef DEC
/*        rec_set(nchnls, dsize, esr, scale);  */
        die("DECaudio record not available");
#endif
#ifdef SGI
	iconfig = ALnewconfig();
	ALsetchannels(iconfig, (long)nchnls);
	ALsetwidth(iconfig, (long)dsize);
/*	ALsetsamplerate(iconfig, (long)esr);    */
	{   long cmdBuf[2];
	    cmdBuf[0] = AL_INPUT_RATE;
	    cmdBuf[1] = (long)esr;
	    ALsetparams(AL_DEFAULT_DEVICE,cmdBuf,2);
	}
	ALsetqueuesize(iconfig, (long)oMaxLag);
	iport = ALopenport("soundi", "r", iconfig);
#endif
#ifdef sun
	die("SUN audio record not available");
#endif
#ifdef HP
	die("HP audio record not available");
#endif
#ifdef NeXT
	die("NeXT audio record not available");
#endif
	ishift = getshift(dsize);
}

void playopen(nchnls, dsize, esr, scale)       /* open for audio output */
  int nchnls, dsize, scale;
  float esr;
{
        int b;
	if (oMaxLag <= 0)            /* if DAC sampframes ndef in command line */
	    oMaxLag = IODACSAMPS;    /*    use the default value               */
#ifdef DEC
        if ((b = outbufsamps / nchnls) >= 8192) {
	    sprintf(errmsg, "-b %d probably too large, suggest <= 2048", b);
	    warning(errmsg);
	}
        if (oMaxLag * esr / 11025 >= 2048) {
	    sprintf(errmsg, "-B %d probably too large, suggest 1024", oMaxLag);
	    warning(errmsg);
	}
        play_set(nchnls, dsize, esr, scale);
	oshift = getshift(nchnls * dsize);
#endif
#ifdef SGI
    {	int PMLqueuesize;
	oconfig = ALnewconfig();
	ALsetchannels(oconfig, (long)nchnls);
	ALsetwidth(oconfig, (long)dsize);
/*	ALsetsamplerate(oconfig, (long)esr);    */
	{   long cmdBuf[2];
	    cmdBuf[0] = AL_OUTPUT_RATE;
	    cmdBuf[1] = (long)esr;
	    ALsetparams(AL_DEFAULT_DEVICE,cmdBuf,2);
	}
	ALsetqueuesize(oconfig, (long)oMaxLag);
	PMLqueuesize = ALgetqueuesize(oconfig);
	printf("\n PMLqueuesize = %d\n", PMLqueuesize);
	oport = ALopenport("soundo", "w", oconfig);
	oshift = getshift(dsize);
    }
#endif
#ifdef sun
	if (oMaxLag < 1024) {
	    sprintf(errmsg, "-B %d probably too small, suggest 1024", oMaxLag);
	    warning(errmsg);
	}
	if ((audiofd = open("/dev/audio", O_WRONLY)) < 0)
	    die("sfinit: cannot open /dev/audio");
	oshift = getshift(nchnls * dsize);
#endif
#ifdef HP
	AWopen(nchnls, (long)esr, oMaxLag);
/*	if ((audiofd = open("/dev/audio", O_WRONLY)) < 0)
	    die("sfinit: cannot open /dev/audio");  */
	oshift = getshift(nchnls * dsize);
#endif
#ifdef NeXT
    {   int protocol, sampleRate;
	if (esr > 33075.0)
	    sampleRate = SNDDRIVER_STREAM_TO_SNDOUT_44 ;
	else sampleRate = SNDDRIVER_STREAM_TO_SNDOUT_22 ;
	if (esr != 44100.0 && esr != 22050) {
	    long isr = esr, actual = isr > 33075 ? 44100 : 22050;
	    sprintf(errmsg,"SRate 44.1K or 22.05K only. This %ld playing at %ld",
		    isr, actual);
	    warning(errmsg);
	}
	if (nchnls != 2)
	    die("NeXT supports nchnls = 2 (stereo) output only");
	SNDAcquire(SND_ACCESS_OUT,0,0,0,NULL_NEGOTIATION_FUN,0,&dev_port,&owner_port); 
	snddriver_stream_setup(dev_port, owner_port, 
			sampleRate,  /* make this a switch */
			4096, 2, low_water, high_water, &protocol, &write_port);
	snddriver_stream_control(write_port, 0, SNDDRIVER_PAUSE_STREAM);
/*	oshift = getshift(dsize);   */  /* what's correct here? oshift currently 0 */
    }                                   /* perhaps driver-writing takes bytes ?    */
#endif
}

int rtrecord(inbuf, nbytes)                    /* get samples from ADC */
  char *inbuf;
  int  nbytes;
{
#ifdef DEC
/*      rec_on(inbuf, (long)nbytes >> ishift);   */  /* not yet supported */
#endif
#ifdef SGI
	ALreadsamps(iport, inbuf, (long)nbytes >> ishift);
#endif
	return(nbytes);
}

void rtplay(outbuf, nbytes)                      /* put samples to DAC  */
  char *outbuf;
  int  nbytes;
     /* N.B. This routine serves as a THROTTLE in Csound Realtime Performance, */
     /* delaying the actual writes and return until the hardware output buffer */
     /* passes a sample-specific THRESHOLD.  If the I/O BLOCKING functionality */
     /* is implemented ACCURATELY by the vendor-supplied audio-library write,  */
     /* that is sufficient.  Otherwise, requires some kind of IOCTL from here. */
     /* This functionality is IMPORTANT when other realtime I/O is occurring,  */
     /* such as when external MIDI data is being collected from a serial port. */
     /* Since Csound polls for MIDI input at the software synthesis K-rate     */
     /* (the resolution of all software-synthesized events), the user can      */
     /* eliminate MIDI jitter by requesting that both be made synchronous with */
     /* the above audio I/O blocks, i.e. by setting -b to some 1 or 2 K-prds.  */
{
        long sampframes = nbytes >> oshift;
#ifdef DEC
        while (get_playbuf_remains() > oMaxLag);  /* once lag is below threshold, */
        play_on(outbuf, sampframes);              /*    send these sample-frames  */
#endif
#ifdef SGI
	ALwritesamps(oport, outbuf, sampframes);
#endif
#ifdef sun
	do {
	    if (ioctl(audiofd, AUDIO_GETINFO, &audinfo) < 0)
	        die("/dev/audio: cannot do AUDIO_GETINFO");
	} while (sampcnt - audinfo.play.samples > oMaxLag);
	sampcnt += sampframes;
	if (write(audiofd, outbuf, nbytes) < nbytes)
	    printf("/dev/audio: couldn't write all bytes requested\n");
#endif
#ifdef HP
	AudioWrite(outbuf, nbytes);
	/*  should synchcronize with buffer writes here by a wait loop */
/*	do {
	    if (ioctl(audiofd, AUDIO_GETINFO, &audinfo) < 0)
	        die("/dev/audio: cannot do AUDIO_GETINFO");
	} while (sampcnt - audinfo.play.samples > oMaxLag);
*/
#endif
#ifdef NeXT
	snddriver_stream_start_writing(write_port,outbuf,
			sampframes,1,0,0,1,1,1,1,1,0, reply_port);	
	if(nrecs == 3)
	    snddriver_stream_control(write_port, 0, SNDDRIVER_RESUME_STREAM);
#endif
	nrecs++;
}

void rtclose()                            /* close the I/O device entirely  */
{                                         /* called only when both complete */
#ifdef DEC
        play_rls();
#endif
#ifdef SGI
	if (iport != NULL)
	    ALcloseport(iport);
	if (oport != NULL) {
	    while (ALgetfilled(oport) > 0)
	        sginap(1);
	    ALcloseport(oport);
	}
#endif
#ifdef HP
	AWclose();
#endif
#ifdef NeXT
	if (dev_port) {
	    SNDRelease(SND_ACCESS_OUT,dev_port, owner_port) ;
	    port_deallocate(task_self(),reply_port);
	} 
#endif
}

