#include "cs.h"                                       /*  SNDINFO.C  */
#include "soundio.h"

sndinfo(argc,argv)
     int argc;
     char **argv;
{
        char	*infilnam;
        int 	infd, openin();
	SOUNDIN *p;         /* space allocated here */
	HEADATA *hdr, *readheader();
extern  char    *retfilnam;

	sssfinit();

	while (--argc) {
	    infilnam = *++argv;
	    if ((infd = openin(infilnam)) < 0) {
	        printf("%s:\n\tcouldn't find\n", retfilnam);
		continue;
	    }
	    p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
	    if ((hdr = readheader(infd, infilnam, p)) != NULL
	      && !hdr->readlong) {
	        long sframes = hdr->audsize / hdr->sampsize / hdr->nchnls;
		if (!hdr->typaiff)
		    printf("%s:\n", retfilnam);
#ifdef WAV
		else if (hdr->typaiff == 2) {
		    printf("\tWAVE soundfile\n");
		  }
#endif
		else {
		    register LOOPDAT *ldp;
		    printf("\tAIFF soundfile");
		    if ((ldp = hdr->loopdata) != NULL
		      && (ldp->loopmode1 || ldp->loopmode2))
		        printf(", looping with modes %d, %d",
			       ldp->loopmode1, ldp->loopmode2);
		    else printf(", no looping");
		    printf("\n");
		}
		printf("\tsrate %ld, %s, %ld bit %s, %4.2f seconds\n",
		     hdr->sr,
		     hdr->nchnls==1 ? "monaural":hdr->nchnls==2 ? "stereo":"quad",
		     hdr->sampsize * 8, getstrformat(hdr->format),
		     (float)sframes / (float)hdr->sr);
		printf("\theadersiz %ld, datasiz %ld (%ld sample frames)\n",
		     hdr->hdrsize, hdr->audsize, sframes);
	    }
	    else printf("%s:\n\tno recognizable soundfile header\n", retfilnam);
	    free((char *)p);
	    close(infd);
	}
	exit(0);
}



