#include "cs.h"			/*	       		SOUNDIN.C	*/
#include "soundio.h"

static	float	fzero = 0.;

extern	int	ksmps;
extern  HEADATA *readheader();
extern  short   ulaw_decode[];
extern  int     bytrevhost(), openin();
extern  char    *retfilnam;

char *getstrformat(format)  /* used here, and in sfheader.c */
 register int format;
{
        switch(format) {
	case AE_CHAR:  return("signed chars");
	case AE_ALAW:  return("alaw bytes");
	case AE_ULAW:  return("ulaw bytes");
	case AE_SHORT: return("shorts");
	case AE_LONG:  return("longs");
	case AE_FLOAT: return("floats");
	default: die("unknown sound format");
	}
}

int getsizformat(format)
 register int format;
{
 static int formatsiz[] = {0, sizeof(char), sizeof(char), sizeof(char),
			    sizeof(short), sizeof(long), sizeof(float)};
        if (format > AE_FLOAT)
	        die("illegal input to getsizformat");
        return(formatsiz[format & 0xF]);
}

void bytrev2(buf, nbytes)      /* reverse bytes in buf of shorts */
 char *buf;
 int  nbytes;
{
	register char *p = buf, c1, c2;
        register int n = nbytes/2;

	do {
	    c1 = *p++;
	    c2 = *p--;
	    *p++ = c2;
	    *p++ = c1;
	} while (--n);
}

void bytrev4(buf, nbytes)     /* reverse bytes in buf of longs */
 char *buf;
 int  nbytes;
{
	register char *p = buf, *q = buf;
	register char c1, c2, c3, c4;
        register int n = nbytes/4;

	do {
	    c1 = *p++;
	    c2 = *p++;
	    c3 = *p++;
	    c4 = *p++;
	    *q++ = c4;
	    *q++ = c3;
	    *q++ = c2;
	    *q++ = c1;
	} while (--n);
}

sreadin(infd,inbuf,nbytes,p)       	/* special handling of sound input	  */
 register int	infd, nbytes;   	/* to accomodate reads thru pipes & net	  */
 register char	*inbuf; 		/* where nbytes rcvd can be < n requested */
 register SOUNDIN *p;                   /* extra arg passed for typaiff testing   */
{
        register int	n, ntot=0;

	do if ((n = read(infd, inbuf+ntot, nbytes-ntot)) < 0)
	        die("soundfile read error");
	while (n > 0 && (ntot += n) < nbytes);
	if (p->typaiff == 1) {                  /* if AIFF input file     */
	    if (p->audrem > 0) {
	        if (ntot > p->audrem)           /*   chk haven't exceeded */
		    ntot = p->audrem;           /*   limit of audio data  */
		p->audrem -= ntot;
	    }
	    else ntot = 0;
	    if (ntot && p->bytrev != NULL)
	        p->bytrev(inbuf, ntot);         /*   bytrev 2 or 4 as reqd */
	}
	return(ntot);
}

int sndgetset(p)		/* core of soundinset                */
 register SOUNDIN *p;		/* called from sndinset, SAsndgetset, & gen01 */
{
        register int	n;
	register HEADATA *hdr;
	long	hdrsize = 0, readlong = 0, framesinbuf, skipframes;
	char	*sfname, soundiname[20];
	int	sinfd;

	if ((n = p->OUTCOUNT) && n != 1 && n != 2 && n != 4) { /* if appl,chkchnls */
	    sprintf(errmsg,"soundin: illegal no of receiving channels");
	    goto errtn;
	}
	if (*p->ifilno == sstrcod)                    /* if char string name given */
	    sfname = unquote(p->strarg);              /*    use that               */
	else {                                        /* else use soundin.filnum   */
	    sprintf(soundiname,"soundin.%ld",(long)*p->ifilno);
	    sfname = soundiname;
	}
	if ((sinfd = openin(sfname)) < 0) {           /* open with full dir paths */
	    if (isfullpath(sfname))
	        sprintf(errmsg,"soundin cannot open %s", sfname);
	    else sprintf(errmsg,"soundin can't find \"%s\" in its search paths",
			 sfname);
	    goto errtn;
	}
	sfname = retfilnam;                            /* & record fullpath filnam */
        if ((p->format = *p->iformat) > 0)           /* convert spec'd format code */
	    p->format |= 0x100;
	p->endfile = 0;
	p->typaiff = 0;                      /* initially non-aiff for readheader */

	if ((hdr=readheader(sinfd,sfname,p)) != NULL 	/* if headerblk returned */
	      && !(readlong = hdr->readlong)) {         /* & hadn't readin audio */
	    if (hdr->typaiff == 1 && hdr->loopdata != NULL /* chk the hdr codes  */
	      && hdr->loopdata->loopmode1 != 0          /* looping aiff:         */
	      && (p->analonly || p->OUTCOUNT))          /*     ok for gen01 only */
	        warning("aiff looping file, once through only");
	    if (p->analonly) {				/* anal: if sr param val */
	        if (p->sr != 0 && p->sr != hdr->sr) {   /*          use it       */
		    sprintf(errmsg,"-s %ld overriding soundfile sr %ld",
			    p->sr, hdr->sr);
		    warning(errmsg);
		    hdr->sr = p->sr;
		}
	    }
	    else if (hdr->sr != esr) {  		/* non-anal:  cmp w. esr */
		sprintf(errmsg,"%s sr = %ld, orch sr = %7.1f",
			sfname, hdr->sr, esr);
		warning(errmsg);
	    }
	    if (p->OUTCOUNT) {                           /* for orch SOUNDIN: */
	        if (hdr->nchnls != p->OUTCOUNT) {        /*        chk nchnls */
		    sprintf(errmsg,"%s nchnls = %d, soundin nchnls = %d",
			    sfname, (int) hdr->nchnls, (int) p->OUTCOUNT);
		    warning(errmsg);
		}
	    }                                            /* else chk sufficient */
	    else if (p->channel != ALLCHNLS && p->channel > hdr->nchnls) {
	        sprintf(errmsg,"req chan %d, file %s has only %ld",
			p->channel, sfname, hdr->nchnls);
		die(errmsg);
	    }
	    if (p->format && hdr->format != p->format) {
	        sprintf(errmsg,"soundin %s superceded by %s header format %s",
			getstrformat((int)p->format), sfname,
			getstrformat((int)hdr->format));
	        warning(errmsg);
	    }
	    switch ((p->format = hdr->format)) {        /*    & copy header data */
	    case AE_CHAR:   break;
	    case AE_ULAW:   break;
	    case AE_SHORT:  break;
	    case AE_LONG:   break;
	    case AE_FLOAT:  break;
	    default: sprintf(errmsg,"%s format %s not yet supported",
			     sfname, getstrformat((int)p->format));
		     goto errcls;
	    }
	    p->sampframsiz = hdr->sampsize * hdr->nchnls;
	    hdrsize = hdr->hdrsize;
	    p->typaiff = hdr->typaiff;          /* copy type from headata       */
	    p->loopdata = hdr->loopdata;
	    p->sr = hdr->sr;
	    p->nchnls = hdr->nchnls;
	}
	else {                                  /* no hdr:  find info elsewhere */
	    if (p->analonly) {
	        if (!p->sr) {              
		    p->sr = SR_DEF;
		    sprintf(errmsg,
			    "no -s and no soundheader, using sr default %ld",p->sr);
		    warning(errmsg);
		}
	    }
	    else {
	        warning("no soundin header, presuming orchestra sr");
		p->sr = (long) esr;
	    }
	    if (!p->OUTCOUNT && p->channel == ALLCHNLS)
	        p->channel = 1;
	    if (!p->format) {                 /* no format:                     */
	        if (p->analonly)              /*     analonly defaults to short */
		    p->format = AE_SHORT;
		else p->format = outformat;   /*     orch defaults to outformat */
	    }
	    sprintf(errmsg,"%s has no soundfile header, reading as %s, %d chnl%s",
		    sfname, getstrformat((int)p->format), (int)p->channel,
		    p->channel == 1 ? "" : "s");
	    warning(errmsg);
	    p->sampframsiz = getsizformat((int)p->format) * p->channel;
	    p->typaiff = 0;                     /*     in_type can't be AIFF    */
	    p->loopdata = NULL;
	    p->nchnls = p->channel;
	}
	printf("audio sr = %ld, ", p->sr);
	if (p->nchnls == 1)
	    printf("monaural\n");
	else {
	    printf("%s, reading ", p->nchnls == 2 ? "stereo" : "quad");
	    if (p->channel == ALLCHNLS)
	        printf("%s channels\n", p->nchnls == 2 ? "both" : "all");
	    else printf("channel %d\n", p->channel);
	}

	if (p->typaiff == 1 && bytrevhost()) {  /* if audio_in needs byte rev   */
	    if (p->format == AE_SHORT)
		p->bytrev = bytrev2;            /*     set on sample size       */
	    else if (p->format == AE_LONG)
		p->bytrev = bytrev4;
	    else p->bytrev = NULL;
	}
	else p->bytrev = NULL;
        if (p->sampframsiz <= 0)                           /* must know framsiz */
	    die("illegal sampframsiz");
	if (hdr->audsize > 0 ) {                           /* given audiosize   */
	    p->audrem = hdr->audsize;
	    p->framesrem = hdr->audsize / p->sampframsiz;  /*   find frames rem */
	}
	else {
	    p->audrem = -1;                                /* else mark unknown */
	    p->framesrem = -1;
	}
        skipframes = *p->iskptim * p->sr;
	framesinbuf = SNDINBUFSIZ / p->sampframsiz;
        if (skipframes < framesinbuf) {              /* if sound within 1st buf */
	    int nreq;
	    if (readlong) {                             /*  fill by direct read */
	        nreq = SNDINBUFSIZ - sizeof(long);
	        *(long *)p->inbuf = hdr->firstlong;
		n = sreadin(sinfd, p->inbuf+sizeof(long), nreq, p);
		p->bufend = p->inbuf + sizeof(long) + n;
	    }
	    else {
	        nreq = SNDINBUFSIZ;
		n = sreadin(sinfd, p->inbuf, nreq, p);
		p->bufend = p->inbuf + n;
	    }
	    p->inbufp = p->inbuf + skipframes * p->sampframsiz;
	}
	else {                 				/* for greater skiptime: */
	    long nbytes = skipframes * p->sampframsiz;
	    if (hdrsize < 0) {
		int nbufs = nbytes/SNDINBUFSIZ;		/* if headersize unknown, */
		int nrem = nbytes - (long)nbufs * SNDINBUFSIZ;
		while (--nbufs)        	                /*  spinrd to req boundry */
		    sreadin(sinfd,p->inbuf,SNDINBUFSIZ,p);
		if (nrem)
		    sreadin(sinfd,p->inbuf,nrem,p);
	    }
	    else if (lseek(sinfd, nbytes+hdrsize, 0) < 0)  /* else seek to bndry */
		    die("soundin seek error");
	    if ((n = sreadin(sinfd,p->inbuf,SNDINBUFSIZ,p)) == 0)/* now rd fulbuf */
		p->endfile = 1;
	    p->inbufp = p->inbuf;
	    p->bufend = p->inbuf + n;
	}
	if (p->inbufp >= p->bufend)   /* needed? */
		p->endfile = 1;
	if (p->framesrem != -1)
	    p->framesrem -= skipframes;              /* sampleframes to EOF   */
	return(sinfd);                              /* return the active fd  */

 errcls: close(sinfd);               /* init error:  close any open file */
 errtn:  return(0);                  /*              return empty handed */
}

int SAsndgetset(infilnam, ap, abeg_time, ainput_dur, asr, channel)
     char    *infilnam;                          /* Stand-Alone sndgetset() */
     SOUNDIN **ap;                               /* used by SoundAnal progs */
     float   *abeg_time, *ainput_dur, *asr;
     int     channel;
{
	SOUNDIN  *p;
	char     quotname[80];
	int      infd;
static  ARGLST   arglst = {0};     /* these for sndgetset */
static	OPTXT    optxt;

	sssfinit();                 /* stand-alone init of SFDIR etc. */
	esr = fzero;                /* set esr 0. with no orchestra   */
	optxt.t.outlist = &arglst;  /* point to dummy OUTCOUNT        */
	*ap = p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
	p->h.optext = &optxt;
	p->ifilno = &sstrcod;
	p->iskptim = abeg_time;
	p->iformat = &fzero;
	sprintf(quotname,"%c%s%c",'"',infilnam,'"');
	p->strarg = quotname;
	p->sr = *asr;
	if (channel < 1 || channel > 4) {          /* SAsnd is chan 1,2,3 or 4 */
	    printf("channel request %d illegal\n", channel);
	    return(0);
	}
	p->channel = channel;
	p->analonly = 1;
	if ((infd = sndgetset(p)) == 0)            /* open sndfil, do skiptime */
	    return(0);

	if (p->framesrem < 0 )
	    warning("undetermined file length, will attempt requested duration");
	else {
	    if (*ainput_dur == fzero) {             /* 0 durtim, use to EOF */
	        p->getframes = p->framesrem;
		*ainput_dur = (float) p->getframes / p->sr;
	    }
	                     /* else chk that input dur is within filetime rem */
	    else if ((p->getframes = p->sr * *ainput_dur) > p->framesrem) {
		    p->getframes = p->framesrem;
		    warning("full requested duration not available");
	    }
	    printf("analyzing %ld sample frames (%3.1f secs)",
		    p->getframes, *ainput_dur);
	    if (*abeg_time != fzero)
	        printf(" from timepoint %3.1f\n", *abeg_time);
	    else printf("\n");
	}
        return(infd);
}

long getsndin(fd, fp, nlocs, p)			/* a simplified soundin */
     int fd;
     register float *fp;
     register long  nlocs;
     SOUNDIN *p;
{
        long  n, nread;
	float *fbeg = fp, *fend = fp + nlocs;

	if (p->nchnls == 1 || p->channel == ALLCHNLS) {  /* MONO or ALLCHNLS */
	  switch (p->format) {
	    case AE_CHAR: {
		register char *inbufp, *bufend;
		inbufp = p->inbufp;
		bufend = p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = p->inbuf;
			bufend = p->inbuf + n;
		    }
		    *fp++ = (float) ( (short)*inbufp++ << 8 );
		}
		p->inbufp = inbufp;
		p->bufend = bufend;   /* must reinit after EOF this file */
	    } break;
	    case AE_ULAW: {
		register unsigned char *inbufp, *bufend;
		inbufp = (unsigned char *) p->inbufp;
		bufend = (unsigned char *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (unsigned char *) p->inbuf;
			bufend = (unsigned char *) (p->inbuf + n);
		    }
		    *fp++ = (float) ulaw_decode[*inbufp++];
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_SHORT: {
		register short	*inbufp, *bufend;
		inbufp = (short *) p->inbufp;
		bufend = (short *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (short *) p->inbuf;
			bufend = (short *) (p->inbuf + n);
		    }
		    *fp++ = (float) *inbufp++;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_LONG: {
		register long  *inbufp, *bufend;
		inbufp = (long *) p->inbufp;
		bufend = (long *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (long *) p->inbuf;
			bufend = (long *) (p->inbuf + n);
		    }
		    *fp++ = (float) *inbufp++;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_FLOAT: {
		register float	*inbufp, *bufend;
		inbufp = (float *) p->inbufp;
		bufend = (float *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (float *) p->inbuf;
			bufend = (float *) (p->inbuf + n);
		    }
		    *fp++ = *inbufp++;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    default: goto getserr;
	  }
	} else {                                /* MULTI-CHANNEL, SELECT ONE */
	  register int chcnt = 0, chreq = p->channel, nchnls = p->nchnls;
	  nlocs *= nchnls;
	  switch (p->format) {
	    case AE_CHAR: {
		register char *inbufp, *bufend;
		inbufp = p->inbufp;
		bufend = p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = p->inbuf;
			bufend = p->inbuf + n;
		    }
		    if (++chcnt == chreq)
		        *fp++ = (float) ( (short)*inbufp << 8 );
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = inbufp;
		p->bufend = bufend;
	    } break;
	    case AE_ULAW: {
		register unsigned char *inbufp, *bufend;
		inbufp = (unsigned char *) p->inbufp;
		bufend = (unsigned char *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (unsigned char *) p->inbuf;
			bufend = (unsigned char *) (p->inbuf + n);
		    }
		    if (++chcnt == chreq)
		        *fp++ = (float) ulaw_decode[*inbufp];
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_SHORT: {
		register short	*inbufp, *bufend;
		inbufp = (short *) p->inbufp;
		bufend = (short *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (short *) p->inbuf;
			bufend = (short *) (p->inbuf + n);
		    }
		    if (++chcnt == chreq)
		        *fp++ = (float) *inbufp;
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_LONG: {
		register long  *inbufp, *bufend;
		inbufp = (long *) p->inbufp;
		bufend = (long *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (long *) p->inbuf;
			bufend = (long *) (p->inbuf + n);
		    }
		    if (++chcnt == chreq)
		        *fp++ = (float) *inbufp;
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    case AE_FLOAT: {
		register float	*inbufp, *bufend;
		inbufp = (float *) p->inbufp;
		bufend = (float *) p->bufend;
		while (nlocs--) {
		    if (inbufp >= bufend) {
			if ((n = sreadin(fd,p->inbuf,SNDINBUFSIZ,p)) == 0)
			    break;
			inbufp = (float *) p->inbuf;
			bufend = (float *) (p->inbuf + n);
		    }
		    if (++chcnt == chreq)
		        *fp++ = *inbufp;
		    inbufp++;
		    if (chcnt == nchnls) chcnt = 0;
		}
		p->inbufp = (char *) inbufp;
		p->bufend = (char *) bufend;
	    } break;
	    default: goto getserr;
	  }
	}
	nread = fp - fbeg;
	while (fp < fend)    /* if incomplete */
	    *fp++ = fzero;   /*  pad with 0's */
	return(nread);

getserr: printf("cannot read sformat %s\n",getstrformat((int)p->format));
	return(-1L);
}

void sndinset(p)            /* init routine for instr soundin   */
 SOUNDIN *p;                /* shares above sndgetset with SAsndgetset, gen01*/
{
        int    sinfd, chancod;

	if (p->fdch.fd != 0)   return;           /* if file already open, rtn  */
	p->channel = ALLCHNLS;                   /* reading all channels       */
	p->analonly = 0;
	if ((sinfd = sndgetset(p)) > 0) {        /* if soundinset successful   */
	        p->fdch.fd = sinfd;		 /*     store & log the fd     */
		fdrecord(&p->fdch);              /*     instr will close later */
	}
	else initerror(errmsg);			 /* else just print the errmsg */
}

void soundin(p)
 register SOUNDIN *p;
{
register short	nsmps;
register float	*r1, *r2, *r3, *r4;
	int	chnsout, n, ntogo;

	r1 = p->r1;
	r2 = p->r2;
	r3 = p->r3;
	r4 = p->r4;
	chnsout = p->OUTCOUNT;
	ntogo = ksmps;
	if (p->endfile)
		goto filend;
	nsmps = (p->bufend - p->inbufp) / p->sampframsiz;
	if (nsmps > ksmps)
		nsmps = ksmps;
	ntogo -= nsmps;
	switch (p->format) {
	    case AE_CHAR: {
		register char *inbufp = p->inbufp;
chars:		switch(chnsout) {
		case 1:	do {	*r1++ = (float) ( (short)*inbufp++ << 8 );
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = (float) ( (short)*inbufp++ << 8 );
				*r2++ = (float) ( (short)*inbufp++ << 8 );
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = (float) ( (short)*inbufp++ << 8 );
				*r2++ = (float) ( (short)*inbufp++ << 8 );
				*r3++ = (float) ( (short)*inbufp++ << 8 );
				*r4++ = (float) ( (short)*inbufp++ << 8 );
			} while (--nsmps);
		}
		if (inbufp >= p->bufend) {
			if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->sampframsiz) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto chars;
			}
		}
		p->inbufp = inbufp;
		break;
	    }
	    case AE_ULAW: {
		register unsigned char *inbufp = (unsigned char *)p->inbufp;
ulaw:		switch(chnsout) {
		case 1:	do {	*r1++ = (float) ulaw_decode[*inbufp++];
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = (float) ulaw_decode[*inbufp++];
				*r2++ = (float) ulaw_decode[*inbufp++];
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = (float) ulaw_decode[*inbufp++];
				*r2++ = (float) ulaw_decode[*inbufp++];
				*r3++ = (float) ulaw_decode[*inbufp++];
				*r4++ = (float) ulaw_decode[*inbufp++];
			} while (--nsmps);
		}
		if (inbufp >= (unsigned char *)p->bufend) {
			if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (unsigned char *)p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->sampframsiz) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto ulaw;
			}
		}
		p->inbufp = (char *)inbufp;
		break;
	    }
	    case AE_SHORT: {
		register short *inbufp = (short *)p->inbufp;
shorts:		switch(chnsout) {
		case 1:	do {	*r1++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
				*r3++ = (float) *inbufp++;
				*r4++ = (float) *inbufp++;
			} while (--nsmps);
		}
		if (inbufp >= (short *)p->bufend) {
			if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (short *) p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->sampframsiz) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto shorts;
			}
		}
		p->inbufp = (char *) inbufp;
		break;
	    }
	    case AE_LONG: {
		register long *inbufp = (long *)p->inbufp;
longs:		switch(chnsout) {
		case 1:	do {	*r1++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = (float) *inbufp++;
				*r2++ = (float) *inbufp++;
				*r3++ = (float) *inbufp++;
				*r4++ = (float) *inbufp++;
			} while (--nsmps);
		}
		if (inbufp >= (long *)p->bufend) {
			if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (long *)p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->sampframsiz) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto longs;
			}
		}
		p->inbufp = (char *)inbufp;
		break;
	    }
	    case AE_FLOAT: {
		register float *inbufp = (float *)p->inbufp;
floats:		switch(chnsout) {
		case 1:	do {	*r1++ = *inbufp++;
			} while (--nsmps);
			break;
		case 2:	do {	*r1++ = *inbufp++;
				*r2++ = *inbufp++;
			} while (--nsmps);
			break;
		case 4:	do {	*r1++ = *inbufp++;
				*r2++ = *inbufp++;
				*r3++ = *inbufp++;
				*r4++ = *inbufp++;
			} while (--nsmps);
		}
		if ((char *)inbufp >= p->bufend) {
			if ((n = sreadin(p->fdch.fd,p->inbuf,SNDINBUFSIZ,p)) == 0) {
				p->endfile = 1;
				if (ntogo) goto filend;
				else return;
			}
			inbufp = (float *) p->inbuf;
			p->bufend = p->inbuf + n;
			if (ntogo > 0) {
				if ((nsmps = n / p->sampframsiz) > ntogo)
					nsmps = ntogo;
				ntogo -= nsmps;
				goto floats;
			}
		}
		p->inbufp = (char *) inbufp;
		break;
	    }
	    default: dies("soundin of %s not implemented",
			  getstrformat((int)p->format));
	}
	return;

filend:	nsmps = ntogo;
	switch(chnsout) {			/* if past end of file, */
	case 1:	do *r1++ = fzero;		/*    move in zeros	*/
		while (--nsmps);
		break;
	case 2:	do {	*r1++ = fzero;
			*r2++ = fzero;
		} while (--nsmps);
		break;
	case 4:	do {	*r1++ = fzero;
			*r2++ = fzero;
			*r3++ = fzero;
			*r4++ = fzero;
		} while (--nsmps);
	}
}
