			/*					SOUNDIO.H	*/

#define	IOBUFSAMPS   1024	/* default sampframes in audio iobuf, -b settable */
#define	IODACSAMPS   1024	/* default samps in hardware buffer,  -B settable */
#define	SNDINBUFSIZ  4096	/* soundin bufsize;   must be > sizeof(SFHEADER), */
                                /*                 but small is kind to net rexec */
#define AE_CHAR   0x101         /* standard audio encoding types */
#define AE_ALAW   0x102
#define AE_ULAW   0x103
#define AE_SHORT  0x104
#define AE_LONG   0x105
#define AE_FLOAT  0x106

typedef struct {             /* struct for passing data to/from sfheader routines */
        long  sr;
	long  nchnls;
	long  sampsize;
	long  format;
	long  hdrsize;
	int   typaiff;		/* 0 -> IRCAM, 1 -> AIFF, 2 -> WAV */
	LOOPDAT *loopdata;
	long  audsize;
	long  readlong;
	long  firstlong;
} HEADATA;

typedef	struct {
	OPDS	h;
	float	*r1, *r2, *r3, *r4, *ifilno, *iskptim, *iformat;
	char    *strarg;
	short	format, channel, nchnls, sampframsiz, typaiff, analonly, endfile;
	long	sr, audrem, framesrem, getframes;    /* bytes, frames, frames */
	LOOPDAT *loopdata;
	void	(*bytrev)();
	FDCH	fdch;
	char	*inbufp, *bufend;
	char	inbuf[SNDINBUFSIZ];
} SOUNDIN;

#ifdef SFSUN41
#include <multimedia/audio_hdr.h>
#include <multimedia/libaudio.h>
#endif

#ifdef SFIRCAM

#define SF_MAXCHAN	4
#define SF_MINCOM       400

#define SF_END          0         /* SFCODE types */
#define SF_MAXAMP       1
#define SF_AUDIOENCOD   2
#define SF_PVDATA       3
#define SF_COMMENT      4
#define SF_CODMAX       4

typedef struct {                  /* this code written by sfheaders.c */
	float	value[SF_MAXCHAN];
} SFMAXAMP;

typedef struct {                  /*     ditto                    */
        short   encoding;
	short   grouping;
} SFAUDIOENCOD;

typedef struct {                  /* this code written by pvanal */
        short   frameSize;
	short   frameIncr;
} SFPVDATA;

typedef struct {                  /* this code not possible yet */
        char    comment[SF_MINCOM];
} SFCOMMENT;

#endif
