        		/*					SPECTRA.H	*/

typedef struct {
	OPDS	h;
	DOWNDAT *dsig;
	float	*signal, *iocts, *isamps, *idisprd;
	int     disprd, countdown;
	WINDAT  dwindow;
	AUXCH	auxch;
} OCTDOWN;

#define MAXFRQS 120

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	DOWNDAT *dsig;
	float	*iprd, *ifrqs, *iq, *ihann, *idbout, *idsines;
	int	nfreqs, hanning, ncoefs, dbout;
	float	curq, *sinp, *cosp, *linbufp;
	int     countdown, timcount, winlen[MAXFRQS];
	WINDAT  dwindow;
	AUXCH	auxch;
} NOCTDFT;

typedef struct {
	OPDS	h;
	SPECDAT *wsig;
	float	*iprd, *iwtflg;
	int     countdown, timcount;
	WINDAT  dwindow;
} SPECDISP;

#define MAXPTL 10

typedef struct {
	OPDS	h;
	float	*koct;
	SPECDAT *wsig;
	float	*inptls, *irolloff, *iodd, *interp, *ifprd, *iwtflg;
	int	pdist[MAXPTL], nptls, rolloff, kinterp, ftimcnt, winpts;
	float	pmult[MAXPTL], kval, kinc, *fundp, *oct0p, octfreqs;
	SPECDAT	wfund;
	SPECDISP fdisplay;
} SPECPTRK;

typedef struct {
	OPDS	h;
	float	*ksum;
	SPECDAT *wsig;
	float   *interp;
	int     kinterp;
	float	kval, kinc;
} SPECSUM;

typedef struct {
	OPDS	h;
	SPECDAT	*waddm;
	SPECDAT *wsig1, *wsig2;
	float   *imul2;
	float	mul2;
} SPECADDM;

typedef struct {
	OPDS	h;
	SPECDAT *wdiff;
	SPECDAT *wsig;
	SPECDAT specsave;
} SPECDIFF;

typedef struct {
	OPDS	h;
	SPECDAT *wscaled;
	SPECDAT *wsig;
	float	*ifscale, *ifthresh;
	int	thresh;
	float	*fscale, *fthresh;
	AUXCH	auxch;
} SPECSCAL;

typedef struct {
	OPDS	h;
	SPECDAT *wacout;
	SPECDAT *wsig;
	SPECDAT accumer;
} SPECHIST;

typedef struct {
	OPDS	h;
	SPECDAT *wfil;
	SPECDAT *wsig;
	float	*ifhtim;
	float   *coefs, *states;
	AUXCH	auxch;
} SPECFILT;
