#include "cs.h"			/*				UGENS3.C	*/
#include "ugens3.h"
#include <math.h>

static float	fzero = 0.;

void foscset(p)
 register FOSC *p;
{
register FUNC	*ftp;

	if ((ftp = ftfind(p->ifn)) != NULL) {
		p->ftp = ftp;
		if (*p->iphs >= 0)
			p->cphs = p->mphs = *p->iphs * fmaxlen;
	}
}

void foscil(p)
 register FOSC	*p;
{
register FUNC	*ftp;
register float	*ar, *ampp, car, fmod, cfreq, mod, ndx, *ftab;
register long	mphs, cphs, minc, cinc, lobits;
register int	nsmps = ksmps;

	ar = p->rslt;
	ftp = p->ftp;
	ftab = ftp->ftable;
	lobits = ftp->lobits;
	mphs = p->mphs;
	cphs = p->cphs;
	car = *p->kcps * *p->kcar;
	mod = *p->kcps * *p->kmod;
	ndx = *p->kndx * mod;
	ampp = p->xamp;
	minc = mod * sicvt; 
	if (p->XINCODE) {
		do {
			mphs &= PMASK;
			fmod = *(ftab + (mphs >>lobits)) * ndx;
			mphs += minc;
			cfreq = car + fmod;
			cinc = cfreq * sicvt;
			cphs &= PMASK;
			*ar++ = *(ftab + (cphs >>lobits)) * *ampp++;
			cphs += cinc;
		}
		while (--nsmps);
	}
	else {
		register float amp;
		amp = *ampp;
		do {
			mphs &= PMASK;
			fmod = *(ftab + (mphs >>lobits)) * ndx;
			mphs += minc;
			cfreq = car + fmod;
			cinc = cfreq * sicvt;
			cphs &= PMASK;
			*ar++ = *(ftab + (cphs >>lobits)) * amp;
			cphs += cinc;
		}
		while (--nsmps);
	}
	p->mphs = mphs;
	p->cphs = cphs;
}

void foscili(p)
 register FOSC	*p;
{
register FUNC	*ftp;
register float	*ar, *ampp, fract, v1, car, fmod, cfreq, mod;
register float	ndx, *ftab;
register long	mphs, cphs, minc, cinc, lobits;
register int	nsmps = ksmps;

	ar = p->rslt;
	ftp = p->ftp;
	lobits = ftp->lobits;
	mphs = p->mphs;
	cphs = p->cphs;
	car = *p->kcps * *p->kcar;
	mod = *p->kcps * *p->kmod;
	ndx = *p->kndx * mod;
	ampp = p->xamp;
	minc = mod * sicvt;
	if (p->XINCODE) {
		do {
			mphs &= PMASK;
			fract = PFRAC(mphs);
			ftab = ftp->ftable + (mphs >>lobits);
			v1 = *ftab++;
			fmod = (v1 + (*ftab - v1) * fract) * ndx;
			mphs += minc;
			cfreq = car + fmod;
			cinc = cfreq * sicvt;
			cphs &= PMASK;
			fract = PFRAC(cphs);
			ftab = ftp->ftable + (cphs >>lobits);
			v1 = *ftab++;
			*ar++ = (v1 + (*ftab - v1) * fract) * *ampp++;
			cphs += cinc;
		}
		while (--nsmps);
	}
	else {
		register float amp;
		amp = *ampp;
		do {
			mphs &= PMASK;
			fract = PFRAC(mphs);
			ftab = ftp->ftable + (mphs >>lobits);
			v1 = *ftab++;
			fmod = (v1 + (*ftab - v1) * fract) * ndx;
			mphs += minc;
			cfreq = car + fmod;
			cinc = cfreq * sicvt;
			cphs &= PMASK;
			fract = PFRAC(cphs);
			ftab = ftp->ftable + (cphs >>lobits);
			v1 = *ftab++;
			*ar++ = (v1 + (*ftab - v1) * fract) * amp;
			cphs += cinc;
		}
		while (--nsmps);
	}
	p->mphs = mphs;
	p->cphs = cphs;
}

void losset(p)
 register LOSC *p;
{
extern   FUNC	*ftnp2find();       /* permit non-power-of-2 ftable (no masks) */
register FUNC	*ftp;

	if ((ftp = ftnp2find(p->ifn)) != NULL) {
		p->ftp = ftp;
		if (*p->ibas != fzero)
		    p->cpscvt = ftp->cvtbas / *p->ibas;
		else if ((p->cpscvt = ftp->cpscvt) == fzero)
		    goto lerr1;
		if ((p->mod1 = *p->imod1) < 0) {
		    if ((p->mod1 = ftp->loopmode1) == 0)
		        warning("locscil: sustain defers to non-looping source");
		    p->beg1 = ftp->begin1;
		    p->end1 = ftp->end1;
		}
		else {
		    p->beg1 = *p->ibeg1;
		    p->end1 = *p->iend1;
		    if (p->mod1 < 0 || p->mod1 > 3
		     || p->beg1 < 0 || p->end1 > ftp->flenfrms
		     || p->beg1 >= p->end1)
		        goto lerr2;
		}
		if ((p->mod2 = *p->imod2) < 0) {
		    p->mod2 = ftp->loopmode2;
		    p->beg2 = ftp->begin2;
		    p->end2 = ftp->end2;
		}
		else {
		    p->beg2 = *p->ibeg2;
		    p->end2 = *p->iend2;
		    if (p->mod2 < 0 || p->mod2 > 3
		     || p->beg2 < 0 || p->end2 > ftp->flenfrms
		     || p->beg2 >= p->end2)
		        goto lerr3;
		}
		if (!p->mod2 && !p->end2)         /* if no release looping */
		    p->end2 = ftp->soundend;      /*   set a reading limit */
		p->beg1 <<= LOBITS;
		p->end1 <<= LOBITS;
		p->beg2 <<= LOBITS;
		p->end2 <<= LOBITS;
		p->lphs = 0;
		p->seg1 = 1;
		if ((p->curmod = p->mod1))
		    p->looping = 1;
		else p->looping = 0;
		if (p->OUTCOUNT == 1) {
		    p->stereo = 0;
		    if (ftp->nchnls != 1)
		        initerror("mono loscil cannot read from stereo ftable");
		}
		else {
		    p->stereo = 1;
		    if (ftp->nchnls != 2)
		        initerror("stereo loscil cannot read from mono ftable");
		}
	}
	return;
 lerr1: initerror("no legal base frequency");
	return;
 lerr2: initerror("illegal sustain loop data");
	return;
 lerr3: initerror("illegal release loop data");
	return;
}

void loscil(p)
 register LOSC *p;
{
         FUNC	*ftp;
register float	*ar1, *ftbl, *ftab, *xamp;
register long	phs, inc, beg, end;
register int	nsmps = ksmps, aamp;
	 float  fract, v1, v2, *ar2;
extern   float  loscal;                /* 1. / LOFACT */

	ftp = p->ftp;
	ftbl = ftp->ftable;
	if ((inc = *p->kcps * p->cpscvt) < 0)
	    inc = -inc;
	xamp = p->xamp;
	aamp = (p->XINCODE) ? 1 : 0;
	if (p->seg1) {                      /* if still segment 1  */
	    beg = p->beg1;
	    end = p->end1;
	    if (p->h.insdshead->relesing)   /*    sense note_off   */
	        p->looping = 0;
	}
	else {
	    beg = p->beg2;
	    end = p->end2;
	}
	phs = p->lphs;
	ar1 = p->ar1;
	if (p->stereo) {
	    ar2 = p->ar2;
	    goto phsck2;
	}
phschk:	if (phs >= end)	goto put0;
 	switch(p->curmod) {
	case 0: do {
	            fract = (phs & LOMASK) * loscal;         /* NO LOOPING  */
	            ftab = ftbl + (phs >> LOBITS);
		    v1 = *ftab++;
		    *ar1++ = (v1 + (*ftab - v1) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end)
		        goto nxtseg;
		} while (--nsmps);
	        break;
	case 1: do {
	            fract = (phs & LOMASK) * loscal;        /* NORMAL LOOPING */
	            ftab = ftbl + (phs >> LOBITS);
		    v1 = *ftab++;
		    *ar1++ = (v1 + (*ftab - v1) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end) {
		        if (!(p->looping)) goto nxtseg;
			 phs -= end - beg;
		    }
		} while (--nsmps);
	        break;
	case 2:
	 case2: do {
	            fract = (phs & LOMASK) * loscal;       /* BIDIR FORW, EVEN */
	            ftab = ftbl + (phs >> LOBITS);
		    v1 = *ftab++;
		    *ar1++ = (v1 + (*ftab - v1) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end) {
		        if (!(p->looping)) goto nxtseg;
			phs -= (phs - end) * 2;
			p->curmod = 3;
			if (--nsmps) goto case3;
			else break;
		    }
		} while (--nsmps);
	        break;
	case 3:
	 case3: do {
	            fract = (phs & LOMASK) * loscal;      /* BIDIR BACK, EVEN */
	            ftab = ftbl + (phs >> LOBITS);
		    v1 = *ftab++;
		    *ar1++ = (v1 + (*ftab - v1) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs -= inc) < beg) {
			phs += (beg - phs) * 2;
			p->curmod = 2;
			if (--nsmps) goto case2;
			else break;
		    }
		} while (--nsmps);
	        break;

	nxtseg: if (p->seg1) {
	            p->seg1 = 0;
		    if ((p->curmod = p->mod2))
		        p->looping = 1;
		    if (--nsmps) {
		        beg = p->beg2;
			end = p->end2;
			p->lphs = phs;
			goto phschk;
		    }
		    break;
	        }
	        if (--nsmps) goto phsout;
	        break;
	}
	p->lphs = phs;
	return;

phsout: p->lphs = phs;
put0:   do *ar1++ = fzero;
	while (--nsmps);
	return;

phsck2:	if (phs >= end)	goto put0s;            /* for STEREO:  */
 	switch(p->curmod) {
	case 0: do {
	            fract = (phs & LOMASK) * loscal;         /* NO LOOPING  */
	            ftab = ftbl + ((phs >> LOBITS) << 1);
		    v1 = *ftab++;
		    v2 = *ftab++;
		    *ar1++ = (v1 + (*ftab++ - v1) * fract) * *xamp;
		    *ar2++ = (v2 + (*ftab   - v2) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end)
		        goto nxtseg2;
		} while (--nsmps);
	        break;
	case 1: do {
	            fract = (phs & LOMASK) * loscal;        /* NORMAL LOOPING */
	            ftab = ftbl + ((phs >> LOBITS) << 1);
		    v1 = *ftab++;
		    v2 = *ftab++;
		    *ar1++ = (v1 + (*ftab++ - v1) * fract) * *xamp;
		    *ar2++ = (v2 + (*ftab   - v2) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end) {
		        if (!(p->looping)) goto nxtseg2;
			 phs -= end - beg;
		    }
		} while (--nsmps);
	        break;
	case 2:
	 case2s: do {
	            fract = (phs & LOMASK) * loscal;       /* BIDIR FORW, EVEN */
	            ftab = ftbl + ((phs >> LOBITS) << 1);
		    v1 = *ftab++;
		    v2 = *ftab++;
		    *ar1++ = (v1 + (*ftab++ - v1) * fract) * *xamp;
		    *ar2++ = (v2 + (*ftab   - v2) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs += inc) >= end) {
		        if (!(p->looping)) goto nxtseg2;
			phs -= (phs - end) * 2;
			p->curmod = 3;
			if (--nsmps) goto case3s;
			else break;
		    }
		} while (--nsmps);
	        break;
	case 3:
	 case3s: do {
	            fract = (phs & LOMASK) * loscal;      /* BIDIR BACK, EVEN */
	            ftab = ftbl + ((phs >> LOBITS) << 1);
		    v1 = *ftab++;
		    v2 = *ftab++;
		    *ar1++ = (v1 + (*ftab++ - v1) * fract) * *xamp;
		    *ar2++ = (v2 + (*ftab   - v2) * fract) * *xamp;
		    if (aamp)  xamp++;
		    if ((phs -= inc) < beg) {
			phs += (beg - phs) * 2;
			p->curmod = 2;
			if (--nsmps) goto case2s;
			else break;
		    }
		} while (--nsmps);
	        break;

	nxtseg2:if (p->seg1) {
	            p->seg1 = 0;
		    if ((p->curmod = p->mod2))
		        p->looping = 1;
		    if (--nsmps) {
		        beg = p->beg2;
			end = p->end2;
			p->lphs = phs;
			goto phsck2;
		    }
		    break;
	        }
	        if (--nsmps) goto phsout2;
	        break;
	}
	p->lphs = phs;
	return;

phsout2:p->lphs = phs;
put0s:  do {
             *ar1++ = fzero;
	     *ar2++ = fzero;
	} while (--nsmps);
}

#define ISINSIZ 32768L
#define ADMASK  32767L
	
static short *isintab = NULL;
static float sinsizdsr;       /* ISINSIZ / esr */
static float mkdkr;           /* 1024000 / ekr */

void adset(p)
 register ADSYN *p;
{
	int	n;
	char	filnam[64];
	MEMFIL	*mfp;
register short	*adp, *endata, val;
register PTLPTR	*ptlap, *ptlfp, *ptlim;

	if (isintab == NULL) {		/* if no sin table yet, make one */
		register short *ip;
		isintab = ip = (short *) mmalloc((long)ISINSIZ * sizeof(short));
		for (n = 0; n < ISINSIZ; n++)
			*ip++ = (short) (sin(twopi * n / ISINSIZ) * 32767.);
		sinsizdsr = ISINSIZ / esr;
		mkdkr = 1024000. / ekr;       /*  & set local consts */
	}
	if (*p->ifilcod == sstrcod)                     /* if stringnam given */
	        strcpy(filnam, unquote(p->strarg));     /*    use that        */
	else sprintf(filnam,"adsyn.%d",(int)*p->ifilcod);/* else adsyn.filnum */
	if ((mfp = p->mfp) == NULL || strcmp(mfp->filename,filnam) != 0) {
	    if ((mfp = ldmemfile(filnam)) == NULL) {    /*   readfile if reqd */
		sprintf(errmsg,"ADSYN cannot load %s",filnam);
		goto adserr;
	    }
	    p->mfp = mfp;                               /*   & record         */
	    adp = (short *) mfp->beginp;
	    endata = (short *) mfp->endp;
	}
/*	adh = (ADHEADER *) mfp;  			/* chk header values */
/*	if (adh->admagic != ADSYN_MAGIC) {
/*		sprintf(errmsg,"%s not an ADSYN file",filnam);
/*		goto adserr;
/*	}
 */
 	adp = (short *) mfp->beginp;    		/* align on file data */
	endata = (short *) mfp->endp;
	ptlap = ptlfp = p->ptlptrs;      		/* find base ptl blk  */
	ptlim = ptlap + MAXPTLS + 1;
	do if ((val = *adp++) < 0) {		/* then for each brkpt set,   */
		switch (val) {
		case -1: ptlap->nxtp = ptlap + 1;       /* chain the ptl blks */
		         if ((ptlap = ptlap->nxtp) >= ptlim) goto adsful;
		         ptlap->ap = (DUPLE *) adp;	/*  record start amp  */
		         ptlap->amp = ptlap->ap->val;
			 break;			
		case -2: if ((ptlfp += 1) >= ptlim) goto adsful;
		         ptlfp->fp = (DUPLE *) adp;	/*  record start frq  */
		         ptlfp->frq = ptlfp->fp->val;
			 ptlfp->phs = 0;		/*  and clr the phase */
			 break;
		default: sprintf(errmsg,"illegal code %d encountered",val);
			 goto adserr;
		}
	} while (adp < endata);
	if (ptlap != ptlfp) {
		sprintf(errmsg,"%d amp tracks, %d freq tracks",
			ptlap - p->ptlptrs - 1, ptlfp - p->ptlptrs - 1);
		goto adserr;
	}
	ptlap->nxtp = NULL;   /* terminate the chain */
	p->mksecs = 0;
 	return;

adsful:	sprintf(errmsg,"partial count exceeds MAXPTLS");
adserr:	initerror(errmsg);
}

void adsyn(p)
 register ADSYN *p;
{
	PTLPTR	*curp, *prvp;
	DUPLE	*ap, *fp;
	short	curtim, diff, ktogo;
register long	phs, sinc, *sp, amp;
register int    nsmps;
register float	*ar;
	float	ampscale, frqscale;
	long    timkincr, nxtim;

	ampscale = *p->kamod * dv32768; 	   /* (since 15-bit sine table) */
	frqscale = *p->kfmod * sinsizdsr;
	timkincr = *p->ksmod * mkdkr;   	   /* 1024 * msecs of analysis  */
	sp = (long *) p->rslt;  		   /* use out array for sums */
	nsmps = ksmps;
        do  *sp++ = 0;  			   /* cleared first to zero */
	while (--nsmps);
 	curtim = p->mksecs >> 10;                  /* cvt mksecs to msecs */
        curp = p->ptlptrs;                         /* now for each partial:    */
        while((prvp = curp) && (curp = curp->nxtp) != NULL ) {
	    ap = curp->ap;
	    fp = curp->fp;
	    while (curtim >= (ap+1)->tim)       /* timealign ap, fp */
		curp->ap = ap += 1;
	    while (curtim >= (fp+1)->tim)
		curp->fp = fp += 1;
	    if ((amp = curp->amp)) {		/* for non-zero amp   */
		sinc = curp->frq * frqscale;
		phs = curp->phs;
		sp = (long *) p->rslt;   
		nsmps = ksmps;			/*   addin a sinusoid */
		do {
		    *sp++ += *(isintab + phs) * amp;
		    phs += sinc;
		    phs &= ADMASK;
		}
		while (--nsmps);	
		curp->phs = phs;
	    }
	    if ((nxtim = (ap+1)->tim) == 32767) {   /* if last amp this partial */
	        prvp->nxtp = curp->nxtp;            /*   remov from activ chain */
		curp = prvp;
	    }
	    else {				   /* else interp towds nxt amp */
	        if ((diff = (ap+1)->val - amp)) {
		    ktogo = ((nxtim<<10) - p->mksecs + timkincr - 1) / timkincr;
		    curp->amp += diff / ktogo;
		}
		if ((nxtim = (fp+1)->tim) != 32767            /*      & nxt frq */
		  && (diff = (fp+1)->val - curp->frq)) {
		    ktogo = ((nxtim<<10) - p->mksecs + timkincr - 1) / timkincr;
		    curp->frq += diff / ktogo;
		}
	    }
	}
	p->mksecs += timkincr;   		/* advance the time */
	ar = p->rslt;
	sp = (long *) ar;
	nsmps = ksmps;
        do  *ar++ = *sp++ * ampscale;		/* float & scale the results */
	while (--nsmps);
}

