#include	"cs.h"                            /*                WAVE.C   */
#include	"soundio.h"
#include	"wav.h"
#include	"sfheader.h"
#include	<math.h>

#define TRUE    (1)
#define FALSE   (0)
#define DEBUG	(0)

#ifdef __ZTC__
#define tell(x) lseek(x,0L,1)
#endif

static long ss;
static struct wav_head formhdr;

void wavWriteHdr(fd,sampsize,nchls,sr)/* Write WAV header at start of file.  */
  int fd;               	     /* Called after open, before data writes*/
  int sampsize;			/* sample size in bytes */
  int nchls;
  double sr;			/* sampling rate */
{
#if DEBUG
	printf("wavWriteHdr: fd %d sampsize %d nchls %d sr %lf\n",
		fd,sampsize,nchls,sr);
#endif

  formhdr.datasize = sampsize * nchls * 1; /* Unknown number */

  formhdr.magic = *((long *)RIFF_ID);
  formhdr.len0 = (formhdr.datasize/sampsize) + WAVHDRSIZ;	
  formhdr.magic1 = *((long *)WAVE_ID);
  formhdr.magic2 = *((long *)FMT_ID);
  formhdr.len = 16;
  formhdr.format = 1;
  formhdr.nchns = nchls;
  formhdr.rate = (long)sr;
  formhdr.aver = (long)sr * nchls * sampsize;
  formhdr.nBlockAlign = nchls * sampsize;
  formhdr.size = 8 * sampsize;
  formhdr.magic3 = *((long *)DATA_ID);

  if (write(fd, &formhdr, sizeof(formhdr)) != sizeof(formhdr))
    die("error writing WAV header");
  ss = sampsize * nchls;

}
             
void wavReWriteHdr(fd)            /* Write proper sizes into WAV header  */
  int fd;                          /*         Called before closing file.  */
{
        long endpos;
	long numsamps;
#if DEBUG
	printf("wavReWriteHdr: fd %d\n", fd);
#endif
	endpos = tell(fd);
	lseek(fd, 0L, 0);
	numsamps = (endpos - WAVHDRSIZ);
	formhdr.datasize = numsamps;
	formhdr.len0 = formhdr.datasize + 8 + 16 + 12;
#if DEBUG
	printf(
	 "wavReWriteHdr: fd %d endpos=%ld numsamps=%ld datasize = %d len0=%ld\n",
	       fd, endpos, numsamps, formhdr.datasize, formhdr.len0);
#endif
	if (write(fd, &formhdr, sizeof(formhdr)) != sizeof(formhdr))
	  die("error rewriting WAV header");
	lseek(fd, endpos, 0);
}

int is_wav_form(firstlong)    /* test a long for wav form ID                 */
  long firstlong;             /* called by readheader prior to wavReadHeader */
{
        return (firstlong == *(long *)RIFF_ID);
}


void wavReadHeader(fd,fname,hdr,firstlong,p) /* Read WAV header, fill hdr, & */
  int fd;             			    /* postn rd ptr to start of samps*/
  char *fname;
  HEADATA *hdr;	/* datablock for passing data back */
  long firstlong;
  SOUNDIN *p;
{
  struct wav_head form;
  if (!is_wav_form(firstlong))    /* double check it's a form header */
    die("bad form for wavReadHeader");         /* & read remainder */
  sreadin(fd,(char *)&form + sizeof(long),sizeof(form) - sizeof(long),p);
  if (form.magic1 != *(long *) WAVE_ID) {
    fprintf(stderr, "Got form.magic = %lx\n", form.magic);
    die("form header not type wav");
  }
  hdr->sr = form.rate;
  hdr->nchnls = form.nchns;
  hdr->sampsize = form.size/8;
  hdr->format = ( form.size == 16 ? AE_SHORT :
		  form.size == 8 ? AE_CHAR :
		  AE_LONG);
  hdr->hdrsize = sizeof(form);
  hdr->typaiff = 2;
  hdr->loopdata = NULL;
  hdr->audsize = form.datasize;
  hdr->readlong = FALSE;
  hdr->firstlong = 0;
}
