/*                      ** FORTE's patch format, v1.10 **                       */
/*                                                                              */
/*    (compiled from various sources, most notably Francois Dion's PATCHKIT)    */

#define byte unsigned char
#define word unsigned short int
#define dword unsigned long int

/*   Patch file structure:
Ŀ
  PatchHeader                  
Ĵ
  instruments *                
  Ŀ
    InstrumentHeader             
  Ĵ
    layers *                     
    Ŀ
      LayerHeader                  
    Ĵ
      samples *                    
      Ŀ
Ĵ      WaveHeader                   
   Ĵ  Ĵ
	  Ĵ  The actual sample data       
		   */

typedef struct {
	char         header[12];  			// asciz, Currently 'GF1PATCH110'#0

	char         gravis_id[10]; 	 	// asciz, Always 'ID#000002'

	char         description[60];  		// asciz, Whatever you want, (Gravis
										// uses it for a copyright notice)

	byte         instruments;	  		// 1, number of instruments in patch
										// Could be > 1 but why such a thing?

	byte         voices;  				// 14, Playback voices, ignored

	byte         channels; 		 		// 0, ignored, Wav channels that can
										// be played beside the patch

	word         waveforms;  			// Total number of waveforms in file

	word         master_volume;	  		// Master Volume, 00..7F

	dword        data_size;  			// Memory patch takes in gusram?

	byte         reserved[36];  		// For future extensions

} TPatchHeader;


typedef struct {

	word		 instrument_id;			// Instrument id: 0..FFFF

	char 		 instrument_name[16];	// Name of instrument
										// Not used in patches of 2.06 disks
										// but you SHOULD use it, This is
										// what's seen when you choose  'Use
										// Names from Patch files' in the Win
										// Patch Manager, and it will become
										// essential once we have bank-switch
										// and not only GM-sounds

	dword		 instrument_size;       // Number of bytes for the instrument
										// incl. header.To skip to next instr

	byte		 layers;			    // 1, Number of layers in instr: 1-4
										// Current drivers only support 1

	byte		 reserved[40];			// For future extensions

} TInstrumentHeader;


typedef struct {

	byte         layer_dup;  	// If not 0 the wavesample to use is from the
								// previous layer. Waveheader is still needed

	byte         layer_id;  	// 0, Layer id: 0..3

	dword        layer_size;  	// Data size in bytes in the layer, excluding
								// the header. To skip to next layer

	byte         samples;  		// number of wavesamples

	byte         reserved[40];  // For future extensions

} TLayerHeader;


typedef struct {
	byte	rate[6];	// Ramp rate
	byte	offs[6];    // Ramp length
} TEnvelope;
// I have not been able to fully understand the envelope bytes:
// The rates are the rate of amplitude change (I think the alowed range is
// 1..3F for point 1-5 and 1..CF for point 6 or something...) wich goes on
// until the corresponding 'offset' (what time unit?) is reached (maybe its
// somekind of dy/dx desciption).    Different parts of the  envelope  are
// enabled/disabled via the mode byte below.You should try Gravis PATCH.EXE
// (from the SDK) or another patch editor to fiddle around with it a little

typedef struct {
	byte         wave_name[7];  // asciz. name of the wave. 'NoName'#0 if
								// none, use 'C3', 'High' and such names

	byte         fractions;  	// Start loop point fraction in 4 bits + End
								// loop point fraction in the 4 other bits;
								// used when looppoint is between two samples

	dword        wave_size;		// Total size of wavesample. Limited to 64KB
								// now by the drivers,card can do up to 256KB
								// for 16 bit data and 1MB for 8 bit data.

	dword        start_loop;  	// Start loop position
	dword        end_loop;  	// End loop position

	word         sample_rate;	// Sample frequency, in Hz
								// For info only, patch drivers don't care,
								// they use root_frequency to calc playback

	dword        low_frequency; // Lowest frequency to play, see scale_table
	dword        high_frequency;// Highest frequency to play, see scale_table
	dword        root_frequency;// Root frequency to play, see scale_table
								// The 'frequency' wich correspond to the
								// sample_rate.(this is the freq that sounds
								// in the drum bank are played at)

	word         tune;  		// Always 1, not used anymore

	byte         balance;  		// Pan, 0..15, (0-full left, 15-full right)

	TEnvelope    envelope;		// Envelope description

	byte         tremolo_sweep; // tremolo sweep (sensitivity? amplitude?)
	byte         tremolo_rate;  // tremolo rate
	byte         tremolo_depth; // tremolo depth
	byte         vibrato_sweep; // vibrato sweep
	byte         vibrato_rate;  // vibrato rate (lfo - sine)
	byte         vibrato_depth; // vibrato depth

	byte         modes;  		// A set of flags:
	// bit 0 = 0=8 bit, 1=16 bit wave data.
	// bit 1 = 0=Signed data, 1=Unsigned data.
	// bit 2 = 1=Enable looping
	// bit 3 = 1=Enable bidirectional looping
	// bit 4 = 1=Enable looping backward
	// bit 5 = 1=Enable sustain (3rd point of envelope)
	// bit 6 = 1=Enable envelopes, must be set if you want to hear anything
	// bit 7 = 1=Enable clamped release (6th point of envelope)

	word         scale_frequency;  	// 60, Dunno what it is
	word         scale_factor; 		// from 0 to 2048, 1024 is normal
									// notefreq := (freq*scale_factor) shr 10

	byte         reserved[36];  	// For future extensions

} TWaveHeader;



static dword scale_table[108] =
{	   		// C-0..B-8
	/*O0*/	16351,17323,18354,19445,20601,21826,23124,24499,25956,27500,29135,30867,
	/*O1*/	32703,34647,36708,38890,41203,43653,46249,48999,51913,54999,58270,61735,
	/*O2*/	65406,69295,73416,77781,82406,87306,92498,97998,103826,109999,116540,123470,
	/*O3*/	130812,138591,146832,155563,164813,174614,184997,195997,207652,219999,233081,246941,
	/*O4*/	261625,277182,293664,311126,329627,349228,369994,391995,415304,440000,466163,493883,
	/*O5*/	523251,554365,587329,622254,659255,698456,739989,783991,830609,880000,932328,987767,
	/*O6*/	1046503,1108731,1174660,1244509,1318511,1396914,1479979,1567983,1661220,1760002,1864657,1975536,
	/*O7*/	2093007,2217464,2349321,2489019,2637024,2793830,2959960,3135968,3322443,3520006,3729316,3951073,
	/*O8*/	4186073,4434930,4698645,4978041,5274051,5587663,5919922,6271939,6644889,7040015,7458636,7902150
};
