/*
[description]
gold wave version 5 scripts.
version 1.6
by Jim Grimsby,  Gary Campbell, Jim Bowers, Jitendra and Ramkumar


[include]
*/
Include "HjGlobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
;Include "common.jsm"
include "goldwave.jsh" ;wglobal variables  
 include "goldwave.jsm" ;gold wave script messages and constance 
;[settings functions]




Int Function progressOn ()
if IniReadInteger ("GoldWaveSettings", "progress", 1, "goldwave.ini") == 1 then 
return true
 else 
return false 
EndIf 
EndFunction
Int Function markersOn ()
if IniReadInteger ("GoldWaveSettings", "markers", 1, "goldwave.ini") == 1 then 
return true
 else 
return false 
EndIf 
EndFunction
Int Function LablesOn ()
if IniReadInteger ("GoldWaveSettings", "lables", 1, "goldwave.ini") == 1 then 
return true
 else 
return false 
Endif 
EndFunction
;[Setting scripts] 
Script ProgressONOff ()
if progressOn () then 
IniWriteInteger ("GoldWaveSettings", "progress", 0, "goldwave.ini")
SayMessage (ot_status, "Progress off", "Off")
else 
IniWriteInteger ("GoldWaveSettings", "progress", 1, "goldwave.ini")
SayMessage (ot_status, "Progress on", "On")
Endif
EndScript
Script LablesONOff ()
if LablesOn () then 
IniWriteInteger ("GoldWaveSettings", "lables", 0, "goldwave.ini")
SayMessage (ot_status, "Labels off", "Off")
else 
IniWriteInteger ("GoldWaveSettings", "lables", 1, "goldwave.ini")
SayMessage (ot_status, "Labels on", "On")
Endif
EndScript
Script markersOnOff ()
if markersOn () then 
IniWriteInteger ("GoldWaveSettings", "Markers", 0, "goldwave.ini")
SayMessage (ot_status, "Markers off", "Off")
else 
IniWriteInteger ("GoldWaveSettings", "markers", 1, "goldwave.ini")
SayMessage (ot_status, "Markers on", "On")
Endif
EndScript
;[work arounds]

Script tab ()
PerformScript Tab()

pause ()if StringContains (GetWindowClass (GetFocus ()), "Frame")then
PerformScript Tab()
endif


EndScript
Script Shifttab ()
PerformScript ShiftTab()
pause ()if StringContains (GetWindowClass (GetFocus ()), "Frame")then
PerformScript ShiftTab()
endif
EndScript

















Script JawsHome ()
If InSoundWindow () then
if IsPCCursor () then
JAWSHome ()
SayUsingVoice (VCTX_Message, "the cursor moved to start marker location.", OT_cursor )
Delay (1, true)
ReadStartMarker ()
Else
SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
EndIf
Else
PerformScript JAWSHome()
EndIf
EndScript


Script JawsEnd ()
If InSoundWindow () then
if IsPCCursor () then 
JAWSEnd ()
SayUsingVoice (VCTX_Message, "the cursor moved to Finish marker location.", OT_cursor )
Delay (1, true)
ReadFinishMarker ()
Else
PerformScript JAWSEnd()
EndIf
Else
PerformScript JAWSEnd()
endif 
EndScript


Script MoveStartMarkerToBeginning ()
If InSoundWindow () then
TypeCurrentScriptKey ()
Delay (3, true)
ReadStartMarker ()
Else
PerformScript SelectFromStartOfLine()
EndIf
EndScript


Script MoveStartMarkerToFinishMarker ()
If InSoundWindow () then
TypeCurrentScriptKey ()
Delay (3, true)
ReadStartMarker ()
ReadFinishMarker ()
Else
PerformScript SelectToEndOfLine()
EndIf
EndScript


Script MoveFinishMarkerToStartMarker ()
If InSoundWindow () then
TypeCurrentScriptKey ()
Delay (3, true)
ReadFinishMarker ()
ReadStartMarker ()
Else
PerformScript SelectFromTop()
EndIf

EndScript


Script MoveFinishMarkerToEnd ()
If InSoundWindow () then
TypeCurrentScriptKey ()
Delay (3, true)
ReadFinishMarker ()
Else
PerformScript SelectToBottom()
EndIf
EndScript
;Zoom related scripts and functions
Script SayCurrentZoomLevel ()
if not InMainWindow () Then 
ReadZoomStatus ()
EndIf
EndScript

Void Function ReadZoomStatus ()
Var
	String sTemp
if InSoundWindow ()||InControlWindow ()Then 
Let stemp=GetSecondStatusLine ()
If (StringLength(sTemp) > 0) Then
Let StatusText = StringSegment(sTemp, " ", 2)
SayMessage (OT_NO_Disable, "The current zoom level is", "Zoomed")
sayformattedtime (Statustext)
endif
endif
EndFunction

 String Function FormatPeriod (string sPeriod)
; formats either hours or   minutes
IF (StringToInt (sPeriod) == 0) THEN
RETURN ("")
ELIF (StringToInt (sPeriod) == 1) THEN
RETURN (sPeriod + " ")
ELSE
; hours or minutes > 1
RETURN (sPeriod + "s ")
ENDIF
EndFunction

Void Function SayFormattedTime (string STime)
VAR
String sHours,
STRING sMinutes,
STRING sSeconds
LET STime = stringStripAllBlanks (STime)
; not required if sTime never   contains spaces
 ; uses StringSegment to separate hours, minutes & seconds based on the colon
IF (StringSegment (sTime, ":", 3) > "") THEN
; all 3 components exist
LET SHours = FormatPeriod (StringSegment (STime, ":", 1) + " hour")
 LET SMinutes = FormatPeriod (StringSegment (STime, ":", 2) + " minute")
LET sSeconds = StringSegment (sTime, ":", 3)
ELIF (StringSegment (sTime, ":", 2) > "") THEN
; minutes & seconds exist
LET SMinutes = FormatPeriod (StringSegment (STime, ":", 1) + " minute")
 LET sSeconds = StringSegment (sTime, ":", 2)
ELSE
; only seconds showing
LET sSeconds = StringSegment (sTime, ":", 1)
ENDIF
; how many segments in time string
; Note: the "x" is required because of the odd way Jaws compares numeric   strings
IF (StringLeft (sHours, 1) == "0") THEN
LET sHours =stringChopLeft (sHours, 1)
EndIf
IF (StringLeft (sMinutes, 1) == "0") THEN
LET sMinutes =stringChopLeft (sMinutes, 1)
EndIf
 IF ("x" + sSeconds == "x00.0") THEN
 LET sSeconds = "0"
ELIF (StringLeft (sSeconds, 1) == "0") THEN
LET sSeconds =stringChopLeft (sSeconds, 1)
ENDIF
LET sSeconds = sSeconds + " seconds"
SayUsingVoice (vctx_Message, sHours + sMinutes + sSeconds, OT_NO_Disable )
EndFunction

Script ZoomIn ()
if not UserBufferIsActive () && InSoundWindow () then
TypeCurrentScriptKey ()
Delay (1, true)
ReadZoomStatus ()
Else
PerformScript SelectPriorLine()
EndIf
EndScript

Script ZoomOut ()
if not UserBufferIsActive () && InSoundWindow () then
TypeCurrentScriptKey ()
Delay (1, true)
ReadZoomStatus ()
Else
PerformScript SelectNextLine()
EndIf
EndScript

Void Function CheckAndPass ()
If DialogActive () then
SayCurrentScriptKeyLabel ()
TypeCurrentScriptKey ()
EndIf
if not UserBufferIsActive () && InSoundWindow () then
TypeCurrentScriptKey ()
Pause ()
if InControlWindow ()||InSoundWindow () then 
If markersOn () then 
ReadZoomStatus ()
EndIf
endif
endif
EndFunction

Script ZoomSelection ()
CheckAndPass ()
EndScript


Script Zoom1Second ()
CheckAndPass ()
EndScript

Script Zoom10Sec ()
CheckAndPass ()
EndScript


Script Zoom1min ()
CheckAndPass ()
EndScript


Script Zoom10Min ()
CheckAndPass ()
EndScript


Script Zoom1Hour ()
CheckAndPass ()
EndScript


Script ZoomAll ()
CheckAndPass ()
EndScript


Script ZoomToIndividualSample ()
CheckAndPass ()
EndScript


Script ZoomToActualWaveForm ()
CheckAndPass ()
EndScript


Script PresetZoom ()
CheckAndPass ()
EndScript


Script PreviousZoom ()
CheckAndPass ()
EndScript





Script ChangeZoomLevelDisplayMode ()
var
	int nCurrent,
Int Restriction
let nCurrent = getRestriction()
Let restriction = Ncurrent
if! (nCurrent == RestrictNone) then
	let nCurrent = RestrictNone
SpeechOff ()
SaveCursor ()
JAWSCursor ()
SaveCursor ()
RouteJAWSToPc ()
JAWSPageDown ()
JAWSHome ()
If FindString (GetCurrentWindow (), "Original", s_Bottom, S_Unrestricted)  || FindString (GetCurrentWindow (), "Modified", s_Bottom,  S_Unrestricted) then 
NextWord ()
EndIf
RightMouseButton ()
Delay (1, true)
SpeechOn ()
SayLine ()
RestoreCursor ()
RestoreCursor ()
Let NCurrent = Restriction
Endif
EndScript

Void Function InEffectsDialog ()
var 
Int Control,
Handle grip
Let grip = GetFocus ()
If ( DialogActive ()  ) Then 
Let Control = GetControlID (grip)
If (Control == 1001) Then 
Return true
Else 
Return false
EndIf
endif
EndFunction





Void Function ReadCursorTime ()
Var
	String sTemp
if InSoundWindow ()||InControlWindow ()Then 
TypeKey (Gw_ks_MemorizeMarkers)
Pause ()
TypeKey ( gw_ks_SetStartMarker)
Pause ()
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp)) Then
Let StatusText = StringSegment(sTemp, " ", 3)
let statustext2=Cursor_Short+ StatusText
TimeFormat ()
let StatusText=cursor+statustext3
SayFormattedMessage (OT_NO_DISABLE,StatusText,StatusText2)
EndIf
Endif
SpeechOff ()
TypeKey (Gw_ks_RecallMarkers)
Pause ()
SpeechOn ()
EndFunction

Script SayCursorLocation ()
if not InMainWindow () Then 
ReadCursorTime ()
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
EndIf
EndIf
EndScript

Script SaySoundRemainingTime ()
Var
	String sTemp,
String Stemp2,
Int I,
Int J
if not inmainWindow () then
if InSoundWindow ()||InControlWindow ()Then 
SpeechOff ()
TypeKey (Gw_ks_MemorizeMarkers)
Pause ()
TypeKey ( gw_ks_SetStartMarker)
{Control+Shift+End}
Pause ()
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp)) Then
Let i = StringContains(sTemp, "(") + 1
Let j = StringContains(sTemp, ")")
Let StatusText = Substring(sTemp, i, j - i)
Let statustext2 = RemTime_S+Statustext
TimeFormat ()
Let statustext = RemTime_L+statustext3
SpeechOn ()
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
else 
SayFormattedMessage (OT_NO_DISABLE,statustext,statustext2)
EndIf
EndIf
EndIf
EndIf
TypeKey (Gw_ks_RecallMarkers)
EndScript


;End of the scripts by Jitendra!
;some scripts By: b.Ram Kumar to preview and stop the audio in nonstandard effect plugin's dialogs.
Script PreViewButtonClick ()
	var handle grip,
 int i,
  handle hwnd 
Let grip = GetFocus ()
 let i =0 
Let hwnd = GetCurrentWindow ()
if InSoundWindow ()||InControlWindow () then
   SayString (" You are not in any of the effects dialog box " ) 
else 
   SpeechOff()
if !InSoundWindow () then
 while   (GetWindowName (grip)  != "Preview" && i != 50)  
 let  i=i+1 {Tab}  
 delay(1)  
 Let grip = GetFocus ()
 endwhile
SayUsingVoice (vctx_message, "Preview", OT_Control_Name ) {Space} Pause () SetFocus (hwnd) EndIf  SpeechOn ()
endif 
 EndScript
Script StopPreViewButtonClick ()
var
handle grip,
int i,
handle hwnd 
Let grip = GetFocus () 
let i =0
Let hwnd = GetCurrentWindow ()
if InSoundWindow () then
   SayString (" You are not in any of the effects dialog box " ) 
else 
SpeechOff ()
if !InSoundWindow () then 
while   (GetWindowName (grip)  != "stop" && i != 50)
  let  i=i+1
{Tab} 
delay(1)
Let grip = GetFocus () 
EndWhile
SayUsingVoice (vctx_message, "Stop preview", OT_Control_name )
{Space}
Pause ()
SetFocus (hwnd) 
EndIf
SpeechOn ()
ENDIF 
EndScript

;[Active window functions]
Void Function menuCommand (int menuID)
if InControlWindow ()then 
toggelControlWindow ()
endif 
SendMessage (GetAppMainWindow (GetFocus ()), wm_command, menuID, 0)
EndFunction
Void Function CheckGoldWaveVersion ()
if (GetProgramVersion (GetAppFilePath ()) < 5) then
if (GWFirstTime == 0) then
SayUsingVoice (VCTX_MESSAGE, MsgSwitchingConfigurations, OT_STRING)
let GWFirstTime = 1
EndIf
SwitchToConfiguration (configuration_v4)
EndIf
EndFunction
Int Function inmainWindow2 ()
if UserBufferIsActive () then 
return false
else 
if InControlWindow ()then 
let wasControl = true 
toggelControlWindow ()
else 
let wasControl = false
EndIf 
If StringContains (GetWindowClass (GetFocus ()), wc_main)then 
WasInControl ()
return true 
else 
WasInControl ()
 return false
EndIf
endif
EndFunction
Int Function inmainWindow ()
if UserBufferIsActive () then 
return false
else 
if InControlWindow ()then 
let wasControl = true 
toggelControlWindow ()
else 
let wasControl = false
EndIf   ; in control window
If StringContains (GetWindowClass (GetFocus ()), wc_main)then 
SayFormattedMessage (ot_error, NoFile, NoFile_short)
WasInControl ()
return true 
else 
WasInControl ()
 return false
EndIf
endif
EndFunction
Int Function InSoundWindow ()
if UserBufferIsActive () then 
return false
else 
if StringContains (GetWindowClass (GetFocus ()),wc_SoundWindow) then
Return true
else 
return false 
EndIf
endif
EndFunction
Int Function InControlWindow ()
if UserBufferIsActive () then 
return false
else 
If StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_ControlWindow)then
Return true
Else
 Return false 
EndIf
endif
EndFunction
Function WasInControl ()
if WasControl == true then 
toggelControlWindow ()
EndIf 
EndFunction
Function WasInSound ()
If WasSound ==True Then 
toggelControlWindow ()
EndIf 
EndFunction

Int Function InCuePointsDialog ()
If StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_CuePointsDialog)then
return true 
else
 return false
endif
EndFunction

Int Function InOpenSoundDialog ()
var string GwDlg 
let gwdlg = GetAppTitle ()
if gwdlg == s_openSound then return true 
else return false 
endif 
EndFunction

;[status line functions]
Function ReadRemainingTime ()
If StringContains (GetWindowClass (GetRealWindow (GetFocus ())),WC_progressDialog ) then
Let StatusText = GetDialogStaticText ()
let statusText = stringChopRight (statusText, 6)
SayFormattedMessage (OT_NO_DISABLE,StatusText)
EndIf 
EndFunction
Void Function readTotalTime ()
Var
	String sTemp
if not inmainWindow ()then 
ReadRemainingTime ()
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp) > 0 ) Then
Let StatusText = StringSegment (sTemp, " ", 2)
let StatusText2=Totaltime_short 
+ StatusText
TimeFormat ()
let StatusText=Totaltime+statustext3 
SayFormattedMessage (OT_NO_DISABLE, StatusText, StatusText2)
EndIf
EndIf 
EndIf
EndFunction
Function ReadStartMarker ()
Var
	String sTemp
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp)) Then
Let StatusText = StringSegment(sTemp, " ", 3)
let statustext2=StartMarker_short+ StatusText
TimeFormat ()
let StatusText=StartMarker+statustext3
SayFormattedMessage (OT_NO_DISABLE,StatusText,StatusText2)
EndIf
Endif
EndFunction
Function ReadFinishMarker ()
Var
	String sTemp
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp) > 0) Then
Let StatusText = StringSegment(sTemp, " ", 5)
let statustext2= FinishMarker_short+ StatusText
TimeFormat ()
let StatusText=FinishMarker+statustext3
SayFormattedMessage (OT_NO_DISABLE,StatusText,statusText2)
EndIf 
EndIf 
EndFunction
Void Function TimeFormat ()
var 
int status
let status = StringLength (statustext)
if status == 12 then 
let statustext3 =" "+ SubString (statustext, 1, 2)+" "+Hours+" "
+SubString (statustext, 4, 2)+" "+Minutes+" "
+SubString (statustext, 8, 5)+" "+Seconds
elIf status == 9 then 
let statustext3 =" "+ SubString (statustext, 1, 2)+" "+Minutes+" " 
+SubString (statustext, 4, 5)+" "+Seconds
elif status == 8 then
let statustext3 =" "+ SubString (statustext, 1, 1)+" "+Minutes+" " 
+SubString (statustext, 3, 5)+" "+Seconds
ElIf status == 5 then 
Let statustext3 =" "+  statustext+" "+seconds 
ElIf status==6 Then 
Let statustext3 =" "+  statustext+" "+seconds 
EndIf
;WasInControl ()
EndFunction

String Function CollapseSpaces(String s)
; Replaces strings of multiple blanks with a single blank.
; This is so that the string can be used with StringSegment to select tokens.

Var
	String sOut,
	String sTemp,
	;String sDebug,   ; debug
	Int i

;Let sDebug = "s = {" + s + "}\n"   ; debug
Let sTemp = StringTrimTrailingBlanks (s)
Let sTemp = StringTrimLeadingBlanks(sTemp)

Let i = StringContains(sTemp, " ")
;Let sDebug = sDebug + "Before while i = " + IntToString(i) + " sTemp = {" + sTemp + "}\n"   ; debug
While (i)
	; We should be guaranteed the loop will terminate-- knock knock-- does laminate count?
	Let sOut = sOut + StringLeft(sTemp, i)   ; includes the first following blank
	Let sTemp = StringChopLeft(sTemp, i)
	Let sTemp = StringTrimLeadingBlanks(sTemp)
	Let i = StringContains (sTemp, " ")
;Let sDebug = sDebug + "At end of while i = " + IntToString(i) + " sTemp = {" + sTemp + "}\n"   ; debug
;Let sDebug = sDebug + "sOut = {" + sOut + "}\n"   ; debug
EndWhile
;Let sDebug = sDebug + "After while sTemp length " + IntToString(StringLength(sTemp)) + " sTemp = {" + sTemp + "}\n"

If (StringLength(sTemp) > 0) Then
	Let sOut = sOut + sTemp
EndIf
;If (UserBufferIsActive()) Then   ; debug
	;UserBufferDeactivate()   ; debug
;EndIf   ; debug
;UserBufferClear()   ; debug
;UserBufferAddText(sDebug)   ; debug
;UserBufferActivate()   ; debug
Return sOut
EndFunction

Handle Function GetMainWindow()
; Returns a handle to the "main" window (the tMainForm).
var
	Handle hStatus,
	Handle hTemp
Let hTemp = FindTopLevelWindow(Wc_TMainForm,"")
;SayString("GetMainWindow: top level window class is" + GetWindowClass(hTemp))   ; debug
;SayString("Window name is " + GetWindowName(hTemp))   ; debug
Return hTemp
EndFunction

String Function GetFirstStatusLine()
; Returns the first status line at the bottom of the screen.
; Strings of spaces are collapsed to a single space.
Var
	Handle hTemp
Let HTEMP = GetMainWindow ()
 Let hTemp =FindWindow (htemp,wc_StatusBar )
Return CollapseSpaces(GetWindowText(hTemp, READ_EVERYTHING))

EndFunction

String Function GetSecondStatusLine()
; Returns the second status line at the bottom of the screen.
; Strings of spaces are collapsed to a single space. 
Var
	Handle hTemp
let HTEMP = GetMainWindow ()
let HTEMP = FindWindow (HTEMP, wc_StatusBar)
Let hTemp = GetNextWindow(hTemp)
Return CollapseSpaces (GetWindowText(hTemp, READ_EVERYTHING))
EndFunction
String Function GetControlStatusLine ()
; Returns the "Control Status" line which contains the current action and elapsed time.
; Strings of spaces are collapsed to a single space.

; Returns the line in the edit in either the TControlBar or the TControlView.
; This line contains the elapsed time and the current action (Play, Stopped, etc.).
Var
	Handle hTemp,
	String sTemp

; Is it in the tControlBar?
Let hTemp = GetMainWindow()
Let hTemp = GetFirstChild(hTemp)   ; TControlBar
Let hTemp = GetFirstChild(hTemp)   ; TPanel
Let hTemp = GetNextWindow(hTemp)   ; TPanel
Let hTemp = GetFirstChild(hTemp)
If (! hTemp) Then
	; Go for the TControlView
	Let hTemp = FindTopLevelWindow(wc_ControlWindow, S_CONTROL)
	Let hTemp = GetFirstChild(hTemp)
	; We should have it
EndIf
Let sTemp = GetWindowText(hTemp, READ_EVERYTHING)
Return CollapseSpaces (sTemp)
EndFunction

String Function GetTotalTime ()
Var
	String sTemp
Let sTemp = GetFirstStatusLine ()
Return StringSegment(sTemp, " ", 2)
EndFunction
String Function GetAction()
Var
	String sTemp
Let sTemp = GetControlStatusLine ()
Return StringSegment(sTemp, " ", 1)
EndFunction
Void Function toggelControlWindow ()
SpeechOff ()
{alt+f6}
pause () 
pause ()
SpeechOn ()
EndFunction
;[Status line scripts]
Script sayProgress ()
if not inmainWindow ()then 
If StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_progressDialog ) then
Let statustext = GetDialogStaticText ()
let statusText = StringRight (statustext, 5)
Let StatusText = stringChopLeft (statustext, 1)
let Statustext = stringChopRight (statustext, 1)
SayFormattedMessage (OT_NO_DISABLE, statustext)
Endif 
endIf
EndScript
Script SaySelectedChannel ()
Var
	String sTemp
if not inmainWindow ()then 
Let sTemp = GetFirstStatusLine()
If (StringLength (sTemp) > 0) Then
Let StatusText = StringSegment (sTemp, " ", 1)
If StringContains (StatusText, S_MONO) then 
SayFormattedMessage (OT_NO_DISABLE, mono, Mono_short)
elif StringContains (StatusText, S_STEREO)
Then 
SayFormattedMessage (OT_NO_DISABLE,both,Both_short)
elif StringContains (StatusText, S_LEFT)
Then 
SayFormattedMessage (OT_NO_DISABLE,left,Left_Short)
elif StringContains (StatusText, S_RIGHT)
Then 
SayFormattedMessage (OT_NO_DISABLE,right,Right_Short)
endif
EndIf
EndIf
EndScript
Void Function ReadOpenFile ()
Var
Handle Hwnd,
	String sTemp,
	String sMsg_L,
	String sMsg_S
if InSoundWindow ()||InControlWindow ()Then 
Let hWnd =  GetMainWindow ()
let HWND =  FindWindow (HWND, wc_soundwindow)
Let sTemp = GetWindowName (hWnd)
; By passing the file name as a parameter to the FormatString function we 
; give localizers more flexibility in translating the message.
Let sMsg_L = FormatString(OpenFile, sTemp)
Let sMsg_S = FormatString(Open_Short, sTemp)
SayFormattedMessage (OT_NO_DISABLE, sMsg_L, sMsg_S)
let statusText = sMsg_L 
EndIf 
EndFunction
Script SayOpenFile ()
if not inmainWindow ()then 
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
else 
ReadOpenFile ()
EndIf 
EndIf 
EndScript   ; SayOpenFile 
Script SayFileFormat ()
Var
	String sTemp,
	String sTemp2,
	Int i,
	Int j
If Not inmainWindow () then 
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetSecondStatusLine ()
If (StringLength(sTemp) > 0) Then
Let i = StringContains(sTemp, ":") + 1
Let sTemp2 = Substring(sTemp, i, 999)
Let sTemp2 = StringTrimLeadingBlanks (sTemp2)
Let i = StringContains(sTemp2, " ")   ; skip over the second number
Let sTemp2 = Substring(sTemp2, i, 999)   ; longer than the string could be
Let sTemp2 = StringTrimLeadingBlanks(sTemp2)
; Note: if the PriorCharacter() was to add a space at the beginning of the string, this code doesn't do that
Let StatusText=FileFormat
+ sTemp2
Let StatusText2=FileFormat_Short
+ sTemp2
if IsSameScript ()then 
SayFormattedMessage (ot_user_buffer, statustext)
else 
SayFormattedMessage (OT_NO_DISABLE, statustext, statustext2)
EndIf
EndIf
Endif
EndIf 
EndScript
Script SayAction ()
Var
	String sAction
If not  inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then 
Let sAction = GetAction ()
If (StringLength(sAction) > 0) Then
let StatusText=acction 
+" "
+ sAction
let StatusText2=acction_short 
+" "
+ sAction
if IsSameScript ()then 
SayFormattedMessage (ot_user_buffer, statustext)
else 
SayFormattedMessage (OT_NO_DISABLE,statusText,statusText2)
Endif
endIf 
EndIf 
EndIf 
EndScript
Script SayElapsedTime ()
Var
	String sTemp
If not InMainWindow () Then  
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetControlStatusLine ()
If (StringLength(sTemp) > 0) Then
let StatusText=ElapsedTime
 + StringSegment(sTemp, " ", 2)
let StatusText2=ElapsedTime_short
+StringSegment(sTemp, " ", 2)
if IsSameScript ()then 
SayFormattedMessage (ot_user_buffer, statustext)
Else 
SayFormattedMessage (OT_NO_DISABLE,StatusText,statustext2)
EndIf
EndIf
EndIf 
EndIf 
EndScript
Script sayTotaltime ()
readTotalTime ()
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
EndIf 

EndScript

Script sayStartMarkerLocation ()
if not InMainWindow () Then 
ReadStartMarker ()
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
EndIf
EndIf
EndScript

Script SayFinishMarkerLocation ()
If Not inmainWindow () Then 
ReadFinishMarker ()
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
EndIf
EndIf
EndScript

Script SayDurationOfSelection ()
Var
	String sTemp,
	String sTemp2,
	Int i,
	Int j
if not inmainWindow () then 
if InSoundWindow ()||InControlWindow ()Then 
Let sTemp = GetFirstStatusLine()
If (StringLength(sTemp) > 0) Then
Let i = StringContains(sTemp, "(") + 1
Let j = StringContains(sTemp, ")")
Let StatusText = Substring(sTemp, i, j - i)
Let statustext2=SelectedDuration_short+statusText
TimeFormat ()
Let statustext=SelectedDuration+statustext3 
if IsSameScript () then 
SayFormattedMessage (ot_user_buffer,StatusText)
else 
SayFormattedMessage (OT_NO_DISABLE,statustext,statustext2)
EndIf
EndIf 
EndIf
EndIf 
EndScript
Script SayStatusLine ()
if InSoundWindow ()||InControlWindow ()Then
PerformScript SayOpenFile()
PerformScript SayFileFormat()
PerformScript SayAction()
PerformScript SayTotalTime()
PerformScript SayElapsedTime()
PerformScript sayStartMarkerLocation()
PerformScript SayFinishMarkerLocation()
PerformScript SayDurationOfSelection()
ElIf StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_progressDialog ) then
let StatusText=GetAppTitle ()
+GetDialogStaticText ()
SayFormattedMessage (OT_NO_DISABLE,statusText)
else 
PerformScript SayBottomLineOfWindow()
EndIf
EndScript
;[Gold wave commands]
Script Previous ()
if not inmainWindow ()then
TypeCurrentScriptKey ()
pause ()
if InControlWindow ()||InSoundWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable,ShiftBackSlash )
EndIf 
if markersOn () then 
ReadStartMarker ()
ReadFinishMarker ()
endif 
EndIf ;InSoundWindow ()||InControlWindow ()
EndIf ;not inmainWindow ()
EndScript
Script makePlaybackSpeedFaster ()
if not inmainWindow ()then
TypeKey (Gw_ks_speedFaster)
pause ()
if InControlWindow ()||InSoundWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftL)
EndIf 
EndIf 
EndIf
EndScript
Script MakePlaybackSpeedSlower ()
if not inmainWindow ()then
TypeKey (Gw_ks_speedSlower)
pause ()
if InControlWindow ()||InSoundWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftJ)
EndIf 
EndIf
EndIf
EndScript
Script MakePlaybackSpeedNormal ()
if not inmainWindow ()then
TypeKey (Gw_ks_speedNormal)
pause ()
if InControlWindow ()||InSoundWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftK)
EndIf 
EndIf
EndIf
EndScript
Script SelectView ()
if not inmainWindow ()then
TypeKey (Gw_ks_SelectView)
pause ()
if InControlWindow ()||InSoundWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, controlW)
EndIf 
if markersOn () then 
ReadStartMarker ()
ReadFinishMarker ()
endif 
EndIf ;InSoundWindow ()||InControlWindow ()
EndIf ;not inmainWindow ()
EndScript

Script Newfile ()
TypeKey (Gw_Ks_NewFile)
EndScript

Script open ()
TypeKey (Gw_ks_OpenFile)
EndScript
Script save ()
if InCuePointsDialog ()then 
SaveCursor ()
if FindString (GetRealWindow (GetFocus ()), s_splitFile, s_top, s_unrestricted)then
LeftMouseButton ()
endif
elif not inmainWindow ()then 
TypeKey (Gw_ks_SaveFile)
EndIf
EndScript
Script SelectLeftChannel ()
TypeKey (Gw_ks_SelectLeftChannel)
Pause ()
PerformScript SaySelectedChannel()
EndScript
Script SelectRightChannel ()
TypeKey (Gw_ks_SelectRightChannel)
Pause ()
PerformScript SaySelectedChannel()
EndScript
Script SelectBothChannels ()
TypeKey (  Gw_Ks_SelectBothChannels)
Pause ()
PerformScript SaySelectedChannel()
EndScript
Script SetStartMarker ()
TypeKey ( gw_ks_SetStartMarker)
Pause ()
if markersOn () then 
ReadStartMarker()
Endif 
EndScript
Script SetFinishMarker ()
TypeKey (Gw_Ks_SetFinishMarker)
Pause ()
if markersOn () then 
ReadFinishMarker()
Endif
EndScript

Script Play3SecondsToStartMarker ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftLeftBrackit)
endif 
TypeKey (gw_ks_Play3SecondsToStartMarker)
endif 
endif
EndScript
Script PlayThreeSecondsToFinishMarker ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftRightBrackit)
endif 
TypeKey (gw_ks_playthreesecondstofinishmarker ) 
endif 
endif
EndScript
Script PlayFromFinishMarker ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ControlRightBrackit
)
endif 
TypeKey (gw_ks_PlayFromFinishMarker ) 
endif 
endif
EndScript
Script PlayFromStartMarkerToFinishMarker ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable,controlLeftBrackit )
endif 
TypeKey (gw_ks_PlayThreeSecondsFromStartMarker ) 
endif 
endif
EndScript



Script JumpToNextCue ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ControlJ, Controlj_short)
Endif 
TypeKey (Gw_Ks_JumpToNextCue)
pause ()
if markersOn () then 
ReadStartMarker ()
Endif 
EndIf 
Endif
EndScript
Script JumpToPrierCue ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then
SayFormattedMessage (ot_no_disable, ControlShiftJ, ControlShiftJ_short)
EndIf 
TypeKey (Gw_Ks_JumpToPrierCue)
pause ()
if markersOn () then 
ReadStartMarker ()
endif
EndIf 
EndIf
EndScript
Script MoveFinishMarkerToNextCue ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then
SayFormattedMessage (ot_no_disable, AltJ, ControlJ_short)
EndIf 
TypeKey (Gw_Ks_MoveFinishMarkerToNextCue)
pause ()
if markersOn () then 
ReadFinishMarker ()
endif
EndIf 
EndIf
EndScript
Script MoveFinishMarkerToPriorCue ()
if not inmainWindow ()then if InSoundWindow ()||InControlWindow ()then 
if LablesOn () then
SayFormattedMessage (ot_no_disable, AltShiftJ, ControlShiftJ_short)
EndIf 
TypeKey (Gw_Ks_MoveFinishMarkerToPriorCue)
pause ()
if markersOn () then 
ReadFinishMarker ()
endif
EndIf 
EndIf
EndScript

Script playFromHere ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (gw_ks_playFromHere)
else 
TypeCurrentScriptKey ()
endif 
endif
EndScript

Script PlayGreenButton ()
if IsSameScript () then 
PerformScript PreViewButtonClick()
else
if InOpenSoundDialog ()then 
SpeechOff ()
let startpoint = GetFocus ()
TypeKey (Gw_Ks_OdPreview)
pause ()
SetFocus (startpoint)
Delay (1, false)
SpeechOn ()
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f4_preview,f4_preview_short)  
Endif 
else 
TypeKey (Gw_Ks_PlayGreenButton)
endif
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f4,f4_short)
Endif 
ElIf StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_EffectDialog)||StringContains (GetWindowClass (GetRealWindow (GetFocus())),wc_expressionEvaluatorDialog)||StringContains (GetWindowClass (GetRealWindow (GetFocus ())), wc_cuepointsdialog) Then 
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f4_preview,f4_preview_short)  
EndIf 
endif
Endif 
endif 
EndScript


Script playOneButton ()
TypeKey (Gw_Ks_PlayoneButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
 if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f2,f4_short)
endif 
EndIf
EndIf
EndScript

Script PlayYelloButton ()
TypeKey (Gw_Ks_PlayYelloButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
 if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,ShiftF4,f4_short)
endif 
EndIf
EndIf
EndScript
Script RewindButton ()
TypeKey (Gw_Ks_RewindButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f5,f5_short)
Endif 
EndIf
EndIf
EndScript
Script FastForwardButton ()
TypeKey (Gw_ks_FastForwardButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f6,f6_short)
Endif 
EndIf
EndIf
EndScript
Script PauseButton ()
Var
	String sAction,
	String sMsgLong,
	String sMsgShort
Let sAction = GetAction ()
TypeKey (Gw_ks_PauseButton )
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then If (StringContains(sAction, S_ACTION_PAUSE)) Then
	Let sMsgLong = f7_resume
	Let sMsgShort = f7_resume_short
Else
	Let sMsgLong = f7
	Let sMsgShort = f7_short
EndIf
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE, sMsgLong, sMsgShort)
Endif 
Return
EndIf
EndIf
SayCurrentScriptKeyLabel ()
EndScript
Script StopButton ()
if IsSameScript () then 
PerformScript StopPreViewButtonClick()
else 
if InOpenSoundDialog ()then 
SpeechOff ()
let startpoint = GetFocus ()
TypeKey (Gw_Ks_OdStopPreview)
pause ()
SetFocus (startpoint)
Delay (1, false)
SpeechOn ()
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f8_preview)
endif 
else
TypeKey (Gw_ks_StopButton)
endif 
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow () Then
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f8,f8_short)
Endif 
ElIf StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_EffectDialog)||StringContains (GetWindowClass (GetRealWindow (GetFocus())),wc_expressionEvaluatorDialog)||StringContains (GetWindowClass (GetRealWindow (GetFocus ())), wc_cuepointsdialog) Then 
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,f8_preview)
endif 
EndIf
EndIf
EndIf 
EndScript
Script PauseRecordButton ()
Var
	String sAction,
	String sMsgLong,
	String sMsgShort
Let sAction = GetAction ()
TypeKey (Gw_ks_PauseRecordButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
If (StringContains(sAction, S_ACTION_PAUSE)) Then
	Let sMsgLong = ControlF7_resume
	Let sMsgShort = f7_resume_short
Else
	Let sMsgLong = ControlF7
	Let sMsgShort = f7_short
EndIf
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE, sMsgLong, sMsgShort)
endif 
Return
EndIf
EndIf
SayCurrentScriptKeyLabel ()
EndScript
Script StopRechordButton ()
TypeKey (Gw_Ks_StopRechordButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,ControlF8,f8_short)
Endif 
EndIf
Endif
EndScript
Script RechordButton ()
Var
	String sAction,
	String sMsgLong,
	String sMsgShort
Let sAction = GetAction ()
TypeKey (Gw_ks_RechordButton)
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
If (StringContains(sAction, S_ACTION_PAUSE)) Then
	Let sMsgLong = ControlF7_resume
	Let sMsgShort = f7_resume_short   ; resume
Else
	Let sMsgLong = ControlF9
	Let sMsgShort = ControlF9_short
EndIf
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE, sMsgLong, sMsgShort)
endif 
Return
EndIf
EndIf
EndScript
Script MoveStartMarkerLeft ()
if not inmainWindow ()then 
if InControlWindow ()then 
toggelControlWindow ()
let wasControl = true 
else let wascontrol = false 
EndIf
if InSoundWindow ()then
TypeKey (Gw_ks_MoveStartMarkerLeft)
Pause ()
WasInControl ()
if markersOn () then 
ReadStartMarker ()
endif 
Else
PerformScript SelectPriorCharacter()
EndIf
EndIf
EndScript
Script MoveStartMarkerRight ()
if not inmainWindow ()then 
If InControlWindow () Then 
toggelControlWindow ()
let wasControl = true 
else let wascontrol = false 
EndIf
if InSoundWindow ()Then
TypeKey (gw_ks_MoveStartMarkerRight)
pause ()
WasInControl ()
if markersOn () then 
ReadStartMarker ()
endif
else 
PerformScript SelectNextCharacter()
EndIf
EndIf
EndScript


Script startMarkerFordward ()
if InSoundWindow () then 
SpeechOff ()
SaveCursor ()
PCCursor ()
JAWSPageDown ()
Pause ()
PerformScript ContextMenu()
{s}
pause ()
SpeechOn ()
if markersOn () then 
PerformScript sayStartMarkerLocation()
endif 
endif 
EndScript

Script moveStartmarkerBack ()
if InSoundWindow () then 
SpeechOff ()
SaveCursor ()
PCCursor ()
JAWSPageUp ()
Pause ()
PerformScript ContextMenu()
{s}
pause ()
SpeechOn ()
if markersOn () then 
PerformScript sayStartMarkerLocation()
endif 
endif 
EndScript

Script JawsPageUp ()
;some line of codes by Jitendra, to say the TFaders found on the control window.
if not UserBufferIsActive () && GetWindowClass (GetFocus ())== "TFader" then 
JAWSPageUp ()
Pause ()
PerformScript SayWindowPromptAndText()
Elif IsPCCursor () then 
if InSoundWindow () then 
JawsPageUp ()
;TypeKey (Gw_ks_PlayFromHere)
else 
PerformScript JAWSPageUp()
endif 
else 
PerformScript JAWSPageUp()
endif 
EndScript
Script jawsPageDown ()
;some line of codes by Jitendra, to say the TFaders found on the control window.
if not UserBufferIsActive () && GetWindowClass (GetFocus ())== "TFader" then 
JAWSPageDown ()
Pause ()
PerformScript SayWindowPromptAndText()
Elif IsPCCursor () then 
if InSoundWindow () then 
JAWSPageDown ()
;TypeKey (Gw_Ks_playFromHere)
else 
PerformScript JAWSPageDown()
endif 
else 
PerformScript JAWSPageDown()
endif 
EndScript

Script MoveFinishMarkerLeft ()
if not inmainWindow ()then 
If InControlWindow () Then 
toggelControlWindow ()
let wasControl = true 
else let wascontrol = false 
EndIf
if InSoundWindow ()Then
TypeKey (Gw_ks_MoveFinishMarkerLeft)
Pause ()
WasInControl ()
if markersOn () then 
ReadFinishMarker ()
endif 
Else 
PerformScript SelectPriorWord()
EndIf
EndIf
EndScript

Script MoveFinishMarkerRight ()
if not inmainWindow ()then 
If InControlWindow () Then  toggelControlWindow ()
let wasControl = true 
else let wascontrol = false 
EndIf
if InSoundWindow ()Then
TypeKey (Gw_ks_MoveFinishMarkerRight)
Pause () WasInControl ()
if markersOn () then 
ReadFinishMarker ()
endif 
else 
PerformScript SelectNextWord()
EndIf
EndIf
EndScript

Script MemorizeMarkers ()
if not inmainWindow ()then 
TypeKey (Gw_ks_MemorizeMarkers)
if InSoundWindow ()||InControlWindow ()Then
if LablesOn ()then
SayFormattedMessage (ot_no_disable,ShiftM,ShiftM_short)
endif
EndIf 
EndIf
EndScript
Script RecallMarkers ()
if not inmainWindow ()then 
TypeKey (Gw_ks_RecallMarkers)
if InSoundWindow ()||InControlWindow ()Then
if LablesOn () then 
SayFormattedMessage (ot_no_disable, ShiftR, ShiftR_short)
endif
Pause ()
if markersOn () then 
ReadStartMarker ()ReadFinishMarker ()
endif
EndIf
EndIf
EndScript
Script SetMarkers ()
if not inmainWindow ()then 
TypeKey (Gw_ks_SetMarkers)
EndIf
EndScript
Script CopySelectedTextToClipboard  ()
		Var
	String sTemp
if not inmainWindow ()then 
if InControlWindow ()||InSoundWindow ()then 
TypeKey (Gw_Ks_CopySoundToClipboard)
Let sTemp = GetFirstStatusLine ()
Let StatusText = StringSegment(sTemp, " ", 3)
Let StatusText2 = StringSegment(sTemp, " ", 5)
if StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,ControlC,controlC_short)
else 
SayFormattedMessage (ot_error,NothingSelected)
EndIf 
else 
PerformScript CopySelectedTextToClipboard () EndIf 
EndIf
EndScript
Script CutToClipboard ()
Var
	String sTemp
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (Gw_ks_CutToClipboard)
Let sTemp = GetFirstStatusLine ()
Let StatusText = StringSegment(sTemp, " ", 3)
Let StatusText2 = StringSegment(sTemp, " ", 5)
if StatusText!= StatusText2 Then 
SayFormattedMessage (OT_status,ControlX,controlx_short)
else 
SayFormattedMessage (ot_error,NothingSelected)
EndIf
else 
PerformScript CutToClipboard()
EndIf 
EndIf
EndScript
Script PasteSoundToBeginningOfFile ()
if not inmainWindow ()then
if InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime()
TypeKey (Gw_ks_PasteSoundToBeginningOfFile)
Pause ()
Let StatusText2 = GetTotalTime ()
if StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,ControlB,ControlV_short)
Else 
SayFormattedMessage (OT_error,nothingInClipboard)
EndIf
endIf EndIf
EndScript
Script PasteSoundTOEndOfFile ()
if not inmainWindow ()then 
if InCuePointsDialog ()then
SpeechOff ()
typeKey ("alt+c")
Pause ()
typekey ("shift+tab")
pause ()
SpeechOn ()
typeKey ("space")
elif InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime ()
TypeKey (Gw_ks_PasteSoundTOEndOfFile)
Pause ()
Let StatusText2 = GetTotalTime ()
if StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,ControlE,controlv_short)
Else 
SayFormattedMessage (OT_error,nothingInClipboard)
Endif
EndIf
endIf 
EndScript
Script PasteSoundAtFinishMarkerLocation ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime ()
TypeKey (Gw_Ks_PasteSoundAtFinishMarkerLocation)
Pause ()
Let StatusText2 = GetTotalTime ()
if StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,ControlF,controlV_short)
Else 
SayFormattedMessage (OT_error,nothingInClipboard)
Endif
EndIf EndIf 
EndScript
Script PasteFromClipboard ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime ()
TypeKey (Gw_Ks_PasteFromClipboard)
Pause ()
Let StatusText2 = GetTotalTime ()
if StatusText !=StatusText2 Then 
SayFormattedMessage (OT_Status,ControlV,ControlV_short)
Else 
SayFormattedMessage (OT_error,nothingInClipboard)
EndIf
Else 
PerformScript PasteFromClipboard()
EndIf
EndIf 
EndScript
Script PasteNew ()
TypeKey (Gw_ks_PasteNew)
EndScript
Script JawsDelete ()
Var
	String sTemp
if not inmainWindow ()then 
if InCuePointsDialog ()then 
 TypeKey (Gw_ks_deleteSound)
TypeKey ("f4")
Elif InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime ()
TypeKey (Gw_ks_deleteSound)
Delay (10, true)
Let StatusText2 = GetTotalTime ()
if  StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,delete,Delete_short)
else 
SayFormattedMessage (ot_error,NothingSelected)
EndIf 
else 
PerformScript JawsDelete()
endIf
EndIf 
EndScript
Script DeleteUnSelectedSound ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
Let StatusText = GetTotalTime ()
TypeKey (Gw_ks_DeleteUnSelectedSound)
Delay (10, true)
Let StatusText2 = GetTotalTime ()
if StatusText != StatusText2 Then 
SayFormattedMessage (OT_status,ControlT,Delete_short)
else 
SayFormattedMessage (ot_error,NothingSelected)
EndIf
EndIf
Endif 
EndScript
Script SelectAll ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (Gw_Ks_SelectAll)
pause ()
readTotalTime ()
SayFormattedMessage (OT_status,ControlA)
elif InCuePointsDialog ()then 
SaveCursor ()
if FindString (GetRealWindow (GetFocus ()), s_autoCue, s_top, s_unrestricted) then 
LeftMouseButton ()
endif 
Else 
PerformScript SelectAll()
EndIf
EndIf 
EndScript
Script DropCue ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (Gw_Ks_DropCue)
if LablesOn ()then 
SayFormattedMessage (ot_no_disable,ControlQ,ControlQ_short)
endif
EndIf  
EndIf 
EndScript
Script DropAndEditCue ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (Gw_Ks_DropAndEditCue)
if LablesOn ()then 
SayFormattedMessage (ot_no_disable,ControlQ,ControlQ_short)
endif
EndIf  
EndIf 
EndScript
Script Redo ()
if not inmainWindow ()Then 
if InSoundWindow ()||InControlWindow ()Then
TypeKey (Gw_ks_Redo) if LablesOn () then 
SayFormattedMessage (ot_no_disable,controlY)
endif 
EndIf 
EndIf 
EndScript
Script Mix ()
if not inmainWindow ()then 
TypeKey (Gw_ks_Mix)
endIf 
EndScript
Script replace ()
If not inmainWindow ()then 
TypeKey (Gw_ks_replace)
If InControlWindow ()||InSoundWindow () then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable,ControlR)
endif
EndIf
EndIf 
EndScript
Script DeviceControlWindo ()
TypeKey (Gw_ks_DeviceControlWindo)
EndScript
Script switchSoundWindow ()
if not inmainWindow ()then 
TypeKey (Gw_ks_switchSoundWindow)
EndIf
EndScript
Script ControlProperties ()
TypeKey (Gw_ks_ControlProperties)
EndScript
Script ExitGoldWave ()
TypeKey (Gw_ks_ExitGoldWave)
EndScript
Script helpContents ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
TypeKey (Gw_ks_helpContents)
Else 
SaveCursor ()
FindString (GetRealWindow (GetFocus ()),s_Help, s_bottom, S_unRESTRICTED)
if StringContains (GetWord (), s_Help)Then 
LeftMouseButton ()
endIf 
endIf 
EndScript
;[Extra commands]
Script FormatOptions ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_FileFormats)
EndIf
EndScript
Script storageOptions ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_Storage)
EndIf
EndScript
Script saveAs ()
if not inmainWindow ()Then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_saveAs)
EndIf
EndIf 
EndScript
Script CloseAll ()
if not inmainWindow ()Then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_CloseAll)
EndIf
EndIf 
EndScript
Script saveAll ()
if not inmainWindow ()Then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_SaveAll)
EndIf
EndIf 
EndScript

Script SaveSelectionAs ()
if not inmainWindow ()then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_SaveSelectionAs)
EndIf
endif
EndScript
Script OpenFile1 ()
menuCommand (id_file1)
EndScript
Script OpenFile2 ()
menuCommand (id_file2)
EndScript
Script OpenFile3 ()
menuCommand (id_file3)
EndScript
Script OpenFile4 ()
menuCommand (id_file4)
EndScript
Script OpenFile5 ()
menuCommand (id_file5)
EndScript
Script OpenFile6 ()
menuCommand (id_file6)
EndScript
Script OpenFile7 ()
menuCommand (id_file7)
EndScript
Script openFile8 ()
menuCommand (id_file8)
EndScript
Script openFile9 ()
menuCommand (id_file9)
EndScript

Script CheckForUpdate ()

if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_CheckForUpdates)
endif 


EndScript


Script GoldWaveManual ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_manual)
EndIf
EndScript
Script GoldWaveHomePage ()
run (gw_cl_HomePage)
EndScript
Script BatchProcessing ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_BatchProcessing)
EndIf
EndScript
Script FileInformationEditor ()
if not inmainWindow ()then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_information)
EndIf
EndIf
EndScript
Script CdReader ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_CdReader )
EndIf
EndScript
Script CuePointsEditor ()
if not inmainWindow ()then 
If InControlWindow ()||InSoundWindow () then 
menuCommand (id_CuePoints)
EndIf
EndIf
EndScript
Script EffectChainEditor ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_EffectChainEditor )
EndIf 
EndIf 
EndScript
Script ExpressionEvaluator ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_ExpressionEvaluator )
EndIf
EndIf
EndScript

Script MergeFiles ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_filemerger)
endif 
EndScript

Script SpeechTool ()
if inmainwindow2 ()||InControlWindow ()||InSoundWindow ()then 
menuCommand (id_SpeechTool)
endif 



EndScript


Script Crossfade ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
TypeKey (gw_ks_crossFade)
EndIf 
EndIf 
EndScript
Script OverWrite ()
if not inmainWindow ()then 
If  InSoundWindow ()||InControlWindow () then 
TypeKey (gw_ks_OverWrite)
if LablesOn () then 
SayFormattedMessage (ot_no_disable,controlk)
endif
Endif 
Endif 
EndScript
Script InsertSilence ()
if not inmainWindow ()then
 If InControlWindow ()||InSoundWindow () then 
menuCommand (id_InsertSilence) elif InCuePointsDialog ()then
if InCuePointsDialog ()then 
SaveCursor ()
if FindString (GetRealWindow (GetFocus ()), s_autoCue, s_top, s_unrestricted)then
SetFocus (GetCurrentWindow ())
TypeKey ("tab")
TypeKey ("space")
endif
Endif
EndIf 
endif 
EndScript

Script AutoTrim ()
if not inmainWindow ()then 
If  InSoundWindow ()||InControlWindow () then 
TypeKey (GW_ks_Autotrim)
endif
endif
EndScript

Script mute ()
if not inmainWindow ()then 
If  InSoundWindow ()||InControlWindow () then 
menuCommand (id_Mute)
if LablesOn () then 
SayFormattedMessage (OT_NO_DISABLE,controlU)   
endif
Endif 
Endif
EndScript
Script VolumeChange ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Changevolume)
EndIf
EndIf 
EndScript
Script FadeIn ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_FadeIn)
EndIf 
EndIf 
EndScript
Script fadeOut ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_FadeOut )EndIf 
EndIf 
EndScript
Script volumeMaximize ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Maximize)EndIf 
Endif 
EndScript
Script volumeMatch ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Match )
endif
EndIf 
EndScript
Script VolumeShape ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Shape )EndIf 
EndIf 
EndScript
Script ChannelMix ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_ChannelMix )Endif
EndIf
EndScript
Script MaxMatch ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_MaxMatch )Endif
EndIf 
EndScript
Script pan ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_pan )Endif
EndIf
EndScript
Script ReduceVocals ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then  menuCommand (id_ReduceVocals )
Endif
EndIf
EndScript
Script equalizer ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_equalizer )
Endif
EndIf 
EndScript
Script ParametricEQ ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_ParametricEQ )
Endif
Endif 
EndScript
Script PopClick ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_PopClick )Endif
EndIf
EndScript
Script NoiseReduction ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_NoiseReduction )Endif
EndIf 
EndScript
Script BandpassStop ()
if not inmainWindow ()then 
if InSoundWindow ()||InControlWindow () then 
menuCommand (id_BandpassStop )
Endif
EndIf
EndScript
Script Smoother ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Smoother )
Endif
EndIf 
EndScript
Script LowHighpass ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_LowHighpass )Endif
Endif
EndScript
Script SilenceReduction ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_SilenceReduction )Endif endIf 
EndScript
Script Doppler ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Doppler )
EndIf 
EndIf 
EndScript
Script Dynamics ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Dynamics )EndIf 
endif
 EndScript
Script Echo ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Echo )EndIf 
Endif
EndScript
Script CompressorExpander ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_CompressorExpander )EndIf 
EndIf  EndScript
Script Flanger ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Flanger )Endif
endIf 
EndScript
Script Mechanize ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then  menuCommand (id_Mechanize )
Endif
EndIf 
EndScript
Script Offset ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Offset )Endif
EndIf
EndScript
Script Pitch ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_Pitch )Endif
EndIf
EndScript
Script GWAmp ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_GWAmp)
endif endif
EndScript

Script VoiceAutoGain ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_VoiceAutoGain)
endif 
endif
EndScript
Script voiceAutoOffsetRemoval ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_voiceAutoOffsetRemoval)
endif
endif
EndScript
Script VoiceCensor ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_VoiceCensor)
endif
endif
EndScript
Script VoiceOver ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_VoiceOver)
endif
endif
EndScript




Script Reverb ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then  menuCommand (id_Reverb )
Endif
EndIf 
EndScript
Script TimeWarp ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 

menuCommand (id_TimeWarp )Endif
EndIf
 EndScript
Script PlaybackRate ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_PlaybackRate )
Endif
EndIf
EndScript
Script Resample ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_Resample )
Endif
EndIf 
EndScript
Script reverseSound ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable,reverse)
endif
menuCommand (id_reverse)
EndIf 
EndIf 
EndScript
Script InterpolateSound ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, Interpolate)
endif 
menuCommand (id_Interpolate)
endIf 
EndIf 
EndScript
Script InvertSound ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
if LablesOn () then 
SayFormattedMessage (ot_no_disable, invert)
endif 
EndIf 
EndIf 
EndScript

Script SwitchTOWindow1 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window1)
endif 
endif
EndScript
Script switchToWindow2 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window2)
endif 
endif
EndScript
Script switchToWindow3 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window3)
endif 
endif
EndScript
Script switchToWindow4 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window4)
endif 
endif
EndScript

Script SwitchToWindow5 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window5)
endif 
endif
EndScript

Script SwitchToWindow6 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window6)
endif 
endif
EndScript

Script SwitchToWindow7 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window7)
endif 
endif
EndScript

Script switchToWindow8 ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window8)
endif 
endif
EndScript

Script SwitchToWindow9 ()

if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_window9)
endif 
endif
EndScript

Script MoreWindows ()
if not inmainWindow ()then If InControlWindow ()||InSoundWindow () then 
menuCommand (id_MoreWindows)
endif 
endif
EndScript


;[Dialogs]
Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes,
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
GetProgress ()
NewTextEvent(hWnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, sFrameName)
EndFunction
Void Function GetProgress ()
if progressOn ()  then 
If StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_progressDialog ) then
Let statustext = GetDialogStaticText ()
let statusText = StringRight (statustext, 5)
Let StatusText = stringChopLeft (statustext, 1)
let Statustext = stringChopRight (statustext, 1)
if StatusText != StatusText2 Then 
If StringContains (statustext,"0%")||StringContains (statustext,"5%") then 
let statustext2 = statustext
StopSpeech ()
saystring (statustext)
EndIf 
EndIf 
EndIf 
endif 
EndFunction

Script ContextMenu ()
var 
handle HwNd 
;we need to know if we are in the sound window. 
if InSoundWindow ()then
;If we are we need to get the handle of the sound window. 
let Hwnd = GetFocus ()
;ok now we need to move the mouse  pointer  to the top of this window. 
;ok the first thing we need to do is save the active cursor. 
SaveCursor ()
;ok now we can turn on the jaws cursor witch controls the mouse pointer. 
JAWSCursor ()
;ok now we can move the mouse pointer to the top of the sound window.
MoveTo (GetWindowLeft (hwnd), GetWindowTop (hwnd)) ;now we need to move in to a clickable zone.
NextLine ()
NextLine ()
JAWSEnd ()
;now we can click the right mouse button to open the context menu. 
RightMouseButton ()
;now we restore the active cursor.
RestoreCursor ()
;now if we were not in the sound window we need to have the script key shift f10do what it normaly would. 
else 
TypeCurrentScriptKey ()
EndIf 
EndScript
Script UpALevel ()
if StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_CdReaderDialog)||StringContains (GetWindowClass (GetRealWindow (GetFocus ())),wc_CuePointsDialog)then 
{alt+f4}
else 
PerformScript UpALevel()
EndIf 
EndScript
;[help]
Script ScriptFileName ()
if IsSameScript ()then 
SayFormattedMessage (ot_user_buffer, ScriptInformation,"" )
Else 
ScriptAndAppNames (msgScriptName)
Endif
EndScript
Script HotKeyHelp ()
If UserBufferIsActive () then
	UserBufferDeactivate ()
EndIf
if inmainwindow2 ()then 
SayFormattedMessage (ot_user_buffer, hotkeys2)
elif InControlWindow ()||InSoundWindow () then 
SayFormattedMessage (ot_user_buffer, hotkeys)
elif InCuePointsDialog ()then 
SayFormattedMessage (ot_user_buffer, cuePointsHelp)
else 
PerformScript HotKeyHelp()
EndIf
EndScript

Function autoStartEvent ()
CheckGoldWaveVersion ()
If (GWFirstTime == 0) then
Let GWFirstTime = 1
SayFormattedMessage (	OT_APP_START, HotKeyHelpMsg)
EndIf 
EndFunction
Int Function HandleCustomWindows ()
if StringContains (GetWindowClass (GetFocus ()), "Frame")then
return true 
endif
IF GetCurrentControlID () == 	ID_PRESETS_EDIT||GetWindowClass (GetFocus ()) == WC_TComboBox THEN 
SayString (GetGroupBoxName ())
SayString (GetWindowName (GetFocus ()))
SayString (GetWindowType (GetFocus ()))
SayString (GetWindowText (GetFocus ( ), TRUE))
return TRUE 
ELIF GetWindowClass (GetFocus ()) == 	Wc_TNumEdit  THEN 
SayString (GetGroupBoxName ())
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
SetRestriction (RestrictRealWindow )
JAWSHome ()
SayString (GetWindowText (GetCurrentWindow (), FALSE))
SayString (GetWindowType (GetFocus ()))
SayString (GetWindowText (GetFocus ( ), TRUE))
RETURN TRUE 
elif GetAppTitle ()==s_Control_Properties&&GetWindowClass (GetFocus ())==wc_TCheck&&GetField ()==s_Select then 
SaveCursor ()
InvisibleCursor ()
SetRestriction ( RestrictAppWindow)
RouteInvisibleToPc ()
JAWSHome ()
SayWindow (GetCurrentWindow (), 0)
PCCursor ()
RestoreCursor ()
return false 
ElIf InSoundWindow () then
ReadOpenFile()
return true 
elIf StringContains (GetWindowClass (GetFocus ()), wc_main)then 
SayFormattedMessage (ot_error, NoFile, NoFile_short)
return true  
elif GetWindowClass (GetFocus ()) == "TFader" then 
SaveCursor ()
InvisibleCursor ()
SaveCursor ()
RouteInvisibleToPc ()
SetRestriction ( RestrictAppWindow)
NextLine ()
SayString (GetLine ())
RestoreCursor ()
return true 
else 
return false 
EndIf 
EndFunction

Script sayNextLine ()
if GetWindowClass (GetFocus ()) == "TFader" then 
if IsPCCursor ()then 
SaveCursor ()
PCCursor ()
NextLine ()
InvisibleCursor ()
RouteInvisibleToPc ()
SetRestriction (RestrictRealWindow )
NextLine ()
SayString (GetLine ())
RestoreCursor ()
else 
PerformScript SayNextLine()
endif 
else 
PerformScript SayNextLine()
endif 
EndScript
Script SayPriorLine ()
if GetWindowClass (GetFocus ()) == "TFader" then 
if IsPCCursor ()then 
SaveCursor ()
PriorLine ()
InvisibleCursor ()
RouteInvisibleToPc ()
SetRestriction (RestrictRealWindow )
NextLine ()
SayString (GetLine ())
RestoreCursor ()
else 
PerformScript SayPriorLine()
endif 
else 
PerformScript SayPriorLine()
endif 
EndScript
Script  SayPriorCharacter()
if GetWindowClass (GetFocus ()) == "TFader" then 
if IsPCCursor ()then 
PriorCharacter ()
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
SetRestriction (RestrictRealWindow )
NextLine ()
SayString (GetLine ())
RestoreCursor ()
else 
PerformScript SayPriorCharacter()
endif 
else 
PerformScript SayPriorCharacter()
endif 
EndScript
Script  SayNextCharacter()
if GetWindowClass (GetFocus ()) == "TFader" then 
if IsPCCursor ()then 
NextCharacter ()
SaveCursor ()
InvisibleCursor ()
RouteInvisibleToPc ()
SetRestriction (RestrictRealWindow )
NextLine ()
SayString (GetLine ())
RestoreCursor ()
else 
PerformScript SayNextCharacter()
endif 
else 
PerformScript SayNextCharacter()
endif 
EndScript





