;GoldWave V4.26 scripts
;version 2.0
;author: Jim Bauer
;released July, 2004

include "HJGlobal.jsh"
include "HJConst.jsh"
include "common.jsm"
include "GoldWave.jsh"
include "GoldWave.jsm"



Function AutoGraphicsLabelerHelper(int nLeft,int nTop,int nRight,int nBottom)
var
	Int iX,
	Int iY,
	int nGraphicIdNoMouseOnIt,
	int nGraphicIdWithMouseOnIt,
	int nLoops,
	int nAttributes,
	String strLabel,
	String strGraphicName,
	String strTemp
InvisibleCursor()
let iX = nLeft+(nRight-nLeft)/2
let iY = nTop+(nBottom-nTop)/2
MoveTo (iX, iY)
let nGraphicIdNoMouseOnIt = GetGraphicID()
JawsCursor()
RouteJawsToInvisible()
let nLoops  = 0
while (nLoops < 15 && strLastTooltip == "")
	delay(1)
	let nLoops = nLoops+1
EndWhile
If (strLastTooltip != "") then
	let strLabel = strLastTooltip
	let nGraphicIdWithMouseOnIt = GetGraphicID()
	if (nGraphicIdWithMouseOnIt) then
		let nAttributes = GetControlAttributes()
			if (nAttributes & CTRL_GRAYED) then
				let strLabel = strLabel + cScSpace +cmsgGrayedGraphic1_L
			endIf
			if (nAttributes & CTRL_PRESSED) then
				let strLabel = strLabel + cScSpace +cmsgPressedGraphic1_L
			endIf
if (StrLabel == "Change") then
let StrLabel = sc_change
EndIf
			SetGraphicLabel(nGraphicIdWithMouseOnIt, strLabel, TRUE)
			if (nGraphicIdWithMouseOnIt != nGraphicIdNoMouseOnIt &&
			nGraphicIdNoMouseOnIt != 0) then
				SetGraphicLabel(nGraphicIdNoMouseOnIt,strLabel, TRUE)
			endIf
			let g_AutoLabeledGraphics = g_AutoLabeledGraphics+1
		endIf
	endIf
;RestoreCursor() ; No longer needed.
let strLastTooltip = ""
Delay(2)
if (IsKeyWaiting ())  then
	return 0
else
	return 1
endIf
EndFunction




Script AutoLabelGraphics ()
var
	int bProcessTooltipEvent,
	int nIncludeGraphics,
	string sMessageLong,
	string sMessageShort,
	string sLabeled
;cmsg242_L = "Starting auto graphic labeler"
SayFormattedMessage (ot_status, cmsg242_L, cmsg242_S)
Delay(2)
Refresh() 
Delay(10)
SaveCursor()
JawsCursor()
MoveTo(1,1)
let strLastTooltip = cScNull
let bProcessTooltipEvent = GetJcfOption (OPT_PROCESSTOOLTIPEVENT)
let nIncludeGraphics = GetJcfOption(OPT_INCLUDE_GRAPHICS)
SetJcfOption (OPT_PROCESSTOOLTIPEVENT, TRUE)
SetJcfOption (OPT_INCLUDE_GRAPHICS, 2)
let g_AutoLabeledGraphics = 0
GraphicsEnumerate(GetAppMainWindow(GetFocus()),"AutoGraphicsLabelerHelper")
SetJcfOption (OPT_PROCESSTOOLTIPEVENT, bProcessTooltipEvent)
SetJcfOption (OPT_INCLUDE_GRAPHICS, nIncludeGraphics)
RestoreCursor()
;cmsg243_L = "Auto labeler finished"
let sLabeled = IntToString (g_AutoLabeledGraphics)
let sMessageShort = FormatString (cmsg243_S, sLabeled)
let sMessageLong = FormatString (cmsg243_L, sLabeled)
SayFormattedMessage (ot_status, sMessageLong, sMessageShort)
EndScript



HANDLE Function FindGWMainWindow ()
var
handle grip,
handle HNull
let grip = GetTopLevelWindow (GetFocus ())
let grip = FindDescendantWindow (grip, GoldWave_MWCid)
if ((grip)
&& (GetWindowSubtypeCode (grip) == GoldWave_MWStc)
&& (GetWindowClass (grip) == GoldWave_MWClass)) then
return (grip)
else
return (HNull)
EndIf
EndFunction




int function isKeyDown(string keyName)
;Returns true if the given key is being held down.
;Author: Doug Lee, chatterbox scripts
var
	int isDown, int isOn
if !getKeyState(keyName, isDown, isOn) then
	return False
endIf
return isDown
endFunction



Void Function GraphicsInitialize ()
Refresh (1);force the refresh
EndFunction



Int Function GetDelimiterCount (string text, string delim)
var
int c,
int i
if ((StringContains (text, delim) == 0)
|| (StringLength (delim) > 1)) then
return (0)
EndIf
while (text)
let i = StringContains (text, delim)
if (i) then
let c = c + 1
let text = stringChopLeft (text, i)
else
let text = ""
EndIf
EndWhile
return (c)
EndFunction



Int Function IsFileLoaded ()
var
handle grip
let grip = FindGWMainWindow ()
if (grip) then
return ((GetFirstChild (grip) != 0)
&& (FindDescendantWindow (grip, 32001) != 0))
EndIf
return (0)
EndFunction



Int Function IsFilePlaying ()
var
handle grip
let grip = FindDescendantWindow (GetParent (FindGWMainWindow ()), 32040)
if (grip) then
return ((IsFileLoaded ())
&& (StringContains (StringSegment (GetWindowText (grip, 0), " ", 2), "Zoom") == 0))
EndIf
return (0)
EndFunction



String Function ExtractTimePortion ()
var
handle grip,
int i,
string m
if (IsFileLoaded () == 0) then
return ("")
EndIf
let grip = GetParent (FindGWMainWindow ())
if (grip) then
let grip = FindDescendantWindow (grip, 424)
if ((grip)
&& (GetControlID (GetPriorWindow (grip)) == 32040)) then
let m = GetWindowText (grip, 0)
let m = stringChopLeft (m, (StringContains (m, "Hz")+2))
let i = 1
while (StringContains (SubString (m, i, 1), " ")== 0)
let i = i + 1
EndWhile
let m = StringLeft (m, i -1)
return (m)
else;didn't find the right window
return ("")
EndIf
else;didn't find main window's parent
return ("")
EndIf
EndFunction



String Function GetStartMarkerPosition ()
var
handle grip,
int i,
int l,
string s,
string t
let grip = GetTopLevelWindow (GetFocus ())
let grip = FindDescendantWindow (grip, 424)
if (grip) then
let t = GetWindowText (grip, 0)
let s = StringLeft (t, StringContains (t, " to")-1)
let l = StringLength (s)
let i = l
while ((StringContains (SubString (s, i, 1), " ") == 0)
&& (i > 0))
let i = i - 1

EndWhile
if (i > 0) then
return (convertTime (SubString (s, i + 1, l - i)))
EndIf
EndIf
return ("")
EndFunction



String Function GetFinishMarkerPosition ()
var
handle grip,
string s,
string t,
int i,
int l
let grip = GetTopLevelWindow (GetFocus ())
let grip = FindDescendantWindow (grip, 424)
if (grip) then
let t = GetWindowText (grip, 0)
let i = (StringContains (t, "to") + 2)
let s = StringTrimLeadingBlanks (stringChopLeft (t, i))
let l = StringLength (s)
let i = 1
while ((StringContains (SubString (s, i, 1), " ") == 0)
&& (i <= l))
let i = i + 1
EndWhile
return (convertTime (StringLeft (s, i -1)))
EndIf
return ("")
EndFunction



String Function convertTime (string str)
var
string s,
int i,
int n
let i = StringContains (str, ".")
if (i) then
if (precision == 0) then
let str = SubString (str, 1, i -1)
elif (precision < 3) then
let str = SubString (str, 1, i + precision)
EndIf
let n = StringContains (str, ":")
if (n) then
let s = SubString (str, 1, n -1)
let str = stringChopLeft (str, n)
if (StringContains (str, ":")) then
if (StringContains (s, "0") == 1) then
let s = stringChopLeft (s, 1)
EndIf
if (StringContains (str, "0") == 1) then
let str = stringChopLeft (str, 1)
EndIf
let s = s + " hours " + SubString (str, 1, (StringContains (str, ":")-1))+ " minutes "
let str = stringChopLeft (str, StringContains (str, ":"))
if (StringContains (str, "0") == 1) then
let str = stringChopLeft (str, 1)
EndIf
let s = s + str + " seconds"
else;only minutes
if (StringContains (s, "0") == 1) then
let s = StringChopLeft (s, 1)
EndIf
if (StringContains (str, "0") == 1) then
let str = StringChopLeft (str, 1)
EndIf
let s = s + " minutes " + str + " seconds"
EndIf
else; only seconds
if (StringContains (str, "0") == 1) then
let str = StringChopLeft (str, 1)
EndIf
let s = str + " seconds"
EndIf
return (s)
else;no period character
return ("")
EndIf
EndFunction



Script SpeakTotalTime ()
var
string time
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let time = convertTime (ExtractTimePortion ())
if (time) then
let time = "Total time: " + time
else
let time = "Couldn't obtain file time."
EndIf
SayUsingVoice (VCTX_Message, time, OT_STRING)
EndScript



Script TogglePrecision ()
if (precision == 3) then
let precision = 0
else
let precision = precision + 1
EndIf
SayInteger (precision)
IniWriteInteger ("General", "Precision", precision, "GoldWave.jsi")
EndScript



Void Function SayElapsedTime ()
var
handle grip,
string s
if (IsFilePlaying () == 0) then
Say (MsgNoFilePlaying, OT_ERROR)
return
EndIf
let grip = FindDescendantWindow (GetParent (FindGWMainWindow ()), 32040)
if ((grip)
&& (GetControlID (grip) == 32040)) then
let s = GetWindowText (grip, 0)
if ((StringContains (s, "Stereo"))
|| (StringContains (s, "Mono"))) then
let s = convertTime (StringSegment (s, " ", 2))
if (StringContains (s, "seconds")) then
SayUsingVoice (VCTX_Message, s, OT_STRING)
EndIf
EndIf
EndIf
EndFunction



Void Function SayRemainingTime ()
var
handle grip,
string s,
string m,
string SMessage,
int c,
int n,
int hours,
int minutes,
int seconds,
int ElapsedHours,
int ElapsedMinutes,
int ElapsedSeconds,
int TotalSeconds,
int TotalElapsedSeconds,
int TotalRemainingSeconds, ;last 3 vars are for converting hours, minutes and seconds into
;seconds
int count ;counter variable
if (IsFilePlaying () == 0) then
Say (MsgNoFilePlaying, OT_ERROR)
return
EndIf
let grip = FindDescendantWindow (GetParent (FindGWMainWindow ()), 32040)
if (grip) then
let s = ExtractTimePortion ()
let m = StringSegment (GetWindowText (grip, 0), " ", 2)
let c = GetDelimiterCount (s, ":")
let n = GetDelimiterCount (m, ":")
if (c == 2) then
let hours = StringToInt (StringSegment (s, ":", 1))
let minutes = StringToInt (StringSegment (s, ":", 2))
let s = StringSegment (s, ":", 3)
let seconds = StringToInt (stringChopRight (s, StringContains (s, ".")))
elif (c == 1) then
let hours = 0
let minutes = StringToInt (StringSegment (s, ":", 1))
let s = StringSegment (s, ":", 2)
let seconds = StringToInt (stringChopRight (s, StringContains (s, ".")))
EndIf
if (n == 2) then
let ElapsedHours = StringToInt (StringSegment (m, ":", 1))
let ElapsedMinutes = StringToInt (StringSegment (m, ":", 2))
let m = StringSegment (m, ":", 3)
let ElapsedSeconds = StringToInt (stringChopRight (m, StringContains (m,".")))
elif (n == 1) then
let ElapsedHours = 0
let ElapsedMinutes = StringToInt (StringSegment (m, ":", 1))
let m = StringSegment (m, ":", 2)
let ElapsedSeconds = StringToInt (stringChopRight (m, StringContains (m,".")))
EndIf
if ((!seconds)
|| (!ElapsedSeconds)) then
let seconds = StringToInt (s)
let ElapsedSeconds = StringToInt (m)
EndIf
let TotalSeconds = seconds+(minutes*60)+(hours*3600)
let TotalElapsedSeconds=ElapsedSeconds+(60*ElapsedMinutes)+(3600*ElapsedHours)
let TotalRemainingSeconds=TotalSeconds-TotalElapsedSeconds
let hours=TotalRemainingSeconds/3600
let count=TotalRemainingSeconds-(hours*3600)
let minutes=count/60
let count=count-(minutes*60)
let seconds=count
if (hours > 0) then
let SMessage = SMessage + IntToString(hours) +" hour"
if (hours > 1) then let SMessage = SMessage + "s"
EndIf
let SMessage = SMessage + ", "
EndIf
if (minutes > 0) then
let SMessage = SMessage + IntToString(minutes) +" minute"
if (minutes > 1) then let SMessage = SMessage + "s"
EndIf
let SMessage = SMessage + ", "
EndIf
let SMessage = SMessage + IntToString(seconds) +" second"
if (seconds != 1) then let SMessage = SMessage + "s"
EndIf
let SMessage = SMessage + " remaining"
SayUsingVoice (VCTX_MESSAGE, SMessage, OT_STRING)
EndIf
EndFunction



Void Function SayStartMarkerPosition ()
if (IsFileLoaded () == 0) then
say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
SayUsingVoice (vctx_message, GetStartMarkerPosition (), OT_STRING)
EndFunction



Void Function SayFinishMarkerPosition ()
if (IsFileLoaded () == 0) then
say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
SayUsingVoice (vctx_message, GetFinishMarkerPosition (), OT_STRING)
EndFunction




Script SpeakTime ()
if (TimeAnnounceMode == mode_elapsed) then
SayElapsedTime ()
elif (TimeAnnounceMode == mode_remaining) then
SayRemainingTime ()
elif (TimeAnnounceMode == mode_StartMarker) then
SayStartMarkerPosition ()
elif (TimeAnnounceMode == mode_FinishMarker) then
SayFinishMarkerPosition ()
else
LoadStartupValues ()
EndIf
EndScript



Void Function LoadStartupValues ()
var
int x,
int y,
int z
let x = IniReadInteger ("General", "precision", -1, "GoldWave.jsi")
let y = IniReadInteger ("General", "TimeAnnounceMode", -1, "GoldWave.jsi")
let z = IniReadInteger ("General", "AutoAnnounceMarkers", -1, "GoldWave.jsi")
if ((x != -1)
|| (y != -1)
|| (z != -1)) then
let precision = x
let TimeAnnounceMode = y
let AutoAnnounceMarkers = z
else
let precision = 0
let TimeAnnounceMode = 0
let AutoAnnounceMarkers = 0
IniWriteInteger ("General", "precision", precision, "GoldWave.jsi")
IniWriteInteger ("General", "TimeAnnounceMode", TimeAnnounceMode, "GoldWave.jsi")
IniWriteInteger ("General", "AutoAnnounceMarkers", AutoAnnounceMarkers, "GoldWave.jsi")
EndIf
EndFunction



Script ToggleTimeAnnounceMode ()
if (TimeAnnounceMode == mode_FinishMarker) then
let TimeAnnounceMode = mode_elapsed
else
let TimeAnnounceMode = TimeAnnounceMode + 1
EndIf
if (TimeAnnounceMode == mode_elapsed) then
SayUsingVoice (vctx_message, MsgElapsed, OT_STRING)
elif (TimeAnnounceMode == mode_remaining) then
SayUsingVoice (vctx_message, MsgRemaining, OT_STRING)
elif (TimeAnnounceMode == mode_StartMarker) then
SayUsingVoice (vctx_message, MsgStartMarker, OT_STRING)
elif (TimeAnnounceMode == mode_FinishMarker) then
SayUsingVoice (vctx_message, MsgFinishMarker, OT_STRING)
EndIf
IniWriteInteger ("General", "TimeAnnounceMode", TimeAnnounceMode, "GoldWave.jsi")
EndScript



Script ToggleAutoMarkerAnnounce ()
let AutoAnnounceMarkers = 1 - AutoAnnounceMarkers
if (AutoAnnounceMarkers) then
SayUsingVoice (vctx_message, MsgAutoMarkerAnnounceOn, OT_STRING)
else
SayUsingVoice (vctx_message, MsgAutoMarkerAnnounceOff, OT_STRING)
EndIf		
IniWriteInteger ("General", "AutoAnnounceMarkers", AutoAnnounceMarkers, "GoldWave.jsi")
EndScript



Void Function AutoStartEvent ()
LoadStartupValues ()
EndFunction



;--Skimming support, 02/21/05
void function skim ()
;Starts or continues skimming thru the currently playing file.
var
string keyName
let keyName = stringSegment (cks29+"|"+cks30, "|", skimCallingScript)
let keyName = "shift+"+keyName
typeKey (keyName)
reactivatePlay ()
EndFunction

void function reactivatePlay ()
;Resumes play after the start marker has been moved by the last skim call.
typeKey ("f4")
if isKeyDown (stringSegment (cks29+"|"+cks30, "|", skimCallingScript)) then
let skimID = scheduleFunction ("skim", 0)
else
unscheduleFunction (skimID)
let skimID = 0
let skimCallingScript = 0
let skimInProgress = false
EndIf
EndFunction



script rightArrow ()
if skimInProgress then
return
EndIf
if isFilePlaying () && !userBufferIsActive () && !inHjDialog () && !dialogActive () && !menusActive () then
let skimCallingScript = 1
let skimInProgress = true
skim ()
return
EndIf
performScript sayNextCharacter ()
EndScript



script leftArrow ()
if skimInProgress then
return
EndIf
if isFilePlaying () && !userBufferIsActive () && !inHjDialog () && !dialogActive () && !menusActive () then
let skimCallingScript = 2
let skimInProgress = true
skim ()
return
EndIf
performScript sayPriorCharacter ()
EndScript



String Function MakeReport ()
var
handle grip,
handle h,
string temp,
string m,
string s
let grip = GetParent (FindGWMainWindow ())
let h = GetFirstChild (FindGWMainWindow ())
if (grip) then
let grip = FindDescendantWindow (grip, 424)
if (grip) then
let m = GetWindowText (grip, 0)
let temp = StringLeft (m, StringContains (m, "Hz")+1)
let s = "File: " + GetWindowName (h) + "\r\n"
let s = s + "Sampling Rate: " + temp + "\r\n"
let s = s + "Total Time: " + convertTime (ExtractTimePortion ()) + "\r\n"
let temp = StringTrimLeadingBlanks (StringSegment (m, ")", 2))
let s = s + "Other Info: " + temp + "\r\n"
return (s)
else
return ("")
EndIf
return ("")
EndIf
EndFunction



Void Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
handle grip,
handle OkButton,
string s
if (FocusWindow == FindGWMainWindow ()) then
if (IsFileLoaded () == 0) then
SayWindowTypeAndText (GetAppMainWindow (FocusWindow))
SayUsingVoice (VCTX_Message, MsgNoFileLoaded, OT_STRING)
return
EndIf
elif (GetWindowClass (FocusWindow) == "GWVIEWAMP") then
if (MenusActive () == 0) then
FocusChangedEvent (FocusWindow, PrevWindow)
ScheduleFunction ("GraphicsInitialize", 3)
EndIf
return
elif (StringContains (stringLower (GetWindowName (getParent (focusWindow))), "volume")) then
let OkButton = FindDescendantWindow (GetRealWindow (FocusWindow), 1)
let grip = FindDescendantWindow (GetRealWindow (FocusWindow), 224)
if (GetWindowSubtypeCode (FocusWindow) == 20) then
if (ControlIsChecked ()) then
let s = MsgChecked
else
let s = MsgUnchecked
EndIf
if (GetJfwVersion () >= 500000) then
SayControlExWithMarkup (FocusWindow, GetWindowName (GetPriorWindow (FocusWindow)), "", s)
else
SayControlInformation (GetWindowName (GetPriorWindow (FocusWindow)), MsgCheckbox, s)
EndIf
elif (GetWindowClass (FocusWindow) == "XdblcksTip321") then
if (PrevWindow == grip) then
SetFocus (OKButton)
else
SetFocus (grip)
EndIf
else;focused on a button, just say type and text
SayWindowTypeAndText (FocusWindow)
EndIf
return
else
FocusChangedEvent (FocusWindow, PrevWindow)
EndIf
EndFunction



Script SpeakFileInformation ()
var
handle grip
let grip = GetFocus ()
if ((GetWindowClass (grip) == "GWVIEWAMP")
&& (IsFileLoaded ())) then
SayUsingVoice (VCTX_Message, MakeReport (), OT_STRING)
else
Say (MsgNoFileLoaded, OT_ERROR)
EndIf
EndScript



Void Function RunGWManual ()
var
object IExplorer,
object Null,
string s
let s = StringChopRight (GetAppFilePath (), 3) + "htm"
let IExplorer = CreateObject ("InternetExplorer.application")
if (!IExplorer) then
let IExplorer = CreateObjectEx ("InternetExplorer.application", 0)
if (!IExplorer) then
return
EndIf
EndIf
IExplorer.navigate (s)
delay (5)
let IExplorer.visible = true
let IExplorer = Null
EndFunction



Script ToggleSelectedChannel ()
var
handle grip,
string s
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (GetTopLevelWindow (GetFocus ()), sc_channel_toggle, s_top, s_unrestricted)) then
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
let grip = FindDescendantWindow (GetParent (FindGWMainWindow ()), 32040)
if (grip) then
let s = GetWindowText (grip, 0)
if (StringContains (s, "Left")) then
SayUsingVoice (VCTX_Message, MsgLeftChannel, OT_STRING)
elif (StringContains (s, "Right")) then
SayUsingVoice (VCTX_Message, MsgRightChannel, OT_STRING)
else
SayUsingVoice (VCTX_Message, MsgBothChannels, OT_STRING)
EndIf
EndIf
EndIf
EndScript



Script FadeIn ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_FadeIn, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
EndIf
EndScript



Script FadeOut ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_FadeOut, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
EndIf
EndScript



Script ParametricEq ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_parametric_eq, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script equalizer ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_equalizer, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script echo ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_echo, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script LowHighpass ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_LowHighpass, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script reverse ()
var
handle grip
if (IsFileLoaded () == 0) then
Say (MsgNoFileLoaded, OT_ERROR)
return
EndIf
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_reverse, s_top, s_unrestricted)) then
Say (sc_reverse, OT_STATUS)
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script SaveSelectionAs ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_save_selection_as, s_top, s_unrestricted)) then
say (sc_save_selection_as, OT_STATUS)
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
EndIf
EndScript



Script BandPassStop ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_BandPass_stop, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
EndIf
EndScript



Script pan ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_pan, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
EndIf
EndScript



Script NoiseGate ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_noise_gate, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
Pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script NoiseReduction ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_noise_reduction, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
Pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script exchange ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_exchange, s_top, s_unrestricted)) then
say (sc_exchange, OT_STATUS)
LeftMouseButton ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script silence ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_silence, s_top, s_unrestricted)) then
say (sc_silence, OT_STATUS)
LeftMouseButton ()
RestoreCursor ()
RestoreCursor ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script ChangeVolume ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_change, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
Pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script flange ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_flange, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
Pause ()
RestoreCursor ()
RestoreCursor ()
SpeechOn ()
else
say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script CuePoints ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_CuePoints, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script ExpressionEvaluator ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_ExpressionEvaluator, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script pitch ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_pitch, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script mechanize ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_mechanize, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script offset ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_offset, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script doppler ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_doppler, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script dynamics ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_dynamics, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script TimeWarp ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_TimeWarp, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script maximize ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_maximize, s_top, s_unrestricted)) then
say (sc_maximize, OT_STATUS)
LeftMouseButton ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script shape ()
var
handle grip
let grip = GetTopLevelWindow (GetFocus ())
SaveCursor ()
JawsCursor ()
SaveCursor ()
if (FindGraphic (grip, sc_shape, s_top, s_unrestricted)) then
SpeechOff ()
LeftMouseButton ()
pause ()
SpeechOn ()
RestoreCursor ()
RestoreCursor ()
else
Say (MsgNotFound, OT_ERROR)
RestoreCursor ()
RestoreCursor ()
EndIf
EndScript



Script MoveStartMarkerLeft ()
TypeCurrentScriptKey ()
pause ()
if (GetVerbosity () != advanced) then
say (MsgMarkerLeft, OT_STATUS)
EndIf
SayStartMarkerPosition ()
EndScript



Script MoveStartMarkerRight ()
TypeCurrentScriptKey ()
pause ()
if (GetVerbosity () != advanced) then
say (MsgMarkerRight, OT_STATUS)
EndIf
SayStartMarkerPosition ()
EndScript



Script MoveFinishMarkerLeft ()
TypeCurrentScriptKey ()
pause ()

if (GetVerbosity () != advanced) then
say (MsgMarkerLeft, OT_STATUS)
EndIf
SayFinishMarkerPosition ()
EndScript



Script MoveFinishMarkerRight ()
TypeCurrentScriptKey ()
pause ()
if (GetVerbosity () != advanced) then
say (MsgMarkerRight, OT_STATUS)
EndIf
SayFinishMarkerPosition ()
EndScript



Script DropStartMarker ()
TypeCurrentScriptKey ()
pause ()
if (AutoAnnounceMarkers == 0) then
return
EndIf
if (GetVerbosity () != advanced) then
say (MsgStartMarker + " dropped.", OT_STATUS)
EndIf
SayStartMarkerPosition ()
EndScript



Script DropFinishMarker ()
TypeCurrentScriptKey ()
pause ()
if (AutoAnnounceMarkers == 0) then
return
EndIf
if (GetVerbosity () != advanced) then
say (MsgFinishMarker + " dropped.", OT_STATUS)
EndIf
SayFinishMarkerPosition ()
EndScript



Int Function WhatWindowIsThis (handle HWindow)
var
string name
if (HWindow == FindGWMainWindow ()) then
SayMessage (OT_HELP, MsgSshMW_l, MsgSshMW_s)
return (1)
elif (GetWindowClass (HWindow) == "GWVIEWAMP") then
SayMessage (OT_HELP, MsgSshActiveFile_l, FormatString (MsgSshActiveFile_s, GetWindowName (GetRealWindow (HWindow))))
return (1)
elif (StringContains (GetWindowName (GetRealWindow (HWindow)), "Device Controls Properties")) then
let name = GetWindowName (HWindow)
if (StringContains (GetDialogPageName (), "Play")) then
if (GetWindowType (HWindow) == "radio button") then
if (name == "All") then
Say (MsgSshPlayAll, OT_HELP)
return (1)
elif (name == "Selection") then
say (MsgSshPlaySelection, OT_HELP)
return (1)
elif (name == "Unselected") then
say (MsgSshPlayUnselected, OT_HELP)
return (1)
elif (name == "View") then
say (MsgSshPlayView, OT_HELP)
return (1)
elif (name == "Finish") then
say (MsgSshPlayFinish, OT_HELP)
return (1)
elif (name == "Intro/loop/end") then
say (MsgSshPlayIntroLoopEnd, OT_HELP)
return (1)
EndIf;elif case on radio button names
elif (GetWindowType (HWindow) == "Edit") then
if (GetWindowName (GetPriorWindow (HWindow)) == "Loop") then
say (MsgSshPlayLoop, OT_HELP)
return (1)
elif (name == "Fast:") then
say (MsgSshPlayFastForward, OT_HELP)
return (1)
elif (name == "Rewind:") then
say (MsgSshPlayRewind, OT_HELP)
return (1)
EndIf;elif case on edit windows on the "Play" page
EndIf;elif case on window types
elif (StringContains (GetDialogPageName (), "Record")) then
if (GetWindowType (HWindow) == "check box") then
if (name == "Monitor") then
say (MsgSshRecordMonitor, OT_HELP)
return (1)
elif (name == "Loop") then
say (MsgSshRecordLoop, OT_HELP)
return (1)
elif (name == "Ctrl key safety") then
say (MsgSshRecordCtrlKeySafety, OT_HELP)
return (1)
elif (name == "Allow undo") then
say (MsgSshRecordAllowUndo, OT_HELP)
return (1)
elif (name == "Mix with selection") then
say (MsgSshRecordMixWithSelection, OT_HELP)
return (1)
elif (name == "Disable write cache") then
say (MsgSshRecordDisableWriteCache, OT_HELP)
						return (1)
elif (name == "Unbounded") then
say (MsgSshRecordUnbounded, OT_HELP)
return (1)
elif (name == "Timer") then
say (MsgSshRecordTimer, OT_HELP)		
return (1)
elif (name == "Level activated") then
say (MsgSshRecordLevelActivated, OT_HELP)
return (1)
elif (name == "Time stamp cues") then
say (MsgSshRecordTimeStampCues, OT_HELP)
return (1)
EndIf;elif case on checkbox names
EndIf;if the window type = checkbox
EndIf;checking dialog page names
EndIf;evaluating HWindow
EndFunction



Script ScreenSensitiveHelp ()
if (IsSameScript ()) then
RunGWManual ()
return
EndIf
if (WhatWindowIsThis (GetFocus ()) == 0) then
PerformScript ScreenSensitiveHelp()
EndIf
EndScript



Script ScriptInformation ()
ScriptAndAppNames (MsgScriptInfo)
EndScript



Script HotkeyHelp ()
sayFormattedMessage (OT_user_buffer, msgHotkeyHelp)
EndScript
