/*******************************************************************************


"This software program is licensed subject to the GNU General Public License 
(GPL). Version 2, June 1991, available at 
<http://www.fsf.org/copyleft/gpl.html>"

GNU General Public License 

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

Everyone is permitted to copy and distribute verbatim copies of this license
document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to 
share and change it. By contrast, the GNU General Public License is intended
to guarantee your freedom to share and change free software--to make sure 
the software is free for all its users. This General Public License applies 
to most of the Free Software Foundation's software and to any other program 
whose authors commit to using it. (Some other Free Software Foundation 
software is covered by the GNU Library General Public License instead.) You 
can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our
General Public Licenses are designed to make sure that you have the freedom 
to distribute copies of free software (and charge for this service if you 
wish), that you receive source code or can get it if you want it, that you 
can change the software or use pieces of it in new free programs; and that 
you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to 
deny you these rights or to ask you to surrender the rights. These 
restrictions translate to certain responsibilities for you if you distribute
copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or 
for a fee, you must give the recipients all the rights that you have. You 
must make sure that they, too, receive or can get the source code. And you 
must show them these terms so they know their rights.
 
We protect your rights with two steps: (1) copyright the software, and (2) 
offer you this license which gives you legal permission to copy, distribute 
and/or modify the software. 

Also, for each author's protection and ours, we want to make certain that 
everyone understands that there is no warranty for this free software. If 
the software is modified by someone else and passed on, we want its 
recipients to know that what they have is not the original, so that any 
problems introduced by others will not reflect on the original authors' 
reputations. 

Finally, any free program is threatened constantly by software patents. We 
wish to avoid the danger that redistributors of a free program will 
individually obtain patent licenses, in effect making the program 
proprietary. To prevent this, we have made it clear that any patent must be 
licensed for everyone's free use or not licensed at all. 

The precise terms and conditions for copying, distribution and modification 
follow. 

TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice
   placed by the copyright holder saying it may be distributed under the 
   terms of this General Public License. The "Program", below, refers to any
   such program or work, and a "work based on the Program" means either the 
   Program or any derivative work under copyright law: that is to say, a 
   work containing the Program or a portion of it, either verbatim or with 
   modifications and/or translated into another language. (Hereinafter, 
   translation is included without limitation in the term "modification".) 
   Each licensee is addressed as "you". 

   Activities other than copying, distribution and modification are not 
   covered by this License; they are outside its scope. The act of running 
   the Program is not restricted, and the output from the Program is covered 
   only if its contents constitute a work based on the Program (independent 
   of having been made by running the Program). Whether that is true depends
   on what the Program does. 

1. You may copy and distribute verbatim copies of the Program's source code 
   as you receive it, in any medium, provided that you conspicuously and 
   appropriately publish on each copy an appropriate copyright notice and 
   disclaimer of warranty; keep intact all the notices that refer to this 
   License and to the absence of any warranty; and give any other recipients 
   of the Program a copy of this License along with the Program. 

   You may charge a fee for the physical act of transferring a copy, and you 
   may at your option offer warranty protection in exchange for a fee. 

2. You may modify your copy or copies of the Program or any portion of it, 
   thus forming a work based on the Program, and copy and distribute such 
   modifications or work under the terms of Section 1 above, provided that 
   you also meet all of these conditions: 

   * a) You must cause the modified files to carry prominent notices stating 
        that you changed the files and the date of any change. 

   * b) You must cause any work that you distribute or publish, that in 
        whole or in part contains or is derived from the Program or any part 
        thereof, to be licensed as a whole at no charge to all third parties
        under the terms of this License. 

   * c) If the modified program normally reads commands interactively when 
        run, you must cause it, when started running for such interactive 
        use in the most ordinary way, to print or display an announcement 
        including an appropriate copyright notice and a notice that there is
        no warranty (or else, saying that you provide a warranty) and that 
        users may redistribute the program under these conditions, and 
        telling the user how to view a copy of this License. (Exception: if 
        the Program itself is interactive but does not normally print such 
        an announcement, your work based on the Program is not required to 
        print an announcement.) 

   These requirements apply to the modified work as a whole. If identifiable 
   sections of that work are not derived from the Program, and can be 
   reasonably considered independent and separate works in themselves, then 
   this License, and its terms, do not apply to those sections when you 
   distribute them as separate works. But when you distribute the same 
   sections as part of a whole which is a work based on the Program, the 
   distribution of the whole must be on the terms of this License, whose 
   permissions for other licensees extend to the entire whole, and thus to 
   each and every part regardless of who wrote it. 

   Thus, it is not the intent of this section to claim rights or contest 
   your rights to work written entirely by you; rather, the intent is to 
   exercise the right to control the distribution of derivative or 
   collective works based on the Program. 

   In addition, mere aggregation of another work not based on the Program 
   with the Program (or with a work based on the Program) on a volume of a 
   storage or distribution medium does not bring the other work under the 
   scope of this License. 

3. You may copy and distribute the Program (or a work based on it, under 
   Section 2) in object code or executable form under the terms of Sections 
   1 and 2 above provided that you also do one of the following: 

   * a) Accompany it with the complete corresponding machine-readable source 
        code, which must be distributed under the terms of Sections 1 and 2 
        above on a medium customarily used for software interchange; or, 

   * b) Accompany it with a written offer, valid for at least three years, 
        to give any third party, for a charge no more than your cost of 
        physically performing source distribution, a complete machine-
        readable copy of the corresponding source code, to be distributed 
        under the terms of Sections 1 and 2 above on a medium customarily 
        used for software interchange; or, 

   * c) Accompany it with the information you received as to the offer to 
        distribute corresponding source code. (This alternative is allowed 
        only for noncommercial distribution and only if you received the 
        program in object code or executable form with such an offer, in 
        accord with Subsection b above.) 

   The source code for a work means the preferred form of the work for 
   making modifications to it. For an executable work, complete source code 
   means all the source code for all modules it contains, plus any 
   associated interface definition files, plus the scripts used to control 
   compilation and installation of the executable. However, as a special 
   exception, the source code distributed need not include anything that is 
   normally distributed (in either source or binary form) with the major 
   components (compiler, kernel, and so on) of the operating system on which
   the executable runs, unless that component itself accompanies the 
   executable. 

   If distribution of executable or object code is made by offering access 
   to copy from a designated place, then offering equivalent access to copy 
   the source code from the same place counts as distribution of the source 
   code, even though third parties are not compelled to copy the source 
   along with the object code. 

4. You may not copy, modify, sublicense, or distribute the Program except as
   expressly provided under this License. Any attempt otherwise to copy, 
   modify, sublicense or distribute the Program is void, and will 
   automatically terminate your rights under this License. However, parties 
   who have received copies, or rights, from you under this License will not
   have their licenses terminated so long as such parties remain in full 
   compliance. 

5. You are not required to accept this License, since you have not signed 
   it. However, nothing else grants you permission to modify or distribute 
   the Program or its derivative works. These actions are prohibited by law 
   if you do not accept this License. Therefore, by modifying or 
   distributing the Program (or any work based on the Program), you 
   indicate your acceptance of this License to do so, and all its terms and
   conditions for copying, distributing or modifying the Program or works 
   based on it. 

6. Each time you redistribute the Program (or any work based on the 
   Program), the recipient automatically receives a license from the 
   original licensor to copy, distribute or modify the Program subject to 
   these terms and conditions. You may not impose any further restrictions 
   on the recipients' exercise of the rights granted herein. You are not 
   responsible for enforcing compliance by third parties to this License. 

7. If, as a consequence of a court judgment or allegation of patent 
   infringement or for any other reason (not limited to patent issues), 
   conditions are imposed on you (whether by court order, agreement or 
   otherwise) that contradict the conditions of this License, they do not 
   excuse you from the conditions of this License. If you cannot distribute 
   so as to satisfy simultaneously your obligations under this License and 
   any other pertinent obligations, then as a consequence you may not 
   distribute the Program at all. For example, if a patent license would 
   not permit royalty-free redistribution of the Program by all those who 
   receive copies directly or indirectly through you, then the only way you 
   could satisfy both it and this License would be to refrain entirely from 
   distribution of the Program. 

   If any portion of this section is held invalid or unenforceable under any
   particular circumstance, the balance of the section is intended to apply
   and the section as a whole is intended to apply in other circumstances. 

   It is not the purpose of this section to induce you to infringe any 
   patents or other property right claims or to contest validity of any 
   such claims; this section has the sole purpose of protecting the 
   integrity of the free software distribution system, which is implemented 
   by public license practices. Many people have made generous contributions
   to the wide range of software distributed through that system in 
   reliance on consistent application of that system; it is up to the 
   author/donor to decide if he or she is willing to distribute software 
   through any other system and a licensee cannot impose that choice. 

   This section is intended to make thoroughly clear what is believed to be 
   a consequence of the rest of this License. 

8. If the distribution and/or use of the Program is restricted in certain 
   countries either by patents or by copyrighted interfaces, the original 
   copyright holder who places the Program under this License may add an 
   explicit geographical distribution limitation excluding those countries, 
   so that distribution is permitted only in or among countries not thus 
   excluded. In such case, this License incorporates the limitation as if 
   written in the body of this License. 

9. The Free Software Foundation may publish revised and/or new versions of 
   the General Public License from time to time. Such new versions will be 
   similar in spirit to the present version, but may differ in detail to 
   address new problems or concerns. 

   Each version is given a distinguishing version number. If the Program 
   specifies a version number of this License which applies to it and "any 
   later version", you have the option of following the terms and 
   conditions either of that version or of any later version published by 
   the Free Software Foundation. If the Program does not specify a version 
   number of this License, you may choose any version ever published by the 
   Free Software Foundation. 

10. If you wish to incorporate parts of the Program into other free programs
    whose distribution conditions are different, write to the author to ask 
    for permission. For software which is copyrighted by the Free Software 
    Foundation, write to the Free Software Foundation; we sometimes make 
    exceptions for this. Our decision will be guided by the two goals of 
    preserving the free status of all derivatives of our free software and 
    of promoting the sharing and reuse of software generally. 

   NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
    FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN 
    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES 
    PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
    EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
    ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH 
    YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL 
    NECESSARY SERVICING, REPAIR OR CORRECTION. 

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
    REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
    DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
    DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
    (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
    INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
    THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR 
    OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest 
possible use to the public, the best way to achieve this is to make it free 
software which everyone can redistribute and change under these terms. 

To do so, attach the following notices to the program. It is safest to 
attach them to the start of each source file to most effectively convey the
exclusion of warranty; and each file should have at least the "copyright" 
line and a pointer to where the full notice is found. 

one line to give the program's name and an idea of what it does.
Copyright (C) yyyy  name of author

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the Free 
Software Foundation; either version 2 of the License, or (at your option) 
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT 
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 
Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Also add information on how to contact you by electronic and paper mail. 

If the program is interactive, make it output a short notice like this when 
it starts in an interactive mode: 

Gnomovision version 69, Copyright (C) year name of author Gnomovision comes 
with ABSOLUTELY NO WARRANTY; for details type 'show w'.  This is free 
software, and you are welcome to redistribute it under certain conditions; 
type 'show c' for details.

The hypothetical commands 'show w' and 'show c' should show the appropriate 
parts of the General Public License. Of course, the commands you use may be 
called something other than 'show w' and 'show c'; they could even be 
mouse-clicks or menu items--whatever suits your program. 

You should also get your employer (if you work as a programmer) or your 
school, if any, to sign a "copyright disclaimer" for the program, if 
necessary. Here is a sample; alter the names: 

Yoyodyne, Inc., hereby disclaims all copyright interest in the program 
'Gnomovision' (which makes passes at compilers) written by James Hacker.

signature of Ty Coon, 1 April 1989
Ty Coon, President of Vice

This General Public License does not permit incorporating your program into 
proprietary programs. If your program is a subroutine library, you may 
consider it more useful to permit linking proprietary applications with the 
library. If this is what you want to do, use the GNU Library General Public 
License instead of this License.

*******************************************************************************/

#include <linux/version.h>
#include <linux/module.h>
#include <linux/pci.h>
#include <asm/io.h>
#include <linux/i2c.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/kernel.h>
#include <linux/list.h>
#include <linux/reboot.h>
#include <linux/pm.h>
#include <linux/netdevice.h>
#include <asm/uaccess.h>

#include "smb2-algo-bit.h"
#include "i2c-i825xx.h"

#define SEM_LOCK    if( down_interruptible( ldata->sem ) ) return -ERESTARTSYS;
#define SEM_UNLOCK  up( ldata->sem );

#define DHCP_PARAM_BUF_SIZE 26

//assume page is 2^n ...
#define I2C_PAGE_ALIGN(addr)    ( (addr) & (~(PAGE_SIZE - 1)))
#define I2C_PAGE_OFFSET(addr)   ( (addr) & (PAGE_SIZE - 1))

#ifndef I2C_VER_2_8_0
static void i825xx_inc(struct i2c_adapter *adapter);
static void i825xx_dec(struct i2c_adapter *adapter);
#endif
static int  i825xx_smbus_xfer(struct i2c_adapter * adap, u16 addr, 
                 unsigned short flags,char read_write, 
                 u8 command, int size, union i2c_smbus_data * data);
static u32 i825xx_func(struct i2c_adapter *adapter);

static int i825xx_init_data(struct pci_dev *pcid, struct i825xx_data * ldata);

static struct list_head i825xx_list = LIST_HEAD_INIT(i825xx_list);

#ifdef I825XX_SYNC_WA
static int i825xx_reboot_notify(struct notifier_block *nt,
                   unsigned long type, void *unused);
static int i825xx_network_notify(struct notifier_block *,
                                   unsigned long, void *);

static struct notifier_block i825xx_reboot_blk = {
  notifier_call:    i825xx_reboot_notify,
  next:         NULL,
  priority:     0xffff
};

struct notifier_block i825xx_network_blk = {
         i825xx_network_notify,
         NULL,
         0
};
static struct pm_dev * i825xx_pm = NULL;

#endif /* I825XX_SYNC_WA */


static inline void i825xx_line_assert(void * data, 
                     I825XX_REG_SIZE line_bit)
{
  struct i825xx_data * ldata = (struct i825xx_data *)data;
  


#ifdef I825XX_SYNC_WA
    //the pci_mask may not be valid due to no sync with lan driver.
        ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);

    // make sure the ARP bit is toggled appropriatly according
    // to the pending pm state
    if(ldata->state == I825XX_UP){
      ldata->pci_mask &= ~(PCI_ARP_EN);
    }else {
      ldata->pci_mask |= PCI_ARP_EN ;
    }
#else 
  if(!(ldata->pci_mask & line_bit)){
#endif /* I825XX_SYNC_WA */    
    ldata->pci_mask |= line_bit;
    I825XX_REG_WRITE(ldata->pci_mask, ldata->pci_smb_access);
    
    // force pci access by reading the bus & update the cache
    ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);
    mb();
#ifndef I825XX_SYNC_WA
  }
#endif
}

static inline void i825xx_line_deassert(void * data, 
                       I825XX_REG_SIZE line_bit)
{
  struct i825xx_data * ldata = (struct i825xx_data *)data;
  

#ifdef I825XX_SYNC_WA
    //the pci_mask may not be valid due to no sync with lan driver.
    ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);

    // make sure the ARP bit is toggled appropriatly according
    // to the pending pm state
    if(ldata->state == I825XX_UP){
      ldata->pci_mask &= ~(PCI_ARP_EN);
    }else {
      ldata->pci_mask |= PCI_ARP_EN ;
    }
#else
  if( ldata->pci_mask & line_bit){
#endif /* I825XX_SYNC_WA */    

    ldata->pci_mask &= ~line_bit;
    I825XX_REG_WRITE(ldata->pci_mask, ldata->pci_smb_access);

    // force pci access by reading the bus
    ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);
    mb();
#ifndef I825XX_SYNC_WA
  }
#endif
}

static inline  int i825xx_line_get(void * data,
                  I825XX_REG_SIZE line_bit)
{
  struct i825xx_data * ldata = (struct i825xx_data *)data;

  ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);
  rmb();
  return (ldata->pci_mask & line_bit ? 1 : 0 );
}

static void i825xx_setscl(void *data, int val)
{
  if(val != 0){
    i825xx_line_assert(data, PCI_SMB_SCLI);
  }else{
    i825xx_line_deassert(data, PCI_SMB_SCLI);
  }
}

static void i825xx_setsda(void *data, int val)
{
  if(val != 0){
    i825xx_line_assert(data, PCI_SMB_SDAI);
  }else{
    i825xx_line_deassert(data, PCI_SMB_SDAI);
  }
}

static int i825xx_getscl(void *data)
{
  return i825xx_line_get(data, PCI_SMB_SCLO);
}

static int i825xx_getsda(void *data)
{
  return i825xx_line_get(data, PCI_SMB_SDAO);
}

static enum lines_states i825xx_getlines(void *data)
{
  unsigned int res = 0;
  struct i825xx_data * ldata = (struct i825xx_data *)data;

  ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);
  rmb();
  if (ldata->pci_mask & PCI_SMB_SDAO)
    res |= 0x10;
  if(ldata->pci_mask & PCI_SMB_SCLO)
    res |= 1;
  
  return res;
}

//#ifndef EXTERNAL_BUS 

// Wait for grant we busy wait up to 1 ms. Otherwise
// we sleep. 
static void i825xx_wait_grant(unsigned long * in_wait){
  
  if(*in_wait < 1000){
    udelay(50);
    *in_wait += 50;
  }else{
    set_current_state(TASK_UNINTERRUPTIBLE); 
    schedule_timeout(1); 
  } 
}
  
static int i825xx_request_grant(void * data)
{
  unsigned long in_wait = 0;
  unsigned long start   = jiffies;

  i825xx_line_assert(data,PCI_SMB_REQ);

  do{
    i825xx_wait_grant(&in_wait);
    
    if(i825xx_line_get(data,PCI_SMB_GNT)){
      return 0;
    }

  }while(jiffies - start < (HZ * 35) / 1000); 
  

  return 1;
}

static int i825xx_release_grant(void * data)
{
  unsigned long in_wait =0;
  unsigned long start    = jiffies;

  i825xx_line_deassert(data,PCI_SMB_REQ);

  do{
    i825xx_wait_grant(&in_wait);

    if(i825xx_line_get(data,PCI_SMB_GNT) == 0){
      return 0;
    }
#ifdef I825XX_SYNC_WA
    // our deasertion failed due to no sync with lan drv so:
    i825xx_line_deassert(data,PCI_SMB_REQ);
#endif /* I825XX_SYNC_WA */

  }while(jiffies - start < (HZ * 35) / 1000); 
  
  return 1;
}

//#endif /* EXTERNAL_BUS */

#ifdef I825XX_HOSTIF_OFFSET
static u8
calc_checksum(u8 *buffer, u16 size)
{   
    u16 i;
    u8 checksum = 0;

    for (i = 0; i < size; i++) {
        checksum += buffer[i];
    }
    return (0xff - checksum + 1);
}

static int 
host_read(void *data, u32 offset, u32 *value)
{
    struct i825xx_data * ldata = (struct i825xx_data *)data;
    u32 manc, i,j,read_data = 0;
    int rc = -1;

    if (i825xx_smb_en(ldata->pci_smb_access) == -1) {
        printk(KERN_DEBUG "Read HOSTIF not active 0x%x\n", 
               I825XX_REG_READ(ldata->pci_smb_access));
        rc = -2;
    } else if (ldata->pci_hostif_access != NULL){
        for(j=0; j<2; j++){
            for (i = 0; i < HOST_READY_RETRIES; i++) {
                manc = I825XX_REG_READ(ldata->pci_smb_access);
                if (manc & PCI_HOST_READY) {
                    set_current_state(TASK_UNINTERRUPTIBLE);
                    schedule_timeout(HOST_READY_DELAY);
                } else{
                    read_data = I825XX_REG_READ(ldata->pci_hostif_access + offset);
                    rmb();
                    rc = 0;
                    break;
                }
            }
            if (manc & PCI_HOST_READY){
                printk(KERN_DEBUG "Read HOSTIF not ready 0x%x\n", manc);
            }
        }
    }
    *value = read_data;
    return rc;
}

static int 
host_write(void *data, u32 offset, u32 data_dword)
{
    struct i825xx_data * ldata = (struct i825xx_data *)data;
    u32 manc, i;
    int rc = -1;

    if (i825xx_smb_en(ldata->pci_smb_access) == -1) {
        printk(KERN_DEBUG "Write HOSTIF not active 0x%x\n", 
               I825XX_REG_READ(ldata->pci_smb_access));
        rc = -2;
    } else if (ldata->pci_hostif_access != NULL){
        for (i = 0; i < HOST_READY_RETRIES; i++) {
            manc = I825XX_REG_READ(ldata->pci_smb_access);
            if (manc & PCI_HOST_READY) {
                set_current_state(TASK_UNINTERRUPTIBLE);
                schedule_timeout(HOST_READY_DELAY);
            } else{
                I825XX_REG_WRITE(data_dword, ldata->pci_hostif_access + offset);
                manc = I825XX_REG_READ(ldata->pci_smb_access);
                rmb();
                rc = 0;
                break; 
            }
        }
        if (manc & PCI_HOST_READY){
            printk(KERN_DEBUG "Write HOSTIF not ready 0x%x\n", manc);
        }
    }
    return rc;
}

static int
i8254x_run_command(void * data, u32 cmd, u32 *ret_data, u8 wait)
{
	u8 retry = 0;
	int rc = 0;

	rc = host_write(data, 0, cmd);

	if ((rc == 0) && (wait == HOST_CMD_WAIT)) {
		while (((*ret_data & HOST_CMD_DONE_BIT) == 0) && (rc == 0) &&
		       (retry < HOST_CMD_RETRIES)) {
			set_current_state(TASK_UNINTERRUPTIBLE);
			schedule_timeout(HOST_CMD_RETRY_DELAY);
			retry++;
			rc = host_read(data, 0, ret_data);
		}

		if (((*ret_data & 0xff) != ((cmd & 0xff) | HOST_CMD_DONE_BIT)) && 
		    (rc == 0)){
			rc = -1;
		}
	}

	return rc;
}
static int
i8254x_clear_log_command(void * data)
{
   u8 buff[4];
   u32 reg_data = 0;
   
   buff[0] = HOST_CLEAR_LOG_CMD;
   buff[1] = 0;
   buff[2] = 0;
   buff[3] = calc_checksum(buff, 3);

   return i8254x_run_command(data, *(u32 *)buff, &reg_data, HOST_CMD_WAIT);
}

static int
i8254x_geterr_log_length(void * data, u8 *retval)
{
	u8 buff[4];
	u32 tmp = 0;
	int rc = 0;

	buff[0] = HOST_GET_LOG_CMD;
	buff[1] = 0;
	buff[2] = 0;
	buff[3] = calc_checksum(buff, 3);


	rc = i8254x_run_command(data, *(u32 *)buff, &tmp, HOST_CMD_WAIT);

	if (rc == 0) {
		/* read end of the buffer to find actual number of trace entries */
		rc = host_read(data, ((tmp & 0xff00)>>8), &tmp);    
		if (rc == 0){
			*retval = (tmp & 0xff)*48;
		}
	}

	return rc;
}

static int
i8254x_geterr_log(void * data, u32 * buffer, u8 buffer_length)
{
	u16 i;
	int rc=0;
	
	for (i = 0; (i < buffer_length)&&(rc == 0); i += 4){
		rc = host_read(data, 4 + i, &(buffer[i>>2]));
	}

	return rc;
}

static int
i8254x_null_command(void * data)
{
    u8 buff[4];
    u32 reg_data = 0;

    buff[0] = HOST_NULL_CMD;
    buff[1] = 0;
    buff[2] = 0;
    buff[3] = calc_checksum(buff, 3);

    return i8254x_run_command(data, *(u32 *)buff, &reg_data, HOST_CMD_WAIT);;
}

static int
i8254x_check_reload_complete(void * data, int count)
{
    int rc = -1;
    int i;

    for (i = 0; i < count ; i++) {
        rc = i8254x_null_command(data);
        if (rc ==0) {
            break;
        }
        set_current_state(TASK_UNINTERRUPTIBLE);
        schedule_timeout(HOST_CMD_CHECK_COMPLETE_DELAY);
    }

    return rc;
}

static int
i8254x_hostreset(void * data, u8 option)
{
	u8 buff[8];
	int rc;
	int retry = 0;
	u32 tmp = 0;

	buff[0] = option;
	buff[1] = 0;
	buff[2] = 0;
	buff[3] = 0;
	buff[4] = HOST_RESET_CMD;
	buff[5] = 2;
	buff[6] = 0;
	buff[7] = calc_checksum(buff, 7);

	rc = host_write(data, 4, *(u32 *)buff);
	if (rc == 0)
		rc = host_write(data, 0, *(u32 *)(buff+4));

	while ((retry < HOST_CMD_RETRIES) && (rc == 0) && 
	       ((tmp & HOST_CMD_DONE_BIT) == 0)) {
		set_current_state(TASK_UNINTERRUPTIBLE);
		schedule_timeout(HOST_CMD_RETRY_DELAY);
		retry++;
		rc = host_read(data, 0, &tmp);
	}

	if (((tmp & 0xff) != (HOST_RESET_CMD | HOST_CMD_DONE_BIT)) && 
	    (rc == 0)){
		rc = -1;
	}
	
    set_current_state(TASK_UNINTERRUPTIBLE);
	schedule_timeout(HOST_CMD_RESET_DELAY);
    
    if (rc != 0) {
		rc = i8254x_check_reload_complete(data, HOST_CMD_RETRIES);
	}
	return rc;
}

static int
i8254x_getclasf_reg(void * data, u8 reg_addr, u8 *retval)
{
	u8 buff[8];
	u32 tmp = 0;
	int rc = 0;

	buff[0] = reg_addr;
	buff[1] = 0;
	buff[2] = 0;
	buff[3] = 0;
	buff[4] = HOST_GET_REG_CMD;
	buff[5] = 2;
	buff[6] = 0;
	buff[7] = calc_checksum(buff, 7);

	rc = host_write(data, 4, *(u32 *)buff);

	if (rc == 0) {
		rc = i8254x_run_command(data, *(u32 *)(buff+4), &tmp, HOST_CMD_WAIT);
		if (rc == 0){
			rc = host_read(data, 4, &tmp);
			*retval = (tmp & 0xff0000)>>16;
		}
	}

	return rc;
}

static int
i8254x_setclasf_reg(void * data, u8 reg_addr, u8 reg_data)
{
    u8 buff[8];
    u32 tmp;
    int rc = 0;

    buff[0] = reg_addr;
    buff[1] = 0;
    buff[2] = reg_data;
    buff[3] = 0;
    buff[4] = HOST_SET_REG_CMD;
    buff[5] = 4;
    buff[6] = 0;
    buff[7] = calc_checksum(buff, 7);

    rc = host_write(data, 4, *(u32 *)buff);
    
	if (rc == 0) {
        rc = i8254x_run_command(data, *(u32 *)(buff+4), &tmp, HOST_CMD_WAIT);
	}
    
    return rc;
}


static int 
host_write_buf(void * data, u32 byte_offset, u32 *buf, u32 num_dwords) {
	int rc=0;
	unsigned int buf_pos=0;
		
	while ((rc==0) && (buf_pos < num_dwords)) {
		rc = host_write(data, byte_offset+(4*buf_pos), *(buf+buf_pos));
		buf_pos++;
	}

	return rc;
}


static int
host_read_buf(void * data, u32 byte_offset, u32 *buf, u32 num_dwords) {
	int rc=0;
	unsigned int buf_pos=0;
		
	while ((rc==0) && (buf_pos < num_dwords)) {
		rc = host_read(data, byte_offset+(4*buf_pos), (buf+buf_pos));
		buf_pos++;
	}

	return rc;
}


static int
i8254x_get_dhcp(void * data, u8 *dhcp_param_buf)
{	
	u8 buff[4];
	u32 tmp = 0;
	int rc = 0;

	u32 ret_dword_buf[DHCP_PARAM_BUF_SIZE/sizeof(u32)+1];

	buff[0] = HOST_GET_DHCP_CMD;
	buff[1] = 0;
	buff[2] = 0;
	buff[3] = calc_checksum(buff, 3);

	rc = i8254x_run_command(data, *(u32 *)buff, &tmp, HOST_CMD_WAIT);

	if (rc == 0) {
		rc = host_read_buf(data, 4, ret_dword_buf, sizeof(ret_dword_buf)/sizeof(u32));
	}

	memcpy(dhcp_param_buf, (u8 *)ret_dword_buf, DHCP_PARAM_BUF_SIZE);

	return rc;	
}


static int
i8254x_set_dhcp(void * data, u8 *dhcp_param_buf)
{
	//make sure there is room for dhcp_params + 4 byte command + rounding to next dword
	u8 buff[DHCP_PARAM_BUF_SIZE+7];	
	u32 tmp = 0;
	int rc = 0;	
	unsigned int buff_size = (DHCP_PARAM_BUF_SIZE+4);	// +4 for 4 byte command
	//round buff_size to the nearest dword if needed
	unsigned int rem = (buff_size%4);
	if (rem!=0) {
		buff_size+=(4-rem);
	}
	
	memset(buff, 0, buff_size);
	memcpy(buff, dhcp_param_buf, DHCP_PARAM_BUF_SIZE);  //copy dhcp params buf
	buff[buff_size-4] = HOST_SET_DHCP_CMD;
	buff[buff_size-3] = DHCP_PARAM_BUF_SIZE;
	buff[buff_size-2] = 0;
	buff[buff_size-1] = calc_checksum(buff, buff_size-1);

	//write buff except command word
	rc = host_write_buf(data, 4, (u32 *)buff, (buff_size-4)/sizeof(u32));

	if (rc == 0) {
		rc = i8254x_run_command(data, *(u32 *)(&(buff[buff_size-4])), &tmp, HOST_CMD_WAIT);
	}

	return rc;	
}


static int
i8254x_hostversion(void *data, u32 *version)
{
	u32 tmp=0;
	int rc = 0;
	u8 buff[4];
  
	buff[0] = HOST_VERSION_CMD;
	buff[1] = 0;
	buff[2] = 0;
	buff[3] = calc_checksum (buff, 3);

	rc = i8254x_run_command(data, *(u32 *)(buff), &tmp, HOST_CMD_WAIT);
	
	if (rc == 0) {
		rc = host_read(data, 4, &version[0]);
	}

	if (rc == 0) {
		rc = host_read(data, 8, &version[1]);
	}

	return rc;
}

#endif /*I825XX_HOSTIF_OFFSET*/



static int 
i825xx_algo_control(struct i2c_adapter *adapter, unsigned int cmd, unsigned long data)
{
#ifdef I825XX_HOSTIF_OFFSET
    u32 version[2];
    u32 addr;
    u8 reg = 0;
	u32 *tmp_buff;
	u8 dhcp_param_buf[DHCP_PARAM_BUF_SIZE];
#endif /*I825XX_HOSTIF_OFFSET*/
    int rc = 0;
    switch (cmd) {

#ifdef SMB_TRACE_DEBUG   
    case CMD_GET_TRACE_BUFF:
        copy_to_user((void *)data, (u8 *)trace_buf, trace_count*sizeof(struct log_entry));
        break;
    case CMD_GET_TRACE_SIZE:
        copy_to_user((void *)data, &trace_count, sizeof(trace_count));
        break;
    case CMD_RESET_TRACE:
        trace_count = data;
        break;
#endif /* SMB_TRACE_DEBUG */

#ifdef I825XX_HOSTIF_OFFSET
    case CMD_RESET_FIRMWARE:
        rc = i8254x_null_command(adapter->data);
        if (rc == 0) {
		rc = i8254x_hostreset(adapter->data, (data & 0xff));
	}
        break;
    case CMD_GET_VERSION:
        rc = i8254x_null_command(adapter->data);
        if (rc == 0) {
            rc = i8254x_hostversion(adapter->data, version);
	}
        if (rc == 0) {
            copy_to_user((void *)data, version, sizeof(version));
	}
        break;
    case CMD_GET_CLASF_REG:
        rc = i8254x_null_command(adapter->data);
        if (rc == 0){
		rc = copy_from_user((void *)&addr, (void *)data, sizeof(addr));
	}
	if (rc == 0) {
		rc = i8254x_getclasf_reg(adapter->data, (addr & 0xff), &reg);
	}
        if (rc == 0) {
		rc = copy_to_user((void *)data, &reg, sizeof(reg));
        }
        break;
    case CMD_SET_CLASF_REG:
        rc = i8254x_null_command(adapter->data);
        if (rc == 0) {
		rc = copy_from_user((void *)&addr, (void *)data, sizeof(addr));
	}
        if (rc == 0) {
		rc = i8254x_setclasf_reg(adapter->data, (addr & 0xff),
				         ((addr & 0xff00)>>8));
        }
        break;
    case CMD_CHECK_HOSTIF:
	if (data < 10) {
		data = 10;
	}
        rc = i8254x_check_reload_complete(adapter->data, data);
        break;
	case CMD_GET_DHCP:
        rc = i8254x_null_command(adapter->data);
		if (rc == 0) {
			rc = i8254x_get_dhcp(adapter->data, dhcp_param_buf);
		}
        if (rc == 0) {
			rc = copy_to_user((void *)data, (void *)dhcp_param_buf, sizeof(dhcp_param_buf));
        }

		break;
	case CMD_SET_DHCP:
        rc = i8254x_null_command(adapter->data);
        if (rc == 0) {
			rc = copy_from_user((void *)dhcp_param_buf, (void *)data, sizeof(dhcp_param_buf));
		}
        if (rc == 0) {
			rc = i8254x_set_dhcp(adapter->data, dhcp_param_buf);
        }
        break;
    case CMD_GET_ERRLOG_LENGTH:
	rc = i8254x_null_command(adapter->data);
        
	if (rc == 0) {
		rc = i8254x_geterr_log_length(adapter->data, &reg);
	}

	if (rc == 0){
		rc = copy_to_user((void *)data, &reg, sizeof(reg));
	}
	break;
    case CMD_GET_ERRLOG_BUFFER:
	rc = i8254x_null_command(adapter->data);

        if (rc == 0) {
		rc = i8254x_geterr_log_length(adapter->data, &reg);
        }

        if (rc == 0){
		tmp_buff = kmalloc(reg, GFP_KERNEL);
		if (tmp_buff != NULL){
			rc = i8254x_geterr_log(adapter->data, tmp_buff, reg);
			if (rc == 0){
				rc = copy_to_user((void *)data, tmp_buff, reg);
			}
			kfree(tmp_buff);
		}
	}
        break;
   case CMD_CLEAR_ERRLOG:
       rc = i8254x_null_command(adapter->data);
       
       if (rc == 0) {
           rc = i8254x_clear_log_command(adapter->data);
       }
       break;
#endif /*I825XX_HOSTIF_OFFSET*/

    case 0:
    default:
        rc = 0;
        break;
    }
    return rc;
}

static struct i2c_algorithm i825xx_algo = {
  name:         "Non-I2C SMBus adapter",
  id:           I2C_ALGO_SMBUS,
  master_xfer:      NULL,
  smbus_xfer:       i825xx_smbus_xfer,
  slave_send:       NULL,
  slave_recv:       NULL,
  algo_control:     i825xx_algo_control,
  functionality:    i825xx_func,
};

/* templates */
static __init struct smb2_algo_bit_data i825xx_bit_data = {
    data:       NULL,
    setsda:     i825xx_setsda,
    setscl:     i825xx_setscl,
    getsda:     i825xx_getsda,
    getscl:     i825xx_getscl,
    getlines:   i825xx_getlines,
};  

static __init struct i2c_adapter i825xx_adapter = {
#ifdef I2C_VER_2_8_0
  owner:      THIS_MODULE,    //  defined in linux/module.h
#endif
  name:         " ",
  id:           0x8086/*I2C_HW_SMBUS_I82551*/,
  algo:         &i825xx_algo,
  algo_data:        NULL,
#ifndef I2C_VER_2_8_0
  inc_use:      i825xx_inc,
  dec_use:      i825xx_dec,
#endif
  client_register:  NULL,
  client_unregister:    NULL,
  data:         NULL,
  retries:      1
};

static int i825xx_smbus_xfer(struct i2c_adapter * adap, u16 addr, 
                 unsigned short flags,char read_write, 
                 u8 command, int size,union i2c_smbus_data * data)
{
  int res;
  
  struct i825xx_data *ldata = (struct i825xx_data *)adap->data;

  SEM_LOCK;
  /* init the lines output states */
  ldata->pci_mask = I825XX_REG_READ(ldata->pci_smb_access);
 
  if(i825xx_smb_en(ldata->pci_smb_access) == -1){
    SEM_UNLOCK;
    return -1;
  }

  if( ldata->type == INTERNAL ){
    if(i825xx_request_grant(adap->data) != 0){
      res = -EIO;
      goto exit_xfer;
    }
    flags &= ldata->flag_mask;/* prevent PEC on internal transactions that are not PEC-aware */
    flags |= I2C_INTERNAL_BUS;/* prevent PEC check on internal transactions */
  }

  res = smb2_xfer(adap, addr, flags,read_write, command,size,data);

exit_xfer:

  if( ldata->type == INTERNAL ){
    i825xx_release_grant(adap->data);
  }
  SEM_UNLOCK;
  return res;
}

#ifndef I2C_VER_2_8_0

static void i825xx_inc(struct i2c_adapter *adapter)
{
    MOD_INC_USE_COUNT;
}

static void i825xx_dec(struct i2c_adapter *adapter)
{
    MOD_DEC_USE_COUNT;
}

#endif //  I2C_VER_2_8_0

static u32 i825xx_func(struct i2c_adapter *adapter)
{
  return I2C_FUNC_SMBUS_QUICK | 
    I2C_FUNC_SMBUS_BYTE |
    I2C_FUNC_SMBUS_BYTE_DATA | I2C_FUNC_SMBUS_WORD_DATA |
    I2C_FUNC_SMBUS_BLOCK_DATA |
    I2C_FUNC_SMBUS_PROC_CALL |
#ifdef I2C_FUNC_SMBUS_HWPEC_CALC
    I2C_FUNC_SMBUS_HWPEC_CALC |
#endif
#ifdef I2C_FUNC_SMBUS_BLOCK_PROC_CALL
    I2C_FUNC_SMBUS_BLOCK_PROC_CALL; 
#else
    0;
#endif
}

static __init struct i2c_adapter * i825xx_alloc(void){

  struct i2c_adapter *adap;
  struct smb2_algo_bit_data *algo ;
  struct i825xx_data *ldat ;

  int len = sizeof(struct i2c_adapter) + sizeof(struct i825xx_data)
    +sizeof(struct smb2_algo_bit_data);
  
  adap = kmalloc(len, GFP_KERNEL);
  if(adap == NULL){
    return NULL;
  }

  memset(adap, 0, len);
  algo = (struct smb2_algo_bit_data *)(adap + 1);
  ldat = (struct i825xx_data *)(algo + 1);
  
  memcpy(adap,&i825xx_adapter, sizeof(i825xx_adapter));
  adap->algo_data = algo;
  adap->data = ldat;

  memcpy(algo, &i825xx_bit_data, sizeof(i825xx_bit_data));
  algo->data = ldat;
  memset(&algo->stats, 0, sizeof(struct smb2_stats));

  
  ldat->adap = adap;

  ldat->type = UNKNOWN;
  ldat->sem = NULL;
  return adap;
} 

static void i825xx_remove(struct i2c_adapter * adp)
{
  struct i825xx_data * ldata = adp->data;
  if(ldata->initialized > 0){
    i2c_del_adapter(adp);
  }

  if(ldata->pci_smb_access != 0){
    iounmap(ldata->pci_smb_access - 
        I2C_PAGE_OFFSET(I825XX_PCI_SMB_OFFSET));
  }
#ifdef I825XX_HOSTIF_OFFSET
  if(ldata->pci_hostif_access != 0){
    iounmap(ldata->pci_hostif_access -
            I2C_PAGE_OFFSET(I825XX_HOSTIF_OFFSET));
  }
#endif


  //Note: EXTERNAL is important here.
  //We assume that it is initialized second, and
  //removed from the list second as well.
  if(ldata->type == EXTERNAL && ldata->sem != NULL){
    kfree(ldata->sem);
  }

  kfree(adp);
}

static int __init i825xx_probe(struct pci_dev *pcid)
{
  int res;
  struct i825xx_data * ldata_i;
  struct i2c_adapter * adap_i = NULL;

  struct i825xx_data * ldata_e;
  struct i2c_adapter * adap_e = NULL;

  if(i825xx_is_supported(pcid)){
    return -1;
  }
  
  pci_set_master(pcid) ; 

  // should we wake the device if it's suspended?
  if(pci_enable_device(pcid)){
    return -ENODEV;
  }

  //first **internal** smbus adapter
  if( (adap_i = i825xx_alloc()) == NULL){
    return -ENODEV;
  }
  ldata_i = (struct i825xx_data *)adap_i->data;

  if( (ldata_i->sem = kmalloc(sizeof(struct semaphore), GFP_KERNEL)) == NULL ){
    return -ENOMEM;
  }

  sema_init( ldata_i->sem, 1 );
  if( (res = i825xx_init_data(pcid, ldata_i)) != 0 )
    return res;
  strncpy(adap_i->name+strlen(adap_i->name), " Int", sizeof(adap_i->name)-strlen(adap_i->name)+1);
  ldata_i->type = INTERNAL;

  //next **external** smbus adapter
  if( (adap_e = i825xx_alloc()) == NULL){
    return -ENODEV;
  }

  ldata_e = (struct i825xx_data *)adap_e->data;
  if( (res = i825xx_init_data(pcid, ldata_e)) != 0 )
    return res;
  ldata_e->sem = ldata_i->sem;
  strncpy(adap_e->name+strlen(adap_e->name), " Ext", sizeof(adap_e->name)-strlen(adap_e->name)+1);
  ldata_e->type = EXTERNAL;

  /* now attach the adapters */  
  if( (res = i2c_add_adapter(adap_i))){
    printk(I825XX_DEV_NAME " adapter registration failed\n");
    i825xx_remove(adap_i);
    return res;
  }

  list_add_tail(&ldata_i->node, &i825xx_list);
  ldata_i->initialized = 1;
  ldata_i->flag_mask = 0x14; /*I2C_CLIENT_PEC + I2C_TEN*/

  if (!i825xx_is_internal_PEC_supported(pcid))
      ldata_i->flag_mask = 0;

  if( (res = i2c_add_adapter(adap_e))){
    printk(I825XX_DEV_NAME " adapter registration failed\n");
    i825xx_remove(adap_e);
    return res;
  }

  list_add_tail(&ldata_e->node, &i825xx_list);
  ldata_e->initialized = 1;
  ldata_e->flag_mask = 0x14; /*I2C_CLIENT_PEC + I2C_TEN*/
  return 0;
}

static int i825xx_init_data(struct pci_dev *pcid, struct i825xx_data * ldata)
{
  unsigned long mem;
  struct i2c_adapter *adap = ldata->adap;

  mem = i825xx_iomem(pcid);
  
  // map only 1 page containing PCI-SMBUS register, 
  // we're aligning before calling ioremap, so we can call "close by"
  // registers (82551 PM register).
  mem = I2C_PAGE_ALIGN(mem + I825XX_PCI_SMB_OFFSET);

  ldata->pci_smb_access = ioremap_nocache(mem, PAGE_SIZE);
  
  if(ldata->pci_smb_access == 0){
    i825xx_remove(adap);
    return -ENOMEM;
  }

  ldata->pci_smb_access += I2C_PAGE_OFFSET(I825XX_PCI_SMB_OFFSET);
  ldata->pci_hostif_access = NULL;

#ifdef I825XX_HOSTIF_OFFSET
  if (i825xx_is_hostif_supported(pcid)){
      mem = i825xx_iomem(pcid);
      mem = I2C_PAGE_ALIGN(mem + I825XX_HOSTIF_OFFSET);
      ldata->pci_hostif_access = ioremap_nocache(mem, PAGE_SIZE);
      ldata->pci_hostif_access += I2C_PAGE_OFFSET(I825XX_HOSTIF_OFFSET);
  }
#endif

  if(i825xx_smb_supported(ldata->pci_smb_access) == -1){
    i825xx_remove(adap);
    return -ENODEV;
  }
              
  {
    char str[256];
    sprintf(str, "%s %s at %s",I825XX_BUS_TYPE, I825XX_DEV_NAME,
        pcid->slot_name);
    strncpy(adap->name, str, sizeof(adap->name));
  }

#ifdef I825XX_SYNC_WA
  //TBD we assume the adapter is up ?!
  ldata->state = I825XX_UP;
#endif
  ldata->pcid = pcid;
  return 0;
}

#ifdef I825XX_SYNC_WA
static void
i825xx_set_pm_state(enum i825xx_pm_state state)
{
  struct list_head * pos;
  struct i825xx_data * ldata;
  list_for_each(pos,&i825xx_list){
    ldata = list_entry(pos, struct i825xx_data, node);    
#ifdef I2C_VER_2_6_X
    down(&ldata->adap->lock);
#else
    down(&ldata->adap->bus);
#endif
    if(state == I825XX_DOWN){
      i825xx_arp_en(ldata->pci_smb_access);
      ldata->state = I825XX_DOWN;
    }else{
      ldata->state = I825XX_UP;
      //i825xx_arp_dis(ldata->pci_smb_access);
    } 
#ifdef I2C_VER_2_6_X
    up(&ldata->adap->lock);
#else
    up(&ldata->adap->bus); 
#endif
  }
}


static int
i825xx_pm_event(struct pm_dev *dev, pm_request_t rqst, void *data)
{
    switch(rqst){
    case PM_SUSPEND:
        i825xx_set_pm_state(I825XX_DOWN);
        break;
    case PM_RESUME:
        i825xx_set_pm_state(I825XX_UP);
        break;
    }
    return 0;
}
static int
i825xx_reboot_notify(struct notifier_block *nt,
                     unsigned long type, void *unused)
{
    i825xx_set_pm_state(I825XX_DOWN);
    return NOTIFY_DONE;
}

static int 
i825xx_network_notify(struct notifier_block *this, unsigned long event, void *ptr)
{
  //  struct net_device *dev = ptr;
  struct list_head * pos;
  struct i825xx_data * ldata;
  
  list_for_each(pos,&i825xx_list){
    ldata = list_entry(pos, struct i825xx_data, node);

    if(ptr == pci_get_drvdata(ldata->pcid)){
  
#ifdef I2C_VER_2_6_X
      down(&ldata->adap->lock);
#else
      down(&ldata->adap->bus);
#endif
      //release SCL, SDA, internal bus incase they are down
      i825xx_setsda(ldata, 1);
      udelay(2);
      i825xx_setscl(ldata, 1);

      if( ldata->type == INTERNAL ){
    udelay(2);
    i825xx_release_grant(ldata);
      }
#ifdef I2C_VER_2_6_X
      up(&ldata->adap->lock);
#else
      up(&ldata->adap->bus); 
#endif
    }
  }
 
  return NOTIFY_DONE;
}

#endif /* I825XX_SYNC_WA */

int __init i825xx_init(void)
{
  int res = -ENODEV;
  struct pci_dev *dev = NULL;

  if(pci_present() == 0){
    return -ENODEV;
  }
  while( (dev = pci_find_device(PCI_VENDOR_ID_INTEL,PCI_ANY_ID,dev))){
    res = i825xx_probe(dev);
  }
  if(list_empty(&i825xx_list) == 0){
#ifdef I825XX_SYNC_WA
    register_reboot_notifier(&i825xx_reboot_blk);
    i825xx_pm = pm_register(PM_UNKNOWN_DEV, PM_SYS_UNKNOWN, i825xx_pm_event);
    register_netdevice_notifier(&i825xx_network_blk);
#endif
    printk("Loading %s SMBus driver. Version %s\n", I825XX_DEV_NAME, COMPONENT_VERSION);
    return 0;
  }
  else 
    return res;
}



void __exit i825xx_cleanup(void)
{
  struct list_head * tmp;
  struct i825xx_data * ldat;


#ifdef I825XX_SYNC_WA
  //unregister before we remove the i2c_adapter
  //TBD we will lose any notifications occuring
  // before we unregister the device.
  if(list_empty(&i825xx_list) == 0){
    unregister_reboot_notifier(&i825xx_reboot_blk);
    unregister_netdevice_notifier(&i825xx_network_blk);

    if(i825xx_pm != NULL){
      pm_unregister(i825xx_pm);
    }
  }
#endif

  while(list_empty(&i825xx_list) == 0){

    tmp = i825xx_list.next;
    list_del(tmp);
    
    ldat = list_entry(tmp, struct i825xx_data, node);
    i825xx_remove(ldat->adap);
  }

}


#ifdef MODULE_LICENSE
MODULE_LICENSE("GPL");
#endif

MODULE_AUTHOR("Intel Corporation, <linux.nics@intel.com>");
MODULE_DESCRIPTION(I825XX_DEV_NAME" Smbus driver. Version " COMPONENT_VERSION);



EXPORT_NO_SYMBOLS;


module_init(i825xx_init);
module_exit(i825xx_cleanup);

