/*******************************************************************************


"This software program is licensed subject to the GNU General Public License 
(GPL). Version 2, June 1991, available at 
<http://www.fsf.org/copyleft/gpl.html>"

GNU General Public License 

Version 2, June 1991

Copyright (C) 1989, 1991 Free Software Foundation, Inc.  
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

Everyone is permitted to copy and distribute verbatim copies of this license
document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to 
share and change it. By contrast, the GNU General Public License is intended
to guarantee your freedom to share and change free software--to make sure 
the software is free for all its users. This General Public License applies 
to most of the Free Software Foundation's software and to any other program 
whose authors commit to using it. (Some other Free Software Foundation 
software is covered by the GNU Library General Public License instead.) You 
can apply it to your programs, too.

When we speak of free software, we are referring to freedom, not price. Our
General Public Licenses are designed to make sure that you have the freedom 
to distribute copies of free software (and charge for this service if you 
wish), that you receive source code or can get it if you want it, that you 
can change the software or use pieces of it in new free programs; and that 
you know you can do these things.

To protect your rights, we need to make restrictions that forbid anyone to 
deny you these rights or to ask you to surrender the rights. These 
restrictions translate to certain responsibilities for you if you distribute
copies of the software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or 
for a fee, you must give the recipients all the rights that you have. You 
must make sure that they, too, receive or can get the source code. And you 
must show them these terms so they know their rights.
 
We protect your rights with two steps: (1) copyright the software, and (2) 
offer you this license which gives you legal permission to copy, distribute 
and/or modify the software. 

Also, for each author's protection and ours, we want to make certain that 
everyone understands that there is no warranty for this free software. If 
the software is modified by someone else and passed on, we want its 
recipients to know that what they have is not the original, so that any 
problems introduced by others will not reflect on the original authors' 
reputations. 

Finally, any free program is threatened constantly by software patents. We 
wish to avoid the danger that redistributors of a free program will 
individually obtain patent licenses, in effect making the program 
proprietary. To prevent this, we have made it clear that any patent must be 
licensed for everyone's free use or not licensed at all. 

The precise terms and conditions for copying, distribution and modification 
follow. 

TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice
   placed by the copyright holder saying it may be distributed under the 
   terms of this General Public License. The "Program", below, refers to any
   such program or work, and a "work based on the Program" means either the 
   Program or any derivative work under copyright law: that is to say, a 
   work containing the Program or a portion of it, either verbatim or with 
   modifications and/or translated into another language. (Hereinafter, 
   translation is included without limitation in the term "modification".) 
   Each licensee is addressed as "you". 

   Activities other than copying, distribution and modification are not 
   covered by this License; they are outside its scope. The act of running 
   the Program is not restricted, and the output from the Program is covered 
   only if its contents constitute a work based on the Program (independent 
   of having been made by running the Program). Whether that is true depends
   on what the Program does. 

1. You may copy and distribute verbatim copies of the Program's source code 
   as you receive it, in any medium, provided that you conspicuously and 
   appropriately publish on each copy an appropriate copyright notice and 
   disclaimer of warranty; keep intact all the notices that refer to this 
   License and to the absence of any warranty; and give any other recipients 
   of the Program a copy of this License along with the Program. 

   You may charge a fee for the physical act of transferring a copy, and you 
   may at your option offer warranty protection in exchange for a fee. 

2. You may modify your copy or copies of the Program or any portion of it, 
   thus forming a work based on the Program, and copy and distribute such 
   modifications or work under the terms of Section 1 above, provided that 
   you also meet all of these conditions: 

   * a) You must cause the modified files to carry prominent notices stating 
        that you changed the files and the date of any change. 

   * b) You must cause any work that you distribute or publish, that in 
        whole or in part contains or is derived from the Program or any part 
        thereof, to be licensed as a whole at no charge to all third parties
        under the terms of this License. 

   * c) If the modified program normally reads commands interactively when 
        run, you must cause it, when started running for such interactive 
        use in the most ordinary way, to print or display an announcement 
        including an appropriate copyright notice and a notice that there is
        no warranty (or else, saying that you provide a warranty) and that 
        users may redistribute the program under these conditions, and 
        telling the user how to view a copy of this License. (Exception: if 
        the Program itself is interactive but does not normally print such 
        an announcement, your work based on the Program is not required to 
        print an announcement.) 

   These requirements apply to the modified work as a whole. If identifiable 
   sections of that work are not derived from the Program, and can be 
   reasonably considered independent and separate works in themselves, then 
   this License, and its terms, do not apply to those sections when you 
   distribute them as separate works. But when you distribute the same 
   sections as part of a whole which is a work based on the Program, the 
   distribution of the whole must be on the terms of this License, whose 
   permissions for other licensees extend to the entire whole, and thus to 
   each and every part regardless of who wrote it. 

   Thus, it is not the intent of this section to claim rights or contest 
   your rights to work written entirely by you; rather, the intent is to 
   exercise the right to control the distribution of derivative or 
   collective works based on the Program. 

   In addition, mere aggregation of another work not based on the Program 
   with the Program (or with a work based on the Program) on a volume of a 
   storage or distribution medium does not bring the other work under the 
   scope of this License. 

3. You may copy and distribute the Program (or a work based on it, under 
   Section 2) in object code or executable form under the terms of Sections 
   1 and 2 above provided that you also do one of the following: 

   * a) Accompany it with the complete corresponding machine-readable source 
        code, which must be distributed under the terms of Sections 1 and 2 
        above on a medium customarily used for software interchange; or, 

   * b) Accompany it with a written offer, valid for at least three years, 
        to give any third party, for a charge no more than your cost of 
        physically performing source distribution, a complete machine-
        readable copy of the corresponding source code, to be distributed 
        under the terms of Sections 1 and 2 above on a medium customarily 
        used for software interchange; or, 

   * c) Accompany it with the information you received as to the offer to 
        distribute corresponding source code. (This alternative is allowed 
        only for noncommercial distribution and only if you received the 
        program in object code or executable form with such an offer, in 
        accord with Subsection b above.) 

   The source code for a work means the preferred form of the work for 
   making modifications to it. For an executable work, complete source code 
   means all the source code for all modules it contains, plus any 
   associated interface definition files, plus the scripts used to control 
   compilation and installation of the executable. However, as a special 
   exception, the source code distributed need not include anything that is 
   normally distributed (in either source or binary form) with the major 
   components (compiler, kernel, and so on) of the operating system on which
   the executable runs, unless that component itself accompanies the 
   executable. 

   If distribution of executable or object code is made by offering access 
   to copy from a designated place, then offering equivalent access to copy 
   the source code from the same place counts as distribution of the source 
   code, even though third parties are not compelled to copy the source 
   along with the object code. 

4. You may not copy, modify, sublicense, or distribute the Program except as
   expressly provided under this License. Any attempt otherwise to copy, 
   modify, sublicense or distribute the Program is void, and will 
   automatically terminate your rights under this License. However, parties 
   who have received copies, or rights, from you under this License will not
   have their licenses terminated so long as such parties remain in full 
   compliance. 

5. You are not required to accept this License, since you have not signed 
   it. However, nothing else grants you permission to modify or distribute 
   the Program or its derivative works. These actions are prohibited by law 
   if you do not accept this License. Therefore, by modifying or 
   distributing the Program (or any work based on the Program), you 
   indicate your acceptance of this License to do so, and all its terms and
   conditions for copying, distributing or modifying the Program or works 
   based on it. 

6. Each time you redistribute the Program (or any work based on the 
   Program), the recipient automatically receives a license from the 
   original licensor to copy, distribute or modify the Program subject to 
   these terms and conditions. You may not impose any further restrictions 
   on the recipients' exercise of the rights granted herein. You are not 
   responsible for enforcing compliance by third parties to this License. 

7. If, as a consequence of a court judgment or allegation of patent 
   infringement or for any other reason (not limited to patent issues), 
   conditions are imposed on you (whether by court order, agreement or 
   otherwise) that contradict the conditions of this License, they do not 
   excuse you from the conditions of this License. If you cannot distribute 
   so as to satisfy simultaneously your obligations under this License and 
   any other pertinent obligations, then as a consequence you may not 
   distribute the Program at all. For example, if a patent license would 
   not permit royalty-free redistribution of the Program by all those who 
   receive copies directly or indirectly through you, then the only way you 
   could satisfy both it and this License would be to refrain entirely from 
   distribution of the Program. 

   If any portion of this section is held invalid or unenforceable under any
   particular circumstance, the balance of the section is intended to apply
   and the section as a whole is intended to apply in other circumstances. 

   It is not the purpose of this section to induce you to infringe any 
   patents or other property right claims or to contest validity of any 
   such claims; this section has the sole purpose of protecting the 
   integrity of the free software distribution system, which is implemented 
   by public license practices. Many people have made generous contributions
   to the wide range of software distributed through that system in 
   reliance on consistent application of that system; it is up to the 
   author/donor to decide if he or she is willing to distribute software 
   through any other system and a licensee cannot impose that choice. 

   This section is intended to make thoroughly clear what is believed to be 
   a consequence of the rest of this License. 

8. If the distribution and/or use of the Program is restricted in certain 
   countries either by patents or by copyrighted interfaces, the original 
   copyright holder who places the Program under this License may add an 
   explicit geographical distribution limitation excluding those countries, 
   so that distribution is permitted only in or among countries not thus 
   excluded. In such case, this License incorporates the limitation as if 
   written in the body of this License. 

9. The Free Software Foundation may publish revised and/or new versions of 
   the General Public License from time to time. Such new versions will be 
   similar in spirit to the present version, but may differ in detail to 
   address new problems or concerns. 

   Each version is given a distinguishing version number. If the Program 
   specifies a version number of this License which applies to it and "any 
   later version", you have the option of following the terms and 
   conditions either of that version or of any later version published by 
   the Free Software Foundation. If the Program does not specify a version 
   number of this License, you may choose any version ever published by the 
   Free Software Foundation. 

10. If you wish to incorporate parts of the Program into other free programs
    whose distribution conditions are different, write to the author to ask 
    for permission. For software which is copyrighted by the Free Software 
    Foundation, write to the Free Software Foundation; we sometimes make 
    exceptions for this. Our decision will be guided by the two goals of 
    preserving the free status of all derivatives of our free software and 
    of promoting the sharing and reuse of software generally. 

   NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
    FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN 
    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES 
    PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
    EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
    ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH 
    YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL 
    NECESSARY SERVICING, REPAIR OR CORRECTION. 

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
    REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
    DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
    DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
    (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
    INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
    THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER OR 
    OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest 
possible use to the public, the best way to achieve this is to make it free 
software which everyone can redistribute and change under these terms. 

To do so, attach the following notices to the program. It is safest to 
attach them to the start of each source file to most effectively convey the
exclusion of warranty; and each file should have at least the "copyright" 
line and a pointer to where the full notice is found. 

one line to give the program's name and an idea of what it does.
Copyright (C) yyyy  name of author

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the Free 
Software Foundation; either version 2 of the License, or (at your option) 
any later version.

This program is distributed in the hope that it will be useful, but WITHOUT 
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 
Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Also add information on how to contact you by electronic and paper mail. 

If the program is interactive, make it output a short notice like this when 
it starts in an interactive mode: 

Gnomovision version 69, Copyright (C) year name of author Gnomovision comes 
with ABSOLUTELY NO WARRANTY; for details type 'show w'.  This is free 
software, and you are welcome to redistribute it under certain conditions; 
type 'show c' for details.

The hypothetical commands 'show w' and 'show c' should show the appropriate 
parts of the General Public License. Of course, the commands you use may be 
called something other than 'show w' and 'show c'; they could even be 
mouse-clicks or menu items--whatever suits your program. 

You should also get your employer (if you work as a programmer) or your 
school, if any, to sign a "copyright disclaimer" for the program, if 
necessary. Here is a sample; alter the names: 

Yoyodyne, Inc., hereby disclaims all copyright interest in the program 
'Gnomovision' (which makes passes at compilers) written by James Hacker.

signature of Ty Coon, 1 April 1989
Ty Coon, President of Vice

This General Public License does not permit incorporating your program into 
proprietary programs. If your program is a subroutine library, you may 
consider it more useful to permit linking proprietary applications with the 
library. If this is what you want to do, use the GNU Library General Public 
License instead of this License.

*******************************************************************************/

#include <linux/delay.h>
#include "mng_host_cmds.h"

//returns num of dwords the specific command needs to read/write (including header)
#define MNG_DWORD_CMD_SIZE(x) ((sizeof(struct host_command_hdr)+x)/sizeof(u32)+((x%sizeof(u32))?1:0)) 
 
#define MNG_HOST_CMD_RETRY_COUNT 20					   
					   
//Watchdog command defines										
#define CASF_WDTIMER_VERSION            0x10
#define CASF_WD_SENSORTYPE              0x20    //sensor type 20h (os hung)
#define CASF_WD_EVTTYPE                 0x6F    //event type
#define CASF_WD_EVTOFFSET               0x01    //event offset 01h(run-time stop) or 00h(timer expired)
#define CASF_WD_EVTSOURCETYPE           0x68    //event source type (68h - ASF 1.0 implementatoin)
#define CASF_WD_EVTSEVERITY             0x10    //event severity
#define CASF_WD_SENSORDEVICE            0xFF    //sensor device
#define CASF_WD_SENSORNO                0xFF    //sensor number
#define CASF_WD_ENTITY                  0x23    //entity(OS-entity)
#define CASF_WD_ENTITYINSTANCE          0x00    //entity instance
										
										
inline int mng_host_if_enabled(struct mng_dev *dev) {

	__u32 fwsm;
	mng_sem_reg_read(dev, MNG_FWSM_OFFSET, &fwsm);

	if (fwsm & MNG_FWSM_MODE_MASK) {
		return 0;
	} else {
		return -1;
	}	
}


/**
 * Compute Cheksum for the current command. 
 * Write result to the header.cheksum field
 */
static void mng_host_cmd_add_checksum(struct host_command *cmd)
{
	int  i = 0;
	__u8   tmp_data = 0;
	__u8 * tmp_ptr = (u8 *)cmd;
	int  length = cmd->header.length + sizeof(cmd->header);
	cmd->header.checksum = 0;
	for (i = 0; i < length ; i++) {
		tmp_data += tmp_ptr[i];
	}
	cmd->header.checksum = 0xff - tmp_data + 1;
}


int mng_do_host_cmd(struct mng_dev *dev, struct host_command *cmd) {
	u32 control = 0;
	int count = 0;
	int ret = 0;

	//For DEBUG prints
	__u8 cmd_id = cmd->header.command;

	down(&(dev->host_cmd_sem));

	if ((dev->pci_sem_regs_access == NULL) || (dev->pci_hostif_access == NULL)) {
		ret = -ENOMEM;
		goto out;
	}

	//check if host i/f is enabled by checking the mode in the FWSM reg
	if (mng_host_if_enabled(dev)) {
		printk(KERN_DEBUG "MNG: HOST-IF not active\n");
		ret = -EIO;
		goto out;
	}

	//Check if firmware is enabled by reading control reg
	mng_data_read(MNG_GET_HOST_MEM_PTR(dev,MNG_FW_CONTROL_REG_OFFSET), 1, &control);
	if ((control & MNG_FW_ENABLED_BIT) == 0){
		printk(KERN_DEBUG "MNG: HOST FW Not enabled. Host Command ID %d\n", cmd_id);
		ret = -EIO;	
		goto out;
	}
		
	if (cmd->header.length > MNG_HOST_COMMAND_MAX_DATA_LENGTH) {
		ret = -EINVAL;
		goto out;
	}

	//Setup data in area 0x8800 ... 
	mng_data_write(MNG_GET_HOST_MEM_PTR(dev,MNG_HOSTIF_START_OFFSET), 
                   MNG_DWORD_CMD_SIZE(cmd->header.length),
				   (u32*)cmd);

	//Start command execution by setting the command bit in the control register
	control |= MNG_COMMAND_BIT;	
	mng_data_write(MNG_GET_HOST_MEM_PTR(dev, MNG_FW_CONTROL_REG_OFFSET), 
					1,
					&control);
	
	//Poll for command bit in the control register to be cleared
	do{
		mdelay(MNG_SLEEP_MSEC);
	 	mng_data_read(MNG_GET_HOST_MEM_PTR(dev,MNG_FW_CONTROL_REG_OFFSET),
					  1,
					  &control);
		
		if (!(control & MNG_COMMAND_BIT)) {
		  break;
		}
	}while( count++ < MNG_MAX_RETRIES );

	if (control & MNG_COMMAND_BIT) {
		printk(KERN_DEBUG "MNG: HOST Cmd Bit Not Cleared After Max Retries. Host Command ID %d\n", cmd_id);
		ret = -EIO;
		goto out;
	}

	//check status valid bit
	if( !(control & MNG_STATUS_VALID_BIT) ){
		printk(KERN_DEBUG "MNG: HOST Status Invalid. Host Command ID %d\n", cmd_id);
		ret = -EIO;
		goto out;
	}

	//read status into cmd struct:

	//first read the header:
	mng_data_read(MNG_GET_HOST_MEM_PTR(dev, MNG_HOSTIF_START_OFFSET), 
				  MNG_DWORD_CMD_SIZE(0),
				  (u32*)cmd);

	//then read the entire status data, according to the length in the header
	mng_data_read(MNG_GET_HOST_MEM_PTR(dev, MNG_HOSTIF_START_OFFSET), 
				  MNG_DWORD_CMD_SIZE(cmd->header.length), 
				  (u32*)cmd);

	out:
	up(&(dev->host_cmd_sem));
    return ret;		
}


int mng_host_cmd_start_wdog(struct mng_dev *dev) {
	struct host_command cmd;
	int retry_count = MNG_HOST_CMD_RETRY_COUNT;
	int err=0;

	memset((void*)&cmd.header, 0, sizeof(cmd.header) );
	cmd.header.command = START_ASF_WATCHDOG_CMD;
	cmd.header.length = 16;
	
	cmd.data[0] = dev->wdog.interval & 0x00ff;
	cmd.data[1] = (dev->wdog.interval & 0xff00) >> 8;
	cmd.data[2] = CASF_WD_SENSORTYPE;
	cmd.data[3] = CASF_WD_EVTTYPE;
	cmd.data[4] = CASF_WD_EVTOFFSET;
	cmd.data[5] = CASF_WD_EVTSOURCETYPE;
	
	cmd.data[6]  = CASF_WD_EVTSEVERITY;
	cmd.data[7]  = CASF_WD_SENSORDEVICE;
	cmd.data[8] = CASF_WD_SENSORNO;
	cmd.data[9] = CASF_WD_ENTITY;
	cmd.data[10] = CASF_WD_ENTITYINSTANCE;

	memset((void*)&(cmd.data[11]), 0, 5 );

	mng_host_cmd_add_checksum(&cmd);

	while (retry_count) {
		err = mng_do_host_cmd(dev, &cmd);
		if (err == 0) {
			break;
		}
		retry_count--;
	}

	if (err) {
		printk(KERN_DEBUG "MNG: Start Watchdog command could not be completed. Error: %d\n", err);
		return err;
	}
	
	if (cmd.header.status != MNG_HOSTCMD_STATUS_OK) {
		printk(KERN_DEBUG "MNG: Start Watchdog command failed with status: %d\n", cmd.header.status);
		return -EIO;
	}

	return 0;
}


int mng_host_cmd_stop_wdog(struct mng_dev *dev) {
	struct host_command cmd;
	int retry_count = MNG_HOST_CMD_RETRY_COUNT;
	int err=0;

	memset((void*)&cmd.header, 0, sizeof(cmd.header) );
	cmd.header.command = STOP_ASF_WATCHDOG_CMD;
	cmd.header.length = 0;

	mng_host_cmd_add_checksum(&cmd);

	while (retry_count) {
		err = mng_do_host_cmd(dev, &cmd);
		if (err == 0) {
			break;
		}
		retry_count--;
	}

	if (err) {
		printk(KERN_DEBUG "MNG: Start Watchdog command could not be completed. Error: %d\n", err);
		return err;
	}
	
	if (cmd.header.status != MNG_HOSTCMD_STATUS_OK) {
		printk(KERN_DEBUG "MNG: Start Watchdog command failed with status: %d\n", cmd.header.status);
		return -EIO;
	}

	return 0;
}


int mng_host_cmd_set_system_state(struct mng_dev *dev, __u8 state) {

	struct host_command cmd;
	int retry_count = MNG_HOST_CMD_RETRY_COUNT;
	int err=0;

	memset((void*)&cmd.header, 0, sizeof(cmd.header) );
	cmd.header.command = SET_ASF_SYSTEM_STATE;
	cmd.header.length = 1;

	cmd.data[0] = state;

	mng_host_cmd_add_checksum(&cmd);

	while (retry_count) {
		err = mng_do_host_cmd(dev, &cmd);
		if (err == 0) {
			break;
		}
		retry_count--;
	}

	if (err) {
		printk(KERN_DEBUG "MNG: Set System State command could not be completed. Error: %d\n", err);
		return err;
	}
	
	if (cmd.header.status != MNG_HOSTCMD_STATUS_OK) {
		printk(KERN_DEBUG "MNG: Set System State command failed with status: %d\n", cmd.header.status);
		return -EIO;
	}

	return 0;
}


static int mng_host_cmd_get_asf_reg(struct mng_dev *dev, __u8 reg_addr, __u8 *reg_data) {

	struct host_command cmd;
	int retry_count = MNG_HOST_CMD_RETRY_COUNT;
	int err=0;

	memset((void*)&cmd.header, 0, sizeof(cmd.header) );
	cmd.header.command = GET_ASF_REGISTER_CMD;
	cmd.header.length = 2;

	cmd.data[0] = reg_addr;
	cmd.data[1] = 0;
	cmd.data[2] = 0;
	cmd.data[3] = 0;

	mng_host_cmd_add_checksum(&cmd);

	while (retry_count) {
		err = mng_do_host_cmd(dev, &cmd);
		if (err == 0) {
			break;
		}
		retry_count--;
	}

	if (err) {
		printk(KERN_DEBUG "MNG: Get ASF Register command could not be completed. Error: %d\n", err);
		return err;
	}
	
	if (cmd.header.status != MNG_HOSTCMD_STATUS_OK) {
		printk(KERN_DEBUG "MNG: Get ASF Register command failed with status: %d\n", cmd.header.status);
		return -EIO;
	}

	*reg_data = cmd.data[2];

	return 0;
}


static int mng_host_cmd_set_asf_reg(struct mng_dev *dev, __u8 reg_addr, __u8 reg_data) {

	struct host_command cmd;
	int retry_count = MNG_HOST_CMD_RETRY_COUNT;
	int err=0;

	memset((void*)&cmd.header, 0, sizeof(cmd.header) );
	cmd.header.command = SET_ASF_REGISTER_CMD;
	cmd.header.length = 4;

	cmd.data[0] = reg_addr;
	cmd.data[2] = reg_data;
	cmd.data[1] = 0;	
	cmd.data[3] = 0;

	mng_host_cmd_add_checksum(&cmd);

	while (retry_count) {
		err = mng_do_host_cmd(dev, &cmd);
		if (err == 0) {
			break;
		}
		retry_count--;
	}

	if (err) {
		printk(KERN_DEBUG "MNG: Set ASF Register command could not be completed. Error: %d\n", err);
		return err;
	}
	
	if (cmd.header.status != MNG_HOSTCMD_STATUS_OK) {
		printk(KERN_DEBUG "MNG: Set ASF Register command failed with status: %d\n", cmd.header.status);
		return -EIO;
	}

	return 0;
}


int mng_host_cmd_set_arp_en(struct mng_dev *dev, int enable) {

	int err;
	__u8 reg;

	err = mng_host_cmd_get_asf_reg(dev, 0xE2, &reg);
	if (err) {
		printk(KERN_DEBUG "MNG: Set ARP enable failed\n");
		return err;
	}

	if (enable) {
		reg |= 0x02;
	} else {
		reg &= ~0x02;
	}

	err = mng_host_cmd_set_asf_reg(dev, 0xE2, reg);
	if (err) {
		printk(KERN_DEBUG "MNG: Set ARP enable failed\n");
		return err;
	}

	return 0;
}
