#! /bin/bash

#
# asfd       Bring up/down the ASF agent
#
# chkconfig: 2345 14 09
# description: Activates/Deactivates the ASF agent daemon
# probe: true

# Source function library.
. /etc/init.d/functions

. /etc/sysconfig/network

# Check that networking is up.
[ "${NETWORKING}" = "no" ] && exit 0

# See how we were called.
case "$1" in
  start)
	I2C_NEEDED="no"
	modprobe i2c-i8254x 1 > /dev/null 2>&1 #gigabit bit bang module
	if [ $? == 0 ]; then
	    I2C_NEEDED="yes"
	fi
	modprobe i2c-i82551 1 > /dev/null 2>&1 #FE bit bang module	
	if [ $? == 0 ]; then
	    I2C_NEEDED="yes"
	fi
	
	if [ "${I2C_NEEDED}" == "yes" ]; then	
	    action $"Loading the I2C modules: " modprobe i2c-dev
	    action $"Loading the watchdog module: " modprobe asfwdg
	fi
	modprobe mng_host_if > /dev/null 2>&1
	if [ "$?" -eq 0 ]; then
	    action $"Loading the host-i/f driver: " /bin/true
	else
    	    action $"Loading the host-i/f driver: " /bin/false
	fi
	/usr/sbin/asfd
	action $"Starting ASF agent: " touch /var/lock/subsys/asfd
	;;
  stop)
        action $"Shutting down ASF agent: " rm -f /var/lock/subsys/asfd
	kill -15 `pidof asfd` 1 > /dev/null 2>&1
	while [ -n "`pidof asfd`" ]; do usleep 50000;
	done;
	;;
  restart|reload)
	$0 stop
	$0 start
	;;
  status)
	echo -n "ASFD Daemon status: "
	status /usr/sbin/asfd
	;;
  version)
        echo -n "Package asf-apps "
        rpm -q --queryformat Version:\ %{VERSION}\ Build:\ %{RELEASE}\\n asf-apps
        echo -n "Package asf-modules "
        rpm -q --queryformat Version:\ %{VERSION}\ Build:\ %{RELEASE}\\n asf-modules

        /usr/sbin/asfd --v
	if [ -e /usr/sbin/asfcli ]; then
		/usr/sbin/asfcli version
	fi
	if [ -e /usr/sbin/alertapp ]; then
		/usr/sbin/alertapp --version
	fi
	modinfo -d i2c-i8254x
	modinfo -d i2c-i82551
	modinfo -d asfwdg
	modinfo -d mng_host_if
	;;
  *)
        echo $"Usage: $0 {start|stop|restart|reload|status|version}"
        exit 1
esac

exit 0
