/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_ATI_H
#define GATOS_ATI_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_ATI_C
#define WHERE
#else
#define WHERE	extern
#endif

#include <stdio.h>

#define XY(X,Y)		( ( ((u32)(X)) << 16 ) + ((u32)(Y)) )

/* OVERLAY_SCALE_CNTL values */
#define DISABLE_VIDEO	0x0000007B
#define ENABLE_VIDEO	\
	(0xC4000001|((gatos.gamma)?((4-gatos.gamma)<<5):0)|(gatos.cold<<1))

/* ATI function declarations */

int	ati_init(void) ;

int	ati_setcolorkey(void) ;
void	ati_enable_video(int) ;
void	ati_enable_capture(int) ;
void	ati_buffer_mode(void) ;
int	ati_setcaptsize(void) ;
int	ati_pollscreen(int) ;
void	ati_setgeometry(void) ;
int	ati_setgamma(void) ;
int	ati_setcold(void) ;

void	ati_capture(FILE*, int) ;
void	ati_playback(FILE*, int) ;

void	ati_dumpregs(void) ;

#ifdef GATOS_ATI_C
static int	ati_chipid(int, int, int, int) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
