/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>

#define LIMIT(x) (((x)<0)?0:((x)>255)?255:(x))

char s[2000];

void * do_alloc(long a,long b)
{
void *r;
r=calloc(a,b);
while(r==NULL){
	r=calloc(a,b);
	sleep(1);
	}
return r;
}

int do_write(int fd,unsigned char *data,long size)
{
long chunk,r,i;
chunk=size;

i=0;
while(chunk>0){
	r=write(fd,data+i,chunk);
	if(r<0){
		fprintf(stderr,"atisplit:writing to file \"%s\":",s);fflush(stderr);
		perror("");fflush(stderr);
		return -1;
		}
	chunk-=r;
	i+=r;
	}
return 0;
}

int main(int argc,char *argv[]) 
{

  int file;
  char *name,*name_2;
  unsigned char *data,*buf;
  struct stat st;
  long i;
  long file_ct;
  int fout;
  int h,v;
  long chunk;
  long y,x;
  
  /*  
  int y, cr, cb, r, g, b, h, v, i, j, res, n = 0 ; FILE *file ;
  unsigned char rgb[3], buf[9], name[13] ; struct stat st ;
*/

  if(argc>1){
  	name=argv[1];
	}else{
	name="gatos.yuv";
	}
  if(argc>2){
	name_2=argv[2];
	} else {
	name_2="tv%06d.yuv";
	}
  file=open(name,O_RDONLY);
  if(file<0){
        fprintf(stderr,"atisplit:opening file \"%s\":",name);fflush(stderr);
	perror("");fflush(stderr);
	return -1;
	}
  fstat(file,&st);
  data=mmap(NULL,st.st_size,PROT_READ,MAP_SHARED,file,0);	 
  if(data==NULL){
  	fprintf(stderr,"atisplit:opening file \"%s\":",name);fflush(stderr);
	perror("");fflush(stderr);
	return -1;
	}
  i=0;
  file_ct=1;
  while(i<st.st_size){
  	memcpy(s,data+i,7);
	s[7]=0;
  	sscanf(s,"%3d %3d",&h,&v);
	i+=8;
	sprintf(s,name_2,file_ct);
	chunk=h*v*2;
	fout=open(s,O_WRONLY|O_CREAT, S_IREAD|S_IWRITE);
	if(fout<0){
		fprintf(stderr,"atisplit:writing to file \"%s\":",s);fflush(stderr);
		perror("");fflush(stderr);
		i+=chunk;
		file_ct++;
		continue;
		}
	buf=do_alloc(h,sizeof(char));
	for(y=0;y<v;y++){
		for(x=0;x<h;x++){			
			buf[x]=*(data+i+2*y*h+2*x);
			}
		do_write(fout,buf,h);
		}
	for(y=0;y<v/2;y++){
		for(x=0;x<h/2;x++){		
			buf[x]=(*(data+i+4*y*h+4*x+1)+	
			       *(data+i+4*y*h+2*h+4*x+1))>>1;	
			}
		do_write(fout,buf,h/2);
		}
	for(y=0;y<v/2;y++){
		for(x=0;x<h/2;x++){		
			buf[x]=(*(data+i+4*y*h+4*x+3)+	
			       *(data+i+4*y*h+2*h+4*x+3))>>1;	
			}
		do_write(fout,buf,h/2);
		}
	free(buf);
	i+=chunk;
	close(fout);
	printf("%s:%d:%d\n",s,h,v);
	file_ct++;
  	}
fflush(stdout);
return 0;
}

 /*
  while ( fread(buf,1,8,stdin) == 8 ) {

    while (1) {
      snprintf(name,sizeof(name),"tv%06d.ppm",++n) ;
      if (lstat(name,&st)) break ; }

    res = sscanf(buf,"%3d %3d\n",&h,&v) ; file = fopen(name,"w") ;
    if (!file) { perror("fopen() failed") ; exit(0) ; }
    fprintf(stderr,"aiwtoppm: %dx%d image: %s\n",h,v,name) ;
    fprintf(file,"P6\n%d %d\n255\n",h,v) ;

    for ( i=0 ; i<v ; i++ ) for ( j=0 ; j<h ; j+=2 ) {

	if (!fread(buf,4,1,stdin)) break ;
	cb = buf[1] - 128 ; cr = buf[3] - 128 ;

	y = buf[0] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	rgb[0] = LIMIT(r) ; rgb[1] = LIMIT(g) ; rgb[2] = LIMIT(b) ;
	fwrite(rgb,3,1,file) ;

	y = buf[2] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	rgb[0] = LIMIT(r) ; rgb[1] = LIMIT(g) ; rgb[2] = LIMIT(b) ;
	fwrite(rgb,3,1,file) ; }

    fclose(file) ; }

  return(0) ; */
