/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_I2CMPP_C 1

#include "gatos.h"
#include "i2c.h"
#include "i2cmpp.h"
#include "atiregs.h"

/* Private global vars */
static u32 i2c_prevstate=0 ;

/* ------------------------------------------------------------------------ */
/* Initialization routine */

int i2c_init_mpp(void) {

  u32 a ;
  int ok ;

  MPP_STROBE_SEQ = 0x00000000 ;
  mpp_setmode(MPP_Normal) ;
  MPP_STROBE_SEQ = 0x00008387 ;

  Impact_TV_reg_write(0x15,0x00005503) ;
  a = Impact_TV_reg_read(0x15) ;
  i2c_prevstate = 0x00005503 ;
  /* I don't know why need the following line,
     probably some magic value gets written into ImpactTV */
  i2c_stop_mpp() ;	/* Is this necessary ? /AA */
  i2c_start_mpp() ;
  ok = (i2c_readD() == 0) ;
  i2c_stop_mpp() ;
  return !ok ; }

/* ------------------------------------------------------------------------ */
/* Public routines */

void i2c_start_mpp(void) {
  i2c_dir(1) ;
  i2c_setD(1) ; I2C_SLEEP ;
  i2c_setC(1) ; I2C_SLEEP ;
  i2c_setD(0) ; I2C_SLEEP ;
  i2c_setC(0) ; I2C_SLEEP ; }

void i2c_stop_mpp(void) {
  i2c_dir(1) ;
  i2c_setC(0) ; I2C_SLEEP ;
  i2c_setD(0) ; I2C_SLEEP ;
  i2c_setC(1) ; I2C_SLEEP ;
  i2c_setD(1) ; I2C_SLEEP ;
  /*i2c_dir(0) ; i2c_setC(0) ; Can't be right ? /AA */ }

int i2c_sendbyte_mpp(u8 data) {
  int i ;
  data = ((data & 0xAA) >> 1) | ((data & 0x55) << 1) ;
  data = ((data & 0xCC) >> 2) | ((data & 0x33) << 2) ;
  data = ((data & 0xF0) >> 4) | ((data & 0x0F) << 4) ;
  i2c_dir(1) ;
  for ( i=0 ; i<8 ; i++ ) {
    i2c_setC(0) ; I2C_SLEEP ;
    i2c_setD(data&1) ; I2C_SLEEP ;
    i2c_setC(1) ; I2C_SLEEP ;
    data >>= 1 ; }
  i2c_setC(0) ; I2C_SLEEP ;
  return !i2c_ack_mpp(0) ; }

u8 i2c_readbyte_mpp(int last) {
 int i ; u8 ret = 0 ;
 i2c_dir(0) ;
 for ( i=0 ; i<8 ; i++ ) {
  i2c_setC(1) ; I2C_SLEEP ;
  ret = (ret<<1) | i2c_readD() ;
  i2c_setC(0) ; I2C_SLEEP ; }
 return ret ; }

/* ------------------------------------------------------------------------ */
/* Private routines */

static void mpp_setmode(int mode) {
  MPP_CONFIG = 0x8003b8b0 | (mode << 26) ; }

/* return 0 when ready */
static int mpp_notready(void) {
  return ((MPP_CONFIG & 0x40000000) != 0) ; }

static void i2c_dir(int set) {
  i2c_prevstate = (i2c_prevstate & 0xFFFFFFEF) | (set << 4) ;
  MPP_sendbyte(ImpactTV_data_lo_0,i2c_prevstate) ; }

static void i2c_setD(int set) {
  i2c_prevstate = (i2c_prevstate & 0xFFFFFFDF)| (set << 5) ;
  MPP_sendbyte(ImpactTV_data_lo_0,i2c_prevstate) ; }

static void i2c_setC(int set) {
  i2c_prevstate = (i2c_prevstate & 0xFFFFFFFD) | (set << 1) ;
  MPP_sendbyte(ImpactTV_data_lo_0,i2c_prevstate) ; }

static int i2c_readD_sub(void) {
 return MPP_readbyte(ImpactTV_data_lo_0) & 0xFF ; }

static int i2c_readD(void) {
  return (i2c_readD_sub()>>6) & 0x01 ; }

static int i2c_ack_mpp(int set) {
  int ret=0 ;
  if (set) {
    i2c_dir(1) ;
    i2c_setD(0) ; I2C_SLEEP ;
    i2c_setC(1) ; I2C_SLEEP ;
    i2c_setC(0) ; I2C_SLEEP ;
    i2c_dir(0) ; }
  else {
    i2c_dir(0) ; I2C_SLEEP ;
    i2c_setC(1) ; I2C_SLEEP ;
    ret = i2c_readD() ;
    i2c_setC(0) ; I2C_SLEEP ; }
  return !ret ; }

static void MPP_disable(void) {
  MPP_CONFIG = 0 ; }

/* this is in place MPP_sendbyte, note
   that I exchanged the arguments */
static void MPP_sendbyte(u8 addr, u32 data) {
  mpp_setmode(MPP_Normal) ;
  MPP_CONFIG = 0x8003B8B0 ;
  while (mpp_notready()) ;
  MPP_ADDR = addr ;
  MPP_DATA = data ; }

static u8 MPP_readbyte(u8 addr) {
  MPP_CONFIG = 0x8003B8B0 ;
  while (mpp_notready()) ;
  MPP_ADDR = addr ;
  mpp_setmode(MPP_Read) ;
  while (mpp_notready()) ;
  mpp_setmode(MPP_Normal) ;
  return MPP_DATA & 0xFF ; }

/* Impact TV seem to have at most 256 register but it
   has a 16 bit addressing. The higher byte is not used.
   So registers 0x15 or 0x115 are the same.
*/
static void Impact_TV_reg_write(u16 reg, u32 data) {
  MPP_sendbyte(ImpactTV_reg_lo,reg & 0xFF) ;
  MPP_sendbyte(ImpactTV_reg_hi,reg >> 8) ;
  MPP_sendbyte(ImpactTV_data_lo_0, data & 0xFF) ;
  MPP_sendbyte(ImpactTV_data_lo_1,(data >> 8) &0xFF) ;
  MPP_sendbyte(ImpactTV_data_hi_0,(data >> 16)&0xFF) ;
  MPP_sendbyte(ImpactTV_data_hi_1,(data >> 24)&0xFF) ;
}

static u32 Impact_TV_reg_read(u16 reg) {
  u32 ret ;
  MPP_sendbyte(ImpactTV_reg_lo,reg & 0xFF) ;
  MPP_sendbyte(ImpactTV_reg_hi,reg >> 8) ;
  ret = MPP_readbyte(ImpactTV_data_lo_0) ;
  ret |= MPP_readbyte(ImpactTV_data_lo_1) <<  8 ;
  ret |= MPP_readbyte(ImpactTV_data_hi_0) << 16 ;
  ret |= MPP_readbyte(ImpactTV_data_hi_1) << 24 ;
  return ret ; }
