/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_I2CMPP_H
#define GATOS_I2CMPP_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_I2CMPP_C
#define WHERE
#else
#define WHERE	extern
#endif

/* ATI MPP Registers and ImpacTV chip based I2C interface */

/* Impact TV registers */
#define ImpactTV_revcode	0xB
#define ImpactTV_init		0xA
/* register index */
#define ImpactTV_reg_hi		0x9
#define ImpactTV_reg_lo		0x8

/* for some reasons the data registers are repeated twice */
/* maybe writing twice is an analog of "execute" signal */

#define ImpactTV_data_hi_1	0x1B
#define ImpactTV_data_hi_0	0x1A
#define ImpactTV_data_lo_1	0x19
#define ImpactTV_data_lo_0	0x18

/* MPP bus mode */
#define MPP_Normal	0
#define MPP_Read	1

/* I2C function declarations */

int	i2c_init_mpp(void) ;
void	i2c_start_mpp(void) ;
void	i2c_stop_mpp(void) ;
u8	i2c_readbyte_mpp(int) ;
int	i2c_sendbyte_mpp(u8) ;

#ifdef GATOS_I2CMPP_C
/* routines that access MPP bus and ImpactTV chip */
static void	mpp_setmode(int) ;
static int	mpp_notready(void) ;
static void	i2c_dir(int) ;
static void	i2c_setD(int) ;
static void	i2c_setC(int) ;
static int	i2c_readD_sub(void) ;
static int	i2c_readD(void) ;
static int	i2c_ack_mpp(int) ;
static void	MPP_disable(void) ;
static void	MPP_sendbyte(u8, u32) ;
static u8	MPP_readbyte(u8) ;
static void	Impact_TV_reg_write(u16, u32) ;
static u32	Impact_TV_reg_read(u16) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
