/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_I2CSW_C 1

#include "gatos.h"
#include "i2c.h"
#include "i2csw.h"
#include "atiregs.h"

#include <stdio.h>
#include <errno.h>

#define I2C_SW_GETSCL	(*sclreg & sclset)
#define I2C_SW_GETSDA	(*sdareg & sdaget)

/* Private global vars */
volatile u32 *sclreg=NULL, *sdareg=NULL ;
u32 scldir=0, sclset=0, sdadir=0, sdaset=0, sdaget=0, i2c_ctrl_0=0 ;

/* ------------------------------------------------------------------------ */
/* Initialization routine */

int i2c_init_sw(void) {
  int ok ; u32 save1=0, save2=0, save3=0, save4=0 ;
  switch (gatos.i2c_mode) {
    case 1:
      sclreg = DAC_CNTL_PTR ; sdareg = GEN_TEST_CNTL_PTR ;
      sclset = 0x01000000 ; sdaset = 0x00000001 ; sdaget = 0x00000008 ;
      scldir = 0x08000000 ; sdadir = 0x00000020 ;
      save1 = DAC_CNTL ; save2 = GEN_TEST_CNTL ; save3 = GP_IO ;
      *sdareg |= 0x00000010 ; save4 = CRTC_H_TOTAL_DISP ;
      GP_IO &= 0x7FFFFFFF ; CRTC_H_TOTAL_DISP = save4 ;
      /*save4 = VMC_CONFIG ; VMC_CONFIG &= 0x7FFFFFFF ;*/ break ;
    case 2:
      sclreg = sdareg = GP_IO_PTR ; save1 = GP_IO ;
      sclset = 0x00000800 ; sdaset = sdaget = 0x00000010 ;
      scldir = 0x08000000 ; sdadir = 0x00100000 ; break ;
    case 3:
      sclreg = sdareg = I2C_CNTL_0_PTR ; save1 = I2C_CNTL_0 ;
      sclset = 0x00004000 ; sdaset = sdaget = 0x00008000 ;
      scldir = sdadir = 0x00000000 ; save2 = I2C_CNTL_1 ;
      I2C_CNTL_1 = 0x00400000 ; if (I2C_CNTL_1!=0x00400000) RETURN(ENODEV) ;
      i2c_ctrl_0 = sclset|sdaset ; I2C_CNTL_0 = i2c_ctrl_0|0x00040000 ; break ;
    case 4:
      sclreg = sdareg = GP_IO_PTR ; save1 = GP_IO ;
      sclset = 0x00000400 ; sdaset = sdaget = 0x00001000 ;
      scldir = 0x04000000 ; sdadir = 0x10000000 ; break ;
    default: RETURN(ENODEV) ; }
  ok = i2c_device(0xC0) + i2c_device(0xC2) +
       i2c_device(0xC4) + i2c_device(0xC6) ;
  /* Success if 1-3 tuners detected */
  if ((ok != 0) && (ok != 4)) RETURN0 ;
  /* Initialization failed, restore registers */
  switch (gatos.i2c_mode) {
    case 1: DAC_CNTL = save1 ; GEN_TEST_CNTL = save2 ;
            GP_IO = save3 ; /*VMC_CONFIG = save4 ;*/ break ;
    case 2: GP_IO = save1 ; break ;
    case 3: I2C_CNTL_0 = save1 ; I2C_CNTL_1 = save2 ; break ;
    case 4: GP_IO = save1 ; break ;
    default: RETURN(ENODEV) ; }
  RETURN(ENODEV) ; }

/* ------------------------------------------------------------------------ */
/* Public routines */

void i2c_start_sw(void) {
  if (scldir) *sclreg |= scldir ; if (sdadir) *sdareg |= sdadir ;
  i2c_setsda(1) ; i2c_setscl(1) ; i2c_setsda(0) ; i2c_setscl(0) ; }

void i2c_stop_sw(void) {
  if (sdadir) *sdareg |= sdadir ;
  i2c_setscl(0) ; i2c_setsda(0) ; i2c_setscl(1) ; i2c_setsda(1) ;
  if (scldir) *sclreg &= ~scldir ; if (sdadir) *sdareg &= ~sdadir ; }

int i2c_sendbyte_sw(u8 data) {
  int nack, i ;
  if (sdadir) *sdareg |= sdadir ;
  for ( i=7 ; i>=0 ; i-- ) {
    i2c_setscl(0) ; i2c_setsda(data&(1<<i)) ; i2c_setscl(1) ; }
  i2c_setscl(0) ; if (sdadir) *sdareg &= ~sdadir ;
  i2c_setsda(1) ; i2c_setscl(1) ;
  nack = (I2C_SW_GETSDA) ? 1 : 0 ;
  i2c_setscl(0) ; return nack ; }

u8 i2c_readbyte_sw(int last) {
  int i ; u8 data=0 ;
  if (sdadir) *sdareg &= ~sdadir ;
  for ( i=7 ; i>=0 ; i-- ) {
    i2c_setscl(1) ; if (I2C_SW_GETSDA) data |= (1<<i) ;
    I2C_SLEEP ; i2c_setscl(0) ; }
  if (sdadir) *sdareg |= sdadir ;
  i2c_setsda(last) ; i2c_setscl(1) ; i2c_setscl(0) ;
  if (sdadir) *sdareg &= ~sdadir ; return data ; }

/* ------------------------------------------------------------------------ */
/* Private routines */

static void i2c_setscl(int high) {
  if (gatos.i2c_mode == 3) {
    if (high) i2c_ctrl_0 |=  sclset ;
    else      i2c_ctrl_0 &= ~sclset ;
    I2C_CNTL_0 = i2c_ctrl_0 ; }
  else
    if (high) *sclreg |=  sclset ;
    else      *sclreg &= ~sclset ;
  I2C_SLEEP ; }

static void i2c_setsda(int high) {
  if (gatos.i2c_mode == 3) {
    if (high) i2c_ctrl_0 |=  sdaset ;
    else      i2c_ctrl_0 &= ~sdaset ;
    I2C_CNTL_0 = i2c_ctrl_0 ; }
  else
    if (high) *sdareg |=  sdaset ;
    else      *sdareg &= ~sdaset ;
  I2C_SLEEP ; }
